/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.jrobin.core.Header;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;

class HeaderTableModel
extends AbstractTableModel {
    private static final Object[] DESCRIPTIONS = new Object[]{"path", "signature", "step", "last timestamp", "datasources", "archives", "size"};
    private static final String[] COLUMN_NAMES = new String[]{"description", "value"};
    private File file;
    private Object[] values;

    HeaderTableModel() {
    }

    public int getRowCount() {
        return DESCRIPTIONS.length;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return DESCRIPTIONS[n];
        }
        if (n2 == 1) {
            if (this.values != null) {
                return this.values[n];
            }
            return "--";
        }
        return null;
    }

    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    void setFile(File file) {
        try {
            this.file = file;
            this.values = null;
            String string = this.file.getAbsolutePath();
            RrdDb rrdDb = new RrdDb(string);
            Header header = rrdDb.getHeader();
            String string2 = header.getSignature();
            String string3 = "" + header.getStep();
            String string4 = header.getLastUpdateTime() + " [" + new Date(header.getLastUpdateTime() * 1000L) + "]";
            String string5 = "" + header.getDsCount();
            String string6 = "" + header.getArcCount();
            String string7 = rrdDb.getRrdBackend().getLength() + " bytes";
            rrdDb.close();
            this.values = new Object[]{string, string2, string3, string4, string5, string6, string7};
            this.fireTableDataChanged();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (RrdException rrdException) {
            rrdException.printStackTrace();
        }
    }
}

