# Alt-Ergo

[Alt-Ergo] is an open-source automatic solver of mathematical formulas designed for program verification. It is based on [Satisfiability Modulo Theories] (SMT). Solvers of this family have made impressive advances and became very popular during the last decade. They are now used is various domains such as hardware design, software verification and formal testing. It was developed at [LRI], and is now improved and maintained at [OCamlPro], and friendly collaboration is maintained with the [Why3] development team.

You can [try Alt-Ergo] online.
Also see the [Alt-Ergo Users' Club].

## Build status
next | main
------------ | -------------
[![Build Status (next)](https://travis-ci.org/OCamlPro/alt-ergo.svg?branch=next)](https://travis-ci.org/OCamlPro/alt-ergo) | [![Build Status (main)](https://travis-ci.org/OCamlPro/alt-ergo.svg?branch=main)](https://travis-ci.org/OCamlPro/alt-ergo) 

## Website

Alt-Ergo's website: [https://alt-ergo.ocamlpro.com].

## Documentation

See our [general documentation] wich contains

* [installing informations]
* the [usage section] for information on how to use Alt-Ergo.
* A section about [input file format] supported by Alt-Ergo.
* [API] and [developers documentation].

## Download

We provide sources tarball of the [latest] release of Alt-Ergo. You can also find it on the GitHub's [releases' page].

Alt-Ergo is available in the OCaml package manager [opam] with this command:
```
opam install alt-ergo
```
## Copyright

Alt-Ergo is freely available for non-commercial uses (such as academic and exploratory trials) under the [OCamlPro non-commercial license 1.0].

For commercial use, see the [Alt-Ergo Users' Club]. Club members with adequate membership can have access to Alt-Ergo under the [Apache Software License version 2.0].
See the [license section] for more detail.

## Build

See [installing informations] section.

## Contributing

Please refer to our [contributing guidelines].

## Support

See [Alt-Ergo @ OCamlPro] or contact us at [alt-ergo@ocamlpro.com] for more details.

[Alt-Ergo]: https://alt-ergo.ocamlpro.com
[alt-ergo@ocamlpro.com]: mailto:alt-ergo@ocamlpro.com
[Alt-Ergo @ OCamlPro]: https://alt-ergo.ocamlpro.com/#services
[Alt-Ergo Users' Club]: https://alt-ergo.ocamlpro.com/#club
[Apache Software License version 2.0]: ./licenses/Apache-License-2.0.txt
[API]: https://ocamlpro.github.io/alt-ergo/API/index.html
[contributing guidelines]: https://ocamlpro.github.io/alt-ergo/Dev/contributing.html
[developers documentation]: https://ocamlpro.github.io/alt-ergo/Dev/index.html
[general documentation]: https://ocamlpro.github.io/alt-ergo/
[input file format]: https://ocamlpro.github.io/alt-ergo/Input_file_formats/index.html
[installing informations]: https://ocamlpro.github.io/alt-ergo/Install/index.html
[https://alt-ergo.ocamlpro.com]: https://alt-ergo.ocamlpro.com
[latest]: https://alt-ergo.ocamlpro.com/http/alt-ergo-2.3.2/alt-ergo-2.3.2.tar.gz
[license section]: https://ocamlpro.github.io/alt-ergo/About/license.html
[LRI]: https://www.lri.fr
[OCamlPro]: https://www.ocamlpro.com
[OCamlPro non-commercial license 1.0]: ./licenses/OCamlPro-Non-Commercial-License.txt
[opam]: https://opam.ocaml.org
[releases' page]: https://github.com/OCamlPro/alt-ergo/releases/
[Satisfiability Modulo Theories]: https://en.wikipedia.org/wiki/Satisfiability_modulo_theories
[try Alt-Ergo]: https://alt-ergo.ocamlpro.com/try.html
[usage section]: https://ocamlpro.github.io/alt-ergo/Usage/index.html
[Why3]: http://why3.lri.fr/
