// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workstations/v1/workstations.proto

#include "google/cloud/workstations/v1/internal/workstations_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/workstations/v1/workstations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace workstations_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WorkstationsLogging::WorkstationsLogging(
    std::shared_ptr<WorkstationsStub> child, TracingOptions tracing_options,
    std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::workstations::v1::WorkstationCluster>
WorkstationsLogging::GetWorkstationCluster(
    grpc::ClientContext& context,
    google::cloud::workstations::v1::GetWorkstationClusterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::workstations::v1::GetWorkstationClusterRequest const&
              request) {
        return child_->GetWorkstationCluster(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workstations::v1::ListWorkstationClustersResponse>
WorkstationsLogging::ListWorkstationClusters(
    grpc::ClientContext& context,
    google::cloud::workstations::v1::ListWorkstationClustersRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::workstations::v1::ListWorkstationClustersRequest const&
              request) {
        return child_->ListWorkstationClusters(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncCreateWorkstationCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::CreateWorkstationClusterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::workstations::v1::
                 CreateWorkstationClusterRequest const& request) {
        return child_->AsyncCreateWorkstationCluster(cq, std::move(context),
                                                     options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncUpdateWorkstationCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::UpdateWorkstationClusterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::workstations::v1::
                 UpdateWorkstationClusterRequest const& request) {
        return child_->AsyncUpdateWorkstationCluster(cq, std::move(context),
                                                     options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncDeleteWorkstationCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::DeleteWorkstationClusterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::workstations::v1::
                 DeleteWorkstationClusterRequest const& request) {
        return child_->AsyncDeleteWorkstationCluster(cq, std::move(context),
                                                     options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsLogging::GetWorkstationConfig(
    grpc::ClientContext& context,
    google::cloud::workstations::v1::GetWorkstationConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::workstations::v1::GetWorkstationConfigRequest const&
                 request) {
        return child_->GetWorkstationConfig(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workstations::v1::ListWorkstationConfigsResponse>
WorkstationsLogging::ListWorkstationConfigs(
    grpc::ClientContext& context,
    google::cloud::workstations::v1::ListWorkstationConfigsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::workstations::v1::ListWorkstationConfigsRequest const&
              request) {
        return child_->ListWorkstationConfigs(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workstations::v1::ListUsableWorkstationConfigsResponse>
WorkstationsLogging::ListUsableWorkstationConfigs(
    grpc::ClientContext& context,
    google::cloud::workstations::v1::ListUsableWorkstationConfigsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::workstations::v1::
                 ListUsableWorkstationConfigsRequest const& request) {
        return child_->ListUsableWorkstationConfigs(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncCreateWorkstationConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
              request) {
        return child_->AsyncCreateWorkstationConfig(cq, std::move(context),
                                                    options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncUpdateWorkstationConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
              request) {
        return child_->AsyncUpdateWorkstationConfig(cq, std::move(context),
                                                    options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncDeleteWorkstationConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
              request) {
        return child_->AsyncDeleteWorkstationConfig(cq, std::move(context),
                                                    options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workstations::v1::Workstation>
WorkstationsLogging::GetWorkstation(
    grpc::ClientContext& context,
    google::cloud::workstations::v1::GetWorkstationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::workstations::v1::GetWorkstationRequest const&
                 request) { return child_->GetWorkstation(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workstations::v1::ListWorkstationsResponse>
WorkstationsLogging::ListWorkstations(
    grpc::ClientContext& context,
    google::cloud::workstations::v1::ListWorkstationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::workstations::v1::ListWorkstationsRequest const&
                 request) {
        return child_->ListWorkstations(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workstations::v1::ListUsableWorkstationsResponse>
WorkstationsLogging::ListUsableWorkstations(
    grpc::ClientContext& context,
    google::cloud::workstations::v1::ListUsableWorkstationsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::workstations::v1::ListUsableWorkstationsRequest const&
              request) {
        return child_->ListUsableWorkstations(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncCreateWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::CreateWorkstationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::workstations::v1::CreateWorkstationRequest const&
                 request) {
        return child_->AsyncCreateWorkstation(cq, std::move(context), options,
                                              request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncUpdateWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::UpdateWorkstationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::workstations::v1::UpdateWorkstationRequest const&
                 request) {
        return child_->AsyncUpdateWorkstation(cq, std::move(context), options,
                                              request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncDeleteWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::DeleteWorkstationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::workstations::v1::DeleteWorkstationRequest const&
                 request) {
        return child_->AsyncDeleteWorkstation(cq, std::move(context), options,
                                              request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncStartWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::StartWorkstationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::workstations::v1::StartWorkstationRequest const&
                 request) {
        return child_->AsyncStartWorkstation(cq, std::move(context), options,
                                             request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncStopWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::workstations::v1::StopWorkstationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::workstations::v1::StopWorkstationRequest const&
                 request) {
        return child_->AsyncStopWorkstation(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workstations::v1::GenerateAccessTokenResponse>
WorkstationsLogging::GenerateAccessToken(
    grpc::ClientContext& context,
    google::cloud::workstations::v1::GenerateAccessTokenRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::workstations::v1::GenerateAccessTokenRequest const&
                 request) {
        return child_->GenerateAccessToken(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkstationsLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context), options,
                                         request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<Status> WorkstationsLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workstations_v1_internal
}  // namespace cloud
}  // namespace google
