// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/websecurityscanner/v1/web_security_scanner.proto

#include "google/cloud/websecurityscanner/v1/internal/web_security_scanner_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/websecurityscanner/v1/web_security_scanner.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace websecurityscanner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WebSecurityScannerLogging::WebSecurityScannerLogging(
    std::shared_ptr<WebSecurityScannerStub> child,
    TracingOptions tracing_options, std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerLogging::CreateScanConfig(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::CreateScanConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::websecurityscanner::v1::CreateScanConfigRequest const&
              request) { return child_->CreateScanConfig(context, request); },
      context, request, __func__, tracing_options_);
}

Status WebSecurityScannerLogging::DeleteScanConfig(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::DeleteScanConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::websecurityscanner::v1::DeleteScanConfigRequest const&
              request) { return child_->DeleteScanConfig(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerLogging::GetScanConfig(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::GetScanConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::GetScanConfigRequest const&
                 request) { return child_->GetScanConfig(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ListScanConfigsResponse>
WebSecurityScannerLogging::ListScanConfigs(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::ListScanConfigsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::websecurityscanner::v1::ListScanConfigsRequest const&
              request) { return child_->ListScanConfigs(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerLogging::UpdateScanConfig(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::UpdateScanConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::websecurityscanner::v1::UpdateScanConfigRequest const&
              request) { return child_->UpdateScanConfig(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerLogging::StartScanRun(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::StartScanRunRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::StartScanRunRequest const&
                 request) { return child_->StartScanRun(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerLogging::GetScanRun(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::GetScanRunRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::GetScanRunRequest const&
                 request) { return child_->GetScanRun(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ListScanRunsResponse>
WebSecurityScannerLogging::ListScanRuns(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::ListScanRunsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::ListScanRunsRequest const&
                 request) { return child_->ListScanRuns(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerLogging::StopScanRun(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::StopScanRunRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::StopScanRunRequest const&
                 request) { return child_->StopScanRun(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ListCrawledUrlsResponse>
WebSecurityScannerLogging::ListCrawledUrls(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest const&
              request) { return child_->ListCrawledUrls(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::Finding>
WebSecurityScannerLogging::GetFinding(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::GetFindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::GetFindingRequest const&
                 request) { return child_->GetFinding(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ListFindingsResponse>
WebSecurityScannerLogging::ListFindings(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::ListFindingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::ListFindingsRequest const&
                 request) { return child_->ListFindings(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::websecurityscanner::v1::ListFindingTypeStatsResponse>
WebSecurityScannerLogging::ListFindingTypeStats(
    grpc::ClientContext& context,
    google::cloud::websecurityscanner::v1::ListFindingTypeStatsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::
                 ListFindingTypeStatsRequest const& request) {
        return child_->ListFindingTypeStats(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace websecurityscanner_v1_internal
}  // namespace cloud
}  // namespace google
