// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/telcoautomation/v1/telcoautomation.proto

#include "google/cloud/telcoautomation/v1/internal/telco_automation_auth_decorator.h"
#include <google/cloud/telcoautomation/v1/telcoautomation.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace telcoautomation_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TelcoAutomationAuth::TelcoAutomationAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<TelcoAutomationStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::telcoautomation::v1::ListOrchestrationClustersResponse>
TelcoAutomationAuth::ListOrchestrationClusters(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ListOrchestrationClustersRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListOrchestrationClusters(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>
TelcoAutomationAuth::GetOrchestrationCluster(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::GetOrchestrationClusterRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetOrchestrationCluster(context, request);
}

future<StatusOr<google::longrunning::Operation>>
TelcoAutomationAuth::AsyncCreateOrchestrationCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::telcoautomation::v1::CreateOrchestrationClusterRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateOrchestrationCluster(cq, *std::move(context),
                                                      options, request);
      });
}

future<StatusOr<google::longrunning::Operation>>
TelcoAutomationAuth::AsyncDeleteOrchestrationCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::telcoautomation::v1::DeleteOrchestrationClusterRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteOrchestrationCluster(cq, *std::move(context),
                                                      options, request);
      });
}

StatusOr<google::cloud::telcoautomation::v1::ListEdgeSlmsResponse>
TelcoAutomationAuth::ListEdgeSlms(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ListEdgeSlmsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListEdgeSlms(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::EdgeSlm>
TelcoAutomationAuth::GetEdgeSlm(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::GetEdgeSlmRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetEdgeSlm(context, request);
}

future<StatusOr<google::longrunning::Operation>>
TelcoAutomationAuth::AsyncCreateEdgeSlm(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::telcoautomation::v1::CreateEdgeSlmRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateEdgeSlm(cq, *std::move(context), options,
                                         request);
      });
}

future<StatusOr<google::longrunning::Operation>>
TelcoAutomationAuth::AsyncDeleteEdgeSlm(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::telcoautomation::v1::DeleteEdgeSlmRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteEdgeSlm(cq, *std::move(context), options,
                                         request);
      });
}

StatusOr<google::cloud::telcoautomation::v1::Blueprint>
TelcoAutomationAuth::CreateBlueprint(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::CreateBlueprintRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateBlueprint(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Blueprint>
TelcoAutomationAuth::UpdateBlueprint(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::UpdateBlueprintRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateBlueprint(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Blueprint>
TelcoAutomationAuth::GetBlueprint(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::GetBlueprintRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetBlueprint(context, request);
}

Status TelcoAutomationAuth::DeleteBlueprint(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::DeleteBlueprintRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteBlueprint(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::ListBlueprintsResponse>
TelcoAutomationAuth::ListBlueprints(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ListBlueprintsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListBlueprints(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Blueprint>
TelcoAutomationAuth::ApproveBlueprint(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ApproveBlueprintRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ApproveBlueprint(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Blueprint>
TelcoAutomationAuth::ProposeBlueprint(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ProposeBlueprintRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ProposeBlueprint(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Blueprint>
TelcoAutomationAuth::RejectBlueprint(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::RejectBlueprintRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RejectBlueprint(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::ListBlueprintRevisionsResponse>
TelcoAutomationAuth::ListBlueprintRevisions(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ListBlueprintRevisionsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListBlueprintRevisions(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::SearchBlueprintRevisionsResponse>
TelcoAutomationAuth::SearchBlueprintRevisions(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::SearchBlueprintRevisionsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchBlueprintRevisions(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::SearchDeploymentRevisionsResponse>
TelcoAutomationAuth::SearchDeploymentRevisions(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::SearchDeploymentRevisionsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchDeploymentRevisions(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::DiscardBlueprintChangesResponse>
TelcoAutomationAuth::DiscardBlueprintChanges(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::DiscardBlueprintChangesRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DiscardBlueprintChanges(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::ListPublicBlueprintsResponse>
TelcoAutomationAuth::ListPublicBlueprints(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ListPublicBlueprintsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListPublicBlueprints(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::PublicBlueprint>
TelcoAutomationAuth::GetPublicBlueprint(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::GetPublicBlueprintRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetPublicBlueprint(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Deployment>
TelcoAutomationAuth::CreateDeployment(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::CreateDeploymentRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateDeployment(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Deployment>
TelcoAutomationAuth::UpdateDeployment(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::UpdateDeploymentRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateDeployment(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Deployment>
TelcoAutomationAuth::GetDeployment(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::GetDeploymentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetDeployment(context, request);
}

Status TelcoAutomationAuth::RemoveDeployment(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::RemoveDeploymentRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RemoveDeployment(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::ListDeploymentsResponse>
TelcoAutomationAuth::ListDeployments(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ListDeploymentsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListDeployments(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::ListDeploymentRevisionsResponse>
TelcoAutomationAuth::ListDeploymentRevisions(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ListDeploymentRevisionsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListDeploymentRevisions(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::DiscardDeploymentChangesResponse>
TelcoAutomationAuth::DiscardDeploymentChanges(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::DiscardDeploymentChangesRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DiscardDeploymentChanges(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Deployment>
TelcoAutomationAuth::ApplyDeployment(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ApplyDeploymentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ApplyDeployment(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::ComputeDeploymentStatusResponse>
TelcoAutomationAuth::ComputeDeploymentStatus(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ComputeDeploymentStatusRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ComputeDeploymentStatus(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::Deployment>
TelcoAutomationAuth::RollbackDeployment(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::RollbackDeploymentRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RollbackDeployment(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
TelcoAutomationAuth::GetHydratedDeployment(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::GetHydratedDeploymentRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetHydratedDeployment(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::ListHydratedDeploymentsResponse>
TelcoAutomationAuth::ListHydratedDeployments(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ListHydratedDeploymentsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListHydratedDeployments(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
TelcoAutomationAuth::UpdateHydratedDeployment(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::UpdateHydratedDeploymentRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateHydratedDeployment(context, request);
}

StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
TelcoAutomationAuth::ApplyHydratedDeployment(
    grpc::ClientContext& context,
    google::cloud::telcoautomation::v1::ApplyHydratedDeploymentRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ApplyHydratedDeployment(context, request);
}

future<StatusOr<google::longrunning::Operation>>
TelcoAutomationAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context), options,
                                        request);
      });
}

future<Status> TelcoAutomationAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context), options,
                                           request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace telcoautomation_v1_internal
}  // namespace cloud
}  // namespace google
