// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/sql/v1/cloud_sql_databases.proto

#include "google/cloud/sql/v1/internal/sql_databases_rest_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <memory>

namespace google {
namespace cloud {
namespace sql_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SqlDatabasesServiceRestLogging::SqlDatabasesServiceRestLogging(
    std::shared_ptr<SqlDatabasesServiceRestStub> child,
    TracingOptions tracing_options, std::set<std::string> components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      components_(std::move(components)) {}

StatusOr<google::cloud::sql::v1::Operation>
SqlDatabasesServiceRestLogging::Delete(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::sql::v1::SqlDatabasesDeleteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::sql::v1::SqlDatabasesDeleteRequest const& request) {
        return child_->Delete(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::sql::v1::Database> SqlDatabasesServiceRestLogging::Get(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::sql::v1::SqlDatabasesGetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::sql::v1::SqlDatabasesGetRequest const& request) {
        return child_->Get(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::sql::v1::Operation>
SqlDatabasesServiceRestLogging::Insert(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::sql::v1::SqlDatabasesInsertRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::sql::v1::SqlDatabasesInsertRequest const& request) {
        return child_->Insert(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::sql::v1::DatabasesListResponse>
SqlDatabasesServiceRestLogging::List(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::sql::v1::SqlDatabasesListRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::sql::v1::SqlDatabasesListRequest const& request) {
        return child_->List(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::sql::v1::Operation>
SqlDatabasesServiceRestLogging::Patch(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::sql::v1::SqlDatabasesUpdateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::sql::v1::SqlDatabasesUpdateRequest const& request) {
        return child_->Patch(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::sql::v1::Operation>
SqlDatabasesServiceRestLogging::Update(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::sql::v1::SqlDatabasesUpdateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::sql::v1::SqlDatabasesUpdateRequest const& request) {
        return child_->Update(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace sql_v1_internal
}  // namespace cloud
}  // namespace google
