// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/registration_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_V1_REGISTRATION_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_V1_REGISTRATION_CONNECTION_H

#include "google/cloud/servicedirectory/v1/internal/registration_retry_traits.h"
#include "google/cloud/servicedirectory/v1/registration_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/servicedirectory/v1/registration_service.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `RegistrationServiceConnection`.
class RegistrationServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<RegistrationServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `RegistrationServiceConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 * - [`kUnknown`](@ref google::cloud::StatusCode)
 */
class RegistrationServiceLimitedErrorCountRetryPolicy
    : public RegistrationServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit RegistrationServiceLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  RegistrationServiceLimitedErrorCountRetryPolicy(
      RegistrationServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : RegistrationServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  RegistrationServiceLimitedErrorCountRetryPolicy(
      RegistrationServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : RegistrationServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<RegistrationServiceRetryPolicy> clone() const override {
    return std::make_unique<RegistrationServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = RegistrationServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      servicedirectory_v1_internal::RegistrationServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `RegistrationServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 * - [`kUnknown`](@ref google::cloud::StatusCode)
 */
class RegistrationServiceLimitedTimeRetryPolicy
    : public RegistrationServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit RegistrationServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  RegistrationServiceLimitedTimeRetryPolicy(
      RegistrationServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : RegistrationServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  RegistrationServiceLimitedTimeRetryPolicy(
      RegistrationServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : RegistrationServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<RegistrationServiceRetryPolicy> clone() const override {
    return std::make_unique<RegistrationServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = RegistrationServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      servicedirectory_v1_internal::RegistrationServiceRetryTraits>
      impl_;
};

/**
 * The `RegistrationServiceConnection` object for `RegistrationServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `RegistrationServiceClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `RegistrationServiceClient`.
 *
 * To create a concrete instance, see `MakeRegistrationServiceConnection()`.
 *
 * For mocking, see
 * `servicedirectory_v1_mocks::MockRegistrationServiceConnection`.
 */
class RegistrationServiceConnection {
 public:
  virtual ~RegistrationServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::servicedirectory::v1::Namespace>
  CreateNamespace(
      google::cloud::servicedirectory::v1::CreateNamespaceRequest const&
          request);

  virtual StreamRange<google::cloud::servicedirectory::v1::Namespace>
  ListNamespaces(
      google::cloud::servicedirectory::v1::ListNamespacesRequest request);

  virtual StatusOr<google::cloud::servicedirectory::v1::Namespace> GetNamespace(
      google::cloud::servicedirectory::v1::GetNamespaceRequest const& request);

  virtual StatusOr<google::cloud::servicedirectory::v1::Namespace>
  UpdateNamespace(
      google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&
          request);

  virtual Status DeleteNamespace(
      google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&
          request);

  virtual StatusOr<google::cloud::servicedirectory::v1::Service> CreateService(
      google::cloud::servicedirectory::v1::CreateServiceRequest const& request);

  virtual StreamRange<google::cloud::servicedirectory::v1::Service>
  ListServices(
      google::cloud::servicedirectory::v1::ListServicesRequest request);

  virtual StatusOr<google::cloud::servicedirectory::v1::Service> GetService(
      google::cloud::servicedirectory::v1::GetServiceRequest const& request);

  virtual StatusOr<google::cloud::servicedirectory::v1::Service> UpdateService(
      google::cloud::servicedirectory::v1::UpdateServiceRequest const& request);

  virtual Status DeleteService(
      google::cloud::servicedirectory::v1::DeleteServiceRequest const& request);

  virtual StatusOr<google::cloud::servicedirectory::v1::Endpoint>
  CreateEndpoint(
      google::cloud::servicedirectory::v1::CreateEndpointRequest const&
          request);

  virtual StreamRange<google::cloud::servicedirectory::v1::Endpoint>
  ListEndpoints(
      google::cloud::servicedirectory::v1::ListEndpointsRequest request);

  virtual StatusOr<google::cloud::servicedirectory::v1::Endpoint> GetEndpoint(
      google::cloud::servicedirectory::v1::GetEndpointRequest const& request);

  virtual StatusOr<google::cloud::servicedirectory::v1::Endpoint>
  UpdateEndpoint(
      google::cloud::servicedirectory::v1::UpdateEndpointRequest const&
          request);

  virtual Status DeleteEndpoint(
      google::cloud::servicedirectory::v1::DeleteEndpointRequest const&
          request);

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);
};

/**
 * A factory function to construct an object of type
 * `RegistrationServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * RegistrationServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `RegistrationServiceConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::servicedirectory_v1::RegistrationServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `RegistrationServiceConnection`
 * created by this function.
 */
std::shared_ptr<RegistrationServiceConnection>
MakeRegistrationServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_V1_REGISTRATION_CONNECTION_H
