// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURESOURCEMANAGER_V1_INTERNAL_SECURE_SOURCE_MANAGER_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURESOURCEMANAGER_V1_INTERNAL_SECURE_SOURCE_MANAGER_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/securesourcemanager/v1/secure_source_manager.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace securesourcemanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SecureSourceManagerStub {
 public:
  virtual ~SecureSourceManagerStub() = 0;

  virtual StatusOr<
      google::cloud::securesourcemanager::v1::ListInstancesResponse>
  ListInstances(
      grpc::ClientContext& context,
      google::cloud::securesourcemanager::v1::ListInstancesRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::securesourcemanager::v1::Instance>
  GetInstance(grpc::ClientContext& context,
              google::cloud::securesourcemanager::v1::GetInstanceRequest const&
                  request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateInstance(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::securesourcemanager::v1::CreateInstanceRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteInstance(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::securesourcemanager::v1::DeleteInstanceRequest const&
          request) = 0;

  virtual StatusOr<
      google::cloud::securesourcemanager::v1::ListRepositoriesResponse>
  ListRepositories(
      grpc::ClientContext& context,
      google::cloud::securesourcemanager::v1::ListRepositoriesRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::securesourcemanager::v1::Repository>
  GetRepository(
      grpc::ClientContext& context,
      google::cloud::securesourcemanager::v1::GetRepositoryRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateRepository(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::securesourcemanager::v1::CreateRepositoryRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteRepository(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::securesourcemanager::v1::DeleteRepositoryRequest const&
          request) = 0;

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicyRepo(
      grpc::ClientContext& context,
      google::iam::v1::GetIamPolicyRequest const& request) = 0;

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicyRepo(
      grpc::ClientContext& context,
      google::iam::v1::SetIamPolicyRequest const& request) = 0;

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissionsRepo(
      grpc::ClientContext& context,
      google::iam::v1::TestIamPermissionsRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultSecureSourceManagerStub : public SecureSourceManagerStub {
 public:
  DefaultSecureSourceManagerStub(
      std::unique_ptr<google::cloud::securesourcemanager::v1::
                          SecureSourceManager::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  StatusOr<google::cloud::securesourcemanager::v1::ListInstancesResponse>
  ListInstances(
      grpc::ClientContext& context,
      google::cloud::securesourcemanager::v1::ListInstancesRequest const&
          request) override;

  StatusOr<google::cloud::securesourcemanager::v1::Instance> GetInstance(
      grpc::ClientContext& context,
      google::cloud::securesourcemanager::v1::GetInstanceRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateInstance(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::securesourcemanager::v1::CreateInstanceRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteInstance(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::securesourcemanager::v1::DeleteInstanceRequest const&
          request) override;

  StatusOr<google::cloud::securesourcemanager::v1::ListRepositoriesResponse>
  ListRepositories(
      grpc::ClientContext& context,
      google::cloud::securesourcemanager::v1::ListRepositoriesRequest const&
          request) override;

  StatusOr<google::cloud::securesourcemanager::v1::Repository> GetRepository(
      grpc::ClientContext& context,
      google::cloud::securesourcemanager::v1::GetRepositoryRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateRepository(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::securesourcemanager::v1::CreateRepositoryRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteRepository(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::securesourcemanager::v1::DeleteRepositoryRequest const&
          request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicyRepo(
      grpc::ClientContext& context,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicyRepo(
      grpc::ClientContext& context,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissionsRepo(
      grpc::ClientContext& context,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::securesourcemanager::v1::SecureSourceManager::
                      StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securesourcemanager_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURESOURCEMANAGER_V1_INTERNAL_SECURE_SOURCE_MANAGER_STUB_H
