// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/schema.proto

#include "google/cloud/pubsub/internal/schema_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/pubsub/v1/schema.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SchemaServiceStub::~SchemaServiceStub() = default;

StatusOr<google::pubsub::v1::Schema> DefaultSchemaServiceStub::CreateSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::CreateSchemaRequest const& request) {
  google::pubsub::v1::Schema response;
  auto status = grpc_stub_->CreateSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::pubsub::v1::Schema> DefaultSchemaServiceStub::GetSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::GetSchemaRequest const& request) {
  google::pubsub::v1::Schema response;
  auto status = grpc_stub_->GetSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::pubsub::v1::ListSchemasResponse>
DefaultSchemaServiceStub::ListSchemas(
    grpc::ClientContext& context,
    google::pubsub::v1::ListSchemasRequest const& request) {
  google::pubsub::v1::ListSchemasResponse response;
  auto status = grpc_stub_->ListSchemas(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::pubsub::v1::ListSchemaRevisionsResponse>
DefaultSchemaServiceStub::ListSchemaRevisions(
    grpc::ClientContext& context,
    google::pubsub::v1::ListSchemaRevisionsRequest const& request) {
  google::pubsub::v1::ListSchemaRevisionsResponse response;
  auto status = grpc_stub_->ListSchemaRevisions(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::pubsub::v1::Schema> DefaultSchemaServiceStub::CommitSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::CommitSchemaRequest const& request) {
  google::pubsub::v1::Schema response;
  auto status = grpc_stub_->CommitSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::pubsub::v1::Schema> DefaultSchemaServiceStub::RollbackSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::RollbackSchemaRequest const& request) {
  google::pubsub::v1::Schema response;
  auto status = grpc_stub_->RollbackSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::pubsub::v1::Schema>
DefaultSchemaServiceStub::DeleteSchemaRevision(
    grpc::ClientContext& context,
    google::pubsub::v1::DeleteSchemaRevisionRequest const& request) {
  google::pubsub::v1::Schema response;
  auto status = grpc_stub_->DeleteSchemaRevision(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultSchemaServiceStub::DeleteSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::DeleteSchemaRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::pubsub::v1::ValidateSchemaResponse>
DefaultSchemaServiceStub::ValidateSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::ValidateSchemaRequest const& request) {
  google::pubsub::v1::ValidateSchemaResponse response;
  auto status = grpc_stub_->ValidateSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::pubsub::v1::ValidateMessageResponse>
DefaultSchemaServiceStub::ValidateMessage(
    grpc::ClientContext& context,
    google::pubsub::v1::ValidateMessageRequest const& request) {
  google::pubsub::v1::ValidateMessageResponse response;
  auto status = grpc_stub_->ValidateMessage(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google
