// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#include "google/cloud/pubsub/admin/subscription_admin_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace pubsub_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SubscriptionAdminConnectionIdempotencyPolicy::
    ~SubscriptionAdminConnectionIdempotencyPolicy() = default;

std::unique_ptr<SubscriptionAdminConnectionIdempotencyPolicy>
SubscriptionAdminConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SubscriptionAdminConnectionIdempotencyPolicy>(*this);
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::CreateSubscription(
    google::pubsub::v1::Subscription const&) {
  return Idempotency::kIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::GetSubscription(
    google::pubsub::v1::GetSubscriptionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::UpdateSubscription(
    google::pubsub::v1::UpdateSubscriptionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::ListSubscriptions(
    google::pubsub::v1::ListSubscriptionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::DeleteSubscription(
    google::pubsub::v1::DeleteSubscriptionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::ModifyPushConfig(
    google::pubsub::v1::ModifyPushConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::GetSnapshot(
    google::pubsub::v1::GetSnapshotRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::ListSnapshots(
    google::pubsub::v1::ListSnapshotsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::CreateSnapshot(
    google::pubsub::v1::CreateSnapshotRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::UpdateSnapshot(
    google::pubsub::v1::UpdateSnapshotRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::DeleteSnapshot(
    google::pubsub::v1::DeleteSnapshotRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SubscriptionAdminConnectionIdempotencyPolicy::Seek(
    google::pubsub::v1::SeekRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<SubscriptionAdminConnectionIdempotencyPolicy>
MakeDefaultSubscriptionAdminConnectionIdempotencyPolicy() {
  return std::make_unique<SubscriptionAdminConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_admin
}  // namespace cloud
}  // namespace google
