// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

#include "google/cloud/orgpolicy/v2/internal/org_policy_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace orgpolicy_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

OrgPolicyTracingStub::OrgPolicyTracingStub(std::shared_ptr<OrgPolicyStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::orgpolicy::v2::ListConstraintsResponse>
OrgPolicyTracingStub::ListConstraints(
    grpc::ClientContext& context,
    google::cloud::orgpolicy::v2::ListConstraintsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.orgpolicy.v2.OrgPolicy",
                                     "ListConstraints");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListConstraints(context, request));
}

StatusOr<google::cloud::orgpolicy::v2::ListPoliciesResponse>
OrgPolicyTracingStub::ListPolicies(
    grpc::ClientContext& context,
    google::cloud::orgpolicy::v2::ListPoliciesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.orgpolicy.v2.OrgPolicy",
                                     "ListPolicies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListPolicies(context, request));
}

StatusOr<google::cloud::orgpolicy::v2::Policy> OrgPolicyTracingStub::GetPolicy(
    grpc::ClientContext& context,
    google::cloud::orgpolicy::v2::GetPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.orgpolicy.v2.OrgPolicy",
                                     "GetPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetPolicy(context, request));
}

StatusOr<google::cloud::orgpolicy::v2::Policy>
OrgPolicyTracingStub::GetEffectivePolicy(
    grpc::ClientContext& context,
    google::cloud::orgpolicy::v2::GetEffectivePolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.orgpolicy.v2.OrgPolicy",
                                     "GetEffectivePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEffectivePolicy(context, request));
}

StatusOr<google::cloud::orgpolicy::v2::Policy>
OrgPolicyTracingStub::CreatePolicy(
    grpc::ClientContext& context,
    google::cloud::orgpolicy::v2::CreatePolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.orgpolicy.v2.OrgPolicy",
                                     "CreatePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreatePolicy(context, request));
}

StatusOr<google::cloud::orgpolicy::v2::Policy>
OrgPolicyTracingStub::UpdatePolicy(
    grpc::ClientContext& context,
    google::cloud::orgpolicy::v2::UpdatePolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.orgpolicy.v2.OrgPolicy",
                                     "UpdatePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdatePolicy(context, request));
}

Status OrgPolicyTracingStub::DeletePolicy(
    grpc::ClientContext& context,
    google::cloud::orgpolicy::v2::DeletePolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.orgpolicy.v2.OrgPolicy",
                                     "DeletePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeletePolicy(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<OrgPolicyStub> MakeOrgPolicyTracingStub(
    std::shared_ptr<OrgPolicyStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<OrgPolicyTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace orgpolicy_v2_internal
}  // namespace cloud
}  // namespace google
