// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v2/service.proto

#include "google/cloud/notebooks/v2/internal/notebook_option_defaults.h"
#include "google/cloud/notebooks/v2/notebook_connection.h"
#include "google/cloud/notebooks/v2/notebook_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace notebooks_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options NotebookServiceDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_NOTEBOOK_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_NOTEBOOK_SERVICE_AUTHORITY",
      "notebooks.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<notebooks_v2::NotebookServiceRetryPolicyOption>()) {
    options.set<notebooks_v2::NotebookServiceRetryPolicyOption>(
        notebooks_v2::NotebookServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<notebooks_v2::NotebookServiceBackoffPolicyOption>()) {
    options.set<notebooks_v2::NotebookServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<notebooks_v2::NotebookServicePollingPolicyOption>()) {
    options.set<notebooks_v2::NotebookServicePollingPolicyOption>(
        GenericPollingPolicy<
            notebooks_v2::NotebookServiceRetryPolicyOption::Type,
            notebooks_v2::NotebookServiceBackoffPolicyOption::Type>(
            options.get<notebooks_v2::NotebookServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          notebooks_v2::NotebookServiceConnectionIdempotencyPolicyOption>()) {
    options.set<notebooks_v2::NotebookServiceConnectionIdempotencyPolicyOption>(
        notebooks_v2::MakeDefaultNotebookServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v2_internal
}  // namespace cloud
}  // namespace google
