// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#include "google/cloud/networkservices/v1/internal/network_services_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/networkservices/v1/network_services.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace networkservices_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NetworkServicesLogging::NetworkServicesLogging(
    std::shared_ptr<NetworkServicesStub> child, TracingOptions tracing_options,
    std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::networkservices::v1::ListEndpointPoliciesResponse>
NetworkServicesLogging::ListEndpointPolicies(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::ListEndpointPoliciesRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::networkservices::v1::ListEndpointPoliciesRequest const&
              request) {
        return child_->ListEndpointPolicies(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesLogging::GetEndpointPolicy(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::GetEndpointPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetEndpointPolicyRequest const&
                 request) {
        return child_->GetEndpointPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncCreateEndpointPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
              request) {
        return child_->AsyncCreateEndpointPolicy(cq, std::move(context),
                                                 options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncUpdateEndpointPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
              request) {
        return child_->AsyncUpdateEndpointPolicy(cq, std::move(context),
                                                 options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncDeleteEndpointPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
              request) {
        return child_->AsyncDeleteEndpointPolicy(cq, std::move(context),
                                                 options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::ListGatewaysResponse>
NetworkServicesLogging::ListGateways(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::ListGatewaysRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::ListGatewaysRequest const&
                 request) { return child_->ListGateways(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::Gateway>
NetworkServicesLogging::GetGateway(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::GetGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetGatewayRequest const&
                 request) { return child_->GetGateway(context, request); },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncCreateGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::CreateGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::CreateGatewayRequest const&
                 request) {
        return child_->AsyncCreateGateway(cq, std::move(context), options,
                                          request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncUpdateGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::UpdateGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::UpdateGatewayRequest const&
                 request) {
        return child_->AsyncUpdateGateway(cq, std::move(context), options,
                                          request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncDeleteGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::DeleteGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::DeleteGatewayRequest const&
                 request) {
        return child_->AsyncDeleteGateway(cq, std::move(context), options,
                                          request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::ListGrpcRoutesResponse>
NetworkServicesLogging::ListGrpcRoutes(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::ListGrpcRoutesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::ListGrpcRoutesRequest const&
                 request) { return child_->ListGrpcRoutes(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesLogging::GetGrpcRoute(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::GetGrpcRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetGrpcRouteRequest const&
                 request) { return child_->GetGrpcRoute(context, request); },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncCreateGrpcRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::CreateGrpcRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::CreateGrpcRouteRequest const&
                 request) {
        return child_->AsyncCreateGrpcRoute(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncUpdateGrpcRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::UpdateGrpcRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::UpdateGrpcRouteRequest const&
                 request) {
        return child_->AsyncUpdateGrpcRoute(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncDeleteGrpcRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::DeleteGrpcRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::DeleteGrpcRouteRequest const&
                 request) {
        return child_->AsyncDeleteGrpcRoute(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::ListHttpRoutesResponse>
NetworkServicesLogging::ListHttpRoutes(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::ListHttpRoutesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::ListHttpRoutesRequest const&
                 request) { return child_->ListHttpRoutes(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesLogging::GetHttpRoute(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::GetHttpRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetHttpRouteRequest const&
                 request) { return child_->GetHttpRoute(context, request); },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncCreateHttpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::CreateHttpRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::CreateHttpRouteRequest const&
                 request) {
        return child_->AsyncCreateHttpRoute(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncUpdateHttpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::UpdateHttpRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::UpdateHttpRouteRequest const&
                 request) {
        return child_->AsyncUpdateHttpRoute(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncDeleteHttpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::DeleteHttpRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::DeleteHttpRouteRequest const&
                 request) {
        return child_->AsyncDeleteHttpRoute(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::ListTcpRoutesResponse>
NetworkServicesLogging::ListTcpRoutes(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::ListTcpRoutesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::ListTcpRoutesRequest const&
                 request) { return child_->ListTcpRoutes(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesLogging::GetTcpRoute(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::GetTcpRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetTcpRouteRequest const&
                 request) { return child_->GetTcpRoute(context, request); },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncCreateTcpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::CreateTcpRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::CreateTcpRouteRequest const&
                 request) {
        return child_->AsyncCreateTcpRoute(cq, std::move(context), options,
                                           request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncUpdateTcpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::UpdateTcpRouteRequest const&
                 request) {
        return child_->AsyncUpdateTcpRoute(cq, std::move(context), options,
                                           request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncDeleteTcpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::DeleteTcpRouteRequest const&
                 request) {
        return child_->AsyncDeleteTcpRoute(cq, std::move(context), options,
                                           request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::ListTlsRoutesResponse>
NetworkServicesLogging::ListTlsRoutes(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::ListTlsRoutesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::ListTlsRoutesRequest const&
                 request) { return child_->ListTlsRoutes(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesLogging::GetTlsRoute(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::GetTlsRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetTlsRouteRequest const&
                 request) { return child_->GetTlsRoute(context, request); },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncCreateTlsRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::CreateTlsRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::CreateTlsRouteRequest const&
                 request) {
        return child_->AsyncCreateTlsRoute(cq, std::move(context), options,
                                           request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncUpdateTlsRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::UpdateTlsRouteRequest const&
                 request) {
        return child_->AsyncUpdateTlsRoute(cq, std::move(context), options,
                                           request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncDeleteTlsRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::DeleteTlsRouteRequest const&
                 request) {
        return child_->AsyncDeleteTlsRoute(cq, std::move(context), options,
                                           request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::ListServiceBindingsResponse>
NetworkServicesLogging::ListServiceBindings(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::ListServiceBindingsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::networkservices::v1::ListServiceBindingsRequest const&
              request) {
        return child_->ListServiceBindings(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesLogging::GetServiceBinding(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::GetServiceBindingRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetServiceBindingRequest const&
                 request) {
        return child_->GetServiceBinding(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncCreateServiceBinding(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::CreateServiceBindingRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateServiceBindingRequest const&
              request) {
        return child_->AsyncCreateServiceBinding(cq, std::move(context),
                                                 options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncDeleteServiceBinding(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
              request) {
        return child_->AsyncDeleteServiceBinding(cq, std::move(context),
                                                 options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::ListMeshesResponse>
NetworkServicesLogging::ListMeshes(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::ListMeshesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::ListMeshesRequest const&
                 request) { return child_->ListMeshes(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::Mesh>
NetworkServicesLogging::GetMesh(
    grpc::ClientContext& context,
    google::cloud::networkservices::v1::GetMeshRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::networkservices::v1::GetMeshRequest const& request) {
        return child_->GetMesh(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncCreateMesh(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::CreateMeshRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::CreateMeshRequest const&
                 request) {
        return child_->AsyncCreateMesh(cq, std::move(context), options,
                                       request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncUpdateMesh(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::UpdateMeshRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::UpdateMeshRequest const&
                 request) {
        return child_->AsyncUpdateMesh(cq, std::move(context), options,
                                       request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncDeleteMesh(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkservices::v1::DeleteMeshRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::networkservices::v1::DeleteMeshRequest const&
                 request) {
        return child_->AsyncDeleteMesh(cq, std::move(context), options,
                                       request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context), options,
                                         request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<Status> NetworkServicesLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_internal
}  // namespace cloud
}  // namespace google
