// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networksecurity/v1/network_security.proto

#include "google/cloud/networksecurity/v1/internal/network_security_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace networksecurity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NetworkSecurityTracingConnection::NetworkSecurityTracingConnection(
    std::shared_ptr<networksecurity_v1::NetworkSecurityConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::networksecurity::v1::AuthorizationPolicy>
NetworkSecurityTracingConnection::ListAuthorizationPolicies(
    google::cloud::networksecurity::v1::ListAuthorizationPoliciesRequest
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::"
      "ListAuthorizationPolicies");
  internal::OTelScope scope(span);
  auto sr = child_->ListAuthorizationPolicies(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networksecurity::v1::AuthorizationPolicy>(std::move(span),
                                                               std::move(sr));
}

StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>
NetworkSecurityTracingConnection::GetAuthorizationPolicy(
    google::cloud::networksecurity::v1::GetAuthorizationPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::GetAuthorizationPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAuthorizationPolicy(request));
}

future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
NetworkSecurityTracingConnection::CreateAuthorizationPolicy(
    google::cloud::networksecurity::v1::CreateAuthorizationPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::"
      "CreateAuthorizationPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateAuthorizationPolicy(request));
}

future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
NetworkSecurityTracingConnection::UpdateAuthorizationPolicy(
    google::cloud::networksecurity::v1::UpdateAuthorizationPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::"
      "UpdateAuthorizationPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateAuthorizationPolicy(request));
}

future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
NetworkSecurityTracingConnection::DeleteAuthorizationPolicy(
    google::cloud::networksecurity::v1::DeleteAuthorizationPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::"
      "DeleteAuthorizationPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteAuthorizationPolicy(request));
}

StreamRange<google::cloud::networksecurity::v1::ServerTlsPolicy>
NetworkSecurityTracingConnection::ListServerTlsPolicies(
    google::cloud::networksecurity::v1::ListServerTlsPoliciesRequest request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::ListServerTlsPolicies");
  internal::OTelScope scope(span);
  auto sr = child_->ListServerTlsPolicies(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networksecurity::v1::ServerTlsPolicy>(std::move(span),
                                                           std::move(sr));
}

StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>
NetworkSecurityTracingConnection::GetServerTlsPolicy(
    google::cloud::networksecurity::v1::GetServerTlsPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::GetServerTlsPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetServerTlsPolicy(request));
}

future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
NetworkSecurityTracingConnection::CreateServerTlsPolicy(
    google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::CreateServerTlsPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateServerTlsPolicy(request));
}

future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
NetworkSecurityTracingConnection::UpdateServerTlsPolicy(
    google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::UpdateServerTlsPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateServerTlsPolicy(request));
}

future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
NetworkSecurityTracingConnection::DeleteServerTlsPolicy(
    google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::DeleteServerTlsPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteServerTlsPolicy(request));
}

StreamRange<google::cloud::networksecurity::v1::ClientTlsPolicy>
NetworkSecurityTracingConnection::ListClientTlsPolicies(
    google::cloud::networksecurity::v1::ListClientTlsPoliciesRequest request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::ListClientTlsPolicies");
  internal::OTelScope scope(span);
  auto sr = child_->ListClientTlsPolicies(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networksecurity::v1::ClientTlsPolicy>(std::move(span),
                                                           std::move(sr));
}

StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>
NetworkSecurityTracingConnection::GetClientTlsPolicy(
    google::cloud::networksecurity::v1::GetClientTlsPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::GetClientTlsPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetClientTlsPolicy(request));
}

future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
NetworkSecurityTracingConnection::CreateClientTlsPolicy(
    google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::CreateClientTlsPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateClientTlsPolicy(request));
}

future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
NetworkSecurityTracingConnection::UpdateClientTlsPolicy(
    google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::UpdateClientTlsPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateClientTlsPolicy(request));
}

future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
NetworkSecurityTracingConnection::DeleteClientTlsPolicy(
    google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networksecurity_v1::NetworkSecurityConnection::DeleteClientTlsPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteClientTlsPolicy(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<networksecurity_v1::NetworkSecurityConnection>
MakeNetworkSecurityTracingConnection(
    std::shared_ptr<networksecurity_v1::NetworkSecurityConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<NetworkSecurityTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networksecurity_v1_internal
}  // namespace cloud
}  // namespace google
