// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networksecurity/v1/network_security.proto

#include "google/cloud/networksecurity/v1/internal/network_security_metadata_decorator.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/networksecurity/v1/network_security.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networksecurity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NetworkSecurityMetadata::NetworkSecurityMetadata(
    std::shared_ptr<NetworkSecurityStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::networksecurity::v1::ListAuthorizationPoliciesResponse>
NetworkSecurityMetadata::ListAuthorizationPolicies(
    grpc::ClientContext& context,
    google::cloud::networksecurity::v1::ListAuthorizationPoliciesRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListAuthorizationPolicies(context, request);
}

StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>
NetworkSecurityMetadata::GetAuthorizationPolicy(
    grpc::ClientContext& context,
    google::cloud::networksecurity::v1::GetAuthorizationPolicyRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetAuthorizationPolicy(context, request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncCreateAuthorizationPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networksecurity::v1::CreateAuthorizationPolicyRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateAuthorizationPolicy(cq, std::move(context), options,
                                                request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncUpdateAuthorizationPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networksecurity::v1::UpdateAuthorizationPolicyRequest const&
        request) {
  SetMetadata(
      *context, options,
      absl::StrCat("authorization_policy.name=",
                   internal::UrlEncode(request.authorization_policy().name())));
  return child_->AsyncUpdateAuthorizationPolicy(cq, std::move(context), options,
                                                request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncDeleteAuthorizationPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networksecurity::v1::DeleteAuthorizationPolicyRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteAuthorizationPolicy(cq, std::move(context), options,
                                                request);
}

StatusOr<google::cloud::networksecurity::v1::ListServerTlsPoliciesResponse>
NetworkSecurityMetadata::ListServerTlsPolicies(
    grpc::ClientContext& context,
    google::cloud::networksecurity::v1::ListServerTlsPoliciesRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListServerTlsPolicies(context, request);
}

StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>
NetworkSecurityMetadata::GetServerTlsPolicy(
    grpc::ClientContext& context,
    google::cloud::networksecurity::v1::GetServerTlsPolicyRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetServerTlsPolicy(context, request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncCreateServerTlsPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateServerTlsPolicy(cq, std::move(context), options,
                                            request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncUpdateServerTlsPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
        request) {
  SetMetadata(
      *context, options,
      absl::StrCat("server_tls_policy.name=",
                   internal::UrlEncode(request.server_tls_policy().name())));
  return child_->AsyncUpdateServerTlsPolicy(cq, std::move(context), options,
                                            request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncDeleteServerTlsPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteServerTlsPolicy(cq, std::move(context), options,
                                            request);
}

StatusOr<google::cloud::networksecurity::v1::ListClientTlsPoliciesResponse>
NetworkSecurityMetadata::ListClientTlsPolicies(
    grpc::ClientContext& context,
    google::cloud::networksecurity::v1::ListClientTlsPoliciesRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListClientTlsPolicies(context, request);
}

StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>
NetworkSecurityMetadata::GetClientTlsPolicy(
    grpc::ClientContext& context,
    google::cloud::networksecurity::v1::GetClientTlsPolicyRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetClientTlsPolicy(context, request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncCreateClientTlsPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateClientTlsPolicy(cq, std::move(context), options,
                                            request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncUpdateClientTlsPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
        request) {
  SetMetadata(
      *context, options,
      absl::StrCat("client_tls_policy.name=",
                   internal::UrlEncode(request.client_tls_policy().name())));
  return child_->AsyncUpdateClientTlsPolicy(cq, std::move(context), options,
                                            request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncDeleteClientTlsPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteClientTlsPolicy(cq, std::move(context), options,
                                            request);
}

future<StatusOr<google::longrunning::Operation>>
NetworkSecurityMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), options, request);
}

future<Status> NetworkSecurityMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context), options, request);
}

void NetworkSecurityMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options,
                                          std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void NetworkSecurityMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options) {
  for (auto const& kv : fixed_metadata_) {
    context.AddMetadata(kv.first, kv.second);
  }
  context.AddMetadata("x-goog-api-client", api_client_header_);
  if (options.has<UserProjectOption>()) {
    context.AddMetadata("x-goog-user-project",
                        options.get<UserProjectOption>());
  }
  auto const& authority = options.get<AuthorityOption>();
  if (!authority.empty()) context.set_authority(authority);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networksecurity_v1_internal
}  // namespace cloud
}  // namespace google
