// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/hub.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_INTERNAL_HUB_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_INTERNAL_HUB_TRACING_CONNECTION_H

#include "google/cloud/networkconnectivity/v1/hub_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkconnectivity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class HubServiceTracingConnection
    : public networkconnectivity_v1::HubServiceConnection {
 public:
  ~HubServiceTracingConnection() override = default;

  explicit HubServiceTracingConnection(
      std::shared_ptr<networkconnectivity_v1::HubServiceConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::networkconnectivity::v1::Hub> ListHubs(
      google::cloud::networkconnectivity::v1::ListHubsRequest request) override;

  StatusOr<google::cloud::networkconnectivity::v1::Hub> GetHub(
      google::cloud::networkconnectivity::v1::GetHubRequest const& request)
      override;

  future<StatusOr<google::cloud::networkconnectivity::v1::Hub>> CreateHub(
      google::cloud::networkconnectivity::v1::CreateHubRequest const& request)
      override;

  future<StatusOr<google::cloud::networkconnectivity::v1::Hub>> UpdateHub(
      google::cloud::networkconnectivity::v1::UpdateHubRequest const& request)
      override;

  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeleteHub(google::cloud::networkconnectivity::v1::DeleteHubRequest const&
                request) override;

  StreamRange<google::cloud::networkconnectivity::v1::Spoke> ListHubSpokes(
      google::cloud::networkconnectivity::v1::ListHubSpokesRequest request)
      override;

  StreamRange<google::cloud::networkconnectivity::v1::Spoke> ListSpokes(
      google::cloud::networkconnectivity::v1::ListSpokesRequest request)
      override;

  StatusOr<google::cloud::networkconnectivity::v1::Spoke> GetSpoke(
      google::cloud::networkconnectivity::v1::GetSpokeRequest const& request)
      override;

  future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>> CreateSpoke(
      google::cloud::networkconnectivity::v1::CreateSpokeRequest const& request)
      override;

  future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>> UpdateSpoke(
      google::cloud::networkconnectivity::v1::UpdateSpokeRequest const& request)
      override;

  future<
      StatusOr<google::cloud::networkconnectivity::v1::RejectHubSpokeResponse>>
  RejectHubSpoke(
      google::cloud::networkconnectivity::v1::RejectHubSpokeRequest const&
          request) override;

  future<
      StatusOr<google::cloud::networkconnectivity::v1::AcceptHubSpokeResponse>>
  AcceptHubSpoke(
      google::cloud::networkconnectivity::v1::AcceptHubSpokeRequest const&
          request) override;

  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeleteSpoke(google::cloud::networkconnectivity::v1::DeleteSpokeRequest const&
                  request) override;

  StatusOr<google::cloud::networkconnectivity::v1::RouteTable> GetRouteTable(
      google::cloud::networkconnectivity::v1::GetRouteTableRequest const&
          request) override;

  StatusOr<google::cloud::networkconnectivity::v1::Route> GetRoute(
      google::cloud::networkconnectivity::v1::GetRouteRequest const& request)
      override;

  StreamRange<google::cloud::networkconnectivity::v1::Route> ListRoutes(
      google::cloud::networkconnectivity::v1::ListRoutesRequest request)
      override;

  StreamRange<google::cloud::networkconnectivity::v1::RouteTable>
  ListRouteTables(google::cloud::networkconnectivity::v1::ListRouteTablesRequest
                      request) override;

  StatusOr<google::cloud::networkconnectivity::v1::Group> GetGroup(
      google::cloud::networkconnectivity::v1::GetGroupRequest const& request)
      override;

  StreamRange<google::cloud::networkconnectivity::v1::Group> ListGroups(
      google::cloud::networkconnectivity::v1::ListGroupsRequest request)
      override;

 private:
  std::shared_ptr<networkconnectivity_v1::HubServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<networkconnectivity_v1::HubServiceConnection>
MakeHubServiceTracingConnection(
    std::shared_ptr<networkconnectivity_v1::HubServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_INTERNAL_HUB_TRACING_CONNECTION_H
