// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/metric_service.proto

#include "google/cloud/monitoring/v3/internal/metric_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

MetricServiceTracingConnection::MetricServiceTracingConnection(
    std::shared_ptr<monitoring_v3::MetricServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::api::MonitoredResourceDescriptor>
MetricServiceTracingConnection::ListMonitoredResourceDescriptors(
    google::monitoring::v3::ListMonitoredResourceDescriptorsRequest request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::"
      "ListMonitoredResourceDescriptors");
  internal::OTelScope scope(span);
  auto sr = child_->ListMonitoredResourceDescriptors(std::move(request));
  return internal::MakeTracedStreamRange<
      google::api::MonitoredResourceDescriptor>(std::move(span), std::move(sr));
}

StatusOr<google::api::MonitoredResourceDescriptor>
MetricServiceTracingConnection::GetMonitoredResourceDescriptor(
    google::monitoring::v3::GetMonitoredResourceDescriptorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::GetMonitoredResourceDescriptor");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->GetMonitoredResourceDescriptor(request));
}

StreamRange<google::api::MetricDescriptor>
MetricServiceTracingConnection::ListMetricDescriptors(
    google::monitoring::v3::ListMetricDescriptorsRequest request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::ListMetricDescriptors");
  internal::OTelScope scope(span);
  auto sr = child_->ListMetricDescriptors(std::move(request));
  return internal::MakeTracedStreamRange<google::api::MetricDescriptor>(
      std::move(span), std::move(sr));
}

StatusOr<google::api::MetricDescriptor>
MetricServiceTracingConnection::GetMetricDescriptor(
    google::monitoring::v3::GetMetricDescriptorRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::GetMetricDescriptor");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetMetricDescriptor(request));
}

StatusOr<google::api::MetricDescriptor>
MetricServiceTracingConnection::CreateMetricDescriptor(
    google::monitoring::v3::CreateMetricDescriptorRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::CreateMetricDescriptor");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateMetricDescriptor(request));
}

Status MetricServiceTracingConnection::DeleteMetricDescriptor(
    google::monitoring::v3::DeleteMetricDescriptorRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::DeleteMetricDescriptor");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteMetricDescriptor(request));
}

StreamRange<google::monitoring::v3::TimeSeries>
MetricServiceTracingConnection::ListTimeSeries(
    google::monitoring::v3::ListTimeSeriesRequest request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::ListTimeSeries");
  internal::OTelScope scope(span);
  auto sr = child_->ListTimeSeries(std::move(request));
  return internal::MakeTracedStreamRange<google::monitoring::v3::TimeSeries>(
      std::move(span), std::move(sr));
}

Status MetricServiceTracingConnection::CreateTimeSeries(
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::CreateTimeSeries");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateTimeSeries(request));
}

Status MetricServiceTracingConnection::CreateServiceTimeSeries(
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::CreateServiceTimeSeries");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateServiceTimeSeries(request));
}

future<Status> MetricServiceTracingConnection::AsyncCreateTimeSeries(
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::MetricServiceConnection::AsyncCreateTimeSeries");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->AsyncCreateTimeSeries(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<monitoring_v3::MetricServiceConnection>
MakeMetricServiceTracingConnection(
    std::shared_ptr<monitoring_v3::MetricServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<MetricServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
