// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/azure_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AZURE_CLUSTERS_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AZURE_CLUSTERS_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/gkemulticloud/v1/azure_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace gkemulticloud_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AzureClustersConnectionIdempotencyPolicy {
 public:
  virtual ~AzureClustersConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<AzureClustersConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateAzureClient(
      google::cloud::gkemulticloud::v1::CreateAzureClientRequest const&
          request);

  virtual google::cloud::Idempotency GetAzureClient(
      google::cloud::gkemulticloud::v1::GetAzureClientRequest const& request);

  virtual google::cloud::Idempotency ListAzureClients(
      google::cloud::gkemulticloud::v1::ListAzureClientsRequest request);

  virtual google::cloud::Idempotency DeleteAzureClient(
      google::cloud::gkemulticloud::v1::DeleteAzureClientRequest const&
          request);

  virtual google::cloud::Idempotency CreateAzureCluster(
      google::cloud::gkemulticloud::v1::CreateAzureClusterRequest const&
          request);

  virtual google::cloud::Idempotency UpdateAzureCluster(
      google::cloud::gkemulticloud::v1::UpdateAzureClusterRequest const&
          request);

  virtual google::cloud::Idempotency GetAzureCluster(
      google::cloud::gkemulticloud::v1::GetAzureClusterRequest const& request);

  virtual google::cloud::Idempotency ListAzureClusters(
      google::cloud::gkemulticloud::v1::ListAzureClustersRequest request);

  virtual google::cloud::Idempotency DeleteAzureCluster(
      google::cloud::gkemulticloud::v1::DeleteAzureClusterRequest const&
          request);

  virtual google::cloud::Idempotency GenerateAzureAccessToken(
      google::cloud::gkemulticloud::v1::GenerateAzureAccessTokenRequest const&
          request);

  virtual google::cloud::Idempotency CreateAzureNodePool(
      google::cloud::gkemulticloud::v1::CreateAzureNodePoolRequest const&
          request);

  virtual google::cloud::Idempotency UpdateAzureNodePool(
      google::cloud::gkemulticloud::v1::UpdateAzureNodePoolRequest const&
          request);

  virtual google::cloud::Idempotency GetAzureNodePool(
      google::cloud::gkemulticloud::v1::GetAzureNodePoolRequest const& request);

  virtual google::cloud::Idempotency ListAzureNodePools(
      google::cloud::gkemulticloud::v1::ListAzureNodePoolsRequest request);

  virtual google::cloud::Idempotency DeleteAzureNodePool(
      google::cloud::gkemulticloud::v1::DeleteAzureNodePoolRequest const&
          request);

  virtual google::cloud::Idempotency GetAzureServerConfig(
      google::cloud::gkemulticloud::v1::GetAzureServerConfigRequest const&
          request);
};

std::unique_ptr<AzureClustersConnectionIdempotencyPolicy>
MakeDefaultAzureClustersConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AZURE_CLUSTERS_CONNECTION_IDEMPOTENCY_POLICY_H
