// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v1/functions.proto

#include "google/cloud/functions/v1/internal/cloud_functions_connection_impl.h"
#include "google/cloud/functions/v1/internal/cloud_functions_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace functions_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<functions_v1::CloudFunctionsServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<functions_v1::CloudFunctionsServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<functions_v1::CloudFunctionsServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<functions_v1::CloudFunctionsServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<functions_v1::
               CloudFunctionsServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<functions_v1::CloudFunctionsServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

CloudFunctionsServiceConnectionImpl::CloudFunctionsServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<functions_v1_internal::CloudFunctionsServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), CloudFunctionsServiceConnection::options())) {}

StreamRange<google::cloud::functions::v1::CloudFunction>
CloudFunctionsServiceConnectionImpl::ListFunctions(
    google::cloud::functions::v1::ListFunctionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListFunctions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::functions::v1::CloudFunction>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<functions_v1::CloudFunctionsServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::functions::v1::ListFunctionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::functions::v1::ListFunctionsRequest const&
                       request) {
              return stub->ListFunctions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::functions::v1::ListFunctionsResponse r) {
        std::vector<google::cloud::functions::v1::CloudFunction> result(
            r.functions().size());
        auto& messages = *r.mutable_functions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::functions::v1::CloudFunction>
CloudFunctionsServiceConnectionImpl::GetFunction(
    google::cloud::functions::v1::GetFunctionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetFunction(request),
      [this](grpc::ClientContext& context,
             google::cloud::functions::v1::GetFunctionRequest const& request) {
        return stub_->GetFunction(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::functions::v1::CloudFunction>>
CloudFunctionsServiceConnectionImpl::CreateFunction(
    google::cloud::functions::v1::CreateFunctionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::functions::v1::CloudFunction>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::functions::v1::CreateFunctionRequest const& request) {
        return stub->AsyncCreateFunction(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::functions::v1::CloudFunction>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateFunction(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::functions::v1::CloudFunction>>
CloudFunctionsServiceConnectionImpl::UpdateFunction(
    google::cloud::functions::v1::UpdateFunctionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::functions::v1::CloudFunction>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::functions::v1::UpdateFunctionRequest const& request) {
        return stub->AsyncUpdateFunction(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::functions::v1::CloudFunction>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateFunction(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::functions::v1::OperationMetadataV1>>
CloudFunctionsServiceConnectionImpl::DeleteFunction(
    google::cloud::functions::v1::DeleteFunctionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::functions::v1::OperationMetadataV1>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::functions::v1::DeleteFunctionRequest const& request) {
        return stub->AsyncDeleteFunction(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::functions::v1::OperationMetadataV1>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteFunction(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::functions::v1::CallFunctionResponse>
CloudFunctionsServiceConnectionImpl::CallFunction(
    google::cloud::functions::v1::CallFunctionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CallFunction(request),
      [this](grpc::ClientContext& context,
             google::cloud::functions::v1::CallFunctionRequest const& request) {
        return stub_->CallFunction(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::functions::v1::GenerateUploadUrlResponse>
CloudFunctionsServiceConnectionImpl::GenerateUploadUrl(
    google::cloud::functions::v1::GenerateUploadUrlRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateUploadUrl(request),
      [this](grpc::ClientContext& context,
             google::cloud::functions::v1::GenerateUploadUrlRequest const&
                 request) {
        return stub_->GenerateUploadUrl(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::functions::v1::GenerateDownloadUrlResponse>
CloudFunctionsServiceConnectionImpl::GenerateDownloadUrl(
    google::cloud::functions::v1::GenerateDownloadUrlRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateDownloadUrl(request),
      [this](grpc::ClientContext& context,
             google::cloud::functions::v1::GenerateDownloadUrlRequest const&
                 request) {
        return stub_->GenerateDownloadUrl(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy>
CloudFunctionsServiceConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy>
CloudFunctionsServiceConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudFunctionsServiceConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v1_internal
}  // namespace cloud
}  // namespace google
