// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: grafeas/v1/grafeas.proto

#include "google/cloud/containeranalysis/v1/internal/grafeas_auth_decorator.h"
#include <grafeas/v1/grafeas.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace containeranalysis_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GrafeasAuth::GrafeasAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<GrafeasStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<grafeas::v1::Occurrence> GrafeasAuth::GetOccurrence(
    grpc::ClientContext& context,
    grafeas::v1::GetOccurrenceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetOccurrence(context, request);
}

StatusOr<grafeas::v1::ListOccurrencesResponse> GrafeasAuth::ListOccurrences(
    grpc::ClientContext& context,
    grafeas::v1::ListOccurrencesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListOccurrences(context, request);
}

Status GrafeasAuth::DeleteOccurrence(
    grpc::ClientContext& context,
    grafeas::v1::DeleteOccurrenceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteOccurrence(context, request);
}

StatusOr<grafeas::v1::Occurrence> GrafeasAuth::CreateOccurrence(
    grpc::ClientContext& context,
    grafeas::v1::CreateOccurrenceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateOccurrence(context, request);
}

StatusOr<grafeas::v1::BatchCreateOccurrencesResponse>
GrafeasAuth::BatchCreateOccurrences(
    grpc::ClientContext& context,
    grafeas::v1::BatchCreateOccurrencesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->BatchCreateOccurrences(context, request);
}

StatusOr<grafeas::v1::Occurrence> GrafeasAuth::UpdateOccurrence(
    grpc::ClientContext& context,
    grafeas::v1::UpdateOccurrenceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateOccurrence(context, request);
}

StatusOr<grafeas::v1::Note> GrafeasAuth::GetOccurrenceNote(
    grpc::ClientContext& context,
    grafeas::v1::GetOccurrenceNoteRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetOccurrenceNote(context, request);
}

StatusOr<grafeas::v1::Note> GrafeasAuth::GetNote(
    grpc::ClientContext& context, grafeas::v1::GetNoteRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetNote(context, request);
}

StatusOr<grafeas::v1::ListNotesResponse> GrafeasAuth::ListNotes(
    grpc::ClientContext& context,
    grafeas::v1::ListNotesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListNotes(context, request);
}

Status GrafeasAuth::DeleteNote(grpc::ClientContext& context,
                               grafeas::v1::DeleteNoteRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteNote(context, request);
}

StatusOr<grafeas::v1::Note> GrafeasAuth::CreateNote(
    grpc::ClientContext& context,
    grafeas::v1::CreateNoteRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateNote(context, request);
}

StatusOr<grafeas::v1::BatchCreateNotesResponse> GrafeasAuth::BatchCreateNotes(
    grpc::ClientContext& context,
    grafeas::v1::BatchCreateNotesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->BatchCreateNotes(context, request);
}

StatusOr<grafeas::v1::Note> GrafeasAuth::UpdateNote(
    grpc::ClientContext& context,
    grafeas::v1::UpdateNoteRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateNote(context, request);
}

StatusOr<grafeas::v1::ListNoteOccurrencesResponse>
GrafeasAuth::ListNoteOccurrences(
    grpc::ClientContext& context,
    grafeas::v1::ListNoteOccurrencesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListNoteOccurrences(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace containeranalysis_v1_internal
}  // namespace cloud
}  // namespace google
