// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_network_endpoint_groups/v1/region_network_endpoint_groups.proto

#include "google/cloud/compute/region_network_endpoint_groups/v1/region_network_endpoint_groups_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_network_endpoint_groups_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionNetworkEndpointGroupsClient::RegionNetworkEndpointGroupsClient(
    std::shared_ptr<RegionNetworkEndpointGroupsConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RegionNetworkEndpointGroupsClient::~RegionNetworkEndpointGroupsClient() =
    default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionNetworkEndpointGroupsClient::AttachNetworkEndpoints(
    std::string const& project, std::string const& region,
    std::string const& network_endpoint_group,
    google::cloud::cpp::compute::v1::
        RegionNetworkEndpointGroupsAttachEndpointsRequest const&
            region_network_endpoint_groups_attach_endpoints_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_network_endpoint_groups::v1::
      AttachNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_endpoint_group(network_endpoint_group);
  *request
       .mutable_region_network_endpoint_groups_attach_endpoints_request_resource() =
      region_network_endpoint_groups_attach_endpoints_request_resource;
  return connection_->AttachNetworkEndpoints(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionNetworkEndpointGroupsClient::AttachNetworkEndpoints(
    google::cloud::cpp::compute::region_network_endpoint_groups::v1::
        AttachNetworkEndpointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AttachNetworkEndpoints(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionNetworkEndpointGroupsClient::DeleteNetworkEndpointGroup(
    std::string const& project, std::string const& region,
    std::string const& network_endpoint_group, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_network_endpoint_groups::v1::
      DeleteNetworkEndpointGroupRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_endpoint_group(network_endpoint_group);
  return connection_->DeleteNetworkEndpointGroup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionNetworkEndpointGroupsClient::DeleteNetworkEndpointGroup(
    google::cloud::cpp::compute::region_network_endpoint_groups::v1::
        DeleteNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkEndpointGroup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionNetworkEndpointGroupsClient::DetachNetworkEndpoints(
    std::string const& project, std::string const& region,
    std::string const& network_endpoint_group,
    google::cloud::cpp::compute::v1::
        RegionNetworkEndpointGroupsDetachEndpointsRequest const&
            region_network_endpoint_groups_detach_endpoints_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_network_endpoint_groups::v1::
      DetachNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_endpoint_group(network_endpoint_group);
  *request
       .mutable_region_network_endpoint_groups_detach_endpoints_request_resource() =
      region_network_endpoint_groups_detach_endpoints_request_resource;
  return connection_->DetachNetworkEndpoints(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionNetworkEndpointGroupsClient::DetachNetworkEndpoints(
    google::cloud::cpp::compute::region_network_endpoint_groups::v1::
        DetachNetworkEndpointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DetachNetworkEndpoints(request);
}

StatusOr<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
RegionNetworkEndpointGroupsClient::GetNetworkEndpointGroup(
    std::string const& project, std::string const& region,
    std::string const& network_endpoint_group, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_network_endpoint_groups::v1::
      GetNetworkEndpointGroupRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_endpoint_group(network_endpoint_group);
  return connection_->GetNetworkEndpointGroup(request);
}

StatusOr<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
RegionNetworkEndpointGroupsClient::GetNetworkEndpointGroup(
    google::cloud::cpp::compute::region_network_endpoint_groups::v1::
        GetNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNetworkEndpointGroup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionNetworkEndpointGroupsClient::InsertNetworkEndpointGroup(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::NetworkEndpointGroup const&
        network_endpoint_group_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_network_endpoint_groups::v1::
      InsertNetworkEndpointGroupRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_network_endpoint_group_resource() =
      network_endpoint_group_resource;
  return connection_->InsertNetworkEndpointGroup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionNetworkEndpointGroupsClient::InsertNetworkEndpointGroup(
    google::cloud::cpp::compute::region_network_endpoint_groups::v1::
        InsertNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertNetworkEndpointGroup(request);
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
RegionNetworkEndpointGroupsClient::ListRegionNetworkEndpointGroups(
    std::string const& project, std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_network_endpoint_groups::v1::
      ListRegionNetworkEndpointGroupsRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListRegionNetworkEndpointGroups(request);
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
RegionNetworkEndpointGroupsClient::ListRegionNetworkEndpointGroups(
    google::cloud::cpp::compute::region_network_endpoint_groups::v1::
        ListRegionNetworkEndpointGroupsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRegionNetworkEndpointGroups(std::move(request));
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointWithHealthStatus>
RegionNetworkEndpointGroupsClient::ListNetworkEndpoints(
    std::string const& project, std::string const& region,
    std::string const& network_endpoint_group, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_network_endpoint_groups::v1::
      ListNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_endpoint_group(network_endpoint_group);
  return connection_->ListNetworkEndpoints(request);
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointWithHealthStatus>
RegionNetworkEndpointGroupsClient::ListNetworkEndpoints(
    google::cloud::cpp::compute::region_network_endpoint_groups::v1::
        ListNetworkEndpointsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNetworkEndpoints(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_network_endpoint_groups_v1
}  // namespace cloud
}  // namespace google
