// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/region_commitments/v1/region_commitments.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_REGION_COMMITMENTS_V1_INTERNAL_REGION_COMMITMENTS_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_REGION_COMMITMENTS_V1_INTERNAL_REGION_COMMITMENTS_REST_CONNECTION_IMPL_H

#include "google/cloud/compute/region_commitments/v1/internal/region_commitments_rest_stub.h"
#include "google/cloud/compute/region_commitments/v1/internal/region_commitments_retry_traits.h"
#include "google/cloud/compute/region_commitments/v1/region_commitments_connection.h"
#include "google/cloud/compute/region_commitments/v1/region_commitments_connection_idempotency_policy.h"
#include "google/cloud/compute/region_commitments/v1/region_commitments_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/region_operations/v1/region_operations.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_commitments_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RegionCommitmentsRestConnectionImpl
    : public compute_region_commitments_v1::RegionCommitmentsConnection {
 public:
  ~RegionCommitmentsRestConnectionImpl() override = default;

  RegionCommitmentsRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          compute_region_commitments_v1_internal::RegionCommitmentsRestStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<std::pair<std::string,
                        google::cloud::cpp::compute::v1::CommitmentsScopedList>>
  AggregatedListRegionCommitments(
      google::cloud::cpp::compute::region_commitments::v1::
          AggregatedListRegionCommitmentsRequest request) override;

  StatusOr<google::cloud::cpp::compute::v1::Commitment> GetCommitment(
      google::cloud::cpp::compute::region_commitments::v1::
          GetCommitmentRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> InsertCommitment(
      google::cloud::cpp::compute::region_commitments::v1::
          InsertCommitmentRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::Commitment>
  ListRegionCommitments(google::cloud::cpp::compute::region_commitments::v1::
                            ListRegionCommitmentsRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> UpdateCommitment(
      google::cloud::cpp::compute::region_commitments::v1::
          UpdateCommitmentRequest const& request) override;

 private:
  static std::unique_ptr<
      compute_region_commitments_v1::RegionCommitmentsRetryPolicy>
  retry_policy(Options const& options) {
    return options
        .get<
            compute_region_commitments_v1::RegionCommitmentsRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options
        .get<compute_region_commitments_v1::
                 RegionCommitmentsBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<compute_region_commitments_v1::
                             RegionCommitmentsConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<compute_region_commitments_v1::
                 RegionCommitmentsConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
    return options
        .get<compute_region_commitments_v1::
                 RegionCommitmentsPollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<
      compute_region_commitments_v1_internal::RegionCommitmentsRestStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_commitments_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_REGION_COMMITMENTS_V1_INTERNAL_REGION_COMMITMENTS_REST_CONNECTION_IMPL_H
