// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/networks/v1/networks.proto

#include "google/cloud/compute/networks/v1/networks_connection.h"
#include "google/cloud/compute/networks/v1/internal/networks_option_defaults.h"
#include "google/cloud/compute/networks/v1/internal/networks_tracing_connection.h"
#include "google/cloud/compute/networks/v1/networks_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_networks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NetworksConnection::~NetworksConnection() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksConnection::AddPeering(
    google::cloud::cpp::compute::networks::v1::AddPeeringRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksConnection::DeleteNetwork(
    google::cloud::cpp::compute::networks::v1::DeleteNetworkRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Network>
NetworksConnection::GetNetwork(
    google::cloud::cpp::compute::networks::v1::GetNetworkRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::cpp::compute::v1::NetworksGetEffectiveFirewallsResponse>
NetworksConnection::GetEffectiveFirewalls(
    google::cloud::cpp::compute::networks::v1::
        GetEffectiveFirewallsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksConnection::InsertNetwork(
    google::cloud::cpp::compute::networks::v1::InsertNetworkRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::cpp::compute::v1::Network>
NetworksConnection::ListNetworks(
    google::cloud::cpp::compute::networks::v1::
        ListNetworksRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cpp::compute::v1::Network>>();
}

StreamRange<google::cloud::cpp::compute::v1::ExchangedPeeringRoute>
NetworksConnection::ListPeeringRoutes(
    google::cloud::cpp::compute::networks::v1::
        ListPeeringRoutesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cpp::compute::v1::ExchangedPeeringRoute>>();
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksConnection::PatchNetwork(
    google::cloud::cpp::compute::networks::v1::PatchNetworkRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksConnection::RemovePeering(
    google::cloud::cpp::compute::networks::v1::RemovePeeringRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksConnection::SwitchToCustomMode(
    google::cloud::cpp::compute::networks::v1::
        SwitchToCustomModeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksConnection::UpdatePeering(
    google::cloud::cpp::compute::networks::v1::UpdatePeeringRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_networks_v1
}  // namespace cloud
}  // namespace google
