// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/health_checks/v1/health_checks.proto

#include "google/cloud/compute/health_checks/v1/internal/health_checks_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_health_checks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

HealthChecksTracingConnection::HealthChecksTracingConnection(
    std::shared_ptr<compute_health_checks_v1::HealthChecksConnection> child)
    : child_(std::move(child)) {}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::HealthChecksScopedList>>
HealthChecksTracingConnection::AggregatedListHealthChecks(
    google::cloud::cpp::compute::health_checks::v1::
        AggregatedListHealthChecksRequest request) {
  auto span = internal::MakeSpan(
      "compute_health_checks_v1::HealthChecksConnection::"
      "AggregatedListHealthChecks");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListHealthChecks(std::move(request));
  return internal::MakeTracedStreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::HealthChecksScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksTracingConnection::DeleteHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::
        DeleteHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_health_checks_v1::HealthChecksConnection::DeleteHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteHealthCheck(request));
}

StatusOr<google::cloud::cpp::compute::v1::HealthCheck>
HealthChecksTracingConnection::GetHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::GetHealthCheckRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_health_checks_v1::HealthChecksConnection::GetHealthCheck");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetHealthCheck(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksTracingConnection::InsertHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::
        InsertHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_health_checks_v1::HealthChecksConnection::InsertHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertHealthCheck(request));
}

StreamRange<google::cloud::cpp::compute::v1::HealthCheck>
HealthChecksTracingConnection::ListHealthChecks(
    google::cloud::cpp::compute::health_checks::v1::ListHealthChecksRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_health_checks_v1::HealthChecksConnection::ListHealthChecks");
  internal::OTelScope scope(span);
  auto sr = child_->ListHealthChecks(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::HealthCheck>(std::move(span),
                                                    std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksTracingConnection::PatchHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::
        PatchHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_health_checks_v1::HealthChecksConnection::PatchHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PatchHealthCheck(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksTracingConnection::UpdateHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::
        UpdateHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_health_checks_v1::HealthChecksConnection::UpdateHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateHealthCheck(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_health_checks_v1::HealthChecksConnection>
MakeHealthChecksTracingConnection(
    std::shared_ptr<compute_health_checks_v1::HealthChecksConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<HealthChecksTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_health_checks_v1_internal
}  // namespace cloud
}  // namespace google
