// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/disks/v1/disks.proto

#include "google/cloud/compute/disks/v1/internal/disks_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_disks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DisksTracingConnection::DisksTracingConnection(
    std::shared_ptr<compute_disks_v1::DisksConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::AddResourcePolicies(
    google::cloud::cpp::compute::disks::v1::AddResourcePoliciesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_disks_v1::DisksConnection::AddResourcePolicies");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->AddResourcePolicies(request));
}

StreamRange<
    std::pair<std::string, google::cloud::cpp::compute::v1::DisksScopedList>>
DisksTracingConnection::AggregatedListDisks(
    google::cloud::cpp::compute::disks::v1::AggregatedListDisksRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_disks_v1::DisksConnection::AggregatedListDisks");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListDisks(std::move(request));
  return internal::MakeTracedStreamRange<
      std::pair<std::string, google::cloud::cpp::compute::v1::DisksScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::BulkInsert(
    google::cloud::cpp::compute::disks::v1::BulkInsertRequest const& request) {
  auto span =
      internal::MakeSpan("compute_disks_v1::DisksConnection::BulkInsert");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->BulkInsert(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::CreateSnapshot(
    google::cloud::cpp::compute::disks::v1::CreateSnapshotRequest const&
        request) {
  auto span =
      internal::MakeSpan("compute_disks_v1::DisksConnection::CreateSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSnapshot(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::DeleteDisk(
    google::cloud::cpp::compute::disks::v1::DeleteDiskRequest const& request) {
  auto span =
      internal::MakeSpan("compute_disks_v1::DisksConnection::DeleteDisk");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteDisk(request));
}

StatusOr<google::cloud::cpp::compute::v1::Disk> DisksTracingConnection::GetDisk(
    google::cloud::cpp::compute::disks::v1::GetDiskRequest const& request) {
  auto span = internal::MakeSpan("compute_disks_v1::DisksConnection::GetDisk");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDisk(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
DisksTracingConnection::GetIamPolicy(
    google::cloud::cpp::compute::disks::v1::GetIamPolicyRequest const&
        request) {
  auto span =
      internal::MakeSpan("compute_disks_v1::DisksConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::InsertDisk(
    google::cloud::cpp::compute::disks::v1::InsertDiskRequest const& request) {
  auto span =
      internal::MakeSpan("compute_disks_v1::DisksConnection::InsertDisk");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertDisk(request));
}

StreamRange<google::cloud::cpp::compute::v1::Disk>
DisksTracingConnection::ListDisks(
    google::cloud::cpp::compute::disks::v1::ListDisksRequest request) {
  auto span =
      internal::MakeSpan("compute_disks_v1::DisksConnection::ListDisks");
  internal::OTelScope scope(span);
  auto sr = child_->ListDisks(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::cpp::compute::v1::Disk>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::RemoveResourcePolicies(
    google::cloud::cpp::compute::disks::v1::RemoveResourcePoliciesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_disks_v1::DisksConnection::RemoveResourcePolicies");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RemoveResourcePolicies(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::Resize(
    google::cloud::cpp::compute::disks::v1::ResizeRequest const& request) {
  auto span = internal::MakeSpan("compute_disks_v1::DisksConnection::Resize");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Resize(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
DisksTracingConnection::SetIamPolicy(
    google::cloud::cpp::compute::disks::v1::SetIamPolicyRequest const&
        request) {
  auto span =
      internal::MakeSpan("compute_disks_v1::DisksConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::SetLabels(
    google::cloud::cpp::compute::disks::v1::SetLabelsRequest const& request) {
  auto span =
      internal::MakeSpan("compute_disks_v1::DisksConnection::SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::StartAsyncReplication(
    google::cloud::cpp::compute::disks::v1::StartAsyncReplicationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_disks_v1::DisksConnection::StartAsyncReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->StartAsyncReplication(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::StopAsyncReplication(
    google::cloud::cpp::compute::disks::v1::StopAsyncReplicationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_disks_v1::DisksConnection::StopAsyncReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->StopAsyncReplication(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::StopGroupAsyncReplication(
    google::cloud::cpp::compute::disks::v1::
        StopGroupAsyncReplicationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_disks_v1::DisksConnection::StopGroupAsyncReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->StopGroupAsyncReplication(request));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
DisksTracingConnection::TestIamPermissions(
    google::cloud::cpp::compute::disks::v1::TestIamPermissionsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_disks_v1::DisksConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
DisksTracingConnection::UpdateDisk(
    google::cloud::cpp::compute::disks::v1::UpdateDiskRequest const& request) {
  auto span =
      internal::MakeSpan("compute_disks_v1::DisksConnection::UpdateDisk");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateDisk(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_disks_v1::DisksConnection> MakeDisksTracingConnection(
    std::shared_ptr<compute_disks_v1::DisksConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DisksTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_disks_v1_internal
}  // namespace cloud
}  // namespace google
