// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/batch/v1/batch.proto

#include "google/cloud/batch/v1/internal/batch_option_defaults.h"
#include "google/cloud/batch/v1/batch_connection.h"
#include "google/cloud/batch/v1/batch_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace batch_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options BatchServiceDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_BATCH_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_BATCH_SERVICE_AUTHORITY", "batch.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<batch_v1::BatchServiceRetryPolicyOption>()) {
    options.set<batch_v1::BatchServiceRetryPolicyOption>(
        batch_v1::BatchServiceLimitedTimeRetryPolicy(std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<batch_v1::BatchServiceBackoffPolicyOption>()) {
    options.set<batch_v1::BatchServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<batch_v1::BatchServicePollingPolicyOption>()) {
    options.set<batch_v1::BatchServicePollingPolicyOption>(
        GenericPollingPolicy<batch_v1::BatchServiceRetryPolicyOption::Type,
                             batch_v1::BatchServiceBackoffPolicyOption::Type>(
            options.get<batch_v1::BatchServiceRetryPolicyOption>()->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<batch_v1::BatchServiceConnectionIdempotencyPolicyOption>()) {
    options.set<batch_v1::BatchServiceConnectionIdempotencyPolicyOption>(
        batch_v1::MakeDefaultBatchServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace batch_v1_internal
}  // namespace cloud
}  // namespace google
