// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/metadata_service.proto

#include "google/cloud/aiplatform/v1/metadata_connection.h"
#include "google/cloud/aiplatform/v1/internal/metadata_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/metadata_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/metadata_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/metadata_tracing_connection.h"
#include "google/cloud/aiplatform/v1/metadata_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetadataServiceConnection::~MetadataServiceConnection() = default;

future<StatusOr<google::cloud::aiplatform::v1::MetadataStore>>
MetadataServiceConnection::CreateMetadataStore(
    google::cloud::aiplatform::v1::CreateMetadataStoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::MetadataStore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::MetadataStore>
MetadataServiceConnection::GetMetadataStore(
    google::cloud::aiplatform::v1::GetMetadataStoreRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::MetadataStore>
MetadataServiceConnection::ListMetadataStores(
    google::cloud::aiplatform::v1::
        ListMetadataStoresRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::MetadataStore>>();
}

future<StatusOr<
    google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>
MetadataServiceConnection::DeleteMetadataStore(
    google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceConnection::CreateArtifact(
    google::cloud::aiplatform::v1::CreateArtifactRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceConnection::GetArtifact(
    google::cloud::aiplatform::v1::GetArtifactRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::Artifact>
MetadataServiceConnection::ListArtifacts(
    google::cloud::aiplatform::v1::
        ListArtifactsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Artifact>>();
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceConnection::UpdateArtifact(
    google::cloud::aiplatform::v1::UpdateArtifactRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceConnection::DeleteArtifact(
    google::cloud::aiplatform::v1::DeleteArtifactRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>
MetadataServiceConnection::PurgeArtifacts(
    google::cloud::aiplatform::v1::PurgeArtifactsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceConnection::CreateContext(
    google::cloud::aiplatform::v1::CreateContextRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceConnection::GetContext(
    google::cloud::aiplatform::v1::GetContextRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::Context>
MetadataServiceConnection::ListContexts(
    google::cloud::aiplatform::v1::
        ListContextsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Context>>();
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceConnection::UpdateContext(
    google::cloud::aiplatform::v1::UpdateContextRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceConnection::DeleteContext(
    google::cloud::aiplatform::v1::DeleteContextRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>
MetadataServiceConnection::PurgeContexts(
    google::cloud::aiplatform::v1::PurgeContextsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<
    google::cloud::aiplatform::v1::AddContextArtifactsAndExecutionsResponse>
MetadataServiceConnection::AddContextArtifactsAndExecutions(
    google::cloud::aiplatform::v1::
        AddContextArtifactsAndExecutionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::AddContextChildrenResponse>
MetadataServiceConnection::AddContextChildren(
    google::cloud::aiplatform::v1::AddContextChildrenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::RemoveContextChildrenResponse>
MetadataServiceConnection::RemoveContextChildren(
    google::cloud::aiplatform::v1::RemoveContextChildrenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceConnection::QueryContextLineageSubgraph(
    google::cloud::aiplatform::v1::QueryContextLineageSubgraphRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceConnection::CreateExecution(
    google::cloud::aiplatform::v1::CreateExecutionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceConnection::GetExecution(
    google::cloud::aiplatform::v1::GetExecutionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::Execution>
MetadataServiceConnection::ListExecutions(
    google::cloud::aiplatform::v1::
        ListExecutionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Execution>>();
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceConnection::UpdateExecution(
    google::cloud::aiplatform::v1::UpdateExecutionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceConnection::DeleteExecution(
    google::cloud::aiplatform::v1::DeleteExecutionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>
MetadataServiceConnection::PurgeExecutions(
    google::cloud::aiplatform::v1::PurgeExecutionsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::AddExecutionEventsResponse>
MetadataServiceConnection::AddExecutionEvents(
    google::cloud::aiplatform::v1::AddExecutionEventsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceConnection::QueryExecutionInputsAndOutputs(
    google::cloud::aiplatform::v1::
        QueryExecutionInputsAndOutputsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceConnection::CreateMetadataSchema(
    google::cloud::aiplatform::v1::CreateMetadataSchemaRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceConnection::GetMetadataSchema(
    google::cloud::aiplatform::v1::GetMetadataSchemaRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceConnection::ListMetadataSchemas(
    google::cloud::aiplatform::v1::
        ListMetadataSchemasRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::MetadataSchema>>();
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceConnection::QueryArtifactLineageSubgraph(
    google::cloud::aiplatform::v1::QueryArtifactLineageSubgraphRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<MetadataServiceConnection> MakeMetadataServiceConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 MetadataServicePolicyOptionList>(options,
                                                                  __func__);
  options = aiplatform_v1_internal::MetadataServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = aiplatform_v1_internal::CreateDefaultMetadataServiceStub(
      background->cq(), options);
  return aiplatform_v1_internal::MakeMetadataServiceTracingConnection(
      std::make_shared<aiplatform_v1_internal::MetadataServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
