// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/index_endpoint_service.proto

#include "google/cloud/aiplatform/v1/internal/index_endpoint_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/index_endpoint_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<aiplatform_v1::IndexEndpointServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<aiplatform_v1::IndexEndpointServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<aiplatform_v1::IndexEndpointServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<aiplatform_v1::IndexEndpointServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<aiplatform_v1::
               IndexEndpointServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<aiplatform_v1::IndexEndpointServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

IndexEndpointServiceConnectionImpl::IndexEndpointServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<aiplatform_v1_internal::IndexEndpointServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), IndexEndpointServiceConnection::options())) {}

future<StatusOr<google::cloud::aiplatform::v1::IndexEndpoint>>
IndexEndpointServiceConnectionImpl::CreateIndexEndpoint(
    google::cloud::aiplatform::v1::CreateIndexEndpointRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::IndexEndpoint>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::CreateIndexEndpointRequest const&
              request) {
        return stub->AsyncCreateIndexEndpoint(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::IndexEndpoint>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateIndexEndpoint(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::aiplatform::v1::IndexEndpoint>
IndexEndpointServiceConnectionImpl::GetIndexEndpoint(
    google::cloud::aiplatform::v1::GetIndexEndpointRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIndexEndpoint(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::GetIndexEndpointRequest const&
                 request) { return stub_->GetIndexEndpoint(context, request); },
      request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::IndexEndpoint>
IndexEndpointServiceConnectionImpl::ListIndexEndpoints(
    google::cloud::aiplatform::v1::ListIndexEndpointsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListIndexEndpoints(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::IndexEndpoint>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<aiplatform_v1::IndexEndpointServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListIndexEndpointsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::aiplatform::v1::ListIndexEndpointsRequest const&
                    request) {
              return stub->ListIndexEndpoints(context, request);
            },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListIndexEndpointsResponse r) {
        std::vector<google::cloud::aiplatform::v1::IndexEndpoint> result(
            r.index_endpoints().size());
        auto& messages = *r.mutable_index_endpoints();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::aiplatform::v1::IndexEndpoint>
IndexEndpointServiceConnectionImpl::UpdateIndexEndpoint(
    google::cloud::aiplatform::v1::UpdateIndexEndpointRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateIndexEndpoint(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::UpdateIndexEndpointRequest const&
                 request) {
        return stub_->UpdateIndexEndpoint(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
IndexEndpointServiceConnectionImpl::DeleteIndexEndpoint(
    google::cloud::aiplatform::v1::DeleteIndexEndpointRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::DeleteOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::DeleteIndexEndpointRequest const&
              request) {
        return stub->AsyncDeleteIndexEndpoint(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::aiplatform::v1::DeleteOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteIndexEndpoint(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::DeployIndexResponse>>
IndexEndpointServiceConnectionImpl::DeployIndex(
    google::cloud::aiplatform::v1::DeployIndexRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::DeployIndexResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::DeployIndexRequest const& request) {
        return stub->AsyncDeployIndex(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::DeployIndexResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeployIndex(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::UndeployIndexResponse>>
IndexEndpointServiceConnectionImpl::UndeployIndex(
    google::cloud::aiplatform::v1::UndeployIndexRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::UndeployIndexResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::UndeployIndexRequest const& request) {
        return stub->AsyncUndeployIndex(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::UndeployIndexResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UndeployIndex(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::MutateDeployedIndexResponse>>
IndexEndpointServiceConnectionImpl::MutateDeployedIndex(
    google::cloud::aiplatform::v1::MutateDeployedIndexRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::MutateDeployedIndexResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::MutateDeployedIndexRequest const&
              request) {
        return stub->AsyncMutateDeployedIndex(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::MutateDeployedIndexResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->MutateDeployedIndex(request),
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
