// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/metric_service.proto

package monitoring

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	metric "google.golang.org/genproto/googleapis/api/metric"
	monitoredres "google.golang.org/genproto/googleapis/api/monitoredres"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Controls which fields are returned by `ListTimeSeries`.
type ListTimeSeriesRequest_TimeSeriesView int32

const (
	// Returns the identity of the metric(s), the time series,
	// and the time series data.
	ListTimeSeriesRequest_FULL ListTimeSeriesRequest_TimeSeriesView = 0
	// Returns the identity of the metric and the time series resource,
	// but not the time series data.
	ListTimeSeriesRequest_HEADERS ListTimeSeriesRequest_TimeSeriesView = 1
)

var ListTimeSeriesRequest_TimeSeriesView_name = map[int32]string{
	0: "FULL",
	1: "HEADERS",
}

var ListTimeSeriesRequest_TimeSeriesView_value = map[string]int32{
	"FULL":    0,
	"HEADERS": 1,
}

func (x ListTimeSeriesRequest_TimeSeriesView) String() string {
	return proto.EnumName(ListTimeSeriesRequest_TimeSeriesView_name, int32(x))
}

func (ListTimeSeriesRequest_TimeSeriesView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{8, 0}
}

// The `ListMonitoredResourceDescriptors` request.
type ListMonitoredResourceDescriptorsRequest struct {
	// Required. The project on which to execute the request. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// An optional [filter](https://cloud.google.com/monitoring/api/v3/filters)
	// describing the descriptors to be returned.  The filter can reference the
	// descriptor's type and labels. For example, the following filter returns
	// only Google Compute Engine descriptors that have an `id` label:
	//
	//     resource.type = starts_with("gce_") AND resource.label:id
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// A positive number that is the maximum number of results to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If this field is not empty then it must contain the `nextPageToken` value
	// returned by a previous call to this method.  Using this field causes the
	// method to return additional results from the previous method call.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMonitoredResourceDescriptorsRequest) Reset() {
	*m = ListMonitoredResourceDescriptorsRequest{}
}
func (m *ListMonitoredResourceDescriptorsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsRequest) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{0}
}

func (m *ListMonitoredResourceDescriptorsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Unmarshal(m, b)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Marshal(b, m, deterministic)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Merge(m, src)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_Size() int {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Size(m)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMonitoredResourceDescriptorsRequest proto.InternalMessageInfo

func (m *ListMonitoredResourceDescriptorsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListMonitoredResourceDescriptorsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListMonitoredResourceDescriptorsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListMonitoredResourceDescriptorsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The `ListMonitoredResourceDescriptors` response.
type ListMonitoredResourceDescriptorsResponse struct {
	// The monitored resource descriptors that are available to this project
	// and that match `filter`, if present.
	ResourceDescriptors []*monitoredres.MonitoredResourceDescriptor `protobuf:"bytes,1,rep,name=resource_descriptors,json=resourceDescriptors,proto3" json:"resource_descriptors,omitempty"`
	// If there are more results than have been returned, then this field is set
	// to a non-empty value.  To see the additional results,
	// use that value as `page_token` in the next call to this method.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMonitoredResourceDescriptorsResponse) Reset() {
	*m = ListMonitoredResourceDescriptorsResponse{}
}
func (m *ListMonitoredResourceDescriptorsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsResponse) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{1}
}

func (m *ListMonitoredResourceDescriptorsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Unmarshal(m, b)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Marshal(b, m, deterministic)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Merge(m, src)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_Size() int {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Size(m)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMonitoredResourceDescriptorsResponse proto.InternalMessageInfo

func (m *ListMonitoredResourceDescriptorsResponse) GetResourceDescriptors() []*monitoredres.MonitoredResourceDescriptor {
	if m != nil {
		return m.ResourceDescriptors
	}
	return nil
}

func (m *ListMonitoredResourceDescriptorsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The `GetMonitoredResourceDescriptor` request.
type GetMonitoredResourceDescriptorRequest struct {
	// Required. The monitored resource descriptor to get.  The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/monitoredResourceDescriptors/[RESOURCE_TYPE]
	//
	// The `[RESOURCE_TYPE]` is a predefined type, such as
	// `cloudsql_database`.
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMonitoredResourceDescriptorRequest) Reset()         { *m = GetMonitoredResourceDescriptorRequest{} }
func (m *GetMonitoredResourceDescriptorRequest) String() string { return proto.CompactTextString(m) }
func (*GetMonitoredResourceDescriptorRequest) ProtoMessage()    {}
func (*GetMonitoredResourceDescriptorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{2}
}

func (m *GetMonitoredResourceDescriptorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMonitoredResourceDescriptorRequest.Unmarshal(m, b)
}
func (m *GetMonitoredResourceDescriptorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMonitoredResourceDescriptorRequest.Marshal(b, m, deterministic)
}
func (m *GetMonitoredResourceDescriptorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMonitoredResourceDescriptorRequest.Merge(m, src)
}
func (m *GetMonitoredResourceDescriptorRequest) XXX_Size() int {
	return xxx_messageInfo_GetMonitoredResourceDescriptorRequest.Size(m)
}
func (m *GetMonitoredResourceDescriptorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMonitoredResourceDescriptorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMonitoredResourceDescriptorRequest proto.InternalMessageInfo

func (m *GetMonitoredResourceDescriptorRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The `ListMetricDescriptors` request.
type ListMetricDescriptorsRequest struct {
	// Required. The project on which to execute the request. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// If this field is empty, all custom and
	// system-defined metric descriptors are returned.
	// Otherwise, the [filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifies which metric descriptors are to be
	// returned. For example, the following filter matches all
	// [custom metrics](https://cloud.google.com/monitoring/custom-metrics):
	//
	//     metric.type = starts_with("custom.googleapis.com/")
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// A positive number that is the maximum number of results to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If this field is not empty then it must contain the `nextPageToken` value
	// returned by a previous call to this method.  Using this field causes the
	// method to return additional results from the previous method call.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMetricDescriptorsRequest) Reset()         { *m = ListMetricDescriptorsRequest{} }
func (m *ListMetricDescriptorsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMetricDescriptorsRequest) ProtoMessage()    {}
func (*ListMetricDescriptorsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{3}
}

func (m *ListMetricDescriptorsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMetricDescriptorsRequest.Unmarshal(m, b)
}
func (m *ListMetricDescriptorsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMetricDescriptorsRequest.Marshal(b, m, deterministic)
}
func (m *ListMetricDescriptorsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMetricDescriptorsRequest.Merge(m, src)
}
func (m *ListMetricDescriptorsRequest) XXX_Size() int {
	return xxx_messageInfo_ListMetricDescriptorsRequest.Size(m)
}
func (m *ListMetricDescriptorsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMetricDescriptorsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMetricDescriptorsRequest proto.InternalMessageInfo

func (m *ListMetricDescriptorsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListMetricDescriptorsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListMetricDescriptorsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListMetricDescriptorsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The `ListMetricDescriptors` response.
type ListMetricDescriptorsResponse struct {
	// The metric descriptors that are available to the project
	// and that match the value of `filter`, if present.
	MetricDescriptors []*metric.MetricDescriptor `protobuf:"bytes,1,rep,name=metric_descriptors,json=metricDescriptors,proto3" json:"metric_descriptors,omitempty"`
	// If there are more results than have been returned, then this field is set
	// to a non-empty value.  To see the additional results,
	// use that value as `page_token` in the next call to this method.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMetricDescriptorsResponse) Reset()         { *m = ListMetricDescriptorsResponse{} }
func (m *ListMetricDescriptorsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMetricDescriptorsResponse) ProtoMessage()    {}
func (*ListMetricDescriptorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{4}
}

func (m *ListMetricDescriptorsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMetricDescriptorsResponse.Unmarshal(m, b)
}
func (m *ListMetricDescriptorsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMetricDescriptorsResponse.Marshal(b, m, deterministic)
}
func (m *ListMetricDescriptorsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMetricDescriptorsResponse.Merge(m, src)
}
func (m *ListMetricDescriptorsResponse) XXX_Size() int {
	return xxx_messageInfo_ListMetricDescriptorsResponse.Size(m)
}
func (m *ListMetricDescriptorsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMetricDescriptorsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMetricDescriptorsResponse proto.InternalMessageInfo

func (m *ListMetricDescriptorsResponse) GetMetricDescriptors() []*metric.MetricDescriptor {
	if m != nil {
		return m.MetricDescriptors
	}
	return nil
}

func (m *ListMetricDescriptorsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The `GetMetricDescriptor` request.
type GetMetricDescriptorRequest struct {
	// Required. The metric descriptor on which to execute the request. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/metricDescriptors/[METRIC_ID]
	//
	// An example value of `[METRIC_ID]` is
	// `"compute.googleapis.com/instance/disk/read_bytes_count"`.
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMetricDescriptorRequest) Reset()         { *m = GetMetricDescriptorRequest{} }
func (m *GetMetricDescriptorRequest) String() string { return proto.CompactTextString(m) }
func (*GetMetricDescriptorRequest) ProtoMessage()    {}
func (*GetMetricDescriptorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{5}
}

func (m *GetMetricDescriptorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMetricDescriptorRequest.Unmarshal(m, b)
}
func (m *GetMetricDescriptorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMetricDescriptorRequest.Marshal(b, m, deterministic)
}
func (m *GetMetricDescriptorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMetricDescriptorRequest.Merge(m, src)
}
func (m *GetMetricDescriptorRequest) XXX_Size() int {
	return xxx_messageInfo_GetMetricDescriptorRequest.Size(m)
}
func (m *GetMetricDescriptorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMetricDescriptorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMetricDescriptorRequest proto.InternalMessageInfo

func (m *GetMetricDescriptorRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The `CreateMetricDescriptor` request.
type CreateMetricDescriptorRequest struct {
	// Required. The project on which to execute the request. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new [custom metric](https://cloud.google.com/monitoring/custom-metrics)
	// descriptor.
	MetricDescriptor     *metric.MetricDescriptor `protobuf:"bytes,2,opt,name=metric_descriptor,json=metricDescriptor,proto3" json:"metric_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CreateMetricDescriptorRequest) Reset()         { *m = CreateMetricDescriptorRequest{} }
func (m *CreateMetricDescriptorRequest) String() string { return proto.CompactTextString(m) }
func (*CreateMetricDescriptorRequest) ProtoMessage()    {}
func (*CreateMetricDescriptorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{6}
}

func (m *CreateMetricDescriptorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMetricDescriptorRequest.Unmarshal(m, b)
}
func (m *CreateMetricDescriptorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMetricDescriptorRequest.Marshal(b, m, deterministic)
}
func (m *CreateMetricDescriptorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMetricDescriptorRequest.Merge(m, src)
}
func (m *CreateMetricDescriptorRequest) XXX_Size() int {
	return xxx_messageInfo_CreateMetricDescriptorRequest.Size(m)
}
func (m *CreateMetricDescriptorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMetricDescriptorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMetricDescriptorRequest proto.InternalMessageInfo

func (m *CreateMetricDescriptorRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateMetricDescriptorRequest) GetMetricDescriptor() *metric.MetricDescriptor {
	if m != nil {
		return m.MetricDescriptor
	}
	return nil
}

// The `DeleteMetricDescriptor` request.
type DeleteMetricDescriptorRequest struct {
	// Required. The metric descriptor on which to execute the request. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/metricDescriptors/[METRIC_ID]
	//
	// An example of `[METRIC_ID]` is:
	// `"custom.googleapis.com/my_test_metric"`.
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteMetricDescriptorRequest) Reset()         { *m = DeleteMetricDescriptorRequest{} }
func (m *DeleteMetricDescriptorRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteMetricDescriptorRequest) ProtoMessage()    {}
func (*DeleteMetricDescriptorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{7}
}

func (m *DeleteMetricDescriptorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteMetricDescriptorRequest.Unmarshal(m, b)
}
func (m *DeleteMetricDescriptorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteMetricDescriptorRequest.Marshal(b, m, deterministic)
}
func (m *DeleteMetricDescriptorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteMetricDescriptorRequest.Merge(m, src)
}
func (m *DeleteMetricDescriptorRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteMetricDescriptorRequest.Size(m)
}
func (m *DeleteMetricDescriptorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteMetricDescriptorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteMetricDescriptorRequest proto.InternalMessageInfo

func (m *DeleteMetricDescriptorRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The `ListTimeSeries` request.
type ListTimeSeriesRequest struct {
	// Required. The project on which to execute the request. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	Name string `protobuf:"bytes,10,opt,name=name,proto3" json:"name,omitempty"`
	// Required. A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// that specifies which time series should be returned.  The filter must
	// specify a single metric type, and can additionally specify metric labels
	// and other information. For example:
	//
	//     metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
	//         metric.labels.instance_name = "my-instance-name"
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. The time interval for which results should be returned. Only time series
	// that contain data points in the specified interval are included
	// in the response.
	Interval *TimeInterval `protobuf:"bytes,4,opt,name=interval,proto3" json:"interval,omitempty"`
	// Specifies the alignment of data points in individual time series as
	// well as how to combine the retrieved time series across specified labels.
	//
	// By default (if no `aggregation` is explicitly specified), the raw time
	// series data is returned.
	Aggregation *Aggregation `protobuf:"bytes,5,opt,name=aggregation,proto3" json:"aggregation,omitempty"`
	// Unsupported: must be left blank. The points in each time series are
	// currently returned in reverse time order (most recent to oldest).
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Required. Specifies which information is returned about the time series.
	View ListTimeSeriesRequest_TimeSeriesView `protobuf:"varint,7,opt,name=view,proto3,enum=google.monitoring.v3.ListTimeSeriesRequest_TimeSeriesView" json:"view,omitempty"`
	// A positive number that is the maximum number of results to return. If
	// `page_size` is empty or more than 100,000 results, the effective
	// `page_size` is 100,000 results. If `view` is set to `FULL`, this is the
	// maximum number of `Points` returned. If `view` is set to `HEADERS`, this is
	// the maximum number of `TimeSeries` returned.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If this field is not empty then it must contain the `nextPageToken` value
	// returned by a previous call to this method.  Using this field causes the
	// method to return additional results from the previous method call.
	PageToken            string   `protobuf:"bytes,9,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTimeSeriesRequest) Reset()         { *m = ListTimeSeriesRequest{} }
func (m *ListTimeSeriesRequest) String() string { return proto.CompactTextString(m) }
func (*ListTimeSeriesRequest) ProtoMessage()    {}
func (*ListTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{8}
}

func (m *ListTimeSeriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTimeSeriesRequest.Unmarshal(m, b)
}
func (m *ListTimeSeriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTimeSeriesRequest.Marshal(b, m, deterministic)
}
func (m *ListTimeSeriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTimeSeriesRequest.Merge(m, src)
}
func (m *ListTimeSeriesRequest) XXX_Size() int {
	return xxx_messageInfo_ListTimeSeriesRequest.Size(m)
}
func (m *ListTimeSeriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTimeSeriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTimeSeriesRequest proto.InternalMessageInfo

func (m *ListTimeSeriesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListTimeSeriesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListTimeSeriesRequest) GetInterval() *TimeInterval {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *ListTimeSeriesRequest) GetAggregation() *Aggregation {
	if m != nil {
		return m.Aggregation
	}
	return nil
}

func (m *ListTimeSeriesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListTimeSeriesRequest) GetView() ListTimeSeriesRequest_TimeSeriesView {
	if m != nil {
		return m.View
	}
	return ListTimeSeriesRequest_FULL
}

func (m *ListTimeSeriesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTimeSeriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The `ListTimeSeries` response.
type ListTimeSeriesResponse struct {
	// One or more time series that match the filter included in the request.
	TimeSeries []*TimeSeries `protobuf:"bytes,1,rep,name=time_series,json=timeSeries,proto3" json:"time_series,omitempty"`
	// If there are more results than have been returned, then this field is set
	// to a non-empty value.  To see the additional results,
	// use that value as `page_token` in the next call to this method.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Query execution errors that may have caused the time series data returned
	// to be incomplete.
	ExecutionErrors      []*status.Status `protobuf:"bytes,3,rep,name=execution_errors,json=executionErrors,proto3" json:"execution_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ListTimeSeriesResponse) Reset()         { *m = ListTimeSeriesResponse{} }
func (m *ListTimeSeriesResponse) String() string { return proto.CompactTextString(m) }
func (*ListTimeSeriesResponse) ProtoMessage()    {}
func (*ListTimeSeriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{9}
}

func (m *ListTimeSeriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTimeSeriesResponse.Unmarshal(m, b)
}
func (m *ListTimeSeriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTimeSeriesResponse.Marshal(b, m, deterministic)
}
func (m *ListTimeSeriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTimeSeriesResponse.Merge(m, src)
}
func (m *ListTimeSeriesResponse) XXX_Size() int {
	return xxx_messageInfo_ListTimeSeriesResponse.Size(m)
}
func (m *ListTimeSeriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTimeSeriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTimeSeriesResponse proto.InternalMessageInfo

func (m *ListTimeSeriesResponse) GetTimeSeries() []*TimeSeries {
	if m != nil {
		return m.TimeSeries
	}
	return nil
}

func (m *ListTimeSeriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListTimeSeriesResponse) GetExecutionErrors() []*status.Status {
	if m != nil {
		return m.ExecutionErrors
	}
	return nil
}

// The `CreateTimeSeries` request.
type CreateTimeSeriesRequest struct {
	// Required. The project on which to execute the request. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new data to be added to a list of time series.
	// Adds at most one data point to each of several time series.  The new data
	// point must be more recent than any other point in its time series.  Each
	// `TimeSeries` value must fully specify a unique time series by supplying
	// all label values for the metric and the monitored resource.
	//
	// The maximum number of `TimeSeries` objects per `Create` request is 200.
	TimeSeries           []*TimeSeries `protobuf:"bytes,2,rep,name=time_series,json=timeSeries,proto3" json:"time_series,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateTimeSeriesRequest) Reset()         { *m = CreateTimeSeriesRequest{} }
func (m *CreateTimeSeriesRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTimeSeriesRequest) ProtoMessage()    {}
func (*CreateTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{10}
}

func (m *CreateTimeSeriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTimeSeriesRequest.Unmarshal(m, b)
}
func (m *CreateTimeSeriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTimeSeriesRequest.Marshal(b, m, deterministic)
}
func (m *CreateTimeSeriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTimeSeriesRequest.Merge(m, src)
}
func (m *CreateTimeSeriesRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTimeSeriesRequest.Size(m)
}
func (m *CreateTimeSeriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTimeSeriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTimeSeriesRequest proto.InternalMessageInfo

func (m *CreateTimeSeriesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateTimeSeriesRequest) GetTimeSeries() []*TimeSeries {
	if m != nil {
		return m.TimeSeries
	}
	return nil
}

// DEPRECATED. Used to hold per-time-series error status.
type CreateTimeSeriesError struct {
	// DEPRECATED. Time series ID that resulted in the `status` error.
	TimeSeries *TimeSeries `protobuf:"bytes,1,opt,name=time_series,json=timeSeries,proto3" json:"time_series,omitempty"` // Deprecated: Do not use.
	// DEPRECATED. The status of the requested write operation for `time_series`.
	Status               *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CreateTimeSeriesError) Reset()         { *m = CreateTimeSeriesError{} }
func (m *CreateTimeSeriesError) String() string { return proto.CompactTextString(m) }
func (*CreateTimeSeriesError) ProtoMessage()    {}
func (*CreateTimeSeriesError) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{11}
}

func (m *CreateTimeSeriesError) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTimeSeriesError.Unmarshal(m, b)
}
func (m *CreateTimeSeriesError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTimeSeriesError.Marshal(b, m, deterministic)
}
func (m *CreateTimeSeriesError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTimeSeriesError.Merge(m, src)
}
func (m *CreateTimeSeriesError) XXX_Size() int {
	return xxx_messageInfo_CreateTimeSeriesError.Size(m)
}
func (m *CreateTimeSeriesError) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTimeSeriesError.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTimeSeriesError proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *CreateTimeSeriesError) GetTimeSeries() *TimeSeries {
	if m != nil {
		return m.TimeSeries
	}
	return nil
}

// Deprecated: Do not use.
func (m *CreateTimeSeriesError) GetStatus() *status.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// Summary of the result of a failed request to write data to a time series.
type CreateTimeSeriesSummary struct {
	// The number of points in the request.
	TotalPointCount int32 `protobuf:"varint,1,opt,name=total_point_count,json=totalPointCount,proto3" json:"total_point_count,omitempty"`
	// The number of points that were successfully written.
	SuccessPointCount int32 `protobuf:"varint,2,opt,name=success_point_count,json=successPointCount,proto3" json:"success_point_count,omitempty"`
	// The number of points that failed to be written. Order is not guaranteed.
	Errors               []*CreateTimeSeriesSummary_Error `protobuf:"bytes,3,rep,name=errors,proto3" json:"errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *CreateTimeSeriesSummary) Reset()         { *m = CreateTimeSeriesSummary{} }
func (m *CreateTimeSeriesSummary) String() string { return proto.CompactTextString(m) }
func (*CreateTimeSeriesSummary) ProtoMessage()    {}
func (*CreateTimeSeriesSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{12}
}

func (m *CreateTimeSeriesSummary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTimeSeriesSummary.Unmarshal(m, b)
}
func (m *CreateTimeSeriesSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTimeSeriesSummary.Marshal(b, m, deterministic)
}
func (m *CreateTimeSeriesSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTimeSeriesSummary.Merge(m, src)
}
func (m *CreateTimeSeriesSummary) XXX_Size() int {
	return xxx_messageInfo_CreateTimeSeriesSummary.Size(m)
}
func (m *CreateTimeSeriesSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTimeSeriesSummary.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTimeSeriesSummary proto.InternalMessageInfo

func (m *CreateTimeSeriesSummary) GetTotalPointCount() int32 {
	if m != nil {
		return m.TotalPointCount
	}
	return 0
}

func (m *CreateTimeSeriesSummary) GetSuccessPointCount() int32 {
	if m != nil {
		return m.SuccessPointCount
	}
	return 0
}

func (m *CreateTimeSeriesSummary) GetErrors() []*CreateTimeSeriesSummary_Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

// Detailed information about an error category.
type CreateTimeSeriesSummary_Error struct {
	// The status of the requested write operation.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// The number of points that couldn't be written because of `status`.
	PointCount           int32    `protobuf:"varint,2,opt,name=point_count,json=pointCount,proto3" json:"point_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTimeSeriesSummary_Error) Reset()         { *m = CreateTimeSeriesSummary_Error{} }
func (m *CreateTimeSeriesSummary_Error) String() string { return proto.CompactTextString(m) }
func (*CreateTimeSeriesSummary_Error) ProtoMessage()    {}
func (*CreateTimeSeriesSummary_Error) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{12, 0}
}

func (m *CreateTimeSeriesSummary_Error) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTimeSeriesSummary_Error.Unmarshal(m, b)
}
func (m *CreateTimeSeriesSummary_Error) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTimeSeriesSummary_Error.Marshal(b, m, deterministic)
}
func (m *CreateTimeSeriesSummary_Error) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTimeSeriesSummary_Error.Merge(m, src)
}
func (m *CreateTimeSeriesSummary_Error) XXX_Size() int {
	return xxx_messageInfo_CreateTimeSeriesSummary_Error.Size(m)
}
func (m *CreateTimeSeriesSummary_Error) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTimeSeriesSummary_Error.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTimeSeriesSummary_Error proto.InternalMessageInfo

func (m *CreateTimeSeriesSummary_Error) GetStatus() *status.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *CreateTimeSeriesSummary_Error) GetPointCount() int32 {
	if m != nil {
		return m.PointCount
	}
	return 0
}

// The `QueryTimeSeries` request.
type QueryTimeSeriesRequest struct {
	// Required. The project on which to execute the request. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The query in the monitoring query language format. The default
	// time zone is in UTC.
	Query string `protobuf:"bytes,7,opt,name=query,proto3" json:"query,omitempty"`
	// A positive number that is the maximum number of time_series_data to return.
	PageSize int32 `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If this field is not empty then it must contain the `nextPageToken` value
	// returned by a previous call to this method.  Using this field causes the
	// method to return additional results from the previous method call.
	PageToken            string   `protobuf:"bytes,10,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryTimeSeriesRequest) Reset()         { *m = QueryTimeSeriesRequest{} }
func (m *QueryTimeSeriesRequest) String() string { return proto.CompactTextString(m) }
func (*QueryTimeSeriesRequest) ProtoMessage()    {}
func (*QueryTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{13}
}

func (m *QueryTimeSeriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryTimeSeriesRequest.Unmarshal(m, b)
}
func (m *QueryTimeSeriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryTimeSeriesRequest.Marshal(b, m, deterministic)
}
func (m *QueryTimeSeriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTimeSeriesRequest.Merge(m, src)
}
func (m *QueryTimeSeriesRequest) XXX_Size() int {
	return xxx_messageInfo_QueryTimeSeriesRequest.Size(m)
}
func (m *QueryTimeSeriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTimeSeriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTimeSeriesRequest proto.InternalMessageInfo

func (m *QueryTimeSeriesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *QueryTimeSeriesRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *QueryTimeSeriesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *QueryTimeSeriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The `QueryTimeSeries` response.
type QueryTimeSeriesResponse struct {
	// The descriptor for the time series data.
	TimeSeriesDescriptor *TimeSeriesDescriptor `protobuf:"bytes,8,opt,name=time_series_descriptor,json=timeSeriesDescriptor,proto3" json:"time_series_descriptor,omitempty"`
	// The time series data.
	TimeSeriesData []*TimeSeriesData `protobuf:"bytes,9,rep,name=time_series_data,json=timeSeriesData,proto3" json:"time_series_data,omitempty"`
	// If there are more results than have been returned, then this field is set
	// to a non-empty value.  To see the additional results, use that value as
	// `page_token` in the next call to this method.
	NextPageToken string `protobuf:"bytes,10,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Query execution errors that may have caused the time series data returned
	// to be incomplete. The available data will be available in the
	// response.
	PartialErrors        []*status.Status `protobuf:"bytes,11,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *QueryTimeSeriesResponse) Reset()         { *m = QueryTimeSeriesResponse{} }
func (m *QueryTimeSeriesResponse) String() string { return proto.CompactTextString(m) }
func (*QueryTimeSeriesResponse) ProtoMessage()    {}
func (*QueryTimeSeriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{14}
}

func (m *QueryTimeSeriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryTimeSeriesResponse.Unmarshal(m, b)
}
func (m *QueryTimeSeriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryTimeSeriesResponse.Marshal(b, m, deterministic)
}
func (m *QueryTimeSeriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTimeSeriesResponse.Merge(m, src)
}
func (m *QueryTimeSeriesResponse) XXX_Size() int {
	return xxx_messageInfo_QueryTimeSeriesResponse.Size(m)
}
func (m *QueryTimeSeriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTimeSeriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTimeSeriesResponse proto.InternalMessageInfo

func (m *QueryTimeSeriesResponse) GetTimeSeriesDescriptor() *TimeSeriesDescriptor {
	if m != nil {
		return m.TimeSeriesDescriptor
	}
	return nil
}

func (m *QueryTimeSeriesResponse) GetTimeSeriesData() []*TimeSeriesData {
	if m != nil {
		return m.TimeSeriesData
	}
	return nil
}

func (m *QueryTimeSeriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *QueryTimeSeriesResponse) GetPartialErrors() []*status.Status {
	if m != nil {
		return m.PartialErrors
	}
	return nil
}

// This is an error detail intended to be used with INVALID_ARGUMENT errors.
type QueryErrorList struct {
	// Errors in parsing the time series query language text. The number of errors
	// in the response may be limited.
	Errors []*QueryError `protobuf:"bytes,1,rep,name=errors,proto3" json:"errors,omitempty"`
	// A summary of all the errors.
	ErrorSummary         string   `protobuf:"bytes,2,opt,name=error_summary,json=errorSummary,proto3" json:"error_summary,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryErrorList) Reset()         { *m = QueryErrorList{} }
func (m *QueryErrorList) String() string { return proto.CompactTextString(m) }
func (*QueryErrorList) ProtoMessage()    {}
func (*QueryErrorList) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b3d47b45a293957, []int{15}
}

func (m *QueryErrorList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryErrorList.Unmarshal(m, b)
}
func (m *QueryErrorList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryErrorList.Marshal(b, m, deterministic)
}
func (m *QueryErrorList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryErrorList.Merge(m, src)
}
func (m *QueryErrorList) XXX_Size() int {
	return xxx_messageInfo_QueryErrorList.Size(m)
}
func (m *QueryErrorList) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryErrorList.DiscardUnknown(m)
}

var xxx_messageInfo_QueryErrorList proto.InternalMessageInfo

func (m *QueryErrorList) GetErrors() []*QueryError {
	if m != nil {
		return m.Errors
	}
	return nil
}

func (m *QueryErrorList) GetErrorSummary() string {
	if m != nil {
		return m.ErrorSummary
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.monitoring.v3.ListTimeSeriesRequest_TimeSeriesView", ListTimeSeriesRequest_TimeSeriesView_name, ListTimeSeriesRequest_TimeSeriesView_value)
	proto.RegisterType((*ListMonitoredResourceDescriptorsRequest)(nil), "google.monitoring.v3.ListMonitoredResourceDescriptorsRequest")
	proto.RegisterType((*ListMonitoredResourceDescriptorsResponse)(nil), "google.monitoring.v3.ListMonitoredResourceDescriptorsResponse")
	proto.RegisterType((*GetMonitoredResourceDescriptorRequest)(nil), "google.monitoring.v3.GetMonitoredResourceDescriptorRequest")
	proto.RegisterType((*ListMetricDescriptorsRequest)(nil), "google.monitoring.v3.ListMetricDescriptorsRequest")
	proto.RegisterType((*ListMetricDescriptorsResponse)(nil), "google.monitoring.v3.ListMetricDescriptorsResponse")
	proto.RegisterType((*GetMetricDescriptorRequest)(nil), "google.monitoring.v3.GetMetricDescriptorRequest")
	proto.RegisterType((*CreateMetricDescriptorRequest)(nil), "google.monitoring.v3.CreateMetricDescriptorRequest")
	proto.RegisterType((*DeleteMetricDescriptorRequest)(nil), "google.monitoring.v3.DeleteMetricDescriptorRequest")
	proto.RegisterType((*ListTimeSeriesRequest)(nil), "google.monitoring.v3.ListTimeSeriesRequest")
	proto.RegisterType((*ListTimeSeriesResponse)(nil), "google.monitoring.v3.ListTimeSeriesResponse")
	proto.RegisterType((*CreateTimeSeriesRequest)(nil), "google.monitoring.v3.CreateTimeSeriesRequest")
	proto.RegisterType((*CreateTimeSeriesError)(nil), "google.monitoring.v3.CreateTimeSeriesError")
	proto.RegisterType((*CreateTimeSeriesSummary)(nil), "google.monitoring.v3.CreateTimeSeriesSummary")
	proto.RegisterType((*CreateTimeSeriesSummary_Error)(nil), "google.monitoring.v3.CreateTimeSeriesSummary.Error")
	proto.RegisterType((*QueryTimeSeriesRequest)(nil), "google.monitoring.v3.QueryTimeSeriesRequest")
	proto.RegisterType((*QueryTimeSeriesResponse)(nil), "google.monitoring.v3.QueryTimeSeriesResponse")
	proto.RegisterType((*QueryErrorList)(nil), "google.monitoring.v3.QueryErrorList")
}

func init() {
	proto.RegisterFile("google/monitoring/v3/metric_service.proto", fileDescriptor_7b3d47b45a293957)
}

var fileDescriptor_7b3d47b45a293957 = []byte{
	// 1650 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xcd, 0x73, 0xdb, 0x44,
	0x14, 0x67, 0xed, 0x24, 0x4d, 0x9e, 0x49, 0x9a, 0x6c, 0x53, 0xd7, 0x71, 0x9b, 0xd6, 0x55, 0x29,
	0x49, 0xdd, 0x54, 0x62, 0x6c, 0x4a, 0xa9, 0x4b, 0x3a, 0xe3, 0x7c, 0xb4, 0x30, 0xfd, 0x20, 0x75,
	0x4a, 0x66, 0x28, 0x9d, 0x31, 0x8a, 0xbd, 0x71, 0x05, 0xd6, 0x47, 0x57, 0xeb, 0xa4, 0x49, 0xa6,
	0x1c, 0xf8, 0x03, 0xb8, 0xc0, 0x01, 0x6e, 0x9c, 0x7b, 0x60, 0x86, 0x53, 0x99, 0x1e, 0x38, 0x70,
	0x62, 0x3a, 0x1c, 0x18, 0xb8, 0x65, 0x38, 0xf4, 0xd0, 0x53, 0x4f, 0x5c, 0xe1, 0xc4, 0x68, 0x25,
	0xd9, 0x92, 0x2c, 0xcb, 0x76, 0x32, 0xdc, 0xa4, 0x7d, 0x6f, 0xdf, 0xfe, 0xde, 0xef, 0x7d, 0xec,
	0x93, 0xe0, 0x5c, 0x4d, 0xd7, 0x6b, 0x75, 0x22, 0xa9, 0xba, 0xa6, 0x30, 0x9d, 0x2a, 0x5a, 0x4d,
	0xda, 0xcc, 0x4b, 0x2a, 0x61, 0x54, 0xa9, 0x94, 0x4d, 0x42, 0x37, 0x95, 0x0a, 0x11, 0x0d, 0xaa,
	0x33, 0x1d, 0x4f, 0xda, 0xaa, 0x62, 0x4b, 0x55, 0xdc, 0xcc, 0xa7, 0x4f, 0x38, 0x06, 0x64, 0x43,
	0x91, 0x64, 0x4d, 0xd3, 0x99, 0xcc, 0x14, 0x5d, 0x33, 0xed, 0x3d, 0xe9, 0x63, 0x1e, 0x69, 0xa5,
	0xae, 0x10, 0x8d, 0x39, 0x82, 0x53, 0x1e, 0xc1, 0x86, 0x42, 0xea, 0xd5, 0xf2, 0x3a, 0x79, 0x20,
	0x6f, 0x2a, 0x3a, 0x0d, 0xd9, 0x69, 0xc3, 0x71, 0x04, 0x67, 0xbc, 0x02, 0x1b, 0x0a, 0xa9, 0x96,
	0x29, 0x31, 0xf5, 0x06, 0x75, 0xb1, 0xa6, 0xa7, 0x3c, 0x4a, 0x01, 0x51, 0x26, 0xd4, 0x63, 0xb9,
	0x4e, 0xa8, 0x8b, 0xed, 0x74, 0xa8, 0x46, 0x45, 0x57, 0x55, 0x5d, 0x8b, 0x54, 0xf1, 0xe1, 0x3c,
	0xe9, 0xa8, 0xf0, 0xb7, 0xf5, 0xc6, 0x86, 0x54, 0x6d, 0x50, 0xce, 0x8d, 0x23, 0x3f, 0x1e, 0x94,
	0x13, 0xd5, 0x60, 0xdb, 0x01, 0xef, 0xa9, 0x51, 0x91, 0x4c, 0x26, 0xb3, 0x86, 0x43, 0xa8, 0xf0,
	0x3b, 0x82, 0x99, 0x9b, 0x8a, 0xc9, 0x6e, 0xb9, 0x9e, 0x97, 0x1c, 0xef, 0x96, 0x88, 0x59, 0xa1,
	0x8a, 0xc1, 0x74, 0x6a, 0x96, 0xc8, 0xc3, 0x06, 0x31, 0x19, 0xbe, 0x03, 0x03, 0x9a, 0xac, 0x92,
	0xd4, 0x60, 0x06, 0xcd, 0x8e, 0x2c, 0xcc, 0xbf, 0x28, 0xc6, 0xfe, 0x2d, 0x5e, 0xc2, 0x17, 0x3d,
	0xf1, 0xb3, 0x4f, 0x91, 0x0d, 0xc5, 0x14, 0x2b, 0xba, 0x2a, 0x45, 0x18, 0x2d, 0x71, 0x53, 0x38,
	0x09, 0x43, 0x1b, 0x4a, 0x9d, 0x11, 0x9a, 0x8a, 0x59, 0x46, 0x4b, 0xce, 0x1b, 0x3e, 0x0e, 0x23,
	0x86, 0x5c, 0x23, 0x65, 0x53, 0xd9, 0x21, 0xa9, 0x78, 0x06, 0xcd, 0x0e, 0x96, 0x86, 0xad, 0x85,
	0x55, 0x65, 0x87, 0xe0, 0x69, 0x00, 0x2e, 0x64, 0xfa, 0xe7, 0x44, 0x4b, 0x0d, 0xf0, 0x8d, 0x5c,
	0xfd, 0xae, 0xb5, 0x20, 0xfc, 0x80, 0x60, 0xb6, 0xbb, 0x4b, 0xa6, 0xa1, 0x6b, 0x26, 0xc1, 0xf7,
	0x60, 0xd2, 0x8d, 0x67, 0xb9, 0xda, 0x92, 0xa7, 0x50, 0x26, 0x3e, 0x9b, 0xc8, 0xcd, 0x38, 0x1e,
	0x89, 0xb2, 0xa1, 0x88, 0x51, 0xde, 0x1c, 0xa1, 0xed, 0x67, 0xe0, 0x37, 0xe1, 0xb0, 0x46, 0x1e,
	0xb1, 0xb2, 0x07, 0xac, 0xed, 0xe5, 0xa8, 0xb5, 0xbc, 0xd2, 0x04, 0xbc, 0x03, 0x67, 0xaf, 0x93,
	0x28, 0xb8, 0xc1, 0x00, 0xc4, 0xbd, 0x01, 0x80, 0x83, 0x04, 0x40, 0x78, 0x86, 0xe0, 0x04, 0x27,
	0x8b, 0xa7, 0x5a, 0x48, 0xd0, 0xaf, 0xf9, 0x82, 0x9e, 0xe3, 0x67, 0xce, 0xe1, 0x6c, 0xc4, 0x99,
	0x01, 0x4b, 0xff, 0x63, 0xa4, 0xbf, 0x41, 0x30, 0xdd, 0x01, 0xbc, 0x13, 0xde, 0x1b, 0x80, 0x9d,
	0xde, 0xd3, 0x1e, 0xdc, 0x13, 0xbe, 0xe0, 0x06, 0x51, 0x4f, 0xa8, 0x41, 0xa3, 0x3d, 0xc7, 0xb3,
	0x0a, 0x69, 0x2b, 0x9e, 0x41, 0x8b, 0x01, 0x42, 0xe3, 0x5e, 0x42, 0xa1, 0x6f, 0x42, 0x85, 0xa7,
	0x08, 0xa6, 0x17, 0x29, 0x91, 0x19, 0xe9, 0xeb, 0xa4, 0x7d, 0x84, 0xee, 0x36, 0x4c, 0xb4, 0x91,
	0xc8, 0x3d, 0xef, 0xc2, 0xe1, 0x42, 0xfc, 0x45, 0x31, 0x56, 0x1a, 0x0f, 0x12, 0x29, 0xd4, 0x60,
	0x7a, 0x89, 0xd4, 0x49, 0x9f, 0xc0, 0xf7, 0x41, 0xd1, 0x5f, 0x71, 0x38, 0x6a, 0xe5, 0xc7, 0x5d,
	0x45, 0x25, 0xab, 0x84, 0x2a, 0xa4, 0x99, 0xd5, 0xd7, 0x9d, 0x13, 0x80, 0x9f, 0x90, 0xe7, 0x27,
	0x5c, 0x80, 0xf3, 0x95, 0xba, 0xde, 0xa8, 0xba, 0xa5, 0xac, 0xca, 0x9a, 0x5c, 0x23, 0x34, 0x78,
	0xd6, 0x0a, 0xd5, 0x3f, 0x23, 0x15, 0xe6, 0x70, 0x73, 0xdc, 0x9f, 0xd6, 0xb6, 0xcb, 0x6e, 0x6e,
	0x2f, 0xc2, 0xb0, 0xa2, 0x31, 0x42, 0x37, 0xe5, 0x3a, 0x4f, 0xde, 0x44, 0x4e, 0x10, 0xc3, 0x2e,
	0x3d, 0xd1, 0x02, 0xf8, 0x81, 0xa3, 0x69, 0x9b, 0x68, 0x6e, 0xc4, 0x8b, 0x90, 0x90, 0x6b, 0x35,
	0x4a, 0x6a, 0xbc, 0xd9, 0xf3, 0x3a, 0x4c, 0xe4, 0x4e, 0x87, 0xdb, 0x29, 0xb6, 0x14, 0x4b, 0xde,
	0x5d, 0x78, 0x0a, 0x86, 0x75, 0x5a, 0x25, 0xb4, 0xbc, 0xbe, 0x9d, 0x1a, 0xe2, 0x39, 0x7b, 0x88,
	0xbf, 0x2f, 0x6c, 0xe3, 0x55, 0x18, 0xd8, 0x54, 0xc8, 0x56, 0xea, 0x50, 0x06, 0xcd, 0x8e, 0xe5,
	0x0a, 0xe1, 0x86, 0x43, 0x59, 0x14, 0x5b, 0x2b, 0x6b, 0x0a, 0xd9, 0xb2, 0x81, 0x73, 0x63, 0xfe,
	0xaa, 0x1e, 0x8e, 0xac, 0xea, 0x91, 0x60, 0x55, 0xcf, 0xc0, 0x98, 0xdf, 0x30, 0x1e, 0x86, 0x81,
	0x6b, 0x1f, 0xdd, 0xbc, 0x39, 0xfe, 0x1a, 0x4e, 0xc0, 0xa1, 0xf7, 0x97, 0x8b, 0x4b, 0xcb, 0xa5,
	0xd5, 0x71, 0x24, 0xfc, 0x82, 0x20, 0x19, 0x04, 0xe6, 0xd4, 0x7d, 0x11, 0x12, 0x4c, 0x51, 0x89,
	0x35, 0x71, 0x28, 0xc4, 0x2d, 0xf8, 0x4c, 0x67, 0xf2, 0x9d, 0xed, 0xc0, 0x9a, 0xcf, 0xbd, 0x56,
	0x3b, 0x9e, 0x87, 0x71, 0xf2, 0x88, 0x54, 0x1a, 0x16, 0xcf, 0x65, 0x42, 0xa9, 0xd5, 0x60, 0xe2,
	0xfc, 0x3c, 0xec, 0x9e, 0x47, 0x8d, 0x8a, 0xb8, 0xca, 0x6f, 0xdd, 0xd2, 0xe1, 0xa6, 0xee, 0x32,
	0x57, 0x15, 0x9e, 0x20, 0x38, 0x66, 0x97, 0x71, 0xe7, 0x2c, 0x8d, 0x1f, 0x34, 0x4b, 0xaf, 0xf9,
	0xe9, 0x88, 0xf5, 0x46, 0x87, 0x1d, 0x50, 0x0f, 0x27, 0xc2, 0x57, 0x08, 0x8e, 0x06, 0xc1, 0x72,
	0x3f, 0xf0, 0x72, 0x90, 0x70, 0xd4, 0xd3, 0x09, 0xb1, 0x14, 0xf2, 0x91, 0x2e, 0xc2, 0x90, 0x3d,
	0x9e, 0x38, 0xfd, 0x25, 0x84, 0x42, 0xbe, 0xc7, 0xd1, 0x12, 0xbe, 0x8d, 0xb5, 0xb3, 0xb7, 0xda,
	0x50, 0x55, 0x99, 0x6e, 0xe3, 0x2c, 0x4c, 0x30, 0x9d, 0xc9, 0xf5, 0xb2, 0xa1, 0x2b, 0x1a, 0x2b,
	0x57, 0xf4, 0x86, 0xc6, 0x38, 0xb0, 0xc1, 0xd2, 0x61, 0x2e, 0x58, 0xb1, 0xd6, 0x17, 0xad, 0x65,
	0x2c, 0xc2, 0x11, 0xb3, 0x51, 0xa9, 0x10, 0xd3, 0xf4, 0x69, 0xc7, 0xb8, 0xf6, 0x84, 0x23, 0xf2,
	0xe8, 0xdf, 0x80, 0x21, 0x5f, 0xa8, 0xf3, 0xe1, 0x9e, 0x76, 0x80, 0x26, 0x72, 0xce, 0x4a, 0x8e,
	0x89, 0xf4, 0x5d, 0x18, 0xb4, 0x49, 0xcc, 0x36, 0xbd, 0x47, 0x9d, 0xbc, 0x77, 0x3d, 0xc7, 0xa7,
	0x20, 0xd1, 0x8e, 0x14, 0x8c, 0x26, 0x44, 0xe1, 0x0b, 0x48, 0xde, 0x69, 0x10, 0xba, 0xdd, 0x9e,
	0x56, 0xd8, 0x49, 0x2b, 0xc4, 0xd3, 0xd9, 0xce, 0x90, 0x49, 0x18, 0x7c, 0x68, 0x69, 0xf3, 0x36,
	0x30, 0x52, 0xb2, 0x5f, 0xfc, 0x65, 0x3c, 0x12, 0x59, 0xc6, 0xd0, 0x36, 0x86, 0xc5, 0xe0, 0x58,
	0x1b, 0x00, 0xa7, 0x3c, 0x3f, 0x85, 0xa4, 0x27, 0x5b, 0xbc, 0xd7, 0xca, 0x30, 0x77, 0x3c, 0xdb,
	0x2d, 0x71, 0x3c, 0xad, 0x7e, 0x92, 0x85, 0xac, 0xe2, 0xdb, 0x30, 0xee, 0x3b, 0x41, 0x66, 0x72,
	0x6a, 0x84, 0x87, 0xea, 0x8d, 0xae, 0xb6, 0x65, 0x26, 0x97, 0xc6, 0x98, 0xef, 0x3d, 0xac, 0x1b,
	0x40, 0x58, 0x37, 0xb8, 0x0c, 0x63, 0x86, 0x4c, 0x99, 0x22, 0xd7, 0xdd, 0x5e, 0x90, 0xe8, 0xd8,
	0x0b, 0x46, 0x1d, 0x4d, 0xa7, 0x13, 0xe8, 0x30, 0xc6, 0xf9, 0xe2, 0xaf, 0x56, 0x5f, 0xc3, 0xef,
	0x36, 0xb3, 0x2c, 0xb2, 0x81, 0xb5, 0x76, 0xb9, 0x29, 0x85, 0xcf, 0xc0, 0x28, 0x7f, 0x2a, 0x9b,
	0x76, 0xc6, 0x39, 0xad, 0xeb, 0x75, 0xbe, 0xe8, 0x64, 0x61, 0xee, 0xe7, 0x51, 0x18, 0xb5, 0x6f,
	0xce, 0x55, 0xfb, 0xc3, 0x0c, 0xbf, 0x44, 0x90, 0xe9, 0x36, 0x3a, 0xe3, 0xf9, 0xce, 0x57, 0x44,
	0x0f, 0x5f, 0x11, 0xe9, 0xab, 0xfb, 0xdd, 0x6e, 0xe7, 0x8e, 0x50, 0xdc, 0x2b, 0xf2, 0x94, 0xfd,
	0xf2, 0xcf, 0x97, 0x5f, 0xc7, 0xde, 0xc6, 0x39, 0xeb, 0x43, 0x69, 0xd7, 0x5a, 0x98, 0x37, 0xec,
	0x9e, 0x67, 0x4a, 0xd9, 0xc7, 0xad, 0x2f, 0xb9, 0x30, 0x0f, 0x7e, 0x43, 0x70, 0x32, 0x7a, 0xe2,
	0xc6, 0x57, 0xc2, 0x51, 0xf6, 0x34, 0xa7, 0xa7, 0x7b, 0xfd, 0x6c, 0x10, 0x96, 0xbc, 0xbe, 0x5c,
	0xc2, 0x17, 0xc3, 0x7c, 0x89, 0x74, 0x45, 0xca, 0x66, 0x1f, 0xe3, 0x9f, 0x90, 0x3d, 0xe6, 0xb4,
	0x8d, 0xc1, 0x38, 0x17, 0xc1, 0x75, 0x87, 0x81, 0x3f, 0x9d, 0xef, 0x6b, 0x8f, 0x13, 0x94, 0x77,
	0xbc, 0x8e, 0x9c, 0xc3, 0x33, 0x1d, 0x82, 0xd2, 0x06, 0xf0, 0x7b, 0x04, 0x47, 0x42, 0x66, 0x65,
	0xfc, 0x56, 0x67, 0xfa, 0xc3, 0x67, 0xc6, 0x74, 0xe4, 0x24, 0x2a, 0x5c, 0xf6, 0xe2, 0x9b, 0xc3,
	0xd9, 0x70, 0xa2, 0x83, 0xf0, 0x38, 0xbb, 0xbf, 0x22, 0x48, 0x86, 0xcf, 0xd9, 0x38, 0xb2, 0xeb,
	0xef, 0x0f, 0xe8, 0x27, 0x7b, 0xc5, 0xa4, 0x85, 0x6b, 0xae, 0x6d, 0xe2, 0xe6, 0xd0, 0xdf, 0x13,
	0x7a, 0xa5, 0xb6, 0xd0, 0x3e, 0xb3, 0x5b, 0x6c, 0x27, 0xc3, 0x27, 0xef, 0x4e, 0xae, 0x44, 0xce,
	0xe9, 0xe9, 0xa4, 0xbb, 0xc9, 0xfd, 0xe7, 0x20, 0x2e, 0xab, 0x06, 0xdb, 0x0e, 0xb0, 0x9d, 0xed,
	0x87, 0xed, 0x1f, 0x11, 0x8c, 0xf9, 0x67, 0x3a, 0x7c, 0xbe, 0x8f, 0x91, 0x34, 0x3d, 0xd7, 0x9b,
	0xb2, 0x93, 0xb6, 0x4b, 0x7b, 0xc5, 0x29, 0xce, 0xb6, 0x3d, 0xb0, 0xcf, 0xb9, 0x43, 0xf7, 0x9c,
	0x35, 0xc4, 0x72, 0xf4, 0x02, 0xce, 0x84, 0x13, 0xee, 0x19, 0x5a, 0xbe, 0x43, 0x30, 0x1e, 0xbc,
	0xe9, 0xf1, 0x85, 0xde, 0x26, 0x82, 0x6e, 0x54, 0x5e, 0xdd, 0x2b, 0x8e, 0x73, 0x84, 0x9e, 0xdb,
	0x8c, 0x03, 0x3b, 0x2b, 0x74, 0x05, 0x56, 0x40, 0xd9, 0xf4, 0x1e, 0x7a, 0x5e, 0x9c, 0xea, 0xf8,
	0xe1, 0xf4, 0x47, 0xf1, 0x19, 0x7a, 0xc0, 0x98, 0x61, 0x16, 0x24, 0x69, 0x6b, 0x6b, 0x2b, 0x38,
	0x44, 0xca, 0x0d, 0xf6, 0x40, 0xe2, 0xd3, 0xe6, 0x05, 0xa3, 0x2e, 0xb3, 0x0d, 0x9d, 0xaa, 0x73,
	0xdd, 0xd4, 0x5b, 0x67, 0xf5, 0xa1, 0x2a, 0x52, 0x22, 0x57, 0xfb, 0xd1, 0xdf, 0xa2, 0x0a, 0x23,
	0x0b, 0xff, 0x0c, 0xbe, 0x2a, 0xfe, 0x8d, 0xfa, 0xf9, 0x30, 0xc4, 0x57, 0x9a, 0x54, 0xed, 0x3a,
	0x4f, 0x21, 0xb5, 0x23, 0xed, 0xb6, 0xd5, 0xce, 0xbc, 0x95, 0x9c, 0xcb, 0x3a, 0xad, 0xc9, 0x9a,
	0xb2, 0x63, 0xff, 0x92, 0x94, 0x76, 0xbd, 0xaf, 0x7d, 0x98, 0xb9, 0xbc, 0xa1, 0xd7, 0xab, 0xc4,
	0x92, 0xdb, 0x0f, 0x7d, 0x6c, 0x45, 0xd9, 0x0c, 0x7a, 0x55, 0x7c, 0x1a, 0xdb, 0xe7, 0x4f, 0x1f,
	0xfc, 0x61, 0x98, 0xfb, 0x51, 0xf7, 0xcb, 0x6e, 0xfb, 0x2f, 0x51, 0x0f, 0xa6, 0xc7, 0xf8, 0xe3,
	0x68, 0x4a, 0x0e, 0x62, 0xfa, 0x56, 0x3b, 0x4d, 0x07, 0x31, 0x67, 0x51, 0x07, 0xa9, 0x8a, 0xae,
	0x86, 0x16, 0xe6, 0x02, 0xf6, 0x4d, 0x42, 0x2b, 0x56, 0x15, 0xae, 0xa0, 0x7b, 0x57, 0x1d, 0xdd,
	0x9a, 0x5e, 0x97, 0xb5, 0x9a, 0xa8, 0xd3, 0x9a, 0x54, 0x23, 0x1a, 0xaf, 0x51, 0xa9, 0x45, 0xbb,
	0xff, 0xb7, 0xed, 0x95, 0xd6, 0xdb, 0x93, 0x58, 0xfa, 0xba, 0x6d, 0x60, 0xd1, 0xaa, 0x22, 0x77,
	0x16, 0xb0, 0x8e, 0x5c, 0xcb, 0x3f, 0x77, 0x85, 0xf7, 0xb9, 0xf0, 0x7e, 0x4b, 0x78, 0x7f, 0x2d,
	0xff, 0x2a, 0x36, 0x6d, 0x0b, 0x0b, 0x05, 0x2e, 0x2d, 0x14, 0x5a, 0xe2, 0x42, 0x61, 0x2d, 0xbf,
	0x3e, 0xc4, 0x41, 0xe4, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xef, 0xe1, 0x3e, 0x69, 0x71, 0x17,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MetricServiceClient is the client API for MetricService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MetricServiceClient interface {
	// Lists monitored resource descriptors that match a filter. This method does not require a Workspace.
	ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error)
	// Gets a single monitored resource descriptor. This method does not require a Workspace.
	GetMonitoredResourceDescriptor(ctx context.Context, in *GetMonitoredResourceDescriptorRequest, opts ...grpc.CallOption) (*monitoredres.MonitoredResourceDescriptor, error)
	// Lists metric descriptors that match a filter. This method does not require a Workspace.
	ListMetricDescriptors(ctx context.Context, in *ListMetricDescriptorsRequest, opts ...grpc.CallOption) (*ListMetricDescriptorsResponse, error)
	// Gets a single metric descriptor. This method does not require a Workspace.
	GetMetricDescriptor(ctx context.Context, in *GetMetricDescriptorRequest, opts ...grpc.CallOption) (*metric.MetricDescriptor, error)
	// Creates a new metric descriptor.
	// User-created metric descriptors define
	// [custom metrics](https://cloud.google.com/monitoring/custom-metrics).
	CreateMetricDescriptor(ctx context.Context, in *CreateMetricDescriptorRequest, opts ...grpc.CallOption) (*metric.MetricDescriptor, error)
	// Deletes a metric descriptor. Only user-created
	// [custom metrics](https://cloud.google.com/monitoring/custom-metrics) can be
	// deleted.
	DeleteMetricDescriptor(ctx context.Context, in *DeleteMetricDescriptorRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists time series that match a filter. This method does not require a Workspace.
	ListTimeSeries(ctx context.Context, in *ListTimeSeriesRequest, opts ...grpc.CallOption) (*ListTimeSeriesResponse, error)
	// Creates or adds data to one or more time series.
	// The response is empty if all time series in the request were written.
	// If any time series could not be written, a corresponding failure message is
	// included in the error response.
	CreateTimeSeries(ctx context.Context, in *CreateTimeSeriesRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type metricServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetricServiceClient(cc grpc.ClientConnInterface) MetricServiceClient {
	return &metricServiceClient{cc}
}

func (c *metricServiceClient) ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error) {
	out := new(ListMonitoredResourceDescriptorsResponse)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.MetricService/ListMonitoredResourceDescriptors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricServiceClient) GetMonitoredResourceDescriptor(ctx context.Context, in *GetMonitoredResourceDescriptorRequest, opts ...grpc.CallOption) (*monitoredres.MonitoredResourceDescriptor, error) {
	out := new(monitoredres.MonitoredResourceDescriptor)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.MetricService/GetMonitoredResourceDescriptor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricServiceClient) ListMetricDescriptors(ctx context.Context, in *ListMetricDescriptorsRequest, opts ...grpc.CallOption) (*ListMetricDescriptorsResponse, error) {
	out := new(ListMetricDescriptorsResponse)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.MetricService/ListMetricDescriptors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricServiceClient) GetMetricDescriptor(ctx context.Context, in *GetMetricDescriptorRequest, opts ...grpc.CallOption) (*metric.MetricDescriptor, error) {
	out := new(metric.MetricDescriptor)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.MetricService/GetMetricDescriptor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricServiceClient) CreateMetricDescriptor(ctx context.Context, in *CreateMetricDescriptorRequest, opts ...grpc.CallOption) (*metric.MetricDescriptor, error) {
	out := new(metric.MetricDescriptor)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.MetricService/CreateMetricDescriptor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricServiceClient) DeleteMetricDescriptor(ctx context.Context, in *DeleteMetricDescriptorRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.MetricService/DeleteMetricDescriptor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricServiceClient) ListTimeSeries(ctx context.Context, in *ListTimeSeriesRequest, opts ...grpc.CallOption) (*ListTimeSeriesResponse, error) {
	out := new(ListTimeSeriesResponse)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.MetricService/ListTimeSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricServiceClient) CreateTimeSeries(ctx context.Context, in *CreateTimeSeriesRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.MetricService/CreateTimeSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetricServiceServer is the server API for MetricService service.
type MetricServiceServer interface {
	// Lists monitored resource descriptors that match a filter. This method does not require a Workspace.
	ListMonitoredResourceDescriptors(context.Context, *ListMonitoredResourceDescriptorsRequest) (*ListMonitoredResourceDescriptorsResponse, error)
	// Gets a single monitored resource descriptor. This method does not require a Workspace.
	GetMonitoredResourceDescriptor(context.Context, *GetMonitoredResourceDescriptorRequest) (*monitoredres.MonitoredResourceDescriptor, error)
	// Lists metric descriptors that match a filter. This method does not require a Workspace.
	ListMetricDescriptors(context.Context, *ListMetricDescriptorsRequest) (*ListMetricDescriptorsResponse, error)
	// Gets a single metric descriptor. This method does not require a Workspace.
	GetMetricDescriptor(context.Context, *GetMetricDescriptorRequest) (*metric.MetricDescriptor, error)
	// Creates a new metric descriptor.
	// User-created metric descriptors define
	// [custom metrics](https://cloud.google.com/monitoring/custom-metrics).
	CreateMetricDescriptor(context.Context, *CreateMetricDescriptorRequest) (*metric.MetricDescriptor, error)
	// Deletes a metric descriptor. Only user-created
	// [custom metrics](https://cloud.google.com/monitoring/custom-metrics) can be
	// deleted.
	DeleteMetricDescriptor(context.Context, *DeleteMetricDescriptorRequest) (*empty.Empty, error)
	// Lists time series that match a filter. This method does not require a Workspace.
	ListTimeSeries(context.Context, *ListTimeSeriesRequest) (*ListTimeSeriesResponse, error)
	// Creates or adds data to one or more time series.
	// The response is empty if all time series in the request were written.
	// If any time series could not be written, a corresponding failure message is
	// included in the error response.
	CreateTimeSeries(context.Context, *CreateTimeSeriesRequest) (*empty.Empty, error)
}

// UnimplementedMetricServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMetricServiceServer struct {
}

func (*UnimplementedMetricServiceServer) ListMonitoredResourceDescriptors(ctx context.Context, req *ListMonitoredResourceDescriptorsRequest) (*ListMonitoredResourceDescriptorsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListMonitoredResourceDescriptors not implemented")
}
func (*UnimplementedMetricServiceServer) GetMonitoredResourceDescriptor(ctx context.Context, req *GetMonitoredResourceDescriptorRequest) (*monitoredres.MonitoredResourceDescriptor, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetMonitoredResourceDescriptor not implemented")
}
func (*UnimplementedMetricServiceServer) ListMetricDescriptors(ctx context.Context, req *ListMetricDescriptorsRequest) (*ListMetricDescriptorsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListMetricDescriptors not implemented")
}
func (*UnimplementedMetricServiceServer) GetMetricDescriptor(ctx context.Context, req *GetMetricDescriptorRequest) (*metric.MetricDescriptor, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetMetricDescriptor not implemented")
}
func (*UnimplementedMetricServiceServer) CreateMetricDescriptor(ctx context.Context, req *CreateMetricDescriptorRequest) (*metric.MetricDescriptor, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateMetricDescriptor not implemented")
}
func (*UnimplementedMetricServiceServer) DeleteMetricDescriptor(ctx context.Context, req *DeleteMetricDescriptorRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteMetricDescriptor not implemented")
}
func (*UnimplementedMetricServiceServer) ListTimeSeries(ctx context.Context, req *ListTimeSeriesRequest) (*ListTimeSeriesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListTimeSeries not implemented")
}
func (*UnimplementedMetricServiceServer) CreateTimeSeries(ctx context.Context, req *CreateTimeSeriesRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateTimeSeries not implemented")
}

func RegisterMetricServiceServer(s *grpc.Server, srv MetricServiceServer) {
	s.RegisterService(&_MetricService_serviceDesc, srv)
}

func _MetricService_ListMonitoredResourceDescriptors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMonitoredResourceDescriptorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricServiceServer).ListMonitoredResourceDescriptors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.MetricService/ListMonitoredResourceDescriptors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricServiceServer).ListMonitoredResourceDescriptors(ctx, req.(*ListMonitoredResourceDescriptorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricService_GetMonitoredResourceDescriptor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMonitoredResourceDescriptorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricServiceServer).GetMonitoredResourceDescriptor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.MetricService/GetMonitoredResourceDescriptor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricServiceServer).GetMonitoredResourceDescriptor(ctx, req.(*GetMonitoredResourceDescriptorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricService_ListMetricDescriptors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetricDescriptorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricServiceServer).ListMetricDescriptors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.MetricService/ListMetricDescriptors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricServiceServer).ListMetricDescriptors(ctx, req.(*ListMetricDescriptorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricService_GetMetricDescriptor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetricDescriptorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricServiceServer).GetMetricDescriptor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.MetricService/GetMetricDescriptor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricServiceServer).GetMetricDescriptor(ctx, req.(*GetMetricDescriptorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricService_CreateMetricDescriptor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMetricDescriptorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricServiceServer).CreateMetricDescriptor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.MetricService/CreateMetricDescriptor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricServiceServer).CreateMetricDescriptor(ctx, req.(*CreateMetricDescriptorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricService_DeleteMetricDescriptor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMetricDescriptorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricServiceServer).DeleteMetricDescriptor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.MetricService/DeleteMetricDescriptor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricServiceServer).DeleteMetricDescriptor(ctx, req.(*DeleteMetricDescriptorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricService_ListTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricServiceServer).ListTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.MetricService/ListTimeSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricServiceServer).ListTimeSeries(ctx, req.(*ListTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricService_CreateTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricServiceServer).CreateTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.MetricService/CreateTimeSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricServiceServer).CreateTimeSeries(ctx, req.(*CreateTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MetricService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.monitoring.v3.MetricService",
	HandlerType: (*MetricServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMonitoredResourceDescriptors",
			Handler:    _MetricService_ListMonitoredResourceDescriptors_Handler,
		},
		{
			MethodName: "GetMonitoredResourceDescriptor",
			Handler:    _MetricService_GetMonitoredResourceDescriptor_Handler,
		},
		{
			MethodName: "ListMetricDescriptors",
			Handler:    _MetricService_ListMetricDescriptors_Handler,
		},
		{
			MethodName: "GetMetricDescriptor",
			Handler:    _MetricService_GetMetricDescriptor_Handler,
		},
		{
			MethodName: "CreateMetricDescriptor",
			Handler:    _MetricService_CreateMetricDescriptor_Handler,
		},
		{
			MethodName: "DeleteMetricDescriptor",
			Handler:    _MetricService_DeleteMetricDescriptor_Handler,
		},
		{
			MethodName: "ListTimeSeries",
			Handler:    _MetricService_ListTimeSeries_Handler,
		},
		{
			MethodName: "CreateTimeSeries",
			Handler:    _MetricService_CreateTimeSeries_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/monitoring/v3/metric_service.proto",
}
