.\" $NCDId: @(#)AuErEvnt.man,v 1.1 1994/09/27 00:26:23 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id$
.TH AuErrorEvent 3 "1.2" "audiolib - events"
.SH \fBName\fP
\fBAuErrorEvent\fP \- error event structure
.SH \fBStructures\fP
#include <audio/audiolib.h>
.sp 1
typedef union _AuEvent
.br
{
.br
    . . .
.br
    \fBAuErrorEvent\fP \fIauerror\fP;
.br
    . . .
.br
}\fBAuEvent\fP;
.sp 1
typedef struct _AuErrorEvent
.br
{
.br
    int \fItype\fP;
.br
    \fBAuUint32\fP \fIserial\fP;
.br
    \fBAuBool\fP \fIsend_event\fP;
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuTime\fP \fItime\fP;
.br
    \fBAuID\fP \fIresourceid\fP;
.br
    unsigned char \fIerror_code\fP;
.br
    unsigned char \fIrequest_code\fP;
.br
    unsigned char \fIminor_code\fP;
.br
    union
.br
    {
.br
        \fBAuUint32\fP \fIl\fP[4];
.br
    }\fIdata\fP;
.br
}\fBAuErrorEvent\fP;
.SH \fBMembers\fP
.IP \fItype\fP 1i
The event type.
Error events are type 0.
.IP \fIserial\fP 1i
The serial number of the failed request.
.IP \fIsend_event\fP 1i
\fBAuTrue\fP if the event came from a \fBSendEvent\fP protocol request.
.IP \fIserver\fP 1i
The connection to the audio server that the event was read from.
.IP \fItime\fP 1i
The server time in milliseconds when the event was generated.
.IP \fIresourceid\fP 1i
The resource ID or other value of the failed request.
.IP \fIerror_code\fP 1i
The error code of the failed request.
.IP \fIrequest_code\fP 1i
The protocol major request code of the failed request.
.IP \fIminor_code\fP 1i
The protocol minor request code of the failed request.
.IP \fIdata\fP 1i
Never used?
.SH \fBDescription\fP
Error events are sent to clients to alert them of non-fatal errors encountered while processing requests.
.SH \fBSee Also\fP
\fBAuAnyEvent\fP,
\fBAuElementNotifyEvent\fP,
\fBAuGrabNotifyEvent\fP,
\fBAuMonitorNotifyEvent\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface

