/*
 *  hap -- a mail notification program
 * 
 *  copyright 1995 by Eric Fischer, etaoin@uchicago.edu
 * 
 *  copies of hap may be redistributed under the terms of the
 *  GNU public license, copies of which are available from
 *  the Free Software Foundation, 59 Temple Place, Boston, MA
 *  02111 USA.
 *
 */

#include "hap.h"

/**************************************************************************

   USAGE, VERSION INFO

**************************************************************************/

char *
usagestr[] = {
	"\n",
	"Usage: %s [-seconds] [-hVkbsqvtmiA] [--long-option ...] ",
	"[file [... file]]\n",
	"\n",
	" -h  --help        print this message\n",
	" -V  --version     give version and copyright information\n",
	"\n",
	" -seconds          wait `seconds' seconds between mail checks\n",
	" -k  --kill        kill all %s processes you have running\n",
	" -b  --biff        BIFF emulation\n",
	" -s  --silent      silent (no beeping)\n",
	" -q  --quote       quote the first line of each new message\n",
	" -v  --verbose     be verbose: quote up to five lines of each\n",
	" -t  --terse       be terse: tiny mail listings off in the corner\n",
	" -m  --mesg        delay mail notifications until mesg is y\n",
	" -i  --no-inverse  don't put notices in inverse video\n",
	" -A  --address     use people's addresses, not their names\n",
	"\n",
	0
};

void
usage()
{
	char **here = usagestr;
	char *bn = mybasename (program);

	while (*here) {
		fprintf (stderr, *here, bn);
		here++;
	}

	exit (1);
}

void
version()
{
	printf ("\n   This is Hap version 3.7 (August 6, 1996)\n");
	printf ("   by Eric Fischer, etaoin@uchicago.edu\n");
#ifdef __DATE__
#ifdef __TIME__
	printf ("   compiled %s, %s\n", __DATE__, __TIME__);
#endif
#endif
	printf ("\n   Hap is copyright 1996 by Eric Fischer\n");
	printf ("   and distributed under the GNU public license.\n\n");
	exit (0);
}
