/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.behavior.IProvideScheduler;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class UDPDiscoveryManager {
    private static final Log log = LogManager.getLog(UDPDiscoveryManager.class);
    private static final UDPDiscoveryManager INSTANCE = new UDPDiscoveryManager();
    private final ConcurrentMap<String, UDPDiscoveryService> services = new ConcurrentHashMap<String, UDPDiscoveryService>();

    private UDPDiscoveryManager() {
    }

    public static UDPDiscoveryManager getInstance() {
        return INSTANCE;
    }

    @Deprecated
    public UDPDiscoveryService getService(String discoveryAddress, int discoveryPort, int servicePort, ICompositeCacheManager cacheMgr) {
        return this.getService(discoveryAddress, discoveryPort, null, servicePort, 0, cacheMgr, new StandardSerializer());
    }

    public UDPDiscoveryService getService(String discoveryAddress, int discoveryPort, String serviceAddress, int servicePort, int updTTL, ICompositeCacheManager cacheMgr, IElementSerializer serializer) {
        String key = String.join((CharSequence)":", discoveryAddress, String.valueOf(discoveryPort), String.valueOf(servicePort));
        UDPDiscoveryService service = this.services.computeIfAbsent(key, k -> {
            log.info("Creating service for address:port:servicePort [{0}]", key);
            UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
            attributes.setUdpDiscoveryAddr(discoveryAddress);
            attributes.setUdpDiscoveryPort(discoveryPort);
            attributes.setServiceAddress(serviceAddress);
            attributes.setServicePort(servicePort);
            attributes.setUdpTTL(updTTL);
            UDPDiscoveryService newService = new UDPDiscoveryService(attributes, serializer);
            cacheMgr.registerShutdownObserver(newService);
            if (cacheMgr instanceof IProvideScheduler) {
                newService.setScheduledExecutorService(((IProvideScheduler)((Object)cacheMgr)).getScheduledExecutorService());
            }
            newService.startup();
            return newService;
        });
        log.debug("Returning service [{0}] for key [{1}]", service, key);
        return service;
    }
}

