#!/usr/bin/perl -w

use strict;

use constant N => 256;
use constant K => 32;
use constant SERVER_COUNT => 2;
use constant ITERATIONS => 500;

my ($total, $duplicates) = (0, 0);
my @nextPacket = ();
my @sequences = ();
my @rates = ();

foreach my $iter (1 .. ITERATIONS) {
	@nextPacket = ();
	@sequences = ();
	@rates = ();
	my @results = split ':', &iteration;
	$total += $results[1];
	$duplicates += $results[0];
	print "Iteration $iter: Duplicates: $results[0], Total: $results[1]\n";
}
print "Iteration total: Duplicates: $duplicates, Total: $total, Effiency: "
	. ($duplicates / (K * ITERATIONS)) . "\n";

################[ subs ]###########################

sub iteration {
	my @packetsReceived;
	my $time = 0;
	my $totalReceived = 0;
	my $totalDuplicates = 0;

	@nextPacket = ();
	@sequences = ();
	foreach my $server (0 .. SERVER_COUNT-1) {
		push @sequences, &getShuffled;
		push @nextPacket, 0;
		push @rates, 1;
	}

	while (($totalReceived - $totalDuplicates) < K) {
		$time++;
		foreach my $server (0 .. SERVER_COUNT-1) {
			if (&serverGives($server, $time)) {
				my $received = &serverDequeue($server);
				$totalReceived++;
				$totalDuplicates++ if ($packetsReceived[$received]);
				$packetsReceived[$received]++;
			}
		}
		print "Unique: " . ($totalReceived - $totalDuplicates) 
			. ", Duplicate: $totalDuplicates, Received: $totalReceived,"
			. " Overhead: " 
			. ($totalDuplicates / K) . "\n";
	}
	return "$totalDuplicates:$totalReceived";
}

############[ subs ]##################3

sub serverDequeue {
	my $server = shift;
	my $retval = @{$sequences[$server]}[$nextPacket[$server]++ % N];
	#print "Server $server dequeues $retval\n";
	$retval;
}

sub serverGives {
	my ($server, $time) = @_;
	my $retval = !($time % $rates[$server]);
	#print "Server $server ", ($retval?"does":"does not"), " return a number at time $time\n";
	$retval;
}

sub getShuffled {
	my @list = (1 .. N);
	&fisher_yates_shuffle(\@list);
	return \@list;
}

sub fisher_yates_shuffle {
	my $array = shift;
    my $i;
    for ($i = @$array; --$i; ) {
		my $j = int rand ($i+1);
        next if $i == $j;
        @$array[$i,$j] = @$array[$j,$i];
    }
}

__END__

sub numberUnique {
	my $retVal = 0;
	foreach (@packetsReceived) {
		$retVal++ if $_;	
	}
	$retVal;
}

sub numberDuplicates {
	my $retVal = 0;
	foreach my $count (@packetsReceived) {
		$count = 0 if (! defined $count);
		my $sum = $count - 1;
		$retVal += $sum if ($sum > 0);
	}
	$retVal;
}
