// (c) Copyright 2000 Justin F. Chapweske
// (c) Copyright 2000 Ry4an C. Brase

import com.onionnetworks.util.Util;
import java.security.SecureRandom;
import java.util.Random;

public class FECOverhead {
    
    public static final Random rand = new Random();

    public static final int DEFAULT_K = 32;
    public static final int DEFAULT_N = 256;
    public static final int DEFAULT_BLOCKS = 100;
    public static final int[] DEFAULT_RATES = new int[] {1,1,1};
    public static final double[] DEFAULT_BEGIN_LOSS = new double[] {.02,.02,.02};
    public static final double[] DEFAULT_END_LOSS = new double[] {.98,.98,.98};
    
    int k,n,blocks;
    int[] rates;
    double[] beginLoss, endLoss;
    int numServers;       // # of servers == rates.length
    int time;             // current time
    int numUnique;        // Number of Unique packets recieved.
    int totalRecieved;    // Total packets recieved
    boolean[][] recieved; // Quasi-bitmap of packets recieved.
    int[] packetsInBlock; // Number of packets recieved for each block.
    int blockCollisions = 0; // Number of collisions on full blocks.
    int packetCollisions = 0; // Number of collisions on the same packet.

    boolean[] bursting;   // Are we in the middle of an error burst?
    int[] numLost;        // Number of packets lost from each server.


    // this is organized by stripes.
    int[][][] serverData; // The data that each of the servers will send.
    int[][] stripeOrder;  // The order that the stripes will be sent

    int[] stripeNum;      // Current stripe each server is on.
    int[] stripePos;      // Current block# each server is on.

    public FECOverhead() {
        this(DEFAULT_K,DEFAULT_N,DEFAULT_BLOCKS,DEFAULT_RATES,
             DEFAULT_BEGIN_LOSS,DEFAULT_END_LOSS);
    }

    public FECOverhead(int k, int n, int blocks, int[] rates, 
                       double[] beginLoss, double[] endLoss) {
        this.k = k;
        this.n = n;
        this.blocks = blocks;
        this.rates = rates;
        this.beginLoss = beginLoss;
        this.endLoss = endLoss;
        
        numServers = rates.length;
        recieved = new boolean[blocks][n];
        packetsInBlock = new int[blocks];
        bursting = new boolean[numServers];
        numLost = new int[numServers];
        
        serverData = new int[numServers][n][blocks];
        stripeOrder = new int[numServers][n];
        
        stripeNum = new int[numServers];
        stripePos = new int[numServers];
        initServers();
    }

    public void initServers() {
        for (int i=0;i<numServers;i++) {
            for (int j=0;j<n;j++) {
                for (int l=0;l<blocks;l++) {
                    serverData[i][j][l] = l;
                }
                Util.shuffle(serverData[i][j]);
            }
        }

        for (int i=0;i<numServers;i++) {
            for (int j=0;j<n;j++) {
                stripeOrder[i][j] = j;
            }
            Util.shuffle(stripeOrder[i]);
        }
    }

    public int getOverhead() {
        if (time > 0) {
            throw new IllegalStateException("Can't run this more than once");
        }
        while (numUnique < k*blocks) {
            for (int i=0;i<numServers;i++) {
                if (serverGives(i,time)) {
                    int stripe = stripeOrder[i][stripeNum[i]];
                    int block = serverData[i][stripe][stripePos[i]];
                    if (++stripePos[i] == blocks) {
                        stripePos[i] = 0;
                        stripeNum[i]++;
                    }

                    // do packet loss
                    if (!bursting[i]) {
                        if (rand.nextDouble() < beginLoss[i]) { // lost
                            bursting[i] = true;
                            numLost[i]++;
                            //System.out.print("+");
                            continue;
                        }
                    } else {
                        if (rand.nextDouble() < endLoss[i]) {
                            bursting[i] = false;
                        } else { // lost
                            //System.out.print("+");
                            numLost[i]++;
                            continue;
                        }
                    }
                    
                    //System.out.print("O");
                    totalRecieved++;

                    // Check if that block is full or if that packet has been
                    // recieved before;
                    if (!recieved[block][stripe]) {
                        if (packetsInBlock[block] < k) {  
                            packetsInBlock[block]++;
                            recieved[block][stripe] = true;
                            numUnique++;
                        } else {
                            blockCollisions++;
                        }
                    } else {
                        packetCollisions++;
                    }
                }
            }
            time++;
        }
        System.out.println("blockColl="+blockCollisions+
                           ",packetColl="+packetCollisions+
                           ",unique="+numUnique+",totalRecieved="+
                           totalRecieved+",overhead="+
                           ((float)(totalRecieved-(k*blocks))/
                            (float)(k*blocks)));
        return totalRecieved;
    }

    public boolean serverGives(int server, int time) {
        return (time % rates[server]) == 0;
    }

    public static final void main(String[] args) {
        int totalRecieved = 0;
        int numLost = 0;
        int i = 0;
        int k = DEFAULT_K;
        int n = DEFAULT_N;
        int blocks = DEFAULT_BLOCKS;
        for (i=0;i<100;i++) {
            FECOverhead oh = new FECOverhead();
            totalRecieved += oh.getOverhead();
            for (int j=0;j<oh.numServers;j++) {
                numLost+=oh.numLost[j];
            }
        }
        System.out.println("Overall overhead="+((float)(totalRecieved-
                                                        k*blocks*i)/
                                                (float)(k*blocks*i)));
        System.out.println("Overall packet loss rate="+
                           ((float)numLost/(float)(totalRecieved+numLost)));
    }
}
