/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import org.apache.log4j.helpers.OptionConverter;

public class LogLog {
    public static final String CONFIG_DEBUG_KEY = "log4j.configDebug";
    protected static boolean configDebugEnabled = false;
    private static final String PREFIX = "log4j: ";
    private static final String ERR_PREFIX = "log4j:ERROR ";
    private static final String WARN_PREFIX = "log4j:WARN ";

    public static void setInternalDebugging(boolean bl) {
        configDebugEnabled = bl;
    }

    public static void debug(String string) {
        if (configDebugEnabled) {
            System.out.println(PREFIX + string);
        }
    }

    public static void debug(String string, Throwable throwable) {
        if (configDebugEnabled) {
            System.out.println(PREFIX + string);
            if (throwable != null) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public static void error(String string) {
        System.err.println(ERR_PREFIX + string);
    }

    public static void error(String string, Throwable throwable) {
        System.err.println(ERR_PREFIX + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static void warn(String string) {
        System.err.println(WARN_PREFIX + string);
    }

    public static void warn(String string, Throwable throwable) {
        System.err.println(WARN_PREFIX + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    static {
        try {
            String string = System.getProperty(CONFIG_DEBUG_KEY);
            if (string != null) {
                configDebugEnabled = OptionConverter.toBoolean(string, true);
            }
        }
        catch (SecurityException securityException) {
            System.err.println("log4j: Could not read system property \"log4j.configDebug\".");
        }
    }
}

