// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags
func (c *SageMaker) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddTags API operation for Amazon SageMaker Service.
//
// Adds or overwrites one or more tags for the specified Amazon SageMaker resource.
// You can add tags to notebook instances, training jobs, hyperparameter tuning
// jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations,
// and endpoints.
//
// Each tag consists of a key and an optional value. Tag keys must be unique
// per resource. For more information about tags, see For more information,
// see AWS Tagging Strategies (https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
//
// Tags that you add to a hyperparameter tuning job by calling this API are
// also added to any training jobs that the hyperparameter tuning job launches
// after you call this API, but not to training jobs that the hyperparameter
// tuning job launched before you called this API. To make sure that the tags
// associated with a hyperparameter tuning job are also added to all training
// jobs that the hyperparameter tuning job launches, add the tags when you first
// create the tuning job by specifying them in the Tags parameter of CreateHyperParameterTuningJob
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation AddTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags
func (c *SageMaker) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTrialComponent = "AssociateTrialComponent"

// AssociateTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTrialComponent for more information on using the AssociateTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateTrialComponentRequest method.
//    req, resp := client.AssociateTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent
func (c *SageMaker) AssociateTrialComponentRequest(input *AssociateTrialComponentInput) (req *request.Request, output *AssociateTrialComponentOutput) {
	op := &request.Operation{
		Name:       opAssociateTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTrialComponentInput{}
	}

	output = &AssociateTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTrialComponent API operation for Amazon SageMaker Service.
//
// Associates a trial component with a trial. A trial component can be associated
// with multiple trials. To disassociate a trial component from a trial, call
// the DisassociateTrialComponent API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation AssociateTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent
func (c *SageMaker) AssociateTrialComponent(input *AssociateTrialComponentInput) (*AssociateTrialComponentOutput, error) {
	req, out := c.AssociateTrialComponentRequest(input)
	return out, req.Send()
}

// AssociateTrialComponentWithContext is the same as AssociateTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) AssociateTrialComponentWithContext(ctx aws.Context, input *AssociateTrialComponentInput, opts ...request.Option) (*AssociateTrialComponentOutput, error) {
	req, out := c.AssociateTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlgorithm = "CreateAlgorithm"

// CreateAlgorithmRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlgorithm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlgorithm for more information on using the CreateAlgorithm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAlgorithmRequest method.
//    req, resp := client.CreateAlgorithmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm
func (c *SageMaker) CreateAlgorithmRequest(input *CreateAlgorithmInput) (req *request.Request, output *CreateAlgorithmOutput) {
	op := &request.Operation{
		Name:       opCreateAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAlgorithmInput{}
	}

	output = &CreateAlgorithmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlgorithm API operation for Amazon SageMaker Service.
//
// Create a machine learning algorithm that you can use in Amazon SageMaker
// and list in the AWS Marketplace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateAlgorithm for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm
func (c *SageMaker) CreateAlgorithm(input *CreateAlgorithmInput) (*CreateAlgorithmOutput, error) {
	req, out := c.CreateAlgorithmRequest(input)
	return out, req.Send()
}

// CreateAlgorithmWithContext is the same as CreateAlgorithm with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlgorithm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateAlgorithmWithContext(ctx aws.Context, input *CreateAlgorithmInput, opts ...request.Option) (*CreateAlgorithmOutput, error) {
	req, out := c.CreateAlgorithmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApp = "CreateApp"

// CreateAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApp for more information on using the CreateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppRequest method.
//    req, resp := client.CreateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp
func (c *SageMaker) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	output = &CreateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApp API operation for Amazon SageMaker Service.
//
// Creates a running App for the specified UserProfile. Supported Apps are JupyterServer
// and KernelGateway. This operation is automatically invoked by Amazon SageMaker
// Amazon SageMaker Studio (Studio) upon access to the associated Studio Domain,
// and when new kernel configurations are selected by the user. A user may have
// multiple Apps active simultaneously. Apps will automatically terminate and
// be deleted when stopped from within Studio, or when the DeleteApp API is
// manually called. UserProfiles are limited to 5 concurrently running Apps
// at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateApp for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp
func (c *SageMaker) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	return out, req.Send()
}

// CreateAppWithContext is the same as CreateApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateAppWithContext(ctx aws.Context, input *CreateAppInput, opts ...request.Option) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAutoMLJob = "CreateAutoMLJob"

// CreateAutoMLJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateAutoMLJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAutoMLJob for more information on using the CreateAutoMLJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAutoMLJobRequest method.
//    req, resp := client.CreateAutoMLJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob
func (c *SageMaker) CreateAutoMLJobRequest(input *CreateAutoMLJobInput) (req *request.Request, output *CreateAutoMLJobOutput) {
	op := &request.Operation{
		Name:       opCreateAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAutoMLJobInput{}
	}

	output = &CreateAutoMLJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAutoMLJob API operation for Amazon SageMaker Service.
//
// Creates an AutoPilot job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateAutoMLJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob
func (c *SageMaker) CreateAutoMLJob(input *CreateAutoMLJobInput) (*CreateAutoMLJobOutput, error) {
	req, out := c.CreateAutoMLJobRequest(input)
	return out, req.Send()
}

// CreateAutoMLJobWithContext is the same as CreateAutoMLJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAutoMLJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateAutoMLJobWithContext(ctx aws.Context, input *CreateAutoMLJobInput, opts ...request.Option) (*CreateAutoMLJobOutput, error) {
	req, out := c.CreateAutoMLJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCodeRepository = "CreateCodeRepository"

// CreateCodeRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateCodeRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCodeRepository for more information on using the CreateCodeRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCodeRepositoryRequest method.
//    req, resp := client.CreateCodeRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository
func (c *SageMaker) CreateCodeRepositoryRequest(input *CreateCodeRepositoryInput) (req *request.Request, output *CreateCodeRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCodeRepositoryInput{}
	}

	output = &CreateCodeRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCodeRepository API operation for Amazon SageMaker Service.
//
// Creates a Git repository as a resource in your Amazon SageMaker account.
// You can associate the repository with notebook instances so that you can
// use Git source control for the notebooks you create. The Git repository is
// a resource in your Amazon SageMaker account, so it can be associated with
// more than one notebook instance, and it persists independently from the lifecycle
// of any notebook instances it is associated with.
//
// The repository can be hosted either in AWS CodeCommit (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
// or in any other Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateCodeRepository for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository
func (c *SageMaker) CreateCodeRepository(input *CreateCodeRepositoryInput) (*CreateCodeRepositoryOutput, error) {
	req, out := c.CreateCodeRepositoryRequest(input)
	return out, req.Send()
}

// CreateCodeRepositoryWithContext is the same as CreateCodeRepository with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCodeRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateCodeRepositoryWithContext(ctx aws.Context, input *CreateCodeRepositoryInput, opts ...request.Option) (*CreateCodeRepositoryOutput, error) {
	req, out := c.CreateCodeRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCompilationJob = "CreateCompilationJob"

// CreateCompilationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateCompilationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCompilationJob for more information on using the CreateCompilationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCompilationJobRequest method.
//    req, resp := client.CreateCompilationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob
func (c *SageMaker) CreateCompilationJobRequest(input *CreateCompilationJobInput) (req *request.Request, output *CreateCompilationJobOutput) {
	op := &request.Operation{
		Name:       opCreateCompilationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCompilationJobInput{}
	}

	output = &CreateCompilationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCompilationJob API operation for Amazon SageMaker Service.
//
// Starts a model compilation job. After the model has been compiled, Amazon
// SageMaker saves the resulting model artifacts to an Amazon Simple Storage
// Service (Amazon S3) bucket that you specify.
//
// If you choose to host your model using Amazon SageMaker hosting services,
// you can use the resulting model artifacts as part of the model. You can also
// use the artifacts with AWS IoT Greengrass. In that case, deploy them as an
// ML resource.
//
// In the request body, you provide the following:
//
//    * A name for the compilation job
//
//    * Information about the input model artifacts
//
//    * The output location for the compiled model and the device (target) that
//    the model runs on
//
//    * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker
//    assumes to perform the model compilation job
//
// You can also provide a Tag to track the model compilation job's resource
// use and costs. The response body contains the CompilationJobArn for the compiled
// job.
//
// To stop a model compilation job, use StopCompilationJob. To get information
// about a particular model compilation job, use DescribeCompilationJob. To
// get information about multiple model compilation jobs, use ListCompilationJobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateCompilationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob
func (c *SageMaker) CreateCompilationJob(input *CreateCompilationJobInput) (*CreateCompilationJobOutput, error) {
	req, out := c.CreateCompilationJobRequest(input)
	return out, req.Send()
}

// CreateCompilationJobWithContext is the same as CreateCompilationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCompilationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateCompilationJobWithContext(ctx aws.Context, input *CreateCompilationJobInput, opts ...request.Option) (*CreateCompilationJobOutput, error) {
	req, out := c.CreateCompilationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain
func (c *SageMaker) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon SageMaker Service.
//
// Creates a Domain for Amazon SageMaker Amazon SageMaker Studio (Studio), which
// can be accessed by end-users in a web browser. A Domain has an associated
// directory, list of authorized users, and a variety of security, application,
// policies, and Amazon Virtual Private Cloud configurations. An AWS account
// is limited to one Domain, per region. Users within a domain can share notebook
// files and other artifacts with each other. When a Domain is created, an Amazon
// Elastic File System (EFS) is also created for use by all of the users within
// the Domain. Each user receives a private home directory within the EFS for
// notebooks, Git repositories, and data files.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain
func (c *SageMaker) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointRequest method.
//    req, resp := client.CreateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint
func (c *SageMaker) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for Amazon SageMaker Service.
//
// Creates an endpoint using the endpoint configuration specified in the request.
// Amazon SageMaker uses the endpoint to provision resources and deploy models.
// You create the endpoint configuration with the CreateEndpointConfig (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html)
// API.
//
// Use this API to deploy models using Amazon SageMaker hosting services.
//
// For an example that calls this method when deploying a model to Amazon SageMaker
// hosting services, see Deploy the Model to Amazon SageMaker Hosting Services
// (AWS SDK for Python (Boto 3)). (https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
//
// You must not delete an EndpointConfig that is in use by an endpoint that
// is live or while the UpdateEndpoint or CreateEndpoint operations are being
// performed on the endpoint. To update an endpoint, you must create a new EndpointConfig.
//
// The endpoint name must be unique within an AWS Region in your AWS account.
//
// When it receives the request, Amazon SageMaker creates the endpoint, launches
// the resources (ML compute instances), and deploys the model(s) on them.
//
// When Amazon SageMaker receives the request, it sets the endpoint status to
// Creating. After it creates the endpoint, it sets the status to InService.
// Amazon SageMaker can then process incoming requests for inferences. To check
// the status of an endpoint, use the DescribeEndpoint (https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
// API.
//
// If any of the models hosted at this endpoint get model data from an Amazon
// S3 location, Amazon SageMaker uses AWS Security Token Service to download
// model artifacts from the S3 path you provided. AWS STS is activated in your
// IAM user account by default. If you previously deactivated AWS STS for a
// region, you need to reactivate AWS STS for that region. For more information,
// see Activating and Deactivating AWS STS in an AWS Region (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
// in the AWS Identity and Access Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint
func (c *SageMaker) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpointConfig = "CreateEndpointConfig"

// CreateEndpointConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpointConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpointConfig for more information on using the CreateEndpointConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointConfigRequest method.
//    req, resp := client.CreateEndpointConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig
func (c *SageMaker) CreateEndpointConfigRequest(input *CreateEndpointConfigInput) (req *request.Request, output *CreateEndpointConfigOutput) {
	op := &request.Operation{
		Name:       opCreateEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointConfigInput{}
	}

	output = &CreateEndpointConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpointConfig API operation for Amazon SageMaker Service.
//
// Creates an endpoint configuration that Amazon SageMaker hosting services
// uses to deploy models. In the configuration, you identify one or more models,
// created using the CreateModel API, to deploy and the resources that you want
// Amazon SageMaker to provision. Then you call the CreateEndpoint (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html)
// API.
//
// Use this API if you want to use Amazon SageMaker hosting services to deploy
// models into production.
//
// In the request, you define a ProductionVariant, for each model that you want
// to deploy. Each ProductionVariant parameter also describes the resources
// that you want Amazon SageMaker to provision. This includes the number and
// type of ML compute instances to deploy.
//
// If you are hosting multiple models, you also assign a VariantWeight to specify
// how much traffic you want to allocate to each model. For example, suppose
// that you want to host two models, A and B, and you assign traffic weight
// 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds
// of the traffic to Model A, and one-third to model B.
//
// For an example that calls this method when deploying a model to Amazon SageMaker
// hosting services, see Deploy the Model to Amazon SageMaker Hosting Services
// (AWS SDK for Python (Boto 3)). (https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateEndpointConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig
func (c *SageMaker) CreateEndpointConfig(input *CreateEndpointConfigInput) (*CreateEndpointConfigOutput, error) {
	req, out := c.CreateEndpointConfigRequest(input)
	return out, req.Send()
}

// CreateEndpointConfigWithContext is the same as CreateEndpointConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpointConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateEndpointConfigWithContext(ctx aws.Context, input *CreateEndpointConfigInput, opts ...request.Option) (*CreateEndpointConfigOutput, error) {
	req, out := c.CreateEndpointConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExperiment = "CreateExperiment"

// CreateExperimentRequest generates a "aws/request.Request" representing the
// client's request for the CreateExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExperiment for more information on using the CreateExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateExperimentRequest method.
//    req, resp := client.CreateExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment
func (c *SageMaker) CreateExperimentRequest(input *CreateExperimentInput) (req *request.Request, output *CreateExperimentOutput) {
	op := &request.Operation{
		Name:       opCreateExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateExperimentInput{}
	}

	output = &CreateExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExperiment API operation for Amazon SageMaker Service.
//
// Creates an Amazon SageMaker experiment. An experiment is a collection of
// trials that are observed, compared and evaluated as a group. A trial is a
// set of steps, called trial components, that produce a machine learning model.
//
// The goal of an experiment is to determine the components that produce the
// best model. Multiple trials are performed, each one isolating and measuring
// the impact of a change to one or more inputs, while keeping the remaining
// inputs constant.
//
// When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
// all experiments, trials, and trial components are automatically tracked,
// logged, and indexed. When you use the AWS SDK for Python (Boto), you must
// use the logging APIs provided by the SDK.
//
// You can add tags to experiments, trials, trial components and then use the
// Search API to search for the tags.
//
// To add a description to an experiment, specify the optional Description parameter.
// To add a description later, or to change the description, call the UpdateExperiment
// API.
//
// To get a list of all your experiments, call the ListExperiments API. To view
// an experiment's properties, call the DescribeExperiment API. To get a list
// of all the trials associated with an experiment, call the ListTrials API.
// To create a trial call the CreateTrial API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateExperiment for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment
func (c *SageMaker) CreateExperiment(input *CreateExperimentInput) (*CreateExperimentOutput, error) {
	req, out := c.CreateExperimentRequest(input)
	return out, req.Send()
}

// CreateExperimentWithContext is the same as CreateExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateExperimentWithContext(ctx aws.Context, input *CreateExperimentInput, opts ...request.Option) (*CreateExperimentOutput, error) {
	req, out := c.CreateExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlowDefinition = "CreateFlowDefinition"

// CreateFlowDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlowDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlowDefinition for more information on using the CreateFlowDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFlowDefinitionRequest method.
//    req, resp := client.CreateFlowDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition
func (c *SageMaker) CreateFlowDefinitionRequest(input *CreateFlowDefinitionInput) (req *request.Request, output *CreateFlowDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateFlowDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFlowDefinitionInput{}
	}

	output = &CreateFlowDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlowDefinition API operation for Amazon SageMaker Service.
//
// Creates a flow definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateFlowDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition
func (c *SageMaker) CreateFlowDefinition(input *CreateFlowDefinitionInput) (*CreateFlowDefinitionOutput, error) {
	req, out := c.CreateFlowDefinitionRequest(input)
	return out, req.Send()
}

// CreateFlowDefinitionWithContext is the same as CreateFlowDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlowDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateFlowDefinitionWithContext(ctx aws.Context, input *CreateFlowDefinitionInput, opts ...request.Option) (*CreateFlowDefinitionOutput, error) {
	req, out := c.CreateFlowDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHumanTaskUi = "CreateHumanTaskUi"

// CreateHumanTaskUiRequest generates a "aws/request.Request" representing the
// client's request for the CreateHumanTaskUi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHumanTaskUi for more information on using the CreateHumanTaskUi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHumanTaskUiRequest method.
//    req, resp := client.CreateHumanTaskUiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi
func (c *SageMaker) CreateHumanTaskUiRequest(input *CreateHumanTaskUiInput) (req *request.Request, output *CreateHumanTaskUiOutput) {
	op := &request.Operation{
		Name:       opCreateHumanTaskUi,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHumanTaskUiInput{}
	}

	output = &CreateHumanTaskUiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHumanTaskUi API operation for Amazon SageMaker Service.
//
// Defines the settings you will use for the human review workflow user interface.
// Reviewers will see a three-panel interface with an instruction area, the
// item to review, and an input area.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateHumanTaskUi for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi
func (c *SageMaker) CreateHumanTaskUi(input *CreateHumanTaskUiInput) (*CreateHumanTaskUiOutput, error) {
	req, out := c.CreateHumanTaskUiRequest(input)
	return out, req.Send()
}

// CreateHumanTaskUiWithContext is the same as CreateHumanTaskUi with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHumanTaskUi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateHumanTaskUiWithContext(ctx aws.Context, input *CreateHumanTaskUiInput, opts ...request.Option) (*CreateHumanTaskUiOutput, error) {
	req, out := c.CreateHumanTaskUiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHyperParameterTuningJob = "CreateHyperParameterTuningJob"

// CreateHyperParameterTuningJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateHyperParameterTuningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHyperParameterTuningJob for more information on using the CreateHyperParameterTuningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHyperParameterTuningJobRequest method.
//    req, resp := client.CreateHyperParameterTuningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob
func (c *SageMaker) CreateHyperParameterTuningJobRequest(input *CreateHyperParameterTuningJobInput) (req *request.Request, output *CreateHyperParameterTuningJobOutput) {
	op := &request.Operation{
		Name:       opCreateHyperParameterTuningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHyperParameterTuningJobInput{}
	}

	output = &CreateHyperParameterTuningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHyperParameterTuningJob API operation for Amazon SageMaker Service.
//
// Starts a hyperparameter tuning job. A hyperparameter tuning job finds the
// best version of a model by running many training jobs on your dataset using
// the algorithm you choose and values for hyperparameters within ranges that
// you specify. It then chooses the hyperparameter values that result in a model
// that performs the best, as measured by an objective metric that you choose.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateHyperParameterTuningJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob
func (c *SageMaker) CreateHyperParameterTuningJob(input *CreateHyperParameterTuningJobInput) (*CreateHyperParameterTuningJobOutput, error) {
	req, out := c.CreateHyperParameterTuningJobRequest(input)
	return out, req.Send()
}

// CreateHyperParameterTuningJobWithContext is the same as CreateHyperParameterTuningJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHyperParameterTuningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateHyperParameterTuningJobWithContext(ctx aws.Context, input *CreateHyperParameterTuningJobInput, opts ...request.Option) (*CreateHyperParameterTuningJobOutput, error) {
	req, out := c.CreateHyperParameterTuningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLabelingJob = "CreateLabelingJob"

// CreateLabelingJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateLabelingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLabelingJob for more information on using the CreateLabelingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLabelingJobRequest method.
//    req, resp := client.CreateLabelingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob
func (c *SageMaker) CreateLabelingJobRequest(input *CreateLabelingJobInput) (req *request.Request, output *CreateLabelingJobOutput) {
	op := &request.Operation{
		Name:       opCreateLabelingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLabelingJobInput{}
	}

	output = &CreateLabelingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLabelingJob API operation for Amazon SageMaker Service.
//
// Creates a job that uses workers to label the data objects in your input dataset.
// You can use the labeled data to train machine learning models.
//
// You can select your workforce from one of three providers:
//
//    * A private workforce that you create. It can include employees, contractors,
//    and outside experts. Use a private workforce when want the data to stay
//    within your organization or when a specific set of skills is required.
//
//    * One or more vendors that you select from the AWS Marketplace. Vendors
//    provide expertise in specific areas.
//
//    * The Amazon Mechanical Turk workforce. This is the largest workforce,
//    but it should only be used for public data or data that has been stripped
//    of any personally identifiable information.
//
// You can also use automated data labeling to reduce the number of data objects
// that need to be labeled by a human. Automated data labeling uses active learning
// to determine if a data object can be labeled by machine or if it needs to
// be sent to a human worker. For more information, see Using Automated Data
// Labeling (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html).
//
// The data objects to be labeled are contained in an Amazon S3 bucket. You
// create a manifest file that describes the location of each object. For more
// information, see Using Input and Output Data (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html).
//
// The output can be used as the manifest file for another labeling job or as
// training data for your machine learning models.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateLabelingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob
func (c *SageMaker) CreateLabelingJob(input *CreateLabelingJobInput) (*CreateLabelingJobOutput, error) {
	req, out := c.CreateLabelingJobRequest(input)
	return out, req.Send()
}

// CreateLabelingJobWithContext is the same as CreateLabelingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLabelingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateLabelingJobWithContext(ctx aws.Context, input *CreateLabelingJobInput, opts ...request.Option) (*CreateLabelingJobOutput, error) {
	req, out := c.CreateLabelingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModel for more information on using the CreateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelRequest method.
//    req, resp := client.CreateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel
func (c *SageMaker) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *CreateModelOutput) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	output = &CreateModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModel API operation for Amazon SageMaker Service.
//
// Creates a model in Amazon SageMaker. In the request, you name the model and
// describe a primary container. For the primary container, you specify the
// Docker image that contains inference code, artifacts (from prior training),
// and a custom environment map that the inference code uses when you deploy
// the model for predictions.
//
// Use this API to create a model if you want to use Amazon SageMaker hosting
// services or run a batch transform job.
//
// To host your model, you create an endpoint configuration with the CreateEndpointConfig
// API, and then create an endpoint with the CreateEndpoint API. Amazon SageMaker
// then deploys all of the containers that you defined for the model in the
// hosting environment.
//
// For an example that calls this method when deploying a model to Amazon SageMaker
// hosting services, see Deploy the Model to Amazon SageMaker Hosting Services
// (AWS SDK for Python (Boto 3)). (https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
//
// To run a batch transform using your model, you start a job with the CreateTransformJob
// API. Amazon SageMaker uses your model and your dataset to get inferences
// which are then saved to a specified S3 location.
//
// In the CreateModel request, you must define a container with the PrimaryContainer
// parameter.
//
// In the request, you also provide an IAM role that Amazon SageMaker can assume
// to access model artifacts and docker image for deployment on ML compute hosting
// instances or for batch transform jobs. In addition, you also use the IAM
// role to manage permissions the inference code needs. For example, if the
// inference code access any other AWS resources, you grant necessary permissions
// via this role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateModel for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel
func (c *SageMaker) CreateModel(input *CreateModelInput) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	return out, req.Send()
}

// CreateModelWithContext is the same as CreateModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateModelWithContext(ctx aws.Context, input *CreateModelInput, opts ...request.Option) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelPackage = "CreateModelPackage"

// CreateModelPackageRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelPackage for more information on using the CreateModelPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelPackageRequest method.
//    req, resp := client.CreateModelPackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage
func (c *SageMaker) CreateModelPackageRequest(input *CreateModelPackageInput) (req *request.Request, output *CreateModelPackageOutput) {
	op := &request.Operation{
		Name:       opCreateModelPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelPackageInput{}
	}

	output = &CreateModelPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelPackage API operation for Amazon SageMaker Service.
//
// Creates a model package that you can use to create Amazon SageMaker models
// or list on AWS Marketplace. Buyers can subscribe to model packages listed
// on AWS Marketplace to create models in Amazon SageMaker.
//
// To create a model package by specifying a Docker container that contains
// your inference code and the Amazon S3 location of your model artifacts, provide
// values for InferenceSpecification. To create a model from an algorithm resource
// that you created or subscribed to in AWS Marketplace, provide a value for
// SourceAlgorithmSpecification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateModelPackage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage
func (c *SageMaker) CreateModelPackage(input *CreateModelPackageInput) (*CreateModelPackageOutput, error) {
	req, out := c.CreateModelPackageRequest(input)
	return out, req.Send()
}

// CreateModelPackageWithContext is the same as CreateModelPackage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateModelPackageWithContext(ctx aws.Context, input *CreateModelPackageInput, opts ...request.Option) (*CreateModelPackageOutput, error) {
	req, out := c.CreateModelPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMonitoringSchedule = "CreateMonitoringSchedule"

// CreateMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreateMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMonitoringSchedule for more information on using the CreateMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMonitoringScheduleRequest method.
//    req, resp := client.CreateMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule
func (c *SageMaker) CreateMonitoringScheduleRequest(input *CreateMonitoringScheduleInput) (req *request.Request, output *CreateMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opCreateMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMonitoringScheduleInput{}
	}

	output = &CreateMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Creates a schedule that regularly starts Amazon SageMaker Processing Jobs
// to monitor the data captured for an Amazon SageMaker Endoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule
func (c *SageMaker) CreateMonitoringSchedule(input *CreateMonitoringScheduleInput) (*CreateMonitoringScheduleOutput, error) {
	req, out := c.CreateMonitoringScheduleRequest(input)
	return out, req.Send()
}

// CreateMonitoringScheduleWithContext is the same as CreateMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateMonitoringScheduleWithContext(ctx aws.Context, input *CreateMonitoringScheduleInput, opts ...request.Option) (*CreateMonitoringScheduleOutput, error) {
	req, out := c.CreateMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNotebookInstance = "CreateNotebookInstance"

// CreateNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNotebookInstance for more information on using the CreateNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNotebookInstanceRequest method.
//    req, resp := client.CreateNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance
func (c *SageMaker) CreateNotebookInstanceRequest(input *CreateNotebookInstanceInput) (req *request.Request, output *CreateNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNotebookInstanceInput{}
	}

	output = &CreateNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNotebookInstance API operation for Amazon SageMaker Service.
//
// Creates an Amazon SageMaker notebook instance. A notebook instance is a machine
// learning (ML) compute instance running on a Jupyter notebook.
//
// In a CreateNotebookInstance request, specify the type of ML compute instance
// that you want to run. Amazon SageMaker launches the instance, installs common
// libraries that you can use to explore datasets for model training, and attaches
// an ML storage volume to the notebook instance.
//
// Amazon SageMaker also provides a set of example notebooks. Each notebook
// demonstrates how to use Amazon SageMaker with a specific algorithm or with
// a machine learning framework.
//
// After receiving the request, Amazon SageMaker does the following:
//
// Creates a network interface in the Amazon SageMaker VPC.
//
// (Option) If you specified SubnetId, Amazon SageMaker creates a network interface
// in your own VPC, which is inferred from the subnet ID that you provide in
// the input. When creating this network interface, Amazon SageMaker attaches
// the security group that you specified in the request to the network interface
// that it creates in your VPC.
//
// Launches an EC2 instance of the type specified in the request in the Amazon
// SageMaker VPC. If you specified SubnetId of your VPC, Amazon SageMaker specifies
// both network interfaces when launching this instance. This enables inbound
// traffic from your own VPC to the notebook instance, assuming that the security
// groups allow it.
//
// After creating the notebook instance, Amazon SageMaker returns its Amazon
// Resource Name (ARN). You can't change the name of a notebook instance after
// you create it.
//
// After Amazon SageMaker creates the notebook instance, you can connect to
// the Jupyter server and work in Jupyter notebooks. For example, you can write
// code to explore a dataset that you can use for model training, train a model,
// host models by creating Amazon SageMaker endpoints, and validate hosted models.
//
// For more information, see How It Works (https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateNotebookInstance for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance
func (c *SageMaker) CreateNotebookInstance(input *CreateNotebookInstanceInput) (*CreateNotebookInstanceOutput, error) {
	req, out := c.CreateNotebookInstanceRequest(input)
	return out, req.Send()
}

// CreateNotebookInstanceWithContext is the same as CreateNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateNotebookInstanceWithContext(ctx aws.Context, input *CreateNotebookInstanceInput, opts ...request.Option) (*CreateNotebookInstanceOutput, error) {
	req, out := c.CreateNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNotebookInstanceLifecycleConfig = "CreateNotebookInstanceLifecycleConfig"

// CreateNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNotebookInstanceLifecycleConfig for more information on using the CreateNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.CreateNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig
func (c *SageMaker) CreateNotebookInstanceLifecycleConfigRequest(input *CreateNotebookInstanceLifecycleConfigInput) (req *request.Request, output *CreateNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opCreateNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNotebookInstanceLifecycleConfigInput{}
	}

	output = &CreateNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Creates a lifecycle configuration that you can associate with a notebook
// instance. A lifecycle configuration is a collection of shell scripts that
// run when you create or start a notebook instance.
//
// Each lifecycle configuration script has a limit of 16384 characters.
//
// The value of the $PATH environment variable that is available to both scripts
// is /sbin:bin:/usr/sbin:/usr/bin.
//
// View CloudWatch Logs for notebook instance lifecycle configurations in log
// group /aws/sagemaker/NotebookInstances in log stream [notebook-instance-name]/[LifecycleConfigHook].
//
// Lifecycle configuration scripts cannot run for longer than 5 minutes. If
// a script runs for longer than 5 minutes, it fails and the notebook instance
// is not created or started.
//
// For information about notebook instance lifestyle configurations, see Step
// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateNotebookInstanceLifecycleConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig
func (c *SageMaker) CreateNotebookInstanceLifecycleConfig(input *CreateNotebookInstanceLifecycleConfigInput) (*CreateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.CreateNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// CreateNotebookInstanceLifecycleConfigWithContext is the same as CreateNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *CreateNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*CreateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.CreateNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePresignedDomainUrl = "CreatePresignedDomainUrl"

// CreatePresignedDomainUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreatePresignedDomainUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePresignedDomainUrl for more information on using the CreatePresignedDomainUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePresignedDomainUrlRequest method.
//    req, resp := client.CreatePresignedDomainUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl
func (c *SageMaker) CreatePresignedDomainUrlRequest(input *CreatePresignedDomainUrlInput) (req *request.Request, output *CreatePresignedDomainUrlOutput) {
	op := &request.Operation{
		Name:       opCreatePresignedDomainUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePresignedDomainUrlInput{}
	}

	output = &CreatePresignedDomainUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePresignedDomainUrl API operation for Amazon SageMaker Service.
//
// Creates a URL for a specified UserProfile in a Domain. When accessed in a
// web browser, the user will be automatically signed in to Amazon SageMaker
// Amazon SageMaker Studio (Studio), and granted access to all of the Apps and
// files associated with that Amazon Elastic File System (EFS). This operation
// can only be called when AuthMode equals IAM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreatePresignedDomainUrl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl
func (c *SageMaker) CreatePresignedDomainUrl(input *CreatePresignedDomainUrlInput) (*CreatePresignedDomainUrlOutput, error) {
	req, out := c.CreatePresignedDomainUrlRequest(input)
	return out, req.Send()
}

// CreatePresignedDomainUrlWithContext is the same as CreatePresignedDomainUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePresignedDomainUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreatePresignedDomainUrlWithContext(ctx aws.Context, input *CreatePresignedDomainUrlInput, opts ...request.Option) (*CreatePresignedDomainUrlOutput, error) {
	req, out := c.CreatePresignedDomainUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePresignedNotebookInstanceUrl = "CreatePresignedNotebookInstanceUrl"

// CreatePresignedNotebookInstanceUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreatePresignedNotebookInstanceUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePresignedNotebookInstanceUrl for more information on using the CreatePresignedNotebookInstanceUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePresignedNotebookInstanceUrlRequest method.
//    req, resp := client.CreatePresignedNotebookInstanceUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl
func (c *SageMaker) CreatePresignedNotebookInstanceUrlRequest(input *CreatePresignedNotebookInstanceUrlInput) (req *request.Request, output *CreatePresignedNotebookInstanceUrlOutput) {
	op := &request.Operation{
		Name:       opCreatePresignedNotebookInstanceUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePresignedNotebookInstanceUrlInput{}
	}

	output = &CreatePresignedNotebookInstanceUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePresignedNotebookInstanceUrl API operation for Amazon SageMaker Service.
//
// Returns a URL that you can use to connect to the Jupyter server from a notebook
// instance. In the Amazon SageMaker console, when you choose Open next to a
// notebook instance, Amazon SageMaker opens a new tab showing the Jupyter server
// home page from the notebook instance. The console uses this API to get the
// URL and show the page.
//
// IAM authorization policies for this API are also enforced for every HTTP
// request and WebSocket frame that attempts to connect to the notebook instance.For
// example, you can restrict access to this API and to the URL that it returns
// to a list of IP addresses that you specify. Use the NotIpAddress condition
// operator and the aws:SourceIP condition context key to specify the list of
// IP addresses that you want to have access to the notebook instance. For more
// information, see Limit Access to a Notebook Instance by IP Address (https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter).
//
// The URL that you get from a call to is valid only for 5 minutes. If you try
// to use the URL after the 5-minute limit expires, you are directed to the
// AWS console sign-in page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreatePresignedNotebookInstanceUrl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl
func (c *SageMaker) CreatePresignedNotebookInstanceUrl(input *CreatePresignedNotebookInstanceUrlInput) (*CreatePresignedNotebookInstanceUrlOutput, error) {
	req, out := c.CreatePresignedNotebookInstanceUrlRequest(input)
	return out, req.Send()
}

// CreatePresignedNotebookInstanceUrlWithContext is the same as CreatePresignedNotebookInstanceUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePresignedNotebookInstanceUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreatePresignedNotebookInstanceUrlWithContext(ctx aws.Context, input *CreatePresignedNotebookInstanceUrlInput, opts ...request.Option) (*CreatePresignedNotebookInstanceUrlOutput, error) {
	req, out := c.CreatePresignedNotebookInstanceUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProcessingJob = "CreateProcessingJob"

// CreateProcessingJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateProcessingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProcessingJob for more information on using the CreateProcessingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProcessingJobRequest method.
//    req, resp := client.CreateProcessingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob
func (c *SageMaker) CreateProcessingJobRequest(input *CreateProcessingJobInput) (req *request.Request, output *CreateProcessingJobOutput) {
	op := &request.Operation{
		Name:       opCreateProcessingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProcessingJobInput{}
	}

	output = &CreateProcessingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProcessingJob API operation for Amazon SageMaker Service.
//
// Creates a processing job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateProcessingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob
func (c *SageMaker) CreateProcessingJob(input *CreateProcessingJobInput) (*CreateProcessingJobOutput, error) {
	req, out := c.CreateProcessingJobRequest(input)
	return out, req.Send()
}

// CreateProcessingJobWithContext is the same as CreateProcessingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProcessingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateProcessingJobWithContext(ctx aws.Context, input *CreateProcessingJobInput, opts ...request.Option) (*CreateProcessingJobOutput, error) {
	req, out := c.CreateProcessingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrainingJob = "CreateTrainingJob"

// CreateTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrainingJob for more information on using the CreateTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrainingJobRequest method.
//    req, resp := client.CreateTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob
func (c *SageMaker) CreateTrainingJobRequest(input *CreateTrainingJobInput) (req *request.Request, output *CreateTrainingJobOutput) {
	op := &request.Operation{
		Name:       opCreateTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrainingJobInput{}
	}

	output = &CreateTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrainingJob API operation for Amazon SageMaker Service.
//
// Starts a model training job. After training completes, Amazon SageMaker saves
// the resulting model artifacts to an Amazon S3 location that you specify.
//
// If you choose to host your model using Amazon SageMaker hosting services,
// you can use the resulting model artifacts as part of the model. You can also
// use the artifacts in a machine learning service other than Amazon SageMaker,
// provided that you know how to use them for inferences.
//
// In the request body, you provide the following:
//
//    * AlgorithmSpecification - Identifies the training algorithm to use.
//
//    * HyperParameters - Specify these algorithm-specific parameters to enable
//    the estimation of model parameters during training. Hyperparameters can
//    be tuned to optimize this learning process. For a list of hyperparameters
//    for each training algorithm provided by Amazon SageMaker, see Algorithms
//    (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
//
//    * InputDataConfig - Describes the training dataset and the Amazon S3,
//    EFS, or FSx location where it is stored.
//
//    * OutputDataConfig - Identifies the Amazon S3 bucket where you want Amazon
//    SageMaker to save the results of model training.
//
//    * ResourceConfig - Identifies the resources, ML compute instances, and
//    ML storage volumes to deploy for model training. In distributed training,
//    you specify more than one instance.
//
//    * EnableManagedSpotTraining - Optimize the cost of training machine learning
//    models by up to 80% by using Amazon EC2 Spot instances. For more information,
//    see Managed Spot Training (https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html).
//
//    * RoleARN - The Amazon Resource Number (ARN) that Amazon SageMaker assumes
//    to perform tasks on your behalf during model training. You must grant
//    this role the necessary permissions so that Amazon SageMaker can successfully
//    complete model training.
//
//    * StoppingCondition - To help cap training costs, use MaxRuntimeInSeconds
//    to set a time limit for training. Use MaxWaitTimeInSeconds to specify
//    how long you are willing to wait for a managed spot training job to complete.
//
// For more information about Amazon SageMaker, see How It Works (https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateTrainingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob
func (c *SageMaker) CreateTrainingJob(input *CreateTrainingJobInput) (*CreateTrainingJobOutput, error) {
	req, out := c.CreateTrainingJobRequest(input)
	return out, req.Send()
}

// CreateTrainingJobWithContext is the same as CreateTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateTrainingJobWithContext(ctx aws.Context, input *CreateTrainingJobInput, opts ...request.Option) (*CreateTrainingJobOutput, error) {
	req, out := c.CreateTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransformJob = "CreateTransformJob"

// CreateTransformJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransformJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransformJob for more information on using the CreateTransformJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransformJobRequest method.
//    req, resp := client.CreateTransformJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob
func (c *SageMaker) CreateTransformJobRequest(input *CreateTransformJobInput) (req *request.Request, output *CreateTransformJobOutput) {
	op := &request.Operation{
		Name:       opCreateTransformJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransformJobInput{}
	}

	output = &CreateTransformJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransformJob API operation for Amazon SageMaker Service.
//
// Starts a transform job. A transform job uses a trained model to get inferences
// on a dataset and saves these results to an Amazon S3 location that you specify.
//
// To perform batch transformations, you create a transform job and use the
// data that you have readily available.
//
// In the request body, you provide the following:
//
//    * TransformJobName - Identifies the transform job. The name must be unique
//    within an AWS Region in an AWS account.
//
//    * ModelName - Identifies the model to use. ModelName must be the name
//    of an existing Amazon SageMaker model in the same AWS Region and AWS account.
//    For information on creating a model, see CreateModel.
//
//    * TransformInput - Describes the dataset to be transformed and the Amazon
//    S3 location where it is stored.
//
//    * TransformOutput - Identifies the Amazon S3 location where you want Amazon
//    SageMaker to save the results from the transform job.
//
//    * TransformResources - Identifies the ML compute instances for the transform
//    job.
//
// For more information about how batch transformation works, see Batch Transform
// (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateTransformJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob
func (c *SageMaker) CreateTransformJob(input *CreateTransformJobInput) (*CreateTransformJobOutput, error) {
	req, out := c.CreateTransformJobRequest(input)
	return out, req.Send()
}

// CreateTransformJobWithContext is the same as CreateTransformJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransformJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateTransformJobWithContext(ctx aws.Context, input *CreateTransformJobInput, opts ...request.Option) (*CreateTransformJobOutput, error) {
	req, out := c.CreateTransformJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrial = "CreateTrial"

// CreateTrialRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrial for more information on using the CreateTrial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrialRequest method.
//    req, resp := client.CreateTrialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial
func (c *SageMaker) CreateTrialRequest(input *CreateTrialInput) (req *request.Request, output *CreateTrialOutput) {
	op := &request.Operation{
		Name:       opCreateTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrialInput{}
	}

	output = &CreateTrialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrial API operation for Amazon SageMaker Service.
//
// Creates an Amazon SageMaker trial. A trial is a set of steps called trial
// components that produce a machine learning model. A trial is part of a single
// Amazon SageMaker experiment.
//
// When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
// all experiments, trials, and trial components are automatically tracked,
// logged, and indexed. When you use the AWS SDK for Python (Boto), you must
// use the logging APIs provided by the SDK.
//
// You can add tags to a trial and then use the Search API to search for the
// tags.
//
// To get a list of all your trials, call the ListTrials API. To view a trial's
// properties, call the DescribeTrial API. To create a trial component, call
// the CreateTrialComponent API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateTrial for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial
func (c *SageMaker) CreateTrial(input *CreateTrialInput) (*CreateTrialOutput, error) {
	req, out := c.CreateTrialRequest(input)
	return out, req.Send()
}

// CreateTrialWithContext is the same as CreateTrial with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateTrialWithContext(ctx aws.Context, input *CreateTrialInput, opts ...request.Option) (*CreateTrialOutput, error) {
	req, out := c.CreateTrialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrialComponent = "CreateTrialComponent"

// CreateTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrialComponent for more information on using the CreateTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrialComponentRequest method.
//    req, resp := client.CreateTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent
func (c *SageMaker) CreateTrialComponentRequest(input *CreateTrialComponentInput) (req *request.Request, output *CreateTrialComponentOutput) {
	op := &request.Operation{
		Name:       opCreateTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrialComponentInput{}
	}

	output = &CreateTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrialComponent API operation for Amazon SageMaker Service.
//
// Creates a trial component, which is a stage of a machine learning trial.
// A trial is composed of one or more trial components. A trial component can
// be used in multiple trials.
//
// Trial components include pre-processing jobs, training jobs, and batch transform
// jobs.
//
// When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
// all experiments, trials, and trial components are automatically tracked,
// logged, and indexed. When you use the AWS SDK for Python (Boto), you must
// use the logging APIs provided by the SDK.
//
// You can add tags to a trial component and then use the Search API to search
// for the tags.
//
// CreateTrialComponent can only be invoked from within an Amazon SageMaker
// managed environment. This includes Amazon SageMaker training jobs, processing
// jobs, transform jobs, and Amazon SageMaker notebooks. A call to CreateTrialComponent
// from outside one of these environments results in an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent
func (c *SageMaker) CreateTrialComponent(input *CreateTrialComponentInput) (*CreateTrialComponentOutput, error) {
	req, out := c.CreateTrialComponentRequest(input)
	return out, req.Send()
}

// CreateTrialComponentWithContext is the same as CreateTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateTrialComponentWithContext(ctx aws.Context, input *CreateTrialComponentInput, opts ...request.Option) (*CreateTrialComponentOutput, error) {
	req, out := c.CreateTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserProfile = "CreateUserProfile"

// CreateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserProfile for more information on using the CreateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserProfileRequest method.
//    req, resp := client.CreateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile
func (c *SageMaker) CreateUserProfileRequest(input *CreateUserProfileInput) (req *request.Request, output *CreateUserProfileOutput) {
	op := &request.Operation{
		Name:       opCreateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserProfileInput{}
	}

	output = &CreateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserProfile API operation for Amazon SageMaker Service.
//
// Creates a new user profile. A user profile represents a single user within
// a Domain, and is the main way to reference a "person" for the purposes of
// sharing, reporting and other user-oriented features. This entity is created
// during on-boarding. If an administrator invites a person by email or imports
// them from SSO, a new UserProfile is automatically created. This entity is
// the primary holder of settings for an individual user and has a reference
// to the user's private Amazon Elastic File System (EFS) home directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateUserProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile
func (c *SageMaker) CreateUserProfile(input *CreateUserProfileInput) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	return out, req.Send()
}

// CreateUserProfileWithContext is the same as CreateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateUserProfileWithContext(ctx aws.Context, input *CreateUserProfileInput, opts ...request.Option) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkteam = "CreateWorkteam"

// CreateWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkteam for more information on using the CreateWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkteamRequest method.
//    req, resp := client.CreateWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam
func (c *SageMaker) CreateWorkteamRequest(input *CreateWorkteamInput) (req *request.Request, output *CreateWorkteamOutput) {
	op := &request.Operation{
		Name:       opCreateWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkteamInput{}
	}

	output = &CreateWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkteam API operation for Amazon SageMaker Service.
//
// Creates a new work team for labeling your data. A work team is defined by
// one or more Amazon Cognito user pools. You must first create the user pools
// before you can create a work team.
//
// You cannot create more than 25 work teams in an account and region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateWorkteam for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam
func (c *SageMaker) CreateWorkteam(input *CreateWorkteamInput) (*CreateWorkteamOutput, error) {
	req, out := c.CreateWorkteamRequest(input)
	return out, req.Send()
}

// CreateWorkteamWithContext is the same as CreateWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateWorkteamWithContext(ctx aws.Context, input *CreateWorkteamInput, opts ...request.Option) (*CreateWorkteamOutput, error) {
	req, out := c.CreateWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlgorithm = "DeleteAlgorithm"

// DeleteAlgorithmRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlgorithm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlgorithm for more information on using the DeleteAlgorithm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAlgorithmRequest method.
//    req, resp := client.DeleteAlgorithmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm
func (c *SageMaker) DeleteAlgorithmRequest(input *DeleteAlgorithmInput) (req *request.Request, output *DeleteAlgorithmOutput) {
	op := &request.Operation{
		Name:       opDeleteAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAlgorithmInput{}
	}

	output = &DeleteAlgorithmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlgorithm API operation for Amazon SageMaker Service.
//
// Removes the specified algorithm from your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteAlgorithm for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm
func (c *SageMaker) DeleteAlgorithm(input *DeleteAlgorithmInput) (*DeleteAlgorithmOutput, error) {
	req, out := c.DeleteAlgorithmRequest(input)
	return out, req.Send()
}

// DeleteAlgorithmWithContext is the same as DeleteAlgorithm with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlgorithm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteAlgorithmWithContext(ctx aws.Context, input *DeleteAlgorithmInput, opts ...request.Option) (*DeleteAlgorithmOutput, error) {
	req, out := c.DeleteAlgorithmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppRequest method.
//    req, resp := client.DeleteAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp
func (c *SageMaker) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApp API operation for Amazon SageMaker Service.
//
// Used to stop and delete an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteApp for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp
func (c *SageMaker) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCodeRepository = "DeleteCodeRepository"

// DeleteCodeRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCodeRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCodeRepository for more information on using the DeleteCodeRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCodeRepositoryRequest method.
//    req, resp := client.DeleteCodeRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository
func (c *SageMaker) DeleteCodeRepositoryRequest(input *DeleteCodeRepositoryInput) (req *request.Request, output *DeleteCodeRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCodeRepositoryInput{}
	}

	output = &DeleteCodeRepositoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCodeRepository API operation for Amazon SageMaker Service.
//
// Deletes the specified Git repository from your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteCodeRepository for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository
func (c *SageMaker) DeleteCodeRepository(input *DeleteCodeRepositoryInput) (*DeleteCodeRepositoryOutput, error) {
	req, out := c.DeleteCodeRepositoryRequest(input)
	return out, req.Send()
}

// DeleteCodeRepositoryWithContext is the same as DeleteCodeRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCodeRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteCodeRepositoryWithContext(ctx aws.Context, input *DeleteCodeRepositoryInput, opts ...request.Option) (*DeleteCodeRepositoryOutput, error) {
	req, out := c.DeleteCodeRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainRequest method.
//    req, resp := client.DeleteDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain
func (c *SageMaker) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDomain API operation for Amazon SageMaker Service.
//
// Used to delete a domain. If you on-boarded with IAM mode, you will need to
// delete your domain to on-board again using SSO. Use with caution. All of
// the members of the domain will lose access to their EFS volume, including
// data, notebooks, and other artifacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain
func (c *SageMaker) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint
func (c *SageMaker) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpoint API operation for Amazon SageMaker Service.
//
// Deletes an endpoint. Amazon SageMaker frees up all of the resources that
// were deployed when the endpoint was created.
//
// Amazon SageMaker retires any custom KMS key grants associated with the endpoint,
// meaning you don't need to use the RevokeGrant (http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html)
// API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint
func (c *SageMaker) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpointConfig = "DeleteEndpointConfig"

// DeleteEndpointConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpointConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpointConfig for more information on using the DeleteEndpointConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointConfigRequest method.
//    req, resp := client.DeleteEndpointConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig
func (c *SageMaker) DeleteEndpointConfigRequest(input *DeleteEndpointConfigInput) (req *request.Request, output *DeleteEndpointConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointConfigInput{}
	}

	output = &DeleteEndpointConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpointConfig API operation for Amazon SageMaker Service.
//
// Deletes an endpoint configuration. The DeleteEndpointConfig API deletes only
// the specified configuration. It does not delete endpoints created using the
// configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteEndpointConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig
func (c *SageMaker) DeleteEndpointConfig(input *DeleteEndpointConfigInput) (*DeleteEndpointConfigOutput, error) {
	req, out := c.DeleteEndpointConfigRequest(input)
	return out, req.Send()
}

// DeleteEndpointConfigWithContext is the same as DeleteEndpointConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpointConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteEndpointConfigWithContext(ctx aws.Context, input *DeleteEndpointConfigInput, opts ...request.Option) (*DeleteEndpointConfigOutput, error) {
	req, out := c.DeleteEndpointConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExperiment = "DeleteExperiment"

// DeleteExperimentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExperiment for more information on using the DeleteExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteExperimentRequest method.
//    req, resp := client.DeleteExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment
func (c *SageMaker) DeleteExperimentRequest(input *DeleteExperimentInput) (req *request.Request, output *DeleteExperimentOutput) {
	op := &request.Operation{
		Name:       opDeleteExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteExperimentInput{}
	}

	output = &DeleteExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteExperiment API operation for Amazon SageMaker Service.
//
// Deletes an Amazon SageMaker experiment. All trials associated with the experiment
// must be deleted first. Use the ListTrials API to get a list of the trials
// associated with the experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteExperiment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment
func (c *SageMaker) DeleteExperiment(input *DeleteExperimentInput) (*DeleteExperimentOutput, error) {
	req, out := c.DeleteExperimentRequest(input)
	return out, req.Send()
}

// DeleteExperimentWithContext is the same as DeleteExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteExperimentWithContext(ctx aws.Context, input *DeleteExperimentInput, opts ...request.Option) (*DeleteExperimentOutput, error) {
	req, out := c.DeleteExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlowDefinition = "DeleteFlowDefinition"

// DeleteFlowDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlowDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlowDefinition for more information on using the DeleteFlowDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFlowDefinitionRequest method.
//    req, resp := client.DeleteFlowDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition
func (c *SageMaker) DeleteFlowDefinitionRequest(input *DeleteFlowDefinitionInput) (req *request.Request, output *DeleteFlowDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteFlowDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFlowDefinitionInput{}
	}

	output = &DeleteFlowDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFlowDefinition API operation for Amazon SageMaker Service.
//
// Deletes the specified flow definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteFlowDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition
func (c *SageMaker) DeleteFlowDefinition(input *DeleteFlowDefinitionInput) (*DeleteFlowDefinitionOutput, error) {
	req, out := c.DeleteFlowDefinitionRequest(input)
	return out, req.Send()
}

// DeleteFlowDefinitionWithContext is the same as DeleteFlowDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlowDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteFlowDefinitionWithContext(ctx aws.Context, input *DeleteFlowDefinitionInput, opts ...request.Option) (*DeleteFlowDefinitionOutput, error) {
	req, out := c.DeleteFlowDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModel = "DeleteModel"

// DeleteModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModel for more information on using the DeleteModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelRequest method.
//    req, resp := client.DeleteModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel
func (c *SageMaker) DeleteModelRequest(input *DeleteModelInput) (req *request.Request, output *DeleteModelOutput) {
	op := &request.Operation{
		Name:       opDeleteModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelInput{}
	}

	output = &DeleteModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModel API operation for Amazon SageMaker Service.
//
// Deletes a model. The DeleteModel API deletes only the model entry that was
// created in Amazon SageMaker when you called the CreateModel (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html)
// API. It does not delete model artifacts, inference code, or the IAM role
// that you specified when creating the model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel
func (c *SageMaker) DeleteModel(input *DeleteModelInput) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	return out, req.Send()
}

// DeleteModelWithContext is the same as DeleteModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelWithContext(ctx aws.Context, input *DeleteModelInput, opts ...request.Option) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelPackage = "DeleteModelPackage"

// DeleteModelPackageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelPackage for more information on using the DeleteModelPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelPackageRequest method.
//    req, resp := client.DeleteModelPackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage
func (c *SageMaker) DeleteModelPackageRequest(input *DeleteModelPackageInput) (req *request.Request, output *DeleteModelPackageOutput) {
	op := &request.Operation{
		Name:       opDeleteModelPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelPackageInput{}
	}

	output = &DeleteModelPackageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelPackage API operation for Amazon SageMaker Service.
//
// Deletes a model package.
//
// A model package is used to create Amazon SageMaker models or list on AWS
// Marketplace. Buyers can subscribe to model packages listed on AWS Marketplace
// to create models in Amazon SageMaker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModelPackage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage
func (c *SageMaker) DeleteModelPackage(input *DeleteModelPackageInput) (*DeleteModelPackageOutput, error) {
	req, out := c.DeleteModelPackageRequest(input)
	return out, req.Send()
}

// DeleteModelPackageWithContext is the same as DeleteModelPackage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelPackageWithContext(ctx aws.Context, input *DeleteModelPackageInput, opts ...request.Option) (*DeleteModelPackageOutput, error) {
	req, out := c.DeleteModelPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMonitoringSchedule = "DeleteMonitoringSchedule"

// DeleteMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMonitoringSchedule for more information on using the DeleteMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMonitoringScheduleRequest method.
//    req, resp := client.DeleteMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule
func (c *SageMaker) DeleteMonitoringScheduleRequest(input *DeleteMonitoringScheduleInput) (req *request.Request, output *DeleteMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMonitoringScheduleInput{}
	}

	output = &DeleteMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Deletes a monitoring schedule. Also stops the schedule had not already been
// stopped. This does not delete the job execution history of the monitoring
// schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule
func (c *SageMaker) DeleteMonitoringSchedule(input *DeleteMonitoringScheduleInput) (*DeleteMonitoringScheduleOutput, error) {
	req, out := c.DeleteMonitoringScheduleRequest(input)
	return out, req.Send()
}

// DeleteMonitoringScheduleWithContext is the same as DeleteMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteMonitoringScheduleWithContext(ctx aws.Context, input *DeleteMonitoringScheduleInput, opts ...request.Option) (*DeleteMonitoringScheduleOutput, error) {
	req, out := c.DeleteMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotebookInstance = "DeleteNotebookInstance"

// DeleteNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotebookInstance for more information on using the DeleteNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotebookInstanceRequest method.
//    req, resp := client.DeleteNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance
func (c *SageMaker) DeleteNotebookInstanceRequest(input *DeleteNotebookInstanceInput) (req *request.Request, output *DeleteNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotebookInstanceInput{}
	}

	output = &DeleteNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotebookInstance API operation for Amazon SageMaker Service.
//
// Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook
// instance, you must call the StopNotebookInstance API.
//
// When you delete a notebook instance, you lose all of your data. Amazon SageMaker
// removes the ML compute instance, and deletes the ML storage volume and the
// network interface associated with the notebook instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteNotebookInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance
func (c *SageMaker) DeleteNotebookInstance(input *DeleteNotebookInstanceInput) (*DeleteNotebookInstanceOutput, error) {
	req, out := c.DeleteNotebookInstanceRequest(input)
	return out, req.Send()
}

// DeleteNotebookInstanceWithContext is the same as DeleteNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteNotebookInstanceWithContext(ctx aws.Context, input *DeleteNotebookInstanceInput, opts ...request.Option) (*DeleteNotebookInstanceOutput, error) {
	req, out := c.DeleteNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotebookInstanceLifecycleConfig = "DeleteNotebookInstanceLifecycleConfig"

// DeleteNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotebookInstanceLifecycleConfig for more information on using the DeleteNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.DeleteNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig
func (c *SageMaker) DeleteNotebookInstanceLifecycleConfigRequest(input *DeleteNotebookInstanceLifecycleConfigInput) (req *request.Request, output *DeleteNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotebookInstanceLifecycleConfigInput{}
	}

	output = &DeleteNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Deletes a notebook instance lifecycle configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteNotebookInstanceLifecycleConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig
func (c *SageMaker) DeleteNotebookInstanceLifecycleConfig(input *DeleteNotebookInstanceLifecycleConfigInput) (*DeleteNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DeleteNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// DeleteNotebookInstanceLifecycleConfigWithContext is the same as DeleteNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *DeleteNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*DeleteNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DeleteNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags
func (c *SageMaker) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon SageMaker Service.
//
// Deletes the specified tags from an Amazon SageMaker resource.
//
// To list a resource's tags, use the ListTags API.
//
// When you call this API to delete tags from a hyperparameter tuning job, the
// deleted tags are not removed from training jobs that the hyperparameter tuning
// job launched before you called this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags
func (c *SageMaker) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrial = "DeleteTrial"

// DeleteTrialRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrial for more information on using the DeleteTrial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrialRequest method.
//    req, resp := client.DeleteTrialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial
func (c *SageMaker) DeleteTrialRequest(input *DeleteTrialInput) (req *request.Request, output *DeleteTrialOutput) {
	op := &request.Operation{
		Name:       opDeleteTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrialInput{}
	}

	output = &DeleteTrialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrial API operation for Amazon SageMaker Service.
//
// Deletes the specified trial. All trial components that make up the trial
// must be deleted first. Use the DescribeTrialComponent API to get the list
// of trial components.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteTrial for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial
func (c *SageMaker) DeleteTrial(input *DeleteTrialInput) (*DeleteTrialOutput, error) {
	req, out := c.DeleteTrialRequest(input)
	return out, req.Send()
}

// DeleteTrialWithContext is the same as DeleteTrial with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteTrialWithContext(ctx aws.Context, input *DeleteTrialInput, opts ...request.Option) (*DeleteTrialOutput, error) {
	req, out := c.DeleteTrialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrialComponent = "DeleteTrialComponent"

// DeleteTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrialComponent for more information on using the DeleteTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrialComponentRequest method.
//    req, resp := client.DeleteTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent
func (c *SageMaker) DeleteTrialComponentRequest(input *DeleteTrialComponentInput) (req *request.Request, output *DeleteTrialComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrialComponentInput{}
	}

	output = &DeleteTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrialComponent API operation for Amazon SageMaker Service.
//
// Deletes the specified trial component. A trial component must be disassociated
// from all trials before the trial component can be deleted. To disassociate
// a trial component from a trial, call the DisassociateTrialComponent API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent
func (c *SageMaker) DeleteTrialComponent(input *DeleteTrialComponentInput) (*DeleteTrialComponentOutput, error) {
	req, out := c.DeleteTrialComponentRequest(input)
	return out, req.Send()
}

// DeleteTrialComponentWithContext is the same as DeleteTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteTrialComponentWithContext(ctx aws.Context, input *DeleteTrialComponentInput, opts ...request.Option) (*DeleteTrialComponentOutput, error) {
	req, out := c.DeleteTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserProfile = "DeleteUserProfile"

// DeleteUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserProfile for more information on using the DeleteUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserProfileRequest method.
//    req, resp := client.DeleteUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile
func (c *SageMaker) DeleteUserProfileRequest(input *DeleteUserProfileInput) (req *request.Request, output *DeleteUserProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserProfileInput{}
	}

	output = &DeleteUserProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserProfile API operation for Amazon SageMaker Service.
//
// Deletes a user profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteUserProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile
func (c *SageMaker) DeleteUserProfile(input *DeleteUserProfileInput) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	return out, req.Send()
}

// DeleteUserProfileWithContext is the same as DeleteUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteUserProfileWithContext(ctx aws.Context, input *DeleteUserProfileInput, opts ...request.Option) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkteam = "DeleteWorkteam"

// DeleteWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkteam for more information on using the DeleteWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkteamRequest method.
//    req, resp := client.DeleteWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam
func (c *SageMaker) DeleteWorkteamRequest(input *DeleteWorkteamInput) (req *request.Request, output *DeleteWorkteamOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkteamInput{}
	}

	output = &DeleteWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWorkteam API operation for Amazon SageMaker Service.
//
// Deletes an existing work team. This operation can't be undone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteWorkteam for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam
func (c *SageMaker) DeleteWorkteam(input *DeleteWorkteamInput) (*DeleteWorkteamOutput, error) {
	req, out := c.DeleteWorkteamRequest(input)
	return out, req.Send()
}

// DeleteWorkteamWithContext is the same as DeleteWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteWorkteamWithContext(ctx aws.Context, input *DeleteWorkteamInput, opts ...request.Option) (*DeleteWorkteamOutput, error) {
	req, out := c.DeleteWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlgorithm = "DescribeAlgorithm"

// DescribeAlgorithmRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlgorithm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlgorithm for more information on using the DescribeAlgorithm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAlgorithmRequest method.
//    req, resp := client.DescribeAlgorithmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm
func (c *SageMaker) DescribeAlgorithmRequest(input *DescribeAlgorithmInput) (req *request.Request, output *DescribeAlgorithmOutput) {
	op := &request.Operation{
		Name:       opDescribeAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlgorithmInput{}
	}

	output = &DescribeAlgorithmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlgorithm API operation for Amazon SageMaker Service.
//
// Returns a description of the specified algorithm that is in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeAlgorithm for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm
func (c *SageMaker) DescribeAlgorithm(input *DescribeAlgorithmInput) (*DescribeAlgorithmOutput, error) {
	req, out := c.DescribeAlgorithmRequest(input)
	return out, req.Send()
}

// DescribeAlgorithmWithContext is the same as DescribeAlgorithm with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlgorithm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeAlgorithmWithContext(ctx aws.Context, input *DescribeAlgorithmInput, opts ...request.Option) (*DescribeAlgorithmOutput, error) {
	req, out := c.DescribeAlgorithmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApp = "DescribeApp"

// DescribeAppRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApp for more information on using the DescribeApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAppRequest method.
//    req, resp := client.DescribeAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp
func (c *SageMaker) DescribeAppRequest(input *DescribeAppInput) (req *request.Request, output *DescribeAppOutput) {
	op := &request.Operation{
		Name:       opDescribeApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAppInput{}
	}

	output = &DescribeAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApp API operation for Amazon SageMaker Service.
//
// Describes the app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeApp for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp
func (c *SageMaker) DescribeApp(input *DescribeAppInput) (*DescribeAppOutput, error) {
	req, out := c.DescribeAppRequest(input)
	return out, req.Send()
}

// DescribeAppWithContext is the same as DescribeApp with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeAppWithContext(ctx aws.Context, input *DescribeAppInput, opts ...request.Option) (*DescribeAppOutput, error) {
	req, out := c.DescribeAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAutoMLJob = "DescribeAutoMLJob"

// DescribeAutoMLJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutoMLJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutoMLJob for more information on using the DescribeAutoMLJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAutoMLJobRequest method.
//    req, resp := client.DescribeAutoMLJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob
func (c *SageMaker) DescribeAutoMLJobRequest(input *DescribeAutoMLJobInput) (req *request.Request, output *DescribeAutoMLJobOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutoMLJobInput{}
	}

	output = &DescribeAutoMLJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutoMLJob API operation for Amazon SageMaker Service.
//
// Returns information about an Amazon SageMaker job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeAutoMLJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob
func (c *SageMaker) DescribeAutoMLJob(input *DescribeAutoMLJobInput) (*DescribeAutoMLJobOutput, error) {
	req, out := c.DescribeAutoMLJobRequest(input)
	return out, req.Send()
}

// DescribeAutoMLJobWithContext is the same as DescribeAutoMLJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutoMLJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeAutoMLJobWithContext(ctx aws.Context, input *DescribeAutoMLJobInput, opts ...request.Option) (*DescribeAutoMLJobOutput, error) {
	req, out := c.DescribeAutoMLJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCodeRepository = "DescribeCodeRepository"

// DescribeCodeRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCodeRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCodeRepository for more information on using the DescribeCodeRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCodeRepositoryRequest method.
//    req, resp := client.DescribeCodeRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository
func (c *SageMaker) DescribeCodeRepositoryRequest(input *DescribeCodeRepositoryInput) (req *request.Request, output *DescribeCodeRepositoryOutput) {
	op := &request.Operation{
		Name:       opDescribeCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCodeRepositoryInput{}
	}

	output = &DescribeCodeRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCodeRepository API operation for Amazon SageMaker Service.
//
// Gets details about the specified Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeCodeRepository for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository
func (c *SageMaker) DescribeCodeRepository(input *DescribeCodeRepositoryInput) (*DescribeCodeRepositoryOutput, error) {
	req, out := c.DescribeCodeRepositoryRequest(input)
	return out, req.Send()
}

// DescribeCodeRepositoryWithContext is the same as DescribeCodeRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCodeRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeCodeRepositoryWithContext(ctx aws.Context, input *DescribeCodeRepositoryInput, opts ...request.Option) (*DescribeCodeRepositoryOutput, error) {
	req, out := c.DescribeCodeRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCompilationJob = "DescribeCompilationJob"

// DescribeCompilationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCompilationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCompilationJob for more information on using the DescribeCompilationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCompilationJobRequest method.
//    req, resp := client.DescribeCompilationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob
func (c *SageMaker) DescribeCompilationJobRequest(input *DescribeCompilationJobInput) (req *request.Request, output *DescribeCompilationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeCompilationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCompilationJobInput{}
	}

	output = &DescribeCompilationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCompilationJob API operation for Amazon SageMaker Service.
//
// Returns information about a model compilation job.
//
// To create a model compilation job, use CreateCompilationJob. To get information
// about multiple model compilation jobs, use ListCompilationJobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeCompilationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob
func (c *SageMaker) DescribeCompilationJob(input *DescribeCompilationJobInput) (*DescribeCompilationJobOutput, error) {
	req, out := c.DescribeCompilationJobRequest(input)
	return out, req.Send()
}

// DescribeCompilationJobWithContext is the same as DescribeCompilationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCompilationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeCompilationJobWithContext(ctx aws.Context, input *DescribeCompilationJobInput, opts ...request.Option) (*DescribeCompilationJobOutput, error) {
	req, out := c.DescribeCompilationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomain for more information on using the DescribeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainRequest method.
//    req, resp := client.DescribeDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain
func (c *SageMaker) DescribeDomainRequest(input *DescribeDomainInput) (req *request.Request, output *DescribeDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	output = &DescribeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomain API operation for Amazon SageMaker Service.
//
// The desciption of the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeDomain for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain
func (c *SageMaker) DescribeDomain(input *DescribeDomainInput) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	return out, req.Send()
}

// DescribeDomainWithContext is the same as DescribeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeDomainWithContext(ctx aws.Context, input *DescribeDomainInput, opts ...request.Option) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoint for more information on using the DescribeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointRequest method.
//    req, resp := client.DescribeEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint
func (c *SageMaker) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	output = &DescribeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoint API operation for Amazon SageMaker Service.
//
// Returns the description of an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint
func (c *SageMaker) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	return out, req.Send()
}

// DescribeEndpointWithContext is the same as DescribeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeEndpointWithContext(ctx aws.Context, input *DescribeEndpointInput, opts ...request.Option) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpointConfig = "DescribeEndpointConfig"

// DescribeEndpointConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointConfig for more information on using the DescribeEndpointConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointConfigRequest method.
//    req, resp := client.DescribeEndpointConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig
func (c *SageMaker) DescribeEndpointConfigRequest(input *DescribeEndpointConfigInput) (req *request.Request, output *DescribeEndpointConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointConfigInput{}
	}

	output = &DescribeEndpointConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointConfig API operation for Amazon SageMaker Service.
//
// Returns the description of an endpoint configuration created using the CreateEndpointConfig
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeEndpointConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig
func (c *SageMaker) DescribeEndpointConfig(input *DescribeEndpointConfigInput) (*DescribeEndpointConfigOutput, error) {
	req, out := c.DescribeEndpointConfigRequest(input)
	return out, req.Send()
}

// DescribeEndpointConfigWithContext is the same as DescribeEndpointConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeEndpointConfigWithContext(ctx aws.Context, input *DescribeEndpointConfigInput, opts ...request.Option) (*DescribeEndpointConfigOutput, error) {
	req, out := c.DescribeEndpointConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExperiment = "DescribeExperiment"

// DescribeExperimentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExperiment for more information on using the DescribeExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExperimentRequest method.
//    req, resp := client.DescribeExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment
func (c *SageMaker) DescribeExperimentRequest(input *DescribeExperimentInput) (req *request.Request, output *DescribeExperimentOutput) {
	op := &request.Operation{
		Name:       opDescribeExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExperimentInput{}
	}

	output = &DescribeExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExperiment API operation for Amazon SageMaker Service.
//
// Provides a list of an experiment's properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeExperiment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment
func (c *SageMaker) DescribeExperiment(input *DescribeExperimentInput) (*DescribeExperimentOutput, error) {
	req, out := c.DescribeExperimentRequest(input)
	return out, req.Send()
}

// DescribeExperimentWithContext is the same as DescribeExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeExperimentWithContext(ctx aws.Context, input *DescribeExperimentInput, opts ...request.Option) (*DescribeExperimentOutput, error) {
	req, out := c.DescribeExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlowDefinition = "DescribeFlowDefinition"

// DescribeFlowDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlowDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlowDefinition for more information on using the DescribeFlowDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFlowDefinitionRequest method.
//    req, resp := client.DescribeFlowDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition
func (c *SageMaker) DescribeFlowDefinitionRequest(input *DescribeFlowDefinitionInput) (req *request.Request, output *DescribeFlowDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeFlowDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFlowDefinitionInput{}
	}

	output = &DescribeFlowDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlowDefinition API operation for Amazon SageMaker Service.
//
// Returns information about the specified flow definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeFlowDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition
func (c *SageMaker) DescribeFlowDefinition(input *DescribeFlowDefinitionInput) (*DescribeFlowDefinitionOutput, error) {
	req, out := c.DescribeFlowDefinitionRequest(input)
	return out, req.Send()
}

// DescribeFlowDefinitionWithContext is the same as DescribeFlowDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlowDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeFlowDefinitionWithContext(ctx aws.Context, input *DescribeFlowDefinitionInput, opts ...request.Option) (*DescribeFlowDefinitionOutput, error) {
	req, out := c.DescribeFlowDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHumanTaskUi = "DescribeHumanTaskUi"

// DescribeHumanTaskUiRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHumanTaskUi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHumanTaskUi for more information on using the DescribeHumanTaskUi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHumanTaskUiRequest method.
//    req, resp := client.DescribeHumanTaskUiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi
func (c *SageMaker) DescribeHumanTaskUiRequest(input *DescribeHumanTaskUiInput) (req *request.Request, output *DescribeHumanTaskUiOutput) {
	op := &request.Operation{
		Name:       opDescribeHumanTaskUi,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHumanTaskUiInput{}
	}

	output = &DescribeHumanTaskUiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHumanTaskUi API operation for Amazon SageMaker Service.
//
// Returns information about the requested human task user interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeHumanTaskUi for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi
func (c *SageMaker) DescribeHumanTaskUi(input *DescribeHumanTaskUiInput) (*DescribeHumanTaskUiOutput, error) {
	req, out := c.DescribeHumanTaskUiRequest(input)
	return out, req.Send()
}

// DescribeHumanTaskUiWithContext is the same as DescribeHumanTaskUi with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHumanTaskUi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeHumanTaskUiWithContext(ctx aws.Context, input *DescribeHumanTaskUiInput, opts ...request.Option) (*DescribeHumanTaskUiOutput, error) {
	req, out := c.DescribeHumanTaskUiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHyperParameterTuningJob = "DescribeHyperParameterTuningJob"

// DescribeHyperParameterTuningJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHyperParameterTuningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHyperParameterTuningJob for more information on using the DescribeHyperParameterTuningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHyperParameterTuningJobRequest method.
//    req, resp := client.DescribeHyperParameterTuningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob
func (c *SageMaker) DescribeHyperParameterTuningJobRequest(input *DescribeHyperParameterTuningJobInput) (req *request.Request, output *DescribeHyperParameterTuningJobOutput) {
	op := &request.Operation{
		Name:       opDescribeHyperParameterTuningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHyperParameterTuningJobInput{}
	}

	output = &DescribeHyperParameterTuningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHyperParameterTuningJob API operation for Amazon SageMaker Service.
//
// Gets a description of a hyperparameter tuning job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeHyperParameterTuningJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob
func (c *SageMaker) DescribeHyperParameterTuningJob(input *DescribeHyperParameterTuningJobInput) (*DescribeHyperParameterTuningJobOutput, error) {
	req, out := c.DescribeHyperParameterTuningJobRequest(input)
	return out, req.Send()
}

// DescribeHyperParameterTuningJobWithContext is the same as DescribeHyperParameterTuningJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHyperParameterTuningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeHyperParameterTuningJobWithContext(ctx aws.Context, input *DescribeHyperParameterTuningJobInput, opts ...request.Option) (*DescribeHyperParameterTuningJobOutput, error) {
	req, out := c.DescribeHyperParameterTuningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLabelingJob = "DescribeLabelingJob"

// DescribeLabelingJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLabelingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLabelingJob for more information on using the DescribeLabelingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLabelingJobRequest method.
//    req, resp := client.DescribeLabelingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob
func (c *SageMaker) DescribeLabelingJobRequest(input *DescribeLabelingJobInput) (req *request.Request, output *DescribeLabelingJobOutput) {
	op := &request.Operation{
		Name:       opDescribeLabelingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLabelingJobInput{}
	}

	output = &DescribeLabelingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLabelingJob API operation for Amazon SageMaker Service.
//
// Gets information about a labeling job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeLabelingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob
func (c *SageMaker) DescribeLabelingJob(input *DescribeLabelingJobInput) (*DescribeLabelingJobOutput, error) {
	req, out := c.DescribeLabelingJobRequest(input)
	return out, req.Send()
}

// DescribeLabelingJobWithContext is the same as DescribeLabelingJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLabelingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeLabelingJobWithContext(ctx aws.Context, input *DescribeLabelingJobInput, opts ...request.Option) (*DescribeLabelingJobOutput, error) {
	req, out := c.DescribeLabelingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModel = "DescribeModel"

// DescribeModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModel for more information on using the DescribeModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelRequest method.
//    req, resp := client.DescribeModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel
func (c *SageMaker) DescribeModelRequest(input *DescribeModelInput) (req *request.Request, output *DescribeModelOutput) {
	op := &request.Operation{
		Name:       opDescribeModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelInput{}
	}

	output = &DescribeModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModel API operation for Amazon SageMaker Service.
//
// Describes a model that you created using the CreateModel API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeModel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel
func (c *SageMaker) DescribeModel(input *DescribeModelInput) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	return out, req.Send()
}

// DescribeModelWithContext is the same as DescribeModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeModelWithContext(ctx aws.Context, input *DescribeModelInput, opts ...request.Option) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModelPackage = "DescribeModelPackage"

// DescribeModelPackageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModelPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModelPackage for more information on using the DescribeModelPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelPackageRequest method.
//    req, resp := client.DescribeModelPackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage
func (c *SageMaker) DescribeModelPackageRequest(input *DescribeModelPackageInput) (req *request.Request, output *DescribeModelPackageOutput) {
	op := &request.Operation{
		Name:       opDescribeModelPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelPackageInput{}
	}

	output = &DescribeModelPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModelPackage API operation for Amazon SageMaker Service.
//
// Returns a description of the specified model package, which is used to create
// Amazon SageMaker models or list them on AWS Marketplace.
//
// To create models in Amazon SageMaker, buyers can subscribe to model packages
// listed on AWS Marketplace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeModelPackage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage
func (c *SageMaker) DescribeModelPackage(input *DescribeModelPackageInput) (*DescribeModelPackageOutput, error) {
	req, out := c.DescribeModelPackageRequest(input)
	return out, req.Send()
}

// DescribeModelPackageWithContext is the same as DescribeModelPackage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModelPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeModelPackageWithContext(ctx aws.Context, input *DescribeModelPackageInput, opts ...request.Option) (*DescribeModelPackageOutput, error) {
	req, out := c.DescribeModelPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMonitoringSchedule = "DescribeMonitoringSchedule"

// DescribeMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMonitoringSchedule for more information on using the DescribeMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMonitoringScheduleRequest method.
//    req, resp := client.DescribeMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule
func (c *SageMaker) DescribeMonitoringScheduleRequest(input *DescribeMonitoringScheduleInput) (req *request.Request, output *DescribeMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMonitoringScheduleInput{}
	}

	output = &DescribeMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Describes the schedule for a monitoring job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule
func (c *SageMaker) DescribeMonitoringSchedule(input *DescribeMonitoringScheduleInput) (*DescribeMonitoringScheduleOutput, error) {
	req, out := c.DescribeMonitoringScheduleRequest(input)
	return out, req.Send()
}

// DescribeMonitoringScheduleWithContext is the same as DescribeMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeMonitoringScheduleWithContext(ctx aws.Context, input *DescribeMonitoringScheduleInput, opts ...request.Option) (*DescribeMonitoringScheduleOutput, error) {
	req, out := c.DescribeMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotebookInstance = "DescribeNotebookInstance"

// DescribeNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotebookInstance for more information on using the DescribeNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotebookInstanceRequest method.
//    req, resp := client.DescribeNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance
func (c *SageMaker) DescribeNotebookInstanceRequest(input *DescribeNotebookInstanceInput) (req *request.Request, output *DescribeNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNotebookInstanceInput{}
	}

	output = &DescribeNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotebookInstance API operation for Amazon SageMaker Service.
//
// Returns information about a notebook instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeNotebookInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance
func (c *SageMaker) DescribeNotebookInstance(input *DescribeNotebookInstanceInput) (*DescribeNotebookInstanceOutput, error) {
	req, out := c.DescribeNotebookInstanceRequest(input)
	return out, req.Send()
}

// DescribeNotebookInstanceWithContext is the same as DescribeNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeNotebookInstanceWithContext(ctx aws.Context, input *DescribeNotebookInstanceInput, opts ...request.Option) (*DescribeNotebookInstanceOutput, error) {
	req, out := c.DescribeNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotebookInstanceLifecycleConfig = "DescribeNotebookInstanceLifecycleConfig"

// DescribeNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotebookInstanceLifecycleConfig for more information on using the DescribeNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.DescribeNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig
func (c *SageMaker) DescribeNotebookInstanceLifecycleConfigRequest(input *DescribeNotebookInstanceLifecycleConfigInput) (req *request.Request, output *DescribeNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNotebookInstanceLifecycleConfigInput{}
	}

	output = &DescribeNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Returns a description of a notebook instance lifecycle configuration.
//
// For information about notebook instance lifestyle configurations, see Step
// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeNotebookInstanceLifecycleConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig
func (c *SageMaker) DescribeNotebookInstanceLifecycleConfig(input *DescribeNotebookInstanceLifecycleConfigInput) (*DescribeNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DescribeNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// DescribeNotebookInstanceLifecycleConfigWithContext is the same as DescribeNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *DescribeNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*DescribeNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DescribeNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProcessingJob = "DescribeProcessingJob"

// DescribeProcessingJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProcessingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProcessingJob for more information on using the DescribeProcessingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProcessingJobRequest method.
//    req, resp := client.DescribeProcessingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob
func (c *SageMaker) DescribeProcessingJobRequest(input *DescribeProcessingJobInput) (req *request.Request, output *DescribeProcessingJobOutput) {
	op := &request.Operation{
		Name:       opDescribeProcessingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProcessingJobInput{}
	}

	output = &DescribeProcessingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProcessingJob API operation for Amazon SageMaker Service.
//
// Returns a description of a processing job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeProcessingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob
func (c *SageMaker) DescribeProcessingJob(input *DescribeProcessingJobInput) (*DescribeProcessingJobOutput, error) {
	req, out := c.DescribeProcessingJobRequest(input)
	return out, req.Send()
}

// DescribeProcessingJobWithContext is the same as DescribeProcessingJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProcessingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeProcessingJobWithContext(ctx aws.Context, input *DescribeProcessingJobInput, opts ...request.Option) (*DescribeProcessingJobOutput, error) {
	req, out := c.DescribeProcessingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSubscribedWorkteam = "DescribeSubscribedWorkteam"

// DescribeSubscribedWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSubscribedWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSubscribedWorkteam for more information on using the DescribeSubscribedWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSubscribedWorkteamRequest method.
//    req, resp := client.DescribeSubscribedWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam
func (c *SageMaker) DescribeSubscribedWorkteamRequest(input *DescribeSubscribedWorkteamInput) (req *request.Request, output *DescribeSubscribedWorkteamOutput) {
	op := &request.Operation{
		Name:       opDescribeSubscribedWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSubscribedWorkteamInput{}
	}

	output = &DescribeSubscribedWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSubscribedWorkteam API operation for Amazon SageMaker Service.
//
// Gets information about a work team provided by a vendor. It returns details
// about the subscription with a vendor in the AWS Marketplace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeSubscribedWorkteam for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam
func (c *SageMaker) DescribeSubscribedWorkteam(input *DescribeSubscribedWorkteamInput) (*DescribeSubscribedWorkteamOutput, error) {
	req, out := c.DescribeSubscribedWorkteamRequest(input)
	return out, req.Send()
}

// DescribeSubscribedWorkteamWithContext is the same as DescribeSubscribedWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSubscribedWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeSubscribedWorkteamWithContext(ctx aws.Context, input *DescribeSubscribedWorkteamInput, opts ...request.Option) (*DescribeSubscribedWorkteamOutput, error) {
	req, out := c.DescribeSubscribedWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrainingJob = "DescribeTrainingJob"

// DescribeTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrainingJob for more information on using the DescribeTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrainingJobRequest method.
//    req, resp := client.DescribeTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob
func (c *SageMaker) DescribeTrainingJobRequest(input *DescribeTrainingJobInput) (req *request.Request, output *DescribeTrainingJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrainingJobInput{}
	}

	output = &DescribeTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrainingJob API operation for Amazon SageMaker Service.
//
// Returns information about a training job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeTrainingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob
func (c *SageMaker) DescribeTrainingJob(input *DescribeTrainingJobInput) (*DescribeTrainingJobOutput, error) {
	req, out := c.DescribeTrainingJobRequest(input)
	return out, req.Send()
}

// DescribeTrainingJobWithContext is the same as DescribeTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeTrainingJobWithContext(ctx aws.Context, input *DescribeTrainingJobInput, opts ...request.Option) (*DescribeTrainingJobOutput, error) {
	req, out := c.DescribeTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTransformJob = "DescribeTransformJob"

// DescribeTransformJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTransformJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTransformJob for more information on using the DescribeTransformJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTransformJobRequest method.
//    req, resp := client.DescribeTransformJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob
func (c *SageMaker) DescribeTransformJobRequest(input *DescribeTransformJobInput) (req *request.Request, output *DescribeTransformJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTransformJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTransformJobInput{}
	}

	output = &DescribeTransformJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTransformJob API operation for Amazon SageMaker Service.
//
// Returns information about a transform job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeTransformJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob
func (c *SageMaker) DescribeTransformJob(input *DescribeTransformJobInput) (*DescribeTransformJobOutput, error) {
	req, out := c.DescribeTransformJobRequest(input)
	return out, req.Send()
}

// DescribeTransformJobWithContext is the same as DescribeTransformJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTransformJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeTransformJobWithContext(ctx aws.Context, input *DescribeTransformJobInput, opts ...request.Option) (*DescribeTransformJobOutput, error) {
	req, out := c.DescribeTransformJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrial = "DescribeTrial"

// DescribeTrialRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrial for more information on using the DescribeTrial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrialRequest method.
//    req, resp := client.DescribeTrialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial
func (c *SageMaker) DescribeTrialRequest(input *DescribeTrialInput) (req *request.Request, output *DescribeTrialOutput) {
	op := &request.Operation{
		Name:       opDescribeTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrialInput{}
	}

	output = &DescribeTrialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrial API operation for Amazon SageMaker Service.
//
// Provides a list of a trial's properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeTrial for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial
func (c *SageMaker) DescribeTrial(input *DescribeTrialInput) (*DescribeTrialOutput, error) {
	req, out := c.DescribeTrialRequest(input)
	return out, req.Send()
}

// DescribeTrialWithContext is the same as DescribeTrial with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeTrialWithContext(ctx aws.Context, input *DescribeTrialInput, opts ...request.Option) (*DescribeTrialOutput, error) {
	req, out := c.DescribeTrialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrialComponent = "DescribeTrialComponent"

// DescribeTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrialComponent for more information on using the DescribeTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrialComponentRequest method.
//    req, resp := client.DescribeTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent
func (c *SageMaker) DescribeTrialComponentRequest(input *DescribeTrialComponentInput) (req *request.Request, output *DescribeTrialComponentOutput) {
	op := &request.Operation{
		Name:       opDescribeTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrialComponentInput{}
	}

	output = &DescribeTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrialComponent API operation for Amazon SageMaker Service.
//
// Provides a list of a trials component's properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent
func (c *SageMaker) DescribeTrialComponent(input *DescribeTrialComponentInput) (*DescribeTrialComponentOutput, error) {
	req, out := c.DescribeTrialComponentRequest(input)
	return out, req.Send()
}

// DescribeTrialComponentWithContext is the same as DescribeTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeTrialComponentWithContext(ctx aws.Context, input *DescribeTrialComponentInput, opts ...request.Option) (*DescribeTrialComponentOutput, error) {
	req, out := c.DescribeTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserProfile = "DescribeUserProfile"

// DescribeUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserProfile for more information on using the DescribeUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserProfileRequest method.
//    req, resp := client.DescribeUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile
func (c *SageMaker) DescribeUserProfileRequest(input *DescribeUserProfileInput) (req *request.Request, output *DescribeUserProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserProfileInput{}
	}

	output = &DescribeUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserProfile API operation for Amazon SageMaker Service.
//
// Describes the user profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeUserProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile
func (c *SageMaker) DescribeUserProfile(input *DescribeUserProfileInput) (*DescribeUserProfileOutput, error) {
	req, out := c.DescribeUserProfileRequest(input)
	return out, req.Send()
}

// DescribeUserProfileWithContext is the same as DescribeUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeUserProfileWithContext(ctx aws.Context, input *DescribeUserProfileInput, opts ...request.Option) (*DescribeUserProfileOutput, error) {
	req, out := c.DescribeUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkforce = "DescribeWorkforce"

// DescribeWorkforceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkforce operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkforce for more information on using the DescribeWorkforce
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkforceRequest method.
//    req, resp := client.DescribeWorkforceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce
func (c *SageMaker) DescribeWorkforceRequest(input *DescribeWorkforceInput) (req *request.Request, output *DescribeWorkforceOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkforce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkforceInput{}
	}

	output = &DescribeWorkforceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkforce API operation for Amazon SageMaker Service.
//
// Lists private workforce information, including workforce name, Amazon Resource
// Name (ARN), and, if applicable, allowed IP address ranges (CIDRs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)).
// Allowable IP address ranges are the IP addresses that workers can use to
// access tasks.
//
// This operation applies only to private workforces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeWorkforce for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce
func (c *SageMaker) DescribeWorkforce(input *DescribeWorkforceInput) (*DescribeWorkforceOutput, error) {
	req, out := c.DescribeWorkforceRequest(input)
	return out, req.Send()
}

// DescribeWorkforceWithContext is the same as DescribeWorkforce with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkforce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeWorkforceWithContext(ctx aws.Context, input *DescribeWorkforceInput, opts ...request.Option) (*DescribeWorkforceOutput, error) {
	req, out := c.DescribeWorkforceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkteam = "DescribeWorkteam"

// DescribeWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkteam for more information on using the DescribeWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkteamRequest method.
//    req, resp := client.DescribeWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam
func (c *SageMaker) DescribeWorkteamRequest(input *DescribeWorkteamInput) (req *request.Request, output *DescribeWorkteamOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkteamInput{}
	}

	output = &DescribeWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkteam API operation for Amazon SageMaker Service.
//
// Gets information about a specific work team. You can see information such
// as the create date, the last updated date, membership information, and the
// work team's Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeWorkteam for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam
func (c *SageMaker) DescribeWorkteam(input *DescribeWorkteamInput) (*DescribeWorkteamOutput, error) {
	req, out := c.DescribeWorkteamRequest(input)
	return out, req.Send()
}

// DescribeWorkteamWithContext is the same as DescribeWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeWorkteamWithContext(ctx aws.Context, input *DescribeWorkteamInput, opts ...request.Option) (*DescribeWorkteamOutput, error) {
	req, out := c.DescribeWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateTrialComponent = "DisassociateTrialComponent"

// DisassociateTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateTrialComponent for more information on using the DisassociateTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateTrialComponentRequest method.
//    req, resp := client.DisassociateTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent
func (c *SageMaker) DisassociateTrialComponentRequest(input *DisassociateTrialComponentInput) (req *request.Request, output *DisassociateTrialComponentOutput) {
	op := &request.Operation{
		Name:       opDisassociateTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateTrialComponentInput{}
	}

	output = &DisassociateTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateTrialComponent API operation for Amazon SageMaker Service.
//
// Disassociates a trial component from a trial. This doesn't effect other trials
// the component is associated with. Before you can delete a component, you
// must disassociate the component from all trials it is associated with. To
// associate a trial component with a trial, call the AssociateTrialComponent
// API.
//
// To get a list of the trials a component is associated with, use the Search
// API. Specify ExperimentTrialComponent for the Resource parameter. The list
// appears in the response under Results.TrialComponent.Parents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DisassociateTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent
func (c *SageMaker) DisassociateTrialComponent(input *DisassociateTrialComponentInput) (*DisassociateTrialComponentOutput, error) {
	req, out := c.DisassociateTrialComponentRequest(input)
	return out, req.Send()
}

// DisassociateTrialComponentWithContext is the same as DisassociateTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DisassociateTrialComponentWithContext(ctx aws.Context, input *DisassociateTrialComponentInput, opts ...request.Option) (*DisassociateTrialComponentOutput, error) {
	req, out := c.DisassociateTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSearchSuggestions = "GetSearchSuggestions"

// GetSearchSuggestionsRequest generates a "aws/request.Request" representing the
// client's request for the GetSearchSuggestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSearchSuggestions for more information on using the GetSearchSuggestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSearchSuggestionsRequest method.
//    req, resp := client.GetSearchSuggestionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions
func (c *SageMaker) GetSearchSuggestionsRequest(input *GetSearchSuggestionsInput) (req *request.Request, output *GetSearchSuggestionsOutput) {
	op := &request.Operation{
		Name:       opGetSearchSuggestions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSearchSuggestionsInput{}
	}

	output = &GetSearchSuggestionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSearchSuggestions API operation for Amazon SageMaker Service.
//
// An auto-complete API for the search functionality in the Amazon SageMaker
// console. It returns suggestions of possible matches for the property name
// to use in Search queries. Provides suggestions for HyperParameters, Tags,
// and Metrics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation GetSearchSuggestions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions
func (c *SageMaker) GetSearchSuggestions(input *GetSearchSuggestionsInput) (*GetSearchSuggestionsOutput, error) {
	req, out := c.GetSearchSuggestionsRequest(input)
	return out, req.Send()
}

// GetSearchSuggestionsWithContext is the same as GetSearchSuggestions with the addition of
// the ability to pass a context and additional request options.
//
// See GetSearchSuggestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) GetSearchSuggestionsWithContext(ctx aws.Context, input *GetSearchSuggestionsInput, opts ...request.Option) (*GetSearchSuggestionsOutput, error) {
	req, out := c.GetSearchSuggestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAlgorithms = "ListAlgorithms"

// ListAlgorithmsRequest generates a "aws/request.Request" representing the
// client's request for the ListAlgorithms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAlgorithms for more information on using the ListAlgorithms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAlgorithmsRequest method.
//    req, resp := client.ListAlgorithmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms
func (c *SageMaker) ListAlgorithmsRequest(input *ListAlgorithmsInput) (req *request.Request, output *ListAlgorithmsOutput) {
	op := &request.Operation{
		Name:       opListAlgorithms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAlgorithmsInput{}
	}

	output = &ListAlgorithmsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAlgorithms API operation for Amazon SageMaker Service.
//
// Lists the machine learning algorithms that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListAlgorithms for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms
func (c *SageMaker) ListAlgorithms(input *ListAlgorithmsInput) (*ListAlgorithmsOutput, error) {
	req, out := c.ListAlgorithmsRequest(input)
	return out, req.Send()
}

// ListAlgorithmsWithContext is the same as ListAlgorithms with the addition of
// the ability to pass a context and additional request options.
//
// See ListAlgorithms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAlgorithmsWithContext(ctx aws.Context, input *ListAlgorithmsInput, opts ...request.Option) (*ListAlgorithmsOutput, error) {
	req, out := c.ListAlgorithmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAlgorithmsPages iterates over the pages of a ListAlgorithms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAlgorithms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAlgorithms operation.
//    pageNum := 0
//    err := client.ListAlgorithmsPages(params,
//        func(page *sagemaker.ListAlgorithmsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListAlgorithmsPages(input *ListAlgorithmsInput, fn func(*ListAlgorithmsOutput, bool) bool) error {
	return c.ListAlgorithmsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAlgorithmsPagesWithContext same as ListAlgorithmsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAlgorithmsPagesWithContext(ctx aws.Context, input *ListAlgorithmsInput, fn func(*ListAlgorithmsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAlgorithmsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAlgorithmsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAlgorithmsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApps = "ListApps"

// ListAppsRequest generates a "aws/request.Request" representing the
// client's request for the ListApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApps for more information on using the ListApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppsRequest method.
//    req, resp := client.ListAppsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps
func (c *SageMaker) ListAppsRequest(input *ListAppsInput) (req *request.Request, output *ListAppsOutput) {
	op := &request.Operation{
		Name:       opListApps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppsInput{}
	}

	output = &ListAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApps API operation for Amazon SageMaker Service.
//
// Lists apps.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListApps for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps
func (c *SageMaker) ListApps(input *ListAppsInput) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	return out, req.Send()
}

// ListAppsWithContext is the same as ListApps with the addition of
// the ability to pass a context and additional request options.
//
// See ListApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAppsWithContext(ctx aws.Context, input *ListAppsInput, opts ...request.Option) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppsPages iterates over the pages of a ListApps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApps operation.
//    pageNum := 0
//    err := client.ListAppsPages(params,
//        func(page *sagemaker.ListAppsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListAppsPages(input *ListAppsInput, fn func(*ListAppsOutput, bool) bool) error {
	return c.ListAppsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppsPagesWithContext same as ListAppsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAppsPagesWithContext(ctx aws.Context, input *ListAppsInput, fn func(*ListAppsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAutoMLJobs = "ListAutoMLJobs"

// ListAutoMLJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListAutoMLJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAutoMLJobs for more information on using the ListAutoMLJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAutoMLJobsRequest method.
//    req, resp := client.ListAutoMLJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs
func (c *SageMaker) ListAutoMLJobsRequest(input *ListAutoMLJobsInput) (req *request.Request, output *ListAutoMLJobsOutput) {
	op := &request.Operation{
		Name:       opListAutoMLJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAutoMLJobsInput{}
	}

	output = &ListAutoMLJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAutoMLJobs API operation for Amazon SageMaker Service.
//
// Request a list of jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListAutoMLJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs
func (c *SageMaker) ListAutoMLJobs(input *ListAutoMLJobsInput) (*ListAutoMLJobsOutput, error) {
	req, out := c.ListAutoMLJobsRequest(input)
	return out, req.Send()
}

// ListAutoMLJobsWithContext is the same as ListAutoMLJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListAutoMLJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAutoMLJobsWithContext(ctx aws.Context, input *ListAutoMLJobsInput, opts ...request.Option) (*ListAutoMLJobsOutput, error) {
	req, out := c.ListAutoMLJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAutoMLJobsPages iterates over the pages of a ListAutoMLJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAutoMLJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAutoMLJobs operation.
//    pageNum := 0
//    err := client.ListAutoMLJobsPages(params,
//        func(page *sagemaker.ListAutoMLJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListAutoMLJobsPages(input *ListAutoMLJobsInput, fn func(*ListAutoMLJobsOutput, bool) bool) error {
	return c.ListAutoMLJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAutoMLJobsPagesWithContext same as ListAutoMLJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAutoMLJobsPagesWithContext(ctx aws.Context, input *ListAutoMLJobsInput, fn func(*ListAutoMLJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAutoMLJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAutoMLJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAutoMLJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCandidatesForAutoMLJob = "ListCandidatesForAutoMLJob"

// ListCandidatesForAutoMLJobRequest generates a "aws/request.Request" representing the
// client's request for the ListCandidatesForAutoMLJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCandidatesForAutoMLJob for more information on using the ListCandidatesForAutoMLJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCandidatesForAutoMLJobRequest method.
//    req, resp := client.ListCandidatesForAutoMLJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob
func (c *SageMaker) ListCandidatesForAutoMLJobRequest(input *ListCandidatesForAutoMLJobInput) (req *request.Request, output *ListCandidatesForAutoMLJobOutput) {
	op := &request.Operation{
		Name:       opListCandidatesForAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCandidatesForAutoMLJobInput{}
	}

	output = &ListCandidatesForAutoMLJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCandidatesForAutoMLJob API operation for Amazon SageMaker Service.
//
// List the Candidates created for the job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListCandidatesForAutoMLJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob
func (c *SageMaker) ListCandidatesForAutoMLJob(input *ListCandidatesForAutoMLJobInput) (*ListCandidatesForAutoMLJobOutput, error) {
	req, out := c.ListCandidatesForAutoMLJobRequest(input)
	return out, req.Send()
}

// ListCandidatesForAutoMLJobWithContext is the same as ListCandidatesForAutoMLJob with the addition of
// the ability to pass a context and additional request options.
//
// See ListCandidatesForAutoMLJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCandidatesForAutoMLJobWithContext(ctx aws.Context, input *ListCandidatesForAutoMLJobInput, opts ...request.Option) (*ListCandidatesForAutoMLJobOutput, error) {
	req, out := c.ListCandidatesForAutoMLJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCandidatesForAutoMLJobPages iterates over the pages of a ListCandidatesForAutoMLJob operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCandidatesForAutoMLJob method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCandidatesForAutoMLJob operation.
//    pageNum := 0
//    err := client.ListCandidatesForAutoMLJobPages(params,
//        func(page *sagemaker.ListCandidatesForAutoMLJobOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListCandidatesForAutoMLJobPages(input *ListCandidatesForAutoMLJobInput, fn func(*ListCandidatesForAutoMLJobOutput, bool) bool) error {
	return c.ListCandidatesForAutoMLJobPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCandidatesForAutoMLJobPagesWithContext same as ListCandidatesForAutoMLJobPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCandidatesForAutoMLJobPagesWithContext(ctx aws.Context, input *ListCandidatesForAutoMLJobInput, fn func(*ListCandidatesForAutoMLJobOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCandidatesForAutoMLJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCandidatesForAutoMLJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCandidatesForAutoMLJobOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCodeRepositories = "ListCodeRepositories"

// ListCodeRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListCodeRepositories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCodeRepositories for more information on using the ListCodeRepositories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCodeRepositoriesRequest method.
//    req, resp := client.ListCodeRepositoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories
func (c *SageMaker) ListCodeRepositoriesRequest(input *ListCodeRepositoriesInput) (req *request.Request, output *ListCodeRepositoriesOutput) {
	op := &request.Operation{
		Name:       opListCodeRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCodeRepositoriesInput{}
	}

	output = &ListCodeRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCodeRepositories API operation for Amazon SageMaker Service.
//
// Gets a list of the Git repositories in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListCodeRepositories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories
func (c *SageMaker) ListCodeRepositories(input *ListCodeRepositoriesInput) (*ListCodeRepositoriesOutput, error) {
	req, out := c.ListCodeRepositoriesRequest(input)
	return out, req.Send()
}

// ListCodeRepositoriesWithContext is the same as ListCodeRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See ListCodeRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCodeRepositoriesWithContext(ctx aws.Context, input *ListCodeRepositoriesInput, opts ...request.Option) (*ListCodeRepositoriesOutput, error) {
	req, out := c.ListCodeRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCodeRepositoriesPages iterates over the pages of a ListCodeRepositories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCodeRepositories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCodeRepositories operation.
//    pageNum := 0
//    err := client.ListCodeRepositoriesPages(params,
//        func(page *sagemaker.ListCodeRepositoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListCodeRepositoriesPages(input *ListCodeRepositoriesInput, fn func(*ListCodeRepositoriesOutput, bool) bool) error {
	return c.ListCodeRepositoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCodeRepositoriesPagesWithContext same as ListCodeRepositoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCodeRepositoriesPagesWithContext(ctx aws.Context, input *ListCodeRepositoriesInput, fn func(*ListCodeRepositoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCodeRepositoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCodeRepositoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCodeRepositoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCompilationJobs = "ListCompilationJobs"

// ListCompilationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListCompilationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCompilationJobs for more information on using the ListCompilationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCompilationJobsRequest method.
//    req, resp := client.ListCompilationJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs
func (c *SageMaker) ListCompilationJobsRequest(input *ListCompilationJobsInput) (req *request.Request, output *ListCompilationJobsOutput) {
	op := &request.Operation{
		Name:       opListCompilationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCompilationJobsInput{}
	}

	output = &ListCompilationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCompilationJobs API operation for Amazon SageMaker Service.
//
// Lists model compilation jobs that satisfy various filters.
//
// To create a model compilation job, use CreateCompilationJob. To get information
// about a particular model compilation job you have created, use DescribeCompilationJob.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListCompilationJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs
func (c *SageMaker) ListCompilationJobs(input *ListCompilationJobsInput) (*ListCompilationJobsOutput, error) {
	req, out := c.ListCompilationJobsRequest(input)
	return out, req.Send()
}

// ListCompilationJobsWithContext is the same as ListCompilationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListCompilationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCompilationJobsWithContext(ctx aws.Context, input *ListCompilationJobsInput, opts ...request.Option) (*ListCompilationJobsOutput, error) {
	req, out := c.ListCompilationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCompilationJobsPages iterates over the pages of a ListCompilationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCompilationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCompilationJobs operation.
//    pageNum := 0
//    err := client.ListCompilationJobsPages(params,
//        func(page *sagemaker.ListCompilationJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListCompilationJobsPages(input *ListCompilationJobsInput, fn func(*ListCompilationJobsOutput, bool) bool) error {
	return c.ListCompilationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCompilationJobsPagesWithContext same as ListCompilationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCompilationJobsPagesWithContext(ctx aws.Context, input *ListCompilationJobsInput, fn func(*ListCompilationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCompilationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCompilationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCompilationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainsRequest method.
//    req, resp := client.ListDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDomains
func (c *SageMaker) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon SageMaker Service.
//
// Lists the domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListDomains for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDomains
func (c *SageMaker) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDomains operation.
//    pageNum := 0
//    err := client.ListDomainsPages(params,
//        func(page *sagemaker.ListDomainsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEndpointConfigs = "ListEndpointConfigs"

// ListEndpointConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpointConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpointConfigs for more information on using the ListEndpointConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEndpointConfigsRequest method.
//    req, resp := client.ListEndpointConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs
func (c *SageMaker) ListEndpointConfigsRequest(input *ListEndpointConfigsInput) (req *request.Request, output *ListEndpointConfigsOutput) {
	op := &request.Operation{
		Name:       opListEndpointConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointConfigsInput{}
	}

	output = &ListEndpointConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpointConfigs API operation for Amazon SageMaker Service.
//
// Lists endpoint configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListEndpointConfigs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs
func (c *SageMaker) ListEndpointConfigs(input *ListEndpointConfigsInput) (*ListEndpointConfigsOutput, error) {
	req, out := c.ListEndpointConfigsRequest(input)
	return out, req.Send()
}

// ListEndpointConfigsWithContext is the same as ListEndpointConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpointConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointConfigsWithContext(ctx aws.Context, input *ListEndpointConfigsInput, opts ...request.Option) (*ListEndpointConfigsOutput, error) {
	req, out := c.ListEndpointConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointConfigsPages iterates over the pages of a ListEndpointConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpointConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEndpointConfigs operation.
//    pageNum := 0
//    err := client.ListEndpointConfigsPages(params,
//        func(page *sagemaker.ListEndpointConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListEndpointConfigsPages(input *ListEndpointConfigsInput, fn func(*ListEndpointConfigsOutput, bool) bool) error {
	return c.ListEndpointConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointConfigsPagesWithContext same as ListEndpointConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointConfigsPagesWithContext(ctx aws.Context, input *ListEndpointConfigsInput, fn func(*ListEndpointConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEndpointConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEndpoints = "ListEndpoints"

// ListEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpoints for more information on using the ListEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEndpointsRequest method.
//    req, resp := client.ListEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints
func (c *SageMaker) ListEndpointsRequest(input *ListEndpointsInput) (req *request.Request, output *ListEndpointsOutput) {
	op := &request.Operation{
		Name:       opListEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointsInput{}
	}

	output = &ListEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpoints API operation for Amazon SageMaker Service.
//
// Lists endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListEndpoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints
func (c *SageMaker) ListEndpoints(input *ListEndpointsInput) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	return out, req.Send()
}

// ListEndpointsWithContext is the same as ListEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointsWithContext(ctx aws.Context, input *ListEndpointsInput, opts ...request.Option) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointsPages iterates over the pages of a ListEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEndpoints operation.
//    pageNum := 0
//    err := client.ListEndpointsPages(params,
//        func(page *sagemaker.ListEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListEndpointsPages(input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool) error {
	return c.ListEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointsPagesWithContext same as ListEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointsPagesWithContext(ctx aws.Context, input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExperiments = "ListExperiments"

// ListExperimentsRequest generates a "aws/request.Request" representing the
// client's request for the ListExperiments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExperiments for more information on using the ListExperiments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListExperimentsRequest method.
//    req, resp := client.ListExperimentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListExperiments
func (c *SageMaker) ListExperimentsRequest(input *ListExperimentsInput) (req *request.Request, output *ListExperimentsOutput) {
	op := &request.Operation{
		Name:       opListExperiments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExperimentsInput{}
	}

	output = &ListExperimentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExperiments API operation for Amazon SageMaker Service.
//
// Lists all the experiments in your account. The list can be filtered to show
// only experiments that were created in a specific time range. The list can
// be sorted by experiment name or creation time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListExperiments for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListExperiments
func (c *SageMaker) ListExperiments(input *ListExperimentsInput) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	return out, req.Send()
}

// ListExperimentsWithContext is the same as ListExperiments with the addition of
// the ability to pass a context and additional request options.
//
// See ListExperiments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListExperimentsWithContext(ctx aws.Context, input *ListExperimentsInput, opts ...request.Option) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExperimentsPages iterates over the pages of a ListExperiments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExperiments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExperiments operation.
//    pageNum := 0
//    err := client.ListExperimentsPages(params,
//        func(page *sagemaker.ListExperimentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListExperimentsPages(input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool) error {
	return c.ListExperimentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExperimentsPagesWithContext same as ListExperimentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListExperimentsPagesWithContext(ctx aws.Context, input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExperimentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExperimentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExperimentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFlowDefinitions = "ListFlowDefinitions"

// ListFlowDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFlowDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlowDefinitions for more information on using the ListFlowDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFlowDefinitionsRequest method.
//    req, resp := client.ListFlowDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFlowDefinitions
func (c *SageMaker) ListFlowDefinitionsRequest(input *ListFlowDefinitionsInput) (req *request.Request, output *ListFlowDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListFlowDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowDefinitionsInput{}
	}

	output = &ListFlowDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlowDefinitions API operation for Amazon SageMaker Service.
//
// Returns information about the flow definitions in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListFlowDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFlowDefinitions
func (c *SageMaker) ListFlowDefinitions(input *ListFlowDefinitionsInput) (*ListFlowDefinitionsOutput, error) {
	req, out := c.ListFlowDefinitionsRequest(input)
	return out, req.Send()
}

// ListFlowDefinitionsWithContext is the same as ListFlowDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlowDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListFlowDefinitionsWithContext(ctx aws.Context, input *ListFlowDefinitionsInput, opts ...request.Option) (*ListFlowDefinitionsOutput, error) {
	req, out := c.ListFlowDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowDefinitionsPages iterates over the pages of a ListFlowDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlowDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFlowDefinitions operation.
//    pageNum := 0
//    err := client.ListFlowDefinitionsPages(params,
//        func(page *sagemaker.ListFlowDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListFlowDefinitionsPages(input *ListFlowDefinitionsInput, fn func(*ListFlowDefinitionsOutput, bool) bool) error {
	return c.ListFlowDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowDefinitionsPagesWithContext same as ListFlowDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListFlowDefinitionsPagesWithContext(ctx aws.Context, input *ListFlowDefinitionsInput, fn func(*ListFlowDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlowDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHumanTaskUis = "ListHumanTaskUis"

// ListHumanTaskUisRequest generates a "aws/request.Request" representing the
// client's request for the ListHumanTaskUis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHumanTaskUis for more information on using the ListHumanTaskUis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHumanTaskUisRequest method.
//    req, resp := client.ListHumanTaskUisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHumanTaskUis
func (c *SageMaker) ListHumanTaskUisRequest(input *ListHumanTaskUisInput) (req *request.Request, output *ListHumanTaskUisOutput) {
	op := &request.Operation{
		Name:       opListHumanTaskUis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHumanTaskUisInput{}
	}

	output = &ListHumanTaskUisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHumanTaskUis API operation for Amazon SageMaker Service.
//
// Returns information about the human task user interfaces in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListHumanTaskUis for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHumanTaskUis
func (c *SageMaker) ListHumanTaskUis(input *ListHumanTaskUisInput) (*ListHumanTaskUisOutput, error) {
	req, out := c.ListHumanTaskUisRequest(input)
	return out, req.Send()
}

// ListHumanTaskUisWithContext is the same as ListHumanTaskUis with the addition of
// the ability to pass a context and additional request options.
//
// See ListHumanTaskUis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListHumanTaskUisWithContext(ctx aws.Context, input *ListHumanTaskUisInput, opts ...request.Option) (*ListHumanTaskUisOutput, error) {
	req, out := c.ListHumanTaskUisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHumanTaskUisPages iterates over the pages of a ListHumanTaskUis operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHumanTaskUis method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHumanTaskUis operation.
//    pageNum := 0
//    err := client.ListHumanTaskUisPages(params,
//        func(page *sagemaker.ListHumanTaskUisOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListHumanTaskUisPages(input *ListHumanTaskUisInput, fn func(*ListHumanTaskUisOutput, bool) bool) error {
	return c.ListHumanTaskUisPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHumanTaskUisPagesWithContext same as ListHumanTaskUisPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListHumanTaskUisPagesWithContext(ctx aws.Context, input *ListHumanTaskUisInput, fn func(*ListHumanTaskUisOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHumanTaskUisInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHumanTaskUisRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHumanTaskUisOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHyperParameterTuningJobs = "ListHyperParameterTuningJobs"

// ListHyperParameterTuningJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListHyperParameterTuningJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHyperParameterTuningJobs for more information on using the ListHyperParameterTuningJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHyperParameterTuningJobsRequest method.
//    req, resp := client.ListHyperParameterTuningJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs
func (c *SageMaker) ListHyperParameterTuningJobsRequest(input *ListHyperParameterTuningJobsInput) (req *request.Request, output *ListHyperParameterTuningJobsOutput) {
	op := &request.Operation{
		Name:       opListHyperParameterTuningJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHyperParameterTuningJobsInput{}
	}

	output = &ListHyperParameterTuningJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHyperParameterTuningJobs API operation for Amazon SageMaker Service.
//
// Gets a list of HyperParameterTuningJobSummary objects that describe the hyperparameter
// tuning jobs launched in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListHyperParameterTuningJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs
func (c *SageMaker) ListHyperParameterTuningJobs(input *ListHyperParameterTuningJobsInput) (*ListHyperParameterTuningJobsOutput, error) {
	req, out := c.ListHyperParameterTuningJobsRequest(input)
	return out, req.Send()
}

// ListHyperParameterTuningJobsWithContext is the same as ListHyperParameterTuningJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListHyperParameterTuningJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListHyperParameterTuningJobsWithContext(ctx aws.Context, input *ListHyperParameterTuningJobsInput, opts ...request.Option) (*ListHyperParameterTuningJobsOutput, error) {
	req, out := c.ListHyperParameterTuningJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHyperParameterTuningJobsPages iterates over the pages of a ListHyperParameterTuningJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHyperParameterTuningJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHyperParameterTuningJobs operation.
//    pageNum := 0
//    err := client.ListHyperParameterTuningJobsPages(params,
//        func(page *sagemaker.ListHyperParameterTuningJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListHyperParameterTuningJobsPages(input *ListHyperParameterTuningJobsInput, fn func(*ListHyperParameterTuningJobsOutput, bool) bool) error {
	return c.ListHyperParameterTuningJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHyperParameterTuningJobsPagesWithContext same as ListHyperParameterTuningJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListHyperParameterTuningJobsPagesWithContext(ctx aws.Context, input *ListHyperParameterTuningJobsInput, fn func(*ListHyperParameterTuningJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHyperParameterTuningJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHyperParameterTuningJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHyperParameterTuningJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLabelingJobs = "ListLabelingJobs"

// ListLabelingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListLabelingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLabelingJobs for more information on using the ListLabelingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLabelingJobsRequest method.
//    req, resp := client.ListLabelingJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs
func (c *SageMaker) ListLabelingJobsRequest(input *ListLabelingJobsInput) (req *request.Request, output *ListLabelingJobsOutput) {
	op := &request.Operation{
		Name:       opListLabelingJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLabelingJobsInput{}
	}

	output = &ListLabelingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLabelingJobs API operation for Amazon SageMaker Service.
//
// Gets a list of labeling jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListLabelingJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs
func (c *SageMaker) ListLabelingJobs(input *ListLabelingJobsInput) (*ListLabelingJobsOutput, error) {
	req, out := c.ListLabelingJobsRequest(input)
	return out, req.Send()
}

// ListLabelingJobsWithContext is the same as ListLabelingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListLabelingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListLabelingJobsWithContext(ctx aws.Context, input *ListLabelingJobsInput, opts ...request.Option) (*ListLabelingJobsOutput, error) {
	req, out := c.ListLabelingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLabelingJobsPages iterates over the pages of a ListLabelingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLabelingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLabelingJobs operation.
//    pageNum := 0
//    err := client.ListLabelingJobsPages(params,
//        func(page *sagemaker.ListLabelingJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListLabelingJobsPages(input *ListLabelingJobsInput, fn func(*ListLabelingJobsOutput, bool) bool) error {
	return c.ListLabelingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLabelingJobsPagesWithContext same as ListLabelingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListLabelingJobsPagesWithContext(ctx aws.Context, input *ListLabelingJobsInput, fn func(*ListLabelingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLabelingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLabelingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLabelingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLabelingJobsForWorkteam = "ListLabelingJobsForWorkteam"

// ListLabelingJobsForWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the ListLabelingJobsForWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLabelingJobsForWorkteam for more information on using the ListLabelingJobsForWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLabelingJobsForWorkteamRequest method.
//    req, resp := client.ListLabelingJobsForWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam
func (c *SageMaker) ListLabelingJobsForWorkteamRequest(input *ListLabelingJobsForWorkteamInput) (req *request.Request, output *ListLabelingJobsForWorkteamOutput) {
	op := &request.Operation{
		Name:       opListLabelingJobsForWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLabelingJobsForWorkteamInput{}
	}

	output = &ListLabelingJobsForWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLabelingJobsForWorkteam API operation for Amazon SageMaker Service.
//
// Gets a list of labeling jobs assigned to a specified work team.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListLabelingJobsForWorkteam for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam
func (c *SageMaker) ListLabelingJobsForWorkteam(input *ListLabelingJobsForWorkteamInput) (*ListLabelingJobsForWorkteamOutput, error) {
	req, out := c.ListLabelingJobsForWorkteamRequest(input)
	return out, req.Send()
}

// ListLabelingJobsForWorkteamWithContext is the same as ListLabelingJobsForWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See ListLabelingJobsForWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListLabelingJobsForWorkteamWithContext(ctx aws.Context, input *ListLabelingJobsForWorkteamInput, opts ...request.Option) (*ListLabelingJobsForWorkteamOutput, error) {
	req, out := c.ListLabelingJobsForWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLabelingJobsForWorkteamPages iterates over the pages of a ListLabelingJobsForWorkteam operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLabelingJobsForWorkteam method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLabelingJobsForWorkteam operation.
//    pageNum := 0
//    err := client.ListLabelingJobsForWorkteamPages(params,
//        func(page *sagemaker.ListLabelingJobsForWorkteamOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListLabelingJobsForWorkteamPages(input *ListLabelingJobsForWorkteamInput, fn func(*ListLabelingJobsForWorkteamOutput, bool) bool) error {
	return c.ListLabelingJobsForWorkteamPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLabelingJobsForWorkteamPagesWithContext same as ListLabelingJobsForWorkteamPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListLabelingJobsForWorkteamPagesWithContext(ctx aws.Context, input *ListLabelingJobsForWorkteamInput, fn func(*ListLabelingJobsForWorkteamOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLabelingJobsForWorkteamInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLabelingJobsForWorkteamRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLabelingJobsForWorkteamOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModelPackages = "ListModelPackages"

// ListModelPackagesRequest generates a "aws/request.Request" representing the
// client's request for the ListModelPackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelPackages for more information on using the ListModelPackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelPackagesRequest method.
//    req, resp := client.ListModelPackagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages
func (c *SageMaker) ListModelPackagesRequest(input *ListModelPackagesInput) (req *request.Request, output *ListModelPackagesOutput) {
	op := &request.Operation{
		Name:       opListModelPackages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelPackagesInput{}
	}

	output = &ListModelPackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelPackages API operation for Amazon SageMaker Service.
//
// Lists the model packages that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListModelPackages for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages
func (c *SageMaker) ListModelPackages(input *ListModelPackagesInput) (*ListModelPackagesOutput, error) {
	req, out := c.ListModelPackagesRequest(input)
	return out, req.Send()
}

// ListModelPackagesWithContext is the same as ListModelPackages with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelPackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelPackagesWithContext(ctx aws.Context, input *ListModelPackagesInput, opts ...request.Option) (*ListModelPackagesOutput, error) {
	req, out := c.ListModelPackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelPackagesPages iterates over the pages of a ListModelPackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelPackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModelPackages operation.
//    pageNum := 0
//    err := client.ListModelPackagesPages(params,
//        func(page *sagemaker.ListModelPackagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListModelPackagesPages(input *ListModelPackagesInput, fn func(*ListModelPackagesOutput, bool) bool) error {
	return c.ListModelPackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelPackagesPagesWithContext same as ListModelPackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelPackagesPagesWithContext(ctx aws.Context, input *ListModelPackagesInput, fn func(*ListModelPackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelPackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelPackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelPackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModels = "ListModels"

// ListModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModels for more information on using the ListModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelsRequest method.
//    req, resp := client.ListModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels
func (c *SageMaker) ListModelsRequest(input *ListModelsInput) (req *request.Request, output *ListModelsOutput) {
	op := &request.Operation{
		Name:       opListModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelsInput{}
	}

	output = &ListModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModels API operation for Amazon SageMaker Service.
//
// Lists models created with the CreateModel (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListModels for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels
func (c *SageMaker) ListModels(input *ListModelsInput) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	return out, req.Send()
}

// ListModelsWithContext is the same as ListModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelsWithContext(ctx aws.Context, input *ListModelsInput, opts ...request.Option) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelsPages iterates over the pages of a ListModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModels operation.
//    pageNum := 0
//    err := client.ListModelsPages(params,
//        func(page *sagemaker.ListModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListModelsPages(input *ListModelsInput, fn func(*ListModelsOutput, bool) bool) error {
	return c.ListModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelsPagesWithContext same as ListModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelsPagesWithContext(ctx aws.Context, input *ListModelsInput, fn func(*ListModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMonitoringExecutions = "ListMonitoringExecutions"

// ListMonitoringExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListMonitoringExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMonitoringExecutions for more information on using the ListMonitoringExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMonitoringExecutionsRequest method.
//    req, resp := client.ListMonitoringExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringExecutions
func (c *SageMaker) ListMonitoringExecutionsRequest(input *ListMonitoringExecutionsInput) (req *request.Request, output *ListMonitoringExecutionsOutput) {
	op := &request.Operation{
		Name:       opListMonitoringExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMonitoringExecutionsInput{}
	}

	output = &ListMonitoringExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMonitoringExecutions API operation for Amazon SageMaker Service.
//
// Returns list of all monitoring job executions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListMonitoringExecutions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringExecutions
func (c *SageMaker) ListMonitoringExecutions(input *ListMonitoringExecutionsInput) (*ListMonitoringExecutionsOutput, error) {
	req, out := c.ListMonitoringExecutionsRequest(input)
	return out, req.Send()
}

// ListMonitoringExecutionsWithContext is the same as ListMonitoringExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListMonitoringExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListMonitoringExecutionsWithContext(ctx aws.Context, input *ListMonitoringExecutionsInput, opts ...request.Option) (*ListMonitoringExecutionsOutput, error) {
	req, out := c.ListMonitoringExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMonitoringExecutionsPages iterates over the pages of a ListMonitoringExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMonitoringExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMonitoringExecutions operation.
//    pageNum := 0
//    err := client.ListMonitoringExecutionsPages(params,
//        func(page *sagemaker.ListMonitoringExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListMonitoringExecutionsPages(input *ListMonitoringExecutionsInput, fn func(*ListMonitoringExecutionsOutput, bool) bool) error {
	return c.ListMonitoringExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMonitoringExecutionsPagesWithContext same as ListMonitoringExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListMonitoringExecutionsPagesWithContext(ctx aws.Context, input *ListMonitoringExecutionsInput, fn func(*ListMonitoringExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMonitoringExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMonitoringExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMonitoringExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMonitoringSchedules = "ListMonitoringSchedules"

// ListMonitoringSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the ListMonitoringSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMonitoringSchedules for more information on using the ListMonitoringSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMonitoringSchedulesRequest method.
//    req, resp := client.ListMonitoringSchedulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringSchedules
func (c *SageMaker) ListMonitoringSchedulesRequest(input *ListMonitoringSchedulesInput) (req *request.Request, output *ListMonitoringSchedulesOutput) {
	op := &request.Operation{
		Name:       opListMonitoringSchedules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMonitoringSchedulesInput{}
	}

	output = &ListMonitoringSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMonitoringSchedules API operation for Amazon SageMaker Service.
//
// Returns list of all monitoring schedules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListMonitoringSchedules for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringSchedules
func (c *SageMaker) ListMonitoringSchedules(input *ListMonitoringSchedulesInput) (*ListMonitoringSchedulesOutput, error) {
	req, out := c.ListMonitoringSchedulesRequest(input)
	return out, req.Send()
}

// ListMonitoringSchedulesWithContext is the same as ListMonitoringSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See ListMonitoringSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListMonitoringSchedulesWithContext(ctx aws.Context, input *ListMonitoringSchedulesInput, opts ...request.Option) (*ListMonitoringSchedulesOutput, error) {
	req, out := c.ListMonitoringSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMonitoringSchedulesPages iterates over the pages of a ListMonitoringSchedules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMonitoringSchedules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMonitoringSchedules operation.
//    pageNum := 0
//    err := client.ListMonitoringSchedulesPages(params,
//        func(page *sagemaker.ListMonitoringSchedulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListMonitoringSchedulesPages(input *ListMonitoringSchedulesInput, fn func(*ListMonitoringSchedulesOutput, bool) bool) error {
	return c.ListMonitoringSchedulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMonitoringSchedulesPagesWithContext same as ListMonitoringSchedulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListMonitoringSchedulesPagesWithContext(ctx aws.Context, input *ListMonitoringSchedulesInput, fn func(*ListMonitoringSchedulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMonitoringSchedulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMonitoringSchedulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMonitoringSchedulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotebookInstanceLifecycleConfigs = "ListNotebookInstanceLifecycleConfigs"

// ListNotebookInstanceLifecycleConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotebookInstanceLifecycleConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotebookInstanceLifecycleConfigs for more information on using the ListNotebookInstanceLifecycleConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotebookInstanceLifecycleConfigsRequest method.
//    req, resp := client.ListNotebookInstanceLifecycleConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsRequest(input *ListNotebookInstanceLifecycleConfigsInput) (req *request.Request, output *ListNotebookInstanceLifecycleConfigsOutput) {
	op := &request.Operation{
		Name:       opListNotebookInstanceLifecycleConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotebookInstanceLifecycleConfigsInput{}
	}

	output = &ListNotebookInstanceLifecycleConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotebookInstanceLifecycleConfigs API operation for Amazon SageMaker Service.
//
// Lists notebook instance lifestyle configurations created with the CreateNotebookInstanceLifecycleConfig
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListNotebookInstanceLifecycleConfigs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs
func (c *SageMaker) ListNotebookInstanceLifecycleConfigs(input *ListNotebookInstanceLifecycleConfigsInput) (*ListNotebookInstanceLifecycleConfigsOutput, error) {
	req, out := c.ListNotebookInstanceLifecycleConfigsRequest(input)
	return out, req.Send()
}

// ListNotebookInstanceLifecycleConfigsWithContext is the same as ListNotebookInstanceLifecycleConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotebookInstanceLifecycleConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsWithContext(ctx aws.Context, input *ListNotebookInstanceLifecycleConfigsInput, opts ...request.Option) (*ListNotebookInstanceLifecycleConfigsOutput, error) {
	req, out := c.ListNotebookInstanceLifecycleConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotebookInstanceLifecycleConfigsPages iterates over the pages of a ListNotebookInstanceLifecycleConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotebookInstanceLifecycleConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotebookInstanceLifecycleConfigs operation.
//    pageNum := 0
//    err := client.ListNotebookInstanceLifecycleConfigsPages(params,
//        func(page *sagemaker.ListNotebookInstanceLifecycleConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsPages(input *ListNotebookInstanceLifecycleConfigsInput, fn func(*ListNotebookInstanceLifecycleConfigsOutput, bool) bool) error {
	return c.ListNotebookInstanceLifecycleConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotebookInstanceLifecycleConfigsPagesWithContext same as ListNotebookInstanceLifecycleConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsPagesWithContext(ctx aws.Context, input *ListNotebookInstanceLifecycleConfigsInput, fn func(*ListNotebookInstanceLifecycleConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotebookInstanceLifecycleConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotebookInstanceLifecycleConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotebookInstanceLifecycleConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotebookInstances = "ListNotebookInstances"

// ListNotebookInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListNotebookInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotebookInstances for more information on using the ListNotebookInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotebookInstancesRequest method.
//    req, resp := client.ListNotebookInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances
func (c *SageMaker) ListNotebookInstancesRequest(input *ListNotebookInstancesInput) (req *request.Request, output *ListNotebookInstancesOutput) {
	op := &request.Operation{
		Name:       opListNotebookInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotebookInstancesInput{}
	}

	output = &ListNotebookInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotebookInstances API operation for Amazon SageMaker Service.
//
// Returns a list of the Amazon SageMaker notebook instances in the requester's
// account in an AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListNotebookInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances
func (c *SageMaker) ListNotebookInstances(input *ListNotebookInstancesInput) (*ListNotebookInstancesOutput, error) {
	req, out := c.ListNotebookInstancesRequest(input)
	return out, req.Send()
}

// ListNotebookInstancesWithContext is the same as ListNotebookInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotebookInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstancesWithContext(ctx aws.Context, input *ListNotebookInstancesInput, opts ...request.Option) (*ListNotebookInstancesOutput, error) {
	req, out := c.ListNotebookInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotebookInstancesPages iterates over the pages of a ListNotebookInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotebookInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotebookInstances operation.
//    pageNum := 0
//    err := client.ListNotebookInstancesPages(params,
//        func(page *sagemaker.ListNotebookInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListNotebookInstancesPages(input *ListNotebookInstancesInput, fn func(*ListNotebookInstancesOutput, bool) bool) error {
	return c.ListNotebookInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotebookInstancesPagesWithContext same as ListNotebookInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstancesPagesWithContext(ctx aws.Context, input *ListNotebookInstancesInput, fn func(*ListNotebookInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotebookInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotebookInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotebookInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProcessingJobs = "ListProcessingJobs"

// ListProcessingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListProcessingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProcessingJobs for more information on using the ListProcessingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProcessingJobsRequest method.
//    req, resp := client.ListProcessingJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProcessingJobs
func (c *SageMaker) ListProcessingJobsRequest(input *ListProcessingJobsInput) (req *request.Request, output *ListProcessingJobsOutput) {
	op := &request.Operation{
		Name:       opListProcessingJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProcessingJobsInput{}
	}

	output = &ListProcessingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProcessingJobs API operation for Amazon SageMaker Service.
//
// Lists processing jobs that satisfy various filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListProcessingJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProcessingJobs
func (c *SageMaker) ListProcessingJobs(input *ListProcessingJobsInput) (*ListProcessingJobsOutput, error) {
	req, out := c.ListProcessingJobsRequest(input)
	return out, req.Send()
}

// ListProcessingJobsWithContext is the same as ListProcessingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListProcessingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListProcessingJobsWithContext(ctx aws.Context, input *ListProcessingJobsInput, opts ...request.Option) (*ListProcessingJobsOutput, error) {
	req, out := c.ListProcessingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProcessingJobsPages iterates over the pages of a ListProcessingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProcessingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProcessingJobs operation.
//    pageNum := 0
//    err := client.ListProcessingJobsPages(params,
//        func(page *sagemaker.ListProcessingJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListProcessingJobsPages(input *ListProcessingJobsInput, fn func(*ListProcessingJobsOutput, bool) bool) error {
	return c.ListProcessingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProcessingJobsPagesWithContext same as ListProcessingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListProcessingJobsPagesWithContext(ctx aws.Context, input *ListProcessingJobsInput, fn func(*ListProcessingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProcessingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProcessingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProcessingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubscribedWorkteams = "ListSubscribedWorkteams"

// ListSubscribedWorkteamsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscribedWorkteams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscribedWorkteams for more information on using the ListSubscribedWorkteams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSubscribedWorkteamsRequest method.
//    req, resp := client.ListSubscribedWorkteamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams
func (c *SageMaker) ListSubscribedWorkteamsRequest(input *ListSubscribedWorkteamsInput) (req *request.Request, output *ListSubscribedWorkteamsOutput) {
	op := &request.Operation{
		Name:       opListSubscribedWorkteams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscribedWorkteamsInput{}
	}

	output = &ListSubscribedWorkteamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscribedWorkteams API operation for Amazon SageMaker Service.
//
// Gets a list of the work teams that you are subscribed to in the AWS Marketplace.
// The list may be empty if no work team satisfies the filter specified in the
// NameContains parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListSubscribedWorkteams for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams
func (c *SageMaker) ListSubscribedWorkteams(input *ListSubscribedWorkteamsInput) (*ListSubscribedWorkteamsOutput, error) {
	req, out := c.ListSubscribedWorkteamsRequest(input)
	return out, req.Send()
}

// ListSubscribedWorkteamsWithContext is the same as ListSubscribedWorkteams with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscribedWorkteams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListSubscribedWorkteamsWithContext(ctx aws.Context, input *ListSubscribedWorkteamsInput, opts ...request.Option) (*ListSubscribedWorkteamsOutput, error) {
	req, out := c.ListSubscribedWorkteamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubscribedWorkteamsPages iterates over the pages of a ListSubscribedWorkteams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscribedWorkteams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSubscribedWorkteams operation.
//    pageNum := 0
//    err := client.ListSubscribedWorkteamsPages(params,
//        func(page *sagemaker.ListSubscribedWorkteamsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListSubscribedWorkteamsPages(input *ListSubscribedWorkteamsInput, fn func(*ListSubscribedWorkteamsOutput, bool) bool) error {
	return c.ListSubscribedWorkteamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubscribedWorkteamsPagesWithContext same as ListSubscribedWorkteamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListSubscribedWorkteamsPagesWithContext(ctx aws.Context, input *ListSubscribedWorkteamsInput, fn func(*ListSubscribedWorkteamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubscribedWorkteamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubscribedWorkteamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubscribedWorkteamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags
func (c *SageMaker) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon SageMaker Service.
//
// Returns the tags for the specified Amazon SageMaker resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags
func (c *SageMaker) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTags operation.
//    pageNum := 0
//    err := client.ListTagsPages(params,
//        func(page *sagemaker.ListTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrainingJobs = "ListTrainingJobs"

// ListTrainingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrainingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrainingJobs for more information on using the ListTrainingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrainingJobsRequest method.
//    req, resp := client.ListTrainingJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs
func (c *SageMaker) ListTrainingJobsRequest(input *ListTrainingJobsInput) (req *request.Request, output *ListTrainingJobsOutput) {
	op := &request.Operation{
		Name:       opListTrainingJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrainingJobsInput{}
	}

	output = &ListTrainingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrainingJobs API operation for Amazon SageMaker Service.
//
// Lists training jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTrainingJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs
func (c *SageMaker) ListTrainingJobs(input *ListTrainingJobsInput) (*ListTrainingJobsOutput, error) {
	req, out := c.ListTrainingJobsRequest(input)
	return out, req.Send()
}

// ListTrainingJobsWithContext is the same as ListTrainingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrainingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsWithContext(ctx aws.Context, input *ListTrainingJobsInput, opts ...request.Option) (*ListTrainingJobsOutput, error) {
	req, out := c.ListTrainingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrainingJobsPages iterates over the pages of a ListTrainingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrainingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrainingJobs operation.
//    pageNum := 0
//    err := client.ListTrainingJobsPages(params,
//        func(page *sagemaker.ListTrainingJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTrainingJobsPages(input *ListTrainingJobsInput, fn func(*ListTrainingJobsOutput, bool) bool) error {
	return c.ListTrainingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrainingJobsPagesWithContext same as ListTrainingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsPagesWithContext(ctx aws.Context, input *ListTrainingJobsInput, fn func(*ListTrainingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrainingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrainingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrainingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrainingJobsForHyperParameterTuningJob = "ListTrainingJobsForHyperParameterTuningJob"

// ListTrainingJobsForHyperParameterTuningJobRequest generates a "aws/request.Request" representing the
// client's request for the ListTrainingJobsForHyperParameterTuningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrainingJobsForHyperParameterTuningJob for more information on using the ListTrainingJobsForHyperParameterTuningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrainingJobsForHyperParameterTuningJobRequest method.
//    req, resp := client.ListTrainingJobsForHyperParameterTuningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJobRequest(input *ListTrainingJobsForHyperParameterTuningJobInput) (req *request.Request, output *ListTrainingJobsForHyperParameterTuningJobOutput) {
	op := &request.Operation{
		Name:       opListTrainingJobsForHyperParameterTuningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrainingJobsForHyperParameterTuningJobInput{}
	}

	output = &ListTrainingJobsForHyperParameterTuningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrainingJobsForHyperParameterTuningJob API operation for Amazon SageMaker Service.
//
// Gets a list of TrainingJobSummary objects that describe the training jobs
// that a hyperparameter tuning job launched.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTrainingJobsForHyperParameterTuningJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJob(input *ListTrainingJobsForHyperParameterTuningJobInput) (*ListTrainingJobsForHyperParameterTuningJobOutput, error) {
	req, out := c.ListTrainingJobsForHyperParameterTuningJobRequest(input)
	return out, req.Send()
}

// ListTrainingJobsForHyperParameterTuningJobWithContext is the same as ListTrainingJobsForHyperParameterTuningJob with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrainingJobsForHyperParameterTuningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJobWithContext(ctx aws.Context, input *ListTrainingJobsForHyperParameterTuningJobInput, opts ...request.Option) (*ListTrainingJobsForHyperParameterTuningJobOutput, error) {
	req, out := c.ListTrainingJobsForHyperParameterTuningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrainingJobsForHyperParameterTuningJobPages iterates over the pages of a ListTrainingJobsForHyperParameterTuningJob operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrainingJobsForHyperParameterTuningJob method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrainingJobsForHyperParameterTuningJob operation.
//    pageNum := 0
//    err := client.ListTrainingJobsForHyperParameterTuningJobPages(params,
//        func(page *sagemaker.ListTrainingJobsForHyperParameterTuningJobOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJobPages(input *ListTrainingJobsForHyperParameterTuningJobInput, fn func(*ListTrainingJobsForHyperParameterTuningJobOutput, bool) bool) error {
	return c.ListTrainingJobsForHyperParameterTuningJobPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrainingJobsForHyperParameterTuningJobPagesWithContext same as ListTrainingJobsForHyperParameterTuningJobPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJobPagesWithContext(ctx aws.Context, input *ListTrainingJobsForHyperParameterTuningJobInput, fn func(*ListTrainingJobsForHyperParameterTuningJobOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrainingJobsForHyperParameterTuningJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrainingJobsForHyperParameterTuningJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrainingJobsForHyperParameterTuningJobOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTransformJobs = "ListTransformJobs"

// ListTransformJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTransformJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTransformJobs for more information on using the ListTransformJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTransformJobsRequest method.
//    req, resp := client.ListTransformJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs
func (c *SageMaker) ListTransformJobsRequest(input *ListTransformJobsInput) (req *request.Request, output *ListTransformJobsOutput) {
	op := &request.Operation{
		Name:       opListTransformJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTransformJobsInput{}
	}

	output = &ListTransformJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTransformJobs API operation for Amazon SageMaker Service.
//
// Lists transform jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTransformJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs
func (c *SageMaker) ListTransformJobs(input *ListTransformJobsInput) (*ListTransformJobsOutput, error) {
	req, out := c.ListTransformJobsRequest(input)
	return out, req.Send()
}

// ListTransformJobsWithContext is the same as ListTransformJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTransformJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTransformJobsWithContext(ctx aws.Context, input *ListTransformJobsInput, opts ...request.Option) (*ListTransformJobsOutput, error) {
	req, out := c.ListTransformJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTransformJobsPages iterates over the pages of a ListTransformJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTransformJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTransformJobs operation.
//    pageNum := 0
//    err := client.ListTransformJobsPages(params,
//        func(page *sagemaker.ListTransformJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTransformJobsPages(input *ListTransformJobsInput, fn func(*ListTransformJobsOutput, bool) bool) error {
	return c.ListTransformJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTransformJobsPagesWithContext same as ListTransformJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTransformJobsPagesWithContext(ctx aws.Context, input *ListTransformJobsInput, fn func(*ListTransformJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTransformJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTransformJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTransformJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrialComponents = "ListTrialComponents"

// ListTrialComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrialComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrialComponents for more information on using the ListTrialComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrialComponentsRequest method.
//    req, resp := client.ListTrialComponentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrialComponents
func (c *SageMaker) ListTrialComponentsRequest(input *ListTrialComponentsInput) (req *request.Request, output *ListTrialComponentsOutput) {
	op := &request.Operation{
		Name:       opListTrialComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrialComponentsInput{}
	}

	output = &ListTrialComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrialComponents API operation for Amazon SageMaker Service.
//
// Lists the trial components in your account. You can sort the list by trial
// component name or creation time. You can filter the list to show only components
// that were created in a specific time range. You can also filter on one of
// the following:
//
//    * ExperimentName
//
//    * SourceArn
//
//    * TrialName
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTrialComponents for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrialComponents
func (c *SageMaker) ListTrialComponents(input *ListTrialComponentsInput) (*ListTrialComponentsOutput, error) {
	req, out := c.ListTrialComponentsRequest(input)
	return out, req.Send()
}

// ListTrialComponentsWithContext is the same as ListTrialComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrialComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrialComponentsWithContext(ctx aws.Context, input *ListTrialComponentsInput, opts ...request.Option) (*ListTrialComponentsOutput, error) {
	req, out := c.ListTrialComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrialComponentsPages iterates over the pages of a ListTrialComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrialComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrialComponents operation.
//    pageNum := 0
//    err := client.ListTrialComponentsPages(params,
//        func(page *sagemaker.ListTrialComponentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTrialComponentsPages(input *ListTrialComponentsInput, fn func(*ListTrialComponentsOutput, bool) bool) error {
	return c.ListTrialComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrialComponentsPagesWithContext same as ListTrialComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrialComponentsPagesWithContext(ctx aws.Context, input *ListTrialComponentsInput, fn func(*ListTrialComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrialComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrialComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrialComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrials = "ListTrials"

// ListTrialsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrials for more information on using the ListTrials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrialsRequest method.
//    req, resp := client.ListTrialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrials
func (c *SageMaker) ListTrialsRequest(input *ListTrialsInput) (req *request.Request, output *ListTrialsOutput) {
	op := &request.Operation{
		Name:       opListTrials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrialsInput{}
	}

	output = &ListTrialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrials API operation for Amazon SageMaker Service.
//
// Lists the trials in your account. Specify an experiment name to limit the
// list to the trials that are part of that experiment. Specify a trial component
// name to limit the list to the trials that associated with that trial component.
// The list can be filtered to show only trials that were created in a specific
// time range. The list can be sorted by trial name or creation time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTrials for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrials
func (c *SageMaker) ListTrials(input *ListTrialsInput) (*ListTrialsOutput, error) {
	req, out := c.ListTrialsRequest(input)
	return out, req.Send()
}

// ListTrialsWithContext is the same as ListTrials with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrialsWithContext(ctx aws.Context, input *ListTrialsInput, opts ...request.Option) (*ListTrialsOutput, error) {
	req, out := c.ListTrialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrialsPages iterates over the pages of a ListTrials operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrials method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrials operation.
//    pageNum := 0
//    err := client.ListTrialsPages(params,
//        func(page *sagemaker.ListTrialsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTrialsPages(input *ListTrialsInput, fn func(*ListTrialsOutput, bool) bool) error {
	return c.ListTrialsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrialsPagesWithContext same as ListTrialsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrialsPagesWithContext(ctx aws.Context, input *ListTrialsInput, fn func(*ListTrialsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrialsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrialsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrialsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserProfiles = "ListUserProfiles"

// ListUserProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListUserProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserProfiles for more information on using the ListUserProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserProfilesRequest method.
//    req, resp := client.ListUserProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListUserProfiles
func (c *SageMaker) ListUserProfilesRequest(input *ListUserProfilesInput) (req *request.Request, output *ListUserProfilesOutput) {
	op := &request.Operation{
		Name:       opListUserProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserProfilesInput{}
	}

	output = &ListUserProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserProfiles API operation for Amazon SageMaker Service.
//
// Lists user profiles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListUserProfiles for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListUserProfiles
func (c *SageMaker) ListUserProfiles(input *ListUserProfilesInput) (*ListUserProfilesOutput, error) {
	req, out := c.ListUserProfilesRequest(input)
	return out, req.Send()
}

// ListUserProfilesWithContext is the same as ListUserProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListUserProfilesWithContext(ctx aws.Context, input *ListUserProfilesInput, opts ...request.Option) (*ListUserProfilesOutput, error) {
	req, out := c.ListUserProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserProfilesPages iterates over the pages of a ListUserProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUserProfiles operation.
//    pageNum := 0
//    err := client.ListUserProfilesPages(params,
//        func(page *sagemaker.ListUserProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListUserProfilesPages(input *ListUserProfilesInput, fn func(*ListUserProfilesOutput, bool) bool) error {
	return c.ListUserProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserProfilesPagesWithContext same as ListUserProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListUserProfilesPagesWithContext(ctx aws.Context, input *ListUserProfilesInput, fn func(*ListUserProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkteams = "ListWorkteams"

// ListWorkteamsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkteams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkteams for more information on using the ListWorkteams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkteamsRequest method.
//    req, resp := client.ListWorkteamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams
func (c *SageMaker) ListWorkteamsRequest(input *ListWorkteamsInput) (req *request.Request, output *ListWorkteamsOutput) {
	op := &request.Operation{
		Name:       opListWorkteams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkteamsInput{}
	}

	output = &ListWorkteamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkteams API operation for Amazon SageMaker Service.
//
// Gets a list of work teams that you have defined in a region. The list may
// be empty if no work team satisfies the filter specified in the NameContains
// parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListWorkteams for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams
func (c *SageMaker) ListWorkteams(input *ListWorkteamsInput) (*ListWorkteamsOutput, error) {
	req, out := c.ListWorkteamsRequest(input)
	return out, req.Send()
}

// ListWorkteamsWithContext is the same as ListWorkteams with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkteams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListWorkteamsWithContext(ctx aws.Context, input *ListWorkteamsInput, opts ...request.Option) (*ListWorkteamsOutput, error) {
	req, out := c.ListWorkteamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkteamsPages iterates over the pages of a ListWorkteams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkteams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkteams operation.
//    pageNum := 0
//    err := client.ListWorkteamsPages(params,
//        func(page *sagemaker.ListWorkteamsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListWorkteamsPages(input *ListWorkteamsInput, fn func(*ListWorkteamsOutput, bool) bool) error {
	return c.ListWorkteamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkteamsPagesWithContext same as ListWorkteamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListWorkteamsPagesWithContext(ctx aws.Context, input *ListWorkteamsInput, fn func(*ListWorkteamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkteamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkteamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkteamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRenderUiTemplate = "RenderUiTemplate"

// RenderUiTemplateRequest generates a "aws/request.Request" representing the
// client's request for the RenderUiTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RenderUiTemplate for more information on using the RenderUiTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RenderUiTemplateRequest method.
//    req, resp := client.RenderUiTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderUiTemplate
func (c *SageMaker) RenderUiTemplateRequest(input *RenderUiTemplateInput) (req *request.Request, output *RenderUiTemplateOutput) {
	op := &request.Operation{
		Name:       opRenderUiTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenderUiTemplateInput{}
	}

	output = &RenderUiTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RenderUiTemplate API operation for Amazon SageMaker Service.
//
// Renders the UI template so that you can preview the worker's experience.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation RenderUiTemplate for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderUiTemplate
func (c *SageMaker) RenderUiTemplate(input *RenderUiTemplateInput) (*RenderUiTemplateOutput, error) {
	req, out := c.RenderUiTemplateRequest(input)
	return out, req.Send()
}

// RenderUiTemplateWithContext is the same as RenderUiTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See RenderUiTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) RenderUiTemplateWithContext(ctx aws.Context, input *RenderUiTemplateInput, opts ...request.Option) (*RenderUiTemplateOutput, error) {
	req, out := c.RenderUiTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearch = "Search"

// SearchRequest generates a "aws/request.Request" representing the
// client's request for the Search operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Search for more information on using the Search
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchRequest method.
//    req, resp := client.SearchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search
func (c *SageMaker) SearchRequest(input *SearchInput) (req *request.Request, output *SearchOutput) {
	op := &request.Operation{
		Name:       opSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchInput{}
	}

	output = &SearchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Search API operation for Amazon SageMaker Service.
//
// Finds Amazon SageMaker resources that match a search query. Matching resource
// objects are returned as a list of SearchResult objects in the response. You
// can sort the search results by any resource property in a ascending or descending
// order.
//
// You can query against the following value types: numeric, text, Boolean,
// and timestamp.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation Search for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search
func (c *SageMaker) Search(input *SearchInput) (*SearchOutput, error) {
	req, out := c.SearchRequest(input)
	return out, req.Send()
}

// SearchWithContext is the same as Search with the addition of
// the ability to pass a context and additional request options.
//
// See Search for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) SearchWithContext(ctx aws.Context, input *SearchInput, opts ...request.Option) (*SearchOutput, error) {
	req, out := c.SearchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchPages iterates over the pages of a Search operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Search method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a Search operation.
//    pageNum := 0
//    err := client.SearchPages(params,
//        func(page *sagemaker.SearchOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) SearchPages(input *SearchInput, fn func(*SearchOutput, bool) bool) error {
	return c.SearchPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchPagesWithContext same as SearchPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) SearchPagesWithContext(ctx aws.Context, input *SearchInput, fn func(*SearchOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartMonitoringSchedule = "StartMonitoringSchedule"

// StartMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the StartMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMonitoringSchedule for more information on using the StartMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMonitoringScheduleRequest method.
//    req, resp := client.StartMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartMonitoringSchedule
func (c *SageMaker) StartMonitoringScheduleRequest(input *StartMonitoringScheduleInput) (req *request.Request, output *StartMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opStartMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMonitoringScheduleInput{}
	}

	output = &StartMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Starts a previously stopped monitoring schedule.
//
// New monitoring schedules are immediately started after creation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StartMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartMonitoringSchedule
func (c *SageMaker) StartMonitoringSchedule(input *StartMonitoringScheduleInput) (*StartMonitoringScheduleOutput, error) {
	req, out := c.StartMonitoringScheduleRequest(input)
	return out, req.Send()
}

// StartMonitoringScheduleWithContext is the same as StartMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See StartMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StartMonitoringScheduleWithContext(ctx aws.Context, input *StartMonitoringScheduleInput, opts ...request.Option) (*StartMonitoringScheduleOutput, error) {
	req, out := c.StartMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartNotebookInstance = "StartNotebookInstance"

// StartNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StartNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartNotebookInstance for more information on using the StartNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartNotebookInstanceRequest method.
//    req, resp := client.StartNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartNotebookInstance
func (c *SageMaker) StartNotebookInstanceRequest(input *StartNotebookInstanceInput) (req *request.Request, output *StartNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opStartNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartNotebookInstanceInput{}
	}

	output = &StartNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartNotebookInstance API operation for Amazon SageMaker Service.
//
// Launches an ML compute instance with the latest version of the libraries
// and attaches your ML storage volume. After configuring the notebook instance,
// Amazon SageMaker sets the notebook instance status to InService. A notebook
// instance's status must be InService before you can connect to your Jupyter
// notebook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StartNotebookInstance for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartNotebookInstance
func (c *SageMaker) StartNotebookInstance(input *StartNotebookInstanceInput) (*StartNotebookInstanceOutput, error) {
	req, out := c.StartNotebookInstanceRequest(input)
	return out, req.Send()
}

// StartNotebookInstanceWithContext is the same as StartNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StartNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StartNotebookInstanceWithContext(ctx aws.Context, input *StartNotebookInstanceInput, opts ...request.Option) (*StartNotebookInstanceOutput, error) {
	req, out := c.StartNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopAutoMLJob = "StopAutoMLJob"

// StopAutoMLJobRequest generates a "aws/request.Request" representing the
// client's request for the StopAutoMLJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopAutoMLJob for more information on using the StopAutoMLJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopAutoMLJobRequest method.
//    req, resp := client.StopAutoMLJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopAutoMLJob
func (c *SageMaker) StopAutoMLJobRequest(input *StopAutoMLJobInput) (req *request.Request, output *StopAutoMLJobOutput) {
	op := &request.Operation{
		Name:       opStopAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAutoMLJobInput{}
	}

	output = &StopAutoMLJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopAutoMLJob API operation for Amazon SageMaker Service.
//
// A method for forcing the termination of a running job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopAutoMLJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopAutoMLJob
func (c *SageMaker) StopAutoMLJob(input *StopAutoMLJobInput) (*StopAutoMLJobOutput, error) {
	req, out := c.StopAutoMLJobRequest(input)
	return out, req.Send()
}

// StopAutoMLJobWithContext is the same as StopAutoMLJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopAutoMLJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopAutoMLJobWithContext(ctx aws.Context, input *StopAutoMLJobInput, opts ...request.Option) (*StopAutoMLJobOutput, error) {
	req, out := c.StopAutoMLJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopCompilationJob = "StopCompilationJob"

// StopCompilationJobRequest generates a "aws/request.Request" representing the
// client's request for the StopCompilationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopCompilationJob for more information on using the StopCompilationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopCompilationJobRequest method.
//    req, resp := client.StopCompilationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopCompilationJob
func (c *SageMaker) StopCompilationJobRequest(input *StopCompilationJobInput) (req *request.Request, output *StopCompilationJobOutput) {
	op := &request.Operation{
		Name:       opStopCompilationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopCompilationJobInput{}
	}

	output = &StopCompilationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopCompilationJob API operation for Amazon SageMaker Service.
//
// Stops a model compilation job.
//
// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This
// gracefully shuts the job down. If the job hasn't stopped, it sends the SIGKILL
// signal.
//
// When it receives a StopCompilationJob request, Amazon SageMaker changes the
// CompilationJobSummary$CompilationJobStatus of the job to Stopping. After
// Amazon SageMaker stops the job, it sets the CompilationJobSummary$CompilationJobStatus
// to Stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopCompilationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopCompilationJob
func (c *SageMaker) StopCompilationJob(input *StopCompilationJobInput) (*StopCompilationJobOutput, error) {
	req, out := c.StopCompilationJobRequest(input)
	return out, req.Send()
}

// StopCompilationJobWithContext is the same as StopCompilationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopCompilationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopCompilationJobWithContext(ctx aws.Context, input *StopCompilationJobInput, opts ...request.Option) (*StopCompilationJobOutput, error) {
	req, out := c.StopCompilationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopHyperParameterTuningJob = "StopHyperParameterTuningJob"

// StopHyperParameterTuningJobRequest generates a "aws/request.Request" representing the
// client's request for the StopHyperParameterTuningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopHyperParameterTuningJob for more information on using the StopHyperParameterTuningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopHyperParameterTuningJobRequest method.
//    req, resp := client.StopHyperParameterTuningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopHyperParameterTuningJob
func (c *SageMaker) StopHyperParameterTuningJobRequest(input *StopHyperParameterTuningJobInput) (req *request.Request, output *StopHyperParameterTuningJobOutput) {
	op := &request.Operation{
		Name:       opStopHyperParameterTuningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopHyperParameterTuningJobInput{}
	}

	output = &StopHyperParameterTuningJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopHyperParameterTuningJob API operation for Amazon SageMaker Service.
//
// Stops a running hyperparameter tuning job and all running training jobs that
// the tuning job launched.
//
// All model artifacts output from the training jobs are stored in Amazon Simple
// Storage Service (Amazon S3). All data that the training jobs write to Amazon
// CloudWatch Logs are still available in CloudWatch. After the tuning job moves
// to the Stopped state, it releases all reserved resources for the tuning job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopHyperParameterTuningJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopHyperParameterTuningJob
func (c *SageMaker) StopHyperParameterTuningJob(input *StopHyperParameterTuningJobInput) (*StopHyperParameterTuningJobOutput, error) {
	req, out := c.StopHyperParameterTuningJobRequest(input)
	return out, req.Send()
}

// StopHyperParameterTuningJobWithContext is the same as StopHyperParameterTuningJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopHyperParameterTuningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopHyperParameterTuningJobWithContext(ctx aws.Context, input *StopHyperParameterTuningJobInput, opts ...request.Option) (*StopHyperParameterTuningJobOutput, error) {
	req, out := c.StopHyperParameterTuningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopLabelingJob = "StopLabelingJob"

// StopLabelingJobRequest generates a "aws/request.Request" representing the
// client's request for the StopLabelingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopLabelingJob for more information on using the StopLabelingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopLabelingJobRequest method.
//    req, resp := client.StopLabelingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopLabelingJob
func (c *SageMaker) StopLabelingJobRequest(input *StopLabelingJobInput) (req *request.Request, output *StopLabelingJobOutput) {
	op := &request.Operation{
		Name:       opStopLabelingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopLabelingJobInput{}
	}

	output = &StopLabelingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopLabelingJob API operation for Amazon SageMaker Service.
//
// Stops a running labeling job. A job that is stopped cannot be restarted.
// Any results obtained before the job is stopped are placed in the Amazon S3
// output bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopLabelingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopLabelingJob
func (c *SageMaker) StopLabelingJob(input *StopLabelingJobInput) (*StopLabelingJobOutput, error) {
	req, out := c.StopLabelingJobRequest(input)
	return out, req.Send()
}

// StopLabelingJobWithContext is the same as StopLabelingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopLabelingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopLabelingJobWithContext(ctx aws.Context, input *StopLabelingJobInput, opts ...request.Option) (*StopLabelingJobOutput, error) {
	req, out := c.StopLabelingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMonitoringSchedule = "StopMonitoringSchedule"

// StopMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the StopMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMonitoringSchedule for more information on using the StopMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopMonitoringScheduleRequest method.
//    req, resp := client.StopMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopMonitoringSchedule
func (c *SageMaker) StopMonitoringScheduleRequest(input *StopMonitoringScheduleInput) (req *request.Request, output *StopMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opStopMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopMonitoringScheduleInput{}
	}

	output = &StopMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Stops a previously started monitoring schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopMonitoringSchedule
func (c *SageMaker) StopMonitoringSchedule(input *StopMonitoringScheduleInput) (*StopMonitoringScheduleOutput, error) {
	req, out := c.StopMonitoringScheduleRequest(input)
	return out, req.Send()
}

// StopMonitoringScheduleWithContext is the same as StopMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See StopMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopMonitoringScheduleWithContext(ctx aws.Context, input *StopMonitoringScheduleInput, opts ...request.Option) (*StopMonitoringScheduleOutput, error) {
	req, out := c.StopMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopNotebookInstance = "StopNotebookInstance"

// StopNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StopNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopNotebookInstance for more information on using the StopNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopNotebookInstanceRequest method.
//    req, resp := client.StopNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopNotebookInstance
func (c *SageMaker) StopNotebookInstanceRequest(input *StopNotebookInstanceInput) (req *request.Request, output *StopNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opStopNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopNotebookInstanceInput{}
	}

	output = &StopNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopNotebookInstance API operation for Amazon SageMaker Service.
//
// Terminates the ML compute instance. Before terminating the instance, Amazon
// SageMaker disconnects the ML storage volume from it. Amazon SageMaker preserves
// the ML storage volume. Amazon SageMaker stops charging you for the ML compute
// instance when you call StopNotebookInstance.
//
// To access data on the ML storage volume for a notebook instance that has
// been terminated, call the StartNotebookInstance API. StartNotebookInstance
// launches another ML compute instance, configures it, and attaches the preserved
// ML storage volume so you can continue your work.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopNotebookInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopNotebookInstance
func (c *SageMaker) StopNotebookInstance(input *StopNotebookInstanceInput) (*StopNotebookInstanceOutput, error) {
	req, out := c.StopNotebookInstanceRequest(input)
	return out, req.Send()
}

// StopNotebookInstanceWithContext is the same as StopNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StopNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopNotebookInstanceWithContext(ctx aws.Context, input *StopNotebookInstanceInput, opts ...request.Option) (*StopNotebookInstanceOutput, error) {
	req, out := c.StopNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopProcessingJob = "StopProcessingJob"

// StopProcessingJobRequest generates a "aws/request.Request" representing the
// client's request for the StopProcessingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopProcessingJob for more information on using the StopProcessingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopProcessingJobRequest method.
//    req, resp := client.StopProcessingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopProcessingJob
func (c *SageMaker) StopProcessingJobRequest(input *StopProcessingJobInput) (req *request.Request, output *StopProcessingJobOutput) {
	op := &request.Operation{
		Name:       opStopProcessingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopProcessingJobInput{}
	}

	output = &StopProcessingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopProcessingJob API operation for Amazon SageMaker Service.
//
// Stops a processing job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopProcessingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopProcessingJob
func (c *SageMaker) StopProcessingJob(input *StopProcessingJobInput) (*StopProcessingJobOutput, error) {
	req, out := c.StopProcessingJobRequest(input)
	return out, req.Send()
}

// StopProcessingJobWithContext is the same as StopProcessingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopProcessingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopProcessingJobWithContext(ctx aws.Context, input *StopProcessingJobInput, opts ...request.Option) (*StopProcessingJobOutput, error) {
	req, out := c.StopProcessingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTrainingJob = "StopTrainingJob"

// StopTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the StopTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTrainingJob for more information on using the StopTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTrainingJobRequest method.
//    req, resp := client.StopTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTrainingJob
func (c *SageMaker) StopTrainingJobRequest(input *StopTrainingJobInput) (req *request.Request, output *StopTrainingJobOutput) {
	op := &request.Operation{
		Name:       opStopTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTrainingJobInput{}
	}

	output = &StopTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopTrainingJob API operation for Amazon SageMaker Service.
//
// Stops a training job. To stop a job, Amazon SageMaker sends the algorithm
// the SIGTERM signal, which delays job termination for 120 seconds. Algorithms
// might use this 120-second window to save the model artifacts, so the results
// of the training is not lost.
//
// When it receives a StopTrainingJob request, Amazon SageMaker changes the
// status of the job to Stopping. After Amazon SageMaker stops the job, it sets
// the status to Stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopTrainingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTrainingJob
func (c *SageMaker) StopTrainingJob(input *StopTrainingJobInput) (*StopTrainingJobOutput, error) {
	req, out := c.StopTrainingJobRequest(input)
	return out, req.Send()
}

// StopTrainingJobWithContext is the same as StopTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopTrainingJobWithContext(ctx aws.Context, input *StopTrainingJobInput, opts ...request.Option) (*StopTrainingJobOutput, error) {
	req, out := c.StopTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTransformJob = "StopTransformJob"

// StopTransformJobRequest generates a "aws/request.Request" representing the
// client's request for the StopTransformJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTransformJob for more information on using the StopTransformJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTransformJobRequest method.
//    req, resp := client.StopTransformJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTransformJob
func (c *SageMaker) StopTransformJobRequest(input *StopTransformJobInput) (req *request.Request, output *StopTransformJobOutput) {
	op := &request.Operation{
		Name:       opStopTransformJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTransformJobInput{}
	}

	output = &StopTransformJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopTransformJob API operation for Amazon SageMaker Service.
//
// Stops a transform job.
//
// When Amazon SageMaker receives a StopTransformJob request, the status of
// the job changes to Stopping. After Amazon SageMaker stops the job, the status
// is set to Stopped. When you stop a transform job before it is completed,
// Amazon SageMaker doesn't store the job's output in Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopTransformJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTransformJob
func (c *SageMaker) StopTransformJob(input *StopTransformJobInput) (*StopTransformJobOutput, error) {
	req, out := c.StopTransformJobRequest(input)
	return out, req.Send()
}

// StopTransformJobWithContext is the same as StopTransformJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopTransformJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopTransformJobWithContext(ctx aws.Context, input *StopTransformJobInput, opts ...request.Option) (*StopTransformJobOutput, error) {
	req, out := c.StopTransformJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCodeRepository = "UpdateCodeRepository"

// UpdateCodeRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCodeRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCodeRepository for more information on using the UpdateCodeRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCodeRepositoryRequest method.
//    req, resp := client.UpdateCodeRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateCodeRepository
func (c *SageMaker) UpdateCodeRepositoryRequest(input *UpdateCodeRepositoryInput) (req *request.Request, output *UpdateCodeRepositoryOutput) {
	op := &request.Operation{
		Name:       opUpdateCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCodeRepositoryInput{}
	}

	output = &UpdateCodeRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCodeRepository API operation for Amazon SageMaker Service.
//
// Updates the specified Git repository with the specified values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateCodeRepository for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateCodeRepository
func (c *SageMaker) UpdateCodeRepository(input *UpdateCodeRepositoryInput) (*UpdateCodeRepositoryOutput, error) {
	req, out := c.UpdateCodeRepositoryRequest(input)
	return out, req.Send()
}

// UpdateCodeRepositoryWithContext is the same as UpdateCodeRepository with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCodeRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateCodeRepositoryWithContext(ctx aws.Context, input *UpdateCodeRepositoryInput, opts ...request.Option) (*UpdateCodeRepositoryOutput, error) {
	req, out := c.UpdateCodeRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomain = "UpdateDomain"

// UpdateDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomain for more information on using the UpdateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainRequest method.
//    req, resp := client.UpdateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateDomain
func (c *SageMaker) UpdateDomainRequest(input *UpdateDomainInput) (req *request.Request, output *UpdateDomainOutput) {
	op := &request.Operation{
		Name:       opUpdateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainInput{}
	}

	output = &UpdateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomain API operation for Amazon SageMaker Service.
//
// Updates a domain. Changes will impact all of the people in the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateDomain for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateDomain
func (c *SageMaker) UpdateDomain(input *UpdateDomainInput) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	return out, req.Send()
}

// UpdateDomainWithContext is the same as UpdateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateDomainWithContext(ctx aws.Context, input *UpdateDomainInput, opts ...request.Option) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpoint for more information on using the UpdateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointRequest method.
//    req, resp := client.UpdateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpoint
func (c *SageMaker) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpoint API operation for Amazon SageMaker Service.
//
// Deploys the new EndpointConfig specified in the request, switches to using
// newly created endpoint, and then deletes resources provisioned for the endpoint
// using the previous EndpointConfig (there is no availability loss).
//
// When Amazon SageMaker receives the request, it sets the endpoint status to
// Updating. After updating the endpoint, it sets the status to InService. To
// check the status of an endpoint, use the DescribeEndpoint (https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
// API.
//
// You must not delete an EndpointConfig in use by an endpoint that is live
// or while the UpdateEndpoint or CreateEndpoint operations are being performed
// on the endpoint. To update an endpoint, you must create a new EndpointConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpoint
func (c *SageMaker) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	return out, req.Send()
}

// UpdateEndpointWithContext is the same as UpdateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateEndpointWithContext(ctx aws.Context, input *UpdateEndpointInput, opts ...request.Option) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpointWeightsAndCapacities = "UpdateEndpointWeightsAndCapacities"

// UpdateEndpointWeightsAndCapacitiesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointWeightsAndCapacities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpointWeightsAndCapacities for more information on using the UpdateEndpointWeightsAndCapacities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointWeightsAndCapacitiesRequest method.
//    req, resp := client.UpdateEndpointWeightsAndCapacitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpointWeightsAndCapacities
func (c *SageMaker) UpdateEndpointWeightsAndCapacitiesRequest(input *UpdateEndpointWeightsAndCapacitiesInput) (req *request.Request, output *UpdateEndpointWeightsAndCapacitiesOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointWeightsAndCapacities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointWeightsAndCapacitiesInput{}
	}

	output = &UpdateEndpointWeightsAndCapacitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointWeightsAndCapacities API operation for Amazon SageMaker Service.
//
// Updates variant weight of one or more variants associated with an existing
// endpoint, or capacity of one variant associated with an existing endpoint.
// When it receives the request, Amazon SageMaker sets the endpoint status to
// Updating. After updating the endpoint, it sets the status to InService. To
// check the status of an endpoint, use the DescribeEndpoint (https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateEndpointWeightsAndCapacities for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpointWeightsAndCapacities
func (c *SageMaker) UpdateEndpointWeightsAndCapacities(input *UpdateEndpointWeightsAndCapacitiesInput) (*UpdateEndpointWeightsAndCapacitiesOutput, error) {
	req, out := c.UpdateEndpointWeightsAndCapacitiesRequest(input)
	return out, req.Send()
}

// UpdateEndpointWeightsAndCapacitiesWithContext is the same as UpdateEndpointWeightsAndCapacities with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpointWeightsAndCapacities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateEndpointWeightsAndCapacitiesWithContext(ctx aws.Context, input *UpdateEndpointWeightsAndCapacitiesInput, opts ...request.Option) (*UpdateEndpointWeightsAndCapacitiesOutput, error) {
	req, out := c.UpdateEndpointWeightsAndCapacitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExperiment = "UpdateExperiment"

// UpdateExperimentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExperiment for more information on using the UpdateExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateExperimentRequest method.
//    req, resp := client.UpdateExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateExperiment
func (c *SageMaker) UpdateExperimentRequest(input *UpdateExperimentInput) (req *request.Request, output *UpdateExperimentOutput) {
	op := &request.Operation{
		Name:       opUpdateExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateExperimentInput{}
	}

	output = &UpdateExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExperiment API operation for Amazon SageMaker Service.
//
// Adds, updates, or removes the description of an experiment. Updates the display
// name of an experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateExperiment for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateExperiment
func (c *SageMaker) UpdateExperiment(input *UpdateExperimentInput) (*UpdateExperimentOutput, error) {
	req, out := c.UpdateExperimentRequest(input)
	return out, req.Send()
}

// UpdateExperimentWithContext is the same as UpdateExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateExperimentWithContext(ctx aws.Context, input *UpdateExperimentInput, opts ...request.Option) (*UpdateExperimentOutput, error) {
	req, out := c.UpdateExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMonitoringSchedule = "UpdateMonitoringSchedule"

// UpdateMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMonitoringSchedule for more information on using the UpdateMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMonitoringScheduleRequest method.
//    req, resp := client.UpdateMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateMonitoringSchedule
func (c *SageMaker) UpdateMonitoringScheduleRequest(input *UpdateMonitoringScheduleInput) (req *request.Request, output *UpdateMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMonitoringScheduleInput{}
	}

	output = &UpdateMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Updates a previously created schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateMonitoringSchedule
func (c *SageMaker) UpdateMonitoringSchedule(input *UpdateMonitoringScheduleInput) (*UpdateMonitoringScheduleOutput, error) {
	req, out := c.UpdateMonitoringScheduleRequest(input)
	return out, req.Send()
}

// UpdateMonitoringScheduleWithContext is the same as UpdateMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateMonitoringScheduleWithContext(ctx aws.Context, input *UpdateMonitoringScheduleInput, opts ...request.Option) (*UpdateMonitoringScheduleOutput, error) {
	req, out := c.UpdateMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotebookInstance = "UpdateNotebookInstance"

// UpdateNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNotebookInstance for more information on using the UpdateNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNotebookInstanceRequest method.
//    req, resp := client.UpdateNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstance
func (c *SageMaker) UpdateNotebookInstanceRequest(input *UpdateNotebookInstanceInput) (req *request.Request, output *UpdateNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotebookInstanceInput{}
	}

	output = &UpdateNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNotebookInstance API operation for Amazon SageMaker Service.
//
// Updates a notebook instance. NotebookInstance updates include upgrading or
// downgrading the ML compute instance used for your notebook instance to accommodate
// changes in your workload requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateNotebookInstance for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstance
func (c *SageMaker) UpdateNotebookInstance(input *UpdateNotebookInstanceInput) (*UpdateNotebookInstanceOutput, error) {
	req, out := c.UpdateNotebookInstanceRequest(input)
	return out, req.Send()
}

// UpdateNotebookInstanceWithContext is the same as UpdateNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateNotebookInstanceWithContext(ctx aws.Context, input *UpdateNotebookInstanceInput, opts ...request.Option) (*UpdateNotebookInstanceOutput, error) {
	req, out := c.UpdateNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotebookInstanceLifecycleConfig = "UpdateNotebookInstanceLifecycleConfig"

// UpdateNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNotebookInstanceLifecycleConfig for more information on using the UpdateNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.UpdateNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstanceLifecycleConfig
func (c *SageMaker) UpdateNotebookInstanceLifecycleConfigRequest(input *UpdateNotebookInstanceLifecycleConfigInput) (req *request.Request, output *UpdateNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotebookInstanceLifecycleConfigInput{}
	}

	output = &UpdateNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Updates a notebook instance lifecycle configuration created with the CreateNotebookInstanceLifecycleConfig
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateNotebookInstanceLifecycleConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstanceLifecycleConfig
func (c *SageMaker) UpdateNotebookInstanceLifecycleConfig(input *UpdateNotebookInstanceLifecycleConfigInput) (*UpdateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.UpdateNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// UpdateNotebookInstanceLifecycleConfigWithContext is the same as UpdateNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *UpdateNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*UpdateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.UpdateNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrial = "UpdateTrial"

// UpdateTrialRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrial for more information on using the UpdateTrial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrialRequest method.
//    req, resp := client.UpdateTrialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrial
func (c *SageMaker) UpdateTrialRequest(input *UpdateTrialInput) (req *request.Request, output *UpdateTrialOutput) {
	op := &request.Operation{
		Name:       opUpdateTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrialInput{}
	}

	output = &UpdateTrialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrial API operation for Amazon SageMaker Service.
//
// Updates the display name of a trial.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateTrial for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrial
func (c *SageMaker) UpdateTrial(input *UpdateTrialInput) (*UpdateTrialOutput, error) {
	req, out := c.UpdateTrialRequest(input)
	return out, req.Send()
}

// UpdateTrialWithContext is the same as UpdateTrial with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateTrialWithContext(ctx aws.Context, input *UpdateTrialInput, opts ...request.Option) (*UpdateTrialOutput, error) {
	req, out := c.UpdateTrialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrialComponent = "UpdateTrialComponent"

// UpdateTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrialComponent for more information on using the UpdateTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrialComponentRequest method.
//    req, resp := client.UpdateTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrialComponent
func (c *SageMaker) UpdateTrialComponentRequest(input *UpdateTrialComponentInput) (req *request.Request, output *UpdateTrialComponentOutput) {
	op := &request.Operation{
		Name:       opUpdateTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrialComponentInput{}
	}

	output = &UpdateTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrialComponent API operation for Amazon SageMaker Service.
//
// Updates one or more properties of a trial component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrialComponent
func (c *SageMaker) UpdateTrialComponent(input *UpdateTrialComponentInput) (*UpdateTrialComponentOutput, error) {
	req, out := c.UpdateTrialComponentRequest(input)
	return out, req.Send()
}

// UpdateTrialComponentWithContext is the same as UpdateTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateTrialComponentWithContext(ctx aws.Context, input *UpdateTrialComponentInput, opts ...request.Option) (*UpdateTrialComponentOutput, error) {
	req, out := c.UpdateTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserProfile = "UpdateUserProfile"

// UpdateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserProfile for more information on using the UpdateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserProfileRequest method.
//    req, resp := client.UpdateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateUserProfile
func (c *SageMaker) UpdateUserProfileRequest(input *UpdateUserProfileInput) (req *request.Request, output *UpdateUserProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserProfileInput{}
	}

	output = &UpdateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserProfile API operation for Amazon SageMaker Service.
//
// Updates a user profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateUserProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateUserProfile
func (c *SageMaker) UpdateUserProfile(input *UpdateUserProfileInput) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	return out, req.Send()
}

// UpdateUserProfileWithContext is the same as UpdateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateUserProfileWithContext(ctx aws.Context, input *UpdateUserProfileInput, opts ...request.Option) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkforce = "UpdateWorkforce"

// UpdateWorkforceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkforce operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkforce for more information on using the UpdateWorkforce
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkforceRequest method.
//    req, resp := client.UpdateWorkforceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkforce
func (c *SageMaker) UpdateWorkforceRequest(input *UpdateWorkforceInput) (req *request.Request, output *UpdateWorkforceOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkforce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkforceInput{}
	}

	output = &UpdateWorkforceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkforce API operation for Amazon SageMaker Service.
//
// Restricts access to tasks assigned to workers in the specified workforce
// to those within specific ranges of IP addresses. You specify allowed IP addresses
// by creating a list of up to four CIDRs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html).
//
// By default, a workforce isn't restricted to specific IP addresses. If you
// specify a range of IP addresses, workers who attempt to access tasks using
// any IP address outside the specified range are denied access and get a Not
// Found error message on the worker portal. After restricting access with this
// operation, you can see the allowed IP values for a private workforce with
// the operation.
//
// This operation applies only to private workforces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateWorkforce for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkforce
func (c *SageMaker) UpdateWorkforce(input *UpdateWorkforceInput) (*UpdateWorkforceOutput, error) {
	req, out := c.UpdateWorkforceRequest(input)
	return out, req.Send()
}

// UpdateWorkforceWithContext is the same as UpdateWorkforce with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkforce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateWorkforceWithContext(ctx aws.Context, input *UpdateWorkforceInput, opts ...request.Option) (*UpdateWorkforceOutput, error) {
	req, out := c.UpdateWorkforceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkteam = "UpdateWorkteam"

// UpdateWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkteam for more information on using the UpdateWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkteamRequest method.
//    req, resp := client.UpdateWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkteam
func (c *SageMaker) UpdateWorkteamRequest(input *UpdateWorkteamInput) (req *request.Request, output *UpdateWorkteamOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkteamInput{}
	}

	output = &UpdateWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkteam API operation for Amazon SageMaker Service.
//
// Updates an existing work team with new member definitions or description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateWorkteam for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkteam
func (c *SageMaker) UpdateWorkteam(input *UpdateWorkteamInput) (*UpdateWorkteamOutput, error) {
	req, out := c.UpdateWorkteamRequest(input)
	return out, req.Send()
}

// UpdateWorkteamWithContext is the same as UpdateWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateWorkteamWithContext(ctx aws.Context, input *UpdateWorkteamInput, opts ...request.Option) (*UpdateWorkteamOutput, error) {
	req, out := c.UpdateWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// An array of Tag objects. Each tag is a key-value pair. Only the key parameter
	// is required. If you don't specify a value, Amazon SageMaker sets the value
	// to an empty string.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AddTagsInput) SetResourceArn(v string) *AddTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsInput) SetTags(v []*Tag) *AddTagsInput {
	s.Tags = v
	return s
}

type AddTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags associated with the Amazon SageMaker resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *AddTagsOutput) SetTags(v []*Tag) *AddTagsOutput {
	s.Tags = v
	return s
}

// Specifies the training algorithm to use in a CreateTrainingJob (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateTrainingJob.html)
// request.
//
// For more information about algorithms provided by Amazon SageMaker, see Algorithms
// (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information
// about using your own algorithms, see Using Your Own Algorithms with Amazon
// SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
type AlgorithmSpecification struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm resource to use for the training job. This must
	// be an algorithm resource that you created or subscribe to on AWS Marketplace.
	// If you specify a value for this parameter, you can't specify a value for
	// TrainingImage.
	AlgorithmName *string `min:"1" type:"string"`

	// To generate and save time-series metrics during training, set to true. The
	// default is false and time-series metrics aren't generated except in the following
	// cases:
	//
	//    * You use one of the Amazon SageMaker built-in algorithms
	//
	//    * You use one of the following Prebuilt Amazon SageMaker Docker Images
	//    (https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html):
	//    Tensorflow (version >= 1.15) MXNet (version >= 1.6) PyTorch (version >=
	//    1.3)
	//
	//    * You specify at least one MetricDefinition
	EnableSageMakerMetricsTimeSeries *bool `type:"boolean"`

	// A list of metric definition objects. Each object specifies the metric name
	// and regular expressions used to parse algorithm logs. Amazon SageMaker publishes
	// each metric to Amazon CloudWatch.
	MetricDefinitions []*MetricDefinition `type:"list"`

	// The registry path of the Docker image that contains the training algorithm.
	// For information about docker registry paths for built-in algorithms, see
	// Algorithms Provided by Amazon SageMaker: Common Parameters (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	// Amazon SageMaker supports both registry/repository[:tag] and registry/repository[@digest]
	// image path formats. For more information, see Using Your Own Algorithms with
	// Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	TrainingImage *string `type:"string"`

	// The input mode that the algorithm supports. For the input modes that Amazon
	// SageMaker algorithms support, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	// If an algorithm supports the File input mode, Amazon SageMaker downloads
	// the training data from S3 to the provisioned ML storage Volume, and mounts
	// the directory to docker volume for training container. If an algorithm supports
	// the Pipe input mode, Amazon SageMaker streams data directly from S3 to the
	// container.
	//
	// In File mode, make sure you provision ML storage volume with sufficient capacity
	// to accommodate the data download from S3. In addition to the training data,
	// the ML storage volume also stores the output model. The algorithm container
	// use ML storage volume to also store intermediate information, if any.
	//
	// For distributed algorithms using File mode, training data is distributed
	// uniformly, and your training duration is predictable if the input data objects
	// size is approximately same. Amazon SageMaker does not split the files any
	// further for model training. If the object sizes are skewed, training won't
	// be optimal as the data distribution is also skewed where one host in a training
	// cluster is overloaded, thus becoming bottleneck in training.
	//
	// TrainingInputMode is a required field
	TrainingInputMode *string `type:"string" required:"true" enum:"TrainingInputMode"`
}

// String returns the string representation
func (s AlgorithmSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlgorithmSpecification"}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlgorithmName", 1))
	}
	if s.TrainingInputMode == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingInputMode"))
	}
	if s.MetricDefinitions != nil {
		for i, v := range s.MetricDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *AlgorithmSpecification) SetAlgorithmName(v string) *AlgorithmSpecification {
	s.AlgorithmName = &v
	return s
}

// SetEnableSageMakerMetricsTimeSeries sets the EnableSageMakerMetricsTimeSeries field's value.
func (s *AlgorithmSpecification) SetEnableSageMakerMetricsTimeSeries(v bool) *AlgorithmSpecification {
	s.EnableSageMakerMetricsTimeSeries = &v
	return s
}

// SetMetricDefinitions sets the MetricDefinitions field's value.
func (s *AlgorithmSpecification) SetMetricDefinitions(v []*MetricDefinition) *AlgorithmSpecification {
	s.MetricDefinitions = v
	return s
}

// SetTrainingImage sets the TrainingImage field's value.
func (s *AlgorithmSpecification) SetTrainingImage(v string) *AlgorithmSpecification {
	s.TrainingImage = &v
	return s
}

// SetTrainingInputMode sets the TrainingInputMode field's value.
func (s *AlgorithmSpecification) SetTrainingInputMode(v string) *AlgorithmSpecification {
	s.TrainingInputMode = &v
	return s
}

// Specifies the validation and image scan statuses of the algorithm.
type AlgorithmStatusDetails struct {
	_ struct{} `type:"structure"`

	// The status of the scan of the algorithm's Docker image container.
	ImageScanStatuses []*AlgorithmStatusItem `type:"list"`

	// The status of algorithm validation.
	ValidationStatuses []*AlgorithmStatusItem `type:"list"`
}

// String returns the string representation
func (s AlgorithmStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmStatusDetails) GoString() string {
	return s.String()
}

// SetImageScanStatuses sets the ImageScanStatuses field's value.
func (s *AlgorithmStatusDetails) SetImageScanStatuses(v []*AlgorithmStatusItem) *AlgorithmStatusDetails {
	s.ImageScanStatuses = v
	return s
}

// SetValidationStatuses sets the ValidationStatuses field's value.
func (s *AlgorithmStatusDetails) SetValidationStatuses(v []*AlgorithmStatusItem) *AlgorithmStatusDetails {
	s.ValidationStatuses = v
	return s
}

// Represents the overall status of an algorithm.
type AlgorithmStatusItem struct {
	_ struct{} `type:"structure"`

	// if the overall status is Failed, the reason for the failure.
	FailureReason *string `type:"string"`

	// The name of the algorithm for which the overall status is being reported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The current status.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"DetailedAlgorithmStatus"`
}

// String returns the string representation
func (s AlgorithmStatusItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmStatusItem) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *AlgorithmStatusItem) SetFailureReason(v string) *AlgorithmStatusItem {
	s.FailureReason = &v
	return s
}

// SetName sets the Name field's value.
func (s *AlgorithmStatusItem) SetName(v string) *AlgorithmStatusItem {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AlgorithmStatusItem) SetStatus(v string) *AlgorithmStatusItem {
	s.Status = &v
	return s
}

// Provides summary information about an algorithm.
type AlgorithmSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `min:"1" type:"string" required:"true"`

	// A brief description of the algorithm.
	AlgorithmDescription *string `type:"string"`

	// The name of the algorithm that is described by the summary.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// The overall status of the algorithm.
	//
	// AlgorithmStatus is a required field
	AlgorithmStatus *string `type:"string" required:"true" enum:"AlgorithmStatus"`

	// A timestamp that shows when the algorithm was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AlgorithmSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmSummary) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *AlgorithmSummary) SetAlgorithmArn(v string) *AlgorithmSummary {
	s.AlgorithmArn = &v
	return s
}

// SetAlgorithmDescription sets the AlgorithmDescription field's value.
func (s *AlgorithmSummary) SetAlgorithmDescription(v string) *AlgorithmSummary {
	s.AlgorithmDescription = &v
	return s
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *AlgorithmSummary) SetAlgorithmName(v string) *AlgorithmSummary {
	s.AlgorithmName = &v
	return s
}

// SetAlgorithmStatus sets the AlgorithmStatus field's value.
func (s *AlgorithmSummary) SetAlgorithmStatus(v string) *AlgorithmSummary {
	s.AlgorithmStatus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AlgorithmSummary) SetCreationTime(v time.Time) *AlgorithmSummary {
	s.CreationTime = &v
	return s
}

// Defines a training job and a batch transform job that Amazon SageMaker runs
// to validate your algorithm.
//
// The data provided in the validation profile is made available to your buyers
// on AWS Marketplace.
type AlgorithmValidationProfile struct {
	_ struct{} `type:"structure"`

	// The name of the profile for the algorithm. The name must have 1 to 63 characters.
	// Valid characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// ProfileName is a required field
	ProfileName *string `min:"1" type:"string" required:"true"`

	// The TrainingJobDefinition object that describes the training job that Amazon
	// SageMaker runs to validate your algorithm.
	//
	// TrainingJobDefinition is a required field
	TrainingJobDefinition *TrainingJobDefinition `type:"structure" required:"true"`

	// The TransformJobDefinition object that describes the transform job that Amazon
	// SageMaker runs to validate your algorithm.
	TransformJobDefinition *TransformJobDefinition `type:"structure"`
}

// String returns the string representation
func (s AlgorithmValidationProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmValidationProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmValidationProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlgorithmValidationProfile"}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 1))
	}
	if s.TrainingJobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingJobDefinition"))
	}
	if s.TrainingJobDefinition != nil {
		if err := s.TrainingJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TrainingJobDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.TransformJobDefinition != nil {
		if err := s.TransformJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TransformJobDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileName sets the ProfileName field's value.
func (s *AlgorithmValidationProfile) SetProfileName(v string) *AlgorithmValidationProfile {
	s.ProfileName = &v
	return s
}

// SetTrainingJobDefinition sets the TrainingJobDefinition field's value.
func (s *AlgorithmValidationProfile) SetTrainingJobDefinition(v *TrainingJobDefinition) *AlgorithmValidationProfile {
	s.TrainingJobDefinition = v
	return s
}

// SetTransformJobDefinition sets the TransformJobDefinition field's value.
func (s *AlgorithmValidationProfile) SetTransformJobDefinition(v *TransformJobDefinition) *AlgorithmValidationProfile {
	s.TransformJobDefinition = v
	return s
}

// Specifies configurations for one or more training jobs that Amazon SageMaker
// runs to test the algorithm.
type AlgorithmValidationSpecification struct {
	_ struct{} `type:"structure"`

	// An array of AlgorithmValidationProfile objects, each of which specifies a
	// training job and batch transform job that Amazon SageMaker runs to validate
	// your algorithm.
	//
	// ValidationProfiles is a required field
	ValidationProfiles []*AlgorithmValidationProfile `min:"1" type:"list" required:"true"`

	// The IAM roles that Amazon SageMaker uses to run the training jobs.
	//
	// ValidationRole is a required field
	ValidationRole *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AlgorithmValidationSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmValidationSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmValidationSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlgorithmValidationSpecification"}
	if s.ValidationProfiles == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationProfiles"))
	}
	if s.ValidationProfiles != nil && len(s.ValidationProfiles) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationProfiles", 1))
	}
	if s.ValidationRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationRole"))
	}
	if s.ValidationRole != nil && len(*s.ValidationRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationRole", 20))
	}
	if s.ValidationProfiles != nil {
		for i, v := range s.ValidationProfiles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationProfiles", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValidationProfiles sets the ValidationProfiles field's value.
func (s *AlgorithmValidationSpecification) SetValidationProfiles(v []*AlgorithmValidationProfile) *AlgorithmValidationSpecification {
	s.ValidationProfiles = v
	return s
}

// SetValidationRole sets the ValidationRole field's value.
func (s *AlgorithmValidationSpecification) SetValidationRole(v string) *AlgorithmValidationSpecification {
	s.ValidationRole = &v
	return s
}

// Configures how labels are consolidated across human workers.
type AnnotationConsolidationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a Lambda function implements the logic
	// for annotation consolidation.
	//
	// For the built-in bounding box, image classification, semantic segmentation,
	// and text classification task types, Amazon SageMaker Ground Truth provides
	// the following Lambda functions:
	//
	//    * Bounding box - Finds the most similar boxes from different workers based
	//    on the Jaccard index of the boxes. arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox
	//
	//    * Image classification - Uses a variant of the Expectation Maximization
	//    approach to estimate the true class of an image based on annotations from
	//    individual workers. arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass
	//
	//    * Semantic segmentation - Treats each pixel in an image as a multi-class
	//    classification and treats pixel annotations from workers as "votes" for
	//    the correct label. arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation
	//
	//    * Text classification - Uses a variant of the Expectation Maximization
	//    approach to estimate the true class of text based on annotations from
	//    individual workers. arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass
	//
	//    * Named entity recognition - Groups similar selections and calculates
	//    aggregate boundaries, resolving to most-assigned label. arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition
	//
	//    * Bounding box verification - Uses a variant of the Expectation Maximization
	//    approach to estimate the true class of verification judgement for bounding
	//    box labels based on annotations from individual workers. arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox
	//
	//    * Semantic segmentation verification - Uses a variant of the Expectation
	//    Maximization approach to estimate the true class of verification judgment
	//    for semantic segmentation labels based on annotations from individual
	//    workers. arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation
	//
	//    * Bounding box adjustment - Finds the most similar boxes from different
	//    workers based on the Jaccard index of the adjusted annotations. arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox
	//
	//    * Semantic segmentation adjustment - Treats each pixel in an image as
	//    a multi-class classification and treats pixel adjusted annotations from
	//    workers as "votes" for the correct label. arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation
	//
	// For more information, see Annotation Consolidation (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html).
	//
	// AnnotationConsolidationLambdaArn is a required field
	AnnotationConsolidationLambdaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AnnotationConsolidationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnnotationConsolidationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnnotationConsolidationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnnotationConsolidationConfig"}
	if s.AnnotationConsolidationLambdaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnnotationConsolidationLambdaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotationConsolidationLambdaArn sets the AnnotationConsolidationLambdaArn field's value.
func (s *AnnotationConsolidationConfig) SetAnnotationConsolidationLambdaArn(v string) *AnnotationConsolidationConfig {
	s.AnnotationConsolidationLambdaArn = &v
	return s
}

// The app's details.
type AppDetails struct {
	_ struct{} `type:"structure"`

	// The name of the app.
	AppName *string `type:"string"`

	// The type of app.
	AppType *string `type:"string" enum:"AppType"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The status.
	Status *string `type:"string" enum:"AppStatus"`

	// The user profile name.
	UserProfileName *string `type:"string"`
}

// String returns the string representation
func (s AppDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppDetails) GoString() string {
	return s.String()
}

// SetAppName sets the AppName field's value.
func (s *AppDetails) SetAppName(v string) *AppDetails {
	s.AppName = &v
	return s
}

// SetAppType sets the AppType field's value.
func (s *AppDetails) SetAppType(v string) *AppDetails {
	s.AppType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AppDetails) SetCreationTime(v time.Time) *AppDetails {
	s.CreationTime = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AppDetails) SetDomainId(v string) *AppDetails {
	s.DomainId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AppDetails) SetStatus(v string) *AppDetails {
	s.Status = &v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *AppDetails) SetUserProfileName(v string) *AppDetails {
	s.UserProfileName = &v
	return s
}

// Configuration to run a processing job in a specified container image.
type AppSpecification struct {
	_ struct{} `type:"structure"`

	// The arguments for a container used to run a processing job.
	ContainerArguments []*string `min:"1" type:"list"`

	// The entrypoint for a container used to run a processing job.
	ContainerEntrypoint []*string `min:"1" type:"list"`

	// The container image to be run by the processing job.
	//
	// ImageUri is a required field
	ImageUri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AppSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppSpecification"}
	if s.ContainerArguments != nil && len(s.ContainerArguments) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerArguments", 1))
	}
	if s.ContainerEntrypoint != nil && len(s.ContainerEntrypoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerEntrypoint", 1))
	}
	if s.ImageUri == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerArguments sets the ContainerArguments field's value.
func (s *AppSpecification) SetContainerArguments(v []*string) *AppSpecification {
	s.ContainerArguments = v
	return s
}

// SetContainerEntrypoint sets the ContainerEntrypoint field's value.
func (s *AppSpecification) SetContainerEntrypoint(v []*string) *AppSpecification {
	s.ContainerEntrypoint = v
	return s
}

// SetImageUri sets the ImageUri field's value.
func (s *AppSpecification) SetImageUri(v string) *AppSpecification {
	s.ImageUri = &v
	return s
}

type AssociateTrialComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component to associated with the trial.
	//
	// TrialComponentName is a required field
	TrialComponentName *string `min:"1" type:"string" required:"true"`

	// The name of the trial to associate with.
	//
	// TrialName is a required field
	TrialName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateTrialComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTrialComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTrialComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTrialComponentInput"}
	if s.TrialComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialComponentName"))
	}
	if s.TrialComponentName != nil && len(*s.TrialComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialComponentName", 1))
	}
	if s.TrialName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialName"))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrialComponentName sets the TrialComponentName field's value.
func (s *AssociateTrialComponentInput) SetTrialComponentName(v string) *AssociateTrialComponentInput {
	s.TrialComponentName = &v
	return s
}

// SetTrialName sets the TrialName field's value.
func (s *AssociateTrialComponentInput) SetTrialName(v string) *AssociateTrialComponentInput {
	s.TrialName = &v
	return s
}

type AssociateTrialComponentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string `type:"string"`

	// The ARN of the trial component.
	TrialComponentArn *string `type:"string"`
}

// String returns the string representation
func (s AssociateTrialComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTrialComponentOutput) GoString() string {
	return s.String()
}

// SetTrialArn sets the TrialArn field's value.
func (s *AssociateTrialComponentOutput) SetTrialArn(v string) *AssociateTrialComponentOutput {
	s.TrialArn = &v
	return s
}

// SetTrialComponentArn sets the TrialComponentArn field's value.
func (s *AssociateTrialComponentOutput) SetTrialComponentArn(v string) *AssociateTrialComponentOutput {
	s.TrialComponentArn = &v
	return s
}

// An AutoPilot job will return recommendations, or candidates. Each candidate
// has futher details about the steps involed, and the status.
type AutoMLCandidate struct {
	_ struct{} `type:"structure"`

	// The candidate name.
	//
	// CandidateName is a required field
	CandidateName *string `min:"1" type:"string" required:"true"`

	// The candidate's status.
	//
	// CandidateStatus is a required field
	CandidateStatus *string `type:"string" required:"true" enum:"CandidateStatus"`

	// The candidate's steps.
	//
	// CandidateSteps is a required field
	CandidateSteps []*AutoMLCandidateStep `type:"list" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The end time.
	EndTime *time.Time `type:"timestamp"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// The candidate result from a job.
	FinalAutoMLJobObjectiveMetric *FinalAutoMLJobObjectiveMetric `type:"structure"`

	// The inference containers.
	InferenceContainers []*AutoMLContainerDefinition `type:"list"`

	// The last modified time.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// The objective status.
	//
	// ObjectiveStatus is a required field
	ObjectiveStatus *string `type:"string" required:"true" enum:"ObjectiveStatus"`
}

// String returns the string representation
func (s AutoMLCandidate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLCandidate) GoString() string {
	return s.String()
}

// SetCandidateName sets the CandidateName field's value.
func (s *AutoMLCandidate) SetCandidateName(v string) *AutoMLCandidate {
	s.CandidateName = &v
	return s
}

// SetCandidateStatus sets the CandidateStatus field's value.
func (s *AutoMLCandidate) SetCandidateStatus(v string) *AutoMLCandidate {
	s.CandidateStatus = &v
	return s
}

// SetCandidateSteps sets the CandidateSteps field's value.
func (s *AutoMLCandidate) SetCandidateSteps(v []*AutoMLCandidateStep) *AutoMLCandidate {
	s.CandidateSteps = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AutoMLCandidate) SetCreationTime(v time.Time) *AutoMLCandidate {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AutoMLCandidate) SetEndTime(v time.Time) *AutoMLCandidate {
	s.EndTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *AutoMLCandidate) SetFailureReason(v string) *AutoMLCandidate {
	s.FailureReason = &v
	return s
}

// SetFinalAutoMLJobObjectiveMetric sets the FinalAutoMLJobObjectiveMetric field's value.
func (s *AutoMLCandidate) SetFinalAutoMLJobObjectiveMetric(v *FinalAutoMLJobObjectiveMetric) *AutoMLCandidate {
	s.FinalAutoMLJobObjectiveMetric = v
	return s
}

// SetInferenceContainers sets the InferenceContainers field's value.
func (s *AutoMLCandidate) SetInferenceContainers(v []*AutoMLContainerDefinition) *AutoMLCandidate {
	s.InferenceContainers = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *AutoMLCandidate) SetLastModifiedTime(v time.Time) *AutoMLCandidate {
	s.LastModifiedTime = &v
	return s
}

// SetObjectiveStatus sets the ObjectiveStatus field's value.
func (s *AutoMLCandidate) SetObjectiveStatus(v string) *AutoMLCandidate {
	s.ObjectiveStatus = &v
	return s
}

// Information about the steps for a Candidate, and what step it is working
// on.
type AutoMLCandidateStep struct {
	_ struct{} `type:"structure"`

	// The ARN for the Candidate's step.
	//
	// CandidateStepArn is a required field
	CandidateStepArn *string `min:"1" type:"string" required:"true"`

	// The name for the Candidate's step.
	//
	// CandidateStepName is a required field
	CandidateStepName *string `min:"1" type:"string" required:"true"`

	// Whether the Candidate is at the transform, training, or processing step.
	//
	// CandidateStepType is a required field
	CandidateStepType *string `type:"string" required:"true" enum:"CandidateStepType"`
}

// String returns the string representation
func (s AutoMLCandidateStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLCandidateStep) GoString() string {
	return s.String()
}

// SetCandidateStepArn sets the CandidateStepArn field's value.
func (s *AutoMLCandidateStep) SetCandidateStepArn(v string) *AutoMLCandidateStep {
	s.CandidateStepArn = &v
	return s
}

// SetCandidateStepName sets the CandidateStepName field's value.
func (s *AutoMLCandidateStep) SetCandidateStepName(v string) *AutoMLCandidateStep {
	s.CandidateStepName = &v
	return s
}

// SetCandidateStepType sets the CandidateStepType field's value.
func (s *AutoMLCandidateStep) SetCandidateStepType(v string) *AutoMLCandidateStep {
	s.CandidateStepType = &v
	return s
}

// Similar to Channel. A channel is a named input source that training algorithms
// can consume. Refer to Channel for detailed descriptions.
type AutoMLChannel struct {
	_ struct{} `type:"structure"`

	// You can use Gzip or None. The default value is None.
	CompressionType *string `type:"string" enum:"CompressionType"`

	// The data source.
	//
	// DataSource is a required field
	DataSource *AutoMLDataSource `type:"structure" required:"true"`

	// The name of the target variable in supervised learning, a.k.a. 'y'.
	//
	// TargetAttributeName is a required field
	TargetAttributeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLChannel"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.TargetAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAttributeName"))
	}
	if s.TargetAttributeName != nil && len(*s.TargetAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAttributeName", 1))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompressionType sets the CompressionType field's value.
func (s *AutoMLChannel) SetCompressionType(v string) *AutoMLChannel {
	s.CompressionType = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *AutoMLChannel) SetDataSource(v *AutoMLDataSource) *AutoMLChannel {
	s.DataSource = v
	return s
}

// SetTargetAttributeName sets the TargetAttributeName field's value.
func (s *AutoMLChannel) SetTargetAttributeName(v string) *AutoMLChannel {
	s.TargetAttributeName = &v
	return s
}

// A list of container definitions that describe the different containers that
// make up one AutoML candidate. Refer to ContainerDefinition for more details.
type AutoMLContainerDefinition struct {
	_ struct{} `type:"structure"`

	// Environment variables to set in the container. Refer to ContainerDefinition
	// for more details.
	Environment map[string]*string `type:"map"`

	// The ECR path of the container. Refer to ContainerDefinition for more details.
	//
	// Image is a required field
	Image *string `type:"string" required:"true"`

	// The location of the model artifacts. Refer to ContainerDefinition for more
	// details.
	//
	// ModelDataUrl is a required field
	ModelDataUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLContainerDefinition) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *AutoMLContainerDefinition) SetEnvironment(v map[string]*string) *AutoMLContainerDefinition {
	s.Environment = v
	return s
}

// SetImage sets the Image field's value.
func (s *AutoMLContainerDefinition) SetImage(v string) *AutoMLContainerDefinition {
	s.Image = &v
	return s
}

// SetModelDataUrl sets the ModelDataUrl field's value.
func (s *AutoMLContainerDefinition) SetModelDataUrl(v string) *AutoMLContainerDefinition {
	s.ModelDataUrl = &v
	return s
}

// The data source for the AutoPilot job.
type AutoMLDataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the data.
	//
	// S3DataSource is a required field
	S3DataSource *AutoMLS3DataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s AutoMLDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLDataSource"}
	if s.S3DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataSource sets the S3DataSource field's value.
func (s *AutoMLDataSource) SetS3DataSource(v *AutoMLS3DataSource) *AutoMLDataSource {
	s.S3DataSource = v
	return s
}

// Artifacts that are generation during a job.
type AutoMLJobArtifacts struct {
	_ struct{} `type:"structure"`

	// The URL to the notebook location.
	CandidateDefinitionNotebookLocation *string `min:"1" type:"string"`

	// The URL to the notebook location.
	DataExplorationNotebookLocation *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AutoMLJobArtifacts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobArtifacts) GoString() string {
	return s.String()
}

// SetCandidateDefinitionNotebookLocation sets the CandidateDefinitionNotebookLocation field's value.
func (s *AutoMLJobArtifacts) SetCandidateDefinitionNotebookLocation(v string) *AutoMLJobArtifacts {
	s.CandidateDefinitionNotebookLocation = &v
	return s
}

// SetDataExplorationNotebookLocation sets the DataExplorationNotebookLocation field's value.
func (s *AutoMLJobArtifacts) SetDataExplorationNotebookLocation(v string) *AutoMLJobArtifacts {
	s.DataExplorationNotebookLocation = &v
	return s
}

// How long a job is allowed to run, or how many candidates a job is allowed
// to generate.
type AutoMLJobCompletionCriteria struct {
	_ struct{} `type:"structure"`

	// The maximum time, in seconds, an AutoML job is allowed to wait for a trial
	// to complete. It must be equal to or greater than MaxRuntimePerTrainingJobInSeconds.
	MaxAutoMLJobRuntimeInSeconds *int64 `min:"1" type:"integer"`

	// The maximum number of times a training job is allowed to run.
	MaxCandidates *int64 `min:"1" type:"integer"`

	// The maximum time, in seconds, a job is allowed to run.
	MaxRuntimePerTrainingJobInSeconds *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s AutoMLJobCompletionCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobCompletionCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLJobCompletionCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLJobCompletionCriteria"}
	if s.MaxAutoMLJobRuntimeInSeconds != nil && *s.MaxAutoMLJobRuntimeInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAutoMLJobRuntimeInSeconds", 1))
	}
	if s.MaxCandidates != nil && *s.MaxCandidates < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxCandidates", 1))
	}
	if s.MaxRuntimePerTrainingJobInSeconds != nil && *s.MaxRuntimePerTrainingJobInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRuntimePerTrainingJobInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxAutoMLJobRuntimeInSeconds sets the MaxAutoMLJobRuntimeInSeconds field's value.
func (s *AutoMLJobCompletionCriteria) SetMaxAutoMLJobRuntimeInSeconds(v int64) *AutoMLJobCompletionCriteria {
	s.MaxAutoMLJobRuntimeInSeconds = &v
	return s
}

// SetMaxCandidates sets the MaxCandidates field's value.
func (s *AutoMLJobCompletionCriteria) SetMaxCandidates(v int64) *AutoMLJobCompletionCriteria {
	s.MaxCandidates = &v
	return s
}

// SetMaxRuntimePerTrainingJobInSeconds sets the MaxRuntimePerTrainingJobInSeconds field's value.
func (s *AutoMLJobCompletionCriteria) SetMaxRuntimePerTrainingJobInSeconds(v int64) *AutoMLJobCompletionCriteria {
	s.MaxRuntimePerTrainingJobInSeconds = &v
	return s
}

// A collection of settings used for a job.
type AutoMLJobConfig struct {
	_ struct{} `type:"structure"`

	// How long a job is allowed to run, or how many candidates a job is allowed
	// to generate.
	CompletionCriteria *AutoMLJobCompletionCriteria `type:"structure"`

	// Security configuration for traffic encryption or Amazon VPC settings.
	SecurityConfig *AutoMLSecurityConfig `type:"structure"`
}

// String returns the string representation
func (s AutoMLJobConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLJobConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLJobConfig"}
	if s.CompletionCriteria != nil {
		if err := s.CompletionCriteria.Validate(); err != nil {
			invalidParams.AddNested("CompletionCriteria", err.(request.ErrInvalidParams))
		}
	}
	if s.SecurityConfig != nil {
		if err := s.SecurityConfig.Validate(); err != nil {
			invalidParams.AddNested("SecurityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompletionCriteria sets the CompletionCriteria field's value.
func (s *AutoMLJobConfig) SetCompletionCriteria(v *AutoMLJobCompletionCriteria) *AutoMLJobConfig {
	s.CompletionCriteria = v
	return s
}

// SetSecurityConfig sets the SecurityConfig field's value.
func (s *AutoMLJobConfig) SetSecurityConfig(v *AutoMLSecurityConfig) *AutoMLJobConfig {
	s.SecurityConfig = v
	return s
}

// Applies a metric to minimize or maximize for the job's objective.
type AutoMLJobObjective struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true" enum:"AutoMLMetricEnum"`
}

// String returns the string representation
func (s AutoMLJobObjective) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobObjective) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLJobObjective) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLJobObjective"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricName sets the MetricName field's value.
func (s *AutoMLJobObjective) SetMetricName(v string) *AutoMLJobObjective {
	s.MetricName = &v
	return s
}

// Provides a summary about a job.
type AutoMLJobSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the job.
	//
	// AutoMLJobArn is a required field
	AutoMLJobArn *string `min:"1" type:"string" required:"true"`

	// The name of the object you are requesting.
	//
	// AutoMLJobName is a required field
	AutoMLJobName *string `min:"1" type:"string" required:"true"`

	// The job's secondary status.
	//
	// AutoMLJobSecondaryStatus is a required field
	AutoMLJobSecondaryStatus *string `type:"string" required:"true" enum:"AutoMLJobSecondaryStatus"`

	// The job's status.
	//
	// AutoMLJobStatus is a required field
	AutoMLJobStatus *string `type:"string" required:"true" enum:"AutoMLJobStatus"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The end time.
	EndTime *time.Time `type:"timestamp"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// When the job was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AutoMLJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobSummary) GoString() string {
	return s.String()
}

// SetAutoMLJobArn sets the AutoMLJobArn field's value.
func (s *AutoMLJobSummary) SetAutoMLJobArn(v string) *AutoMLJobSummary {
	s.AutoMLJobArn = &v
	return s
}

// SetAutoMLJobName sets the AutoMLJobName field's value.
func (s *AutoMLJobSummary) SetAutoMLJobName(v string) *AutoMLJobSummary {
	s.AutoMLJobName = &v
	return s
}

// SetAutoMLJobSecondaryStatus sets the AutoMLJobSecondaryStatus field's value.
func (s *AutoMLJobSummary) SetAutoMLJobSecondaryStatus(v string) *AutoMLJobSummary {
	s.AutoMLJobSecondaryStatus = &v
	return s
}

// SetAutoMLJobStatus sets the AutoMLJobStatus field's value.
func (s *AutoMLJobSummary) SetAutoMLJobStatus(v string) *AutoMLJobSummary {
	s.AutoMLJobStatus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AutoMLJobSummary) SetCreationTime(v time.Time) *AutoMLJobSummary {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AutoMLJobSummary) SetEndTime(v time.Time) *AutoMLJobSummary {
	s.EndTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *AutoMLJobSummary) SetFailureReason(v string) *AutoMLJobSummary {
	s.FailureReason = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *AutoMLJobSummary) SetLastModifiedTime(v time.Time) *AutoMLJobSummary {
	s.LastModifiedTime = &v
	return s
}

// The output data configuration.
type AutoMLOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The AWS KMS encryption key ID.
	KmsKeyId *string `type:"string"`

	// The Amazon S3 output path. Must be 128 characters or less.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLOutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLOutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLOutputDataConfig"}
	if s.S3OutputPath == nil {
		invalidParams.Add(request.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AutoMLOutputDataConfig) SetKmsKeyId(v string) *AutoMLOutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3OutputPath sets the S3OutputPath field's value.
func (s *AutoMLOutputDataConfig) SetS3OutputPath(v string) *AutoMLOutputDataConfig {
	s.S3OutputPath = &v
	return s
}

// The Amazon S3 data source.
type AutoMLS3DataSource struct {
	_ struct{} `type:"structure"`

	// The data type.
	//
	// S3DataType is a required field
	S3DataType *string `type:"string" required:"true" enum:"AutoMLS3DataType"`

	// The URL to the Amazon S3 data source.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLS3DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLS3DataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLS3DataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLS3DataSource"}
	if s.S3DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataType"))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataType sets the S3DataType field's value.
func (s *AutoMLS3DataSource) SetS3DataType(v string) *AutoMLS3DataSource {
	s.S3DataType = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *AutoMLS3DataSource) SetS3Uri(v string) *AutoMLS3DataSource {
	s.S3Uri = &v
	return s
}

// Security options.
type AutoMLSecurityConfig struct {
	_ struct{} `type:"structure"`

	// Whether to use traffic encryption between the container layers.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// The key used to encrypt stored data.
	VolumeKmsKeyId *string `type:"string"`

	// VPC configuration.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s AutoMLSecurityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLSecurityConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLSecurityConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLSecurityConfig"}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableInterContainerTrafficEncryption sets the EnableInterContainerTrafficEncryption field's value.
func (s *AutoMLSecurityConfig) SetEnableInterContainerTrafficEncryption(v bool) *AutoMLSecurityConfig {
	s.EnableInterContainerTrafficEncryption = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *AutoMLSecurityConfig) SetVolumeKmsKeyId(v string) *AutoMLSecurityConfig {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *AutoMLSecurityConfig) SetVpcConfig(v *VpcConfig) *AutoMLSecurityConfig {
	s.VpcConfig = v
	return s
}

type CaptureContentTypeHeader struct {
	_ struct{} `type:"structure"`

	CsvContentTypes []*string `min:"1" type:"list"`

	JsonContentTypes []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s CaptureContentTypeHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptureContentTypeHeader) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptureContentTypeHeader) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptureContentTypeHeader"}
	if s.CsvContentTypes != nil && len(s.CsvContentTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CsvContentTypes", 1))
	}
	if s.JsonContentTypes != nil && len(s.JsonContentTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JsonContentTypes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsvContentTypes sets the CsvContentTypes field's value.
func (s *CaptureContentTypeHeader) SetCsvContentTypes(v []*string) *CaptureContentTypeHeader {
	s.CsvContentTypes = v
	return s
}

// SetJsonContentTypes sets the JsonContentTypes field's value.
func (s *CaptureContentTypeHeader) SetJsonContentTypes(v []*string) *CaptureContentTypeHeader {
	s.JsonContentTypes = v
	return s
}

type CaptureOption struct {
	_ struct{} `type:"structure"`

	// CaptureMode is a required field
	CaptureMode *string `type:"string" required:"true" enum:"CaptureMode"`
}

// String returns the string representation
func (s CaptureOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptureOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptureOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptureOption"}
	if s.CaptureMode == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptureMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptureMode sets the CaptureMode field's value.
func (s *CaptureOption) SetCaptureMode(v string) *CaptureOption {
	s.CaptureMode = &v
	return s
}

// A list of categorical hyperparameters to tune.
type CategoricalParameterRange struct {
	_ struct{} `type:"structure"`

	// The name of the categorical hyperparameter to tune.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A list of the categories for the hyperparameter.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CategoricalParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CategoricalParameterRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalParameterRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CategoricalParameterRange"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CategoricalParameterRange) SetName(v string) *CategoricalParameterRange {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *CategoricalParameterRange) SetValues(v []*string) *CategoricalParameterRange {
	s.Values = v
	return s
}

// Defines the possible values for a categorical hyperparameter.
type CategoricalParameterRangeSpecification struct {
	_ struct{} `type:"structure"`

	// The allowed categories for the hyperparameter.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CategoricalParameterRangeSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CategoricalParameterRangeSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalParameterRangeSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CategoricalParameterRangeSpecification"}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValues sets the Values field's value.
func (s *CategoricalParameterRangeSpecification) SetValues(v []*string) *CategoricalParameterRangeSpecification {
	s.Values = v
	return s
}

// A channel is a named input source that training algorithms can consume.
type Channel struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// If training data is compressed, the compression type. The default value is
	// None. CompressionType is used only in Pipe input mode. In File mode, leave
	// this field unset or set it to None.
	CompressionType *string `type:"string" enum:"CompressionType"`

	// The MIME type of the data.
	ContentType *string `type:"string"`

	// The location of the channel data.
	//
	// DataSource is a required field
	DataSource *DataSource `type:"structure" required:"true"`

	// (Optional) The input mode to use for the data channel in a training job.
	// If you don't set a value for InputMode, Amazon SageMaker uses the value set
	// for TrainingInputMode. Use this parameter to override the TrainingInputMode
	// setting in a AlgorithmSpecification request when you have a channel that
	// needs a different input mode from the training job's general setting. To
	// download the data from Amazon Simple Storage Service (Amazon S3) to the provisioned
	// ML storage volume, and mount the directory to a Docker volume, use File input
	// mode. To stream data directly from Amazon S3 to the container, choose Pipe
	// input mode.
	//
	// To use a model for incremental training, choose File input model.
	InputMode *string `type:"string" enum:"TrainingInputMode"`

	// Specify RecordIO as the value when input data is in raw format but the training
	// algorithm requires the RecordIO format. In this case, Amazon SageMaker wraps
	// each individual S3 object in a RecordIO record. If the input data is already
	// in RecordIO format, you don't need to set this attribute. For more information,
	// see Create a Dataset Using RecordIO (https://mxnet.apache.org/api/architecture/note_data_loading#data-format).
	//
	// In File mode, leave this field unset or set it to None.
	RecordWrapperType *string `type:"string" enum:"RecordWrapper"`

	// A configuration for a shuffle option for input data in a channel. If you
	// use S3Prefix for S3DataType, this shuffles the results of the S3 key prefix
	// matches. If you use ManifestFile, the order of the S3 object references in
	// the ManifestFile is shuffled. If you use AugmentedManifestFile, the order
	// of the JSON lines in the AugmentedManifestFile is shuffled. The shuffling
	// order is determined using the Seed value.
	//
	// For Pipe input mode, shuffling is done at the start of every epoch. With
	// large datasets this ensures that the order of the training data is different
	// for each epoch, it helps reduce bias and possible overfitting. In a multi-node
	// training job when ShuffleConfig is combined with S3DataDistributionType of
	// ShardedByS3Key, the data is shuffled across nodes so that the content sent
	// to a particular node on the first epoch might be sent to a different node
	// on the second epoch.
	ShuffleConfig *ShuffleConfig `type:"structure"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Channel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Channel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Channel"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(request.ErrInvalidParams))
		}
	}
	if s.ShuffleConfig != nil {
		if err := s.ShuffleConfig.Validate(); err != nil {
			invalidParams.AddNested("ShuffleConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *Channel) SetChannelName(v string) *Channel {
	s.ChannelName = &v
	return s
}

// SetCompressionType sets the CompressionType field's value.
func (s *Channel) SetCompressionType(v string) *Channel {
	s.CompressionType = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Channel) SetContentType(v string) *Channel {
	s.ContentType = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *Channel) SetDataSource(v *DataSource) *Channel {
	s.DataSource = v
	return s
}

// SetInputMode sets the InputMode field's value.
func (s *Channel) SetInputMode(v string) *Channel {
	s.InputMode = &v
	return s
}

// SetRecordWrapperType sets the RecordWrapperType field's value.
func (s *Channel) SetRecordWrapperType(v string) *Channel {
	s.RecordWrapperType = &v
	return s
}

// SetShuffleConfig sets the ShuffleConfig field's value.
func (s *Channel) SetShuffleConfig(v *ShuffleConfig) *Channel {
	s.ShuffleConfig = v
	return s
}

// Defines a named input source, called a channel, to be used by an algorithm.
type ChannelSpecification struct {
	_ struct{} `type:"structure"`

	// A brief description of the channel.
	Description *string `type:"string"`

	// Indicates whether the channel is required by the algorithm.
	IsRequired *bool `type:"boolean"`

	// The name of the channel.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The allowed compression types, if data compression is used.
	SupportedCompressionTypes []*string `type:"list"`

	// The supported MIME types for the data.
	//
	// SupportedContentTypes is a required field
	SupportedContentTypes []*string `type:"list" required:"true"`

	// The allowed input mode, either FILE or PIPE.
	//
	// In FILE mode, Amazon SageMaker copies the data from the input source onto
	// the local Amazon Elastic Block Store (Amazon EBS) volumes before starting
	// your training algorithm. This is the most commonly used input mode.
	//
	// In PIPE mode, Amazon SageMaker streams input data from the source directly
	// to your algorithm without using the EBS volume.
	//
	// SupportedInputModes is a required field
	SupportedInputModes []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ChannelSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelSpecification"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SupportedContentTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("SupportedContentTypes"))
	}
	if s.SupportedInputModes == nil {
		invalidParams.Add(request.NewErrParamRequired("SupportedInputModes"))
	}
	if s.SupportedInputModes != nil && len(s.SupportedInputModes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupportedInputModes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ChannelSpecification) SetDescription(v string) *ChannelSpecification {
	s.Description = &v
	return s
}

// SetIsRequired sets the IsRequired field's value.
func (s *ChannelSpecification) SetIsRequired(v bool) *ChannelSpecification {
	s.IsRequired = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelSpecification) SetName(v string) *ChannelSpecification {
	s.Name = &v
	return s
}

// SetSupportedCompressionTypes sets the SupportedCompressionTypes field's value.
func (s *ChannelSpecification) SetSupportedCompressionTypes(v []*string) *ChannelSpecification {
	s.SupportedCompressionTypes = v
	return s
}

// SetSupportedContentTypes sets the SupportedContentTypes field's value.
func (s *ChannelSpecification) SetSupportedContentTypes(v []*string) *ChannelSpecification {
	s.SupportedContentTypes = v
	return s
}

// SetSupportedInputModes sets the SupportedInputModes field's value.
func (s *ChannelSpecification) SetSupportedInputModes(v []*string) *ChannelSpecification {
	s.SupportedInputModes = v
	return s
}

// Contains information about the output location for managed spot training
// checkpoint data.
type CheckpointConfig struct {
	_ struct{} `type:"structure"`

	// (Optional) The local directory where checkpoints are written. The default
	// directory is /opt/ml/checkpoints/.
	LocalPath *string `type:"string"`

	// Identifies the S3 path where you want Amazon SageMaker to store checkpoints.
	// For example, s3://bucket-name/key-name-prefix.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CheckpointConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckpointConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckpointConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckpointConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocalPath sets the LocalPath field's value.
func (s *CheckpointConfig) SetLocalPath(v string) *CheckpointConfig {
	s.LocalPath = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *CheckpointConfig) SetS3Uri(v string) *CheckpointConfig {
	s.S3Uri = &v
	return s
}

// Specifies summary information about a Git repository.
type CodeRepositorySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Git repository.
	//
	// CodeRepositoryArn is a required field
	CodeRepositoryArn *string `min:"1" type:"string" required:"true"`

	// The name of the Git repository.
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`

	// The date and time that the Git repository was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Configuration details for the Git repository, including the URL where it
	// is located and the ARN of the AWS Secrets Manager secret that contains the
	// credentials used to access the repository.
	GitConfig *GitConfig `type:"structure"`

	// The date and time that the Git repository was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s CodeRepositorySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeRepositorySummary) GoString() string {
	return s.String()
}

// SetCodeRepositoryArn sets the CodeRepositoryArn field's value.
func (s *CodeRepositorySummary) SetCodeRepositoryArn(v string) *CodeRepositorySummary {
	s.CodeRepositoryArn = &v
	return s
}

// SetCodeRepositoryName sets the CodeRepositoryName field's value.
func (s *CodeRepositorySummary) SetCodeRepositoryName(v string) *CodeRepositorySummary {
	s.CodeRepositoryName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CodeRepositorySummary) SetCreationTime(v time.Time) *CodeRepositorySummary {
	s.CreationTime = &v
	return s
}

// SetGitConfig sets the GitConfig field's value.
func (s *CodeRepositorySummary) SetGitConfig(v *GitConfig) *CodeRepositorySummary {
	s.GitConfig = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CodeRepositorySummary) SetLastModifiedTime(v time.Time) *CodeRepositorySummary {
	s.LastModifiedTime = &v
	return s
}

// Identifies a Amazon Cognito user group. A user group can be used in on or
// more work teams.
type CognitoMemberDefinition struct {
	_ struct{} `type:"structure"`

	// An identifier for an application client. You must create the app client ID
	// using Amazon Cognito.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// An identifier for a user group.
	//
	// UserGroup is a required field
	UserGroup *string `min:"1" type:"string" required:"true"`

	// An identifier for a user pool. The user pool must be in the same region as
	// the service that you are calling.
	//
	// UserPool is a required field
	UserPool *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CognitoMemberDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CognitoMemberDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoMemberDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CognitoMemberDefinition"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("UserGroup"))
	}
	if s.UserGroup != nil && len(*s.UserGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserGroup", 1))
	}
	if s.UserPool == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPool"))
	}
	if s.UserPool != nil && len(*s.UserPool) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPool", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *CognitoMemberDefinition) SetClientId(v string) *CognitoMemberDefinition {
	s.ClientId = &v
	return s
}

// SetUserGroup sets the UserGroup field's value.
func (s *CognitoMemberDefinition) SetUserGroup(v string) *CognitoMemberDefinition {
	s.UserGroup = &v
	return s
}

// SetUserPool sets the UserPool field's value.
func (s *CognitoMemberDefinition) SetUserPool(v string) *CognitoMemberDefinition {
	s.UserPool = &v
	return s
}

// Configuration information for tensor collections.
type CollectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the tensor collection. The name must be unique relative to other
	// rule configuration names.
	CollectionName *string `min:"1" type:"string"`

	// Parameter values for the tensor collection. The allowed parameters are "name",
	// "include_regex", "reduction_config", "save_config", "tensor_names", and "save_histogram".
	CollectionParameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s CollectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CollectionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CollectionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CollectionConfiguration"}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *CollectionConfiguration) SetCollectionName(v string) *CollectionConfiguration {
	s.CollectionName = &v
	return s
}

// SetCollectionParameters sets the CollectionParameters field's value.
func (s *CollectionConfiguration) SetCollectionParameters(v map[string]*string) *CollectionConfiguration {
	s.CollectionParameters = v
	return s
}

// A summary of a model compilation job.
type CompilationJobSummary struct {
	_ struct{} `type:"structure"`

	// The time when the model compilation job completed.
	CompilationEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the model compilation job.
	//
	// CompilationJobArn is a required field
	CompilationJobArn *string `type:"string" required:"true"`

	// The name of the model compilation job that you want a summary for.
	//
	// CompilationJobName is a required field
	CompilationJobName *string `min:"1" type:"string" required:"true"`

	// The status of the model compilation job.
	//
	// CompilationJobStatus is a required field
	CompilationJobStatus *string `type:"string" required:"true" enum:"CompilationJobStatus"`

	// The time when the model compilation job started.
	CompilationStartTime *time.Time `type:"timestamp"`

	// The type of device that the model will run on after compilation has completed.
	//
	// CompilationTargetDevice is a required field
	CompilationTargetDevice *string `type:"string" required:"true" enum:"TargetDevice"`

	// The time when the model compilation job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The time when the model compilation job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CompilationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompilationJobSummary) GoString() string {
	return s.String()
}

// SetCompilationEndTime sets the CompilationEndTime field's value.
func (s *CompilationJobSummary) SetCompilationEndTime(v time.Time) *CompilationJobSummary {
	s.CompilationEndTime = &v
	return s
}

// SetCompilationJobArn sets the CompilationJobArn field's value.
func (s *CompilationJobSummary) SetCompilationJobArn(v string) *CompilationJobSummary {
	s.CompilationJobArn = &v
	return s
}

// SetCompilationJobName sets the CompilationJobName field's value.
func (s *CompilationJobSummary) SetCompilationJobName(v string) *CompilationJobSummary {
	s.CompilationJobName = &v
	return s
}

// SetCompilationJobStatus sets the CompilationJobStatus field's value.
func (s *CompilationJobSummary) SetCompilationJobStatus(v string) *CompilationJobSummary {
	s.CompilationJobStatus = &v
	return s
}

// SetCompilationStartTime sets the CompilationStartTime field's value.
func (s *CompilationJobSummary) SetCompilationStartTime(v time.Time) *CompilationJobSummary {
	s.CompilationStartTime = &v
	return s
}

// SetCompilationTargetDevice sets the CompilationTargetDevice field's value.
func (s *CompilationJobSummary) SetCompilationTargetDevice(v string) *CompilationJobSummary {
	s.CompilationTargetDevice = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CompilationJobSummary) SetCreationTime(v time.Time) *CompilationJobSummary {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CompilationJobSummary) SetLastModifiedTime(v time.Time) *CompilationJobSummary {
	s.LastModifiedTime = &v
	return s
}

// There was a conflict when you attempted to modify an experiment, trial, or
// trial component.
type ConflictException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ConflictException) OrigErr() error {
	return nil
}

func (s ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ConflictException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ConflictException) RequestID() string {
	return s.respMetadata.RequestID
}

// Describes the container, as part of model definition.
type ContainerDefinition struct {
	_ struct{} `type:"structure"`

	// This parameter is ignored for models that contain only a PrimaryContainer.
	//
	// When a ContainerDefinition is part of an inference pipeline, the value of
	// the parameter uniquely identifies the container for the purposes of logging
	// and metrics. For information, see Use Logs and Metrics to Monitor an Inference
	// Pipeline (https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html).
	// If you don't specify a value for this parameter for a ContainerDefinition
	// that is part of an inference pipeline, a unique name is automatically assigned
	// based on the position of the ContainerDefinition in the pipeline. If you
	// specify a value for the ContainerHostName for any ContainerDefinition that
	// is part of an inference pipeline, you must specify a value for the ContainerHostName
	// parameter of every ContainerDefinition in that pipeline.
	ContainerHostname *string `type:"string"`

	// The environment variables to set in the Docker container. Each key and value
	// in the Environment string to string map can have length of up to 1024. We
	// support up to 16 entries in the map.
	Environment map[string]*string `type:"map"`

	// The Amazon EC2 Container Registry (Amazon ECR) path where inference code
	// is stored. If you are using your own custom algorithm instead of an algorithm
	// provided by Amazon SageMaker, the inference code must meet Amazon SageMaker
	// requirements. Amazon SageMaker supports both registry/repository[:tag] and
	// registry/repository[@digest] image path formats. For more information, see
	// Using Your Own Algorithms with Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html)
	Image *string `type:"string"`

	// Whether the container hosts a single model or multiple models.
	Mode *string `type:"string" enum:"ContainerMode"`

	// The S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix). The S3 path is required for Amazon SageMaker built-in algorithms,
	// but not if you use your own algorithms. For more information on built-in
	// algorithms, see Common Parameters (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	//
	// If you provide a value for this parameter, Amazon SageMaker uses AWS Security
	// Token Service to download model artifacts from the S3 path you provide. AWS
	// STS is activated in your IAM user account by default. If you previously deactivated
	// AWS STS for a region, you need to reactivate AWS STS for that region. For
	// more information, see Activating and Deactivating AWS STS in an AWS Region
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
	// in the AWS Identity and Access Management User Guide.
	//
	// If you use a built-in algorithm to create a model, Amazon SageMaker requires
	// that you provide a S3 path to the model artifacts in ModelDataUrl.
	ModelDataUrl *string `type:"string"`

	// The name or Amazon Resource Name (ARN) of the model package to use to create
	// the model.
	ModelPackageName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerDefinition"}
	if s.ModelPackageName != nil && len(*s.ModelPackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelPackageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerHostname sets the ContainerHostname field's value.
func (s *ContainerDefinition) SetContainerHostname(v string) *ContainerDefinition {
	s.ContainerHostname = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerDefinition) SetEnvironment(v map[string]*string) *ContainerDefinition {
	s.Environment = v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerDefinition) SetImage(v string) *ContainerDefinition {
	s.Image = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *ContainerDefinition) SetMode(v string) *ContainerDefinition {
	s.Mode = &v
	return s
}

// SetModelDataUrl sets the ModelDataUrl field's value.
func (s *ContainerDefinition) SetModelDataUrl(v string) *ContainerDefinition {
	s.ModelDataUrl = &v
	return s
}

// SetModelPackageName sets the ModelPackageName field's value.
func (s *ContainerDefinition) SetModelPackageName(v string) *ContainerDefinition {
	s.ModelPackageName = &v
	return s
}

// A list of continuous hyperparameters to tune.
type ContinuousParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum value for the hyperparameter. The tuning job uses floating-point
	// values between MinValue value and this value for tuning.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum value for the hyperparameter. The tuning job uses floating-point
	// values between this value and MaxValuefor tuning.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`

	// The name of the continuous hyperparameter to tune.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values:
	//
	// Auto
	//
	// Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
	//
	// Linear
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have only values greater than
	// 0.
	//
	// ReverseLogarithmic
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a reverse logarithmic scale.
	//
	// Reverse logarithmic scaling works only for ranges that are entirely within
	// the range 0<=x<1.0.
	ScalingType *string `type:"string" enum:"HyperParameterScalingType"`
}

// String returns the string representation
func (s ContinuousParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinuousParameterRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousParameterRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContinuousParameterRange"}
	if s.MaxValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxValue"))
	}
	if s.MinValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MinValue"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxValue sets the MaxValue field's value.
func (s *ContinuousParameterRange) SetMaxValue(v string) *ContinuousParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *ContinuousParameterRange) SetMinValue(v string) *ContinuousParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContinuousParameterRange) SetName(v string) *ContinuousParameterRange {
	s.Name = &v
	return s
}

// SetScalingType sets the ScalingType field's value.
func (s *ContinuousParameterRange) SetScalingType(v string) *ContinuousParameterRange {
	s.ScalingType = &v
	return s
}

// Defines the possible values for a continuous hyperparameter.
type ContinuousParameterRangeSpecification struct {
	_ struct{} `type:"structure"`

	// The maximum floating-point value allowed.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum floating-point value allowed.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ContinuousParameterRangeSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinuousParameterRangeSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousParameterRangeSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContinuousParameterRangeSpecification"}
	if s.MaxValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxValue"))
	}
	if s.MinValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MinValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxValue sets the MaxValue field's value.
func (s *ContinuousParameterRangeSpecification) SetMaxValue(v string) *ContinuousParameterRangeSpecification {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *ContinuousParameterRangeSpecification) SetMinValue(v string) *ContinuousParameterRangeSpecification {
	s.MinValue = &v
	return s
}

type CreateAlgorithmInput struct {
	_ struct{} `type:"structure"`

	// A description of the algorithm.
	AlgorithmDescription *string `type:"string"`

	// The name of the algorithm.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// Whether to certify the algorithm so that it can be listed in AWS Marketplace.
	CertifyForMarketplace *bool `type:"boolean"`

	// Specifies details about inference jobs that the algorithm runs, including
	// the following:
	//
	//    * The Amazon ECR paths of containers that contain the inference code and
	//    model artifacts.
	//
	//    * The instance types that the algorithm supports for transform jobs and
	//    real-time endpoints used for inference.
	//
	//    * The input and output content formats that the algorithm supports for
	//    inference.
	InferenceSpecification *InferenceSpecification `type:"structure"`

	// Specifies details about training jobs run by this algorithm, including the
	// following:
	//
	//    * The Amazon ECR path of the container and the version digest of the algorithm.
	//
	//    * The hyperparameters that the algorithm supports.
	//
	//    * The instance types that the algorithm supports for training.
	//
	//    * Whether the algorithm supports distributed training.
	//
	//    * The metrics that the algorithm emits to Amazon CloudWatch.
	//
	//    * Which metrics that the algorithm emits can be used as the objective
	//    metric for hyperparameter tuning jobs.
	//
	//    * The input channels that the algorithm supports for training data. For
	//    example, an algorithm might support train, validation, and test channels.
	//
	// TrainingSpecification is a required field
	TrainingSpecification *TrainingSpecification `type:"structure" required:"true"`

	// Specifies configurations for one or more training jobs and that Amazon SageMaker
	// runs to test the algorithm's training code and, optionally, one or more batch
	// transform jobs that Amazon SageMaker runs to test the algorithm's inference
	// code.
	ValidationSpecification *AlgorithmValidationSpecification `type:"structure"`
}

// String returns the string representation
func (s CreateAlgorithmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAlgorithmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAlgorithmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAlgorithmInput"}
	if s.AlgorithmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlgorithmName"))
	}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlgorithmName", 1))
	}
	if s.TrainingSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingSpecification"))
	}
	if s.InferenceSpecification != nil {
		if err := s.InferenceSpecification.Validate(); err != nil {
			invalidParams.AddNested("InferenceSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.TrainingSpecification != nil {
		if err := s.TrainingSpecification.Validate(); err != nil {
			invalidParams.AddNested("TrainingSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.ValidationSpecification != nil {
		if err := s.ValidationSpecification.Validate(); err != nil {
			invalidParams.AddNested("ValidationSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmDescription sets the AlgorithmDescription field's value.
func (s *CreateAlgorithmInput) SetAlgorithmDescription(v string) *CreateAlgorithmInput {
	s.AlgorithmDescription = &v
	return s
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *CreateAlgorithmInput) SetAlgorithmName(v string) *CreateAlgorithmInput {
	s.AlgorithmName = &v
	return s
}

// SetCertifyForMarketplace sets the CertifyForMarketplace field's value.
func (s *CreateAlgorithmInput) SetCertifyForMarketplace(v bool) *CreateAlgorithmInput {
	s.CertifyForMarketplace = &v
	return s
}

// SetInferenceSpecification sets the InferenceSpecification field's value.
func (s *CreateAlgorithmInput) SetInferenceSpecification(v *InferenceSpecification) *CreateAlgorithmInput {
	s.InferenceSpecification = v
	return s
}

// SetTrainingSpecification sets the TrainingSpecification field's value.
func (s *CreateAlgorithmInput) SetTrainingSpecification(v *TrainingSpecification) *CreateAlgorithmInput {
	s.TrainingSpecification = v
	return s
}

// SetValidationSpecification sets the ValidationSpecification field's value.
func (s *CreateAlgorithmInput) SetValidationSpecification(v *AlgorithmValidationSpecification) *CreateAlgorithmInput {
	s.ValidationSpecification = v
	return s
}

type CreateAlgorithmOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new algorithm.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAlgorithmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAlgorithmOutput) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *CreateAlgorithmOutput) SetAlgorithmArn(v string) *CreateAlgorithmOutput {
	s.AlgorithmArn = &v
	return s
}

type CreateAppInput struct {
	_ struct{} `type:"structure"`

	// The name of the app.
	//
	// AppName is a required field
	AppName *string `type:"string" required:"true"`

	// The type of app.
	//
	// AppType is a required field
	AppType *string `type:"string" required:"true" enum:"AppType"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The instance type and quantity.
	ResourceSpec *ResourceSpec `type:"structure"`

	// Each tag consists of a key and an optional value. Tag keys must be unique
	// per resource.
	Tags []*Tag `type:"list"`

	// The user profile name.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInput"}
	if s.AppName == nil {
		invalidParams.Add(request.NewErrParamRequired("AppName"))
	}
	if s.AppType == nil {
		invalidParams.Add(request.NewErrParamRequired("AppType"))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.UserProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserProfileName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppName sets the AppName field's value.
func (s *CreateAppInput) SetAppName(v string) *CreateAppInput {
	s.AppName = &v
	return s
}

// SetAppType sets the AppType field's value.
func (s *CreateAppInput) SetAppType(v string) *CreateAppInput {
	s.AppType = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateAppInput) SetDomainId(v string) *CreateAppInput {
	s.DomainId = &v
	return s
}

// SetResourceSpec sets the ResourceSpec field's value.
func (s *CreateAppInput) SetResourceSpec(v *ResourceSpec) *CreateAppInput {
	s.ResourceSpec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppInput) SetTags(v []*Tag) *CreateAppInput {
	s.Tags = v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *CreateAppInput) SetUserProfileName(v string) *CreateAppInput {
	s.UserProfileName = &v
	return s
}

type CreateAppOutput struct {
	_ struct{} `type:"structure"`

	// The app's Amazon Resource Name (ARN).
	AppArn *string `type:"string"`
}

// String returns the string representation
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *CreateAppOutput) SetAppArn(v string) *CreateAppOutput {
	s.AppArn = &v
	return s
}

type CreateAutoMLJobInput struct {
	_ struct{} `type:"structure"`

	// Contains CompletionCriteria and SecurityConfig.
	AutoMLJobConfig *AutoMLJobConfig `type:"structure"`

	// Identifies an AutoPilot job. Must be unique to your account and is case-insensitive.
	//
	// AutoMLJobName is a required field
	AutoMLJobName *string `min:"1" type:"string" required:"true"`

	// Defines the job's objective. You provide a MetricName and AutoML will infer
	// minimize or maximize. If this is not provided, the most commonly used ObjectiveMetric
	// for problem type will be selected.
	AutoMLJobObjective *AutoMLJobObjective `type:"structure"`

	// This will generate possible candidates without training a model. A candidate
	// is a combination of data preprocessors, algorithms, and algorithm parameter
	// settings.
	GenerateCandidateDefinitionsOnly *bool `type:"boolean"`

	// Similar to InputDataConfig supported by Tuning. Format(s) supported: CSV.
	//
	// InputDataConfig is a required field
	InputDataConfig []*AutoMLChannel `min:"1" type:"list" required:"true"`

	// Similar to OutputDataConfig supported by Tuning. Format(s) supported: CSV.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *AutoMLOutputDataConfig `type:"structure" required:"true"`

	// Defines the kind of preprocessing and algorithms intended for the candidates.
	// Options include: BinaryClassification, MulticlassClassification, and Regression.
	ProblemType *string `type:"string" enum:"ProblemType"`

	// The ARN of the role that will be used to access the data.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Each tag consists of a key and an optional value. Tag keys must be unique
	// per resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateAutoMLJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAutoMLJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAutoMLJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAutoMLJobInput"}
	if s.AutoMLJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoMLJobName"))
	}
	if s.AutoMLJobName != nil && len(*s.AutoMLJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoMLJobName", 1))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.InputDataConfig != nil && len(s.InputDataConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDataConfig", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.AutoMLJobConfig != nil {
		if err := s.AutoMLJobConfig.Validate(); err != nil {
			invalidParams.AddNested("AutoMLJobConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.AutoMLJobObjective != nil {
		if err := s.AutoMLJobObjective.Validate(); err != nil {
			invalidParams.AddNested("AutoMLJobObjective", err.(request.ErrInvalidParams))
		}
	}
	if s.InputDataConfig != nil {
		for i, v := range s.InputDataConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputDataConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoMLJobConfig sets the AutoMLJobConfig field's value.
func (s *CreateAutoMLJobInput) SetAutoMLJobConfig(v *AutoMLJobConfig) *CreateAutoMLJobInput {
	s.AutoMLJobConfig = v
	return s
}

// SetAutoMLJobName sets the AutoMLJobName field's value.
func (s *CreateAutoMLJobInput) SetAutoMLJobName(v string) *CreateAutoMLJobInput {
	s.AutoMLJobName = &v
	return s
}

// SetAutoMLJobObjective sets the AutoMLJobObjective field's value.
func (s *CreateAutoMLJobInput) SetAutoMLJobObjective(v *AutoMLJobObjective) *CreateAutoMLJobInput {
	s.AutoMLJobObjective = v
	return s
}

// SetGenerateCandidateDefinitionsOnly sets the GenerateCandidateDefinitionsOnly field's value.
func (s *CreateAutoMLJobInput) SetGenerateCandidateDefinitionsOnly(v bool) *CreateAutoMLJobInput {
	s.GenerateCandidateDefinitionsOnly = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateAutoMLJobInput) SetInputDataConfig(v []*AutoMLChannel) *CreateAutoMLJobInput {
	s.InputDataConfig = v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *CreateAutoMLJobInput) SetOutputDataConfig(v *AutoMLOutputDataConfig) *CreateAutoMLJobInput {
	s.OutputDataConfig = v
	return s
}

// SetProblemType sets the ProblemType field's value.
func (s *CreateAutoMLJobInput) SetProblemType(v string) *CreateAutoMLJobInput {
	s.ProblemType = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateAutoMLJobInput) SetRoleArn(v string) *CreateAutoMLJobInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAutoMLJobInput) SetTags(v []*Tag) *CreateAutoMLJobInput {
	s.Tags = v
	return s
}

type CreateAutoMLJobOutput struct {
	_ struct{} `type:"structure"`

	// When a job is created, it is assigned a unique ARN.
	//
	// AutoMLJobArn is a required field
	AutoMLJobArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAutoMLJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAutoMLJobOutput) GoString() string {
	return s.String()
}

// SetAutoMLJobArn sets the AutoMLJobArn field's value.
func (s *CreateAutoMLJobOutput) SetAutoMLJobArn(v string) *CreateAutoMLJobOutput {
	s.AutoMLJobArn = &v
	return s
}

type CreateCodeRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Git repository. The name must have 1 to 63 characters. Valid
	// characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`

	// Specifies details about the repository, including the URL where the repository
	// is located, the default branch, and credentials to use to access the repository.
	//
	// GitConfig is a required field
	GitConfig *GitConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCodeRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCodeRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCodeRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCodeRepositoryInput"}
	if s.CodeRepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeRepositoryName"))
	}
	if s.CodeRepositoryName != nil && len(*s.CodeRepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeRepositoryName", 1))
	}
	if s.GitConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("GitConfig"))
	}
	if s.GitConfig != nil {
		if err := s.GitConfig.Validate(); err != nil {
			invalidParams.AddNested("GitConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeRepositoryName sets the CodeRepositoryName field's value.
func (s *CreateCodeRepositoryInput) SetCodeRepositoryName(v string) *CreateCodeRepositoryInput {
	s.CodeRepositoryName = &v
	return s
}

// SetGitConfig sets the GitConfig field's value.
func (s *CreateCodeRepositoryInput) SetGitConfig(v *GitConfig) *CreateCodeRepositoryInput {
	s.GitConfig = v
	return s
}

type CreateCodeRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new repository.
	//
	// CodeRepositoryArn is a required field
	CodeRepositoryArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCodeRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCodeRepositoryOutput) GoString() string {
	return s.String()
}

// SetCodeRepositoryArn sets the CodeRepositoryArn field's value.
func (s *CreateCodeRepositoryOutput) SetCodeRepositoryArn(v string) *CreateCodeRepositoryOutput {
	s.CodeRepositoryArn = &v
	return s
}

type CreateCompilationJobInput struct {
	_ struct{} `type:"structure"`

	// A name for the model compilation job. The name must be unique within the
	// AWS Region and within your AWS account.
	//
	// CompilationJobName is a required field
	CompilationJobName *string `min:"1" type:"string" required:"true"`

	// Provides information about the location of input model artifacts, the name
	// and shape of the expected data inputs, and the framework in which the model
	// was trained.
	//
	// InputConfig is a required field
	InputConfig *InputConfig `type:"structure" required:"true"`

	// Provides information about the output location for the compiled model and
	// the target device the model runs on.
	//
	// OutputConfig is a required field
	OutputConfig *OutputConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker
	// to perform tasks on your behalf.
	//
	// During model compilation, Amazon SageMaker needs your permission to:
	//
	//    * Read input data from an S3 bucket
	//
	//    * Write model artifacts to an S3 bucket
	//
	//    * Write logs to Amazon CloudWatch Logs
	//
	//    * Publish metrics to Amazon CloudWatch
	//
	// You grant permissions for all of these tasks to an IAM role. To pass this
	// role to Amazon SageMaker, the caller of this API must have the iam:PassRole
	// permission. For more information, see Amazon SageMaker Roles. (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html)
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies a limit to how long a model compilation job can run. When the job
	// reaches the time limit, Amazon SageMaker ends the compilation job. Use this
	// API to cap model training costs.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCompilationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCompilationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCompilationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCompilationJobInput"}
	if s.CompilationJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("CompilationJobName"))
	}
	if s.CompilationJobName != nil && len(*s.CompilationJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CompilationJobName", 1))
	}
	if s.InputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfig"))
	}
	if s.OutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StoppingCondition == nil {
		invalidParams.Add(request.NewErrParamRequired("StoppingCondition"))
	}
	if s.InputConfig != nil {
		if err := s.InputConfig.Validate(); err != nil {
			invalidParams.AddNested("InputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompilationJobName sets the CompilationJobName field's value.
func (s *CreateCompilationJobInput) SetCompilationJobName(v string) *CreateCompilationJobInput {
	s.CompilationJobName = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *CreateCompilationJobInput) SetInputConfig(v *InputConfig) *CreateCompilationJobInput {
	s.InputConfig = v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *CreateCompilationJobInput) SetOutputConfig(v *OutputConfig) *CreateCompilationJobInput {
	s.OutputConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateCompilationJobInput) SetRoleArn(v string) *CreateCompilationJobInput {
	s.RoleArn = &v
	return s
}

// SetStoppingCondition sets the StoppingCondition field's value.
func (s *CreateCompilationJobInput) SetStoppingCondition(v *StoppingCondition) *CreateCompilationJobInput {
	s.StoppingCondition = v
	return s
}

type CreateCompilationJobOutput struct {
	_ struct{} `type:"structure"`

	// If the action is successful, the service sends back an HTTP 200 response.
	// Amazon SageMaker returns the following data in JSON format:
	//
	//    * CompilationJobArn: The Amazon Resource Name (ARN) of the compiled job.
	//
	// CompilationJobArn is a required field
	CompilationJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCompilationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCompilationJobOutput) GoString() string {
	return s.String()
}

// SetCompilationJobArn sets the CompilationJobArn field's value.
func (s *CreateCompilationJobOutput) SetCompilationJobArn(v string) *CreateCompilationJobOutput {
	s.CompilationJobArn = &v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The mode of authentication that member use to access the domain.
	//
	// AuthMode is a required field
	AuthMode *string `type:"string" required:"true" enum:"AuthMode"`

	// The default user settings.
	//
	// DefaultUserSettings is a required field
	DefaultUserSettings *UserSettings `type:"structure" required:"true"`

	// A name for the domain.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The AWS Key Management Service encryption key ID.
	HomeEfsFileSystemKmsKeyId *string `type:"string"`

	// Security setting to limit to a set of subnets.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`

	// Each tag consists of a key and an optional value. Tag keys must be unique
	// per resource.
	Tags []*Tag `type:"list"`

	// Security setting to limit the domain's communication to a Amazon Virtual
	// Private Cloud.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.AuthMode == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthMode"))
	}
	if s.DefaultUserSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultUserSettings"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.DefaultUserSettings != nil {
		if err := s.DefaultUserSettings.Validate(); err != nil {
			invalidParams.AddNested("DefaultUserSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthMode sets the AuthMode field's value.
func (s *CreateDomainInput) SetAuthMode(v string) *CreateDomainInput {
	s.AuthMode = &v
	return s
}

// SetDefaultUserSettings sets the DefaultUserSettings field's value.
func (s *CreateDomainInput) SetDefaultUserSettings(v *UserSettings) *CreateDomainInput {
	s.DefaultUserSettings = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainInput) SetDomainName(v string) *CreateDomainInput {
	s.DomainName = &v
	return s
}

// SetHomeEfsFileSystemKmsKeyId sets the HomeEfsFileSystemKmsKeyId field's value.
func (s *CreateDomainInput) SetHomeEfsFileSystemKmsKeyId(v string) *CreateDomainInput {
	s.HomeEfsFileSystemKmsKeyId = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateDomainInput) SetSubnetIds(v []*string) *CreateDomainInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainInput) SetTags(v []*Tag) *CreateDomainInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateDomainInput) SetVpcId(v string) *CreateDomainInput {
	s.VpcId = &v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created domain.
	DomainArn *string `type:"string"`

	// The URL to the created domain.
	Url *string `type:"string"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetDomainArn sets the DomainArn field's value.
func (s *CreateDomainOutput) SetDomainArn(v string) *CreateDomainOutput {
	s.DomainArn = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *CreateDomainOutput) SetUrl(v string) *CreateDomainOutput {
	s.Url = &v
	return s
}

type CreateEndpointConfigInput struct {
	_ struct{} `type:"structure"`

	DataCaptureConfig *DataCaptureConfig `type:"structure"`

	// The name of the endpoint configuration. You specify this name in a CreateEndpoint
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html)
	// request.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon
	// SageMaker uses to encrypt data on the storage volume attached to the ML compute
	// instance that hosts the endpoint.
	//
	// The KmsKeyId can be any of the following formats:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	//
	// The KMS key policy must grant permission to the IAM role that you specify
	// in your CreateEndpoint, UpdateEndpoint requests. For more information, refer
	// to the AWS Key Management Service section Using Key Policies in AWS KMS (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	//
	// Certain Nitro-based instances include local storage, dependent on the instance
	// type. Local storage volumes are encrypted using a hardware module on the
	// instance. You can't request a KmsKeyId when using an instance type with local
	// storage. If any of the models that you specify in the ProductionVariants
	// parameter use nitro-based instances with local storage, do not specify a
	// value for the KmsKeyId parameter. If you specify a value for KmsKeyId when
	// using any nitro-based instances with local storage, the call to CreateEndpointConfig
	// fails.
	//
	// For a list of instance types that support local instance storage, see Instance
	// Store Volumes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
	//
	// For more information about local instance storage encryption, see SSD Instance
	// Store Volumes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
	KmsKeyId *string `type:"string"`

	// An list of ProductionVariant objects, one for each model that you want to
	// host at this endpoint.
	//
	// ProductionVariants is a required field
	ProductionVariants []*ProductionVariant `min:"1" type:"list" required:"true"`

	// A list of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateEndpointConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointConfigInput"}
	if s.EndpointConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigName"))
	}
	if s.ProductionVariants == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductionVariants"))
	}
	if s.ProductionVariants != nil && len(s.ProductionVariants) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductionVariants", 1))
	}
	if s.DataCaptureConfig != nil {
		if err := s.DataCaptureConfig.Validate(); err != nil {
			invalidParams.AddNested("DataCaptureConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ProductionVariants != nil {
		for i, v := range s.ProductionVariants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProductionVariants", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataCaptureConfig sets the DataCaptureConfig field's value.
func (s *CreateEndpointConfigInput) SetDataCaptureConfig(v *DataCaptureConfig) *CreateEndpointConfigInput {
	s.DataCaptureConfig = v
	return s
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *CreateEndpointConfigInput) SetEndpointConfigName(v string) *CreateEndpointConfigInput {
	s.EndpointConfigName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateEndpointConfigInput) SetKmsKeyId(v string) *CreateEndpointConfigInput {
	s.KmsKeyId = &v
	return s
}

// SetProductionVariants sets the ProductionVariants field's value.
func (s *CreateEndpointConfigInput) SetProductionVariants(v []*ProductionVariant) *CreateEndpointConfigInput {
	s.ProductionVariants = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointConfigInput) SetTags(v []*Tag) *CreateEndpointConfigInput {
	s.Tags = v
	return s
}

type CreateEndpointConfigOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEndpointConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointConfigOutput) GoString() string {
	return s.String()
}

// SetEndpointConfigArn sets the EndpointConfigArn field's value.
func (s *CreateEndpointConfigOutput) SetEndpointConfigArn(v string) *CreateEndpointConfigOutput {
	s.EndpointConfigArn = &v
	return s
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of an endpoint configuration. For more information, see CreateEndpointConfig
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html).
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// The name of the endpoint. The name must be unique within an AWS Region in
	// your AWS account.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)in
	// the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.EndpointConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigName"))
	}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *CreateEndpointInput) SetEndpointConfigName(v string) *CreateEndpointInput {
	s.EndpointConfigName = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *CreateEndpointInput) SetEndpointName(v string) *CreateEndpointInput {
	s.EndpointName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointInput) SetTags(v []*Tag) *CreateEndpointInput {
	s.Tags = v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *CreateEndpointOutput) SetEndpointArn(v string) *CreateEndpointOutput {
	s.EndpointArn = &v
	return s
}

type CreateExperimentInput struct {
	_ struct{} `type:"structure"`

	// The description of the experiment.
	Description *string `type:"string"`

	// The name of the experiment as displayed. The name doesn't need to be unique.
	// If you don't specify DisplayName, the value in ExperimentName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The name of the experiment. The name must be unique in your AWS account and
	// is not case-sensitive.
	//
	// ExperimentName is a required field
	ExperimentName *string `min:"1" type:"string" required:"true"`

	// A list of tags to associate with the experiment. You can use Search API to
	// search on the tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.ExperimentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentName"))
	}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateExperimentInput) SetDescription(v string) *CreateExperimentInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateExperimentInput) SetDisplayName(v string) *CreateExperimentInput {
	s.DisplayName = &v
	return s
}

// SetExperimentName sets the ExperimentName field's value.
func (s *CreateExperimentInput) SetExperimentName(v string) *CreateExperimentInput {
	s.ExperimentName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateExperimentInput) SetTags(v []*Tag) *CreateExperimentInput {
	s.Tags = v
	return s
}

type CreateExperimentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string `type:"string"`
}

// String returns the string representation
func (s CreateExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExperimentOutput) GoString() string {
	return s.String()
}

// SetExperimentArn sets the ExperimentArn field's value.
func (s *CreateExperimentOutput) SetExperimentArn(v string) *CreateExperimentOutput {
	s.ExperimentArn = &v
	return s
}

type CreateFlowDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The name of your flow definition.
	//
	// FlowDefinitionName is a required field
	FlowDefinitionName *string `min:"1" type:"string" required:"true"`

	// An object containing information about the events that trigger a human workflow.
	HumanLoopActivationConfig *HumanLoopActivationConfig `type:"structure"`

	// An object containing information about the tasks the human reviewers will
	// perform.
	//
	// HumanLoopConfig is a required field
	HumanLoopConfig *HumanLoopConfig `type:"structure" required:"true"`

	// An object containing information about where the human review results will
	// be uploaded.
	//
	// OutputConfig is a required field
	OutputConfig *FlowDefinitionOutputConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the role needed to call other services
	// on your behalf. For example, arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// An array of key-value pairs that contain metadata to help you categorize
	// and organize a flow definition. Each tag consists of a key and a value, both
	// of which you define.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateFlowDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowDefinitionInput"}
	if s.FlowDefinitionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinitionName"))
	}
	if s.FlowDefinitionName != nil && len(*s.FlowDefinitionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowDefinitionName", 1))
	}
	if s.HumanLoopConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopConfig"))
	}
	if s.OutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.HumanLoopActivationConfig != nil {
		if err := s.HumanLoopActivationConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopActivationConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HumanLoopConfig != nil {
		if err := s.HumanLoopConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowDefinitionName sets the FlowDefinitionName field's value.
func (s *CreateFlowDefinitionInput) SetFlowDefinitionName(v string) *CreateFlowDefinitionInput {
	s.FlowDefinitionName = &v
	return s
}

// SetHumanLoopActivationConfig sets the HumanLoopActivationConfig field's value.
func (s *CreateFlowDefinitionInput) SetHumanLoopActivationConfig(v *HumanLoopActivationConfig) *CreateFlowDefinitionInput {
	s.HumanLoopActivationConfig = v
	return s
}

// SetHumanLoopConfig sets the HumanLoopConfig field's value.
func (s *CreateFlowDefinitionInput) SetHumanLoopConfig(v *HumanLoopConfig) *CreateFlowDefinitionInput {
	s.HumanLoopConfig = v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *CreateFlowDefinitionInput) SetOutputConfig(v *FlowDefinitionOutputConfig) *CreateFlowDefinitionInput {
	s.OutputConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateFlowDefinitionInput) SetRoleArn(v string) *CreateFlowDefinitionInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFlowDefinitionInput) SetTags(v []*Tag) *CreateFlowDefinitionInput {
	s.Tags = v
	return s
}

type CreateFlowDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow definition you create.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateFlowDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowDefinitionOutput) GoString() string {
	return s.String()
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *CreateFlowDefinitionOutput) SetFlowDefinitionArn(v string) *CreateFlowDefinitionOutput {
	s.FlowDefinitionArn = &v
	return s
}

type CreateHumanTaskUiInput struct {
	_ struct{} `type:"structure"`

	// The name of the user interface you are creating.
	//
	// HumanTaskUiName is a required field
	HumanTaskUiName *string `min:"1" type:"string" required:"true"`

	// An array of key-value pairs that contain metadata to help you categorize
	// and organize a human review workflow user interface. Each tag consists of
	// a key and a value, both of which you define.
	Tags []*Tag `type:"list"`

	// The Liquid template for the worker user interface.
	//
	// UiTemplate is a required field
	UiTemplate *UiTemplate `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateHumanTaskUiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHumanTaskUiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHumanTaskUiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHumanTaskUiInput"}
	if s.HumanTaskUiName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanTaskUiName"))
	}
	if s.HumanTaskUiName != nil && len(*s.HumanTaskUiName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanTaskUiName", 1))
	}
	if s.UiTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("UiTemplate"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UiTemplate != nil {
		if err := s.UiTemplate.Validate(); err != nil {
			invalidParams.AddNested("UiTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanTaskUiName sets the HumanTaskUiName field's value.
func (s *CreateHumanTaskUiInput) SetHumanTaskUiName(v string) *CreateHumanTaskUiInput {
	s.HumanTaskUiName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHumanTaskUiInput) SetTags(v []*Tag) *CreateHumanTaskUiInput {
	s.Tags = v
	return s
}

// SetUiTemplate sets the UiTemplate field's value.
func (s *CreateHumanTaskUiInput) SetUiTemplate(v *UiTemplate) *CreateHumanTaskUiInput {
	s.UiTemplate = v
	return s
}

type CreateHumanTaskUiOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the human review workflow user interface
	// you create.
	//
	// HumanTaskUiArn is a required field
	HumanTaskUiArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHumanTaskUiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHumanTaskUiOutput) GoString() string {
	return s.String()
}

// SetHumanTaskUiArn sets the HumanTaskUiArn field's value.
func (s *CreateHumanTaskUiOutput) SetHumanTaskUiArn(v string) *CreateHumanTaskUiOutput {
	s.HumanTaskUiArn = &v
	return s
}

type CreateHyperParameterTuningJobInput struct {
	_ struct{} `type:"structure"`

	// The HyperParameterTuningJobConfig object that describes the tuning job, including
	// the search strategy, the objective metric used to evaluate training jobs,
	// ranges of parameters to search, and resource limits for the tuning job. For
	// more information, see automatic-model-tuning
	//
	// HyperParameterTuningJobConfig is a required field
	HyperParameterTuningJobConfig *HyperParameterTuningJobConfig `type:"structure" required:"true"`

	// The name of the tuning job. This name is the prefix for the names of all
	// training jobs that this tuning job launches. The name must be unique within
	// the same AWS account and AWS Region. The name must have { } to { } characters.
	// Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name
	// is not case sensitive.
	//
	// HyperParameterTuningJobName is a required field
	HyperParameterTuningJobName *string `min:"1" type:"string" required:"true"`

	// An array of key-value pairs. You can use tags to categorize your AWS resources
	// in different ways, for example, by purpose, owner, or environment. For more
	// information, see AWS Tagging Strategies (https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
	//
	// Tags that you specify for the tuning job are also added to all training jobs
	// that the tuning job launches.
	Tags []*Tag `type:"list"`

	// The HyperParameterTrainingJobDefinition object that describes the training
	// jobs that this tuning job launches, including static hyperparameters, input
	// data configuration, output data configuration, resource configuration, and
	// stopping condition.
	TrainingJobDefinition *HyperParameterTrainingJobDefinition `type:"structure"`

	TrainingJobDefinitions []*HyperParameterTrainingJobDefinition `min:"1" type:"list"`

	// Specifies the configuration for starting the hyperparameter tuning job using
	// one or more previous tuning jobs as a starting point. The results of previous
	// tuning jobs are used to inform which combinations of hyperparameters to search
	// over in the new tuning job.
	//
	// All training jobs launched by the new hyperparameter tuning job are evaluated
	// by using the objective metric. If you specify IDENTICAL_DATA_AND_ALGORITHM
	// as the WarmStartType value for the warm start configuration, the training
	// job that performs the best in the new tuning job is compared to the best
	// training jobs from the parent tuning jobs. From these, the training job that
	// performs the best as measured by the objective metric is returned as the
	// overall best training job.
	//
	// All training jobs launched by parent hyperparameter tuning jobs and the new
	// hyperparameter tuning jobs count against the limit of training jobs for the
	// tuning job.
	WarmStartConfig *HyperParameterTuningJobWarmStartConfig `type:"structure"`
}

// String returns the string representation
func (s CreateHyperParameterTuningJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHyperParameterTuningJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHyperParameterTuningJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHyperParameterTuningJobInput"}
	if s.HyperParameterTuningJobConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("HyperParameterTuningJobConfig"))
	}
	if s.HyperParameterTuningJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("HyperParameterTuningJobName"))
	}
	if s.HyperParameterTuningJobName != nil && len(*s.HyperParameterTuningJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HyperParameterTuningJobName", 1))
	}
	if s.TrainingJobDefinitions != nil && len(s.TrainingJobDefinitions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingJobDefinitions", 1))
	}
	if s.HyperParameterTuningJobConfig != nil {
		if err := s.HyperParameterTuningJobConfig.Validate(); err != nil {
			invalidParams.AddNested("HyperParameterTuningJobConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TrainingJobDefinition != nil {
		if err := s.TrainingJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TrainingJobDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.TrainingJobDefinitions != nil {
		for i, v := range s.TrainingJobDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TrainingJobDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WarmStartConfig != nil {
		if err := s.WarmStartConfig.Validate(); err != nil {
			invalidParams.AddNested("WarmStartConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHyperParameterTuningJobConfig sets the HyperParameterTuningJobConfig field's value.
func (s *CreateHyperParameterTuningJobInput) SetHyperParameterTuningJobConfig(v *HyperParameterTuningJobConfig) *CreateHyperParameterTuningJobInput {
	s.HyperParameterTuningJobConfig = v
	return s
}

// SetHyperParameterTuningJobName sets the HyperParameterTuningJobName field's value.
func (s *CreateHyperParameterTuningJobInput) SetHyperParameterTuningJobName(v string) *CreateHyperParameterTuningJobInput {
	s.HyperParameterTuningJobName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHyperParameterTuningJobInput) SetTags(v []*Tag) *CreateHyperParameterTuningJobInput {
	s.Tags = v
	return s
}

// SetTrainingJobDefinition sets the TrainingJobDefinition field's value.
func (s *CreateHyperParameterTuningJobInput) SetTrainingJobDefinition(v *HyperParameterTrainingJobDefinition) *CreateHyperParameterTuningJobInput {
	s.TrainingJobDefinition = v
	return s
}

// SetTrainingJobDefinitions sets the TrainingJobDefinitions field's value.
func (s *CreateHyperParameterTuningJobInput) SetTrainingJobDefinitions(v []*HyperParameterTrainingJobDefinition) *CreateHyperParameterTuningJobInput {
	s.TrainingJobDefinitions = v
	return s
}

// SetWarmStartConfig sets the WarmStartConfig field's value.
func (s *CreateHyperParameterTuningJobInput) SetWarmStartConfig(v *HyperParameterTuningJobWarmStartConfig) *CreateHyperParameterTuningJobInput {
	s.WarmStartConfig = v
	return s
}

type CreateHyperParameterTuningJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the tuning job. Amazon SageMaker assigns
	// an ARN to a hyperparameter tuning job when you create it.
	//
	// HyperParameterTuningJobArn is a required field
	HyperParameterTuningJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHyperParameterTuningJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHyperParameterTuningJobOutput) GoString() string {
	return s.String()
}

// SetHyperParameterTuningJobArn sets the HyperParameterTuningJobArn field's value.
func (s *CreateHyperParameterTuningJobOutput) SetHyperParameterTuningJobArn(v string) *CreateHyperParameterTuningJobOutput {
	s.HyperParameterTuningJobArn = &v
	return s
}

type CreateLabelingJobInput struct {
	_ struct{} `type:"structure"`

	// Configures the labeling task and how it is presented to workers; including,
	// but not limited to price, keywords, and batch size (task count).
	//
	// HumanTaskConfig is a required field
	HumanTaskConfig *HumanTaskConfig `type:"structure" required:"true"`

	// Input data for the labeling job, such as the Amazon S3 location of the data
	// objects and the location of the manifest file that describes the data objects.
	//
	// InputConfig is a required field
	InputConfig *LabelingJobInputConfig `type:"structure" required:"true"`

	// The attribute name to use for the label in the output manifest file. This
	// is the key for the key/value pair formed with the label that a worker assigns
	// to the object. The name can't end with "-metadata". If you are running a
	// semantic segmentation labeling job, the attribute name must end with "-ref".
	// If you are running any other kind of labeling job, the attribute name must
	// not end with "-ref".
	//
	// LabelAttributeName is a required field
	LabelAttributeName *string `min:"1" type:"string" required:"true"`

	// The S3 URL of the file that defines the categories used to label the data
	// objects.
	//
	// The file is a JSON structure in the following format:
	//
	// {
	//
	// "document-version": "2018-11-28"
	//
	// "labels": [
	//
	// {
	//
	// "label": "label 1"
	//
	// },
	//
	// {
	//
	// "label": "label 2"
	//
	// },
	//
	// ...
	//
	// {
	//
	// "label": "label n"
	//
	// }
	//
	// ]
	//
	// }
	LabelCategoryConfigS3Uri *string `type:"string"`

	// Configures the information required to perform automated data labeling.
	LabelingJobAlgorithmsConfig *LabelingJobAlgorithmsConfig `type:"structure"`

	// The name of the labeling job. This name is used to identify the job in a
	// list of labeling jobs.
	//
	// LabelingJobName is a required field
	LabelingJobName *string `min:"1" type:"string" required:"true"`

	// The location of the output data and the AWS Key Management Service key ID
	// for the key used to encrypt the output data, if any.
	//
	// OutputConfig is a required field
	OutputConfig *LabelingJobOutputConfig `type:"structure" required:"true"`

	// The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform
	// tasks on your behalf during data labeling. You must grant this role the necessary
	// permissions so that Amazon SageMaker can successfully complete data labeling.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// A set of conditions for stopping the labeling job. If any of the conditions
	// are met, the job is automatically stopped. You can use these conditions to
	// control the cost of data labeling.
	StoppingConditions *LabelingJobStoppingConditions `type:"structure"`

	// An array of key/value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateLabelingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLabelingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLabelingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLabelingJobInput"}
	if s.HumanTaskConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanTaskConfig"))
	}
	if s.InputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfig"))
	}
	if s.LabelAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelAttributeName"))
	}
	if s.LabelAttributeName != nil && len(*s.LabelAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelAttributeName", 1))
	}
	if s.LabelingJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelingJobName"))
	}
	if s.LabelingJobName != nil && len(*s.LabelingJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelingJobName", 1))
	}
	if s.OutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.HumanTaskConfig != nil {
		if err := s.HumanTaskConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanTaskConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.InputConfig != nil {
		if err := s.InputConfig.Validate(); err != nil {
			invalidParams.AddNested("InputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.LabelingJobAlgorithmsConfig != nil {
		if err := s.LabelingJobAlgorithmsConfig.Validate(); err != nil {
			invalidParams.AddNested("LabelingJobAlgorithmsConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.StoppingConditions != nil {
		if err := s.StoppingConditions.Validate(); err != nil {
			invalidParams.AddNested("StoppingConditions", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanTaskConfig sets the HumanTaskConfig field's value.
func (s *CreateLabelingJobInput) SetHumanTaskConfig(v *HumanTaskConfig) *CreateLabelingJobInput {
	s.HumanTaskConfig = v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *CreateLabelingJobInput) SetInputConfig(v *LabelingJobInputConfig) *CreateLabelingJobInput {
	s.InputConfig = v
	return s
}

// SetLabelAttributeName sets the LabelAttributeName field's value.
func (s *CreateLabelingJobInput) SetLabelAttributeName(v string) *CreateLabelingJobInput {
	s.LabelAttributeName = &v
	return s
}

// SetLabelCategoryConfigS3Uri sets the LabelCategoryConfigS3Uri field's value.
func (s *CreateLabelingJobInput) SetLabelCategoryConfigS3Uri(v string) *CreateLabelingJobInput {
	s.LabelCategoryConfigS3Uri = &v
	return s
}

// SetLabelingJobAlgorithmsConfig sets the LabelingJobAlgorithmsConfig field's value.
func (s *CreateLabelingJobInput) SetLabelingJobAlgorithmsConfig(v *LabelingJobAlgorithmsConfig) *CreateLabelingJobInput {
	s.LabelingJobAlgorithmsConfig = v
	return s
}

// SetLabelingJobName sets the LabelingJobName field's value.
func (s *CreateLabelingJobInput) SetLabelingJobName(v string) *CreateLabelingJobInput {
	s.LabelingJobName = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *CreateLabelingJobInput) SetOutputConfig(v *LabelingJobOutputConfig) *CreateLabelingJobInput {
	s.OutputConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateLabelingJobInput) SetRoleArn(v string) *CreateLabelingJobInput {
	s.RoleArn = &v
	return s
}

// SetStoppingConditions sets the StoppingConditions field's value.
func (s *CreateLabelingJobInput) SetStoppingConditions(v *LabelingJobStoppingConditions) *CreateLabelingJobInput {
	s.StoppingConditions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLabelingJobInput) SetTags(v []*Tag) *CreateLabelingJobInput {
	s.Tags = v
	return s
}

type CreateLabelingJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the labeling job. You use this ARN to identify
	// the labeling job.
	//
	// LabelingJobArn is a required field
	LabelingJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLabelingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLabelingJobOutput) GoString() string {
	return s.String()
}

// SetLabelingJobArn sets the LabelingJobArn field's value.
func (s *CreateLabelingJobOutput) SetLabelingJobArn(v string) *CreateLabelingJobOutput {
	s.LabelingJobArn = &v
	return s
}

type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// Specifies the containers in the inference pipeline.
	Containers []*ContainerDefinition `type:"list"`

	// Isolates the model container. No inbound or outbound network calls can be
	// made to or from the model container.
	EnableNetworkIsolation *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can
	// assume to access model artifacts and docker image for deployment on ML compute
	// instances or for batch transform jobs. Deploying on ML compute instances
	// is part of model hosting. For more information, see Amazon SageMaker Roles
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
	//
	// To be able to pass this role to Amazon SageMaker, the caller of this API
	// must have the iam:PassRole permission.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// The name of the new model.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// The location of the primary docker image containing inference code, associated
	// artifacts, and custom environment map that the inference code uses when the
	// model is deployed for predictions.
	PrimaryContainer *ContainerDefinition `type:"structure"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`

	// A VpcConfig (https://docs.aws.amazon.com/sagemaker/latest/dg/API_VpcConfig.html)
	// object that specifies the VPC that you want your model to connect to. Control
	// access to and from your model container by configuring the VPC. VpcConfig
	// is used in hosting services and in batch transform. For more information,
	// see Protect Endpoints by Using an Amazon Virtual Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
	// and Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private
	// Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelInput"}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.Containers != nil {
		for i, v := range s.Containers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Containers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PrimaryContainer != nil {
		if err := s.PrimaryContainer.Validate(); err != nil {
			invalidParams.AddNested("PrimaryContainer", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainers sets the Containers field's value.
func (s *CreateModelInput) SetContainers(v []*ContainerDefinition) *CreateModelInput {
	s.Containers = v
	return s
}

// SetEnableNetworkIsolation sets the EnableNetworkIsolation field's value.
func (s *CreateModelInput) SetEnableNetworkIsolation(v bool) *CreateModelInput {
	s.EnableNetworkIsolation = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateModelInput) SetExecutionRoleArn(v string) *CreateModelInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateModelInput) SetModelName(v string) *CreateModelInput {
	s.ModelName = &v
	return s
}

// SetPrimaryContainer sets the PrimaryContainer field's value.
func (s *CreateModelInput) SetPrimaryContainer(v *ContainerDefinition) *CreateModelInput {
	s.PrimaryContainer = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelInput) SetTags(v []*Tag) *CreateModelInput {
	s.Tags = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateModelInput) SetVpcConfig(v *VpcConfig) *CreateModelInput {
	s.VpcConfig = v
	return s
}

type CreateModelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the model created in Amazon SageMaker.
	//
	// ModelArn is a required field
	ModelArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelOutput) GoString() string {
	return s.String()
}

// SetModelArn sets the ModelArn field's value.
func (s *CreateModelOutput) SetModelArn(v string) *CreateModelOutput {
	s.ModelArn = &v
	return s
}

type CreateModelPackageInput struct {
	_ struct{} `type:"structure"`

	// Whether to certify the model package for listing on AWS Marketplace.
	CertifyForMarketplace *bool `type:"boolean"`

	// Specifies details about inference jobs that can be run with models based
	// on this model package, including the following:
	//
	//    * The Amazon ECR paths of containers that contain the inference code and
	//    model artifacts.
	//
	//    * The instance types that the model package supports for transform jobs
	//    and real-time endpoints used for inference.
	//
	//    * The input and output content formats that the model package supports
	//    for inference.
	InferenceSpecification *InferenceSpecification `type:"structure"`

	// A description of the model package.
	ModelPackageDescription *string `type:"string"`

	// The name of the model package. The name must have 1 to 63 characters. Valid
	// characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// ModelPackageName is a required field
	ModelPackageName *string `min:"1" type:"string" required:"true"`

	// Details about the algorithm that was used to create the model package.
	SourceAlgorithmSpecification *SourceAlgorithmSpecification `type:"structure"`

	// Specifies configurations for one or more transform jobs that Amazon SageMaker
	// runs to test the model package.
	ValidationSpecification *ModelPackageValidationSpecification `type:"structure"`
}

// String returns the string representation
func (s CreateModelPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelPackageInput"}
	if s.ModelPackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelPackageName"))
	}
	if s.ModelPackageName != nil && len(*s.ModelPackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelPackageName", 1))
	}
	if s.InferenceSpecification != nil {
		if err := s.InferenceSpecification.Validate(); err != nil {
			invalidParams.AddNested("InferenceSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceAlgorithmSpecification != nil {
		if err := s.SourceAlgorithmSpecification.Validate(); err != nil {
			invalidParams.AddNested("SourceAlgorithmSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.ValidationSpecification != nil {
		if err := s.ValidationSpecification.Validate(); err != nil {
			invalidParams.AddNested("ValidationSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertifyForMarketplace sets the CertifyForMarketplace field's value.
func (s *CreateModelPackageInput) SetCertifyForMarketplace(v bool) *CreateModelPackageInput {
	s.CertifyForMarketplace = &v
	return s
}

// SetInferenceSpecification sets the InferenceSpecification field's value.
func (s *CreateModelPackageInput) SetInferenceSpecification(v *InferenceSpecification) *CreateModelPackageInput {
	s.InferenceSpecification = v
	return s
}

// SetModelPackageDescription sets the ModelPackageDescription field's value.
func (s *CreateModelPackageInput) SetModelPackageDescription(v string) *CreateModelPackageInput {
	s.ModelPackageDescription = &v
	return s
}

// SetModelPackageName sets the ModelPackageName field's value.
func (s *CreateModelPackageInput) SetModelPackageName(v string) *CreateModelPackageInput {
	s.ModelPackageName = &v
	return s
}

// SetSourceAlgorithmSpecification sets the SourceAlgorithmSpecification field's value.
func (s *CreateModelPackageInput) SetSourceAlgorithmSpecification(v *SourceAlgorithmSpecification) *CreateModelPackageInput {
	s.SourceAlgorithmSpecification = v
	return s
}

// SetValidationSpecification sets the ValidationSpecification field's value.
func (s *CreateModelPackageInput) SetValidationSpecification(v *ModelPackageValidationSpecification) *CreateModelPackageInput {
	s.ValidationSpecification = v
	return s
}

type CreateModelPackageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new model package.
	//
	// ModelPackageArn is a required field
	ModelPackageArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateModelPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelPackageOutput) GoString() string {
	return s.String()
}

// SetModelPackageArn sets the ModelPackageArn field's value.
func (s *CreateModelPackageOutput) SetModelPackageArn(v string) *CreateModelPackageOutput {
	s.ModelPackageArn = &v
	return s
}

type CreateMonitoringScheduleInput struct {
	_ struct{} `type:"structure"`

	// The configuration object that specifies the monitoring schedule and defines
	// the monitoring job.
	//
	// MonitoringScheduleConfig is a required field
	MonitoringScheduleConfig *MonitoringScheduleConfig `type:"structure" required:"true"`

	// The name of the monitoring schedule. The name must be unique within an AWS
	// Region within an AWS account.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`

	// (Optional) An array of key-value pairs. For more information, see Using Cost
	// Allocation Tags (https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateMonitoringScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMonitoringScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMonitoringScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMonitoringScheduleInput"}
	if s.MonitoringScheduleConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitoringScheduleConfig"))
	}
	if s.MonitoringScheduleName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitoringScheduleName"))
	}
	if s.MonitoringScheduleName != nil && len(*s.MonitoringScheduleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitoringScheduleName", 1))
	}
	if s.MonitoringScheduleConfig != nil {
		if err := s.MonitoringScheduleConfig.Validate(); err != nil {
			invalidParams.AddNested("MonitoringScheduleConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitoringScheduleConfig sets the MonitoringScheduleConfig field's value.
func (s *CreateMonitoringScheduleInput) SetMonitoringScheduleConfig(v *MonitoringScheduleConfig) *CreateMonitoringScheduleInput {
	s.MonitoringScheduleConfig = v
	return s
}

// SetMonitoringScheduleName sets the MonitoringScheduleName field's value.
func (s *CreateMonitoringScheduleInput) SetMonitoringScheduleName(v string) *CreateMonitoringScheduleInput {
	s.MonitoringScheduleName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMonitoringScheduleInput) SetTags(v []*Tag) *CreateMonitoringScheduleInput {
	s.Tags = v
	return s
}

type CreateMonitoringScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	//
	// MonitoringScheduleArn is a required field
	MonitoringScheduleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMonitoringScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMonitoringScheduleOutput) GoString() string {
	return s.String()
}

// SetMonitoringScheduleArn sets the MonitoringScheduleArn field's value.
func (s *CreateMonitoringScheduleOutput) SetMonitoringScheduleArn(v string) *CreateMonitoringScheduleOutput {
	s.MonitoringScheduleArn = &v
	return s
}

type CreateNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// A list of Elastic Inference (EI) instance types to associate with this notebook
	// instance. Currently, only one instance type can be associated with a notebook
	// instance. For more information, see Using Elastic Inference in Amazon SageMaker
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
	AcceleratorTypes []*string `type:"list"`

	// An array of up to three Git repositories to associate with the notebook instance.
	// These can be either the names of Git repositories stored as resources in
	// your account, or the URL of Git repositories in AWS CodeCommit (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
	// or in any other Git repository. These repositories are cloned at the same
	// level as the default repository of your notebook instance. For more information,
	// see Associating Git Repositories with Amazon SageMaker Notebook Instances
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	AdditionalCodeRepositories []*string `type:"list"`

	// A Git repository to associate with the notebook instance as its default code
	// repository. This can be either the name of a Git repository stored as a resource
	// in your account, or the URL of a Git repository in AWS CodeCommit (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
	// or in any other Git repository. When you open a notebook instance, it opens
	// in the directory that contains this repository. For more information, see
	// Associating Git Repositories with Amazon SageMaker Notebook Instances (https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	DefaultCodeRepository *string `min:"1" type:"string"`

	// Sets whether Amazon SageMaker provides internet access to the notebook instance.
	// If you set this to Disabled this notebook instance will be able to access
	// resources only in your VPC, and will not be able to connect to Amazon SageMaker
	// training and endpoint services unless your configure a NAT Gateway in your
	// VPC.
	//
	// For more information, see Notebook Instances Are Internet-Enabled by Default
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access).
	// You can set the value of this parameter to Disabled only if you set a value
	// for the SubnetId parameter.
	DirectInternetAccess *string `type:"string" enum:"DirectInternetAccess"`

	// The type of ML compute instance to launch for the notebook instance.
	//
	// InstanceType is a required field
	InstanceType *string `type:"string" required:"true" enum:"InstanceType"`

	// The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon
	// SageMaker uses to encrypt data on the storage volume attached to your notebook
	// instance. The KMS key you provide must be enabled. For information, see Enabling
	// and Disabling Keys (https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html)
	// in the AWS Key Management Service Developer Guide.
	KmsKeyId *string `type:"string"`

	// The name of a lifecycle configuration to associate with the notebook instance.
	// For information about lifestyle configurations, see Step 2.1: (Optional)
	// Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
	LifecycleConfigName *string `type:"string"`

	// The name of the new notebook instance.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`

	// When you send any requests to AWS resources from the notebook instance, Amazon
	// SageMaker assumes this role to perform tasks on your behalf. You must grant
	// this role necessary permissions so Amazon SageMaker can perform these tasks.
	// The policy must allow the Amazon SageMaker service principal (sagemaker.amazonaws.com)
	// permissions to assume this role. For more information, see Amazon SageMaker
	// Roles (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
	//
	// To be able to pass this role to Amazon SageMaker, the caller of this API
	// must have the iam:PassRole permission.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Whether root access is enabled or disabled for users of the notebook instance.
	// The default value is Enabled.
	//
	// Lifecycle configurations need root access to be able to set up a notebook
	// instance. Because of this, lifecycle configurations associated with a notebook
	// instance always run with root access even if you disable root access for
	// users.
	RootAccess *string `type:"string" enum:"RootAccess"`

	// The VPC security group IDs, in the form sg-xxxxxxxx. The security groups
	// must be for the same VPC as specified in the subnet.
	SecurityGroupIds []*string `type:"list"`

	// The ID of the subnet in a VPC to which you would like to have a connectivity
	// from your ML compute instance.
	SubnetId *string `type:"string"`

	// A list of tags to associate with the notebook instance. You can add tags
	// later by using the CreateTags API.
	Tags []*Tag `type:"list"`

	// The size, in GB, of the ML storage volume to attach to the notebook instance.
	// The default value is 5 GB.
	VolumeSizeInGB *int64 `min:"5" type:"integer"`
}

// String returns the string representation
func (s CreateNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotebookInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNotebookInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNotebookInstanceInput"}
	if s.DefaultCodeRepository != nil && len(*s.DefaultCodeRepository) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultCodeRepository", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.VolumeSizeInGB != nil && *s.VolumeSizeInGB < 5 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSizeInGB", 5))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorTypes sets the AcceleratorTypes field's value.
func (s *CreateNotebookInstanceInput) SetAcceleratorTypes(v []*string) *CreateNotebookInstanceInput {
	s.AcceleratorTypes = v
	return s
}

// SetAdditionalCodeRepositories sets the AdditionalCodeRepositories field's value.
func (s *CreateNotebookInstanceInput) SetAdditionalCodeRepositories(v []*string) *CreateNotebookInstanceInput {
	s.AdditionalCodeRepositories = v
	return s
}

// SetDefaultCodeRepository sets the DefaultCodeRepository field's value.
func (s *CreateNotebookInstanceInput) SetDefaultCodeRepository(v string) *CreateNotebookInstanceInput {
	s.DefaultCodeRepository = &v
	return s
}

// SetDirectInternetAccess sets the DirectInternetAccess field's value.
func (s *CreateNotebookInstanceInput) SetDirectInternetAccess(v string) *CreateNotebookInstanceInput {
	s.DirectInternetAccess = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateNotebookInstanceInput) SetInstanceType(v string) *CreateNotebookInstanceInput {
	s.InstanceType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateNotebookInstanceInput) SetKmsKeyId(v string) *CreateNotebookInstanceInput {
	s.KmsKeyId = &v
	return s
}

// SetLifecycleConfigName sets the LifecycleConfigName field's value.
func (s *CreateNotebookInstanceInput) SetLifecycleConfigName(v string) *CreateNotebookInstanceInput {
	s.LifecycleConfigName = &v
	return s
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *CreateNotebookInstanceInput) SetNotebookInstanceName(v string) *CreateNotebookInstanceInput {
	s.NotebookInstanceName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateNotebookInstanceInput) SetRoleArn(v string) *CreateNotebookInstanceInput {
	s.RoleArn = &v
	return s
}

// SetRootAccess sets the RootAccess field's value.
func (s *CreateNotebookInstanceInput) SetRootAccess(v string) *CreateNotebookInstanceInput {
	s.RootAccess = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateNotebookInstanceInput) SetSecurityGroupIds(v []*string) *CreateNotebookInstanceInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateNotebookInstanceInput) SetSubnetId(v string) *CreateNotebookInstanceInput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNotebookInstanceInput) SetTags(v []*Tag) *CreateNotebookInstanceInput {
	s.Tags = v
	return s
}

// SetVolumeSizeInGB sets the VolumeSizeInGB field's value.
func (s *CreateNotebookInstanceInput) SetVolumeSizeInGB(v int64) *CreateNotebookInstanceInput {
	s.VolumeSizeInGB = &v
	return s
}

type CreateNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`

	// A shell script that runs only once, when you create a notebook instance.
	// The shell script must be a base64-encoded string.
	OnCreate []*NotebookInstanceLifecycleHook `type:"list"`

	// A shell script that runs every time you start a notebook instance, including
	// when you create the notebook instance. The shell script must be a base64-encoded
	// string.
	OnStart []*NotebookInstanceLifecycleHook `type:"list"`
}

// String returns the string representation
func (s CreateNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotebookInstanceLifecycleConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNotebookInstanceLifecycleConfigInput"}
	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}
	if s.OnCreate != nil {
		for i, v := range s.OnCreate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnCreate", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OnStart != nil {
		for i, v := range s.OnStart {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnStart", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *CreateNotebookInstanceLifecycleConfigInput) SetNotebookInstanceLifecycleConfigName(v string) *CreateNotebookInstanceLifecycleConfigInput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

// SetOnCreate sets the OnCreate field's value.
func (s *CreateNotebookInstanceLifecycleConfigInput) SetOnCreate(v []*NotebookInstanceLifecycleHook) *CreateNotebookInstanceLifecycleConfigInput {
	s.OnCreate = v
	return s
}

// SetOnStart sets the OnStart field's value.
func (s *CreateNotebookInstanceLifecycleConfigInput) SetOnStart(v []*NotebookInstanceLifecycleHook) *CreateNotebookInstanceLifecycleConfigInput {
	s.OnStart = v
	return s
}

type CreateNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	NotebookInstanceLifecycleConfigArn *string `type:"string"`
}

// String returns the string representation
func (s CreateNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotebookInstanceLifecycleConfigOutput) GoString() string {
	return s.String()
}

// SetNotebookInstanceLifecycleConfigArn sets the NotebookInstanceLifecycleConfigArn field's value.
func (s *CreateNotebookInstanceLifecycleConfigOutput) SetNotebookInstanceLifecycleConfigArn(v string) *CreateNotebookInstanceLifecycleConfigOutput {
	s.NotebookInstanceLifecycleConfigArn = &v
	return s
}

type CreateNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notebook instance.
	NotebookInstanceArn *string `type:"string"`
}

// String returns the string representation
func (s CreateNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotebookInstanceOutput) GoString() string {
	return s.String()
}

// SetNotebookInstanceArn sets the NotebookInstanceArn field's value.
func (s *CreateNotebookInstanceOutput) SetNotebookInstanceArn(v string) *CreateNotebookInstanceOutput {
	s.NotebookInstanceArn = &v
	return s
}

type CreatePresignedDomainUrlInput struct {
	_ struct{} `type:"structure"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The session expiration duration in seconds.
	SessionExpirationDurationInSeconds *int64 `min:"1800" type:"integer"`

	// The name of the UserProfile to sign-in as.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePresignedDomainUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePresignedDomainUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePresignedDomainUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePresignedDomainUrlInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.SessionExpirationDurationInSeconds != nil && *s.SessionExpirationDurationInSeconds < 1800 {
		invalidParams.Add(request.NewErrParamMinValue("SessionExpirationDurationInSeconds", 1800))
	}
	if s.UserProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *CreatePresignedDomainUrlInput) SetDomainId(v string) *CreatePresignedDomainUrlInput {
	s.DomainId = &v
	return s
}

// SetSessionExpirationDurationInSeconds sets the SessionExpirationDurationInSeconds field's value.
func (s *CreatePresignedDomainUrlInput) SetSessionExpirationDurationInSeconds(v int64) *CreatePresignedDomainUrlInput {
	s.SessionExpirationDurationInSeconds = &v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *CreatePresignedDomainUrlInput) SetUserProfileName(v string) *CreatePresignedDomainUrlInput {
	s.UserProfileName = &v
	return s
}

type CreatePresignedDomainUrlOutput struct {
	_ struct{} `type:"structure"`

	// The presigned URL.
	AuthorizedUrl *string `type:"string"`
}

// String returns the string representation
func (s CreatePresignedDomainUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePresignedDomainUrlOutput) GoString() string {
	return s.String()
}

// SetAuthorizedUrl sets the AuthorizedUrl field's value.
func (s *CreatePresignedDomainUrlOutput) SetAuthorizedUrl(v string) *CreatePresignedDomainUrlOutput {
	s.AuthorizedUrl = &v
	return s
}

type CreatePresignedNotebookInstanceUrlInput struct {
	_ struct{} `type:"structure"`

	// The name of the notebook instance.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`

	// The duration of the session, in seconds. The default is 12 hours.
	SessionExpirationDurationInSeconds *int64 `min:"1800" type:"integer"`
}

// String returns the string representation
func (s CreatePresignedNotebookInstanceUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePresignedNotebookInstanceUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePresignedNotebookInstanceUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePresignedNotebookInstanceUrlInput"}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}
	if s.SessionExpirationDurationInSeconds != nil && *s.SessionExpirationDurationInSeconds < 1800 {
		invalidParams.Add(request.NewErrParamMinValue("SessionExpirationDurationInSeconds", 1800))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *CreatePresignedNotebookInstanceUrlInput) SetNotebookInstanceName(v string) *CreatePresignedNotebookInstanceUrlInput {
	s.NotebookInstanceName = &v
	return s
}

// SetSessionExpirationDurationInSeconds sets the SessionExpirationDurationInSeconds field's value.
func (s *CreatePresignedNotebookInstanceUrlInput) SetSessionExpirationDurationInSeconds(v int64) *CreatePresignedNotebookInstanceUrlInput {
	s.SessionExpirationDurationInSeconds = &v
	return s
}

type CreatePresignedNotebookInstanceUrlOutput struct {
	_ struct{} `type:"structure"`

	// A JSON object that contains the URL string.
	AuthorizedUrl *string `type:"string"`
}

// String returns the string representation
func (s CreatePresignedNotebookInstanceUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePresignedNotebookInstanceUrlOutput) GoString() string {
	return s.String()
}

// SetAuthorizedUrl sets the AuthorizedUrl field's value.
func (s *CreatePresignedNotebookInstanceUrlOutput) SetAuthorizedUrl(v string) *CreatePresignedNotebookInstanceUrlOutput {
	s.AuthorizedUrl = &v
	return s
}

type CreateProcessingJobInput struct {
	_ struct{} `type:"structure"`

	// Configures the processing job to run a specified Docker container image.
	//
	// AppSpecification is a required field
	AppSpecification *AppSpecification `type:"structure" required:"true"`

	// Sets the environment variables in the Docker container.
	Environment map[string]*string `type:"map"`

	// Configuration for the experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// Networking options for a processing job.
	NetworkConfig *NetworkConfig `type:"structure"`

	// For each input, data is downloaded from S3 into the processing container
	// before the processing job begins running if "S3InputMode" is set to File.
	ProcessingInputs []*ProcessingInput `type:"list"`

	// The name of the processing job. The name must be unique within an AWS Region
	// in the AWS account.
	//
	// ProcessingJobName is a required field
	ProcessingJobName *string `min:"1" type:"string" required:"true"`

	// Output configuration for the processing job.
	ProcessingOutputConfig *ProcessingOutputConfig `type:"structure"`

	// Identifies the resources, ML compute instances, and ML storage volumes to
	// deploy for a processing job. In distributed training, you specify more than
	// one instance.
	//
	// ProcessingResources is a required field
	ProcessingResources *ProcessingResources `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume
	// to perform tasks on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The time limit for how long the processing job is allowed to run.
	StoppingCondition *ProcessingStoppingCondition `type:"structure"`

	// (Optional) An array of key-value pairs. For more information, see Using Cost
	// Allocation Tags (https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateProcessingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProcessingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProcessingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProcessingJobInput"}
	if s.AppSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("AppSpecification"))
	}
	if s.ProcessingJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProcessingJobName"))
	}
	if s.ProcessingJobName != nil && len(*s.ProcessingJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProcessingJobName", 1))
	}
	if s.ProcessingResources == nil {
		invalidParams.Add(request.NewErrParamRequired("ProcessingResources"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.AppSpecification != nil {
		if err := s.AppSpecification.Validate(); err != nil {
			invalidParams.AddNested("AppSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.ExperimentConfig != nil {
		if err := s.ExperimentConfig.Validate(); err != nil {
			invalidParams.AddNested("ExperimentConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.NetworkConfig != nil {
		if err := s.NetworkConfig.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingInputs != nil {
		for i, v := range s.ProcessingInputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProcessingInputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProcessingOutputConfig != nil {
		if err := s.ProcessingOutputConfig.Validate(); err != nil {
			invalidParams.AddNested("ProcessingOutputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingResources != nil {
		if err := s.ProcessingResources.Validate(); err != nil {
			invalidParams.AddNested("ProcessingResources", err.(request.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppSpecification sets the AppSpecification field's value.
func (s *CreateProcessingJobInput) SetAppSpecification(v *AppSpecification) *CreateProcessingJobInput {
	s.AppSpecification = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateProcessingJobInput) SetEnvironment(v map[string]*string) *CreateProcessingJobInput {
	s.Environment = v
	return s
}

// SetExperimentConfig sets the ExperimentConfig field's value.
func (s *CreateProcessingJobInput) SetExperimentConfig(v *ExperimentConfig) *CreateProcessingJobInput {
	s.ExperimentConfig = v
	return s
}

// SetNetworkConfig sets the NetworkConfig field's value.
func (s *CreateProcessingJobInput) SetNetworkConfig(v *NetworkConfig) *CreateProcessingJobInput {
	s.NetworkConfig = v
	return s
}

// SetProcessingInputs sets the ProcessingInputs field's value.
func (s *CreateProcessingJobInput) SetProcessingInputs(v []*ProcessingInput) *CreateProcessingJobInput {
	s.ProcessingInputs = v
	return s
}

// SetProcessingJobName sets the ProcessingJobName field's value.
func (s *CreateProcessingJobInput) SetProcessingJobName(v string) *CreateProcessingJobInput {
	s.ProcessingJobName = &v
	return s
}

// SetProcessingOutputConfig sets the ProcessingOutputConfig field's value.
func (s *CreateProcessingJobInput) SetProcessingOutputConfig(v *ProcessingOutputConfig) *CreateProcessingJobInput {
	s.ProcessingOutputConfig = v
	return s
}

// SetProcessingResources sets the ProcessingResources field's value.
func (s *CreateProcessingJobInput) SetProcessingResources(v *ProcessingResources) *CreateProcessingJobInput {
	s.ProcessingResources = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateProcessingJobInput) SetRoleArn(v string) *CreateProcessingJobInput {
	s.RoleArn = &v
	return s
}

// SetStoppingCondition sets the StoppingCondition field's value.
func (s *CreateProcessingJobInput) SetStoppingCondition(v *ProcessingStoppingCondition) *CreateProcessingJobInput {
	s.StoppingCondition = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProcessingJobInput) SetTags(v []*Tag) *CreateProcessingJobInput {
	s.Tags = v
	return s
}

type CreateProcessingJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the processing job.
	//
	// ProcessingJobArn is a required field
	ProcessingJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProcessingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProcessingJobOutput) GoString() string {
	return s.String()
}

// SetProcessingJobArn sets the ProcessingJobArn field's value.
func (s *CreateProcessingJobOutput) SetProcessingJobArn(v string) *CreateProcessingJobOutput {
	s.ProcessingJobArn = &v
	return s
}

type CreateTrainingJobInput struct {
	_ struct{} `type:"structure"`

	// The registry path of the Docker image that contains the training algorithm
	// and algorithm-specific metadata, including the input mode. For more information
	// about algorithms provided by Amazon SageMaker, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	// For information about providing your own algorithms, see Using Your Own Algorithms
	// with Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	//
	// AlgorithmSpecification is a required field
	AlgorithmSpecification *AlgorithmSpecification `type:"structure" required:"true"`

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig `type:"structure"`

	// Configuration information for the debug hook parameters, collection configuration,
	// and storage paths.
	DebugHookConfig *DebugHookConfig `type:"structure"`

	// Configuration information for debugging rules.
	DebugRuleConfigurations []*DebugRuleConfiguration `type:"list"`

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use
	// a deep learning algorithm in distributed training. For more information,
	// see Protect Communications Between ML Compute Instances in a Distributed
	// Training Job (https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html).
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// To train models using managed spot training, choose True. Managed spot training
	// provides a fully managed and scalable infrastructure for training machine
	// learning models. this option is useful when training jobs can be interrupted
	// and when there is flexibility when the training job is run.
	//
	// The complete and intermediate results of jobs are stored in an Amazon S3
	// bucket, and can be used as a starting point to train models incrementally.
	// Amazon SageMaker provides metrics and logs in CloudWatch. They can be used
	// to see when managed spot training jobs are running, interrupted, resumed,
	// or completed.
	EnableManagedSpotTraining *bool `type:"boolean"`

	// Isolates the training container. No inbound or outbound network calls can
	// be made, except for calls between peers within a training cluster for distributed
	// training. If you enable network isolation for training jobs that are configured
	// to use a VPC, Amazon SageMaker downloads and uploads customer data and model
	// artifacts through the specified VPC, but the training container does not
	// have network access.
	EnableNetworkIsolation *bool `type:"boolean"`

	// Configuration for the experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// Algorithm-specific parameters that influence the quality of the model. You
	// set hyperparameters before you start the learning process. For a list of
	// hyperparameters for each training algorithm provided by Amazon SageMaker,
	// see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	//
	// You can specify a maximum of 100 hyperparameters. Each hyperparameter is
	// a key-value pair. Each key and value is limited to 256 characters, as specified
	// by the Length Constraint.
	HyperParameters map[string]*string `type:"map"`

	// An array of Channel objects. Each channel is a named input source. InputDataConfig
	// describes the input data and its location.
	//
	// Algorithms can accept input data from one or more channels. For example,
	// an algorithm might have two channels of input data, training_data and validation_data.
	// The configuration for each channel provides the S3, EFS, or FSx location
	// where the input data is stored. It also provides information about the stored
	// data: the MIME type, compression method, and whether the data is wrapped
	// in RecordIO format.
	//
	// Depending on the input mode that the algorithm supports, Amazon SageMaker
	// either copies input data files from an S3 bucket to a local directory in
	// the Docker container, or makes it available as input streams. For example,
	// if you specify an EFS location, input data files will be made available as
	// input streams. They do not need to be downloaded.
	InputDataConfig []*Channel `min:"1" type:"list"`

	// Specifies the path to the S3 location where you want to store model artifacts.
	// Amazon SageMaker creates subfolders for the artifacts.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The resources, including the ML compute instances and ML storage volumes,
	// to use for model training.
	//
	// ML storage volumes store model artifacts and incremental states. Training
	// algorithms might also use ML storage volumes for scratch space. If you want
	// Amazon SageMaker to use the ML storage volume to store the training data,
	// choose File as the TrainingInputMode in the algorithm specification. For
	// distributed training algorithms, specify an instance count greater than 1.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume
	// to perform tasks on your behalf.
	//
	// During model training, Amazon SageMaker needs your permission to read input
	// data from an S3 bucket, download a Docker image that contains training code,
	// write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs,
	// and publish metrics to Amazon CloudWatch. You grant permissions for all of
	// these tasks to an IAM role. For more information, see Amazon SageMaker Roles
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
	//
	// To be able to pass this role to Amazon SageMaker, the caller of this API
	// must have the iam:PassRole permission.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies a limit to how long a model training job can run. When the job
	// reaches the time limit, Amazon SageMaker ends the training job. Use this
	// API to cap model training costs.
	//
	// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts, so the results of training are not lost.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`

	// Configuration of storage locations for TensorBoard output.
	TensorBoardOutputConfig *TensorBoardOutputConfig `type:"structure"`

	// The name of the training job. The name must be unique within an AWS Region
	// in an AWS account.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// A VpcConfig object that specifies the VPC that you want your training job
	// to connect to. Control access to and from your training container by configuring
	// the VPC. For more information, see Protect Training Jobs by Using an Amazon
	// Virtual Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrainingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrainingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrainingJobInput"}
	if s.AlgorithmSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("AlgorithmSpecification"))
	}
	if s.InputDataConfig != nil && len(s.InputDataConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDataConfig", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.ResourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StoppingCondition == nil {
		invalidParams.Add(request.NewErrParamRequired("StoppingCondition"))
	}
	if s.TrainingJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingJobName"))
	}
	if s.TrainingJobName != nil && len(*s.TrainingJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingJobName", 1))
	}
	if s.AlgorithmSpecification != nil {
		if err := s.AlgorithmSpecification.Validate(); err != nil {
			invalidParams.AddNested("AlgorithmSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.CheckpointConfig != nil {
		if err := s.CheckpointConfig.Validate(); err != nil {
			invalidParams.AddNested("CheckpointConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.DebugHookConfig != nil {
		if err := s.DebugHookConfig.Validate(); err != nil {
			invalidParams.AddNested("DebugHookConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.DebugRuleConfigurations != nil {
		for i, v := range s.DebugRuleConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DebugRuleConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ExperimentConfig != nil {
		if err := s.ExperimentConfig.Validate(); err != nil {
			invalidParams.AddNested("ExperimentConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.InputDataConfig != nil {
		for i, v := range s.InputDataConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputDataConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TensorBoardOutputConfig != nil {
		if err := s.TensorBoardOutputConfig.Validate(); err != nil {
			invalidParams.AddNested("TensorBoardOutputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmSpecification sets the AlgorithmSpecification field's value.
func (s *CreateTrainingJobInput) SetAlgorithmSpecification(v *AlgorithmSpecification) *CreateTrainingJobInput {
	s.AlgorithmSpecification = v
	return s
}

// SetCheckpointConfig sets the CheckpointConfig field's value.
func (s *CreateTrainingJobInput) SetCheckpointConfig(v *CheckpointConfig) *CreateTrainingJobInput {
	s.CheckpointConfig = v
	return s
}

// SetDebugHookConfig sets the DebugHookConfig field's value.
func (s *CreateTrainingJobInput) SetDebugHookConfig(v *DebugHookConfig) *CreateTrainingJobInput {
	s.DebugHookConfig = v
	return s
}

// SetDebugRuleConfigurations sets the DebugRuleConfigurations field's value.
func (s *CreateTrainingJobInput) SetDebugRuleConfigurations(v []*DebugRuleConfiguration) *CreateTrainingJobInput {
	s.DebugRuleConfigurations = v
	return s
}

// SetEnableInterContainerTrafficEncryption sets the EnableInterContainerTrafficEncryption field's value.
func (s *CreateTrainingJobInput) SetEnableInterContainerTrafficEncryption(v bool) *CreateTrainingJobInput {
	s.EnableInterContainerTrafficEncryption = &v
	return s
}

// SetEnableManagedSpotTraining sets the EnableManagedSpotTraining field's value.
func (s *CreateTrainingJobInput) SetEnableManagedSpotTraining(v bool) *CreateTrainingJobInput {
	s.EnableManagedSpotTraining = &v
	return s
}

// SetEnableNetworkIsolation sets the EnableNetworkIsolation field's value.
func (s *CreateTrainingJobInput) SetEnableNetworkIsolation(v bool) *CreateTrainingJobInput {
	s.EnableNetworkIsolation = &v
	return s
}

// SetExperimentConfig sets the ExperimentConfig field's value.
func (s *CreateTrainingJobInput) SetExperimentConfig(v *ExperimentConfig) *CreateTrainingJobInput {
	s.ExperimentConfig = v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *CreateTrainingJobInput) SetHyperParameters(v map[string]*string) *CreateTrainingJobInput {
	s.HyperParameters = v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateTrainingJobInput) SetInputDataConfig(v []*Channel) *CreateTrainingJobInput {
	s.InputDataConfig = v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *CreateTrainingJobInput) SetOutputDataConfig(v *OutputDataConfig) *CreateTrainingJobInput {
	s.OutputDataConfig = v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *CreateTrainingJobInput) SetResourceConfig(v *ResourceConfig) *CreateTrainingJobInput {
	s.ResourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateTrainingJobInput) SetRoleArn(v string) *CreateTrainingJobInput {
	s.RoleArn = &v
	return s
}

// SetStoppingCondition sets the StoppingCondition field's value.
func (s *CreateTrainingJobInput) SetStoppingCondition(v *StoppingCondition) *CreateTrainingJobInput {
	s.StoppingCondition = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrainingJobInput) SetTags(v []*Tag) *CreateTrainingJobInput {
	s.Tags = v
	return s
}

// SetTensorBoardOutputConfig sets the TensorBoardOutputConfig field's value.
func (s *CreateTrainingJobInput) SetTensorBoardOutputConfig(v *TensorBoardOutputConfig) *CreateTrainingJobInput {
	s.TensorBoardOutputConfig = v
	return s
}

// SetTrainingJobName sets the TrainingJobName field's value.
func (s *CreateTrainingJobInput) SetTrainingJobName(v string) *CreateTrainingJobInput {
	s.TrainingJobName = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateTrainingJobInput) SetVpcConfig(v *VpcConfig) *CreateTrainingJobInput {
	s.VpcConfig = v
	return s
}

type CreateTrainingJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrainingJobOutput) GoString() string {
	return s.String()
}

// SetTrainingJobArn sets the TrainingJobArn field's value.
func (s *CreateTrainingJobOutput) SetTrainingJobArn(v string) *CreateTrainingJobOutput {
	s.TrainingJobArn = &v
	return s
}

type CreateTransformJobInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of records to include in a mini-batch for an HTTP inference
	// request. A record is a single unit of input data that inference can be made
	// on. For example, a single line in a CSV file is a record.
	//
	// To enable the batch strategy, you must set the SplitType property of the
	// DataProcessing object to Line, RecordIO, or TFRecord.
	//
	// To use only one record when making an HTTP invocation request to a container,
	// set BatchStrategy to SingleRecord and SplitType to Line.
	//
	// To fit as many records in a mini-batch as can fit within the MaxPayloadInMB
	// limit, set BatchStrategy to MultiRecord and SplitType to Line.
	BatchStrategy *string `type:"string" enum:"BatchStrategy"`

	// The data structure used to specify the data to be used for inference in a
	// batch transform job and to associate the data that is relevant to the prediction
	// results in the output. The input filter provided allows you to exclude input
	// data that is not needed for inference in a batch transform job. The output
	// filter provided allows you to include input data relevant to interpreting
	// the predictions in the output from the job. For more information, see Associate
	// Prediction Results with their Corresponding Input Records (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
	DataProcessing *DataProcessing `type:"structure"`

	// The environment variables to set in the Docker container. We support up to
	// 16 key and values entries in the map.
	Environment map[string]*string `type:"map"`

	// Configuration for the experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// The maximum number of parallel requests that can be sent to each instance
	// in a transform job. If MaxConcurrentTransforms is set to 0 or left unset,
	// Amazon SageMaker checks the optional execution-parameters to determine the
	// settings for your chosen algorithm. If the execution-parameters endpoint
	// is not enabled, the default value is 1. For more information on execution-parameters,
	// see How Containers Serve Requests (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests).
	// For built-in algorithms, you don't need to set a value for MaxConcurrentTransforms.
	MaxConcurrentTransforms *int64 `type:"integer"`

	// The maximum allowed size of the payload, in MB. A payload is the data portion
	// of a record (without metadata). The value in MaxPayloadInMB must be greater
	// than, or equal to, the size of a single record. To estimate the size of a
	// record in MB, divide the size of your dataset by the number of records. To
	// ensure that the records fit within the maximum payload size, we recommend
	// using a slightly larger value. The default value is 6 MB.
	//
	// For cases where the payload might be arbitrarily large and is transmitted
	// using HTTP chunked encoding, set the value to 0. This feature works only
	// in supported algorithms. Currently, Amazon SageMaker built-in algorithms
	// do not support HTTP chunked encoding.
	MaxPayloadInMB *int64 `type:"integer"`

	// The name of the model that you want to use for the transform job. ModelName
	// must be the name of an existing Amazon SageMaker model within an AWS Region
	// in an AWS account.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// (Optional) An array of key-value pairs. For more information, see Using Cost
	// Allocation Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`

	// Describes the input source and the way the transform job consumes it.
	//
	// TransformInput is a required field
	TransformInput *TransformInput `type:"structure" required:"true"`

	// The name of the transform job. The name must be unique within an AWS Region
	// in an AWS account.
	//
	// TransformJobName is a required field
	TransformJobName *string `min:"1" type:"string" required:"true"`

	// Describes the results of the transform job.
	//
	// TransformOutput is a required field
	TransformOutput *TransformOutput `type:"structure" required:"true"`

	// Describes the resources, including ML instance types and ML instance count,
	// to use for the transform job.
	//
	// TransformResources is a required field
	TransformResources *TransformResources `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTransformJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTransformJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTransformJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTransformJobInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.TransformInput == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformInput"))
	}
	if s.TransformJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformJobName"))
	}
	if s.TransformJobName != nil && len(*s.TransformJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransformJobName", 1))
	}
	if s.TransformOutput == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformOutput"))
	}
	if s.TransformResources == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformResources"))
	}
	if s.ExperimentConfig != nil {
		if err := s.ExperimentConfig.Validate(); err != nil {
			invalidParams.AddNested("ExperimentConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TransformInput != nil {
		if err := s.TransformInput.Validate(); err != nil {
			invalidParams.AddNested("TransformInput", err.(request.ErrInvalidParams))
		}
	}
	if s.TransformOutput != nil {
		if err := s.TransformOutput.Validate(); err != nil {
			invalidParams.AddNested("TransformOutput", err.(request.ErrInvalidParams))
		}
	}
	if s.TransformResources != nil {
		if err := s.TransformResources.Validate(); err != nil {
			invalidParams.AddNested("TransformResources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchStrategy sets the BatchStrategy field's value.
func (s *CreateTransformJobInput) SetBatchStrategy(v string) *CreateTransformJobInput {
	s.BatchStrategy = &v
	return s
}

// SetDataProcessing sets the DataProcessing field's value.
func (s *CreateTransformJobInput) SetDataProcessing(v *DataProcessing) *CreateTransformJobInput {
	s.DataProcessing = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateTransformJobInput) SetEnvironment(v map[string]*string) *CreateTransformJobInput {
	s.Environment = v
	return s
}

// SetExperimentConfig sets the ExperimentConfig field's value.
func (s *CreateTransformJobInput) SetExperimentConfig(v *ExperimentConfig) *CreateTransformJobInput {
	s.ExperimentConfig = v
	return s
}

// SetMaxConcurrentTransforms sets the MaxConcurrentTransforms field's value.
func (s *CreateTransformJobInput) SetMaxConcurrentTransforms(v int64) *CreateTransformJobInput {
	s.MaxConcurrentTransforms = &v
	return s
}

// SetMaxPayloadInMB sets the MaxPayloadInMB field's value.
func (s *CreateTransformJobInput) SetMaxPayloadInMB(v int64) *CreateTransformJobInput {
	s.MaxPayloadInMB = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateTransformJobInput) SetModelName(v string) *CreateTransformJobInput {
	s.ModelName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTransformJobInput) SetTags(v []*Tag) *CreateTransformJobInput {
	s.Tags = v
	return s
}

// SetTransformInput sets the TransformInput field's value.
func (s *CreateTransformJobInput) SetTransformInput(v *TransformInput) *CreateTransformJobInput {
	s.TransformInput = v
	return s
}

// SetTransformJobName sets the TransformJobName field's value.
func (s *CreateTransformJobInput) SetTransformJobName(v string) *CreateTransformJobInput {
	s.TransformJobName = &v
	return s
}

// SetTransformOutput sets the TransformOutput field's value.
func (s *CreateTransformJobInput) SetTransformOutput(v *TransformOutput) *CreateTransformJobInput {
	s.TransformOutput = v
	return s
}

// SetTransformResources sets the TransformResources field's value.
func (s *CreateTransformJobInput) SetTransformResources(v *TransformResources) *CreateTransformJobInput {
	s.TransformResources = v
	return s
}

type CreateTransformJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the transform job.
	//
	// TransformJobArn is a required field
	TransformJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTransformJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTransformJobOutput) GoString() string {
	return s.String()
}

// SetTransformJobArn sets the TransformJobArn field's value.
func (s *CreateTransformJobOutput) SetTransformJobArn(v string) *CreateTransformJobOutput {
	s.TransformJobArn = &v
	return s
}

type CreateTrialComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component as displayed. The name doesn't need to be unique.
	// If DisplayName isn't specified, TrialComponentName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// When the component ended.
	EndTime *time.Time `type:"timestamp"`

	// The input artifacts for the component. Examples of input artifacts are datasets,
	// algorithms, hyperparameters, source code, and instance types.
	InputArtifacts map[string]*TrialComponentArtifact `type:"map"`

	// The output artifacts for the component. Examples of output artifacts are
	// metrics, snapshots, logs, and images.
	OutputArtifacts map[string]*TrialComponentArtifact `type:"map"`

	// The hyperparameters for the component.
	Parameters map[string]*TrialComponentParameterValue `type:"map"`

	// When the component started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the component. States include:
	//
	//    * InProgress
	//
	//    * Completed
	//
	//    * Failed
	Status *TrialComponentStatus `type:"structure"`

	// A list of tags to associate with the component. You can use Search API to
	// search on the tags.
	Tags []*Tag `type:"list"`

	// The name of the component. The name must be unique in your AWS account and
	// is not case-sensitive.
	//
	// TrialComponentName is a required field
	TrialComponentName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrialComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrialComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrialComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrialComponentInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.TrialComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialComponentName"))
	}
	if s.TrialComponentName != nil && len(*s.TrialComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialComponentName", 1))
	}
	if s.InputArtifacts != nil {
		for i, v := range s.InputArtifacts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputArtifacts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputArtifacts != nil {
		for i, v := range s.OutputArtifacts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputArtifacts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateTrialComponentInput) SetDisplayName(v string) *CreateTrialComponentInput {
	s.DisplayName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CreateTrialComponentInput) SetEndTime(v time.Time) *CreateTrialComponentInput {
	s.EndTime = &v
	return s
}

// SetInputArtifacts sets the InputArtifacts field's value.
func (s *CreateTrialComponentInput) SetInputArtifacts(v map[string]*TrialComponentArtifact) *CreateTrialComponentInput {
	s.InputArtifacts = v
	return s
}

// SetOutputArtifacts sets the OutputArtifacts field's value.
func (s *CreateTrialComponentInput) SetOutputArtifacts(v map[string]*TrialComponentArtifact) *CreateTrialComponentInput {
	s.OutputArtifacts = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateTrialComponentInput) SetParameters(v map[string]*TrialComponentParameterValue) *CreateTrialComponentInput {
	s.Parameters = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateTrialComponentInput) SetStartTime(v time.Time) *CreateTrialComponentInput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTrialComponentInput) SetStatus(v *TrialComponentStatus) *CreateTrialComponentInput {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrialComponentInput) SetTags(v []*Tag) *CreateTrialComponentInput {
	s.Tags = v
	return s
}

// SetTrialComponentName sets the TrialComponentName field's value.
func (s *CreateTrialComponentInput) SetTrialComponentName(v string) *CreateTrialComponentInput {
	s.TrialComponentName = &v
	return s
}

type CreateTrialComponentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string `type:"string"`
}

// String returns the string representation
func (s CreateTrialComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrialComponentOutput) GoString() string {
	return s.String()
}

// SetTrialComponentArn sets the TrialComponentArn field's value.
func (s *CreateTrialComponentOutput) SetTrialComponentArn(v string) *CreateTrialComponentOutput {
	s.TrialComponentArn = &v
	return s
}

type CreateTrialInput struct {
	_ struct{} `type:"structure"`

	// The name of the trial as displayed. The name doesn't need to be unique. If
	// DisplayName isn't specified, TrialName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The name of the experiment to associate the trial with.
	//
	// ExperimentName is a required field
	ExperimentName *string `min:"1" type:"string" required:"true"`

	// A list of tags to associate with the trial. You can use Search API to search
	// on the tags.
	Tags []*Tag `type:"list"`

	// The name of the trial. The name must be unique in your AWS account and is
	// not case-sensitive.
	//
	// TrialName is a required field
	TrialName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrialInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.ExperimentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentName"))
	}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentName", 1))
	}
	if s.TrialName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialName"))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateTrialInput) SetDisplayName(v string) *CreateTrialInput {
	s.DisplayName = &v
	return s
}

// SetExperimentName sets the ExperimentName field's value.
func (s *CreateTrialInput) SetExperimentName(v string) *CreateTrialInput {
	s.ExperimentName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrialInput) SetTags(v []*Tag) *CreateTrialInput {
	s.Tags = v
	return s
}

// SetTrialName sets the TrialName field's value.
func (s *CreateTrialInput) SetTrialName(v string) *CreateTrialInput {
	s.TrialName = &v
	return s
}

type CreateTrialOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string `type:"string"`
}

// String returns the string representation
func (s CreateTrialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrialOutput) GoString() string {
	return s.String()
}

// SetTrialArn sets the TrialArn field's value.
func (s *CreateTrialOutput) SetTrialArn(v string) *CreateTrialOutput {
	s.TrialArn = &v
	return s
}

type CreateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The ID of the associated Domain.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// A specifier for the type of value specified in SingleSignOnUserValue. Currently,
	// the only supported value is "UserName". If the Domain's AuthMode is SSO,
	// this field is required. If the Domain's AuthMode is not SSO, this field cannot
	// be specified.
	SingleSignOnUserIdentifier *string `type:"string"`

	// The username of the associated AWS Single Sign-On User for this UserProfile.
	// If the Domain's AuthMode is SSO, this field is required, and must match a
	// valid username of a user in your directory. If the Domain's AuthMode is not
	// SSO, this field cannot be specified.
	SingleSignOnUserValue *string `type:"string"`

	// Each tag consists of a key and an optional value. Tag keys must be unique
	// per resource.
	Tags []*Tag `type:"list"`

	// A name for the UserProfile.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`

	// A collection of settings.
	UserSettings *UserSettings `type:"structure"`
}

// String returns the string representation
func (s CreateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserProfileInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.UserProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserProfileName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserSettings != nil {
		if err := s.UserSettings.Validate(); err != nil {
			invalidParams.AddNested("UserSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *CreateUserProfileInput) SetDomainId(v string) *CreateUserProfileInput {
	s.DomainId = &v
	return s
}

// SetSingleSignOnUserIdentifier sets the SingleSignOnUserIdentifier field's value.
func (s *CreateUserProfileInput) SetSingleSignOnUserIdentifier(v string) *CreateUserProfileInput {
	s.SingleSignOnUserIdentifier = &v
	return s
}

// SetSingleSignOnUserValue sets the SingleSignOnUserValue field's value.
func (s *CreateUserProfileInput) SetSingleSignOnUserValue(v string) *CreateUserProfileInput {
	s.SingleSignOnUserValue = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserProfileInput) SetTags(v []*Tag) *CreateUserProfileInput {
	s.Tags = v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *CreateUserProfileInput) SetUserProfileName(v string) *CreateUserProfileInput {
	s.UserProfileName = &v
	return s
}

// SetUserSettings sets the UserSettings field's value.
func (s *CreateUserProfileInput) SetUserSettings(v *UserSettings) *CreateUserProfileInput {
	s.UserSettings = v
	return s
}

type CreateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The user profile Amazon Resource Name (ARN).
	UserProfileArn *string `type:"string"`
}

// String returns the string representation
func (s CreateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileOutput) GoString() string {
	return s.String()
}

// SetUserProfileArn sets the UserProfileArn field's value.
func (s *CreateUserProfileOutput) SetUserProfileArn(v string) *CreateUserProfileOutput {
	s.UserProfileArn = &v
	return s
}

type CreateWorkteamInput struct {
	_ struct{} `type:"structure"`

	// A description of the work team.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// A list of MemberDefinition objects that contains objects that identify the
	// Amazon Cognito user pool that makes up the work team. For more information,
	// see Amazon Cognito User Pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
	//
	// All of the CognitoMemberDefinition objects that make up the member definition
	// must have the same ClientId and UserPool values.
	//
	// MemberDefinitions is a required field
	MemberDefinitions []*MemberDefinition `min:"1" type:"list" required:"true"`

	// Configures notification of workers regarding available or expiring work items.
	NotificationConfiguration *NotificationConfiguration `type:"structure"`

	// An array of key-value pairs.
	//
	// For more information, see Resource Tag (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html)
	// and Using Cost Allocation Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`

	// The name of the work team. Use this name to identify the work team.
	//
	// WorkteamName is a required field
	WorkteamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateWorkteamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkteamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkteamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkteamInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.MemberDefinitions == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberDefinitions"))
	}
	if s.MemberDefinitions != nil && len(s.MemberDefinitions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberDefinitions", 1))
	}
	if s.WorkteamName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkteamName"))
	}
	if s.WorkteamName != nil && len(*s.WorkteamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkteamName", 1))
	}
	if s.MemberDefinitions != nil {
		for i, v := range s.MemberDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MemberDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateWorkteamInput) SetDescription(v string) *CreateWorkteamInput {
	s.Description = &v
	return s
}

// SetMemberDefinitions sets the MemberDefinitions field's value.
func (s *CreateWorkteamInput) SetMemberDefinitions(v []*MemberDefinition) *CreateWorkteamInput {
	s.MemberDefinitions = v
	return s
}

// SetNotificationConfiguration sets the NotificationConfiguration field's value.
func (s *CreateWorkteamInput) SetNotificationConfiguration(v *NotificationConfiguration) *CreateWorkteamInput {
	s.NotificationConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkteamInput) SetTags(v []*Tag) *CreateWorkteamInput {
	s.Tags = v
	return s
}

// SetWorkteamName sets the WorkteamName field's value.
func (s *CreateWorkteamInput) SetWorkteamName(v string) *CreateWorkteamInput {
	s.WorkteamName = &v
	return s
}

type CreateWorkteamOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the work team. You can use this ARN to
	// identify the work team.
	WorkteamArn *string `type:"string"`
}

// String returns the string representation
func (s CreateWorkteamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkteamOutput) GoString() string {
	return s.String()
}

// SetWorkteamArn sets the WorkteamArn field's value.
func (s *CreateWorkteamOutput) SetWorkteamArn(v string) *CreateWorkteamOutput {
	s.WorkteamArn = &v
	return s
}

type DataCaptureConfig struct {
	_ struct{} `type:"structure"`

	CaptureContentTypeHeader *CaptureContentTypeHeader `type:"structure"`

	// CaptureOptions is a required field
	CaptureOptions []*CaptureOption `min:"1" type:"list" required:"true"`

	// DestinationS3Uri is a required field
	DestinationS3Uri *string `type:"string" required:"true"`

	EnableCapture *bool `type:"boolean"`

	// InitialSamplingPercentage is a required field
	InitialSamplingPercentage *int64 `type:"integer" required:"true"`

	KmsKeyId *string `type:"string"`
}

// String returns the string representation
func (s DataCaptureConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataCaptureConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataCaptureConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataCaptureConfig"}
	if s.CaptureOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptureOptions"))
	}
	if s.CaptureOptions != nil && len(s.CaptureOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CaptureOptions", 1))
	}
	if s.DestinationS3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationS3Uri"))
	}
	if s.InitialSamplingPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialSamplingPercentage"))
	}
	if s.CaptureContentTypeHeader != nil {
		if err := s.CaptureContentTypeHeader.Validate(); err != nil {
			invalidParams.AddNested("CaptureContentTypeHeader", err.(request.ErrInvalidParams))
		}
	}
	if s.CaptureOptions != nil {
		for i, v := range s.CaptureOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptureOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptureContentTypeHeader sets the CaptureContentTypeHeader field's value.
func (s *DataCaptureConfig) SetCaptureContentTypeHeader(v *CaptureContentTypeHeader) *DataCaptureConfig {
	s.CaptureContentTypeHeader = v
	return s
}

// SetCaptureOptions sets the CaptureOptions field's value.
func (s *DataCaptureConfig) SetCaptureOptions(v []*CaptureOption) *DataCaptureConfig {
	s.CaptureOptions = v
	return s
}

// SetDestinationS3Uri sets the DestinationS3Uri field's value.
func (s *DataCaptureConfig) SetDestinationS3Uri(v string) *DataCaptureConfig {
	s.DestinationS3Uri = &v
	return s
}

// SetEnableCapture sets the EnableCapture field's value.
func (s *DataCaptureConfig) SetEnableCapture(v bool) *DataCaptureConfig {
	s.EnableCapture = &v
	return s
}

// SetInitialSamplingPercentage sets the InitialSamplingPercentage field's value.
func (s *DataCaptureConfig) SetInitialSamplingPercentage(v int64) *DataCaptureConfig {
	s.InitialSamplingPercentage = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DataCaptureConfig) SetKmsKeyId(v string) *DataCaptureConfig {
	s.KmsKeyId = &v
	return s
}

type DataCaptureConfigSummary struct {
	_ struct{} `type:"structure"`

	// CaptureStatus is a required field
	CaptureStatus *string `type:"string" required:"true" enum:"CaptureStatus"`

	// CurrentSamplingPercentage is a required field
	CurrentSamplingPercentage *int64 `type:"integer" required:"true"`

	// DestinationS3Uri is a required field
	DestinationS3Uri *string `type:"string" required:"true"`

	// EnableCapture is a required field
	EnableCapture *bool `type:"boolean" required:"true"`

	// KmsKeyId is a required field
	KmsKeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DataCaptureConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataCaptureConfigSummary) GoString() string {
	return s.String()
}

// SetCaptureStatus sets the CaptureStatus field's value.
func (s *DataCaptureConfigSummary) SetCaptureStatus(v string) *DataCaptureConfigSummary {
	s.CaptureStatus = &v
	return s
}

// SetCurrentSamplingPercentage sets the CurrentSamplingPercentage field's value.
func (s *DataCaptureConfigSummary) SetCurrentSamplingPercentage(v int64) *DataCaptureConfigSummary {
	s.CurrentSamplingPercentage = &v
	return s
}

// SetDestinationS3Uri sets the DestinationS3Uri field's value.
func (s *DataCaptureConfigSummary) SetDestinationS3Uri(v string) *DataCaptureConfigSummary {
	s.DestinationS3Uri = &v
	return s
}

// SetEnableCapture sets the EnableCapture field's value.
func (s *DataCaptureConfigSummary) SetEnableCapture(v bool) *DataCaptureConfigSummary {
	s.EnableCapture = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DataCaptureConfigSummary) SetKmsKeyId(v string) *DataCaptureConfigSummary {
	s.KmsKeyId = &v
	return s
}

// The data structure used to specify the data to be used for inference in a
// batch transform job and to associate the data that is relevant to the prediction
// results in the output. The input filter provided allows you to exclude input
// data that is not needed for inference in a batch transform job. The output
// filter provided allows you to include input data relevant to interpreting
// the predictions in the output from the job. For more information, see Associate
// Prediction Results with their Corresponding Input Records (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
type DataProcessing struct {
	_ struct{} `type:"structure"`

	// A JSONPath (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators)
	// expression used to select a portion of the input data to pass to the algorithm.
	// Use the InputFilter parameter to exclude fields, such as an ID column, from
	// the input. If you want Amazon SageMaker to pass the entire input dataset
	// to the algorithm, accept the default value $.
	//
	// Examples: "$", "$[1:]", "$.features"
	InputFilter *string `type:"string"`

	// Specifies the source of the data to join with the transformed data. The valid
	// values are None and Input. The default value is None, which specifies not
	// to join the input with the transformed data. If you want the batch transform
	// job to join the original input data with the transformed data, set JoinSource
	// to Input.
	//
	// For JSON or JSONLines objects, such as a JSON array, Amazon SageMaker adds
	// the transformed data to the input JSON object in an attribute called SageMakerOutput.
	// The joined result for JSON must be a key-value pair object. If the input
	// is not a key-value pair object, Amazon SageMaker creates a new JSON file.
	// In the new JSON file, and the input data is stored under the SageMakerInput
	// key and the results are stored in SageMakerOutput.
	//
	// For CSV files, Amazon SageMaker combines the transformed data with the input
	// data at the end of the input data and stores it in the output file. The joined
	// data has the joined input data followed by the transformed data and the output
	// is a CSV file.
	JoinSource *string `type:"string" enum:"JoinSource"`

	// A JSONPath (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators)
	// expression used to select a portion of the joined dataset to save in the
	// output file for a batch transform job. If you want Amazon SageMaker to store
	// the entire input dataset in the output file, leave the default value, $.
	// If you specify indexes that aren't within the dimension size of the joined
	// dataset, you get an error.
	//
	// Examples: "$", "$[0,5:]", "$['id','SageMakerOutput']"
	OutputFilter *string `type:"string"`
}

// String returns the string representation
func (s DataProcessing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataProcessing) GoString() string {
	return s.String()
}

// SetInputFilter sets the InputFilter field's value.
func (s *DataProcessing) SetInputFilter(v string) *DataProcessing {
	s.InputFilter = &v
	return s
}

// SetJoinSource sets the JoinSource field's value.
func (s *DataProcessing) SetJoinSource(v string) *DataProcessing {
	s.JoinSource = &v
	return s
}

// SetOutputFilter sets the OutputFilter field's value.
func (s *DataProcessing) SetOutputFilter(v string) *DataProcessing {
	s.OutputFilter = &v
	return s
}

// Describes the location of the channel data.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The file system that is associated with a channel.
	FileSystemDataSource *FileSystemDataSource `type:"structure"`

	// The S3 location of the data source that is associated with a channel.
	S3DataSource *S3DataSource `type:"structure"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSource"}
	if s.FileSystemDataSource != nil {
		if err := s.FileSystemDataSource.Validate(); err != nil {
			invalidParams.AddNested("FileSystemDataSource", err.(request.ErrInvalidParams))
		}
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemDataSource sets the FileSystemDataSource field's value.
func (s *DataSource) SetFileSystemDataSource(v *FileSystemDataSource) *DataSource {
	s.FileSystemDataSource = v
	return s
}

// SetS3DataSource sets the S3DataSource field's value.
func (s *DataSource) SetS3DataSource(v *S3DataSource) *DataSource {
	s.S3DataSource = v
	return s
}

// Configuration information for the debug hook parameters, collection configuration,
// and storage paths.
type DebugHookConfig struct {
	_ struct{} `type:"structure"`

	// Configuration information for tensor collections.
	CollectionConfigurations []*CollectionConfiguration `type:"list"`

	// Configuration information for the debug hook parameters.
	HookParameters map[string]*string `type:"map"`

	// Path to local storage location for tensors. Defaults to /opt/ml/output/tensors/.
	LocalPath *string `type:"string"`

	// Path to Amazon S3 storage location for tensors.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DebugHookConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DebugHookConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DebugHookConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DebugHookConfig"}
	if s.S3OutputPath == nil {
		invalidParams.Add(request.NewErrParamRequired("S3OutputPath"))
	}
	if s.CollectionConfigurations != nil {
		for i, v := range s.CollectionConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CollectionConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionConfigurations sets the CollectionConfigurations field's value.
func (s *DebugHookConfig) SetCollectionConfigurations(v []*CollectionConfiguration) *DebugHookConfig {
	s.CollectionConfigurations = v
	return s
}

// SetHookParameters sets the HookParameters field's value.
func (s *DebugHookConfig) SetHookParameters(v map[string]*string) *DebugHookConfig {
	s.HookParameters = v
	return s
}

// SetLocalPath sets the LocalPath field's value.
func (s *DebugHookConfig) SetLocalPath(v string) *DebugHookConfig {
	s.LocalPath = &v
	return s
}

// SetS3OutputPath sets the S3OutputPath field's value.
func (s *DebugHookConfig) SetS3OutputPath(v string) *DebugHookConfig {
	s.S3OutputPath = &v
	return s
}

// Configuration information for debugging rules.
type DebugRuleConfiguration struct {
	_ struct{} `type:"structure"`

	// The instance type to deploy for a training job.
	InstanceType *string `type:"string" enum:"ProcessingInstanceType"`

	// Path to local storage location for output of rules. Defaults to /opt/ml/processing/output/rule/.
	LocalPath *string `type:"string"`

	// The name of the rule configuration. It must be unique relative to other rule
	// configuration names.
	//
	// RuleConfigurationName is a required field
	RuleConfigurationName *string `min:"1" type:"string" required:"true"`

	// The Amazon Elastic Container (ECR) Image for the managed rule evaluation.
	//
	// RuleEvaluatorImage is a required field
	RuleEvaluatorImage *string `type:"string" required:"true"`

	// Runtime configuration for rule container.
	RuleParameters map[string]*string `type:"map"`

	// Path to Amazon S3 storage location for rules.
	S3OutputPath *string `type:"string"`

	// The size, in GB, of the ML storage volume attached to the processing instance.
	VolumeSizeInGB *int64 `type:"integer"`
}

// String returns the string representation
func (s DebugRuleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DebugRuleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DebugRuleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DebugRuleConfiguration"}
	if s.RuleConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleConfigurationName"))
	}
	if s.RuleConfigurationName != nil && len(*s.RuleConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleConfigurationName", 1))
	}
	if s.RuleEvaluatorImage == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleEvaluatorImage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceType sets the InstanceType field's value.
func (s *DebugRuleConfiguration) SetInstanceType(v string) *DebugRuleConfiguration {
	s.InstanceType = &v
	return s
}

// SetLocalPath sets the LocalPath field's value.
func (s *DebugRuleConfiguration) SetLocalPath(v string) *DebugRuleConfiguration {
	s.LocalPath = &v
	return s
}

// SetRuleConfigurationName sets the RuleConfigurationName field's value.
func (s *DebugRuleConfiguration) SetRuleConfigurationName(v string) *DebugRuleConfiguration {
	s.RuleConfigurationName = &v
	return s
}

// SetRuleEvaluatorImage sets the RuleEvaluatorImage field's value.
func (s *DebugRuleConfiguration) SetRuleEvaluatorImage(v string) *DebugRuleConfiguration {
	s.RuleEvaluatorImage = &v
	return s
}

// SetRuleParameters sets the RuleParameters field's value.
func (s *DebugRuleConfiguration) SetRuleParameters(v map[string]*string) *DebugRuleConfiguration {
	s.RuleParameters = v
	return s
}

// SetS3OutputPath sets the S3OutputPath field's value.
func (s *DebugRuleConfiguration) SetS3OutputPath(v string) *DebugRuleConfiguration {
	s.S3OutputPath = &v
	return s
}

// SetVolumeSizeInGB sets the VolumeSizeInGB field's value.
func (s *DebugRuleConfiguration) SetVolumeSizeInGB(v int64) *DebugRuleConfiguration {
	s.VolumeSizeInGB = &v
	return s
}

// Information about the status of the rule evaluation.
type DebugRuleEvaluationStatus struct {
	_ struct{} `type:"structure"`

	// Timestamp when the rule evaluation status was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the rule configuration
	RuleConfigurationName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the rule evaluation job.
	RuleEvaluationJobArn *string `type:"string"`

	// Status of the rule evaluation.
	RuleEvaluationStatus *string `type:"string" enum:"RuleEvaluationStatus"`

	// Details from the rule evaluation.
	StatusDetails *string `type:"string"`
}

// String returns the string representation
func (s DebugRuleEvaluationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DebugRuleEvaluationStatus) GoString() string {
	return s.String()
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DebugRuleEvaluationStatus) SetLastModifiedTime(v time.Time) *DebugRuleEvaluationStatus {
	s.LastModifiedTime = &v
	return s
}

// SetRuleConfigurationName sets the RuleConfigurationName field's value.
func (s *DebugRuleEvaluationStatus) SetRuleConfigurationName(v string) *DebugRuleEvaluationStatus {
	s.RuleConfigurationName = &v
	return s
}

// SetRuleEvaluationJobArn sets the RuleEvaluationJobArn field's value.
func (s *DebugRuleEvaluationStatus) SetRuleEvaluationJobArn(v string) *DebugRuleEvaluationStatus {
	s.RuleEvaluationJobArn = &v
	return s
}

// SetRuleEvaluationStatus sets the RuleEvaluationStatus field's value.
func (s *DebugRuleEvaluationStatus) SetRuleEvaluationStatus(v string) *DebugRuleEvaluationStatus {
	s.RuleEvaluationStatus = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *DebugRuleEvaluationStatus) SetStatusDetails(v string) *DebugRuleEvaluationStatus {
	s.StatusDetails = &v
	return s
}

type DeleteAlgorithmInput struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm to delete.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAlgorithmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlgorithmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlgorithmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAlgorithmInput"}
	if s.AlgorithmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlgorithmName"))
	}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlgorithmName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *DeleteAlgorithmInput) SetAlgorithmName(v string) *DeleteAlgorithmInput {
	s.AlgorithmName = &v
	return s
}

type DeleteAlgorithmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAlgorithmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlgorithmOutput) GoString() string {
	return s.String()
}

type DeleteAppInput struct {
	_ struct{} `type:"structure"`

	// The name of the app.
	//
	// AppName is a required field
	AppName *string `type:"string" required:"true"`

	// The type of app.
	//
	// AppType is a required field
	AppType *string `type:"string" required:"true" enum:"AppType"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The user profile name.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInput"}
	if s.AppName == nil {
		invalidParams.Add(request.NewErrParamRequired("AppName"))
	}
	if s.AppType == nil {
		invalidParams.Add(request.NewErrParamRequired("AppType"))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.UserProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppName sets the AppName field's value.
func (s *DeleteAppInput) SetAppName(v string) *DeleteAppInput {
	s.AppName = &v
	return s
}

// SetAppType sets the AppType field's value.
func (s *DeleteAppInput) SetAppType(v string) *DeleteAppInput {
	s.AppType = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteAppInput) SetDomainId(v string) *DeleteAppInput {
	s.DomainId = &v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *DeleteAppInput) SetUserProfileName(v string) *DeleteAppInput {
	s.UserProfileName = &v
	return s
}

type DeleteAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

type DeleteCodeRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Git repository to delete.
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCodeRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCodeRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCodeRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCodeRepositoryInput"}
	if s.CodeRepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeRepositoryName"))
	}
	if s.CodeRepositoryName != nil && len(*s.CodeRepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeRepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeRepositoryName sets the CodeRepositoryName field's value.
func (s *DeleteCodeRepositoryInput) SetCodeRepositoryName(v string) *DeleteCodeRepositoryInput {
	s.CodeRepositoryName = &v
	return s
}

type DeleteCodeRepositoryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCodeRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCodeRepositoryOutput) GoString() string {
	return s.String()
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The retention policy for this domain, which specifies which resources will
	// be retained after the Domain is deleted. By default, all resources are retained
	// (not automatically deleted).
	RetentionPolicy *RetentionPolicy `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteDomainInput) SetDomainId(v string) *DeleteDomainInput {
	s.DomainId = &v
	return s
}

// SetRetentionPolicy sets the RetentionPolicy field's value.
func (s *DeleteDomainInput) SetRetentionPolicy(v *RetentionPolicy) *DeleteDomainInput {
	s.RetentionPolicy = v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

type DeleteEndpointConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint configuration that you want to delete.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointConfigInput"}
	if s.EndpointConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *DeleteEndpointConfigInput) SetEndpointConfigName(v string) *DeleteEndpointConfigInput {
	s.EndpointConfigName = &v
	return s
}

type DeleteEndpointConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointConfigOutput) GoString() string {
	return s.String()
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint that you want to delete.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *DeleteEndpointInput) SetEndpointName(v string) *DeleteEndpointInput {
	s.EndpointName = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

type DeleteExperimentInput struct {
	_ struct{} `type:"structure"`

	// The name of the experiment to delete.
	//
	// ExperimentName is a required field
	ExperimentName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExperimentInput"}
	if s.ExperimentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentName"))
	}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExperimentName sets the ExperimentName field's value.
func (s *DeleteExperimentInput) SetExperimentName(v string) *DeleteExperimentInput {
	s.ExperimentName = &v
	return s
}

type DeleteExperimentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the experiment that is being deleted.
	ExperimentArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteExperimentOutput) GoString() string {
	return s.String()
}

// SetExperimentArn sets the ExperimentArn field's value.
func (s *DeleteExperimentOutput) SetExperimentArn(v string) *DeleteExperimentOutput {
	s.ExperimentArn = &v
	return s
}

type DeleteFlowDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The name of the flow definition you are deleting.
	//
	// FlowDefinitionName is a required field
	FlowDefinitionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFlowDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowDefinitionInput"}
	if s.FlowDefinitionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinitionName"))
	}
	if s.FlowDefinitionName != nil && len(*s.FlowDefinitionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowDefinitionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowDefinitionName sets the FlowDefinitionName field's value.
func (s *DeleteFlowDefinitionInput) SetFlowDefinitionName(v string) *DeleteFlowDefinitionInput {
	s.FlowDefinitionName = &v
	return s
}

type DeleteFlowDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFlowDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowDefinitionOutput) GoString() string {
	return s.String()
}

type DeleteModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the model to delete.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DeleteModelInput) SetModelName(v string) *DeleteModelInput {
	s.ModelName = &v
	return s
}

type DeleteModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelOutput) GoString() string {
	return s.String()
}

type DeleteModelPackageInput struct {
	_ struct{} `type:"structure"`

	// The name of the model package. The name must have 1 to 63 characters. Valid
	// characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// ModelPackageName is a required field
	ModelPackageName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteModelPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelPackageInput"}
	if s.ModelPackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelPackageName"))
	}
	if s.ModelPackageName != nil && len(*s.ModelPackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelPackageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelPackageName sets the ModelPackageName field's value.
func (s *DeleteModelPackageInput) SetModelPackageName(v string) *DeleteModelPackageInput {
	s.ModelPackageName = &v
	return s
}

type DeleteModelPackageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteModelPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelPackageOutput) GoString() string {
	return s.String()
}

type DeleteMonitoringScheduleInput struct {
	_ struct{} `type:"structure"`

	// The name of the monitoring schedule to delete.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMonitoringScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMonitoringScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMonitoringScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMonitoringScheduleInput"}
	if s.MonitoringScheduleName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitoringScheduleName"))
	}
	if s.MonitoringScheduleName != nil && len(*s.MonitoringScheduleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitoringScheduleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitoringScheduleName sets the MonitoringScheduleName field's value.
func (s *DeleteMonitoringScheduleInput) SetMonitoringScheduleName(v string) *DeleteMonitoringScheduleInput {
	s.MonitoringScheduleName = &v
	return s
}

type DeleteMonitoringScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMonitoringScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMonitoringScheduleOutput) GoString() string {
	return s.String()
}

type DeleteNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon SageMaker notebook instance to delete.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotebookInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotebookInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNotebookInstanceInput"}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *DeleteNotebookInstanceInput) SetNotebookInstanceName(v string) *DeleteNotebookInstanceInput {
	s.NotebookInstanceName = &v
	return s
}

type DeleteNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration to delete.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNotebookInstanceLifecycleConfigInput"}
	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *DeleteNotebookInstanceLifecycleConfigInput) SetNotebookInstanceLifecycleConfigName(v string) *DeleteNotebookInstanceLifecycleConfigInput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

type DeleteNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigOutput) GoString() string {
	return s.String()
}

type DeleteNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotebookInstanceOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource whose tags you want to delete.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// An array or one or more tag keys to delete.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteTagsInput) SetResourceArn(v string) *DeleteTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DeleteTrialComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component to delete.
	//
	// TrialComponentName is a required field
	TrialComponentName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrialComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrialComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrialComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrialComponentInput"}
	if s.TrialComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialComponentName"))
	}
	if s.TrialComponentName != nil && len(*s.TrialComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialComponentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrialComponentName sets the TrialComponentName field's value.
func (s *DeleteTrialComponentInput) SetTrialComponentName(v string) *DeleteTrialComponentInput {
	s.TrialComponentName = &v
	return s
}

type DeleteTrialComponentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component is being deleted.
	TrialComponentArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteTrialComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrialComponentOutput) GoString() string {
	return s.String()
}

// SetTrialComponentArn sets the TrialComponentArn field's value.
func (s *DeleteTrialComponentOutput) SetTrialComponentArn(v string) *DeleteTrialComponentOutput {
	s.TrialComponentArn = &v
	return s
}

type DeleteTrialInput struct {
	_ struct{} `type:"structure"`

	// The name of the trial to delete.
	//
	// TrialName is a required field
	TrialName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrialInput"}
	if s.TrialName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialName"))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrialName sets the TrialName field's value.
func (s *DeleteTrialInput) SetTrialName(v string) *DeleteTrialInput {
	s.TrialName = &v
	return s
}

type DeleteTrialOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial that is being deleted.
	TrialArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteTrialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrialOutput) GoString() string {
	return s.String()
}

// SetTrialArn sets the TrialArn field's value.
func (s *DeleteTrialOutput) SetTrialArn(v string) *DeleteTrialOutput {
	s.TrialArn = &v
	return s
}

type DeleteUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The user profile name.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserProfileInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.UserProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteUserProfileInput) SetDomainId(v string) *DeleteUserProfileInput {
	s.DomainId = &v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *DeleteUserProfileInput) SetUserProfileName(v string) *DeleteUserProfileInput {
	s.UserProfileName = &v
	return s
}

type DeleteUserProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileOutput) GoString() string {
	return s.String()
}

type DeleteWorkteamInput struct {
	_ struct{} `type:"structure"`

	// The name of the work team to delete.
	//
	// WorkteamName is a required field
	WorkteamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWorkteamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkteamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkteamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkteamInput"}
	if s.WorkteamName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkteamName"))
	}
	if s.WorkteamName != nil && len(*s.WorkteamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkteamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkteamName sets the WorkteamName field's value.
func (s *DeleteWorkteamInput) SetWorkteamName(v string) *DeleteWorkteamInput {
	s.WorkteamName = &v
	return s
}

type DeleteWorkteamOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the work team was successfully deleted; otherwise, returns
	// false.
	//
	// Success is a required field
	Success *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s DeleteWorkteamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkteamOutput) GoString() string {
	return s.String()
}

// SetSuccess sets the Success field's value.
func (s *DeleteWorkteamOutput) SetSuccess(v bool) *DeleteWorkteamOutput {
	s.Success = &v
	return s
}

// Gets the Amazon EC2 Container Registry path of the docker image of the model
// that is hosted in this ProductionVariant.
//
// If you used the registry/repository[:tag] form to specify the image path
// of the primary container when you created the model hosted in this ProductionVariant,
// the path resolves to a path of the form registry/repository[@digest]. A digest
// is a hash value that identifies a specific version of an image. For information
// about Amazon ECR paths, see Pulling an Image (https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html)
// in the Amazon ECR User Guide.
type DeployedImage struct {
	_ struct{} `type:"structure"`

	// The date and time when the image path for the model resolved to the ResolvedImage
	ResolutionTime *time.Time `type:"timestamp"`

	// The specific digest path of the image hosted in this ProductionVariant.
	ResolvedImage *string `type:"string"`

	// The image path you specified when you created the model.
	SpecifiedImage *string `type:"string"`
}

// String returns the string representation
func (s DeployedImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeployedImage) GoString() string {
	return s.String()
}

// SetResolutionTime sets the ResolutionTime field's value.
func (s *DeployedImage) SetResolutionTime(v time.Time) *DeployedImage {
	s.ResolutionTime = &v
	return s
}

// SetResolvedImage sets the ResolvedImage field's value.
func (s *DeployedImage) SetResolvedImage(v string) *DeployedImage {
	s.ResolvedImage = &v
	return s
}

// SetSpecifiedImage sets the SpecifiedImage field's value.
func (s *DeployedImage) SetSpecifiedImage(v string) *DeployedImage {
	s.SpecifiedImage = &v
	return s
}

type DescribeAlgorithmInput struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm to describe.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAlgorithmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlgorithmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlgorithmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlgorithmInput"}
	if s.AlgorithmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlgorithmName"))
	}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlgorithmName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *DescribeAlgorithmInput) SetAlgorithmName(v string) *DescribeAlgorithmInput {
	s.AlgorithmName = &v
	return s
}

type DescribeAlgorithmOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `min:"1" type:"string" required:"true"`

	// A brief summary about the algorithm.
	AlgorithmDescription *string `type:"string"`

	// The name of the algorithm being described.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// The current status of the algorithm.
	//
	// AlgorithmStatus is a required field
	AlgorithmStatus *string `type:"string" required:"true" enum:"AlgorithmStatus"`

	// Details about the current status of the algorithm.
	//
	// AlgorithmStatusDetails is a required field
	AlgorithmStatusDetails *AlgorithmStatusDetails `type:"structure" required:"true"`

	// Whether the algorithm is certified to be listed in AWS Marketplace.
	CertifyForMarketplace *bool `type:"boolean"`

	// A timestamp specifying when the algorithm was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Details about inference jobs that the algorithm runs.
	InferenceSpecification *InferenceSpecification `type:"structure"`

	// The product identifier of the algorithm.
	ProductId *string `type:"string"`

	// Details about training jobs run by this algorithm.
	//
	// TrainingSpecification is a required field
	TrainingSpecification *TrainingSpecification `type:"structure" required:"true"`

	// Details about configurations for one or more training jobs that Amazon SageMaker
	// runs to test the algorithm.
	ValidationSpecification *AlgorithmValidationSpecification `type:"structure"`
}

// String returns the string representation
func (s DescribeAlgorithmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlgorithmOutput) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *DescribeAlgorithmOutput) SetAlgorithmArn(v string) *DescribeAlgorithmOutput {
	s.AlgorithmArn = &v
	return s
}

// SetAlgorithmDescription sets the AlgorithmDescription field's value.
func (s *DescribeAlgorithmOutput) SetAlgorithmDescription(v string) *DescribeAlgorithmOutput {
	s.AlgorithmDescription = &v
	return s
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *DescribeAlgorithmOutput) SetAlgorithmName(v string) *DescribeAlgorithmOutput {
	s.AlgorithmName = &v
	return s
}

// SetAlgorithmStatus sets the AlgorithmStatus field's value.
func (s *DescribeAlgorithmOutput) SetAlgorithmStatus(v string) *DescribeAlgorithmOutput {
	s.AlgorithmStatus = &v
	return s
}

// SetAlgorithmStatusDetails sets the AlgorithmStatusDetails field's value.
func (s *DescribeAlgorithmOutput) SetAlgorithmStatusDetails(v *AlgorithmStatusDetails) *DescribeAlgorithmOutput {
	s.AlgorithmStatusDetails = v
	return s
}

// SetCertifyForMarketplace sets the CertifyForMarketplace field's value.
func (s *DescribeAlgorithmOutput) SetCertifyForMarketplace(v bool) *DescribeAlgorithmOutput {
	s.CertifyForMarketplace = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeAlgorithmOutput) SetCreationTime(v time.Time) *DescribeAlgorithmOutput {
	s.CreationTime = &v
	return s
}

// SetInferenceSpecification sets the InferenceSpecification field's value.
func (s *DescribeAlgorithmOutput) SetInferenceSpecification(v *InferenceSpecification) *DescribeAlgorithmOutput {
	s.InferenceSpecification = v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *DescribeAlgorithmOutput) SetProductId(v string) *DescribeAlgorithmOutput {
	s.ProductId = &v
	return s
}

// SetTrainingSpecification sets the TrainingSpecification field's value.
func (s *DescribeAlgorithmOutput) SetTrainingSpecification(v *TrainingSpecification) *DescribeAlgorithmOutput {
	s.TrainingSpecification = v
	return s
}

// SetValidationSpecification sets the ValidationSpecification field's value.
func (s *DescribeAlgorithmOutput) SetValidationSpecification(v *AlgorithmValidationSpecification) *DescribeAlgorithmOutput {
	s.ValidationSpecification = v
	return s
}

type DescribeAppInput struct {
	_ struct{} `type:"structure"`

	// The name of the app.
	//
	// AppName is a required field
	AppName *string `type:"string" required:"true"`

	// The type of app.
	//
	// AppType is a required field
	AppType *string `type:"string" required:"true" enum:"AppType"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The user profile name.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInput"}
	if s.AppName == nil {
		invalidParams.Add(request.NewErrParamRequired("AppName"))
	}
	if s.AppType == nil {
		invalidParams.Add(request.NewErrParamRequired("AppType"))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.UserProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppName sets the AppName field's value.
func (s *DescribeAppInput) SetAppName(v string) *DescribeAppInput {
	s.AppName = &v
	return s
}

// SetAppType sets the AppType field's value.
func (s *DescribeAppInput) SetAppType(v string) *DescribeAppInput {
	s.AppType = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeAppInput) SetDomainId(v string) *DescribeAppInput {
	s.DomainId = &v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *DescribeAppInput) SetUserProfileName(v string) *DescribeAppInput {
	s.UserProfileName = &v
	return s
}

type DescribeAppOutput struct {
	_ struct{} `type:"structure"`

	// The app's Amazon Resource Name (ARN).
	AppArn *string `type:"string"`

	// The name of the app.
	AppName *string `type:"string"`

	// The type of app.
	AppType *string `type:"string" enum:"AppType"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// The timestamp of the last health check.
	LastHealthCheckTimestamp *time.Time `type:"timestamp"`

	// The timestamp of the last user's activity.
	LastUserActivityTimestamp *time.Time `type:"timestamp"`

	// The instance type and quantity.
	ResourceSpec *ResourceSpec `type:"structure"`

	// The status.
	Status *string `type:"string" enum:"AppStatus"`

	// The user profile name.
	UserProfileName *string `type:"string"`
}

// String returns the string representation
func (s DescribeAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAppOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppOutput) SetAppArn(v string) *DescribeAppOutput {
	s.AppArn = &v
	return s
}

// SetAppName sets the AppName field's value.
func (s *DescribeAppOutput) SetAppName(v string) *DescribeAppOutput {
	s.AppName = &v
	return s
}

// SetAppType sets the AppType field's value.
func (s *DescribeAppOutput) SetAppType(v string) *DescribeAppOutput {
	s.AppType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeAppOutput) SetCreationTime(v time.Time) *DescribeAppOutput {
	s.CreationTime = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeAppOutput) SetDomainId(v string) *DescribeAppOutput {
	s.DomainId = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeAppOutput) SetFailureReason(v string) *DescribeAppOutput {
	s.FailureReason = &v
	return s
}

// SetLastHealthCheckTimestamp sets the LastHealthCheckTimestamp field's value.
func (s *DescribeAppOutput) SetLastHealthCheckTimestamp(v time.Time) *DescribeAppOutput {
	s.LastHealthCheckTimestamp = &v
	return s
}

// SetLastUserActivityTimestamp sets the LastUserActivityTimestamp field's value.
func (s *DescribeAppOutput) SetLastUserActivityTimestamp(v time.Time) *DescribeAppOutput {
	s.LastUserActivityTimestamp = &v
	return s
}

// SetResourceSpec sets the ResourceSpec field's value.
func (s *DescribeAppOutput) SetResourceSpec(v *ResourceSpec) *DescribeAppOutput {
	s.ResourceSpec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAppOutput) SetStatus(v string) *DescribeAppOutput {
	s.Status = &v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *DescribeAppOutput) SetUserProfileName(v string) *DescribeAppOutput {
	s.UserProfileName = &v
	return s
}

type DescribeAutoMLJobInput struct {
	_ struct{} `type:"structure"`

	// Request information about a job using that job's unique name.
	//
	// AutoMLJobName is a required field
	AutoMLJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAutoMLJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoMLJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAutoMLJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAutoMLJobInput"}
	if s.AutoMLJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoMLJobName"))
	}
	if s.AutoMLJobName != nil && len(*s.AutoMLJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoMLJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoMLJobName sets the AutoMLJobName field's value.
func (s *DescribeAutoMLJobInput) SetAutoMLJobName(v string) *DescribeAutoMLJobInput {
	s.AutoMLJobName = &v
	return s
}

type DescribeAutoMLJobOutput struct {
	_ struct{} `type:"structure"`

	// Returns the job's ARN.
	//
	// AutoMLJobArn is a required field
	AutoMLJobArn *string `min:"1" type:"string" required:"true"`

	// Returns information on the job's artifacts found in AutoMLJobArtifacts.
	AutoMLJobArtifacts *AutoMLJobArtifacts `type:"structure"`

	// Returns the job's config.
	AutoMLJobConfig *AutoMLJobConfig `type:"structure"`

	// Returns the name of a job.
	//
	// AutoMLJobName is a required field
	AutoMLJobName *string `min:"1" type:"string" required:"true"`

	// Returns the job's objective.
	AutoMLJobObjective *AutoMLJobObjective `type:"structure"`

	// Returns the job's AutoMLJobSecondaryStatus.
	//
	// AutoMLJobSecondaryStatus is a required field
	AutoMLJobSecondaryStatus *string `type:"string" required:"true" enum:"AutoMLJobSecondaryStatus"`

	// Returns the job's AutoMLJobStatus.
	//
	// AutoMLJobStatus is a required field
	AutoMLJobStatus *string `type:"string" required:"true" enum:"AutoMLJobStatus"`

	// Returns the job's BestCandidate.
	BestCandidate *AutoMLCandidate `type:"structure"`

	// Returns the job's creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Returns the job's end time.
	EndTime *time.Time `type:"timestamp"`

	// Returns the job's FailureReason.
	FailureReason *string `type:"string"`

	// Returns the job's output from GenerateCandidateDefinitionsOnly.
	GenerateCandidateDefinitionsOnly *bool `type:"boolean"`

	// Returns the job's input data config.
	//
	// InputDataConfig is a required field
	InputDataConfig []*AutoMLChannel `min:"1" type:"list" required:"true"`

	// Returns the job's last modified time.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// Returns the job's output data config.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *AutoMLOutputDataConfig `type:"structure" required:"true"`

	// Returns the job's problem type.
	ProblemType *string `type:"string" enum:"ProblemType"`

	// This contains ProblemType, AutoMLJobObjective and CompletionCriteria. They're
	// auto-inferred values, if not provided by you. If you do provide them, then
	// they'll be the same as provided.
	ResolvedAttributes *ResolvedAttributes `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that has read permission to the input data location and write
	// permission to the output data location in Amazon S3.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAutoMLJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoMLJobOutput) GoString() string {
	return s.String()
}

// SetAutoMLJobArn sets the AutoMLJobArn field's value.
func (s *DescribeAutoMLJobOutput) SetAutoMLJobArn(v string) *DescribeAutoMLJobOutput {
	s.AutoMLJobArn = &v
	return s
}

// SetAutoMLJobArtifacts sets the AutoMLJobArtifacts field's value.
func (s *DescribeAutoMLJobOutput) SetAutoMLJobArtifacts(v *AutoMLJobArtifacts) *DescribeAutoMLJobOutput {
	s.AutoMLJobArtifacts = v
	return s
}

// SetAutoMLJobConfig sets the AutoMLJobConfig field's value.
func (s *DescribeAutoMLJobOutput) SetAutoMLJobConfig(v *AutoMLJobConfig) *DescribeAutoMLJobOutput {
	s.AutoMLJobConfig = v
	return s
}

// SetAutoMLJobName sets the AutoMLJobName field's value.
func (s *DescribeAutoMLJobOutput) SetAutoMLJobName(v string) *DescribeAutoMLJobOutput {
	s.AutoMLJobName = &v
	return s
}

// SetAutoMLJobObjective sets the AutoMLJobObjective field's value.
func (s *DescribeAutoMLJobOutput) SetAutoMLJobObjective(v *AutoMLJobObjective) *DescribeAutoMLJobOutput {
	s.AutoMLJobObjective = v
	return s
}

// SetAutoMLJobSecondaryStatus sets the AutoMLJobSecondaryStatus field's value.
func (s *DescribeAutoMLJobOutput) SetAutoMLJobSecondaryStatus(v string) *DescribeAutoMLJobOutput {
	s.AutoMLJobSecondaryStatus = &v
	return s
}

// SetAutoMLJobStatus sets the AutoMLJobStatus field's value.
func (s *DescribeAutoMLJobOutput) SetAutoMLJobStatus(v string) *DescribeAutoMLJobOutput {
	s.AutoMLJobStatus = &v
	return s
}

// SetBestCandidate sets the BestCandidate field's value.
func (s *DescribeAutoMLJobOutput) SetBestCandidate(v *AutoMLCandidate) *DescribeAutoMLJobOutput {
	s.BestCandidate = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeAutoMLJobOutput) SetCreationTime(v time.Time) *DescribeAutoMLJobOutput {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeAutoMLJobOutput) SetEndTime(v time.Time) *DescribeAutoMLJobOutput {
	s.EndTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeAutoMLJobOutput) SetFailureReason(v string) *DescribeAutoMLJobOutput {
	s.FailureReason = &v
	return s
}

// SetGenerateCandidateDefinitionsOnly sets the GenerateCandidateDefinitionsOnly field's value.
func (s *DescribeAutoMLJobOutput) SetGenerateCandidateDefinitionsOnly(v bool) *DescribeAutoMLJobOutput {
	s.GenerateCandidateDefinitionsOnly = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DescribeAutoMLJobOutput) SetInputDataConfig(v []*AutoMLChannel) *DescribeAutoMLJobOutput {
	s.InputDataConfig = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeAutoMLJobOutput) SetLastModifiedTime(v time.Time) *DescribeAutoMLJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DescribeAutoMLJobOutput) SetOutputDataConfig(v *AutoMLOutputDataConfig) *DescribeAutoMLJobOutput {
	s.OutputDataConfig = v
	return s
}

// SetProblemType sets the ProblemType field's value.
func (s *DescribeAutoMLJobOutput) SetProblemType(v string) *DescribeAutoMLJobOutput {
	s.ProblemType = &v
	return s
}

// SetResolvedAttributes sets the ResolvedAttributes field's value.
func (s *DescribeAutoMLJobOutput) SetResolvedAttributes(v *ResolvedAttributes) *DescribeAutoMLJobOutput {
	s.ResolvedAttributes = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeAutoMLJobOutput) SetRoleArn(v string) *DescribeAutoMLJobOutput {
	s.RoleArn = &v
	return s
}

type DescribeCodeRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Git repository to describe.
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCodeRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCodeRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCodeRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCodeRepositoryInput"}
	if s.CodeRepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeRepositoryName"))
	}
	if s.CodeRepositoryName != nil && len(*s.CodeRepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeRepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeRepositoryName sets the CodeRepositoryName field's value.
func (s *DescribeCodeRepositoryInput) SetCodeRepositoryName(v string) *DescribeCodeRepositoryInput {
	s.CodeRepositoryName = &v
	return s
}

type DescribeCodeRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Git repository.
	//
	// CodeRepositoryArn is a required field
	CodeRepositoryArn *string `min:"1" type:"string" required:"true"`

	// The name of the Git repository.
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`

	// The date and time that the repository was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Configuration details about the repository, including the URL where the repository
	// is located, the default branch, and the Amazon Resource Name (ARN) of the
	// AWS Secrets Manager secret that contains the credentials used to access the
	// repository.
	GitConfig *GitConfig `type:"structure"`

	// The date and time that the repository was last changed.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s DescribeCodeRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCodeRepositoryOutput) GoString() string {
	return s.String()
}

// SetCodeRepositoryArn sets the CodeRepositoryArn field's value.
func (s *DescribeCodeRepositoryOutput) SetCodeRepositoryArn(v string) *DescribeCodeRepositoryOutput {
	s.CodeRepositoryArn = &v
	return s
}

// SetCodeRepositoryName sets the CodeRepositoryName field's value.
func (s *DescribeCodeRepositoryOutput) SetCodeRepositoryName(v string) *DescribeCodeRepositoryOutput {
	s.CodeRepositoryName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeCodeRepositoryOutput) SetCreationTime(v time.Time) *DescribeCodeRepositoryOutput {
	s.CreationTime = &v
	return s
}

// SetGitConfig sets the GitConfig field's value.
func (s *DescribeCodeRepositoryOutput) SetGitConfig(v *GitConfig) *DescribeCodeRepositoryOutput {
	s.GitConfig = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeCodeRepositoryOutput) SetLastModifiedTime(v time.Time) *DescribeCodeRepositoryOutput {
	s.LastModifiedTime = &v
	return s
}

type DescribeCompilationJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the model compilation job that you want information about.
	//
	// CompilationJobName is a required field
	CompilationJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCompilationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCompilationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCompilationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCompilationJobInput"}
	if s.CompilationJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("CompilationJobName"))
	}
	if s.CompilationJobName != nil && len(*s.CompilationJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CompilationJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompilationJobName sets the CompilationJobName field's value.
func (s *DescribeCompilationJobInput) SetCompilationJobName(v string) *DescribeCompilationJobInput {
	s.CompilationJobName = &v
	return s
}

type DescribeCompilationJobOutput struct {
	_ struct{} `type:"structure"`

	// The time when the model compilation job on a compilation job instance ended.
	// For a successful or stopped job, this is when the job's model artifacts have
	// finished uploading. For a failed job, this is when Amazon SageMaker detected
	// that the job failed.
	CompilationEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker assumes
	// to perform the model compilation job.
	//
	// CompilationJobArn is a required field
	CompilationJobArn *string `type:"string" required:"true"`

	// The name of the model compilation job.
	//
	// CompilationJobName is a required field
	CompilationJobName *string `min:"1" type:"string" required:"true"`

	// The status of the model compilation job.
	//
	// CompilationJobStatus is a required field
	CompilationJobStatus *string `type:"string" required:"true" enum:"CompilationJobStatus"`

	// The time when the model compilation job started the CompilationJob instances.
	//
	// You are billed for the time between this timestamp and the timestamp in the
	// DescribeCompilationJobResponse$CompilationEndTime field. In Amazon CloudWatch
	// Logs, the start time might be later than this time. That's because it takes
	// time to download the compilation job, which depends on the size of the compilation
	// job container.
	CompilationStartTime *time.Time `type:"timestamp"`

	// The time that the model compilation job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// If a model compilation job failed, the reason it failed.
	//
	// FailureReason is a required field
	FailureReason *string `type:"string" required:"true"`

	// Information about the location in Amazon S3 of the input model artifacts,
	// the name and shape of the expected data inputs, and the framework in which
	// the model was trained.
	//
	// InputConfig is a required field
	InputConfig *InputConfig `type:"structure" required:"true"`

	// The time that the status of the model compilation job was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// Information about the location in Amazon S3 that has been configured for
	// storing the model artifacts used in the compilation job.
	//
	// ModelArtifacts is a required field
	ModelArtifacts *ModelArtifacts `type:"structure" required:"true"`

	// Information about the output location for the compiled model and the target
	// device that the model runs on.
	//
	// OutputConfig is a required field
	OutputConfig *OutputConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the model compilation job.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies a limit to how long a model compilation job can run. When the job
	// reaches the time limit, Amazon SageMaker ends the compilation job. Use this
	// API to cap model training costs.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeCompilationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCompilationJobOutput) GoString() string {
	return s.String()
}

// SetCompilationEndTime sets the CompilationEndTime field's value.
func (s *DescribeCompilationJobOutput) SetCompilationEndTime(v time.Time) *DescribeCompilationJobOutput {
	s.CompilationEndTime = &v
	return s
}

// SetCompilationJobArn sets the CompilationJobArn field's value.
func (s *DescribeCompilationJobOutput) SetCompilationJobArn(v string) *DescribeCompilationJobOutput {
	s.CompilationJobArn = &v
	return s
}

// SetCompilationJobName sets the CompilationJobName field's value.
func (s *DescribeCompilationJobOutput) SetCompilationJobName(v string) *DescribeCompilationJobOutput {
	s.CompilationJobName = &v
	return s
}

// SetCompilationJobStatus sets the CompilationJobStatus field's value.
func (s *DescribeCompilationJobOutput) SetCompilationJobStatus(v string) *DescribeCompilationJobOutput {
	s.CompilationJobStatus = &v
	return s
}

// SetCompilationStartTime sets the CompilationStartTime field's value.
func (s *DescribeCompilationJobOutput) SetCompilationStartTime(v time.Time) *DescribeCompilationJobOutput {
	s.CompilationStartTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeCompilationJobOutput) SetCreationTime(v time.Time) *DescribeCompilationJobOutput {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeCompilationJobOutput) SetFailureReason(v string) *DescribeCompilationJobOutput {
	s.FailureReason = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *DescribeCompilationJobOutput) SetInputConfig(v *InputConfig) *DescribeCompilationJobOutput {
	s.InputConfig = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeCompilationJobOutput) SetLastModifiedTime(v time.Time) *DescribeCompilationJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetModelArtifacts sets the ModelArtifacts field's value.
func (s *DescribeCompilationJobOutput) SetModelArtifacts(v *ModelArtifacts) *DescribeCompilationJobOutput {
	s.ModelArtifacts = v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *DescribeCompilationJobOutput) SetOutputConfig(v *OutputConfig) *DescribeCompilationJobOutput {
	s.OutputConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeCompilationJobOutput) SetRoleArn(v string) *DescribeCompilationJobOutput {
	s.RoleArn = &v
	return s
}

// SetStoppingCondition sets the StoppingCondition field's value.
func (s *DescribeCompilationJobOutput) SetStoppingCondition(v *StoppingCondition) *DescribeCompilationJobOutput {
	s.StoppingCondition = v
	return s
}

type DescribeDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeDomainInput) SetDomainId(v string) *DescribeDomainInput {
	s.DomainId = &v
	return s
}

type DescribeDomainOutput struct {
	_ struct{} `type:"structure"`

	// The domain's authentication mode.
	AuthMode *string `type:"string" enum:"AuthMode"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// Settings which are applied to all UserProfile in this domain, if settings
	// are not explicitly specified in a given UserProfile.
	DefaultUserSettings *UserSettings `type:"structure"`

	// The domain's Amazon Resource Name (ARN).
	DomainArn *string `type:"string"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The domain name.
	DomainName *string `type:"string"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// The ID of the Amazon Elastic File System (EFS) managed by this Domain.
	HomeEfsFileSystemId *string `type:"string"`

	// The AWS Key Management Service encryption key ID.
	HomeEfsFileSystemKmsKeyId *string `type:"string"`

	// The last modified time.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The SSO managed application instance ID.
	SingleSignOnManagedApplicationInstanceId *string `type:"string"`

	// The status.
	Status *string `type:"string" enum:"DomainStatus"`

	// Security setting to limit to a set of subnets.
	SubnetIds []*string `min:"1" type:"list"`

	// The domain's URL.
	Url *string `type:"string"`

	// The ID of the Amazon Virtual Private Cloud.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DescribeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainOutput) GoString() string {
	return s.String()
}

// SetAuthMode sets the AuthMode field's value.
func (s *DescribeDomainOutput) SetAuthMode(v string) *DescribeDomainOutput {
	s.AuthMode = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeDomainOutput) SetCreationTime(v time.Time) *DescribeDomainOutput {
	s.CreationTime = &v
	return s
}

// SetDefaultUserSettings sets the DefaultUserSettings field's value.
func (s *DescribeDomainOutput) SetDefaultUserSettings(v *UserSettings) *DescribeDomainOutput {
	s.DefaultUserSettings = v
	return s
}

// SetDomainArn sets the DomainArn field's value.
func (s *DescribeDomainOutput) SetDomainArn(v string) *DescribeDomainOutput {
	s.DomainArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeDomainOutput) SetDomainId(v string) *DescribeDomainOutput {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainOutput) SetDomainName(v string) *DescribeDomainOutput {
	s.DomainName = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeDomainOutput) SetFailureReason(v string) *DescribeDomainOutput {
	s.FailureReason = &v
	return s
}

// SetHomeEfsFileSystemId sets the HomeEfsFileSystemId field's value.
func (s *DescribeDomainOutput) SetHomeEfsFileSystemId(v string) *DescribeDomainOutput {
	s.HomeEfsFileSystemId = &v
	return s
}

// SetHomeEfsFileSystemKmsKeyId sets the HomeEfsFileSystemKmsKeyId field's value.
func (s *DescribeDomainOutput) SetHomeEfsFileSystemKmsKeyId(v string) *DescribeDomainOutput {
	s.HomeEfsFileSystemKmsKeyId = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeDomainOutput) SetLastModifiedTime(v time.Time) *DescribeDomainOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSingleSignOnManagedApplicationInstanceId sets the SingleSignOnManagedApplicationInstanceId field's value.
func (s *DescribeDomainOutput) SetSingleSignOnManagedApplicationInstanceId(v string) *DescribeDomainOutput {
	s.SingleSignOnManagedApplicationInstanceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDomainOutput) SetStatus(v string) *DescribeDomainOutput {
	s.Status = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DescribeDomainOutput) SetSubnetIds(v []*string) *DescribeDomainOutput {
	s.SubnetIds = v
	return s
}

// SetUrl sets the Url field's value.
func (s *DescribeDomainOutput) SetUrl(v string) *DescribeDomainOutput {
	s.Url = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DescribeDomainOutput) SetVpcId(v string) *DescribeDomainOutput {
	s.VpcId = &v
	return s
}

type DescribeEndpointConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointConfigInput"}
	if s.EndpointConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *DescribeEndpointConfigInput) SetEndpointConfigName(v string) *DescribeEndpointConfigInput {
	s.EndpointConfigName = &v
	return s
}

type DescribeEndpointConfigOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint configuration was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	DataCaptureConfig *DataCaptureConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`

	// Name of the Amazon SageMaker endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the
	// ML storage volume attached to the instance.
	KmsKeyId *string `type:"string"`

	// An array of ProductionVariant objects, one for each model that you want to
	// host at this endpoint.
	//
	// ProductionVariants is a required field
	ProductionVariants []*ProductionVariant `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointConfigOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeEndpointConfigOutput) SetCreationTime(v time.Time) *DescribeEndpointConfigOutput {
	s.CreationTime = &v
	return s
}

// SetDataCaptureConfig sets the DataCaptureConfig field's value.
func (s *DescribeEndpointConfigOutput) SetDataCaptureConfig(v *DataCaptureConfig) *DescribeEndpointConfigOutput {
	s.DataCaptureConfig = v
	return s
}

// SetEndpointConfigArn sets the EndpointConfigArn field's value.
func (s *DescribeEndpointConfigOutput) SetEndpointConfigArn(v string) *DescribeEndpointConfigOutput {
	s.EndpointConfigArn = &v
	return s
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *DescribeEndpointConfigOutput) SetEndpointConfigName(v string) *DescribeEndpointConfigOutput {
	s.EndpointConfigName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DescribeEndpointConfigOutput) SetKmsKeyId(v string) *DescribeEndpointConfigOutput {
	s.KmsKeyId = &v
	return s
}

// SetProductionVariants sets the ProductionVariants field's value.
func (s *DescribeEndpointConfigOutput) SetProductionVariants(v []*ProductionVariant) *DescribeEndpointConfigOutput {
	s.ProductionVariants = v
	return s
}

type DescribeEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *DescribeEndpointInput) SetEndpointName(v string) *DescribeEndpointInput {
	s.EndpointName = &v
	return s
}

type DescribeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	DataCaptureConfig *DataCaptureConfigSummary `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint configuration associated with this endpoint.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// Name of the endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The status of the endpoint.
	//
	//    * OutOfService: Endpoint is not available to take incoming requests.
	//
	//    * Creating: CreateEndpoint is executing.
	//
	//    * Updating: UpdateEndpoint or UpdateEndpointWeightsAndCapacities is executing.
	//
	//    * SystemUpdating: Endpoint is undergoing maintenance and cannot be updated
	//    or deleted or re-scaled until it has completed. This maintenance operation
	//    does not change any customer-specified values such as VPC config, KMS
	//    encryption, model, instance type, or instance count.
	//
	//    * RollingBack: Endpoint fails to scale up or down or change its variant
	//    weight and is in the process of rolling back to its previous configuration.
	//    Once the rollback completes, endpoint returns to an InService status.
	//    This transitional status only applies to an endpoint that has autoscaling
	//    enabled and is undergoing variant weight or capacity changes as part of
	//    an UpdateEndpointWeightsAndCapacities call or when the UpdateEndpointWeightsAndCapacities
	//    operation is called explicitly.
	//
	//    * InService: Endpoint is available to process incoming requests.
	//
	//    * Deleting: DeleteEndpoint is executing.
	//
	//    * Failed: Endpoint could not be created, updated, or re-scaled. Use DescribeEndpointOutput$FailureReason
	//    for information about the failure. DeleteEndpoint is the only operation
	//    that can be performed on a failed endpoint.
	//
	// EndpointStatus is a required field
	EndpointStatus *string `type:"string" required:"true" enum:"EndpointStatus"`

	// If the status of the endpoint is Failed, the reason why it failed.
	FailureReason *string `type:"string"`

	// A timestamp that shows when the endpoint was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// An array of ProductionVariantSummary objects, one for each model hosted behind
	// this endpoint.
	ProductionVariants []*ProductionVariantSummary `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeEndpointOutput) SetCreationTime(v time.Time) *DescribeEndpointOutput {
	s.CreationTime = &v
	return s
}

// SetDataCaptureConfig sets the DataCaptureConfig field's value.
func (s *DescribeEndpointOutput) SetDataCaptureConfig(v *DataCaptureConfigSummary) *DescribeEndpointOutput {
	s.DataCaptureConfig = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeEndpointOutput) SetEndpointArn(v string) *DescribeEndpointOutput {
	s.EndpointArn = &v
	return s
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *DescribeEndpointOutput) SetEndpointConfigName(v string) *DescribeEndpointOutput {
	s.EndpointConfigName = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *DescribeEndpointOutput) SetEndpointName(v string) *DescribeEndpointOutput {
	s.EndpointName = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *DescribeEndpointOutput) SetEndpointStatus(v string) *DescribeEndpointOutput {
	s.EndpointStatus = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeEndpointOutput) SetFailureReason(v string) *DescribeEndpointOutput {
	s.FailureReason = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeEndpointOutput) SetLastModifiedTime(v time.Time) *DescribeEndpointOutput {
	s.LastModifiedTime = &v
	return s
}

// SetProductionVariants sets the ProductionVariants field's value.
func (s *DescribeEndpointOutput) SetProductionVariants(v []*ProductionVariantSummary) *DescribeEndpointOutput {
	s.ProductionVariants = v
	return s
}

type DescribeExperimentInput struct {
	_ struct{} `type:"structure"`

	// The name of the experiment to describe.
	//
	// ExperimentName is a required field
	ExperimentName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExperimentInput"}
	if s.ExperimentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentName"))
	}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExperimentName sets the ExperimentName field's value.
func (s *DescribeExperimentInput) SetExperimentName(v string) *DescribeExperimentInput {
	s.ExperimentName = &v
	return s
}

type DescribeExperimentOutput struct {
	_ struct{} `type:"structure"`

	// Who created the experiment.
	CreatedBy *UserContext `type:"structure"`

	// When the experiment was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the experiment.
	Description *string `type:"string"`

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string `type:"string"`

	// The name of the experiment.
	ExperimentName *string `min:"1" type:"string"`

	// Who last modified the experiment.
	LastModifiedBy *UserContext `type:"structure"`

	// When the experiment was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The ARN of the source and, optionally, the type.
	Source *ExperimentSource `type:"structure"`
}

// String returns the string representation
func (s DescribeExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExperimentOutput) GoString() string {
	return s.String()
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeExperimentOutput) SetCreatedBy(v *UserContext) *DescribeExperimentOutput {
	s.CreatedBy = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeExperimentOutput) SetCreationTime(v time.Time) *DescribeExperimentOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeExperimentOutput) SetDescription(v string) *DescribeExperimentOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeExperimentOutput) SetDisplayName(v string) *DescribeExperimentOutput {
	s.DisplayName = &v
	return s
}

// SetExperimentArn sets the ExperimentArn field's value.
func (s *DescribeExperimentOutput) SetExperimentArn(v string) *DescribeExperimentOutput {
	s.ExperimentArn = &v
	return s
}

// SetExperimentName sets the ExperimentName field's value.
func (s *DescribeExperimentOutput) SetExperimentName(v string) *DescribeExperimentOutput {
	s.ExperimentName = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *DescribeExperimentOutput) SetLastModifiedBy(v *UserContext) *DescribeExperimentOutput {
	s.LastModifiedBy = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeExperimentOutput) SetLastModifiedTime(v time.Time) *DescribeExperimentOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeExperimentOutput) SetSource(v *ExperimentSource) *DescribeExperimentOutput {
	s.Source = v
	return s
}

type DescribeFlowDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The name of the flow definition.
	//
	// FlowDefinitionName is a required field
	FlowDefinitionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFlowDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFlowDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFlowDefinitionInput"}
	if s.FlowDefinitionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinitionName"))
	}
	if s.FlowDefinitionName != nil && len(*s.FlowDefinitionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowDefinitionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowDefinitionName sets the FlowDefinitionName field's value.
func (s *DescribeFlowDefinitionInput) SetFlowDefinitionName(v string) *DescribeFlowDefinitionInput {
	s.FlowDefinitionName = &v
	return s
}

type DescribeFlowDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp when the flow definition was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	FailureReason *string `type:"string"`

	// The Amazon Resource Name (ARN) of the flow defintion.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// FlowDefinitionName is a required field
	FlowDefinitionName *string `min:"1" type:"string" required:"true"`

	// The status of the flow definition. Valid values are listed below.
	//
	// FlowDefinitionStatus is a required field
	FlowDefinitionStatus *string `type:"string" required:"true" enum:"FlowDefinitionStatus"`

	// An object containing information about what triggers a human review workflow.
	HumanLoopActivationConfig *HumanLoopActivationConfig `type:"structure"`

	// An object containing information about who works on the task, the workforce
	// task price, and other task details.
	//
	// HumanLoopConfig is a required field
	HumanLoopConfig *HumanLoopConfig `type:"structure" required:"true"`

	// An object containing information about the output file.
	//
	// OutputConfig is a required field
	OutputConfig *FlowDefinitionOutputConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) execution role for the flow definition.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFlowDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowDefinitionOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeFlowDefinitionOutput) SetCreationTime(v time.Time) *DescribeFlowDefinitionOutput {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeFlowDefinitionOutput) SetFailureReason(v string) *DescribeFlowDefinitionOutput {
	s.FailureReason = &v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *DescribeFlowDefinitionOutput) SetFlowDefinitionArn(v string) *DescribeFlowDefinitionOutput {
	s.FlowDefinitionArn = &v
	return s
}

// SetFlowDefinitionName sets the FlowDefinitionName field's value.
func (s *DescribeFlowDefinitionOutput) SetFlowDefinitionName(v string) *DescribeFlowDefinitionOutput {
	s.FlowDefinitionName = &v
	return s
}

// SetFlowDefinitionStatus sets the FlowDefinitionStatus field's value.
func (s *DescribeFlowDefinitionOutput) SetFlowDefinitionStatus(v string) *DescribeFlowDefinitionOutput {
	s.FlowDefinitionStatus = &v
	return s
}

// SetHumanLoopActivationConfig sets the HumanLoopActivationConfig field's value.
func (s *DescribeFlowDefinitionOutput) SetHumanLoopActivationConfig(v *HumanLoopActivationConfig) *DescribeFlowDefinitionOutput {
	s.HumanLoopActivationConfig = v
	return s
}

// SetHumanLoopConfig sets the HumanLoopConfig field's value.
func (s *DescribeFlowDefinitionOutput) SetHumanLoopConfig(v *HumanLoopConfig) *DescribeFlowDefinitionOutput {
	s.HumanLoopConfig = v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *DescribeFlowDefinitionOutput) SetOutputConfig(v *FlowDefinitionOutputConfig) *DescribeFlowDefinitionOutput {
	s.OutputConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeFlowDefinitionOutput) SetRoleArn(v string) *DescribeFlowDefinitionOutput {
	s.RoleArn = &v
	return s
}

type DescribeHumanTaskUiInput struct {
	_ struct{} `type:"structure"`

	// The name of the human task user interface you want information about.
	//
	// HumanTaskUiName is a required field
	HumanTaskUiName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHumanTaskUiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHumanTaskUiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHumanTaskUiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHumanTaskUiInput"}
	if s.HumanTaskUiName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanTaskUiName"))
	}
	if s.HumanTaskUiName != nil && len(*s.HumanTaskUiName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanTaskUiName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanTaskUiName sets the HumanTaskUiName field's value.
func (s *DescribeHumanTaskUiInput) SetHumanTaskUiName(v string) *DescribeHumanTaskUiInput {
	s.HumanTaskUiName = &v
	return s
}

type DescribeHumanTaskUiOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp when the human task user interface was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the human task user interface.
	//
	// HumanTaskUiArn is a required field
	HumanTaskUiArn *string `type:"string" required:"true"`

	// The name of the human task user interface.
	//
	// HumanTaskUiName is a required field
	HumanTaskUiName *string `min:"1" type:"string" required:"true"`

	// Container for user interface template information.
	//
	// UiTemplate is a required field
	UiTemplate *UiTemplateInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeHumanTaskUiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHumanTaskUiOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeHumanTaskUiOutput) SetCreationTime(v time.Time) *DescribeHumanTaskUiOutput {
	s.CreationTime = &v
	return s
}

// SetHumanTaskUiArn sets the HumanTaskUiArn field's value.
func (s *DescribeHumanTaskUiOutput) SetHumanTaskUiArn(v string) *DescribeHumanTaskUiOutput {
	s.HumanTaskUiArn = &v
	return s
}

// SetHumanTaskUiName sets the HumanTaskUiName field's value.
func (s *DescribeHumanTaskUiOutput) SetHumanTaskUiName(v string) *DescribeHumanTaskUiOutput {
	s.HumanTaskUiName = &v
	return s
}

// SetUiTemplate sets the UiTemplate field's value.
func (s *DescribeHumanTaskUiOutput) SetUiTemplate(v *UiTemplateInfo) *DescribeHumanTaskUiOutput {
	s.UiTemplate = v
	return s
}

type DescribeHyperParameterTuningJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the tuning job to describe.
	//
	// HyperParameterTuningJobName is a required field
	HyperParameterTuningJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHyperParameterTuningJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHyperParameterTuningJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHyperParameterTuningJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHyperParameterTuningJobInput"}
	if s.HyperParameterTuningJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("HyperParameterTuningJobName"))
	}
	if s.HyperParameterTuningJobName != nil && len(*s.HyperParameterTuningJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HyperParameterTuningJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHyperParameterTuningJobName sets the HyperParameterTuningJobName field's value.
func (s *DescribeHyperParameterTuningJobInput) SetHyperParameterTuningJobName(v string) *DescribeHyperParameterTuningJobInput {
	s.HyperParameterTuningJobName = &v
	return s
}

type DescribeHyperParameterTuningJobOutput struct {
	_ struct{} `type:"structure"`

	// A TrainingJobSummary object that describes the training job that completed
	// with the best current HyperParameterTuningJobObjective.
	BestTrainingJob *HyperParameterTrainingJobSummary `type:"structure"`

	// The date and time that the tuning job started.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// If the tuning job failed, the reason it failed.
	FailureReason *string `type:"string"`

	// The date and time that the tuning job ended.
	HyperParameterTuningEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the tuning job.
	//
	// HyperParameterTuningJobArn is a required field
	HyperParameterTuningJobArn *string `type:"string" required:"true"`

	// The HyperParameterTuningJobConfig object that specifies the configuration
	// of the tuning job.
	//
	// HyperParameterTuningJobConfig is a required field
	HyperParameterTuningJobConfig *HyperParameterTuningJobConfig `type:"structure" required:"true"`

	// The name of the tuning job.
	//
	// HyperParameterTuningJobName is a required field
	HyperParameterTuningJobName *string `min:"1" type:"string" required:"true"`

	// The status of the tuning job: InProgress, Completed, Failed, Stopping, or
	// Stopped.
	//
	// HyperParameterTuningJobStatus is a required field
	HyperParameterTuningJobStatus *string `type:"string" required:"true" enum:"HyperParameterTuningJobStatus"`

	// The date and time that the status of the tuning job was modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The ObjectiveStatusCounters object that specifies the number of training
	// jobs, categorized by the status of their final objective metric, that this
	// tuning job launched.
	//
	// ObjectiveStatusCounters is a required field
	ObjectiveStatusCounters *ObjectiveStatusCounters `type:"structure" required:"true"`

	// If the hyperparameter tuning job is an warm start tuning job with a WarmStartType
	// of IDENTICAL_DATA_AND_ALGORITHM, this is the TrainingJobSummary for the training
	// job with the best objective metric value of all training jobs launched by
	// this tuning job and all parent jobs specified for the warm start tuning job.
	OverallBestTrainingJob *HyperParameterTrainingJobSummary `type:"structure"`

	// The HyperParameterTrainingJobDefinition object that specifies the definition
	// of the training jobs that this tuning job launches.
	TrainingJobDefinition *HyperParameterTrainingJobDefinition `type:"structure"`

	TrainingJobDefinitions []*HyperParameterTrainingJobDefinition `min:"1" type:"list"`

	// The TrainingJobStatusCounters object that specifies the number of training
	// jobs, categorized by status, that this tuning job launched.
	//
	// TrainingJobStatusCounters is a required field
	TrainingJobStatusCounters *TrainingJobStatusCounters `type:"structure" required:"true"`

	// The configuration for starting the hyperparameter parameter tuning job using
	// one or more previous tuning jobs as a starting point. The results of previous
	// tuning jobs are used to inform which combinations of hyperparameters to search
	// over in the new tuning job.
	WarmStartConfig *HyperParameterTuningJobWarmStartConfig `type:"structure"`
}

// String returns the string representation
func (s DescribeHyperParameterTuningJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHyperParameterTuningJobOutput) GoString() string {
	return s.String()
}

// SetBestTrainingJob sets the BestTrainingJob field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetBestTrainingJob(v *HyperParameterTrainingJobSummary) *DescribeHyperParameterTuningJobOutput {
	s.BestTrainingJob = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetCreationTime(v time.Time) *DescribeHyperParameterTuningJobOutput {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetFailureReason(v string) *DescribeHyperParameterTuningJobOutput {
	s.FailureReason = &v
	return s
}

// SetHyperParameterTuningEndTime sets the HyperParameterTuningEndTime field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetHyperParameterTuningEndTime(v time.Time) *DescribeHyperParameterTuningJobOutput {
	s.HyperParameterTuningEndTime = &v
	return s
}

// SetHyperParameterTuningJobArn sets the HyperParameterTuningJobArn field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetHyperParameterTuningJobArn(v string) *DescribeHyperParameterTuningJobOutput {
	s.HyperParameterTuningJobArn = &v
	return s
}

// SetHyperParameterTuningJobConfig sets the HyperParameterTuningJobConfig field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetHyperParameterTuningJobConfig(v *HyperParameterTuningJobConfig) *DescribeHyperParameterTuningJobOutput {
	s.HyperParameterTuningJobConfig = v
	return s
}

// SetHyperParameterTuningJobName sets the HyperParameterTuningJobName field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetHyperParameterTuningJobName(v string) *DescribeHyperParameterTuningJobOutput {
	s.HyperParameterTuningJobName = &v
	return s
}

// SetHyperParameterTuningJobStatus sets the HyperParameterTuningJobStatus field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetHyperParameterTuningJobStatus(v string) *DescribeHyperParameterTuningJobOutput {
	s.HyperParameterTuningJobStatus = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetLastModifiedTime(v time.Time) *DescribeHyperParameterTuningJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetObjectiveStatusCounters sets the ObjectiveStatusCounters field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetObjectiveStatusCounters(v *ObjectiveStatusCounters) *DescribeHyperParameterTuningJobOutput {
	s.ObjectiveStatusCounters = v
	return s
}

// SetOverallBestTrainingJob sets the OverallBestTrainingJob field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetOverallBestTrainingJob(v *HyperParameterTrainingJobSummary) *DescribeHyperParameterTuningJobOutput {
	s.OverallBestTrainingJob = v
	return s
}

// SetTrainingJobDefinition sets the TrainingJobDefinition field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetTrainingJobDefinition(v *HyperParameterTrainingJobDefinition) *DescribeHyperParameterTuningJobOutput {
	s.TrainingJobDefinition = v
	return s
}

// SetTrainingJobDefinitions sets the TrainingJobDefinitions field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetTrainingJobDefinitions(v []*HyperParameterTrainingJobDefinition) *DescribeHyperParameterTuningJobOutput {
	s.TrainingJobDefinitions = v
	return s
}

// SetTrainingJobStatusCounters sets the TrainingJobStatusCounters field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetTrainingJobStatusCounters(v *TrainingJobStatusCounters) *DescribeHyperParameterTuningJobOutput {
	s.TrainingJobStatusCounters = v
	return s
}

// SetWarmStartConfig sets the WarmStartConfig field's value.
func (s *DescribeHyperParameterTuningJobOutput) SetWarmStartConfig(v *HyperParameterTuningJobWarmStartConfig) *DescribeHyperParameterTuningJobOutput {
	s.WarmStartConfig = v
	return s
}

type DescribeLabelingJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the labeling job to return information for.
	//
	// LabelingJobName is a required field
	LabelingJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLabelingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLabelingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLabelingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLabelingJobInput"}
	if s.LabelingJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelingJobName"))
	}
	if s.LabelingJobName != nil && len(*s.LabelingJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelingJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelingJobName sets the LabelingJobName field's value.
func (s *DescribeLabelingJobInput) SetLabelingJobName(v string) *DescribeLabelingJobInput {
	s.LabelingJobName = &v
	return s
}

type DescribeLabelingJobOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the labeling job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// If the job failed, the reason that it failed.
	FailureReason *string `type:"string"`

	// Configuration information required for human workers to complete a labeling
	// task.
	//
	// HumanTaskConfig is a required field
	HumanTaskConfig *HumanTaskConfig `type:"structure" required:"true"`

	// Input configuration information for the labeling job, such as the Amazon
	// S3 location of the data objects and the location of the manifest file that
	// describes the data objects.
	//
	// InputConfig is a required field
	InputConfig *LabelingJobInputConfig `type:"structure" required:"true"`

	// A unique identifier for work done as part of a labeling job.
	//
	// JobReferenceCode is a required field
	JobReferenceCode *string `min:"1" type:"string" required:"true"`

	// The attribute used as the label in the output manifest file.
	LabelAttributeName *string `min:"1" type:"string"`

	// The S3 location of the JSON file that defines the categories used to label
	// data objects. Please note the following label-category limits:
	//
	//    * Semantic segmentation labeling jobs using automated labeling: 20 labels
	//
	//    * Box bounding labeling jobs (all): 10 labels
	//
	// The file is a JSON structure in the following format:
	//
	// {
	//
	// "document-version": "2018-11-28"
	//
	// "labels": [
	//
	// {
	//
	// "label": "label 1"
	//
	// },
	//
	// {
	//
	// "label": "label 2"
	//
	// },
	//
	// ...
	//
	// {
	//
	// "label": "label n"
	//
	// }
	//
	// ]
	//
	// }
	LabelCategoryConfigS3Uri *string `type:"string"`

	// Provides a breakdown of the number of data objects labeled by humans, the
	// number of objects labeled by machine, the number of objects than couldn't
	// be labeled, and the total number of objects labeled.
	//
	// LabelCounters is a required field
	LabelCounters *LabelCounters `type:"structure" required:"true"`

	// Configuration information for automated data labeling.
	LabelingJobAlgorithmsConfig *LabelingJobAlgorithmsConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the labeling job.
	//
	// LabelingJobArn is a required field
	LabelingJobArn *string `type:"string" required:"true"`

	// The name assigned to the labeling job when it was created.
	//
	// LabelingJobName is a required field
	LabelingJobName *string `min:"1" type:"string" required:"true"`

	// The location of the output produced by the labeling job.
	LabelingJobOutput *LabelingJobOutput `type:"structure"`

	// The processing status of the labeling job.
	//
	// LabelingJobStatus is a required field
	LabelingJobStatus *string `type:"string" required:"true" enum:"LabelingJobStatus"`

	// The date and time that the labeling job was last updated.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// The location of the job's output data and the AWS Key Management Service
	// key ID for the key used to encrypt the output data, if any.
	//
	// OutputConfig is a required field
	OutputConfig *LabelingJobOutputConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks
	// on your behalf during data labeling.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// A set of conditions for stopping a labeling job. If any of the conditions
	// are met, the job is automatically stopped.
	StoppingConditions *LabelingJobStoppingConditions `type:"structure"`

	// An array of key/value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s DescribeLabelingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLabelingJobOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLabelingJobOutput) SetCreationTime(v time.Time) *DescribeLabelingJobOutput {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeLabelingJobOutput) SetFailureReason(v string) *DescribeLabelingJobOutput {
	s.FailureReason = &v
	return s
}

// SetHumanTaskConfig sets the HumanTaskConfig field's value.
func (s *DescribeLabelingJobOutput) SetHumanTaskConfig(v *HumanTaskConfig) *DescribeLabelingJobOutput {
	s.HumanTaskConfig = v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *DescribeLabelingJobOutput) SetInputConfig(v *LabelingJobInputConfig) *DescribeLabelingJobOutput {
	s.InputConfig = v
	return s
}

// SetJobReferenceCode sets the JobReferenceCode field's value.
func (s *DescribeLabelingJobOutput) SetJobReferenceCode(v string) *DescribeLabelingJobOutput {
	s.JobReferenceCode = &v
	return s
}

// SetLabelAttributeName sets the LabelAttributeName field's value.
func (s *DescribeLabelingJobOutput) SetLabelAttributeName(v string) *DescribeLabelingJobOutput {
	s.LabelAttributeName = &v
	return s
}

// SetLabelCategoryConfigS3Uri sets the LabelCategoryConfigS3Uri field's value.
func (s *DescribeLabelingJobOutput) SetLabelCategoryConfigS3Uri(v string) *DescribeLabelingJobOutput {
	s.LabelCategoryConfigS3Uri = &v
	return s
}

// SetLabelCounters sets the LabelCounters field's value.
func (s *DescribeLabelingJobOutput) SetLabelCounters(v *LabelCounters) *DescribeLabelingJobOutput {
	s.LabelCounters = v
	return s
}

// SetLabelingJobAlgorithmsConfig sets the LabelingJobAlgorithmsConfig field's value.
func (s *DescribeLabelingJobOutput) SetLabelingJobAlgorithmsConfig(v *LabelingJobAlgorithmsConfig) *DescribeLabelingJobOutput {
	s.LabelingJobAlgorithmsConfig = v
	return s
}

// SetLabelingJobArn sets the LabelingJobArn field's value.
func (s *DescribeLabelingJobOutput) SetLabelingJobArn(v string) *DescribeLabelingJobOutput {
	s.LabelingJobArn = &v
	return s
}

// SetLabelingJobName sets the LabelingJobName field's value.
func (s *DescribeLabelingJobOutput) SetLabelingJobName(v string) *DescribeLabelingJobOutput {
	s.LabelingJobName = &v
	return s
}

// SetLabelingJobOutput sets the LabelingJobOutput field's value.
func (s *DescribeLabelingJobOutput) SetLabelingJobOutput(v *LabelingJobOutput) *DescribeLabelingJobOutput {
	s.LabelingJobOutput = v
	return s
}

// SetLabelingJobStatus sets the LabelingJobStatus field's value.
func (s *DescribeLabelingJobOutput) SetLabelingJobStatus(v string) *DescribeLabelingJobOutput {
	s.LabelingJobStatus = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeLabelingJobOutput) SetLastModifiedTime(v time.Time) *DescribeLabelingJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *DescribeLabelingJobOutput) SetOutputConfig(v *LabelingJobOutputConfig) *DescribeLabelingJobOutput {
	s.OutputConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeLabelingJobOutput) SetRoleArn(v string) *DescribeLabelingJobOutput {
	s.RoleArn = &v
	return s
}

// SetStoppingConditions sets the StoppingConditions field's value.
func (s *DescribeLabelingJobOutput) SetStoppingConditions(v *LabelingJobStoppingConditions) *DescribeLabelingJobOutput {
	s.StoppingConditions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeLabelingJobOutput) SetTags(v []*Tag) *DescribeLabelingJobOutput {
	s.Tags = v
	return s
}

type DescribeModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the model.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DescribeModelInput) SetModelName(v string) *DescribeModelInput {
	s.ModelName = &v
	return s
}

type DescribeModelOutput struct {
	_ struct{} `type:"structure"`

	// The containers in the inference pipeline.
	Containers []*ContainerDefinition `type:"list"`

	// A timestamp that shows when the model was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// If True, no inbound or outbound network calls can be made to or from the
	// model container.
	EnableNetworkIsolation *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// model.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the model.
	//
	// ModelArn is a required field
	ModelArn *string `min:"20" type:"string" required:"true"`

	// Name of the Amazon SageMaker model.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// The location of the primary inference code, associated artifacts, and custom
	// environment map that the inference code uses when it is deployed in production.
	PrimaryContainer *ContainerDefinition `type:"structure"`

	// A VpcConfig object that specifies the VPC that this model has access to.
	// For more information, see Protect Endpoints by Using an Amazon Virtual Private
	// Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s DescribeModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelOutput) GoString() string {
	return s.String()
}

// SetContainers sets the Containers field's value.
func (s *DescribeModelOutput) SetContainers(v []*ContainerDefinition) *DescribeModelOutput {
	s.Containers = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeModelOutput) SetCreationTime(v time.Time) *DescribeModelOutput {
	s.CreationTime = &v
	return s
}

// SetEnableNetworkIsolation sets the EnableNetworkIsolation field's value.
func (s *DescribeModelOutput) SetEnableNetworkIsolation(v bool) *DescribeModelOutput {
	s.EnableNetworkIsolation = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *DescribeModelOutput) SetExecutionRoleArn(v string) *DescribeModelOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *DescribeModelOutput) SetModelArn(v string) *DescribeModelOutput {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *DescribeModelOutput) SetModelName(v string) *DescribeModelOutput {
	s.ModelName = &v
	return s
}

// SetPrimaryContainer sets the PrimaryContainer field's value.
func (s *DescribeModelOutput) SetPrimaryContainer(v *ContainerDefinition) *DescribeModelOutput {
	s.PrimaryContainer = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DescribeModelOutput) SetVpcConfig(v *VpcConfig) *DescribeModelOutput {
	s.VpcConfig = v
	return s
}

type DescribeModelPackageInput struct {
	_ struct{} `type:"structure"`

	// The name of the model package to describe.
	//
	// ModelPackageName is a required field
	ModelPackageName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeModelPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeModelPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeModelPackageInput"}
	if s.ModelPackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelPackageName"))
	}
	if s.ModelPackageName != nil && len(*s.ModelPackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelPackageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelPackageName sets the ModelPackageName field's value.
func (s *DescribeModelPackageInput) SetModelPackageName(v string) *DescribeModelPackageInput {
	s.ModelPackageName = &v
	return s
}

type DescribeModelPackageOutput struct {
	_ struct{} `type:"structure"`

	// Whether the model package is certified for listing on AWS Marketplace.
	CertifyForMarketplace *bool `type:"boolean"`

	// A timestamp specifying when the model package was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Details about inference jobs that can be run with models based on this model
	// package.
	InferenceSpecification *InferenceSpecification `type:"structure"`

	// The Amazon Resource Name (ARN) of the model package.
	//
	// ModelPackageArn is a required field
	ModelPackageArn *string `min:"1" type:"string" required:"true"`

	// A brief summary of the model package.
	ModelPackageDescription *string `type:"string"`

	// The name of the model package being described.
	//
	// ModelPackageName is a required field
	ModelPackageName *string `min:"1" type:"string" required:"true"`

	// The current status of the model package.
	//
	// ModelPackageStatus is a required field
	ModelPackageStatus *string `type:"string" required:"true" enum:"ModelPackageStatus"`

	// Details about the current status of the model package.
	//
	// ModelPackageStatusDetails is a required field
	ModelPackageStatusDetails *ModelPackageStatusDetails `type:"structure" required:"true"`

	// Details about the algorithm that was used to create the model package.
	SourceAlgorithmSpecification *SourceAlgorithmSpecification `type:"structure"`

	// Configurations for one or more transform jobs that Amazon SageMaker runs
	// to test the model package.
	ValidationSpecification *ModelPackageValidationSpecification `type:"structure"`
}

// String returns the string representation
func (s DescribeModelPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelPackageOutput) GoString() string {
	return s.String()
}

// SetCertifyForMarketplace sets the CertifyForMarketplace field's value.
func (s *DescribeModelPackageOutput) SetCertifyForMarketplace(v bool) *DescribeModelPackageOutput {
	s.CertifyForMarketplace = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeModelPackageOutput) SetCreationTime(v time.Time) *DescribeModelPackageOutput {
	s.CreationTime = &v
	return s
}

// SetInferenceSpecification sets the InferenceSpecification field's value.
func (s *DescribeModelPackageOutput) SetInferenceSpecification(v *InferenceSpecification) *DescribeModelPackageOutput {
	s.InferenceSpecification = v
	return s
}

// SetModelPackageArn sets the ModelPackageArn field's value.
func (s *DescribeModelPackageOutput) SetModelPackageArn(v string) *DescribeModelPackageOutput {
	s.ModelPackageArn = &v
	return s
}

// SetModelPackageDescription sets the ModelPackageDescription field's value.
func (s *DescribeModelPackageOutput) SetModelPackageDescription(v string) *DescribeModelPackageOutput {
	s.ModelPackageDescription = &v
	return s
}

// SetModelPackageName sets the ModelPackageName field's value.
func (s *DescribeModelPackageOutput) SetModelPackageName(v string) *DescribeModelPackageOutput {
	s.ModelPackageName = &v
	return s
}

// SetModelPackageStatus sets the ModelPackageStatus field's value.
func (s *DescribeModelPackageOutput) SetModelPackageStatus(v string) *DescribeModelPackageOutput {
	s.ModelPackageStatus = &v
	return s
}

// SetModelPackageStatusDetails sets the ModelPackageStatusDetails field's value.
func (s *DescribeModelPackageOutput) SetModelPackageStatusDetails(v *ModelPackageStatusDetails) *DescribeModelPackageOutput {
	s.ModelPackageStatusDetails = v
	return s
}

// SetSourceAlgorithmSpecification sets the SourceAlgorithmSpecification field's value.
func (s *DescribeModelPackageOutput) SetSourceAlgorithmSpecification(v *SourceAlgorithmSpecification) *DescribeModelPackageOutput {
	s.SourceAlgorithmSpecification = v
	return s
}

// SetValidationSpecification sets the ValidationSpecification field's value.
func (s *DescribeModelPackageOutput) SetValidationSpecification(v *ModelPackageValidationSpecification) *DescribeModelPackageOutput {
	s.ValidationSpecification = v
	return s
}

type DescribeMonitoringScheduleInput struct {
	_ struct{} `type:"structure"`

	// Name of a previously created monitoring schedule.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMonitoringScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMonitoringScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMonitoringScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMonitoringScheduleInput"}
	if s.MonitoringScheduleName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitoringScheduleName"))
	}
	if s.MonitoringScheduleName != nil && len(*s.MonitoringScheduleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitoringScheduleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitoringScheduleName sets the MonitoringScheduleName field's value.
func (s *DescribeMonitoringScheduleInput) SetMonitoringScheduleName(v string) *DescribeMonitoringScheduleInput {
	s.MonitoringScheduleName = &v
	return s
}

type DescribeMonitoringScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the monitoring job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The name of the endpoint for the monitoring job.
	EndpointName *string `type:"string"`

	// A string, up to one KB in size, that contains the reason a monitoring job
	// failed, if it failed.
	FailureReason *string `type:"string"`

	// The time at which the monitoring job was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// Describes metadata on the last execution to run, if there was one.
	LastMonitoringExecutionSummary *MonitoringExecutionSummary `type:"structure"`

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	//
	// MonitoringScheduleArn is a required field
	MonitoringScheduleArn *string `type:"string" required:"true"`

	// The configuration object that specifies the monitoring schedule and defines
	// the monitoring job.
	//
	// MonitoringScheduleConfig is a required field
	MonitoringScheduleConfig *MonitoringScheduleConfig `type:"structure" required:"true"`

	// Name of the monitoring schedule.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`

	// The status of an monitoring job.
	//
	// MonitoringScheduleStatus is a required field
	MonitoringScheduleStatus *string `type:"string" required:"true" enum:"ScheduleStatus"`
}

// String returns the string representation
func (s DescribeMonitoringScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMonitoringScheduleOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeMonitoringScheduleOutput) SetCreationTime(v time.Time) *DescribeMonitoringScheduleOutput {
	s.CreationTime = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *DescribeMonitoringScheduleOutput) SetEndpointName(v string) *DescribeMonitoringScheduleOutput {
	s.EndpointName = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeMonitoringScheduleOutput) SetFailureReason(v string) *DescribeMonitoringScheduleOutput {
	s.FailureReason = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeMonitoringScheduleOutput) SetLastModifiedTime(v time.Time) *DescribeMonitoringScheduleOutput {
	s.LastModifiedTime = &v
	return s
}

// SetLastMonitoringExecutionSummary sets the LastMonitoringExecutionSummary field's value.
func (s *DescribeMonitoringScheduleOutput) SetLastMonitoringExecutionSummary(v *MonitoringExecutionSummary) *DescribeMonitoringScheduleOutput {
	s.LastMonitoringExecutionSummary = v
	return s
}

// SetMonitoringScheduleArn sets the MonitoringScheduleArn field's value.
func (s *DescribeMonitoringScheduleOutput) SetMonitoringScheduleArn(v string) *DescribeMonitoringScheduleOutput {
	s.MonitoringScheduleArn = &v
	return s
}

// SetMonitoringScheduleConfig sets the MonitoringScheduleConfig field's value.
func (s *DescribeMonitoringScheduleOutput) SetMonitoringScheduleConfig(v *MonitoringScheduleConfig) *DescribeMonitoringScheduleOutput {
	s.MonitoringScheduleConfig = v
	return s
}

// SetMonitoringScheduleName sets the MonitoringScheduleName field's value.
func (s *DescribeMonitoringScheduleOutput) SetMonitoringScheduleName(v string) *DescribeMonitoringScheduleOutput {
	s.MonitoringScheduleName = &v
	return s
}

// SetMonitoringScheduleStatus sets the MonitoringScheduleStatus field's value.
func (s *DescribeMonitoringScheduleOutput) SetMonitoringScheduleStatus(v string) *DescribeMonitoringScheduleOutput {
	s.MonitoringScheduleStatus = &v
	return s
}

type DescribeNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the notebook instance that you want information about.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotebookInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNotebookInstanceInput"}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *DescribeNotebookInstanceInput) SetNotebookInstanceName(v string) *DescribeNotebookInstanceInput {
	s.NotebookInstanceName = &v
	return s
}

type DescribeNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration to describe.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNotebookInstanceLifecycleConfigInput"}
	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *DescribeNotebookInstanceLifecycleConfigInput) SetNotebookInstanceLifecycleConfigName(v string) *DescribeNotebookInstanceLifecycleConfigInput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

type DescribeNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp that tells when the lifecycle configuration was created.
	CreationTime *time.Time `type:"timestamp"`

	// A timestamp that tells when the lifecycle configuration was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	NotebookInstanceLifecycleConfigArn *string `type:"string"`

	// The name of the lifecycle configuration.
	NotebookInstanceLifecycleConfigName *string `type:"string"`

	// The shell script that runs only once, when you create a notebook instance.
	OnCreate []*NotebookInstanceLifecycleHook `type:"list"`

	// The shell script that runs every time you start a notebook instance, including
	// when you create the notebook instance.
	OnStart []*NotebookInstanceLifecycleHook `type:"list"`
}

// String returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetCreationTime(v time.Time) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetLastModifiedTime(v time.Time) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.LastModifiedTime = &v
	return s
}

// SetNotebookInstanceLifecycleConfigArn sets the NotebookInstanceLifecycleConfigArn field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetNotebookInstanceLifecycleConfigArn(v string) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.NotebookInstanceLifecycleConfigArn = &v
	return s
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetNotebookInstanceLifecycleConfigName(v string) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

// SetOnCreate sets the OnCreate field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetOnCreate(v []*NotebookInstanceLifecycleHook) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.OnCreate = v
	return s
}

// SetOnStart sets the OnStart field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetOnStart(v []*NotebookInstanceLifecycleHook) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.OnStart = v
	return s
}

type DescribeNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A list of the Elastic Inference (EI) instance types associated with this
	// notebook instance. Currently only one EI instance type can be associated
	// with a notebook instance. For more information, see Using Elastic Inference
	// in Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
	AcceleratorTypes []*string `type:"list"`

	// An array of up to three Git repositories associated with the notebook instance.
	// These can be either the names of Git repositories stored as resources in
	// your account, or the URL of Git repositories in AWS CodeCommit (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
	// or in any other Git repository. These repositories are cloned at the same
	// level as the default repository of your notebook instance. For more information,
	// see Associating Git Repositories with Amazon SageMaker Notebook Instances
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	AdditionalCodeRepositories []*string `type:"list"`

	// A timestamp. Use this parameter to return the time when the notebook instance
	// was created
	CreationTime *time.Time `type:"timestamp"`

	// The Git repository associated with the notebook instance as its default code
	// repository. This can be either the name of a Git repository stored as a resource
	// in your account, or the URL of a Git repository in AWS CodeCommit (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
	// or in any other Git repository. When you open a notebook instance, it opens
	// in the directory that contains this repository. For more information, see
	// Associating Git Repositories with Amazon SageMaker Notebook Instances (https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	DefaultCodeRepository *string `min:"1" type:"string"`

	// Describes whether Amazon SageMaker provides internet access to the notebook
	// instance. If this value is set to Disabled, the notebook instance does not
	// have internet access, and cannot connect to Amazon SageMaker training and
	// endpoint services.
	//
	// For more information, see Notebook Instances Are Internet-Enabled by Default
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access).
	DirectInternetAccess *string `type:"string" enum:"DirectInternetAccess"`

	// If status is Failed, the reason it failed.
	FailureReason *string `type:"string"`

	// The type of ML compute instance running on the notebook instance.
	InstanceType *string `type:"string" enum:"InstanceType"`

	// The AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it
	// on the ML storage volume attached to the instance.
	KmsKeyId *string `type:"string"`

	// A timestamp. Use this parameter to retrieve the time when the notebook instance
	// was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The network interface IDs that Amazon SageMaker created at the time of creating
	// the instance.
	NetworkInterfaceId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the notebook instance.
	NotebookInstanceArn *string `type:"string"`

	// Returns the name of a notebook instance lifecycle configuration.
	//
	// For information about notebook instance lifestyle configurations, see Step
	// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html)
	NotebookInstanceLifecycleConfigName *string `type:"string"`

	// The name of the Amazon SageMaker notebook instance.
	NotebookInstanceName *string `type:"string"`

	// The status of the notebook instance.
	NotebookInstanceStatus *string `type:"string" enum:"NotebookInstanceStatus"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the instance.
	RoleArn *string `min:"20" type:"string"`

	// Whether root access is enabled or disabled for users of the notebook instance.
	//
	// Lifecycle configurations need root access to be able to set up a notebook
	// instance. Because of this, lifecycle configurations associated with a notebook
	// instance always run with root access even if you disable root access for
	// users.
	RootAccess *string `type:"string" enum:"RootAccess"`

	// The IDs of the VPC security groups.
	SecurityGroups []*string `type:"list"`

	// The ID of the VPC subnet.
	SubnetId *string `type:"string"`

	// The URL that you use to connect to the Jupyter notebook that is running in
	// your notebook instance.
	Url *string `type:"string"`

	// The size, in GB, of the ML storage volume attached to the notebook instance.
	VolumeSizeInGB *int64 `min:"5" type:"integer"`
}

// String returns the string representation
func (s DescribeNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookInstanceOutput) GoString() string {
	return s.String()
}

// SetAcceleratorTypes sets the AcceleratorTypes field's value.
func (s *DescribeNotebookInstanceOutput) SetAcceleratorTypes(v []*string) *DescribeNotebookInstanceOutput {
	s.AcceleratorTypes = v
	return s
}

// SetAdditionalCodeRepositories sets the AdditionalCodeRepositories field's value.
func (s *DescribeNotebookInstanceOutput) SetAdditionalCodeRepositories(v []*string) *DescribeNotebookInstanceOutput {
	s.AdditionalCodeRepositories = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeNotebookInstanceOutput) SetCreationTime(v time.Time) *DescribeNotebookInstanceOutput {
	s.CreationTime = &v
	return s
}

// SetDefaultCodeRepository sets the DefaultCodeRepository field's value.
func (s *DescribeNotebookInstanceOutput) SetDefaultCodeRepository(v string) *DescribeNotebookInstanceOutput {
	s.DefaultCodeRepository = &v
	return s
}

// SetDirectInternetAccess sets the DirectInternetAccess field's value.
func (s *DescribeNotebookInstanceOutput) SetDirectInternetAccess(v string) *DescribeNotebookInstanceOutput {
	s.DirectInternetAccess = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeNotebookInstanceOutput) SetFailureReason(v string) *DescribeNotebookInstanceOutput {
	s.FailureReason = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeNotebookInstanceOutput) SetInstanceType(v string) *DescribeNotebookInstanceOutput {
	s.InstanceType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DescribeNotebookInstanceOutput) SetKmsKeyId(v string) *DescribeNotebookInstanceOutput {
	s.KmsKeyId = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeNotebookInstanceOutput) SetLastModifiedTime(v time.Time) *DescribeNotebookInstanceOutput {
	s.LastModifiedTime = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *DescribeNotebookInstanceOutput) SetNetworkInterfaceId(v string) *DescribeNotebookInstanceOutput {
	s.NetworkInterfaceId = &v
	return s
}

// SetNotebookInstanceArn sets the NotebookInstanceArn field's value.
func (s *DescribeNotebookInstanceOutput) SetNotebookInstanceArn(v string) *DescribeNotebookInstanceOutput {
	s.NotebookInstanceArn = &v
	return s
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *DescribeNotebookInstanceOutput) SetNotebookInstanceLifecycleConfigName(v string) *DescribeNotebookInstanceOutput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *DescribeNotebookInstanceOutput) SetNotebookInstanceName(v string) *DescribeNotebookInstanceOutput {
	s.NotebookInstanceName = &v
	return s
}

// SetNotebookInstanceStatus sets the NotebookInstanceStatus field's value.
func (s *DescribeNotebookInstanceOutput) SetNotebookInstanceStatus(v string) *DescribeNotebookInstanceOutput {
	s.NotebookInstanceStatus = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeNotebookInstanceOutput) SetRoleArn(v string) *DescribeNotebookInstanceOutput {
	s.RoleArn = &v
	return s
}

// SetRootAccess sets the RootAccess field's value.
func (s *DescribeNotebookInstanceOutput) SetRootAccess(v string) *DescribeNotebookInstanceOutput {
	s.RootAccess = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *DescribeNotebookInstanceOutput) SetSecurityGroups(v []*string) *DescribeNotebookInstanceOutput {
	s.SecurityGroups = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *DescribeNotebookInstanceOutput) SetSubnetId(v string) *DescribeNotebookInstanceOutput {
	s.SubnetId = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DescribeNotebookInstanceOutput) SetUrl(v string) *DescribeNotebookInstanceOutput {
	s.Url = &v
	return s
}

// SetVolumeSizeInGB sets the VolumeSizeInGB field's value.
func (s *DescribeNotebookInstanceOutput) SetVolumeSizeInGB(v int64) *DescribeNotebookInstanceOutput {
	s.VolumeSizeInGB = &v
	return s
}

type DescribeProcessingJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the processing job. The name must be unique within an AWS Region
	// in the AWS account.
	//
	// ProcessingJobName is a required field
	ProcessingJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProcessingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProcessingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProcessingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProcessingJobInput"}
	if s.ProcessingJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProcessingJobName"))
	}
	if s.ProcessingJobName != nil && len(*s.ProcessingJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProcessingJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProcessingJobName sets the ProcessingJobName field's value.
func (s *DescribeProcessingJobInput) SetProcessingJobName(v string) *DescribeProcessingJobInput {
	s.ProcessingJobName = &v
	return s
}

type DescribeProcessingJobOutput struct {
	_ struct{} `type:"structure"`

	// Configures the processing job to run a specified container image.
	//
	// AppSpecification is a required field
	AppSpecification *AppSpecification `type:"structure" required:"true"`

	// The ARN of an AutoML job associated with this processing job.
	AutoMLJobArn *string `min:"1" type:"string"`

	// The time at which the processing job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The environment variables set in the Docker container.
	Environment map[string]*string `type:"map"`

	// An optional string, up to one KB in size, that contains metadata from the
	// processing container when the processing job exits.
	ExitMessage *string `type:"string"`

	// The configuration information used to create an experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// A string, up to one KB in size, that contains the reason a processing job
	// failed, if it failed.
	FailureReason *string `type:"string"`

	// The time at which the processing job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The ARN of a monitoring schedule for an endpoint associated with this processing
	// job.
	MonitoringScheduleArn *string `type:"string"`

	// Networking options for a processing job.
	NetworkConfig *NetworkConfig `type:"structure"`

	// The time at which the processing job completed.
	ProcessingEndTime *time.Time `type:"timestamp"`

	// The inputs for a processing job.
	ProcessingInputs []*ProcessingInput `type:"list"`

	// The Amazon Resource Name (ARN) of the processing job.
	//
	// ProcessingJobArn is a required field
	ProcessingJobArn *string `type:"string" required:"true"`

	// The name of the processing job. The name must be unique within an AWS Region
	// in the AWS account.
	//
	// ProcessingJobName is a required field
	ProcessingJobName *string `min:"1" type:"string" required:"true"`

	// Provides the status of a processing job.
	//
	// ProcessingJobStatus is a required field
	ProcessingJobStatus *string `type:"string" required:"true" enum:"ProcessingJobStatus"`

	// Output configuration for the processing job.
	ProcessingOutputConfig *ProcessingOutputConfig `type:"structure"`

	// Identifies the resources, ML compute instances, and ML storage volumes to
	// deploy for a processing job. In distributed training, you specify more than
	// one instance.
	//
	// ProcessingResources is a required field
	ProcessingResources *ProcessingResources `type:"structure" required:"true"`

	// The time at which the processing job started.
	ProcessingStartTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume
	// to perform tasks on your behalf.
	RoleArn *string `min:"20" type:"string"`

	// The time limit for how long the processing job is allowed to run.
	StoppingCondition *ProcessingStoppingCondition `type:"structure"`

	// The ARN of a training job associated with this processing job.
	TrainingJobArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeProcessingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProcessingJobOutput) GoString() string {
	return s.String()
}

// SetAppSpecification sets the AppSpecification field's value.
func (s *DescribeProcessingJobOutput) SetAppSpecification(v *AppSpecification) *DescribeProcessingJobOutput {
	s.AppSpecification = v
	return s
}

// SetAutoMLJobArn sets the AutoMLJobArn field's value.
func (s *DescribeProcessingJobOutput) SetAutoMLJobArn(v string) *DescribeProcessingJobOutput {
	s.AutoMLJobArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeProcessingJobOutput) SetCreationTime(v time.Time) *DescribeProcessingJobOutput {
	s.CreationTime = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *DescribeProcessingJobOutput) SetEnvironment(v map[string]*string) *DescribeProcessingJobOutput {
	s.Environment = v
	return s
}

// SetExitMessage sets the ExitMessage field's value.
func (s *DescribeProcessingJobOutput) SetExitMessage(v string) *DescribeProcessingJobOutput {
	s.ExitMessage = &v
	return s
}

// SetExperimentConfig sets the ExperimentConfig field's value.
func (s *DescribeProcessingJobOutput) SetExperimentConfig(v *ExperimentConfig) *DescribeProcessingJobOutput {
	s.ExperimentConfig = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeProcessingJobOutput) SetFailureReason(v string) *DescribeProcessingJobOutput {
	s.FailureReason = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeProcessingJobOutput) SetLastModifiedTime(v time.Time) *DescribeProcessingJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetMonitoringScheduleArn sets the MonitoringScheduleArn field's value.
func (s *DescribeProcessingJobOutput) SetMonitoringScheduleArn(v string) *DescribeProcessingJobOutput {
	s.MonitoringScheduleArn = &v
	return s
}

// SetNetworkConfig sets the NetworkConfig field's value.
func (s *DescribeProcessingJobOutput) SetNetworkConfig(v *NetworkConfig) *DescribeProcessingJobOutput {
	s.NetworkConfig = v
	return s
}

// SetProcessingEndTime sets the ProcessingEndTime field's value.
func (s *DescribeProcessingJobOutput) SetProcessingEndTime(v time.Time) *DescribeProcessingJobOutput {
	s.ProcessingEndTime = &v
	return s
}

// SetProcessingInputs sets the ProcessingInputs field's value.
func (s *DescribeProcessingJobOutput) SetProcessingInputs(v []*ProcessingInput) *DescribeProcessingJobOutput {
	s.ProcessingInputs = v
	return s
}

// SetProcessingJobArn sets the ProcessingJobArn field's value.
func (s *DescribeProcessingJobOutput) SetProcessingJobArn(v string) *DescribeProcessingJobOutput {
	s.ProcessingJobArn = &v
	return s
}

// SetProcessingJobName sets the ProcessingJobName field's value.
func (s *DescribeProcessingJobOutput) SetProcessingJobName(v string) *DescribeProcessingJobOutput {
	s.ProcessingJobName = &v
	return s
}

// SetProcessingJobStatus sets the ProcessingJobStatus field's value.
func (s *DescribeProcessingJobOutput) SetProcessingJobStatus(v string) *DescribeProcessingJobOutput {
	s.ProcessingJobStatus = &v
	return s
}

// SetProcessingOutputConfig sets the ProcessingOutputConfig field's value.
func (s *DescribeProcessingJobOutput) SetProcessingOutputConfig(v *ProcessingOutputConfig) *DescribeProcessingJobOutput {
	s.ProcessingOutputConfig = v
	return s
}

// SetProcessingResources sets the ProcessingResources field's value.
func (s *DescribeProcessingJobOutput) SetProcessingResources(v *ProcessingResources) *DescribeProcessingJobOutput {
	s.ProcessingResources = v
	return s
}

// SetProcessingStartTime sets the ProcessingStartTime field's value.
func (s *DescribeProcessingJobOutput) SetProcessingStartTime(v time.Time) *DescribeProcessingJobOutput {
	s.ProcessingStartTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeProcessingJobOutput) SetRoleArn(v string) *DescribeProcessingJobOutput {
	s.RoleArn = &v
	return s
}

// SetStoppingCondition sets the StoppingCondition field's value.
func (s *DescribeProcessingJobOutput) SetStoppingCondition(v *ProcessingStoppingCondition) *DescribeProcessingJobOutput {
	s.StoppingCondition = v
	return s
}

// SetTrainingJobArn sets the TrainingJobArn field's value.
func (s *DescribeProcessingJobOutput) SetTrainingJobArn(v string) *DescribeProcessingJobOutput {
	s.TrainingJobArn = &v
	return s
}

type DescribeSubscribedWorkteamInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the subscribed work team to describe.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSubscribedWorkteamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubscribedWorkteamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSubscribedWorkteamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSubscribedWorkteamInput"}
	if s.WorkteamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkteamArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkteamArn sets the WorkteamArn field's value.
func (s *DescribeSubscribedWorkteamInput) SetWorkteamArn(v string) *DescribeSubscribedWorkteamInput {
	s.WorkteamArn = &v
	return s
}

type DescribeSubscribedWorkteamOutput struct {
	_ struct{} `type:"structure"`

	// A Workteam instance that contains information about the work team.
	//
	// SubscribedWorkteam is a required field
	SubscribedWorkteam *SubscribedWorkteam `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeSubscribedWorkteamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubscribedWorkteamOutput) GoString() string {
	return s.String()
}

// SetSubscribedWorkteam sets the SubscribedWorkteam field's value.
func (s *DescribeSubscribedWorkteamOutput) SetSubscribedWorkteam(v *SubscribedWorkteam) *DescribeSubscribedWorkteamOutput {
	s.SubscribedWorkteam = v
	return s
}

type DescribeTrainingJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the training job.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrainingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrainingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrainingJobInput"}
	if s.TrainingJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingJobName"))
	}
	if s.TrainingJobName != nil && len(*s.TrainingJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrainingJobName sets the TrainingJobName field's value.
func (s *DescribeTrainingJobInput) SetTrainingJobName(v string) *DescribeTrainingJobInput {
	s.TrainingJobName = &v
	return s
}

type DescribeTrainingJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about the algorithm used for training, and algorithm metadata.
	//
	// AlgorithmSpecification is a required field
	AlgorithmSpecification *AlgorithmSpecification `type:"structure" required:"true"`

	AutoMLJobArn *string `min:"1" type:"string"`

	// The billable time in seconds.
	//
	// You can calculate the savings from using managed spot training using the
	// formula (1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100. For example,
	// if BillableTimeInSeconds is 100 and TrainingTimeInSeconds is 500, the savings
	// is 80%.
	BillableTimeInSeconds *int64 `min:"1" type:"integer"`

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig `type:"structure"`

	// A timestamp that indicates when the training job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Configuration information for the debug hook parameters, collection configuration,
	// and storage paths.
	DebugHookConfig *DebugHookConfig `type:"structure"`

	// Configuration information for debugging rules.
	DebugRuleConfigurations []*DebugRuleConfiguration `type:"list"`

	// Status about the debug rule evaluation.
	DebugRuleEvaluationStatuses []*DebugRuleEvaluationStatus `type:"list"`

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use
	// a deep learning algorithms in distributed training.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// A Boolean indicating whether managed spot training is enabled (True) or not
	// (False).
	EnableManagedSpotTraining *bool `type:"boolean"`

	// If you want to allow inbound or outbound network calls, except for calls
	// between peers within a training cluster for distributed training, choose
	// True. If you enable network isolation for training jobs that are configured
	// to use a VPC, Amazon SageMaker downloads and uploads customer data and model
	// artifacts through the specified VPC, but the training container does not
	// have network access.
	EnableNetworkIsolation *bool `type:"boolean"`

	// Configuration for the experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// If the training job failed, the reason it failed.
	FailureReason *string `type:"string"`

	// A collection of MetricData objects that specify the names, values, and dates
	// and times that the training algorithm emitted to Amazon CloudWatch.
	FinalMetricDataList []*MetricData `type:"list"`

	// Algorithm-specific parameters.
	HyperParameters map[string]*string `type:"map"`

	// An array of Channel objects that describes each data input channel.
	InputDataConfig []*Channel `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling
	// job that created the transform or training job.
	LabelingJobArn *string `type:"string"`

	// A timestamp that indicates when the status of the training job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// Information about the Amazon S3 location that is configured for storing model
	// artifacts.
	//
	// ModelArtifacts is a required field
	ModelArtifacts *ModelArtifacts `type:"structure" required:"true"`

	// The S3 path where model artifacts that you configured when creating the job
	// are stored. Amazon SageMaker creates subfolders for model artifacts.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// Resources, including ML compute instances and ML storage volumes, that are
	// configured for model training.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// The AWS Identity and Access Management (IAM) role configured for the training
	// job.
	RoleArn *string `min:"20" type:"string"`

	// Provides detailed information about the state of the training job. For detailed
	// information on the secondary status of the training job, see StatusMessage
	// under SecondaryStatusTransition.
	//
	// Amazon SageMaker provides primary statuses and secondary statuses that apply
	// to each of them:
	//
	// InProgress
	//
	//    * Starting - Starting the training job.
	//
	//    * Downloading - An optional stage for algorithms that support File training
	//    input mode. It indicates that data is being downloaded to the ML storage
	//    volumes.
	//
	//    * Training - Training is in progress.
	//
	//    * Interrupted - The job stopped because the managed spot training instances
	//    were interrupted.
	//
	//    * Uploading - Training is complete and the model artifacts are being uploaded
	//    to the S3 location.
	//
	// Completed
	//
	//    * Completed - The training job has completed.
	//
	// Failed
	//
	//    * Failed - The training job has failed. The reason for the failure is
	//    returned in the FailureReason field of DescribeTrainingJobResponse.
	//
	// Stopped
	//
	//    * MaxRuntimeExceeded - The job stopped because it exceeded the maximum
	//    allowed runtime.
	//
	//    * MaxWaitTmeExceeded - The job stopped because it exceeded the maximum
	//    allowed wait time.
	//
	//    * Stopped - The training job has stopped.
	//
	// Stopping
	//
	//    * Stopping - Stopping the training job.
	//
	// Valid values for SecondaryStatus are subject to change.
	//
	// We no longer support the following secondary statuses:
	//
	//    * LaunchingMLInstances
	//
	//    * PreparingTrainingStack
	//
	//    * DownloadingTrainingImage
	//
	// SecondaryStatus is a required field
	SecondaryStatus *string `type:"string" required:"true" enum:"SecondaryStatus"`

	// A history of all of the secondary statuses that the training job has transitioned
	// through.
	SecondaryStatusTransitions []*SecondaryStatusTransition `type:"list"`

	// Specifies a limit to how long a model training job can run. It also specifies
	// the maximum time to wait for a spot instance. When the job reaches the time
	// limit, Amazon SageMaker ends the training job. Use this API to cap model
	// training costs.
	//
	// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts, so the results of training are not lost.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// Configuration of storage locations for TensorBoard output.
	TensorBoardOutputConfig *TensorBoardOutputConfig `type:"structure"`

	// Indicates the time when the training job ends on training instances. You
	// are billed for the time interval between the value of TrainingStartTime and
	// this time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker
	// detects a job failure.
	TrainingEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`

	// Name of the model training job.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// The status of the training job.
	//
	// Amazon SageMaker provides the following training job statuses:
	//
	//    * InProgress - The training is in progress.
	//
	//    * Completed - The training job has completed.
	//
	//    * Failed - The training job has failed. To see the reason for the failure,
	//    see the FailureReason field in the response to a DescribeTrainingJobResponse
	//    call.
	//
	//    * Stopping - The training job is stopping.
	//
	//    * Stopped - The training job has stopped.
	//
	// For more detailed information, see SecondaryStatus.
	//
	// TrainingJobStatus is a required field
	TrainingJobStatus *string `type:"string" required:"true" enum:"TrainingJobStatus"`

	// Indicates the time when the training job starts on training instances. You
	// are billed for the time interval between this time and the value of TrainingEndTime.
	// The start time in CloudWatch Logs might be later than this time. The difference
	// is due to the time it takes to download the training data and to the size
	// of the training container.
	TrainingStartTime *time.Time `type:"timestamp"`

	// The training time in seconds.
	TrainingTimeInSeconds *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the associated hyperparameter tuning job
	// if the training job was launched by a hyperparameter tuning job.
	TuningJobArn *string `type:"string"`

	// A VpcConfig object that specifies the VPC that this training job has access
	// to. For more information, see Protect Training Jobs by Using an Amazon Virtual
	// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s DescribeTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrainingJobOutput) GoString() string {
	return s.String()
}

// SetAlgorithmSpecification sets the AlgorithmSpecification field's value.
func (s *DescribeTrainingJobOutput) SetAlgorithmSpecification(v *AlgorithmSpecification) *DescribeTrainingJobOutput {
	s.AlgorithmSpecification = v
	return s
}

// SetAutoMLJobArn sets the AutoMLJobArn field's value.
func (s *DescribeTrainingJobOutput) SetAutoMLJobArn(v string) *DescribeTrainingJobOutput {
	s.AutoMLJobArn = &v
	return s
}

// SetBillableTimeInSeconds sets the BillableTimeInSeconds field's value.
func (s *DescribeTrainingJobOutput) SetBillableTimeInSeconds(v int64) *DescribeTrainingJobOutput {
	s.BillableTimeInSeconds = &v
	return s
}

// SetCheckpointConfig sets the CheckpointConfig field's value.
func (s *DescribeTrainingJobOutput) SetCheckpointConfig(v *CheckpointConfig) *DescribeTrainingJobOutput {
	s.CheckpointConfig = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeTrainingJobOutput) SetCreationTime(v time.Time) *DescribeTrainingJobOutput {
	s.CreationTime = &v
	return s
}

// SetDebugHookConfig sets the DebugHookConfig field's value.
func (s *DescribeTrainingJobOutput) SetDebugHookConfig(v *DebugHookConfig) *DescribeTrainingJobOutput {
	s.DebugHookConfig = v
	return s
}

// SetDebugRuleConfigurations sets the DebugRuleConfigurations field's value.
func (s *DescribeTrainingJobOutput) SetDebugRuleConfigurations(v []*DebugRuleConfiguration) *DescribeTrainingJobOutput {
	s.DebugRuleConfigurations = v
	return s
}

// SetDebugRuleEvaluationStatuses sets the DebugRuleEvaluationStatuses field's value.
func (s *DescribeTrainingJobOutput) SetDebugRuleEvaluationStatuses(v []*DebugRuleEvaluationStatus) *DescribeTrainingJobOutput {
	s.DebugRuleEvaluationStatuses = v
	return s
}

// SetEnableInterContainerTrafficEncryption sets the EnableInterContainerTrafficEncryption field's value.
func (s *DescribeTrainingJobOutput) SetEnableInterContainerTrafficEncryption(v bool) *DescribeTrainingJobOutput {
	s.EnableInterContainerTrafficEncryption = &v
	return s
}

// SetEnableManagedSpotTraining sets the EnableManagedSpotTraining field's value.
func (s *DescribeTrainingJobOutput) SetEnableManagedSpotTraining(v bool) *DescribeTrainingJobOutput {
	s.EnableManagedSpotTraining = &v
	return s
}

// SetEnableNetworkIsolation sets the EnableNetworkIsolation field's value.
func (s *DescribeTrainingJobOutput) SetEnableNetworkIsolation(v bool) *DescribeTrainingJobOutput {
	s.EnableNetworkIsolation = &v
	return s
}

// SetExperimentConfig sets the ExperimentConfig field's value.
func (s *DescribeTrainingJobOutput) SetExperimentConfig(v *ExperimentConfig) *DescribeTrainingJobOutput {
	s.ExperimentConfig = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeTrainingJobOutput) SetFailureReason(v string) *DescribeTrainingJobOutput {
	s.FailureReason = &v
	return s
}

// SetFinalMetricDataList sets the FinalMetricDataList field's value.
func (s *DescribeTrainingJobOutput) SetFinalMetricDataList(v []*MetricData) *DescribeTrainingJobOutput {
	s.FinalMetricDataList = v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *DescribeTrainingJobOutput) SetHyperParameters(v map[string]*string) *DescribeTrainingJobOutput {
	s.HyperParameters = v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DescribeTrainingJobOutput) SetInputDataConfig(v []*Channel) *DescribeTrainingJobOutput {
	s.InputDataConfig = v
	return s
}

// SetLabelingJobArn sets the LabelingJobArn field's value.
func (s *DescribeTrainingJobOutput) SetLabelingJobArn(v string) *DescribeTrainingJobOutput {
	s.LabelingJobArn = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeTrainingJobOutput) SetLastModifiedTime(v time.Time) *DescribeTrainingJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetModelArtifacts sets the ModelArtifacts field's value.
func (s *DescribeTrainingJobOutput) SetModelArtifacts(v *ModelArtifacts) *DescribeTrainingJobOutput {
	s.ModelArtifacts = v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DescribeTrainingJobOutput) SetOutputDataConfig(v *OutputDataConfig) *DescribeTrainingJobOutput {
	s.OutputDataConfig = v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *DescribeTrainingJobOutput) SetResourceConfig(v *ResourceConfig) *DescribeTrainingJobOutput {
	s.ResourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeTrainingJobOutput) SetRoleArn(v string) *DescribeTrainingJobOutput {
	s.RoleArn = &v
	return s
}

// SetSecondaryStatus sets the SecondaryStatus field's value.
func (s *DescribeTrainingJobOutput) SetSecondaryStatus(v string) *DescribeTrainingJobOutput {
	s.SecondaryStatus = &v
	return s
}

// SetSecondaryStatusTransitions sets the SecondaryStatusTransitions field's value.
func (s *DescribeTrainingJobOutput) SetSecondaryStatusTransitions(v []*SecondaryStatusTransition) *DescribeTrainingJobOutput {
	s.SecondaryStatusTransitions = v
	return s
}

// SetStoppingCondition sets the StoppingCondition field's value.
func (s *DescribeTrainingJobOutput) SetStoppingCondition(v *StoppingCondition) *DescribeTrainingJobOutput {
	s.StoppingCondition = v
	return s
}

// SetTensorBoardOutputConfig sets the TensorBoardOutputConfig field's value.
func (s *DescribeTrainingJobOutput) SetTensorBoardOutputConfig(v *TensorBoardOutputConfig) *DescribeTrainingJobOutput {
	s.TensorBoardOutputConfig = v
	return s
}

// SetTrainingEndTime sets the TrainingEndTime field's value.
func (s *DescribeTrainingJobOutput) SetTrainingEndTime(v time.Time) *DescribeTrainingJobOutput {
	s.TrainingEndTime = &v
	return s
}

// SetTrainingJobArn sets the TrainingJobArn field's value.
func (s *DescribeTrainingJobOutput) SetTrainingJobArn(v string) *DescribeTrainingJobOutput {
	s.TrainingJobArn = &v
	return s
}

// SetTrainingJobName sets the TrainingJobName field's value.
func (s *DescribeTrainingJobOutput) SetTrainingJobName(v string) *DescribeTrainingJobOutput {
	s.TrainingJobName = &v
	return s
}

// SetTrainingJobStatus sets the TrainingJobStatus field's value.
func (s *DescribeTrainingJobOutput) SetTrainingJobStatus(v string) *DescribeTrainingJobOutput {
	s.TrainingJobStatus = &v
	return s
}

// SetTrainingStartTime sets the TrainingStartTime field's value.
func (s *DescribeTrainingJobOutput) SetTrainingStartTime(v time.Time) *DescribeTrainingJobOutput {
	s.TrainingStartTime = &v
	return s
}

// SetTrainingTimeInSeconds sets the TrainingTimeInSeconds field's value.
func (s *DescribeTrainingJobOutput) SetTrainingTimeInSeconds(v int64) *DescribeTrainingJobOutput {
	s.TrainingTimeInSeconds = &v
	return s
}

// SetTuningJobArn sets the TuningJobArn field's value.
func (s *DescribeTrainingJobOutput) SetTuningJobArn(v string) *DescribeTrainingJobOutput {
	s.TuningJobArn = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DescribeTrainingJobOutput) SetVpcConfig(v *VpcConfig) *DescribeTrainingJobOutput {
	s.VpcConfig = v
	return s
}

type DescribeTransformJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the transform job that you want to view details of.
	//
	// TransformJobName is a required field
	TransformJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTransformJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTransformJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTransformJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTransformJobInput"}
	if s.TransformJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformJobName"))
	}
	if s.TransformJobName != nil && len(*s.TransformJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransformJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransformJobName sets the TransformJobName field's value.
func (s *DescribeTransformJobInput) SetTransformJobName(v string) *DescribeTransformJobInput {
	s.TransformJobName = &v
	return s
}

type DescribeTransformJobOutput struct {
	_ struct{} `type:"structure"`

	AutoMLJobArn *string `min:"1" type:"string"`

	// Specifies the number of records to include in a mini-batch for an HTTP inference
	// request. A record is a single unit of input data that inference can be made
	// on. For example, a single line in a CSV file is a record.
	//
	// To enable the batch strategy, you must set SplitType to Line, RecordIO, or
	// TFRecord.
	BatchStrategy *string `type:"string" enum:"BatchStrategy"`

	// A timestamp that shows when the transform Job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The data structure used to specify the data to be used for inference in a
	// batch transform job and to associate the data that is relevant to the prediction
	// results in the output. The input filter provided allows you to exclude input
	// data that is not needed for inference in a batch transform job. The output
	// filter provided allows you to include input data relevant to interpreting
	// the predictions in the output from the job. For more information, see Associate
	// Prediction Results with their Corresponding Input Records (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
	DataProcessing *DataProcessing `type:"structure"`

	// The environment variables to set in the Docker container. We support up to
	// 16 key and values entries in the map.
	Environment map[string]*string `type:"map"`

	// Configuration for the experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// If the transform job failed, FailureReason describes why it failed. A transform
	// job creates a log file, which includes error messages, and stores it as an
	// Amazon S3 object. For more information, see Log Amazon SageMaker Events with
	// Amazon CloudWatch (https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html).
	FailureReason *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling
	// job that created the transform or training job.
	LabelingJobArn *string `type:"string"`

	// The maximum number of parallel requests on each instance node that can be
	// launched in a transform job. The default value is 1.
	MaxConcurrentTransforms *int64 `type:"integer"`

	// The maximum payload size, in MB, used in the transform job.
	MaxPayloadInMB *int64 `type:"integer"`

	// The name of the model used in the transform job.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// Indicates when the transform job has been completed, or has stopped or failed.
	// You are billed for the time interval between this time and the value of TransformStartTime.
	TransformEndTime *time.Time `type:"timestamp"`

	// Describes the dataset to be transformed and the Amazon S3 location where
	// it is stored.
	//
	// TransformInput is a required field
	TransformInput *TransformInput `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the transform job.
	//
	// TransformJobArn is a required field
	TransformJobArn *string `type:"string" required:"true"`

	// The name of the transform job.
	//
	// TransformJobName is a required field
	TransformJobName *string `min:"1" type:"string" required:"true"`

	// The status of the transform job. If the transform job failed, the reason
	// is returned in the FailureReason field.
	//
	// TransformJobStatus is a required field
	TransformJobStatus *string `type:"string" required:"true" enum:"TransformJobStatus"`

	// Identifies the Amazon S3 location where you want Amazon SageMaker to save
	// the results from the transform job.
	TransformOutput *TransformOutput `type:"structure"`

	// Describes the resources, including ML instance types and ML instance count,
	// to use for the transform job.
	//
	// TransformResources is a required field
	TransformResources *TransformResources `type:"structure" required:"true"`

	// Indicates when the transform job starts on ML instances. You are billed for
	// the time interval between this time and the value of TransformEndTime.
	TransformStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeTransformJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTransformJobOutput) GoString() string {
	return s.String()
}

// SetAutoMLJobArn sets the AutoMLJobArn field's value.
func (s *DescribeTransformJobOutput) SetAutoMLJobArn(v string) *DescribeTransformJobOutput {
	s.AutoMLJobArn = &v
	return s
}

// SetBatchStrategy sets the BatchStrategy field's value.
func (s *DescribeTransformJobOutput) SetBatchStrategy(v string) *DescribeTransformJobOutput {
	s.BatchStrategy = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeTransformJobOutput) SetCreationTime(v time.Time) *DescribeTransformJobOutput {
	s.CreationTime = &v
	return s
}

// SetDataProcessing sets the DataProcessing field's value.
func (s *DescribeTransformJobOutput) SetDataProcessing(v *DataProcessing) *DescribeTransformJobOutput {
	s.DataProcessing = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *DescribeTransformJobOutput) SetEnvironment(v map[string]*string) *DescribeTransformJobOutput {
	s.Environment = v
	return s
}

// SetExperimentConfig sets the ExperimentConfig field's value.
func (s *DescribeTransformJobOutput) SetExperimentConfig(v *ExperimentConfig) *DescribeTransformJobOutput {
	s.ExperimentConfig = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeTransformJobOutput) SetFailureReason(v string) *DescribeTransformJobOutput {
	s.FailureReason = &v
	return s
}

// SetLabelingJobArn sets the LabelingJobArn field's value.
func (s *DescribeTransformJobOutput) SetLabelingJobArn(v string) *DescribeTransformJobOutput {
	s.LabelingJobArn = &v
	return s
}

// SetMaxConcurrentTransforms sets the MaxConcurrentTransforms field's value.
func (s *DescribeTransformJobOutput) SetMaxConcurrentTransforms(v int64) *DescribeTransformJobOutput {
	s.MaxConcurrentTransforms = &v
	return s
}

// SetMaxPayloadInMB sets the MaxPayloadInMB field's value.
func (s *DescribeTransformJobOutput) SetMaxPayloadInMB(v int64) *DescribeTransformJobOutput {
	s.MaxPayloadInMB = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *DescribeTransformJobOutput) SetModelName(v string) *DescribeTransformJobOutput {
	s.ModelName = &v
	return s
}

// SetTransformEndTime sets the TransformEndTime field's value.
func (s *DescribeTransformJobOutput) SetTransformEndTime(v time.Time) *DescribeTransformJobOutput {
	s.TransformEndTime = &v
	return s
}

// SetTransformInput sets the TransformInput field's value.
func (s *DescribeTransformJobOutput) SetTransformInput(v *TransformInput) *DescribeTransformJobOutput {
	s.TransformInput = v
	return s
}

// SetTransformJobArn sets the TransformJobArn field's value.
func (s *DescribeTransformJobOutput) SetTransformJobArn(v string) *DescribeTransformJobOutput {
	s.TransformJobArn = &v
	return s
}

// SetTransformJobName sets the TransformJobName field's value.
func (s *DescribeTransformJobOutput) SetTransformJobName(v string) *DescribeTransformJobOutput {
	s.TransformJobName = &v
	return s
}

// SetTransformJobStatus sets the TransformJobStatus field's value.
func (s *DescribeTransformJobOutput) SetTransformJobStatus(v string) *DescribeTransformJobOutput {
	s.TransformJobStatus = &v
	return s
}

// SetTransformOutput sets the TransformOutput field's value.
func (s *DescribeTransformJobOutput) SetTransformOutput(v *TransformOutput) *DescribeTransformJobOutput {
	s.TransformOutput = v
	return s
}

// SetTransformResources sets the TransformResources field's value.
func (s *DescribeTransformJobOutput) SetTransformResources(v *TransformResources) *DescribeTransformJobOutput {
	s.TransformResources = v
	return s
}

// SetTransformStartTime sets the TransformStartTime field's value.
func (s *DescribeTransformJobOutput) SetTransformStartTime(v time.Time) *DescribeTransformJobOutput {
	s.TransformStartTime = &v
	return s
}

type DescribeTrialComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the trial component to describe.
	//
	// TrialComponentName is a required field
	TrialComponentName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTrialComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrialComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrialComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrialComponentInput"}
	if s.TrialComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialComponentName"))
	}
	if s.TrialComponentName != nil && len(*s.TrialComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialComponentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrialComponentName sets the TrialComponentName field's value.
func (s *DescribeTrialComponentInput) SetTrialComponentName(v string) *DescribeTrialComponentInput {
	s.TrialComponentName = &v
	return s
}

type DescribeTrialComponentOutput struct {
	_ struct{} `type:"structure"`

	// Who created the component.
	CreatedBy *UserContext `type:"structure"`

	// When the component was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the component as displayed. If DisplayName isn't specified, TrialComponentName
	// is displayed.
	DisplayName *string `min:"1" type:"string"`

	// When the component ended.
	EndTime *time.Time `type:"timestamp"`

	// The input artifacts of the component.
	InputArtifacts map[string]*TrialComponentArtifact `type:"map"`

	// Who last modified the component.
	LastModifiedBy *UserContext `type:"structure"`

	// When the component was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The metrics for the component.
	Metrics []*TrialComponentMetricSummary `type:"list"`

	// The output artifacts of the component.
	OutputArtifacts map[string]*TrialComponentArtifact `type:"map"`

	// The hyperparameters of the component.
	Parameters map[string]*TrialComponentParameterValue `type:"map"`

	// The Amazon Resource Name (ARN) of the source and, optionally, the job type.
	Source *TrialComponentSource `type:"structure"`

	// When the component started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the component. States include:
	//
	//    * InProgress
	//
	//    * Completed
	//
	//    * Failed
	Status *TrialComponentStatus `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string `type:"string"`

	// The name of the trial component.
	TrialComponentName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeTrialComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrialComponentOutput) GoString() string {
	return s.String()
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeTrialComponentOutput) SetCreatedBy(v *UserContext) *DescribeTrialComponentOutput {
	s.CreatedBy = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeTrialComponentOutput) SetCreationTime(v time.Time) *DescribeTrialComponentOutput {
	s.CreationTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeTrialComponentOutput) SetDisplayName(v string) *DescribeTrialComponentOutput {
	s.DisplayName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeTrialComponentOutput) SetEndTime(v time.Time) *DescribeTrialComponentOutput {
	s.EndTime = &v
	return s
}

// SetInputArtifacts sets the InputArtifacts field's value.
func (s *DescribeTrialComponentOutput) SetInputArtifacts(v map[string]*TrialComponentArtifact) *DescribeTrialComponentOutput {
	s.InputArtifacts = v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *DescribeTrialComponentOutput) SetLastModifiedBy(v *UserContext) *DescribeTrialComponentOutput {
	s.LastModifiedBy = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeTrialComponentOutput) SetLastModifiedTime(v time.Time) *DescribeTrialComponentOutput {
	s.LastModifiedTime = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *DescribeTrialComponentOutput) SetMetrics(v []*TrialComponentMetricSummary) *DescribeTrialComponentOutput {
	s.Metrics = v
	return s
}

// SetOutputArtifacts sets the OutputArtifacts field's value.
func (s *DescribeTrialComponentOutput) SetOutputArtifacts(v map[string]*TrialComponentArtifact) *DescribeTrialComponentOutput {
	s.OutputArtifacts = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeTrialComponentOutput) SetParameters(v map[string]*TrialComponentParameterValue) *DescribeTrialComponentOutput {
	s.Parameters = v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeTrialComponentOutput) SetSource(v *TrialComponentSource) *DescribeTrialComponentOutput {
	s.Source = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeTrialComponentOutput) SetStartTime(v time.Time) *DescribeTrialComponentOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTrialComponentOutput) SetStatus(v *TrialComponentStatus) *DescribeTrialComponentOutput {
	s.Status = v
	return s
}

// SetTrialComponentArn sets the TrialComponentArn field's value.
func (s *DescribeTrialComponentOutput) SetTrialComponentArn(v string) *DescribeTrialComponentOutput {
	s.TrialComponentArn = &v
	return s
}

// SetTrialComponentName sets the TrialComponentName field's value.
func (s *DescribeTrialComponentOutput) SetTrialComponentName(v string) *DescribeTrialComponentOutput {
	s.TrialComponentName = &v
	return s
}

type DescribeTrialInput struct {
	_ struct{} `type:"structure"`

	// The name of the trial to describe.
	//
	// TrialName is a required field
	TrialName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTrialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrialInput"}
	if s.TrialName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialName"))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrialName sets the TrialName field's value.
func (s *DescribeTrialInput) SetTrialName(v string) *DescribeTrialInput {
	s.TrialName = &v
	return s
}

type DescribeTrialOutput struct {
	_ struct{} `type:"structure"`

	// Who created the trial.
	CreatedBy *UserContext `type:"structure"`

	// When the trial was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the trial as displayed. If DisplayName isn't specified, TrialName
	// is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The name of the experiment the trial is part of.
	ExperimentName *string `min:"1" type:"string"`

	// Who last modified the trial.
	LastModifiedBy *UserContext `type:"structure"`

	// When the trial was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the source and, optionally, the job type.
	Source *TrialSource `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string `type:"string"`

	// The name of the trial.
	TrialName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeTrialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrialOutput) GoString() string {
	return s.String()
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeTrialOutput) SetCreatedBy(v *UserContext) *DescribeTrialOutput {
	s.CreatedBy = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeTrialOutput) SetCreationTime(v time.Time) *DescribeTrialOutput {
	s.CreationTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeTrialOutput) SetDisplayName(v string) *DescribeTrialOutput {
	s.DisplayName = &v
	return s
}

// SetExperimentName sets the ExperimentName field's value.
func (s *DescribeTrialOutput) SetExperimentName(v string) *DescribeTrialOutput {
	s.ExperimentName = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *DescribeTrialOutput) SetLastModifiedBy(v *UserContext) *DescribeTrialOutput {
	s.LastModifiedBy = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeTrialOutput) SetLastModifiedTime(v time.Time) *DescribeTrialOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeTrialOutput) SetSource(v *TrialSource) *DescribeTrialOutput {
	s.Source = v
	return s
}

// SetTrialArn sets the TrialArn field's value.
func (s *DescribeTrialOutput) SetTrialArn(v string) *DescribeTrialOutput {
	s.TrialArn = &v
	return s
}

// SetTrialName sets the TrialName field's value.
func (s *DescribeTrialOutput) SetTrialName(v string) *DescribeTrialOutput {
	s.TrialName = &v
	return s
}

type DescribeUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The user profile name.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserProfileInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.UserProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeUserProfileInput) SetDomainId(v string) *DescribeUserProfileInput {
	s.DomainId = &v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *DescribeUserProfileInput) SetUserProfileName(v string) *DescribeUserProfileInput {
	s.UserProfileName = &v
	return s
}

type DescribeUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// The homa Amazon Elastic File System (EFS) Uid.
	HomeEfsFileSystemUid *string `type:"string"`

	// The last modified time.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The SSO user identifier.
	SingleSignOnUserIdentifier *string `type:"string"`

	// The SSO user value.
	SingleSignOnUserValue *string `type:"string"`

	// The status.
	Status *string `type:"string" enum:"UserProfileStatus"`

	// The user profile Amazon Resource Name (ARN).
	UserProfileArn *string `type:"string"`

	// The user profile name.
	UserProfileName *string `type:"string"`

	// A collection of settings.
	UserSettings *UserSettings `type:"structure"`
}

// String returns the string representation
func (s DescribeUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfileOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeUserProfileOutput) SetCreationTime(v time.Time) *DescribeUserProfileOutput {
	s.CreationTime = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeUserProfileOutput) SetDomainId(v string) *DescribeUserProfileOutput {
	s.DomainId = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeUserProfileOutput) SetFailureReason(v string) *DescribeUserProfileOutput {
	s.FailureReason = &v
	return s
}

// SetHomeEfsFileSystemUid sets the HomeEfsFileSystemUid field's value.
func (s *DescribeUserProfileOutput) SetHomeEfsFileSystemUid(v string) *DescribeUserProfileOutput {
	s.HomeEfsFileSystemUid = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeUserProfileOutput) SetLastModifiedTime(v time.Time) *DescribeUserProfileOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSingleSignOnUserIdentifier sets the SingleSignOnUserIdentifier field's value.
func (s *DescribeUserProfileOutput) SetSingleSignOnUserIdentifier(v string) *DescribeUserProfileOutput {
	s.SingleSignOnUserIdentifier = &v
	return s
}

// SetSingleSignOnUserValue sets the SingleSignOnUserValue field's value.
func (s *DescribeUserProfileOutput) SetSingleSignOnUserValue(v string) *DescribeUserProfileOutput {
	s.SingleSignOnUserValue = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeUserProfileOutput) SetStatus(v string) *DescribeUserProfileOutput {
	s.Status = &v
	return s
}

// SetUserProfileArn sets the UserProfileArn field's value.
func (s *DescribeUserProfileOutput) SetUserProfileArn(v string) *DescribeUserProfileOutput {
	s.UserProfileArn = &v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *DescribeUserProfileOutput) SetUserProfileName(v string) *DescribeUserProfileOutput {
	s.UserProfileName = &v
	return s
}

// SetUserSettings sets the UserSettings field's value.
func (s *DescribeUserProfileOutput) SetUserSettings(v *UserSettings) *DescribeUserProfileOutput {
	s.UserSettings = v
	return s
}

type DescribeWorkforceInput struct {
	_ struct{} `type:"structure"`

	// The name of the private workforce whose access you want to restrict. WorkforceName
	// is automatically set to default when a workforce is created and cannot be
	// modified.
	//
	// WorkforceName is a required field
	WorkforceName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWorkforceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkforceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkforceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkforceInput"}
	if s.WorkforceName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkforceName"))
	}
	if s.WorkforceName != nil && len(*s.WorkforceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkforceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkforceName sets the WorkforceName field's value.
func (s *DescribeWorkforceInput) SetWorkforceName(v string) *DescribeWorkforceInput {
	s.WorkforceName = &v
	return s
}

type DescribeWorkforceOutput struct {
	_ struct{} `type:"structure"`

	// A single private workforce, which is automatically created when you create
	// your first private work team. You can create one private work force in each
	// AWS Region. By default, any workforce-related API operation used in a specific
	// region will apply to the workforce created in that region. To learn how to
	// create a private workforce, see Create a Private Workforce (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html).
	//
	// Workforce is a required field
	Workforce *Workforce `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkforceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkforceOutput) GoString() string {
	return s.String()
}

// SetWorkforce sets the Workforce field's value.
func (s *DescribeWorkforceOutput) SetWorkforce(v *Workforce) *DescribeWorkforceOutput {
	s.Workforce = v
	return s
}

type DescribeWorkteamInput struct {
	_ struct{} `type:"structure"`

	// The name of the work team to return a description of.
	//
	// WorkteamName is a required field
	WorkteamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWorkteamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkteamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkteamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkteamInput"}
	if s.WorkteamName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkteamName"))
	}
	if s.WorkteamName != nil && len(*s.WorkteamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkteamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkteamName sets the WorkteamName field's value.
func (s *DescribeWorkteamInput) SetWorkteamName(v string) *DescribeWorkteamInput {
	s.WorkteamName = &v
	return s
}

type DescribeWorkteamOutput struct {
	_ struct{} `type:"structure"`

	// A Workteam instance that contains information about the work team.
	//
	// Workteam is a required field
	Workteam *Workteam `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkteamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkteamOutput) GoString() string {
	return s.String()
}

// SetWorkteam sets the Workteam field's value.
func (s *DescribeWorkteamOutput) SetWorkteam(v *Workteam) *DescribeWorkteamOutput {
	s.Workteam = v
	return s
}

// Specifies weight and capacity values for a production variant.
type DesiredWeightAndCapacity struct {
	_ struct{} `type:"structure"`

	// The variant's capacity.
	DesiredInstanceCount *int64 `min:"1" type:"integer"`

	// The variant's weight.
	DesiredWeight *float64 `type:"float"`

	// The name of the variant to update.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DesiredWeightAndCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DesiredWeightAndCapacity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DesiredWeightAndCapacity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DesiredWeightAndCapacity"}
	if s.DesiredInstanceCount != nil && *s.DesiredInstanceCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DesiredInstanceCount", 1))
	}
	if s.VariantName == nil {
		invalidParams.Add(request.NewErrParamRequired("VariantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredInstanceCount sets the DesiredInstanceCount field's value.
func (s *DesiredWeightAndCapacity) SetDesiredInstanceCount(v int64) *DesiredWeightAndCapacity {
	s.DesiredInstanceCount = &v
	return s
}

// SetDesiredWeight sets the DesiredWeight field's value.
func (s *DesiredWeightAndCapacity) SetDesiredWeight(v float64) *DesiredWeightAndCapacity {
	s.DesiredWeight = &v
	return s
}

// SetVariantName sets the VariantName field's value.
func (s *DesiredWeightAndCapacity) SetVariantName(v string) *DesiredWeightAndCapacity {
	s.VariantName = &v
	return s
}

type DisassociateTrialComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component to disassociate from the trial.
	//
	// TrialComponentName is a required field
	TrialComponentName *string `min:"1" type:"string" required:"true"`

	// The name of the trial to disassociate from.
	//
	// TrialName is a required field
	TrialName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateTrialComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateTrialComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateTrialComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateTrialComponentInput"}
	if s.TrialComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialComponentName"))
	}
	if s.TrialComponentName != nil && len(*s.TrialComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialComponentName", 1))
	}
	if s.TrialName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialName"))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrialComponentName sets the TrialComponentName field's value.
func (s *DisassociateTrialComponentInput) SetTrialComponentName(v string) *DisassociateTrialComponentInput {
	s.TrialComponentName = &v
	return s
}

// SetTrialName sets the TrialName field's value.
func (s *DisassociateTrialComponentInput) SetTrialName(v string) *DisassociateTrialComponentInput {
	s.TrialName = &v
	return s
}

type DisassociateTrialComponentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string `type:"string"`

	// The ARN of the trial component.
	TrialComponentArn *string `type:"string"`
}

// String returns the string representation
func (s DisassociateTrialComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateTrialComponentOutput) GoString() string {
	return s.String()
}

// SetTrialArn sets the TrialArn field's value.
func (s *DisassociateTrialComponentOutput) SetTrialArn(v string) *DisassociateTrialComponentOutput {
	s.TrialArn = &v
	return s
}

// SetTrialComponentArn sets the TrialComponentArn field's value.
func (s *DisassociateTrialComponentOutput) SetTrialComponentArn(v string) *DisassociateTrialComponentOutput {
	s.TrialComponentArn = &v
	return s
}

// The domain's details.
type DomainDetails struct {
	_ struct{} `type:"structure"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// The domain's Amazon Resource Name (ARN).
	DomainArn *string `type:"string"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The domain name.
	DomainName *string `type:"string"`

	// The last modified time.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The status.
	Status *string `type:"string" enum:"DomainStatus"`

	// The domain's URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainDetails) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DomainDetails) SetCreationTime(v time.Time) *DomainDetails {
	s.CreationTime = &v
	return s
}

// SetDomainArn sets the DomainArn field's value.
func (s *DomainDetails) SetDomainArn(v string) *DomainDetails {
	s.DomainArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DomainDetails) SetDomainId(v string) *DomainDetails {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DomainDetails) SetDomainName(v string) *DomainDetails {
	s.DomainName = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DomainDetails) SetLastModifiedTime(v time.Time) *DomainDetails {
	s.LastModifiedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainDetails) SetStatus(v string) *DomainDetails {
	s.Status = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DomainDetails) SetUrl(v string) *DomainDetails {
	s.Url = &v
	return s
}

// Provides summary information for an endpoint configuration.
type EndpointConfigSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint configuration was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EndpointConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointConfigSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *EndpointConfigSummary) SetCreationTime(v time.Time) *EndpointConfigSummary {
	s.CreationTime = &v
	return s
}

// SetEndpointConfigArn sets the EndpointConfigArn field's value.
func (s *EndpointConfigSummary) SetEndpointConfigArn(v string) *EndpointConfigSummary {
	s.EndpointConfigArn = &v
	return s
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *EndpointConfigSummary) SetEndpointConfigName(v string) *EndpointConfigSummary {
	s.EndpointConfigName = &v
	return s
}

// Input object for the endpoint
type EndpointInput struct {
	_ struct{} `type:"structure"`

	// An endpoint in customer's account which has enabled DataCaptureConfig enabled.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// Path to the filesystem where the endpoint data is available to the container.
	//
	// LocalPath is a required field
	LocalPath *string `type:"string" required:"true"`

	// Whether input data distributed in Amazon S3 is fully replicated or sharded
	// by an S3 key. Defauts to FullyReplicated
	S3DataDistributionType *string `type:"string" enum:"ProcessingS3DataDistributionType"`

	// Whether the Pipe or File is used as the input mode for transfering data for
	// the monitoring job. Pipe mode is recommended for large datasets. File mode
	// is useful for small files that fit in memory. Defaults to File.
	S3InputMode *string `type:"string" enum:"ProcessingS3InputMode"`
}

// String returns the string representation
func (s EndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}
	if s.LocalPath == nil {
		invalidParams.Add(request.NewErrParamRequired("LocalPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *EndpointInput) SetEndpointName(v string) *EndpointInput {
	s.EndpointName = &v
	return s
}

// SetLocalPath sets the LocalPath field's value.
func (s *EndpointInput) SetLocalPath(v string) *EndpointInput {
	s.LocalPath = &v
	return s
}

// SetS3DataDistributionType sets the S3DataDistributionType field's value.
func (s *EndpointInput) SetS3DataDistributionType(v string) *EndpointInput {
	s.S3DataDistributionType = &v
	return s
}

// SetS3InputMode sets the S3InputMode field's value.
func (s *EndpointInput) SetS3InputMode(v string) *EndpointInput {
	s.S3InputMode = &v
	return s
}

// Provides summary information for an endpoint.
type EndpointSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The status of the endpoint.
	//
	//    * OutOfService: Endpoint is not available to take incoming requests.
	//
	//    * Creating: CreateEndpoint is executing.
	//
	//    * Updating: UpdateEndpoint or UpdateEndpointWeightsAndCapacities is executing.
	//
	//    * SystemUpdating: Endpoint is undergoing maintenance and cannot be updated
	//    or deleted or re-scaled until it has completed. This maintenance operation
	//    does not change any customer-specified values such as VPC config, KMS
	//    encryption, model, instance type, or instance count.
	//
	//    * RollingBack: Endpoint fails to scale up or down or change its variant
	//    weight and is in the process of rolling back to its previous configuration.
	//    Once the rollback completes, endpoint returns to an InService status.
	//    This transitional status only applies to an endpoint that has autoscaling
	//    enabled and is undergoing variant weight or capacity changes as part of
	//    an UpdateEndpointWeightsAndCapacities call or when the UpdateEndpointWeightsAndCapacities
	//    operation is called explicitly.
	//
	//    * InService: Endpoint is available to process incoming requests.
	//
	//    * Deleting: DeleteEndpoint is executing.
	//
	//    * Failed: Endpoint could not be created, updated, or re-scaled. Use DescribeEndpointOutput$FailureReason
	//    for information about the failure. DeleteEndpoint is the only operation
	//    that can be performed on a failed endpoint.
	//
	// To get a list of endpoints with a specified status, use the ListEndpointsInput$StatusEquals
	// filter.
	//
	// EndpointStatus is a required field
	EndpointStatus *string `type:"string" required:"true" enum:"EndpointStatus"`

	// A timestamp that shows when the endpoint was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s EndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *EndpointSummary) SetCreationTime(v time.Time) *EndpointSummary {
	s.CreationTime = &v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *EndpointSummary) SetEndpointArn(v string) *EndpointSummary {
	s.EndpointArn = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *EndpointSummary) SetEndpointName(v string) *EndpointSummary {
	s.EndpointName = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointSummary) SetEndpointStatus(v string) *EndpointSummary {
	s.EndpointStatus = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *EndpointSummary) SetLastModifiedTime(v time.Time) *EndpointSummary {
	s.LastModifiedTime = &v
	return s
}

// A summary of the properties of an experiment as returned by the Search API.
type Experiment struct {
	_ struct{} `type:"structure"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	CreatedBy *UserContext `type:"structure"`

	// When the experiment was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the experiment.
	Description *string `type:"string"`

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string `type:"string"`

	// The name of the experiment.
	ExperimentName *string `min:"1" type:"string"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	LastModifiedBy *UserContext `type:"structure"`

	// When the experiment was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The source of the experiment.
	Source *ExperimentSource `type:"structure"`

	// The list of tags that are associated with the experiment. You can use Search
	// API to search on the tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s Experiment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Experiment) GoString() string {
	return s.String()
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Experiment) SetCreatedBy(v *UserContext) *Experiment {
	s.CreatedBy = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Experiment) SetCreationTime(v time.Time) *Experiment {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Experiment) SetDescription(v string) *Experiment {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Experiment) SetDisplayName(v string) *Experiment {
	s.DisplayName = &v
	return s
}

// SetExperimentArn sets the ExperimentArn field's value.
func (s *Experiment) SetExperimentArn(v string) *Experiment {
	s.ExperimentArn = &v
	return s
}

// SetExperimentName sets the ExperimentName field's value.
func (s *Experiment) SetExperimentName(v string) *Experiment {
	s.ExperimentName = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *Experiment) SetLastModifiedBy(v *UserContext) *Experiment {
	s.LastModifiedBy = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Experiment) SetLastModifiedTime(v time.Time) *Experiment {
	s.LastModifiedTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Experiment) SetSource(v *ExperimentSource) *Experiment {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Experiment) SetTags(v []*Tag) *Experiment {
	s.Tags = v
	return s
}

// Configuration for the experiment.
type ExperimentConfig struct {
	_ struct{} `type:"structure"`

	// The name of the experiment.
	ExperimentName *string `min:"1" type:"string"`

	// Display name for the trial component.
	TrialComponentDisplayName *string `min:"1" type:"string"`

	// The name of the trial.
	TrialName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ExperimentConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExperimentConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExperimentConfig"}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentName", 1))
	}
	if s.TrialComponentDisplayName != nil && len(*s.TrialComponentDisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialComponentDisplayName", 1))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExperimentName sets the ExperimentName field's value.
func (s *ExperimentConfig) SetExperimentName(v string) *ExperimentConfig {
	s.ExperimentName = &v
	return s
}

// SetTrialComponentDisplayName sets the TrialComponentDisplayName field's value.
func (s *ExperimentConfig) SetTrialComponentDisplayName(v string) *ExperimentConfig {
	s.TrialComponentDisplayName = &v
	return s
}

// SetTrialName sets the TrialName field's value.
func (s *ExperimentConfig) SetTrialName(v string) *ExperimentConfig {
	s.TrialName = &v
	return s
}

// The source of the experiment.
type ExperimentSource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source.
	//
	// SourceArn is a required field
	SourceArn *string `type:"string" required:"true"`

	// The source type.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s ExperimentSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentSource) GoString() string {
	return s.String()
}

// SetSourceArn sets the SourceArn field's value.
func (s *ExperimentSource) SetSourceArn(v string) *ExperimentSource {
	s.SourceArn = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ExperimentSource) SetSourceType(v string) *ExperimentSource {
	s.SourceType = &v
	return s
}

// A summary of the properties of an experiment. To get the complete set of
// properties, call the DescribeExperiment API and provide the ExperimentName.
type ExperimentSummary struct {
	_ struct{} `type:"structure"`

	// When the experiment was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string `type:"string"`

	// The name of the experiment.
	ExperimentName *string `min:"1" type:"string"`

	// The source of the experiment.
	ExperimentSource *ExperimentSource `type:"structure"`

	// When the experiment was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ExperimentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExperimentSummary) SetCreationTime(v time.Time) *ExperimentSummary {
	s.CreationTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ExperimentSummary) SetDisplayName(v string) *ExperimentSummary {
	s.DisplayName = &v
	return s
}

// SetExperimentArn sets the ExperimentArn field's value.
func (s *ExperimentSummary) SetExperimentArn(v string) *ExperimentSummary {
	s.ExperimentArn = &v
	return s
}

// SetExperimentName sets the ExperimentName field's value.
func (s *ExperimentSummary) SetExperimentName(v string) *ExperimentSummary {
	s.ExperimentName = &v
	return s
}

// SetExperimentSource sets the ExperimentSource field's value.
func (s *ExperimentSummary) SetExperimentSource(v *ExperimentSource) *ExperimentSummary {
	s.ExperimentSource = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ExperimentSummary) SetLastModifiedTime(v time.Time) *ExperimentSummary {
	s.LastModifiedTime = &v
	return s
}

// Specifies a file system data source for a channel.
type FileSystemDataSource struct {
	_ struct{} `type:"structure"`

	// The full path to the directory to associate with the channel.
	//
	// DirectoryPath is a required field
	DirectoryPath *string `type:"string" required:"true"`

	// The access mode of the mount of the directory associated with the channel.
	// A directory can be mounted either in ro (read-only) or rw (read-write) mode.
	//
	// FileSystemAccessMode is a required field
	FileSystemAccessMode *string `type:"string" required:"true" enum:"FileSystemAccessMode"`

	// The file system id.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The file system type.
	//
	// FileSystemType is a required field
	FileSystemType *string `type:"string" required:"true" enum:"FileSystemType"`
}

// String returns the string representation
func (s FileSystemDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileSystemDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileSystemDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FileSystemDataSource"}
	if s.DirectoryPath == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryPath"))
	}
	if s.FileSystemAccessMode == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemAccessMode"))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.FileSystemType == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryPath sets the DirectoryPath field's value.
func (s *FileSystemDataSource) SetDirectoryPath(v string) *FileSystemDataSource {
	s.DirectoryPath = &v
	return s
}

// SetFileSystemAccessMode sets the FileSystemAccessMode field's value.
func (s *FileSystemDataSource) SetFileSystemAccessMode(v string) *FileSystemDataSource {
	s.FileSystemAccessMode = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *FileSystemDataSource) SetFileSystemId(v string) *FileSystemDataSource {
	s.FileSystemId = &v
	return s
}

// SetFileSystemType sets the FileSystemType field's value.
func (s *FileSystemDataSource) SetFileSystemType(v string) *FileSystemDataSource {
	s.FileSystemType = &v
	return s
}

// A conditional statement for a search expression that includes a resource
// property, a Boolean operator, and a value.
//
// If you don't specify an Operator and a Value, the filter searches for only
// the specified property. For example, defining a Filter for the FailureReason
// for the TrainingJob Resource searches for training job objects that have
// a value in the FailureReason field.
//
// If you specify a Value, but not an Operator, Amazon SageMaker uses the equals
// operator as the default.
//
// In search, there are several property types:
//
// Metrics
//
// To define a metric filter, enter a value using the form "Metrics.<name>",
// where <name> is a metric name. For example, the following filter searches
// for training jobs with an "accuracy" metric greater than "0.9":
//
// {
//
// "Name": "Metrics.accuracy",
//
// "Operator": "GREATER_THAN",
//
// "Value": "0.9"
//
// }
//
// HyperParameters
//
// To define a hyperparameter filter, enter a value with the form "HyperParameters.<name>".
// Decimal hyperparameter values are treated as a decimal in a comparison if
// the specified Value is also a decimal value. If the specified Value is an
// integer, the decimal hyperparameter values are treated as integers. For example,
// the following filter is satisfied by training jobs with a "learning_rate"
// hyperparameter that is less than "0.5":
//
// {
//
// "Name": "HyperParameters.learning_rate",
//
// "Operator": "LESS_THAN",
//
// "Value": "0.5"
//
// }
//
// Tags
//
// To define a tag filter, enter a value with the form "Tags.<key>".
type Filter struct {
	_ struct{} `type:"structure"`

	// A property name. For example, TrainingJobName. For the list of valid property
	// names returned in a search result for each supported resource, see TrainingJob
	// properties. You must specify a valid property name for the resource.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A Boolean binary operator that is used to evaluate the filter. The operator
	// field contains one of the following values:
	//
	// Equals
	//
	// The specified resource in Name equals the specified Value.
	//
	// NotEquals
	//
	// The specified resource in Name does not equal the specified Value.
	//
	// GreaterThan
	//
	// The specified resource in Name is greater than the specified Value. Not supported
	// for text-based properties.
	//
	// GreaterThanOrEqualTo
	//
	// The specified resource in Name is greater than or equal to the specified
	// Value. Not supported for text-based properties.
	//
	// LessThan
	//
	// The specified resource in Name is less than the specified Value. Not supported
	// for text-based properties.
	//
	// LessThanOrEqualTo
	//
	// The specified resource in Name is less than or equal to the specified Value.
	// Not supported for text-based properties.
	//
	// Contains
	//
	// Only supported for text-based properties. The word-list of the property contains
	// the specified Value. A SearchExpression can include only one Contains operator.
	//
	// If you have specified a filter Value, the default is Equals.
	Operator *string `type:"string" enum:"Operator"`

	// A value used with Resource and Operator to determine if objects satisfy the
	// filter's condition. For numerical properties, Value must be an integer or
	// floating-point decimal. For timestamp properties, Value must be an ISO 8601
	// date-time string of the following format: YYYY-mm-dd'T'HH:MM:SS.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *Filter) SetOperator(v string) *Filter {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Filter) SetValue(v string) *Filter {
	s.Value = &v
	return s
}

// The candidate result from a job.
type FinalAutoMLJobObjectiveMetric struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true" enum:"AutoMLMetricEnum"`

	// The metric type used.
	Type *string `type:"string" enum:"AutoMLJobObjectiveType"`

	// The value of the metric.
	//
	// Value is a required field
	Value *float64 `type:"float" required:"true"`
}

// String returns the string representation
func (s FinalAutoMLJobObjectiveMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FinalAutoMLJobObjectiveMetric) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *FinalAutoMLJobObjectiveMetric) SetMetricName(v string) *FinalAutoMLJobObjectiveMetric {
	s.MetricName = &v
	return s
}

// SetType sets the Type field's value.
func (s *FinalAutoMLJobObjectiveMetric) SetType(v string) *FinalAutoMLJobObjectiveMetric {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FinalAutoMLJobObjectiveMetric) SetValue(v float64) *FinalAutoMLJobObjectiveMetric {
	s.Value = &v
	return s
}

// Shows the final value for the objective metric for a training job that was
// launched by a hyperparameter tuning job. You define the objective metric
// in the HyperParameterTuningJobObjective parameter of HyperParameterTuningJobConfig.
type FinalHyperParameterTuningJobObjectiveMetric struct {
	_ struct{} `type:"structure"`

	// The name of the objective metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// Whether to minimize or maximize the objective metric. Valid values are Minimize
	// and Maximize.
	Type *string `type:"string" enum:"HyperParameterTuningJobObjectiveType"`

	// The value of the objective metric.
	//
	// Value is a required field
	Value *float64 `type:"float" required:"true"`
}

// String returns the string representation
func (s FinalHyperParameterTuningJobObjectiveMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FinalHyperParameterTuningJobObjectiveMetric) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *FinalHyperParameterTuningJobObjectiveMetric) SetMetricName(v string) *FinalHyperParameterTuningJobObjectiveMetric {
	s.MetricName = &v
	return s
}

// SetType sets the Type field's value.
func (s *FinalHyperParameterTuningJobObjectiveMetric) SetType(v string) *FinalHyperParameterTuningJobObjectiveMetric {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FinalHyperParameterTuningJobObjectiveMetric) SetValue(v float64) *FinalHyperParameterTuningJobObjectiveMetric {
	s.Value = &v
	return s
}

// Contains information about where human output will be stored.
type FlowDefinitionOutputConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Key Management Service (KMS) key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The Amazon S3 path where the object containing human output will be made
	// available.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FlowDefinitionOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowDefinitionOutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowDefinitionOutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowDefinitionOutputConfig"}
	if s.S3OutputPath == nil {
		invalidParams.Add(request.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *FlowDefinitionOutputConfig) SetKmsKeyId(v string) *FlowDefinitionOutputConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3OutputPath sets the S3OutputPath field's value.
func (s *FlowDefinitionOutputConfig) SetS3OutputPath(v string) *FlowDefinitionOutputConfig {
	s.S3OutputPath = &v
	return s
}

// Contains summary information about the flow definition.
type FlowDefinitionSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp when SageMaker created the flow definition.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The reason why the flow definition creation failed. A failure reason is returned
	// only when the flow definition status is Failed.
	FailureReason *string `type:"string"`

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// The name of the f