// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptInvitationRequest method.
//    req, resp := client.AcceptInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
func (c *SecurityHub) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInvitation API operation for AWS SecurityHub.
//
// Accepts the invitation to be a member account and be monitored by the Security
// Hub master account that the invitation was sent from.
//
// When the member account accepts the invitation, permission is granted to
// the master account to view findings generated in the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
func (c *SecurityHub) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisableStandards = "BatchDisableStandards"

// BatchDisableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisableStandards for more information on using the BatchDisableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisableStandardsRequest method.
//    req, resp := client.BatchDisableStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandardsRequest(input *BatchDisableStandardsInput) (req *request.Request, output *BatchDisableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchDisableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/deregister",
	}

	if input == nil {
		input = &BatchDisableStandardsInput{}
	}

	output = &BatchDisableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisableStandards API operation for AWS SecurityHub.
//
// Disables the standards specified by the provided StandardsSubscriptionArns.
//
// For more information, see Security Standards (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html)
// section of the AWS Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchDisableStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandards(input *BatchDisableStandardsInput) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	return out, req.Send()
}

// BatchDisableStandardsWithContext is the same as BatchDisableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchDisableStandardsWithContext(ctx aws.Context, input *BatchDisableStandardsInput, opts ...request.Option) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchEnableStandards = "BatchEnableStandards"

// BatchEnableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchEnableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchEnableStandards for more information on using the BatchEnableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchEnableStandardsRequest method.
//    req, resp := client.BatchEnableStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandardsRequest(input *BatchEnableStandardsInput) (req *request.Request, output *BatchEnableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchEnableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/register",
	}

	if input == nil {
		input = &BatchEnableStandardsInput{}
	}

	output = &BatchEnableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchEnableStandards API operation for AWS SecurityHub.
//
// Enables the standards specified by the provided StandardsArn. To obtain the
// ARN for a standard, use the DescribeStandards operation.
//
// For more information, see the Security Standards (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html)
// section of the AWS Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchEnableStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandards(input *BatchEnableStandardsInput) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	return out, req.Send()
}

// BatchEnableStandardsWithContext is the same as BatchEnableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchEnableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchEnableStandardsWithContext(ctx aws.Context, input *BatchEnableStandardsInput, opts ...request.Option) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchImportFindings = "BatchImportFindings"

// BatchImportFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchImportFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchImportFindings for more information on using the BatchImportFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchImportFindingsRequest method.
//    req, resp := client.BatchImportFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindingsRequest(input *BatchImportFindingsInput) (req *request.Request, output *BatchImportFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchImportFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/import",
	}

	if input == nil {
		input = &BatchImportFindingsInput{}
	}

	output = &BatchImportFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchImportFindings API operation for AWS SecurityHub.
//
// Imports security findings generated from an integrated third-party product
// into Security Hub. This action is requested by the integrated product to
// import its findings into Security Hub.
//
// The maximum allowed size for a finding is 240 Kb. An error is returned for
// any finding larger than 240 Kb.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchImportFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindings(input *BatchImportFindingsInput) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	return out, req.Send()
}

// BatchImportFindingsWithContext is the same as BatchImportFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchImportFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchImportFindingsWithContext(ctx aws.Context, input *BatchImportFindingsInput, opts ...request.Option) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateActionTarget = "CreateActionTarget"

// CreateActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the CreateActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateActionTarget for more information on using the CreateActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateActionTargetRequest method.
//    req, resp := client.CreateActionTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget
func (c *SecurityHub) CreateActionTargetRequest(input *CreateActionTargetInput) (req *request.Request, output *CreateActionTargetOutput) {
	op := &request.Operation{
		Name:       opCreateActionTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/actionTargets",
	}

	if input == nil {
		input = &CreateActionTargetInput{}
	}

	output = &CreateActionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateActionTarget API operation for AWS SecurityHub.
//
// Creates a custom action target in Security Hub.
//
// You can use custom actions on findings and insights in Security Hub to trigger
// target actions in Amazon CloudWatch Events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateActionTarget for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget
func (c *SecurityHub) CreateActionTarget(input *CreateActionTargetInput) (*CreateActionTargetOutput, error) {
	req, out := c.CreateActionTargetRequest(input)
	return out, req.Send()
}

// CreateActionTargetWithContext is the same as CreateActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateActionTargetWithContext(ctx aws.Context, input *CreateActionTargetInput, opts ...request.Option) (*CreateActionTargetOutput, error) {
	req, out := c.CreateActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInsight = "CreateInsight"

// CreateInsightRequest generates a "aws/request.Request" representing the
// client's request for the CreateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInsight for more information on using the CreateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInsightRequest method.
//    req, resp := client.CreateInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsightRequest(input *CreateInsightInput) (req *request.Request, output *CreateInsightOutput) {
	op := &request.Operation{
		Name:       opCreateInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
	}

	if input == nil {
		input = &CreateInsightInput{}
	}

	output = &CreateInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInsight API operation for AWS SecurityHub.
//
// Creates a custom insight in Security Hub. An insight is a consolidation of
// findings that relate to a security issue that requires attention or remediation.
//
// To group the related findings in the insight, use the GroupByAttribute.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateInsight for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsight(input *CreateInsightInput) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	return out, req.Send()
}

// CreateInsightWithContext is the same as CreateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateInsightWithContext(ctx aws.Context, input *CreateInsightInput, opts ...request.Option) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembers = "CreateMembers"

// CreateMembersRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembers for more information on using the CreateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMembersRequest method.
//    req, resp := client.CreateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembersRequest(input *CreateMembersInput) (req *request.Request, output *CreateMembersOutput) {
	op := &request.Operation{
		Name:       opCreateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members",
	}

	if input == nil {
		input = &CreateMembersInput{}
	}

	output = &CreateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembers API operation for AWS SecurityHub.
//
// Creates a member association in Security Hub between the specified accounts
// and the account used to make the request, which is the master account. To
// successfully create a member, you must use this action from an account that
// already has Security Hub enabled. To enable Security Hub, you can use the
// EnableSecurityHub operation.
//
// After you use CreateMembers to create member account associations in Security
// Hub, you must use the InviteMembers operation to invite the accounts to enable
// Security Hub and become member accounts in Security Hub.
//
// If the account owner accepts the invitation, the account becomes a member
// account in Security Hub, and a permission policy is added that permits the
// master account to view the findings generated in the member account. When
// Security Hub is enabled in the invited account, findings start to be sent
// to both the member and master accounts.
//
// To remove the association between the master and member accounts, use the
// DisassociateFromMasterAccount or DisassociateMembers operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembers(input *CreateMembersInput) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	return out, req.Send()
}

// CreateMembersWithContext is the same as CreateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateMembersWithContext(ctx aws.Context, input *CreateMembersInput, opts ...request.Option) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineInvitations = "DeclineInvitations"

// DeclineInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeclineInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeclineInvitations for more information on using the DeclineInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeclineInvitationsRequest method.
//    req, resp := client.DeclineInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitationsRequest(input *DeclineInvitationsInput) (req *request.Request, output *DeclineInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeclineInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/decline",
	}

	if input == nil {
		input = &DeclineInvitationsInput{}
	}

	output = &DeclineInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineInvitations API operation for AWS SecurityHub.
//
// Declines invitations to become a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeclineInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitations(input *DeclineInvitationsInput) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	return out, req.Send()
}

// DeclineInvitationsWithContext is the same as DeclineInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeclineInvitationsWithContext(ctx aws.Context, input *DeclineInvitationsInput, opts ...request.Option) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteActionTarget = "DeleteActionTarget"

// DeleteActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteActionTarget for more information on using the DeleteActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteActionTargetRequest method.
//    req, resp := client.DeleteActionTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget
func (c *SecurityHub) DeleteActionTargetRequest(input *DeleteActionTargetInput) (req *request.Request, output *DeleteActionTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteActionTarget,
		HTTPMethod: "DELETE",
		HTTPPath:   "/actionTargets/{ActionTargetArn+}",
	}

	if input == nil {
		input = &DeleteActionTargetInput{}
	}

	output = &DeleteActionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteActionTarget API operation for AWS SecurityHub.
//
// Deletes a custom action target from Security Hub.
//
// Deleting a custom action target does not affect any findings or insights
// that were already sent to Amazon CloudWatch Events using the custom action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteActionTarget for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget
func (c *SecurityHub) DeleteActionTarget(input *DeleteActionTargetInput) (*DeleteActionTargetOutput, error) {
	req, out := c.DeleteActionTargetRequest(input)
	return out, req.Send()
}

// DeleteActionTargetWithContext is the same as DeleteActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteActionTargetWithContext(ctx aws.Context, input *DeleteActionTargetInput, opts ...request.Option) (*DeleteActionTargetOutput, error) {
	req, out := c.DeleteActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInsight = "DeleteInsight"

// DeleteInsightRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInsight for more information on using the DeleteInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInsightRequest method.
//    req, resp := client.DeleteInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsightRequest(input *DeleteInsightInput) (req *request.Request, output *DeleteInsightOutput) {
	op := &request.Operation{
		Name:       opDeleteInsight,
		HTTPMethod: "DELETE",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &DeleteInsightInput{}
	}

	output = &DeleteInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInsight API operation for AWS SecurityHub.
//
// Deletes the insight specified by the InsightArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInsight for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsight(input *DeleteInsightInput) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	return out, req.Send()
}

// DeleteInsightWithContext is the same as DeleteInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInsightWithContext(ctx aws.Context, input *DeleteInsightInput, opts ...request.Option) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInvitations = "DeleteInvitations"

// DeleteInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInvitations for more information on using the DeleteInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInvitationsRequest method.
//    req, resp := client.DeleteInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitationsRequest(input *DeleteInvitationsInput) (req *request.Request, output *DeleteInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeleteInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/delete",
	}

	if input == nil {
		input = &DeleteInvitationsInput{}
	}

	output = &DeleteInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInvitations API operation for AWS SecurityHub.
//
// Deletes invitations received by the AWS account to become a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitations(input *DeleteInvitationsInput) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	return out, req.Send()
}

// DeleteInvitationsWithContext is the same as DeleteInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInvitationsWithContext(ctx aws.Context, input *DeleteInvitationsInput, opts ...request.Option) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembers for more information on using the DeleteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMembersRequest method.
//    req, resp := client.DeleteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembersRequest(input *DeleteMembersInput) (req *request.Request, output *DeleteMembersOutput) {
	op := &request.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/delete",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	output = &DeleteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMembers API operation for AWS SecurityHub.
//
// Deletes the specified member accounts from Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembers(input *DeleteMembersInput) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	return out, req.Send()
}

// DeleteMembersWithContext is the same as DeleteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteMembersWithContext(ctx aws.Context, input *DeleteMembersInput, opts ...request.Option) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActionTargets = "DescribeActionTargets"

// DescribeActionTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActionTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActionTargets for more information on using the DescribeActionTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeActionTargetsRequest method.
//    req, resp := client.DescribeActionTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets
func (c *SecurityHub) DescribeActionTargetsRequest(input *DescribeActionTargetsInput) (req *request.Request, output *DescribeActionTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeActionTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/actionTargets/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeActionTargetsInput{}
	}

	output = &DescribeActionTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActionTargets API operation for AWS SecurityHub.
//
// Returns a list of the custom action targets in Security Hub in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeActionTargets for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets
func (c *SecurityHub) DescribeActionTargets(input *DescribeActionTargetsInput) (*DescribeActionTargetsOutput, error) {
	req, out := c.DescribeActionTargetsRequest(input)
	return out, req.Send()
}

// DescribeActionTargetsWithContext is the same as DescribeActionTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActionTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeActionTargetsWithContext(ctx aws.Context, input *DescribeActionTargetsInput, opts ...request.Option) (*DescribeActionTargetsOutput, error) {
	req, out := c.DescribeActionTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeActionTargetsPages iterates over the pages of a DescribeActionTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeActionTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeActionTargets operation.
//    pageNum := 0
//    err := client.DescribeActionTargetsPages(params,
//        func(page *securityhub.DescribeActionTargetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeActionTargetsPages(input *DescribeActionTargetsInput, fn func(*DescribeActionTargetsOutput, bool) bool) error {
	return c.DescribeActionTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeActionTargetsPagesWithContext same as DescribeActionTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeActionTargetsPagesWithContext(ctx aws.Context, input *DescribeActionTargetsInput, fn func(*DescribeActionTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeActionTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeActionTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeActionTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHub = "DescribeHub"

// DescribeHubRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHub for more information on using the DescribeHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHubRequest method.
//    req, resp := client.DescribeHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub
func (c *SecurityHub) DescribeHubRequest(input *DescribeHubInput) (req *request.Request, output *DescribeHubOutput) {
	op := &request.Operation{
		Name:       opDescribeHub,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &DescribeHubInput{}
	}

	output = &DescribeHubOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHub API operation for AWS SecurityHub.
//
// Returns details about the Hub resource in your account, including the HubArn
// and the time when you enabled Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeHub for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub
func (c *SecurityHub) DescribeHub(input *DescribeHubInput) (*DescribeHubOutput, error) {
	req, out := c.DescribeHubRequest(input)
	return out, req.Send()
}

// DescribeHubWithContext is the same as DescribeHub with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeHubWithContext(ctx aws.Context, input *DescribeHubInput, opts ...request.Option) (*DescribeHubOutput, error) {
	req, out := c.DescribeHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProducts = "DescribeProducts"

// DescribeProductsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProducts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProducts for more information on using the DescribeProducts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProductsRequest method.
//    req, resp := client.DescribeProductsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts
func (c *SecurityHub) DescribeProductsRequest(input *DescribeProductsInput) (req *request.Request, output *DescribeProductsOutput) {
	op := &request.Operation{
		Name:       opDescribeProducts,
		HTTPMethod: "GET",
		HTTPPath:   "/products",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeProductsInput{}
	}

	output = &DescribeProductsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProducts API operation for AWS SecurityHub.
//
// Returns information about the available products that you can subscribe to
// and integrate with Security Hub in order to consolidate findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeProducts for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts
func (c *SecurityHub) DescribeProducts(input *DescribeProductsInput) (*DescribeProductsOutput, error) {
	req, out := c.DescribeProductsRequest(input)
	return out, req.Send()
}

// DescribeProductsWithContext is the same as DescribeProducts with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProducts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeProductsWithContext(ctx aws.Context, input *DescribeProductsInput, opts ...request.Option) (*DescribeProductsOutput, error) {
	req, out := c.DescribeProductsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeProductsPages iterates over the pages of a DescribeProducts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeProducts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeProducts operation.
//    pageNum := 0
//    err := client.DescribeProductsPages(params,
//        func(page *securityhub.DescribeProductsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeProductsPages(input *DescribeProductsInput, fn func(*DescribeProductsOutput, bool) bool) error {
	return c.DescribeProductsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeProductsPagesWithContext same as DescribeProductsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeProductsPagesWithContext(ctx aws.Context, input *DescribeProductsInput, fn func(*DescribeProductsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeProductsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeProductsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeProductsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStandards = "DescribeStandards"

// DescribeStandardsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStandards for more information on using the DescribeStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStandardsRequest method.
//    req, resp := client.DescribeStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards
func (c *SecurityHub) DescribeStandardsRequest(input *DescribeStandardsInput) (req *request.Request, output *DescribeStandardsOutput) {
	op := &request.Operation{
		Name:       opDescribeStandards,
		HTTPMethod: "GET",
		HTTPPath:   "/standards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStandardsInput{}
	}

	output = &DescribeStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStandards API operation for AWS SecurityHub.
//
// Returns a list of the available standards in Security Hub.
//
// For each standard, the results include the standard ARN, the name, and a
// description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards
func (c *SecurityHub) DescribeStandards(input *DescribeStandardsInput) (*DescribeStandardsOutput, error) {
	req, out := c.DescribeStandardsRequest(input)
	return out, req.Send()
}

// DescribeStandardsWithContext is the same as DescribeStandards with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsWithContext(ctx aws.Context, input *DescribeStandardsInput, opts ...request.Option) (*DescribeStandardsOutput, error) {
	req, out := c.DescribeStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStandardsPages iterates over the pages of a DescribeStandards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStandards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStandards operation.
//    pageNum := 0
//    err := client.DescribeStandardsPages(params,
//        func(page *securityhub.DescribeStandardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeStandardsPages(input *DescribeStandardsInput, fn func(*DescribeStandardsOutput, bool) bool) error {
	return c.DescribeStandardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStandardsPagesWithContext same as DescribeStandardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsPagesWithContext(ctx aws.Context, input *DescribeStandardsInput, fn func(*DescribeStandardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStandardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStandardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStandardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStandardsControls = "DescribeStandardsControls"

// DescribeStandardsControlsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStandardsControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStandardsControls for more information on using the DescribeStandardsControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStandardsControlsRequest method.
//    req, resp := client.DescribeStandardsControlsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls
func (c *SecurityHub) DescribeStandardsControlsRequest(input *DescribeStandardsControlsInput) (req *request.Request, output *DescribeStandardsControlsOutput) {
	op := &request.Operation{
		Name:       opDescribeStandardsControls,
		HTTPMethod: "GET",
		HTTPPath:   "/standards/controls/{StandardsSubscriptionArn+}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStandardsControlsInput{}
	}

	output = &DescribeStandardsControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStandardsControls API operation for AWS SecurityHub.
//
// Returns a list of security standards controls.
//
// For each control, the results include information about whether it is currently
// enabled, the severity, and a link to remediation information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeStandardsControls for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls
func (c *SecurityHub) DescribeStandardsControls(input *DescribeStandardsControlsInput) (*DescribeStandardsControlsOutput, error) {
	req, out := c.DescribeStandardsControlsRequest(input)
	return out, req.Send()
}

// DescribeStandardsControlsWithContext is the same as DescribeStandardsControls with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStandardsControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsControlsWithContext(ctx aws.Context, input *DescribeStandardsControlsInput, opts ...request.Option) (*DescribeStandardsControlsOutput, error) {
	req, out := c.DescribeStandardsControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStandardsControlsPages iterates over the pages of a DescribeStandardsControls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStandardsControls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStandardsControls operation.
//    pageNum := 0
//    err := client.DescribeStandardsControlsPages(params,
//        func(page *securityhub.DescribeStandardsControlsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeStandardsControlsPages(input *DescribeStandardsControlsInput, fn func(*DescribeStandardsControlsOutput, bool) bool) error {
	return c.DescribeStandardsControlsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStandardsControlsPagesWithContext same as DescribeStandardsControlsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsControlsPagesWithContext(ctx aws.Context, input *DescribeStandardsControlsInput, fn func(*DescribeStandardsControlsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStandardsControlsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStandardsControlsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStandardsControlsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisableImportFindingsForProduct = "DisableImportFindingsForProduct"

// DisableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the DisableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableImportFindingsForProduct for more information on using the DisableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableImportFindingsForProductRequest method.
//    req, resp := client.DisableImportFindingsForProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProductRequest(input *DisableImportFindingsForProductInput) (req *request.Request, output *DisableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opDisableImportFindingsForProduct,
		HTTPMethod: "DELETE",
		HTTPPath:   "/productSubscriptions/{ProductSubscriptionArn+}",
	}

	if input == nil {
		input = &DisableImportFindingsForProductInput{}
	}

	output = &DisableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Disables the integration of the specified product with Security Hub. After
// the integration is disabled, findings from that product are no longer sent
// to Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableImportFindingsForProduct for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProduct(input *DisableImportFindingsForProductInput) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// DisableImportFindingsForProductWithContext is the same as DisableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See DisableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableImportFindingsForProductWithContext(ctx aws.Context, input *DisableImportFindingsForProductInput, opts ...request.Option) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableSecurityHub = "DisableSecurityHub"

// DisableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the DisableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableSecurityHub for more information on using the DisableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableSecurityHubRequest method.
//    req, resp := client.DisableSecurityHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHubRequest(input *DisableSecurityHubInput) (req *request.Request, output *DisableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opDisableSecurityHub,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &DisableSecurityHubInput{}
	}

	output = &DisableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableSecurityHub API operation for AWS SecurityHub.
//
// Disables Security Hub in your account only in the current Region. To disable
// Security Hub in all Regions, you must submit one request per Region where
// you have enabled Security Hub.
//
// When you disable Security Hub for a master account, it doesn't disable Security
// Hub for any associated member accounts.
//
// When you disable Security Hub, your existing findings and insights and any
// Security Hub configuration settings are deleted after 90 days and cannot
// be recovered. Any standards that were enabled are disabled, and your master
// and member account associations are removed.
//
// If you want to save your existing findings, you must export them before you
// disable Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableSecurityHub for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHub(input *DisableSecurityHubInput) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	return out, req.Send()
}

// DisableSecurityHubWithContext is the same as DisableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See DisableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableSecurityHubWithContext(ctx aws.Context, input *DisableSecurityHubInput, opts ...request.Option) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromMasterAccount = "DisassociateFromMasterAccount"

// DisassociateFromMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromMasterAccount for more information on using the DisassociateFromMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFromMasterAccountRequest method.
//    req, resp := client.DisassociateFromMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
func (c *SecurityHub) DisassociateFromMasterAccountRequest(input *DisassociateFromMasterAccountInput) (req *request.Request, output *DisassociateFromMasterAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateFromMasterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/master/disassociate",
	}

	if input == nil {
		input = &DisassociateFromMasterAccountInput{}
	}

	output = &DisassociateFromMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFromMasterAccount API operation for AWS SecurityHub.
//
// Disassociates the current Security Hub member account from the associated
// master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateFromMasterAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
func (c *SecurityHub) DisassociateFromMasterAccount(input *DisassociateFromMasterAccountInput) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromMasterAccountWithContext is the same as DisassociateFromMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateFromMasterAccountWithContext(ctx aws.Context, input *DisassociateFromMasterAccountInput, opts ...request.Option) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMembers = "DisassociateMembers"

// DisassociateMembersRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMembers for more information on using the DisassociateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMembersRequest method.
//    req, resp := client.DisassociateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembersRequest(input *DisassociateMembersInput) (req *request.Request, output *DisassociateMembersOutput) {
	op := &request.Operation{
		Name:       opDisassociateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/disassociate",
	}

	if input == nil {
		input = &DisassociateMembersInput{}
	}

	output = &DisassociateMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMembers API operation for AWS SecurityHub.
//
// Disassociates the specified member accounts from the associated master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembers(input *DisassociateMembersInput) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	return out, req.Send()
}

// DisassociateMembersWithContext is the same as DisassociateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateMembersWithContext(ctx aws.Context, input *DisassociateMembersInput, opts ...request.Option) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableImportFindingsForProduct = "EnableImportFindingsForProduct"

// EnableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the EnableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableImportFindingsForProduct for more information on using the EnableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableImportFindingsForProductRequest method.
//    req, resp := client.EnableImportFindingsForProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProductRequest(input *EnableImportFindingsForProductInput) (req *request.Request, output *EnableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opEnableImportFindingsForProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/productSubscriptions",
	}

	if input == nil {
		input = &EnableImportFindingsForProductInput{}
	}

	output = &EnableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Enables the integration of a partner product with Security Hub. Integrated
// products send findings to Security Hub.
//
// When you enable a product integration, a permission policy that grants permission
// for the product to send findings to Security Hub is applied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableImportFindingsForProduct for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProduct(input *EnableImportFindingsForProductInput) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// EnableImportFindingsForProductWithContext is the same as EnableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See EnableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableImportFindingsForProductWithContext(ctx aws.Context, input *EnableImportFindingsForProductInput, opts ...request.Option) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSecurityHub = "EnableSecurityHub"

// EnableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the EnableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSecurityHub for more information on using the EnableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableSecurityHubRequest method.
//    req, resp := client.EnableSecurityHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHubRequest(input *EnableSecurityHubInput) (req *request.Request, output *EnableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opEnableSecurityHub,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &EnableSecurityHubInput{}
	}

	output = &EnableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableSecurityHub API operation for AWS SecurityHub.
//
// Enables Security Hub for your account in the current Region or the Region
// you specify in the request.
//
// When you enable Security Hub, you grant to Security Hub the permissions necessary
// to gather findings from AWS Config, Amazon GuardDuty, Amazon Inspector, and
// Amazon Macie.
//
// When you use the EnableSecurityHub operation to enable Security Hub, you
// also automatically enable the CIS AWS Foundations standard. You do not enable
// the Payment Card Industry Data Security Standard (PCI DSS) standard. To enable
// a standard, use the BatchEnableStandards operation. To disable a standard,
// use the BatchDisableStandards operation.
//
// To learn more, see Setting Up AWS Security Hub (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html)
// in the AWS Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableSecurityHub for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * AccessDeniedException
//   You don't have permission to perform the action specified in the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHub(input *EnableSecurityHubInput) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	return out, req.Send()
}

// EnableSecurityHubWithContext is the same as EnableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableSecurityHubWithContext(ctx aws.Context, input *EnableSecurityHubInput, opts ...request.Option) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnabledStandards = "GetEnabledStandards"

// GetEnabledStandardsRequest generates a "aws/request.Request" representing the
// client's request for the GetEnabledStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnabledStandards for more information on using the GetEnabledStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEnabledStandardsRequest method.
//    req, resp := client.GetEnabledStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandardsRequest(input *GetEnabledStandardsInput) (req *request.Request, output *GetEnabledStandardsOutput) {
	op := &request.Operation{
		Name:       opGetEnabledStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEnabledStandardsInput{}
	}

	output = &GetEnabledStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnabledStandards API operation for AWS SecurityHub.
//
// Returns a list of the standards that are currently enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetEnabledStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandards(input *GetEnabledStandardsInput) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	return out, req.Send()
}

// GetEnabledStandardsWithContext is the same as GetEnabledStandards with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnabledStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetEnabledStandardsWithContext(ctx aws.Context, input *GetEnabledStandardsInput, opts ...request.Option) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEnabledStandardsPages iterates over the pages of a GetEnabledStandards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEnabledStandards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetEnabledStandards operation.
//    pageNum := 0
//    err := client.GetEnabledStandardsPages(params,
//        func(page *securityhub.GetEnabledStandardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetEnabledStandardsPages(input *GetEnabledStandardsInput, fn func(*GetEnabledStandardsOutput, bool) bool) error {
	return c.GetEnabledStandardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEnabledStandardsPagesWithContext same as GetEnabledStandardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetEnabledStandardsPagesWithContext(ctx aws.Context, input *GetEnabledStandardsInput, fn func(*GetEnabledStandardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEnabledStandardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEnabledStandardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEnabledStandardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetFindings = "GetFindings"

// GetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindings for more information on using the GetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsRequest method.
//    req, resp := client.GetFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindingsRequest(input *GetFindingsInput) (req *request.Request, output *GetFindingsOutput) {
	op := &request.Operation{
		Name:       opGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	output = &GetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindings API operation for AWS SecurityHub.
//
// Returns a list of findings that match the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindings(input *GetFindingsInput) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	return out, req.Send()
}

// GetFindingsWithContext is the same as GetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsWithContext(ctx aws.Context, input *GetFindingsInput, opts ...request.Option) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFindingsPages iterates over the pages of a GetFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetFindings operation.
//    pageNum := 0
//    err := client.GetFindingsPages(params,
//        func(page *securityhub.GetFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetFindingsPages(input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool) error {
	return c.GetFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFindingsPagesWithContext same as GetFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsPagesWithContext(ctx aws.Context, input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInsightResults = "GetInsightResults"

// GetInsightResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsightResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsightResults for more information on using the GetInsightResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInsightResultsRequest method.
//    req, resp := client.GetInsightResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResultsRequest(input *GetInsightResultsInput) (req *request.Request, output *GetInsightResultsOutput) {
	op := &request.Operation{
		Name:       opGetInsightResults,
		HTTPMethod: "GET",
		HTTPPath:   "/insights/results/{InsightArn+}",
	}

	if input == nil {
		input = &GetInsightResultsInput{}
	}

	output = &GetInsightResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsightResults API operation for AWS SecurityHub.
//
// Lists the results of the Security Hub insight specified by the insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsightResults for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResults(input *GetInsightResultsInput) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	return out, req.Send()
}

// GetInsightResultsWithContext is the same as GetInsightResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsightResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightResultsWithContext(ctx aws.Context, input *GetInsightResultsInput, opts ...request.Option) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInsights = "GetInsights"

// GetInsightsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsights for more information on using the GetInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInsightsRequest method.
//    req, resp := client.GetInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsightsRequest(input *GetInsightsInput) (req *request.Request, output *GetInsightsOutput) {
	op := &request.Operation{
		Name:       opGetInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInsightsInput{}
	}

	output = &GetInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsights API operation for AWS SecurityHub.
//
// Lists and describes insights for the specified insight ARNs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsights for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsights(input *GetInsightsInput) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	return out, req.Send()
}

// GetInsightsWithContext is the same as GetInsights with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsWithContext(ctx aws.Context, input *GetInsightsInput, opts ...request.Option) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInsightsPages iterates over the pages of a GetInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetInsights operation.
//    pageNum := 0
//    err := client.GetInsightsPages(params,
//        func(page *securityhub.GetInsightsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetInsightsPages(input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool) error {
	return c.GetInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInsightsPagesWithContext same as GetInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsPagesWithContext(ctx aws.Context, input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInvitationsCount = "GetInvitationsCount"

// GetInvitationsCountRequest generates a "aws/request.Request" representing the
// client's request for the GetInvitationsCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvitationsCount for more information on using the GetInvitationsCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvitationsCountRequest method.
//    req, resp := client.GetInvitationsCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCountRequest(input *GetInvitationsCountInput) (req *request.Request, output *GetInvitationsCountOutput) {
	op := &request.Operation{
		Name:       opGetInvitationsCount,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations/count",
	}

	if input == nil {
		input = &GetInvitationsCountInput{}
	}

	output = &GetInvitationsCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvitationsCount API operation for AWS SecurityHub.
//
// Returns the count of all Security Hub membership invitations that were sent
// to the current member account, not including the currently accepted invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInvitationsCount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCount(input *GetInvitationsCountInput) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	return out, req.Send()
}

// GetInvitationsCountWithContext is the same as GetInvitationsCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvitationsCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInvitationsCountWithContext(ctx aws.Context, input *GetInvitationsCountInput, opts ...request.Option) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMasterAccount = "GetMasterAccount"

// GetMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMasterAccount for more information on using the GetMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMasterAccountRequest method.
//    req, resp := client.GetMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
func (c *SecurityHub) GetMasterAccountRequest(input *GetMasterAccountInput) (req *request.Request, output *GetMasterAccountOutput) {
	op := &request.Operation{
		Name:       opGetMasterAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &GetMasterAccountInput{}
	}

	output = &GetMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMasterAccount API operation for AWS SecurityHub.
//
// Provides the details for the Security Hub master account for the current
// member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMasterAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
func (c *SecurityHub) GetMasterAccount(input *GetMasterAccountInput) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	return out, req.Send()
}

// GetMasterAccountWithContext is the same as GetMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetMasterAccountWithContext(ctx aws.Context, input *GetMasterAccountInput, opts ...request.Option) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembers = "GetMembers"

// GetMembersRequest generates a "aws/request.Request" representing the
// client's request for the GetMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembers for more information on using the GetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMembersRequest method.
//    req, resp := client.GetMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembersRequest(input *GetMembersInput) (req *request.Request, output *GetMembersOutput) {
	op := &request.Operation{
		Name:       opGetMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/get",
	}

	if input == nil {
		input = &GetMembersInput{}
	}

	output = &GetMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembers API operation for AWS SecurityHub.
//
// Returns the details for the Security Hub member accounts for the specified
// account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembers(input *GetMembersInput) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	return out, req.Send()
}

// GetMembersWithContext is the same as GetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetMembersWithContext(ctx aws.Context, input *GetMembersInput, opts ...request.Option) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteMembers = "InviteMembers"

// InviteMembersRequest generates a "aws/request.Request" representing the
// client's request for the InviteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteMembers for more information on using the InviteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InviteMembersRequest method.
//    req, resp := client.InviteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembersRequest(input *InviteMembersInput) (req *request.Request, output *InviteMembersOutput) {
	op := &request.Operation{
		Name:       opInviteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/invite",
	}

	if input == nil {
		input = &InviteMembersInput{}
	}

	output = &InviteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteMembers API operation for AWS SecurityHub.
//
// Invites other AWS accounts to become member accounts for the Security Hub
// master account that the invitation is sent from.
//
// Before you can use this action to invite a member, you must first use the
// CreateMembers action to create the member account in Security Hub.
//
// When the account owner accepts the invitation to become a member account
// and enables Security Hub, the master account can view the findings generated
// from the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation InviteMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembers(input *InviteMembersInput) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	return out, req.Send()
}

// InviteMembersWithContext is the same as InviteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) InviteMembersWithContext(ctx aws.Context, input *InviteMembersInput, opts ...request.Option) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEnabledProductsForImport = "ListEnabledProductsForImport"

// ListEnabledProductsForImportRequest generates a "aws/request.Request" representing the
// client's request for the ListEnabledProductsForImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnabledProductsForImport for more information on using the ListEnabledProductsForImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEnabledProductsForImportRequest method.
//    req, resp := client.ListEnabledProductsForImportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImportRequest(input *ListEnabledProductsForImportInput) (req *request.Request, output *ListEnabledProductsForImportOutput) {
	op := &request.Operation{
		Name:       opListEnabledProductsForImport,
		HTTPMethod: "GET",
		HTTPPath:   "/productSubscriptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnabledProductsForImportInput{}
	}

	output = &ListEnabledProductsForImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnabledProductsForImport API operation for AWS SecurityHub.
//
// Lists all findings-generating solutions (products) that you are subscribed
// to receive findings from in Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListEnabledProductsForImport for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImport(input *ListEnabledProductsForImportInput) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	return out, req.Send()
}

// ListEnabledProductsForImportWithContext is the same as ListEnabledProductsForImport with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnabledProductsForImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, opts ...request.Option) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnabledProductsForImportPages iterates over the pages of a ListEnabledProductsForImport operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnabledProductsForImport method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEnabledProductsForImport operation.
//    pageNum := 0
//    err := client.ListEnabledProductsForImportPages(params,
//        func(page *securityhub.ListEnabledProductsForImportOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListEnabledProductsForImportPages(input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool) error {
	return c.ListEnabledProductsForImportPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnabledProductsForImportPagesWithContext same as ListEnabledProductsForImportPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportPagesWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnabledProductsForImportInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnabledProductsForImportRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnabledProductsForImportOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvitationsRequest method.
//    req, resp := client.ListInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for AWS SecurityHub.
//
// Lists all Security Hub membership invitations that were sent to the current
// AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvitations operation.
//    pageNum := 0
//    err := client.ListInvitationsPages(params,
//        func(page *securityhub.ListInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMembersRequest method.
//    req, resp := client.ListMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for AWS SecurityHub.
//
// Lists details about all member accounts for the current Security Hub master
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMembers operation.
//    pageNum := 0
//    err := client.ListMembersPages(params,
//        func(page *securityhub.ListMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource
func (c *SecurityHub) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS SecurityHub.
//
// Returns a list of tags associated with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource
func (c *SecurityHub) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource
func (c *SecurityHub) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS SecurityHub.
//
// Adds one or more tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource
func (c *SecurityHub) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource
func (c *SecurityHub) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS SecurityHub.
//
// Removes one or more tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource
func (c *SecurityHub) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateActionTarget = "UpdateActionTarget"

// UpdateActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateActionTarget for more information on using the UpdateActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateActionTargetRequest method.
//    req, resp := client.UpdateActionTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget
func (c *SecurityHub) UpdateActionTargetRequest(input *UpdateActionTargetInput) (req *request.Request, output *UpdateActionTargetOutput) {
	op := &request.Operation{
		Name:       opUpdateActionTarget,
		HTTPMethod: "PATCH",
		HTTPPath:   "/actionTargets/{ActionTargetArn+}",
	}

	if input == nil {
		input = &UpdateActionTargetInput{}
	}

	output = &UpdateActionTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateActionTarget API operation for AWS SecurityHub.
//
// Updates the name and description of a custom action target in Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateActionTarget for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget
func (c *SecurityHub) UpdateActionTarget(input *UpdateActionTargetInput) (*UpdateActionTargetOutput, error) {
	req, out := c.UpdateActionTargetRequest(input)
	return out, req.Send()
}

// UpdateActionTargetWithContext is the same as UpdateActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateActionTargetWithContext(ctx aws.Context, input *UpdateActionTargetInput, opts ...request.Option) (*UpdateActionTargetOutput, error) {
	req, out := c.UpdateActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindings = "UpdateFindings"

// UpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindings for more information on using the UpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingsRequest method.
//    req, resp := client.UpdateFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindingsRequest(input *UpdateFindingsInput) (req *request.Request, output *UpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings",
	}

	if input == nil {
		input = &UpdateFindingsInput{}
	}

	output = &UpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFindings API operation for AWS SecurityHub.
//
// Updates the Note and RecordState of the Security Hub-aggregated findings
// that the filter attributes specify. Any member account that can view the
// finding also sees the update to the finding.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindings(input *UpdateFindingsInput) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	return out, req.Send()
}

// UpdateFindingsWithContext is the same as UpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateFindingsWithContext(ctx aws.Context, input *UpdateFindingsInput, opts ...request.Option) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInsight = "UpdateInsight"

// UpdateInsightRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInsight for more information on using the UpdateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInsightRequest method.
//    req, resp := client.UpdateInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsightRequest(input *UpdateInsightInput) (req *request.Request, output *UpdateInsightOutput) {
	op := &request.Operation{
		Name:       opUpdateInsight,
		HTTPMethod: "PATCH",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &UpdateInsightInput{}
	}

	output = &UpdateInsightOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInsight API operation for AWS SecurityHub.
//
// Updates the Security Hub insight identified by the specified insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateInsight for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsight(input *UpdateInsightInput) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	return out, req.Send()
}

// UpdateInsightWithContext is the same as UpdateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateInsightWithContext(ctx aws.Context, input *UpdateInsightInput, opts ...request.Option) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStandardsControl = "UpdateStandardsControl"

// UpdateStandardsControlRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStandardsControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStandardsControl for more information on using the UpdateStandardsControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStandardsControlRequest method.
//    req, resp := client.UpdateStandardsControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl
func (c *SecurityHub) UpdateStandardsControlRequest(input *UpdateStandardsControlInput) (req *request.Request, output *UpdateStandardsControlOutput) {
	op := &request.Operation{
		Name:       opUpdateStandardsControl,
		HTTPMethod: "PATCH",
		HTTPPath:   "/standards/control/{StandardsControlArn+}",
	}

	if input == nil {
		input = &UpdateStandardsControlInput{}
	}

	output = &UpdateStandardsControlOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateStandardsControl API operation for AWS SecurityHub.
//
// Used to control whether an individual security standard control is enabled
// or disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateStandardsControl for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   AWS Security Hub isn't enabled for the account used to make this request.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl
func (c *SecurityHub) UpdateStandardsControl(input *UpdateStandardsControlInput) (*UpdateStandardsControlOutput, error) {
	req, out := c.UpdateStandardsControlRequest(input)
	return out, req.Send()
}

// UpdateStandardsControlWithContext is the same as UpdateStandardsControl with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStandardsControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateStandardsControlWithContext(ctx aws.Context, input *UpdateStandardsControlInput, opts ...request.Option) (*UpdateStandardsControlOutput, error) {
	req, out := c.UpdateStandardsControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the invitation sent from the Security Hub master account.
	//
	// InvitationId is a required field
	InvitationId *string `type:"string" required:"true"`

	// The account ID of the Security Hub master account that sent the invitation.
	//
	// MasterId is a required field
	MasterId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInvitationInput"}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}
	if s.MasterId == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptInvitationInput) SetInvitationId(v string) *AcceptInvitationInput {
	s.InvitationId = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *AcceptInvitationInput) SetMasterId(v string) *AcceptInvitationInput {
	s.MasterId = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// You don't have permission to perform the action specified in the request.
type AccessDeniedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s AccessDeniedException) OrigErr() error {
	return nil
}

func (s AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s AccessDeniedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s AccessDeniedException) RequestID() string {
	return s.respMetadata.RequestID
}

// The details of an AWS account.
type AccountDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS account.
	AccountId *string `type:"string"`

	// The email of an AWS account.
	Email *string `type:"string"`
}

// String returns the string representation
func (s AccountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountDetails) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountDetails) SetAccountId(v string) *AccountDetails {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *AccountDetails) SetEmail(v string) *AccountDetails {
	s.Email = &v
	return s
}

// An ActionTarget object.
type ActionTarget struct {
	_ struct{} `type:"structure"`

	// The ARN for the target action.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `type:"string" required:"true"`

	// The description of the target action.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the action target.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ActionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionTarget) GoString() string {
	return s.String()
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *ActionTarget) SetActionTargetArn(v string) *ActionTarget {
	s.ActionTargetArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ActionTarget) SetDescription(v string) *ActionTarget {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActionTarget) SetName(v string) *ActionTarget {
	s.Name = &v
	return s
}

// Information about an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The ID of the subnet. You can specify one subnet per Availability Zone.
	SubnetId *string `type:"string"`

	// The name of the Availability Zone.
	ZoneName *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *AvailabilityZone) SetSubnetId(v string) *AvailabilityZone {
	s.SubnetId = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *AvailabilityZone) SetZoneName(v string) *AvailabilityZone {
	s.ZoneName = &v
	return s
}

// A distribution configuration.
type AwsCloudFrontDistributionDetails struct {
	_ struct{} `type:"structure"`

	// The domain name corresponding to the distribution.
	DomainName *string `type:"string"`

	// The entity tag is a hash of the object.
	ETag *string `type:"string"`

	// The date and time that the distribution was last modified.
	LastModifiedTime *string `type:"string"`

	// A complex type that controls whether access logs are written for the distribution.
	Logging *AwsCloudFrontDistributionLogging `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	Origins *AwsCloudFrontDistributionOrigins `type:"structure"`

	// Indicates the current status of the distribution.
	Status *string `type:"string"`

	// A unique identifier that specifies the AWS WAF web ACL, if any, to associate
	// with this distribution.
	WebAclId *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionDetails) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCloudFrontDistributionDetails) SetDomainName(v string) *AwsCloudFrontDistributionDetails {
	s.DomainName = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *AwsCloudFrontDistributionDetails) SetETag(v string) *AwsCloudFrontDistributionDetails {
	s.ETag = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *AwsCloudFrontDistributionDetails) SetLastModifiedTime(v string) *AwsCloudFrontDistributionDetails {
	s.LastModifiedTime = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *AwsCloudFrontDistributionDetails) SetLogging(v *AwsCloudFrontDistributionLogging) *AwsCloudFrontDistributionDetails {
	s.Logging = v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *AwsCloudFrontDistributionDetails) SetOrigins(v *AwsCloudFrontDistributionOrigins) *AwsCloudFrontDistributionDetails {
	s.Origins = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCloudFrontDistributionDetails) SetStatus(v string) *AwsCloudFrontDistributionDetails {
	s.Status = &v
	return s
}

// SetWebAclId sets the WebAclId field's value.
func (s *AwsCloudFrontDistributionDetails) SetWebAclId(v string) *AwsCloudFrontDistributionDetails {
	s.WebAclId = &v
	return s
}

// A complex type that controls whether access logs are written for the distribution.
type AwsCloudFrontDistributionLogging struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in.
	Bucket *string `type:"string"`

	// With this field, you can enable or disable the selected distribution.
	Enabled *bool `type:"boolean"`

	// Specifies whether you want CloudFront to include cookies in access logs.
	IncludeCookies *bool `type:"boolean"`

	// An optional string that you want CloudFront to use as a prefix to the access
	// log filenames for this distribution.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionLogging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionLogging) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *AwsCloudFrontDistributionLogging) SetBucket(v string) *AwsCloudFrontDistributionLogging {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AwsCloudFrontDistributionLogging) SetEnabled(v bool) *AwsCloudFrontDistributionLogging {
	s.Enabled = &v
	return s
}

// SetIncludeCookies sets the IncludeCookies field's value.
func (s *AwsCloudFrontDistributionLogging) SetIncludeCookies(v bool) *AwsCloudFrontDistributionLogging {
	s.IncludeCookies = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *AwsCloudFrontDistributionLogging) SetPrefix(v string) *AwsCloudFrontDistributionLogging {
	s.Prefix = &v
	return s
}

// A complex type that describes the Amazon S3 bucket, HTTP server (for example,
// a web server), Amazon MediaStore, or other server from which CloudFront gets
// your files.
type AwsCloudFrontDistributionOriginItem struct {
	_ struct{} `type:"structure"`

	// Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want
	// CloudFront to get objects for this origin.
	DomainName *string `type:"string"`

	// A unique identifier for the origin or origin group.
	Id *string `type:"string"`

	// An optional element that causes CloudFront to request your content from a
	// directory in your Amazon S3 bucket or your custom origin.
	OriginPath *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOriginItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionOriginItem) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetDomainName(v string) *AwsCloudFrontDistributionOriginItem {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetId(v string) *AwsCloudFrontDistributionOriginItem {
	s.Id = &v
	return s
}

// SetOriginPath sets the OriginPath field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetOriginPath(v string) *AwsCloudFrontDistributionOriginItem {
	s.OriginPath = &v
	return s
}

// A complex type that contains information about origins and origin groups
// for this distribution.
type AwsCloudFrontDistributionOrigins struct {
	_ struct{} `type:"structure"`

	// A complex type that contains origins or origin groups for this distribution.
	Items []*AwsCloudFrontDistributionOriginItem `type:"list"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOrigins) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionOrigins) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOrigins) SetItems(v []*AwsCloudFrontDistributionOriginItem) *AwsCloudFrontDistributionOrigins {
	s.Items = v
	return s
}

// Information about an AWS CodeBuild project.
type AwsCodeBuildProjectDetails struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) used to
	// encrypt the build output artifacts.
	//
	// You can specify either the Amazon Resource Name (ARN) of the CMK or, if available,
	// the CMK alias (using the format alias/alias-name).
	EncryptionKey *string `type:"string"`

	// Information about the build environment for this build project.
	Environment *AwsCodeBuildProjectEnvironment `type:"structure"`

	// The name of the build project.
	Name *string `type:"string"`

	// The ARN of the IAM role that enables AWS CodeBuild to interact with dependent
	// AWS services on behalf of the AWS account.
	ServiceRole *string `type:"string"`

	// Information about the build input source code for this build project.
	Source *AwsCodeBuildProjectSource `type:"structure"`

	// Information about the VPC configuration that AWS CodeBuild accesses.
	VpcConfig *AwsCodeBuildProjectVpcConfig `type:"structure"`
}

// String returns the string representation
func (s AwsCodeBuildProjectDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectDetails) GoString() string {
	return s.String()
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *AwsCodeBuildProjectDetails) SetEncryptionKey(v string) *AwsCodeBuildProjectDetails {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *AwsCodeBuildProjectDetails) SetEnvironment(v *AwsCodeBuildProjectEnvironment) *AwsCodeBuildProjectDetails {
	s.Environment = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsCodeBuildProjectDetails) SetName(v string) *AwsCodeBuildProjectDetails {
	s.Name = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *AwsCodeBuildProjectDetails) SetServiceRole(v string) *AwsCodeBuildProjectDetails {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *AwsCodeBuildProjectDetails) SetSource(v *AwsCodeBuildProjectSource) *AwsCodeBuildProjectDetails {
	s.Source = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *AwsCodeBuildProjectDetails) SetVpcConfig(v *AwsCodeBuildProjectVpcConfig) *AwsCodeBuildProjectDetails {
	s.VpcConfig = v
	return s
}

// Information about the build environment for this build project.
type AwsCodeBuildProjectEnvironment struct {
	_ struct{} `type:"structure"`

	// The certificate to use with this build project.
	Certificate *string `type:"string"`

	// The type of credentials AWS CodeBuild uses to pull images in your build.
	//
	// Valid values:
	//
	//    * CODEBUILD specifies that AWS CodeBuild uses its own credentials. This
	//    requires that you modify your ECR repository policy to trust the AWS CodeBuild
	//    service principal.
	//
	//    * SERVICE_ROLE specifies that AWS CodeBuild uses your build project's
	//    service role.
	//
	// When you use a cross-account or private registry image, you must use SERVICE_ROLE
	// credentials. When you use an AWS CodeBuild curated image, you must use CODEBUILD
	// credentials.
	ImagePullCredentialsType *string `type:"string"`

	// The credentials for access to a private registry.
	RegistryCredential *AwsCodeBuildProjectEnvironmentRegistryCredential `type:"structure"`

	// The type of build environment to use for related builds.
	//
	// The environment type ARM_CONTAINER is available only in regions US East (N.
	// Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific
	// (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).
	//
	// The environment type LINUX_CONTAINER with compute type build.general1.2xlarge
	// is available only in regions US East (N. Virginia), US East (N. Virginia),
	// US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
	// (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore),
	// Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
	//
	// The environment type LINUX_GPU_CONTAINER is available only in regions US
	// East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central),
	// Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo),
	// Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney) , China
	// (Beijing), and China (Ningxia).
	//
	// Valid values: WINDOWS_CONTAINER | LINUX_CONTAINER | LINUX_GPU_CONTAINER |
	// ARM_CONTAINER
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectEnvironment) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *AwsCodeBuildProjectEnvironment) SetCertificate(v string) *AwsCodeBuildProjectEnvironment {
	s.Certificate = &v
	return s
}

// SetImagePullCredentialsType sets the ImagePullCredentialsType field's value.
func (s *AwsCodeBuildProjectEnvironment) SetImagePullCredentialsType(v string) *AwsCodeBuildProjectEnvironment {
	s.ImagePullCredentialsType = &v
	return s
}

// SetRegistryCredential sets the RegistryCredential field's value.
func (s *AwsCodeBuildProjectEnvironment) SetRegistryCredential(v *AwsCodeBuildProjectEnvironmentRegistryCredential) *AwsCodeBuildProjectEnvironment {
	s.RegistryCredential = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectEnvironment) SetType(v string) *AwsCodeBuildProjectEnvironment {
	s.Type = &v
	return s
}

// The credentials for access to a private registry.
type AwsCodeBuildProjectEnvironmentRegistryCredential struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or name of credentials created using AWS Secrets
	// Manager.
	//
	// The credential can use the name of the credentials only if they exist in
	// your current AWS Region.
	Credential *string `type:"string"`

	// The service that created the credentials to access a private Docker registry.
	//
	// The valid value,SECRETS_MANAGER, is for AWS Secrets Manager.
	CredentialProvider *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *AwsCodeBuildProjectEnvironmentRegistryCredential) SetCredential(v string) *AwsCodeBuildProjectEnvironmentRegistryCredential {
	s.Credential = &v
	return s
}

// SetCredentialProvider sets the CredentialProvider field's value.
func (s *AwsCodeBuildProjectEnvironmentRegistryCredential) SetCredentialProvider(v string) *AwsCodeBuildProjectEnvironmentRegistryCredential {
	s.CredentialProvider = &v
	return s
}

// Information about the build input source code for this build project.
type AwsCodeBuildProjectSource struct {
	_ struct{} `type:"structure"`

	// Information about the Git clone depth for the build project.
	GitCloneDepth *int64 `type:"integer"`

	// Whether to ignore SSL warnings while connecting to the project source code.
	InsecureSsl *bool `type:"boolean"`

	// Information about the location of the source code to be built.
	//
	// Valid values include:
	//
	//    * For source code settings that are specified in the source action of
	//    a pipeline in AWS CodePipeline, location should not be specified. If it
	//    is specified, AWS CodePipeline ignores it. This is because AWS CodePipeline
	//    uses the settings in a pipeline's source action instead of this value.
	//
	//    * For source code in an AWS CodeCommit repository, the HTTPS clone URL
	//    to the repository that contains the source code and the buildspec file
	//    (for example, https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name
	//    ).
	//
	//    * For source code in an S3 input bucket, one of the following. The path
	//    to the ZIP file that contains the source code (for example, bucket-name/path/to/object-name.zip).
	//    The path to the folder that contains the source code (for example, bucket-name/path/to/source-code/folder/).
	//
	//    * For source code in a GitHub repository, the HTTPS clone URL to the repository
	//    that contains the source and the buildspec file.
	//
	//    * For source code in a Bitbucket repository, the HTTPS clone URL to the
	//    repository that contains the source and the buildspec file.
	Location *string `type:"string"`

	// The type of repository that contains the source code to be built. Valid values
	// are:
	//
	//    * BITBUCKET - The source code is in a Bitbucket repository.
	//
	//    * CODECOMMIT - The source code is in an AWS CodeCommit repository.
	//
	//    * CODEPIPELINE - The source code settings are specified in the source
	//    action of a pipeline in AWS CodePipeline.
	//
	//    * GITHUB - The source code is in a GitHub repository.
	//
	//    * GITHUB_ENTERPRISE - The source code is in a GitHub Enterprise repository.
	//
	//    * NO_SOURCE - The project does not have input source code.
	//
	//    * S3 - The source code is in an S3 input bucket.
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectSource) GoString() string {
	return s.String()
}

// SetGitCloneDepth sets the GitCloneDepth field's value.
func (s *AwsCodeBuildProjectSource) SetGitCloneDepth(v int64) *AwsCodeBuildProjectSource {
	s.GitCloneDepth = &v
	return s
}

// SetInsecureSsl sets the InsecureSsl field's value.
func (s *AwsCodeBuildProjectSource) SetInsecureSsl(v bool) *AwsCodeBuildProjectSource {
	s.InsecureSsl = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *AwsCodeBuildProjectSource) SetLocation(v string) *AwsCodeBuildProjectSource {
	s.Location = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectSource) SetType(v string) *AwsCodeBuildProjectSource {
	s.Type = &v
	return s
}

// Information about the VPC configuration that AWS CodeBuild accesses.
type AwsCodeBuildProjectVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security group IDs in your Amazon VPC.
	SecurityGroupIds []*string `type:"list"`

	// A list of one or more subnet IDs in your Amazon VPC.
	Subnets []*string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectVpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetSecurityGroupIds(v []*string) *AwsCodeBuildProjectVpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetSubnets(v []*string) *AwsCodeBuildProjectVpcConfig {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetVpcId(v string) *AwsCodeBuildProjectVpcConfig {
	s.VpcId = &v
	return s
}

// The details of an Amazon EC2 instance.
type AwsEc2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The IAM profile ARN of the instance.
	IamInstanceProfileArn *string `type:"string"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ImageId *string `type:"string"`

	// The IPv4 addresses associated with the instance.
	IpV4Addresses []*string `type:"list"`

	// The IPv6 addresses associated with the instance.
	IpV6Addresses []*string `type:"list"`

	// The key name associated with the instance.
	KeyName *string `type:"string"`

	// The date/time the instance was launched.
	LaunchedAt *string `type:"string"`

	// The identifier of the subnet that the instance was launched in.
	SubnetId *string `type:"string"`

	// The instance type of the instance.
	Type *string `type:"string"`

	// The identifier of the VPC that the instance was launched in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2InstanceDetails) GoString() string {
	return s.String()
}

// SetIamInstanceProfileArn sets the IamInstanceProfileArn field's value.
func (s *AwsEc2InstanceDetails) SetIamInstanceProfileArn(v string) *AwsEc2InstanceDetails {
	s.IamInstanceProfileArn = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AwsEc2InstanceDetails) SetImageId(v string) *AwsEc2InstanceDetails {
	s.ImageId = &v
	return s
}

// SetIpV4Addresses sets the IpV4Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV4Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV4Addresses = v
	return s
}

// SetIpV6Addresses sets the IpV6Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV6Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV6Addresses = v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AwsEc2InstanceDetails) SetKeyName(v string) *AwsEc2InstanceDetails {
	s.KeyName = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *AwsEc2InstanceDetails) SetLaunchedAt(v string) *AwsEc2InstanceDetails {
	s.LaunchedAt = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2InstanceDetails) SetSubnetId(v string) *AwsEc2InstanceDetails {
	s.SubnetId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEc2InstanceDetails) SetType(v string) *AwsEc2InstanceDetails {
	s.Type = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2InstanceDetails) SetVpcId(v string) *AwsEc2InstanceDetails {
	s.VpcId = &v
	return s
}

// Information about the network interface attachment.
type AwsEc2NetworkInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// The timestamp indicating when the attachment initiated.
	AttachTime *string `type:"string"`

	// The identifier of the network interface attachment
	AttachmentId *string `type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The device index of the network interface attachment on the instance.
	DeviceIndex *int64 `type:"integer"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The AWS account ID of the owner of the instance.
	InstanceOwnerId *string `type:"string"`

	// The attachment state.
	//
	// Valid values: attaching | attached | detaching | detached
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2NetworkInterfaceAttachment) GoString() string {
	return s.String()
}

// SetAttachTime sets the AttachTime field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetAttachTime(v string) *AwsEc2NetworkInterfaceAttachment {
	s.AttachTime = &v
	return s
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetAttachmentId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.AttachmentId = &v
	return s
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetDeleteOnTermination(v bool) *AwsEc2NetworkInterfaceAttachment {
	s.DeleteOnTermination = &v
	return s
}

// SetDeviceIndex sets the DeviceIndex field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetDeviceIndex(v int64) *AwsEc2NetworkInterfaceAttachment {
	s.DeviceIndex = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetInstanceId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.InstanceId = &v
	return s
}

// SetInstanceOwnerId sets the InstanceOwnerId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetInstanceOwnerId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.InstanceOwnerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetStatus(v string) *AwsEc2NetworkInterfaceAttachment {
	s.Status = &v
	return s
}

// Details about the network interface
type AwsEc2NetworkInterfaceDetails struct {
	_ struct{} `type:"structure"`

	// The network interface attachment.
	Attachment *AwsEc2NetworkInterfaceAttachment `type:"structure"`

	// The ID of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// Security groups for the network interface.
	SecurityGroups []*AwsEc2NetworkInterfaceSecurityGroup `type:"list"`

	// Indicates whether traffic to or from the instance is validated.
	SourceDestCheck *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2NetworkInterfaceDetails) GoString() string {
	return s.String()
}

// SetAttachment sets the Attachment field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetAttachment(v *AwsEc2NetworkInterfaceAttachment) *AwsEc2NetworkInterfaceDetails {
	s.Attachment = v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetNetworkInterfaceId(v string) *AwsEc2NetworkInterfaceDetails {
	s.NetworkInterfaceId = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetSecurityGroups(v []*AwsEc2NetworkInterfaceSecurityGroup) *AwsEc2NetworkInterfaceDetails {
	s.SecurityGroups = v
	return s
}

// SetSourceDestCheck sets the SourceDestCheck field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetSourceDestCheck(v bool) *AwsEc2NetworkInterfaceDetails {
	s.SourceDestCheck = &v
	return s
}

// A security group associated with the network interface.
type AwsEc2NetworkInterfaceSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2NetworkInterfaceSecurityGroup) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2NetworkInterfaceSecurityGroup) SetGroupId(v string) *AwsEc2NetworkInterfaceSecurityGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2NetworkInterfaceSecurityGroup) SetGroupName(v string) *AwsEc2NetworkInterfaceSecurityGroup {
	s.GroupName = &v
	return s
}

// Details about an EC2 security group.
type AwsEc2SecurityGroupDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The inbound rules associated with the security group.
	IpPermissions []*AwsEc2SecurityGroupIpPermission `type:"list"`

	// [VPC only] The outbound rules associated with the security group.
	IpPermissionsEgress []*AwsEc2SecurityGroupIpPermission `type:"list"`

	// The AWS account ID of the owner of the security group.
	OwnerId *string `type:"string"`

	// [VPC only] The ID of the VPC for the security group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupDetails) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2SecurityGroupDetails) SetGroupId(v string) *AwsEc2SecurityGroupDetails {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2SecurityGroupDetails) SetGroupName(v string) *AwsEc2SecurityGroupDetails {
	s.GroupName = &v
	return s
}

// SetIpPermissions sets the IpPermissions field's value.
func (s *AwsEc2SecurityGroupDetails) SetIpPermissions(v []*AwsEc2SecurityGroupIpPermission) *AwsEc2SecurityGroupDetails {
	s.IpPermissions = v
	return s
}

// SetIpPermissionsEgress sets the IpPermissionsEgress field's value.
func (s *AwsEc2SecurityGroupDetails) SetIpPermissionsEgress(v []*AwsEc2SecurityGroupIpPermission) *AwsEc2SecurityGroupDetails {
	s.IpPermissionsEgress = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2SecurityGroupDetails) SetOwnerId(v string) *AwsEc2SecurityGroupDetails {
	s.OwnerId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SecurityGroupDetails) SetVpcId(v string) *AwsEc2SecurityGroupDetails {
	s.VpcId = &v
	return s
}

// An IP permission for an EC2 security group.
type AwsEc2SecurityGroupIpPermission struct {
	_ struct{} `type:"structure"`

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number.
	//
	// A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	FromPort *int64 `type:"integer"`

	// The IP protocol name (tcp, udp, icmp, icmpv6) or number.
	//
	// [VPC only] Use -1 to specify all protocols.
	//
	// When authorizing security group rules, specifying -1 or a protocol number
	// other than tcp, udp, icmp, or icmpv6 allows traffic on all ports, regardless
	// of any port range you specify.
	//
	// For tcp, udp, and icmp, you must specify a port range.
	//
	// For icmpv6, the port range is optional. If you omit the port range, traffic
	// for all types and codes is allowed.
	IpProtocol *string `type:"string"`

	// The IPv4 ranges.
	IpRanges []*AwsEc2SecurityGroupIpRange `type:"list"`

	// The IPv6 ranges.
	Ipv6Ranges []*AwsEc2SecurityGroupIpv6Range `type:"list"`

	// [VPC only] The prefix list IDs for an AWS service. With outbound rules, this
	// is the AWS service to access through a VPC endpoint from instances associated
	// with the security group.
	PrefixListIds []*AwsEc2SecurityGroupPrefixListId `type:"list"`

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// code.
	//
	// A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	ToPort *int64 `type:"integer"`

	// The security group and AWS account ID pairs.
	UserIdGroupPairs []*AwsEc2SecurityGroupUserIdGroupPair `type:"list"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupIpPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupIpPermission) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetFromPort(v int64) *AwsEc2SecurityGroupIpPermission {
	s.FromPort = &v
	return s
}

// SetIpProtocol sets the IpProtocol field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpProtocol(v string) *AwsEc2SecurityGroupIpPermission {
	s.IpProtocol = &v
	return s
}

// SetIpRanges sets the IpRanges field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpRanges(v []*AwsEc2SecurityGroupIpRange) *AwsEc2SecurityGroupIpPermission {
	s.IpRanges = v
	return s
}

// SetIpv6Ranges sets the Ipv6Ranges field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpv6Ranges(v []*AwsEc2SecurityGroupIpv6Range) *AwsEc2SecurityGroupIpPermission {
	s.Ipv6Ranges = v
	return s
}

// SetPrefixListIds sets the PrefixListIds field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetPrefixListIds(v []*AwsEc2SecurityGroupPrefixListId) *AwsEc2SecurityGroupIpPermission {
	s.PrefixListIds = v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetToPort(v int64) *AwsEc2SecurityGroupIpPermission {
	s.ToPort = &v
	return s
}

// SetUserIdGroupPairs sets the UserIdGroupPairs field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetUserIdGroupPairs(v []*AwsEc2SecurityGroupUserIdGroupPair) *AwsEc2SecurityGroupIpPermission {
	s.UserIdGroupPairs = v
	return s
}

// A range of IPv4 addresses.
type AwsEc2SecurityGroupIpRange struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR range. You can either specify either a CIDR range or a source
	// security group, but not both. To specify a single IPv4 address, use the /32
	// prefix length.
	CidrIp *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupIpRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupIpRange) GoString() string {
	return s.String()
}

// SetCidrIp sets the CidrIp field's value.
func (s *AwsEc2SecurityGroupIpRange) SetCidrIp(v string) *AwsEc2SecurityGroupIpRange {
	s.CidrIp = &v
	return s
}

// A range of IPv6 addresses.
type AwsEc2SecurityGroupIpv6Range struct {
	_ struct{} `type:"structure"`

	// The IPv6 CIDR range. You can either specify either a CIDR range or a source
	// security group, but not both. To specify a single IPv6 address, use the /128
	// prefix length.
	CidrIpv6 *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupIpv6Range) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupIpv6Range) GoString() string {
	return s.String()
}

// SetCidrIpv6 sets the CidrIpv6 field's value.
func (s *AwsEc2SecurityGroupIpv6Range) SetCidrIpv6(v string) *AwsEc2SecurityGroupIpv6Range {
	s.CidrIpv6 = &v
	return s
}

// A prefix list ID.
type AwsEc2SecurityGroupPrefixListId struct {
	_ struct{} `type:"structure"`

	// The ID of the prefix.
	PrefixListId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupPrefixListId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupPrefixListId) GoString() string {
	return s.String()
}

// SetPrefixListId sets the PrefixListId field's value.
func (s *AwsEc2SecurityGroupPrefixListId) SetPrefixListId(v string) *AwsEc2SecurityGroupPrefixListId {
	s.PrefixListId = &v
	return s
}

// A relationship between a security group and a user.
type AwsEc2SecurityGroupUserIdGroupPair struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The status of a VPC peering connection, if applicable.
	PeeringStatus *string `type:"string"`

	// The ID of an AWS account.
	//
	// For a referenced security group in another VPC, the account ID of the referenced
	// security group is returned in the response. If the referenced security group
	// is deleted, this value is not returned.
	//
	// [EC2-Classic] Required when adding or removing rules that reference a security
	// group in another AWS.
	UserId *string `type:"string"`

	// The ID of the VPC for the referenced security group, if applicable.
	VpcId *string `type:"string"`

	// The ID of the VPC peering connection, if applicable.
	VpcPeeringConnectionId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupUserIdGroupPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupUserIdGroupPair) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetGroupId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetGroupName(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.GroupName = &v
	return s
}

// SetPeeringStatus sets the PeeringStatus field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetPeeringStatus(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.PeeringStatus = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetUserId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.UserId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetVpcId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.VpcId = &v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetVpcPeeringConnectionId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.VpcPeeringConnectionId = &v
	return s
}

// Information about an Elasticsearch domain.
type AwsElasticsearchDomainDetails struct {
	_ struct{} `type:"structure"`

	// IAM policy document specifying the access policies for the new Amazon ES
	// domain.
	AccessPolicies *string `type:"string"`

	// Additional options for the domain endpoint.
	DomainEndpointOptions *AwsElasticsearchDomainDomainEndpointOptions `type:"structure"`

	// Unique identifier for an Amazon ES domain.
	DomainId *string `type:"string"`

	// Name of an Amazon ES domain.
	//
	// Domain names are unique across all domains owned by the same account within
	// an AWS Region.
	//
	// Domain names must start with a lowercase letter and must be between 3 and
	// 28 characters.
	//
	// Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
	DomainName *string `type:"string"`

	// Elasticsearch version.
	ElasticsearchVersion *string `type:"string"`

	// Details about the configuration for encryption at rest.
	EncryptionAtRestOptions *AwsElasticsearchDomainEncryptionAtRestOptions `type:"structure"`

	// Domain-specific endpoint used to submit index, search, and data upload requests
	// to an Amazon ES domain.
	//
	// The endpoint is a service URL.
	Endpoint *string `type:"string"`

	// The key-value pair that exists if the Amazon ES domain uses VPC endpoints.
	Endpoints map[string]*string `type:"map"`

	// Details about the configuration for node-to-node encryption.
	NodeToNodeEncryptionOptions *AwsElasticsearchDomainNodeToNodeEncryptionOptions `type:"structure"`

	// Information that Amazon ES derives based on VPCOptions for the domain.
	VPCOptions *AwsElasticsearchDomainVPCOptions `type:"structure"`
}

// String returns the string representation
func (s AwsElasticsearchDomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainDetails) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *AwsElasticsearchDomainDetails) SetAccessPolicies(v string) *AwsElasticsearchDomainDetails {
	s.AccessPolicies = &v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetDomainEndpointOptions(v *AwsElasticsearchDomainDomainEndpointOptions) *AwsElasticsearchDomainDetails {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AwsElasticsearchDomainDetails) SetDomainId(v string) *AwsElasticsearchDomainDetails {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsElasticsearchDomainDetails) SetDomainName(v string) *AwsElasticsearchDomainDetails {
	s.DomainName = &v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *AwsElasticsearchDomainDetails) SetElasticsearchVersion(v string) *AwsElasticsearchDomainDetails {
	s.ElasticsearchVersion = &v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetEncryptionAtRestOptions(v *AwsElasticsearchDomainEncryptionAtRestOptions) *AwsElasticsearchDomainDetails {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsElasticsearchDomainDetails) SetEndpoint(v string) *AwsElasticsearchDomainDetails {
	s.Endpoint = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *AwsElasticsearchDomainDetails) SetEndpoints(v map[string]*string) *AwsElasticsearchDomainDetails {
	s.Endpoints = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetNodeToNodeEncryptionOptions(v *AwsElasticsearchDomainNodeToNodeEncryptionOptions) *AwsElasticsearchDomainDetails {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetVPCOptions(v *AwsElasticsearchDomainVPCOptions) *AwsElasticsearchDomainDetails {
	s.VPCOptions = v
	return s
}

// Additional options for the domain endpoint, such as whether to require HTTPS
// for all traffic.
type AwsElasticsearchDomainDomainEndpointOptions struct {
	_ struct{} `type:"structure"`

	// Whether to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS *bool `type:"boolean"`

	// The TLS security policy to apply to the HTTPS endpoint of the Elasticsearch
	// domain.
	//
	// Valid values:
	//
	//    * Policy-Min-TLS-1-0-2019-07, which supports TLSv1.0 and higher
	//
	//    * Policy-Min-TLS-1-2-2019-07, which only supports TLSv1.2
	TLSSecurityPolicy *string `type:"string"`
}

// String returns the string representation
func (s AwsElasticsearchDomainDomainEndpointOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainDomainEndpointOptions) GoString() string {
	return s.String()
}

// SetEnforceHTTPS sets the EnforceHTTPS field's value.
func (s *AwsElasticsearchDomainDomainEndpointOptions) SetEnforceHTTPS(v bool) *AwsElasticsearchDomainDomainEndpointOptions {
	s.EnforceHTTPS = &v
	return s
}

// SetTLSSecurityPolicy sets the TLSSecurityPolicy field's value.
func (s *AwsElasticsearchDomainDomainEndpointOptions) SetTLSSecurityPolicy(v string) *AwsElasticsearchDomainDomainEndpointOptions {
	s.TLSSecurityPolicy = &v
	return s
}

// Details about the configuration for encryption at rest.
type AwsElasticsearchDomainEncryptionAtRestOptions struct {
	_ struct{} `type:"structure"`

	// Whether encryption at rest is enabled.
	Enabled *bool `type:"boolean"`

	// The KMS key ID. Takes the form 1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a.
	KmsKeyId *string `type:"string"`
}

// String returns the string representation
func (s AwsElasticsearchDomainEncryptionAtRestOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainEncryptionAtRestOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElasticsearchDomainEncryptionAtRestOptions) SetEnabled(v bool) *AwsElasticsearchDomainEncryptionAtRestOptions {
	s.Enabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsElasticsearchDomainEncryptionAtRestOptions) SetKmsKeyId(v string) *AwsElasticsearchDomainEncryptionAtRestOptions {
	s.KmsKeyId = &v
	return s
}

// Details about the configuration for node-to-node encryption.
type AwsElasticsearchDomainNodeToNodeEncryptionOptions struct {
	_ struct{} `type:"structure"`

	// Whether node-to-node encryption is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsElasticsearchDomainNodeToNodeEncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainNodeToNodeEncryptionOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElasticsearchDomainNodeToNodeEncryptionOptions) SetEnabled(v bool) *AwsElasticsearchDomainNodeToNodeEncryptionOptions {
	s.Enabled = &v
	return s
}

// Information that Amazon ES derives based on VPCOptions for the domain.
type AwsElasticsearchDomainVPCOptions struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones associated with the VPC subnets.
	AvailabilityZones []*string `type:"list"`

	// The list of security group IDs associated with the VPC endpoints for the
	// domain.
	SecurityGroupIds []*string `type:"list"`

	// A list of subnet IDs associated with the VPC endpoints for the domain.
	SubnetIds []*string `type:"list"`

	// ID for the VPC.
	VPCId *string `type:"string"`
}

// String returns the string representation
func (s AwsElasticsearchDomainVPCOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainVPCOptions) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetAvailabilityZones(v []*string) *AwsElasticsearchDomainVPCOptions {
	s.AvailabilityZones = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetSecurityGroupIds(v []*string) *AwsElasticsearchDomainVPCOptions {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetSubnetIds(v []*string) *AwsElasticsearchDomainVPCOptions {
	s.SubnetIds = v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetVPCId(v string) *AwsElasticsearchDomainVPCOptions {
	s.VPCId = &v
	return s
}

// Information about a load balancer.
type AwsElbv2LoadBalancerDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zones for the load balancer.
	AvailabilityZones []*AvailabilityZone `type:"list"`

	// The ID of the Amazon Route 53 hosted zone associated with the load balancer.
	CanonicalHostedZoneId *string `type:"string"`

	// The date and time the load balancer was created.
	CreatedTime *string `type:"string"`

	// The public DNS name of the load balancer.
	DNSName *string `type:"string"`

	// The type of IP addresses used by the subnets for your load balancer. The
	// possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and
	// IPv6 addresses).
	IpAddressType *string `type:"string"`

	// The nodes of an Internet-facing load balancer have public IP addresses.
	Scheme *string `type:"string"`

	// The IDs of the security groups for the load balancer.
	SecurityGroups []*string `type:"list"`

	// The state of the load balancer.
	State *LoadBalancerState `type:"structure"`

	// The type of load balancer.
	Type *string `type:"string"`

	// The ID of the VPC for the load balancer.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsElbv2LoadBalancerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbv2LoadBalancerDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsElbv2LoadBalancerDetails) SetAvailabilityZones(v []*AvailabilityZone) *AwsElbv2LoadBalancerDetails {
	s.AvailabilityZones = v
	return s
}

// SetCanonicalHostedZoneId sets the CanonicalHostedZoneId field's value.
func (s *AwsElbv2LoadBalancerDetails) SetCanonicalHostedZoneId(v string) *AwsElbv2LoadBalancerDetails {
	s.CanonicalHostedZoneId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsElbv2LoadBalancerDetails) SetCreatedTime(v string) *AwsElbv2LoadBalancerDetails {
	s.CreatedTime = &v
	return s
}

// SetDNSName sets the DNSName field's value.
func (s *AwsElbv2LoadBalancerDetails) SetDNSName(v string) *AwsElbv2LoadBalancerDetails {
	s.DNSName = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *AwsElbv2LoadBalancerDetails) SetIpAddressType(v string) *AwsElbv2LoadBalancerDetails {
	s.IpAddressType = &v
	return s
}

// SetScheme sets the Scheme field's value.
func (s *AwsElbv2LoadBalancerDetails) SetScheme(v string) *AwsElbv2LoadBalancerDetails {
	s.Scheme = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsElbv2LoadBalancerDetails) SetSecurityGroups(v []*string) *AwsElbv2LoadBalancerDetails {
	s.SecurityGroups = v
	return s
}

// SetState sets the State field's value.
func (s *AwsElbv2LoadBalancerDetails) SetState(v *LoadBalancerState) *AwsElbv2LoadBalancerDetails {
	s.State = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsElbv2LoadBalancerDetails) SetType(v string) *AwsElbv2LoadBalancerDetails {
	s.Type = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsElbv2LoadBalancerDetails) SetVpcId(v string) *AwsElbv2LoadBalancerDetails {
	s.VpcId = &v
	return s
}

// IAM access key details related to a finding.
type AwsIamAccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// The creation date/time of the IAM access key related to a finding.
	CreatedAt *string `type:"string"`

	// The ID of the principal associated with an access key.
	PrincipalId *string `type:"string"`

	// The name of the principal.
	PrincipalName *string `type:"string"`

	// The type of principal associated with an access key.
	PrincipalType *string `type:"string"`

	// The status of the IAM access key related to a finding.
	Status *string `type:"string" enum:"AwsIamAccessKeyStatus"`

	// The user associated with the IAM access key related to a finding.
	//
	// The UserName parameter has been replaced with the PrincipalName parameter
	// because access keys can also be assigned to principals that are not IAM users.
	//
	// Deprecated: This field is deprecated, use PrincipalName instead.
	UserName *string `deprecated:"true" type:"string"`
}

// String returns the string representation
func (s AwsIamAccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamAccessKeyDetails) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsIamAccessKeyDetails) SetCreatedAt(v string) *AwsIamAccessKeyDetails {
	s.CreatedAt = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AwsIamAccessKeyDetails) SetPrincipalId(v string) *AwsIamAccessKeyDetails {
	s.PrincipalId = &v
	return s
}

// SetPrincipalName sets the PrincipalName field's value.
func (s *AwsIamAccessKeyDetails) SetPrincipalName(v string) *AwsIamAccessKeyDetails {
	s.PrincipalName = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AwsIamAccessKeyDetails) SetPrincipalType(v string) *AwsIamAccessKeyDetails {
	s.PrincipalType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsIamAccessKeyDetails) SetStatus(v string) *AwsIamAccessKeyDetails {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AwsIamAccessKeyDetails) SetUserName(v string) *AwsIamAccessKeyDetails {
	s.UserName = &v
	return s
}

// Contains information about an IAM role, including all of the role's policies.
type AwsIamRoleDetails struct {
	_ struct{} `type:"structure"`

	// The trust policy that grants permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 date-time format, when the role was created.
	CreateDate *string `type:"string"`

	// The maximum session duration (in seconds) that you want to set for the specified
	// role.
	MaxSessionDuration *int64 `type:"integer"`

	// The path to the role.
	Path *string `type:"string"`

	// The stable and unique string identifying the role.
	RoleId *string `type:"string"`

	// The friendly name that identifies the role.
	RoleName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamRoleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamRoleDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIamRoleDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIamRoleDetails"}
	if s.AssumeRolePolicyDocument != nil && len(*s.AssumeRolePolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssumeRolePolicyDocument", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssumeRolePolicyDocument sets the AssumeRolePolicyDocument field's value.
func (s *AwsIamRoleDetails) SetAssumeRolePolicyDocument(v string) *AwsIamRoleDetails {
	s.AssumeRolePolicyDocument = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamRoleDetails) SetCreateDate(v string) *AwsIamRoleDetails {
	s.CreateDate = &v
	return s
}

// SetMaxSessionDuration sets the MaxSessionDuration field's value.
func (s *AwsIamRoleDetails) SetMaxSessionDuration(v int64) *AwsIamRoleDetails {
	s.MaxSessionDuration = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamRoleDetails) SetPath(v string) *AwsIamRoleDetails {
	s.Path = &v
	return s
}

// SetRoleId sets the RoleId field's value.
func (s *AwsIamRoleDetails) SetRoleId(v string) *AwsIamRoleDetails {
	s.RoleId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *AwsIamRoleDetails) SetRoleName(v string) *AwsIamRoleDetails {
	s.RoleName = &v
	return s
}

// Contains metadata about a customer master key (CMK).
type AwsKmsKeyDetails struct {
	_ struct{} `type:"structure"`

	// The twelve-digit account ID of the AWS account that owns the CMK.
	AWSAccountId *string `type:"string"`

	// The date and time when the CMK was created.
	CreationDate *float64 `type:"double"`

	// The globally unique identifier for the CMK.
	KeyId *string `type:"string"`

	// The manager of the CMK. CMKs in your AWS account are either customer managed
	// or AWS managed.
	KeyManager *string `type:"string"`

	// The state of the CMK.
	KeyState *string `type:"string"`

	// The source of the CMK's key material.
	//
	// When this value is AWS_KMS, AWS KMS created the key material.
	//
	// When this value is EXTERNAL, the key material was imported from your existing
	// key management infrastructure or the CMK lacks key material.
	//
	// When this value is AWS_CLOUDHSM, the key material was created in the AWS
	// CloudHSM cluster associated with a custom key store.
	Origin *string `type:"string"`
}

// String returns the string representation
func (s AwsKmsKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsKmsKeyDetails) GoString() string {
	return s.String()
}

// SetAWSAccountId sets the AWSAccountId field's value.
func (s *AwsKmsKeyDetails) SetAWSAccountId(v string) *AwsKmsKeyDetails {
	s.AWSAccountId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AwsKmsKeyDetails) SetCreationDate(v float64) *AwsKmsKeyDetails {
	s.CreationDate = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *AwsKmsKeyDetails) SetKeyId(v string) *AwsKmsKeyDetails {
	s.KeyId = &v
	return s
}

// SetKeyManager sets the KeyManager field's value.
func (s *AwsKmsKeyDetails) SetKeyManager(v string) *AwsKmsKeyDetails {
	s.KeyManager = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *AwsKmsKeyDetails) SetKeyState(v string) *AwsKmsKeyDetails {
	s.KeyState = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *AwsKmsKeyDetails) SetOrigin(v string) *AwsKmsKeyDetails {
	s.Origin = &v
	return s
}

// The code for the Lambda function. You can specify either an object in Amazon
// S3, or upload a deployment package directly.
type AwsLambdaFunctionCode struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 bucket in the same AWS Region as your function. The bucket can
	// be in a different AWS account.
	S3Bucket *string `type:"string"`

	// The Amazon S3 key of the deployment package.
	S3Key *string `type:"string"`

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string `type:"string"`

	// The base64-encoded contents of the deployment package. AWS SDK and AWS CLI
	// clients handle the encoding for you.
	ZipFile *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionCode) GoString() string {
	return s.String()
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *AwsLambdaFunctionCode) SetS3Bucket(v string) *AwsLambdaFunctionCode {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *AwsLambdaFunctionCode) SetS3Key(v string) *AwsLambdaFunctionCode {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *AwsLambdaFunctionCode) SetS3ObjectVersion(v string) *AwsLambdaFunctionCode {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *AwsLambdaFunctionCode) SetZipFile(v string) *AwsLambdaFunctionCode {
	s.ZipFile = &v
	return s
}

// The dead-letter queue for failed asynchronous invocations.
type AwsLambdaFunctionDeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
	TargetArn *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionDeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionDeadLetterConfig) GoString() string {
	return s.String()
}

// SetTargetArn sets the TargetArn field's value.
func (s *AwsLambdaFunctionDeadLetterConfig) SetTargetArn(v string) *AwsLambdaFunctionDeadLetterConfig {
	s.TargetArn = &v
	return s
}

// Details about a function's configuration.
type AwsLambdaFunctionDetails struct {
	_ struct{} `type:"structure"`

	// An AwsLambdaFunctionCode object.
	Code *AwsLambdaFunctionCode `type:"structure"`

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string `type:"string"`

	// The function's dead letter queue.
	DeadLetterConfig *AwsLambdaFunctionDeadLetterConfig `type:"structure"`

	// The function's environment variables.
	Environment *AwsLambdaFunctionEnvironment `type:"structure"`

	// The name of the function.
	FunctionName *string `type:"string"`

	// The function that Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The KMS key that's used to encrypt the function's environment variables.
	// This key is only returned if you've configured a customer managed CMK.
	KmsKeyArn *string `type:"string"`

	// The date and time that the function was last updated, in ISO-8601 format
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModified *string `type:"string"`

	// The function's layers.
	Layers []*AwsLambdaFunctionLayer `type:"list"`

	// For Lambda@Edge functions, the ARN of the master function.
	MasterArn *string `type:"string"`

	// The memory that's allocated to the function.
	MemorySize *int64 `type:"integer"`

	// The latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// The function's execution role.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime *string `type:"string"`

	// The amount of time that Lambda allows a function to run before stopping it.
	Timeout *int64 `type:"integer"`

	// The function's AWS X-Ray tracing configuration.
	TracingConfig *AwsLambdaFunctionTracingConfig `type:"structure"`

	// The version of the Lambda function.
	Version *string `type:"string"`

	// The function's networking configuration.
	VpcConfig *AwsLambdaFunctionVpcConfig `type:"structure"`
}

// String returns the string representation
func (s AwsLambdaFunctionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AwsLambdaFunctionDetails) SetCode(v *AwsLambdaFunctionCode) *AwsLambdaFunctionDetails {
	s.Code = v
	return s
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *AwsLambdaFunctionDetails) SetCodeSha256(v string) *AwsLambdaFunctionDetails {
	s.CodeSha256 = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *AwsLambdaFunctionDetails) SetDeadLetterConfig(v *AwsLambdaFunctionDeadLetterConfig) *AwsLambdaFunctionDetails {
	s.DeadLetterConfig = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *AwsLambdaFunctionDetails) SetEnvironment(v *AwsLambdaFunctionEnvironment) *AwsLambdaFunctionDetails {
	s.Environment = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *AwsLambdaFunctionDetails) SetFunctionName(v string) *AwsLambdaFunctionDetails {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *AwsLambdaFunctionDetails) SetHandler(v string) *AwsLambdaFunctionDetails {
	s.Handler = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *AwsLambdaFunctionDetails) SetKmsKeyArn(v string) *AwsLambdaFunctionDetails {
	s.KmsKeyArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *AwsLambdaFunctionDetails) SetLastModified(v string) *AwsLambdaFunctionDetails {
	s.LastModified = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *AwsLambdaFunctionDetails) SetLayers(v []*AwsLambdaFunctionLayer) *AwsLambdaFunctionDetails {
	s.Layers = v
	return s
}

// SetMasterArn sets the MasterArn field's value.
func (s *AwsLambdaFunctionDetails) SetMasterArn(v string) *AwsLambdaFunctionDetails {
	s.MasterArn = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *AwsLambdaFunctionDetails) SetMemorySize(v int64) *AwsLambdaFunctionDetails {
	s.MemorySize = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AwsLambdaFunctionDetails) SetRevisionId(v string) *AwsLambdaFunctionDetails {
	s.RevisionId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *AwsLambdaFunctionDetails) SetRole(v string) *AwsLambdaFunctionDetails {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *AwsLambdaFunctionDetails) SetRuntime(v string) *AwsLambdaFunctionDetails {
	s.Runtime = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AwsLambdaFunctionDetails) SetTimeout(v int64) *AwsLambdaFunctionDetails {
	s.Timeout = &v
	return s
}

// SetTracingConfig sets the TracingConfig field's value.
func (s *AwsLambdaFunctionDetails) SetTracingConfig(v *AwsLambdaFunctionTracingConfig) *AwsLambdaFunctionDetails {
	s.TracingConfig = v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsLambdaFunctionDetails) SetVersion(v string) *AwsLambdaFunctionDetails {
	s.Version = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *AwsLambdaFunctionDetails) SetVpcConfig(v *AwsLambdaFunctionVpcConfig) *AwsLambdaFunctionDetails {
	s.VpcConfig = v
	return s
}

// A function's environment variable settings.
type AwsLambdaFunctionEnvironment struct {
	_ struct{} `type:"structure"`

	// An AwsLambdaFunctionEnvironmentError object.
	Error *AwsLambdaFunctionEnvironmentError `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]*string `type:"map"`
}

// String returns the string representation
func (s AwsLambdaFunctionEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionEnvironment) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *AwsLambdaFunctionEnvironment) SetError(v *AwsLambdaFunctionEnvironmentError) *AwsLambdaFunctionEnvironment {
	s.Error = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *AwsLambdaFunctionEnvironment) SetVariables(v map[string]*string) *AwsLambdaFunctionEnvironment {
	s.Variables = v
	return s
}

// Error messages for environment variables that couldn't be applied.
type AwsLambdaFunctionEnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionEnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionEnvironmentError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AwsLambdaFunctionEnvironmentError) SetErrorCode(v string) *AwsLambdaFunctionEnvironmentError {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AwsLambdaFunctionEnvironmentError) SetMessage(v string) *AwsLambdaFunctionEnvironmentError {
	s.Message = &v
	return s
}

// An AWS Lambda layer.
type AwsLambdaFunctionLayer struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the function layer.
	Arn *string `type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsLambdaFunctionLayer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionLayer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AwsLambdaFunctionLayer) SetArn(v string) *AwsLambdaFunctionLayer {
	s.Arn = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *AwsLambdaFunctionLayer) SetCodeSize(v int64) *AwsLambdaFunctionLayer {
	s.CodeSize = &v
	return s
}

// The function's AWS X-Ray tracing configuration.
type AwsLambdaFunctionTracingConfig struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionTracingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionTracingConfig) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *AwsLambdaFunctionTracingConfig) SetMode(v string) *AwsLambdaFunctionTracingConfig {
	s.Mode = &v
	return s
}

// The VPC security groups and subnets that are attached to a Lambda function.
// For more information, see VPC Settings.
type AwsLambdaFunctionVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []*string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []*string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionVpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsLambdaFunctionVpcConfig) SetSecurityGroupIds(v []*string) *AwsLambdaFunctionVpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsLambdaFunctionVpcConfig) SetSubnetIds(v []*string) *AwsLambdaFunctionVpcConfig {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsLambdaFunctionVpcConfig) SetVpcId(v string) *AwsLambdaFunctionVpcConfig {
	s.VpcId = &v
	return s
}

// Details about a Lambda layer version.
type AwsLambdaLayerVersionDetails struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes. Maximum number of 5 items.
	//
	// Valid values: nodejs10.x | nodejs12.x | java8 | java11 | python2.7 | python3.6
	// | python3.7 | python3.8 | dotnetcore1.0 | dotnetcore2.1 | go1.x | ruby2.5
	// | provided
	CompatibleRuntimes []*string `type:"list"`

	// The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000.
	CreatedDate *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s AwsLambdaLayerVersionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaLayerVersionDetails) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *AwsLambdaLayerVersionDetails) SetCompatibleRuntimes(v []*string) *AwsLambdaLayerVersionDetails {
	s.CompatibleRuntimes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsLambdaLayerVersionDetails) SetCreatedDate(v string) *AwsLambdaLayerVersionDetails {
	s.CreatedDate = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsLambdaLayerVersionDetails) SetVersion(v int64) *AwsLambdaLayerVersionDetails {
	s.Version = &v
	return s
}

// An AWS Identity and Access Management (IAM) role associated with the DB instance.
type AwsRdsDbInstanceAssociatedRole struct {
	_ struct{} `type:"structure"`

	// The name of the feature associated with the IAM)role.
	FeatureName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB instance.
	RoleArn *string `type:"string"`

	// Describes the state of the association between the IAM role and the DB instance.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - the IAM role ARN is associated with the DB instance and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - the IAM role ARN is being associated with the DB instance.
	//
	//    * INVALID - the IAM role ARN is associated with the DB instance, but the
	//    DB instance is unable to assume the IAM role in order to access other
	//    AWS services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbInstanceAssociatedRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbInstanceAssociatedRole) GoString() string {
	return s.String()
}

// SetFeatureName sets the FeatureName field's value.
func (s *AwsRdsDbInstanceAssociatedRole) SetFeatureName(v string) *AwsRdsDbInstanceAssociatedRole {
	s.FeatureName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AwsRdsDbInstanceAssociatedRole) SetRoleArn(v string) *AwsRdsDbInstanceAssociatedRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbInstanceAssociatedRole) SetStatus(v string) *AwsRdsDbInstanceAssociatedRole {
	s.Status = &v
	return s
}

// Contains the details of an Amazon RDS DB instance.
type AwsRdsDbInstanceDetails struct {
	_ struct{} `type:"structure"`

	// The AWS Identity and Access Management (IAM) roles associated with the DB
	// instance.
	AssociatedRoles []*AwsRdsDbInstanceAssociatedRole `type:"list"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// MySQL, MariaDB, SQL Server, PostgreSQL
	//
	// Contains the name of the initial database of this instance that was provided
	// at create time, if one was specified when the DB instance was created. This
	// same name is returned for the life of the DB instance.
	//
	// Oracle
	//
	// Contains the Oracle System ID (SID) of the created DB instance. Not shown
	// when the returned parameters do not apply to an Oracle DB instance.
	DBName *string `type:"string"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// The AWS Region-unique, immutable identifier for the DB instance. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// instance is accessed.
	DbiResourceId *string `type:"string"`

	// Indicates whether the DB instance has deletion protection enabled.
	//
	// When deletion protection is enabled, the database cannot be deleted.
	DeletionProtection *bool `type:"boolean"`

	// Specifies the connection endpoint.
	Endpoint *AwsRdsDbInstanceEndpoint `type:"structure"`

	// Provides the name of the database engine to use for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	//
	// IAM database authentication can be enabled for the following database engines.
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *string `type:"string"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB instance.
	KmsKeyId *string `type:"string"`

	// Specifies the accessibility options for the DB instance.
	//
	// A value of true specifies an Internet-facing instance with a publicly resolvable
	// DNS name, which resolves to a public IP address.
	//
	// A value of false specifies an internal instance with a DNS name that resolves
	// to a private IP address.
	PubliclyAccessible *bool `type:"boolean"`

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// A list of VPC security groups that the DB instance belongs to.
	VpcSecurityGroups []*AwsRdsDbInstanceVpcSecurityGroup `type:"list"`
}

// String returns the string representation
func (s AwsRdsDbInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbInstanceDetails) GoString() string {
	return s.String()
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *AwsRdsDbInstanceDetails) SetAssociatedRoles(v []*AwsRdsDbInstanceAssociatedRole) *AwsRdsDbInstanceDetails {
	s.AssociatedRoles = v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetCACertificateIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.CACertificateIdentifier = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetDBClusterIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *AwsRdsDbInstanceDetails) SetDBInstanceClass(v string) *AwsRdsDbInstanceDetails {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetDBInstanceIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *AwsRdsDbInstanceDetails) SetDBName(v string) *AwsRdsDbInstanceDetails {
	s.DBName = &v
	return s
}

// SetDbInstancePort sets the DbInstancePort field's value.
func (s *AwsRdsDbInstanceDetails) SetDbInstancePort(v int64) *AwsRdsDbInstanceDetails {
	s.DbInstancePort = &v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *AwsRdsDbInstanceDetails) SetDbiResourceId(v string) *AwsRdsDbInstanceDetails {
	s.DbiResourceId = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *AwsRdsDbInstanceDetails) SetDeletionProtection(v bool) *AwsRdsDbInstanceDetails {
	s.DeletionProtection = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsRdsDbInstanceDetails) SetEndpoint(v *AwsRdsDbInstanceEndpoint) *AwsRdsDbInstanceDetails {
	s.Endpoint = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *AwsRdsDbInstanceDetails) SetEngine(v string) *AwsRdsDbInstanceDetails {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbInstanceDetails) SetEngineVersion(v string) *AwsRdsDbInstanceDetails {
	s.EngineVersion = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *AwsRdsDbInstanceDetails) SetIAMDatabaseAuthenticationEnabled(v bool) *AwsRdsDbInstanceDetails {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *AwsRdsDbInstanceDetails) SetInstanceCreateTime(v string) *AwsRdsDbInstanceDetails {
	s.InstanceCreateTime = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRdsDbInstanceDetails) SetKmsKeyId(v string) *AwsRdsDbInstanceDetails {
	s.KmsKeyId = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *AwsRdsDbInstanceDetails) SetPubliclyAccessible(v bool) *AwsRdsDbInstanceDetails {
	s.PubliclyAccessible = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *AwsRdsDbInstanceDetails) SetStorageEncrypted(v bool) *AwsRdsDbInstanceDetails {
	s.StorageEncrypted = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *AwsRdsDbInstanceDetails) SetTdeCredentialArn(v string) *AwsRdsDbInstanceDetails {
	s.TdeCredentialArn = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *AwsRdsDbInstanceDetails) SetVpcSecurityGroups(v []*AwsRdsDbInstanceVpcSecurityGroup) *AwsRdsDbInstanceDetails {
	s.VpcSecurityGroups = v
	return s
}

// Specifies the connection endpoint.
type AwsRdsDbInstanceEndpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsRdsDbInstanceEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbInstanceEndpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *AwsRdsDbInstanceEndpoint) SetAddress(v string) *AwsRdsDbInstanceEndpoint {
	s.Address = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *AwsRdsDbInstanceEndpoint) SetHostedZoneId(v string) *AwsRdsDbInstanceEndpoint {
	s.HostedZoneId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbInstanceEndpoint) SetPort(v int64) *AwsRdsDbInstanceEndpoint {
	s.Port = &v
	return s
}

// A VPC security groups that the DB instance belongs to.
type AwsRdsDbInstanceVpcSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbInstanceVpcSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbInstanceVpcSecurityGroup) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbInstanceVpcSecurityGroup) SetStatus(v string) *AwsRdsDbInstanceVpcSecurityGroup {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *AwsRdsDbInstanceVpcSecurityGroup) SetVpcSecurityGroupId(v string) *AwsRdsDbInstanceVpcSecurityGroup {
	s.VpcSecurityGroupId = &v
	return s
}

// The details of an Amazon S3 bucket.
type AwsS3BucketDetails struct {
	_ struct{} `type:"structure"`

	// The canonical user ID of the owner of the S3 bucket.
	OwnerId *string `type:"string"`

	// The display name of the owner of the S3 bucket.
	OwnerName *string `type:"string"`
}

// String returns the string representation
func (s AwsS3BucketDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsS3BucketDetails) GoString() string {
	return s.String()
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsS3BucketDetails) SetOwnerId(v string) *AwsS3BucketDetails {
	s.OwnerId = &v
	return s
}

// SetOwnerName sets the OwnerName field's value.
func (s *AwsS3BucketDetails) SetOwnerName(v string) *AwsS3BucketDetails {
	s.OwnerName = &v
	return s
}

// Provides consistent format for the contents of the Security Hub-aggregated
// findings. AwsSecurityFinding format enables you to share findings between
// AWS security services and third-party solutions, and security standards checks.
//
// A finding is a potential security issue generated either by AWS services
// (Amazon GuardDuty, Amazon Inspector, and Amazon Macie) or by the integrated
// third-party solutions and standards checks.
type AwsSecurityFinding struct {
	_ struct{} `type:"structure"`

	// The AWS account ID that a finding is generated in.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// This data type is exclusive to findings that are generated as the result
	// of a check run against a specific rule in a supported security standard,
	// such as CIS AWS Foundations. Contains security standard-related finding details.
	Compliance *Compliance `type:"structure"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
	// zero percent confidence and 100 means 100 percent confidence.
	Confidence *int64 `type:"integer"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider created the potential security issue that a finding captured.
	//
	// CreatedAt is a required field
	CreatedAt *string `type:"string" required:"true"`

	// The level of importance assigned to the resources associated with the finding.
	//
	// A score of 0 means that the underlying resources have no criticality, and
	// a score of 100 is reserved for the most critical resources.
	Criticality *int64 `type:"integer"`

	// A finding's description.
	//
	// In this release, Description is a required property.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider first observed the potential security issue that a finding captured.
	FirstObservedAt *string `type:"string"`

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security-findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plug-in, etc.
	//
	// GeneratorId is a required field
	GeneratorId *string `type:"string" required:"true"`

	// The security findings provider-specific identifier for a finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider most recently observed the potential security issue that a finding
	// captured.
	LastObservedAt *string `type:"string"`

	// A list of malware related to a finding.
	Malware []*Malware `type:"list"`

	// The details of network-related information about a finding.
	Network *Network `type:"structure"`

	// A user-defined note added to a finding.
	Note *Note `type:"structure"`

	// The details of process-related information about a finding.
	Process *ProcessDetails `type:"structure"`

	// The ARN generated by Security Hub that uniquely identifies a third-party
	// company (security-findings provider) after this provider's product (solution
	// that generates findings) is registered with Security Hub.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`

	// A data type where security-findings providers can include additional solution-specific
	// details that aren't part of the defined AwsSecurityFinding format.
	ProductFields map[string]*string `type:"map"`

	// The record state of a finding.
	RecordState *string `type:"string" enum:"RecordState"`

	// A list of related findings.
	RelatedFindings []*RelatedFinding `type:"list"`

	// A data type that describes the remediation options for a finding.
	Remediation *Remediation `type:"structure"`

	// A set of resource data types that describe the resources that the finding
	// refers to.
	//
	// Resources is a required field
	Resources []*Resource `type:"list" required:"true"`

	// The schema version that a finding is formatted for.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `type:"string" required:"true"`

	// A finding's severity.
	//
	// Severity is a required field
	Severity *Severity `type:"structure" required:"true"`

	// A URL that links to a page about the current finding in the security-findings
	// provider's solution.
	SourceUrl *string `type:"string"`

	// Threat intelligence details related to a finding.
	ThreatIntelIndicators []*ThreatIntelIndicator `type:"list"`

	// A finding's title.
	//
	// In this release, Title is a required property.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`

	// One or more finding types in the format of namespace/category/classifier
	// that classify a finding.
	//
	// Valid namespace values are: Software and Configuration Checks | TTPs | Effects
	// | Unusual Behaviors | Sensitive Data Identifications
	//
	// Types is a required field
	Types []*string `type:"list" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider last updated the finding record.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields map[string]*string `type:"map"`

	// Indicates the veracity of a finding.
	VerificationState *string `type:"string" enum:"VerificationState"`

	// The workflow state of a finding.
	WorkflowState *string `type:"string" enum:"WorkflowState"`
}

// String returns the string representation
func (s AwsSecurityFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSecurityFinding) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsSecurityFinding) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsSecurityFinding"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.CreatedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatedAt"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.GeneratorId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneratorId"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}
	if s.SchemaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaVersion"))
	}
	if s.Severity == nil {
		invalidParams.Add(request.NewErrParamRequired("Severity"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Types == nil {
		invalidParams.Add(request.NewErrParamRequired("Types"))
	}
	if s.UpdatedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedAt"))
	}
	if s.Malware != nil {
		for i, v := range s.Malware {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Malware", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(request.ErrInvalidParams))
		}
	}
	if s.RelatedFindings != nil {
		for i, v := range s.RelatedFindings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedFindings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Severity != nil {
		if err := s.Severity.Validate(); err != nil {
			invalidParams.AddNested("Severity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *AwsSecurityFinding) SetAwsAccountId(v string) *AwsSecurityFinding {
	s.AwsAccountId = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AwsSecurityFinding) SetCompliance(v *Compliance) *AwsSecurityFinding {
	s.Compliance = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *AwsSecurityFinding) SetConfidence(v int64) *AwsSecurityFinding {
	s.Confidence = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsSecurityFinding) SetCreatedAt(v string) *AwsSecurityFinding {
	s.CreatedAt = &v
	return s
}

// SetCriticality sets the Criticality field's value.
func (s *AwsSecurityFinding) SetCriticality(v int64) *AwsSecurityFinding {
	s.Criticality = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsSecurityFinding) SetDescription(v string) *AwsSecurityFinding {
	s.Description = &v
	return s
}

// SetFirstObservedAt sets the FirstObservedAt field's value.
func (s *AwsSecurityFinding) SetFirstObservedAt(v string) *AwsSecurityFinding {
	s.FirstObservedAt = &v
	return s
}

// SetGeneratorId sets the GeneratorId field's value.
func (s *AwsSecurityFinding) SetGeneratorId(v string) *AwsSecurityFinding {
	s.GeneratorId = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsSecurityFinding) SetId(v string) *AwsSecurityFinding {
	s.Id = &v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *AwsSecurityFinding) SetLastObservedAt(v string) *AwsSecurityFinding {
	s.LastObservedAt = &v
	return s
}

// SetMalware sets the Malware field's value.
func (s *AwsSecurityFinding) SetMalware(v []*Malware) *AwsSecurityFinding {
	s.Malware = v
	return s
}

// SetNetwork sets the Network field's value.
func (s *AwsSecurityFinding) SetNetwork(v *Network) *AwsSecurityFinding {
	s.Network = v
	return s
}

// SetNote sets the Note field's value.
func (s *AwsSecurityFinding) SetNote(v *Note) *AwsSecurityFinding {
	s.Note = v
	return s
}

// SetProcess sets the Process field's value.
func (s *AwsSecurityFinding) SetProcess(v *ProcessDetails) *AwsSecurityFinding {
	s.Process = v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *AwsSecurityFinding) SetProductArn(v string) *AwsSecurityFinding {
	s.ProductArn = &v
	return s
}

// SetProductFields sets the ProductFields field's value.
func (s *AwsSecurityFinding) SetProductFields(v map[string]*string) *AwsSecurityFinding {
	s.ProductFields = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *AwsSecurityFinding) SetRecordState(v string) *AwsSecurityFinding {
	s.RecordState = &v
	return s
}

// SetRelatedFindings sets the RelatedFindings field's value.
func (s *AwsSecurityFinding) SetRelatedFindings(v []*RelatedFinding) *AwsSecurityFinding {
	s.RelatedFindings = v
	return s
}

// SetRemediation sets the Remediation field's value.
func (s *AwsSecurityFinding) SetRemediation(v *Remediation) *AwsSecurityFinding {
	s.Remediation = v
	return s
}

// SetResources sets the Resources field's value.
func (s *AwsSecurityFinding) SetResources(v []*Resource) *AwsSecurityFinding {
	s.Resources = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *AwsSecurityFinding) SetSchemaVersion(v string) *AwsSecurityFinding {
	s.SchemaVersion = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *AwsSecurityFinding) SetSeverity(v *Severity) *AwsSecurityFinding {
	s.Severity = v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *AwsSecurityFinding) SetSourceUrl(v string) *AwsSecurityFinding {
	s.SourceUrl = &v
	return s
}

// SetThreatIntelIndicators sets the ThreatIntelIndicators field's value.
func (s *AwsSecurityFinding) SetThreatIntelIndicators(v []*ThreatIntelIndicator) *AwsSecurityFinding {
	s.ThreatIntelIndicators = v
	return s
}

// SetTitle sets the Title field's value.
func (s *AwsSecurityFinding) SetTitle(v string) *AwsSecurityFinding {
	s.Title = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *AwsSecurityFinding) SetTypes(v []*string) *AwsSecurityFinding {
	s.Types = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AwsSecurityFinding) SetUpdatedAt(v string) *AwsSecurityFinding {
	s.UpdatedAt = &v
	return s
}

// SetUserDefinedFields sets the UserDefinedFields field's value.
func (s *AwsSecurityFinding) SetUserDefinedFields(v map[string]*string) *AwsSecurityFinding {
	s.UserDefinedFields = v
	return s
}

// SetVerificationState sets the VerificationState field's value.
func (s *AwsSecurityFinding) SetVerificationState(v string) *AwsSecurityFinding {
	s.VerificationState = &v
	return s
}

// SetWorkflowState sets the WorkflowState field's value.
func (s *AwsSecurityFinding) SetWorkflowState(v string) *AwsSecurityFinding {
	s.WorkflowState = &v
	return s
}

// A collection of attributes that are applied to all active Security Hub-aggregated
// findings and that result in a subset of findings that are included in this
// insight.
type AwsSecurityFindingFilters struct {
	_ struct{} `type:"structure"`

	// The AWS account ID that a finding is generated in.
	AwsAccountId []*StringFilter `type:"list"`

	// The name of the findings provider (company) that owns the solution (product)
	// that generates findings.
	CompanyName []*StringFilter `type:"list"`

	// Exclusive to findings that are generated as the result of a check run against
	// a specific rule in a supported standard, such as CIS AWS Foundations. Contains
	// security standard-related finding details.
	ComplianceStatus []*StringFilter `type:"list"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
	// zero percent confidence and 100 means 100 percent confidence.
	Confidence []*NumberFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider captured the potential security issue that a finding captured.
	CreatedAt []*DateFilter `type:"list"`

	// The level of importance assigned to the resources associated with the finding.
	//
	// A score of 0 means that the underlying resources have no criticality, and
	// a score of 100 is reserved for the most critical resources.
	Criticality []*NumberFilter `type:"list"`

	// A finding's description.
	Description []*StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider first observed the potential security issue that a finding captured.
	FirstObservedAt []*DateFilter `type:"list"`

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security-findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plug-in, etc.
	GeneratorId []*StringFilter `type:"list"`

	// The security findings provider-specific identifier for a finding.
	Id []*StringFilter `type:"list"`

	// A keyword for a finding.
	Keyword []*KeywordFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider most recently observed the potential security issue that a finding
	// captured.
	LastObservedAt []*DateFilter `type:"list"`

	// The name of the malware that was observed.
	MalwareName []*StringFilter `type:"list"`

	// The filesystem path of the malware that was observed.
	MalwarePath []*StringFilter `type:"list"`

	// The state of the malware that was observed.
	MalwareState []*StringFilter `type:"list"`

	// The type of the malware that was observed.
	MalwareType []*StringFilter `type:"list"`

	// The destination domain of network-related information about a finding.
	NetworkDestinationDomain []*StringFilter `type:"list"`

	// The destination IPv4 address of network-related information about a finding.
	NetworkDestinationIpV4 []*IpFilter `type:"list"`

	// The destination IPv6 address of network-related information about a finding.
	NetworkDestinationIpV6 []*IpFilter `type:"list"`

	// The destination port of network-related information about a finding.
	NetworkDestinationPort []*NumberFilter `type:"list"`

	// Indicates the direction of network traffic associated with a finding.
	NetworkDirection []*StringFilter `type:"list"`

	// The protocol of network-related information about a finding.
	NetworkProtocol []*StringFilter `type:"list"`

	// The source domain of network-related information about a finding.
	NetworkSourceDomain []*StringFilter `type:"list"`

	// The source IPv4 address of network-related information about a finding.
	NetworkSourceIpV4 []*IpFilter `type:"list"`

	// The source IPv6 address of network-related information about a finding.
	NetworkSourceIpV6 []*IpFilter `type:"list"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	NetworkSourceMac []*StringFilter `type:"list"`

	// The source port of network-related information about a finding.
	NetworkSourcePort []*NumberFilter `type:"list"`

	// The text of a note.
	NoteText []*StringFilter `type:"list"`

	// The timestamp of when the note was updated.
	NoteUpdatedAt []*DateFilter `type:"list"`

	// The principal that created a note.
	NoteUpdatedBy []*StringFilter `type:"list"`

	// The date/time that the process was launched.
	ProcessLaunchedAt []*DateFilter `type:"list"`

	// The name of the process.
	ProcessName []*StringFilter `type:"list"`

	// The parent process ID.
	ProcessParentPid []*NumberFilter `type:"list"`

	// The path to the process executable.
	ProcessPath []*StringFilter `type:"list"`

	// The process ID.
	ProcessPid []*NumberFilter `type:"list"`

	// The date/time that the process was terminated.
	ProcessTerminatedAt []*DateFilter `type:"list"`

	// The ARN generated by Security Hub that uniquely identifies a third-party
	// company (security findings provider) after this provider's product (solution
	// that generates findings) is registered with Security Hub.
	ProductArn []*StringFilter `type:"list"`

	// A data type where security-findings providers can include additional solution-specific
	// details that aren't part of the defined AwsSecurityFinding format.
	ProductFields []*MapFilter `type:"list"`

	// The name of the solution (product) that generates findings.
	ProductName []*StringFilter `type:"list"`

	// The recommendation of what to do about the issue described in a finding.
	RecommendationText []*StringFilter `type:"list"`

	// The updated record state for the finding.
	RecordState []*StringFilter `type:"list"`

	// The solution-generated identifier for a related finding.
	RelatedFindingsId []*StringFilter `type:"list"`

	// The ARN of the solution that generated a related finding.
	RelatedFindingsProductArn []*StringFilter `type:"list"`

	// The IAM profile ARN of the instance.
	ResourceAwsEc2InstanceIamInstanceProfileArn []*StringFilter `type:"list"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ResourceAwsEc2InstanceImageId []*StringFilter `type:"list"`

	// The IPv4 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV4Addresses []*IpFilter `type:"list"`

	// The IPv6 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV6Addresses []*IpFilter `type:"list"`

	// The key name associated with the instance.
	ResourceAwsEc2InstanceKeyName []*StringFilter `type:"list"`

	// The date and time the instance was launched.
	ResourceAwsEc2InstanceLaunchedAt []*DateFilter `type:"list"`

	// The identifier of the subnet that the instance was launched in.
	ResourceAwsEc2InstanceSubnetId []*StringFilter `type:"list"`

	// The instance type of the instance.
	ResourceAwsEc2InstanceType []*StringFilter `type:"list"`

	// The identifier of the VPC that the instance was launched in.
	ResourceAwsEc2InstanceVpcId []*StringFilter `type:"list"`

	// The creation date/time of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyCreatedAt []*DateFilter `type:"list"`

	// The status of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyStatus []*StringFilter `type:"list"`

	// The user associated with the IAM access key related to a finding.
	ResourceAwsIamAccessKeyUserName []*StringFilter `type:"list"`

	// The canonical user ID of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerId []*StringFilter `type:"list"`

	// The display name of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerName []*StringFilter `type:"list"`

	// The identifier of the image related to a finding.
	ResourceContainerImageId []*StringFilter `type:"list"`

	// The name of the image related to a finding.
	ResourceContainerImageName []*StringFilter `type:"list"`

	// The date/time that the container was started.
	ResourceContainerLaunchedAt []*DateFilter `type:"list"`

	// The name of the container related to a finding.
	ResourceContainerName []*StringFilter `type:"list"`

	// The details of a resource that doesn't have a specific subfield for the resource
	// type defined.
	ResourceDetailsOther []*MapFilter `type:"list"`

	// The canonical identifier for the given resource type.
	ResourceId []*StringFilter `type:"list"`

	// The canonical AWS partition name that the Region is assigned to.
	ResourcePartition []*StringFilter `type:"list"`

	// The canonical AWS external Region name where this resource is located.
	ResourceRegion []*StringFilter `type:"list"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	ResourceTags []*MapFilter `type:"list"`

	// Specifies the type of the resource that details are provided for.
	ResourceType []*StringFilter `type:"list"`

	// The label of a finding's severity.
	SeverityLabel []*StringFilter `type:"list"`

	// The normalized severity of a finding.
	SeverityNormalized []*NumberFilter `type:"list"`

	// The native severity as defined by the security-findings provider's solution
	// that generated the finding.
	SeverityProduct []*NumberFilter `type:"list"`

	// A URL that links to a page about the current finding in the security-findings
	// provider's solution.
	SourceUrl []*StringFilter `type:"list"`

	// The category of a threat intelligence indicator.
	ThreatIntelIndicatorCategory []*StringFilter `type:"list"`

	// The date/time of the last observation of a threat intelligence indicator.
	ThreatIntelIndicatorLastObservedAt []*DateFilter `type:"list"`

	// The source of the threat intelligence.
	ThreatIntelIndicatorSource []*StringFilter `type:"list"`

	// The URL for more details from the source of the threat intelligence.
	ThreatIntelIndicatorSourceUrl []*StringFilter `type:"list"`

	// The type of a threat intelligence indicator.
	ThreatIntelIndicatorType []*StringFilter `type:"list"`

	// The value of a threat intelligence indicator.
	ThreatIntelIndicatorValue []*StringFilter `type:"list"`

	// A finding's title.
	Title []*StringFilter `type:"list"`

	// A finding type in the format of namespace/category/classifier that classifies
	// a finding.
	Type []*StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider last updated the finding record.
	UpdatedAt []*DateFilter `type:"list"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields []*MapFilter `type:"list"`

	// The veracity of a finding.
	VerificationState []*StringFilter `type:"list"`

	// The workflow state of a finding.
	WorkflowState []*StringFilter `type:"list"`
}

// String returns the string representation
func (s AwsSecurityFindingFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSecurityFindingFilters) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *AwsSecurityFindingFilters) SetAwsAccountId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.AwsAccountId = v
	return s
}

// SetCompanyName sets the CompanyName field's value.
func (s *AwsSecurityFindingFilters) SetCompanyName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.CompanyName = v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *AwsSecurityFindingFilters) SetComplianceStatus(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ComplianceStatus = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *AwsSecurityFindingFilters) SetConfidence(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.Confidence = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsSecurityFindingFilters) SetCreatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.CreatedAt = v
	return s
}

// SetCriticality sets the Criticality field's value.
func (s *AwsSecurityFindingFilters) SetCriticality(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.Criticality = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsSecurityFindingFilters) SetDescription(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Description = v
	return s
}

// SetFirstObservedAt sets the FirstObservedAt field's value.
func (s *AwsSecurityFindingFilters) SetFirstObservedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.FirstObservedAt = v
	return s
}

// SetGeneratorId sets the GeneratorId field's value.
func (s *AwsSecurityFindingFilters) SetGeneratorId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.GeneratorId = v
	return s
}

// SetId sets the Id field's value.
func (s *AwsSecurityFindingFilters) SetId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Id = v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *AwsSecurityFindingFilters) SetKeyword(v []*KeywordFilter) *AwsSecurityFindingFilters {
	s.Keyword = v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *AwsSecurityFindingFilters) SetLastObservedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.LastObservedAt = v
	return s
}

// SetMalwareName sets the MalwareName field's value.
func (s *AwsSecurityFindingFilters) SetMalwareName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwareName = v
	return s
}

// SetMalwarePath sets the MalwarePath field's value.
func (s *AwsSecurityFindingFilters) SetMalwarePath(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwarePath = v
	return s
}

// SetMalwareState sets the MalwareState field's value.
func (s *AwsSecurityFindingFilters) SetMalwareState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwareState = v
	return s
}

// SetMalwareType sets the MalwareType field's value.
func (s *AwsSecurityFindingFilters) SetMalwareType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwareType = v
	return s
}

// SetNetworkDestinationDomain sets the NetworkDestinationDomain field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationDomain(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationDomain = v
	return s
}

// SetNetworkDestinationIpV4 sets the NetworkDestinationIpV4 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationIpV4(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationIpV4 = v
	return s
}

// SetNetworkDestinationIpV6 sets the NetworkDestinationIpV6 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationIpV6(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationIpV6 = v
	return s
}

// SetNetworkDestinationPort sets the NetworkDestinationPort field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationPort(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationPort = v
	return s
}

// SetNetworkDirection sets the NetworkDirection field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDirection(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkDirection = v
	return s
}

// SetNetworkProtocol sets the NetworkProtocol field's value.
func (s *AwsSecurityFindingFilters) SetNetworkProtocol(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkProtocol = v
	return s
}

// SetNetworkSourceDomain sets the NetworkSourceDomain field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceDomain(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceDomain = v
	return s
}

// SetNetworkSourceIpV4 sets the NetworkSourceIpV4 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceIpV4(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceIpV4 = v
	return s
}

// SetNetworkSourceIpV6 sets the NetworkSourceIpV6 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceIpV6(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceIpV6 = v
	return s
}

// SetNetworkSourceMac sets the NetworkSourceMac field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceMac(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceMac = v
	return s
}

// SetNetworkSourcePort sets the NetworkSourcePort field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourcePort(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.NetworkSourcePort = v
	return s
}

// SetNoteText sets the NoteText field's value.
func (s *AwsSecurityFindingFilters) SetNoteText(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NoteText = v
	return s
}

// SetNoteUpdatedAt sets the NoteUpdatedAt field's value.
func (s *AwsSecurityFindingFilters) SetNoteUpdatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.NoteUpdatedAt = v
	return s
}

// SetNoteUpdatedBy sets the NoteUpdatedBy field's value.
func (s *AwsSecurityFindingFilters) SetNoteUpdatedBy(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NoteUpdatedBy = v
	return s
}

// SetProcessLaunchedAt sets the ProcessLaunchedAt field's value.
func (s *AwsSecurityFindingFilters) SetProcessLaunchedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ProcessLaunchedAt = v
	return s
}

// SetProcessName sets the ProcessName field's value.
func (s *AwsSecurityFindingFilters) SetProcessName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProcessName = v
	return s
}

// SetProcessParentPid sets the ProcessParentPid field's value.
func (s *AwsSecurityFindingFilters) SetProcessParentPid(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.ProcessParentPid = v
	return s
}

// SetProcessPath sets the ProcessPath field's value.
func (s *AwsSecurityFindingFilters) SetProcessPath(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProcessPath = v
	return s
}

// SetProcessPid sets the ProcessPid field's value.
func (s *AwsSecurityFindingFilters) SetProcessPid(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.ProcessPid = v
	return s
}

// SetProcessTerminatedAt sets the ProcessTerminatedAt field's value.
func (s *AwsSecurityFindingFilters) SetProcessTerminatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ProcessTerminatedAt = v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *AwsSecurityFindingFilters) SetProductArn(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProductArn = v
	return s
}

// SetProductFields sets the ProductFields field's value.
func (s *AwsSecurityFindingFilters) SetProductFields(v []*MapFilter) *AwsSecurityFindingFilters {
	s.ProductFields = v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *AwsSecurityFindingFilters) SetProductName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProductName = v
	return s
}

// SetRecommendationText sets the RecommendationText field's value.
func (s *AwsSecurityFindingFilters) SetRecommendationText(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RecommendationText = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *AwsSecurityFindingFilters) SetRecordState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RecordState = v
	return s
}

// SetRelatedFindingsId sets the RelatedFindingsId field's value.
func (s *AwsSecurityFindingFilters) SetRelatedFindingsId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RelatedFindingsId = v
	return s
}

// SetRelatedFindingsProductArn sets the RelatedFindingsProductArn field's value.
func (s *AwsSecurityFindingFilters) SetRelatedFindingsProductArn(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RelatedFindingsProductArn = v
	return s
}

// SetResourceAwsEc2InstanceIamInstanceProfileArn sets the ResourceAwsEc2InstanceIamInstanceProfileArn field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceIamInstanceProfileArn(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceIamInstanceProfileArn = v
	return s
}

// SetResourceAwsEc2InstanceImageId sets the ResourceAwsEc2InstanceImageId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceImageId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceImageId = v
	return s
}

// SetResourceAwsEc2InstanceIpV4Addresses sets the ResourceAwsEc2InstanceIpV4Addresses field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceIpV4Addresses(v []*IpFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceIpV4Addresses = v
	return s
}

// SetResourceAwsEc2InstanceIpV6Addresses sets the ResourceAwsEc2InstanceIpV6Addresses field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceIpV6Addresses(v []*IpFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceIpV6Addresses = v
	return s
}

// SetResourceAwsEc2InstanceKeyName sets the ResourceAwsEc2InstanceKeyName field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceKeyName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceKeyName = v
	return s
}

// SetResourceAwsEc2InstanceLaunchedAt sets the ResourceAwsEc2InstanceLaunchedAt field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceLaunchedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceLaunchedAt = v
	return s
}

// SetResourceAwsEc2InstanceSubnetId sets the ResourceAwsEc2InstanceSubnetId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceSubnetId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceSubnetId = v
	return s
}

// SetResourceAwsEc2InstanceType sets the ResourceAwsEc2InstanceType field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceType = v
	return s
}

// SetResourceAwsEc2InstanceVpcId sets the ResourceAwsEc2InstanceVpcId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceVpcId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceVpcId = v
	return s
}

// SetResourceAwsIamAccessKeyCreatedAt sets the ResourceAwsIamAccessKeyCreatedAt field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsIamAccessKeyCreatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsIamAccessKeyCreatedAt = v
	return s
}

// SetResourceAwsIamAccessKeyStatus sets the ResourceAwsIamAccessKeyStatus field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsIamAccessKeyStatus(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsIamAccessKeyStatus = v
	return s
}

// SetResourceAwsIamAccessKeyUserName sets the ResourceAwsIamAccessKeyUserName field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsIamAccessKeyUserName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsIamAccessKeyUserName = v
	return s
}

// SetResourceAwsS3BucketOwnerId sets the ResourceAwsS3BucketOwnerId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsS3BucketOwnerId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsS3BucketOwnerId = v
	return s
}

// SetResourceAwsS3BucketOwnerName sets the ResourceAwsS3BucketOwnerName field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsS3BucketOwnerName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsS3BucketOwnerName = v
	return s
}

// SetResourceContainerImageId sets the ResourceContainerImageId field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerImageId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerImageId = v
	return s
}

// SetResourceContainerImageName sets the ResourceContainerImageName field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerImageName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerImageName = v
	return s
}

// SetResourceContainerLaunchedAt sets the ResourceContainerLaunchedAt field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerLaunchedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerLaunchedAt = v
	return s
}

// SetResourceContainerName sets the ResourceContainerName field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerName = v
	return s
}

// SetResourceDetailsOther sets the ResourceDetailsOther field's value.
func (s *AwsSecurityFindingFilters) SetResourceDetailsOther(v []*MapFilter) *AwsSecurityFindingFilters {
	s.ResourceDetailsOther = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AwsSecurityFindingFilters) SetResourceId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceId = v
	return s
}

// SetResourcePartition sets the ResourcePartition field's value.
func (s *AwsSecurityFindingFilters) SetResourcePartition(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourcePartition = v
	return s
}

// SetResourceRegion sets the ResourceRegion field's value.
func (s *AwsSecurityFindingFilters) SetResourceRegion(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceRegion = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *AwsSecurityFindingFilters) SetResourceTags(v []*MapFilter) *AwsSecurityFindingFilters {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AwsSecurityFindingFilters) SetResourceType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceType = v
	return s
}

// SetSeverityLabel sets the SeverityLabel field's value.
func (s *AwsSecurityFindingFilters) SetSeverityLabel(v []*StringFilter) *AwsSecurityFindingFilters {
	s.SeverityLabel = v
	return s
}

// SetSeverityNormalized sets the SeverityNormalized field's value.
func (s *AwsSecurityFindingFilters) SetSeverityNormalized(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.SeverityNormalized = v
	return s
}

// SetSeverityProduct sets the SeverityProduct field's value.
func (s *AwsSecurityFindingFilters) SetSeverityProduct(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.SeverityProduct = v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *AwsSecurityFindingFilters) SetSourceUrl(v []*StringFilter) *AwsSecurityFindingFilters {
	s.SourceUrl = v
	return s
}

// SetThreatIntelIndicatorCategory sets the ThreatIntelIndicatorCategory field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorCategory(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorCategory = v
	return s
}

// SetThreatIntelIndicatorLastObservedAt sets the ThreatIntelIndicatorLastObservedAt field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorLastObservedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorLastObservedAt = v
	return s
}

// SetThreatIntelIndicatorSource sets the ThreatIntelIndicatorSource field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorSource(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorSource = v
	return s
}

// SetThreatIntelIndicatorSourceUrl sets the ThreatIntelIndicatorSourceUrl field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorSourceUrl(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorSourceUrl = v
	return s
}

// SetThreatIntelIndicatorType sets the ThreatIntelIndicatorType field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorType = v
	return s
}

// SetThreatIntelIndicatorValue sets the ThreatIntelIndicatorValue field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorValue(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorValue = v
	return s
}

// SetTitle sets the Title field's value.
func (s *AwsSecurityFindingFilters) SetTitle(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Title = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsSecurityFindingFilters) SetType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Type = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AwsSecurityFindingFilters) SetUpdatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.UpdatedAt = v
	return s
}

// SetUserDefinedFields sets the UserDefinedFields field's value.
func (s *AwsSecurityFindingFilters) SetUserDefinedFields(v []*MapFilter) *AwsSecurityFindingFilters {
	s.UserDefinedFields = v
	return s
}

// SetVerificationState sets the VerificationState field's value.
func (s *AwsSecurityFindingFilters) SetVerificationState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.VerificationState = v
	return s
}

// SetWorkflowState sets the WorkflowState field's value.
func (s *AwsSecurityFindingFilters) SetWorkflowState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.WorkflowState = v
	return s
}

// A wrapper type for the topic's Amazon Resource Name (ARN).
type AwsSnsTopicDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom
	// CMK.
	KmsMasterKeyId *string `type:"string"`

	// The subscription's owner.
	Owner *string `type:"string"`

	// Subscription is an embedded property that describes the subscription endpoints
	// of an Amazon SNS topic.
	Subscription []*AwsSnsTopicSubscription `type:"list"`

	// The name of the topic.
	TopicName *string `type:"string"`
}

// String returns the string representation
func (s AwsSnsTopicDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSnsTopicDetails) GoString() string {
	return s.String()
}

// SetKmsMasterKeyId sets the KmsMasterKeyId field's value.
func (s *AwsSnsTopicDetails) SetKmsMasterKeyId(v string) *AwsSnsTopicDetails {
	s.KmsMasterKeyId = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *AwsSnsTopicDetails) SetOwner(v string) *AwsSnsTopicDetails {
	s.Owner = &v
	return s
}

// SetSubscription sets the Subscription field's value.
func (s *AwsSnsTopicDetails) SetSubscription(v []*AwsSnsTopicSubscription) *AwsSnsTopicDetails {
	s.Subscription = v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *AwsSnsTopicDetails) SetTopicName(v string) *AwsSnsTopicDetails {
	s.TopicName = &v
	return s
}

// A wrapper type for the attributes of an Amazon SNS subscription.
type AwsSnsTopicSubscription struct {
	_ struct{} `type:"structure"`

	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string `type:"string"`

	// The subscription's protocol.
	Protocol *string `type:"string"`
}

// String returns the string representation
func (s AwsSnsTopicSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSnsTopicSubscription) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsSnsTopicSubscription) SetEndpoint(v string) *AwsSnsTopicSubscription {
	s.Endpoint = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AwsSnsTopicSubscription) SetProtocol(v string) *AwsSnsTopicSubscription {
	s.Protocol = &v
	return s
}

// Data about a queue.
type AwsSqsQueueDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon SQS
	// moves messages after the value of maxReceiveCount is exceeded.
	DeadLetterTargetArn *string `type:"string"`

	// The length of time, in seconds, for which Amazon SQS can reuse a data key
	// to encrypt or decrypt messages before calling AWS KMS again.
	KmsDataKeyReusePeriodSeconds *int64 `type:"integer"`

	// The ID of an AWS-managed customer master key (CMK) for Amazon SQS or a custom
	// CMK.
	KmsMasterKeyId *string `type:"string"`

	// The name of the new queue.
	QueueName *string `type:"string"`
}

// String returns the string representation
func (s AwsSqsQueueDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSqsQueueDetails) GoString() string {
	return s.String()
}

// SetDeadLetterTargetArn sets the DeadLetterTargetArn field's value.
func (s *AwsSqsQueueDetails) SetDeadLetterTargetArn(v string) *AwsSqsQueueDetails {
	s.DeadLetterTargetArn = &v
	return s
}

// SetKmsDataKeyReusePeriodSeconds sets the KmsDataKeyReusePeriodSeconds field's value.
func (s *AwsSqsQueueDetails) SetKmsDataKeyReusePeriodSeconds(v int64) *AwsSqsQueueDetails {
	s.KmsDataKeyReusePeriodSeconds = &v
	return s
}

// SetKmsMasterKeyId sets the KmsMasterKeyId field's value.
func (s *AwsSqsQueueDetails) SetKmsMasterKeyId(v string) *AwsSqsQueueDetails {
	s.KmsMasterKeyId = &v
	return s
}

// SetQueueName sets the QueueName field's value.
func (s *AwsSqsQueueDetails) SetQueueName(v string) *AwsSqsQueueDetails {
	s.QueueName = &v
	return s
}

// Details about a WAF WebACL.
type AwsWafWebAclDetails struct {
	_ struct{} `type:"structure"`

	// The action to perform if none of the Rules contained in the WebACL match.
	DefaultAction *string `type:"string"`

	// A friendly name or description of the WebACL. You can't change the name of
	// a WebACL after you create it.
	Name *string `type:"string"`

	// An array that contains the action for each rule in a WebACL, the priority
	// of the rule, and the ID of the rule.
	Rules []*AwsWafWebAclRule `type:"list"`

	// A unique identifier for a WebACL.
	WebAclId *string `type:"string"`
}

// String returns the string representation
func (s AwsWafWebAclDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsWafWebAclDetails) GoString() string {
	return s.String()
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *AwsWafWebAclDetails) SetDefaultAction(v string) *AwsWafWebAclDetails {
	s.DefaultAction = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsWafWebAclDetails) SetName(v string) *AwsWafWebAclDetails {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *AwsWafWebAclDetails) SetRules(v []*AwsWafWebAclRule) *AwsWafWebAclDetails {
	s.Rules = v
	return s
}

// SetWebAclId sets the WebAclId field's value.
func (s *AwsWafWebAclDetails) SetWebAclId(v string) *AwsWafWebAclDetails {
	s.WebAclId = &v
	return s
}

// Details for a rule in a WAF WebACL.
type AwsWafWebAclRule struct {
	_ struct{} `type:"structure"`

	// Specifies the action that CloudFront or AWS WAF takes when a web request
	// matches the conditions in the Rule.
	Action *WafAction `type:"structure"`

	// Rules to exclude from a rule group.
	ExcludedRules []*WafExcludedRule `type:"list"`

	// Use the OverrideAction to test your RuleGroup.
	//
	// Any rule in a RuleGroup can potentially block a request. If you set the OverrideAction
	// to None, the RuleGroup blocks a request if any individual rule in the RuleGroup
	// matches the request and is configured to block that request.
	//
	// However, if you first want to test the RuleGroup, set the OverrideAction
	// to Count. The RuleGroup then overrides any block action specified by individual
	// rules contained within the group. Instead of blocking matching requests,
	// those requests are counted.
	//
	// ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup
	// to a WebACL. In this case you do not use ActivatedRule|Action. For all other
	// update requests, ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.
	OverrideAction *WafOverrideAction `type:"structure"`

	// Specifies the order in which the Rules in a WebACL are evaluated. Rules with
	// a lower value for Priority are evaluated before Rules with a higher value.
	// The value must be a unique integer. If you add multiple Rules to a WebACL,
	// the values do not need to be consecutive.
	Priority *int64 `type:"integer"`

	// The identifier for a Rule.
	RuleId *string `type:"string"`

	// The rule type.
	//
	// Valid values: REGULAR | RATE_BASED | GROUP
	//
	// The default is REGULAR.
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsWafWebAclRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsWafWebAclRule) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *AwsWafWebAclRule) SetAction(v *WafAction) *AwsWafWebAclRule {
	s.Action = v
	return s
}

// SetExcludedRules sets the ExcludedRules field's value.
func (s *AwsWafWebAclRule) SetExcludedRules(v []*WafExcludedRule) *AwsWafWebAclRule {
	s.ExcludedRules = v
	return s
}

// SetOverrideAction sets the OverrideAction field's value.
func (s *AwsWafWebAclRule) SetOverrideAction(v *WafOverrideAction) *AwsWafWebAclRule {
	s.OverrideAction = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *AwsWafWebAclRule) SetPriority(v int64) *AwsWafWebAclRule {
	s.Priority = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *AwsWafWebAclRule) SetRuleId(v string) *AwsWafWebAclRule {
	s.RuleId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsWafWebAclRule) SetType(v string) *AwsWafWebAclRule {
	s.Type = &v
	return s
}

type BatchDisableStandardsInput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the standards subscriptions to disable.
	//
	// StandardsSubscriptionArns is a required field
	StandardsSubscriptionArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDisableStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisableStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisableStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisableStandardsInput"}
	if s.StandardsSubscriptionArns == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsSubscriptionArns"))
	}
	if s.StandardsSubscriptionArns != nil && len(s.StandardsSubscriptionArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStandardsSubscriptionArns sets the StandardsSubscriptionArns field's value.
func (s *BatchDisableStandardsInput) SetStandardsSubscriptionArns(v []*string) *BatchDisableStandardsInput {
	s.StandardsSubscriptionArns = v
	return s
}

type BatchDisableStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the standards subscriptions that were disabled.
	StandardsSubscriptions []*StandardsSubscription `type:"list"`
}

// String returns the string representation
func (s BatchDisableStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisableStandardsOutput) GoString() string {
	return s.String()
}

// SetStandardsSubscriptions sets the StandardsSubscriptions field's value.
func (s *BatchDisableStandardsOutput) SetStandardsSubscriptions(v []*StandardsSubscription) *BatchDisableStandardsOutput {
	s.StandardsSubscriptions = v
	return s
}

type BatchEnableStandardsInput struct {
	_ struct{} `type:"structure"`

	// The list of standards checks to enable.
	//
	// StandardsSubscriptionRequests is a required field
	StandardsSubscriptionRequests []*StandardsSubscriptionRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchEnableStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEnableStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchEnableStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchEnableStandardsInput"}
	if s.StandardsSubscriptionRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsSubscriptionRequests"))
	}
	if s.StandardsSubscriptionRequests != nil && len(s.StandardsSubscriptionRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionRequests", 1))
	}
	if s.StandardsSubscriptionRequests != nil {
		for i, v := range s.StandardsSubscriptionRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StandardsSubscriptionRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStandardsSubscriptionRequests sets the StandardsSubscriptionRequests field's value.
func (s *BatchEnableStandardsInput) SetStandardsSubscriptionRequests(v []*StandardsSubscriptionRequest) *BatchEnableStandardsInput {
	s.StandardsSubscriptionRequests = v
	return s
}

type BatchEnableStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the standards subscriptions that were enabled.
	StandardsSubscriptions []*StandardsSubscription `type:"list"`
}

// String returns the string representation
func (s BatchEnableStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEnableStandardsOutput) GoString() string {
	return s.String()
}

// SetStandardsSubscriptions sets the StandardsSubscriptions field's value.
func (s *BatchEnableStandardsOutput) SetStandardsSubscriptions(v []*StandardsSubscription) *BatchEnableStandardsOutput {
	s.StandardsSubscriptions = v
	return s
}

type BatchImportFindingsInput struct {
	_ struct{} `type:"structure"`

	// A list of findings to import. To successfully import a finding, it must follow
	// the AWS Security Finding Format (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html).
	// Maximum of 100 findings per request.
	//
	// Findings is a required field
	Findings []*AwsSecurityFinding `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchImportFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchImportFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchImportFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchImportFindingsInput"}
	if s.Findings == nil {
		invalidParams.Add(request.NewErrParamRequired("Findings"))
	}
	if s.Findings != nil {
		for i, v := range s.Findings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Findings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindings sets the Findings field's value.
func (s *BatchImportFindingsInput) SetFindings(v []*AwsSecurityFinding) *BatchImportFindingsInput {
	s.Findings = v
	return s
}

type BatchImportFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The number of findings that failed to import.
	//
	// FailedCount is a required field
	FailedCount *int64 `type:"integer" required:"true"`

	// The list of findings that failed to import.
	FailedFindings []*ImportFindingsError `type:"list"`

	// The number of findings that were successfully imported.
	//
	// SuccessCount is a required field
	SuccessCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s BatchImportFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchImportFindingsOutput) GoString() string {
	return s.String()
}

// SetFailedCount sets the FailedCount field's value.
func (s *BatchImportFindingsOutput) SetFailedCount(v int64) *BatchImportFindingsOutput {
	s.FailedCount = &v
	return s
}

// SetFailedFindings sets the FailedFindings field's value.
func (s *BatchImportFindingsOutput) SetFailedFindings(v []*ImportFindingsError) *BatchImportFindingsOutput {
	s.FailedFindings = v
	return s
}

// SetSuccessCount sets the SuccessCount field's value.
func (s *BatchImportFindingsOutput) SetSuccessCount(v int64) *BatchImportFindingsOutput {
	s.SuccessCount = &v
	return s
}

// Exclusive to findings that are generated as the result of a check run against
// a specific rule in a supported security standard, such as CIS AWS Foundations.
// Contains security standard-related finding details.
//
// Values include the following:
//
//    * Allowed values are the following: PASSED - Standards check passed for
//    all evaluated resources. WARNING - Some information is missing or this
//    check is not supported given your configuration. FAILED - Standards check
//    failed for at least one evaluated resource. NOT_AVAILABLE - Check could
//    not be performed due to a service outage, API error, or because the result
//    of the AWS Config evaluation was NOT_APPLICABLE. If the AWS Config evaluation
//    result was NOT_APPLICABLE, then after 3 days, Security Hub automatically
//    archives the finding.
type Compliance struct {
	_ struct{} `type:"structure"`

	// List of requirements that are related to a standards control.
	RelatedRequirements []*string `type:"list"`

	// The result of a standards check.
	Status *string `type:"string" enum:"ComplianceStatus"`
}

// String returns the string representation
func (s Compliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Compliance) GoString() string {
	return s.String()
}

// SetRelatedRequirements sets the RelatedRequirements field's value.
func (s *Compliance) SetRelatedRequirements(v []*string) *Compliance {
	s.RelatedRequirements = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Compliance) SetStatus(v string) *Compliance {
	s.Status = &v
	return s
}

// Container details related to a finding.
type ContainerDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the image related to a finding.
	ImageId *string `type:"string"`

	// The name of the image related to a finding.
	ImageName *string `type:"string"`

	// The date and time when the container started.
	LaunchedAt *string `type:"string"`

	// The name of the container related to a finding.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ContainerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerDetails) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *ContainerDetails) SetImageId(v string) *ContainerDetails {
	s.ImageId = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *ContainerDetails) SetImageName(v string) *ContainerDetails {
	s.ImageName = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *ContainerDetails) SetLaunchedAt(v string) *ContainerDetails {
	s.LaunchedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContainerDetails) SetName(v string) *ContainerDetails {
	s.Name = &v
	return s
}

type CreateActionTargetInput struct {
	_ struct{} `type:"structure"`

	// The description for the custom action target.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The ID for the custom action target.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The name of the custom action target.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateActionTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActionTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateActionTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateActionTargetInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateActionTargetInput) SetDescription(v string) *CreateActionTargetInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateActionTargetInput) SetId(v string) *CreateActionTargetInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateActionTargetInput) SetName(v string) *CreateActionTargetInput {
	s.Name = &v
	return s
}

type CreateActionTargetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the custom action target.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateActionTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActionTargetOutput) GoString() string {
	return s.String()
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *CreateActionTargetOutput) SetActionTargetArn(v string) *CreateActionTargetOutput {
	s.ActionTargetArn = &v
	return s
}

type CreateInsightInput struct {
	_ struct{} `type:"structure"`

	// One or more attributes used to filter the findings included in the insight.
	// The insight only includes findings that match the criteria defined in the
	// filters.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The attribute used as the aggregator to group related findings for the insight.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The name of the custom insight to create.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInsightInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.GroupByAttribute == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupByAttribute"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *CreateInsightInput) SetFilters(v *AwsSecurityFindingFilters) *CreateInsightInput {
	s.Filters = v
	return s
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *CreateInsightInput) SetGroupByAttribute(v string) *CreateInsightInput {
	s.GroupByAttribute = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInsightInput) SetName(v string) *CreateInsightInput {
	s.Name = &v
	return s
}

type CreateInsightOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight created.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInsightOutput) GoString() string {
	return s.String()
}

// SetInsightArn sets the InsightArn field's value.
func (s *CreateInsightOutput) SetInsightArn(v string) *CreateInsightOutput {
	s.InsightArn = &v
	return s
}

type CreateMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of accounts to associate with the Security Hub master account. For
	// each account, the list includes the account ID and the email address.
	AccountDetails []*AccountDetails `type:"list"`
}

// String returns the string representation
func (s CreateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersInput) GoString() string {
	return s.String()
}

// SetAccountDetails sets the AccountDetails field's value.
func (s *CreateMembersInput) SetAccountDetails(v []*AccountDetails) *CreateMembersInput {
	s.AccountDetails = v
	return s
}

type CreateMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts that were not processed. For each account, the list
	// includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s CreateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *CreateMembersOutput) SetUnprocessedAccounts(v []*Result) *CreateMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// A date filter for querying findings.
type DateFilter struct {
	_ struct{} `type:"structure"`

	// A date range for the date filter.
	DateRange *DateRange `type:"structure"`

	// An end date for the date filter.
	End *string `type:"string"`

	// A start date for the date filter.
	Start *string `type:"string"`
}

// String returns the string representation
func (s DateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateFilter) GoString() string {
	return s.String()
}

// SetDateRange sets the DateRange field's value.
func (s *DateFilter) SetDateRange(v *DateRange) *DateFilter {
	s.DateRange = v
	return s
}

// SetEnd sets the End field's value.
func (s *DateFilter) SetEnd(v string) *DateFilter {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *DateFilter) SetStart(v string) *DateFilter {
	s.Start = &v
	return s
}

// A date range for the date filter.
type DateRange struct {
	_ struct{} `type:"structure"`

	// A date range unit for the date filter.
	Unit *string `type:"string" enum:"DateRangeUnit"`

	// A date range value for the date filter.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s DateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateRange) GoString() string {
	return s.String()
}

// SetUnit sets the Unit field's value.
func (s *DateRange) SetUnit(v string) *DateRange {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DateRange) SetValue(v int64) *DateRange {
	s.Value = &v
	return s
}

type DeclineInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The list of account IDs for the accounts from which to decline the invitations
	// to Security Hub.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeclineInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeclineInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeclineInvitationsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeclineInvitationsInput) SetAccountIds(v []*string) *DeclineInvitationsInput {
	s.AccountIds = v
	return s
}

type DeclineInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts that were not processed. For each account, the list
	// includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s DeclineInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeclineInvitationsOutput) SetUnprocessedAccounts(v []*Result) *DeclineInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteActionTargetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom action target to delete.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `location:"uri" locationName:"ActionTargetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteActionTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActionTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteActionTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteActionTargetInput"}
	if s.ActionTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTargetArn"))
	}
	if s.ActionTargetArn != nil && len(*s.ActionTargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionTargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *DeleteActionTargetInput) SetActionTargetArn(v string) *DeleteActionTargetInput {
	s.ActionTargetArn = &v
	return s
}

type DeleteActionTargetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom action target that was deleted.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteActionTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActionTargetOutput) GoString() string {
	return s.String()
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *DeleteActionTargetOutput) SetActionTargetArn(v string) *DeleteActionTargetOutput {
	s.ActionTargetArn = &v
	return s
}

type DeleteInsightInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight to delete.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInsightInput"}
	if s.InsightArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightArn"))
	}
	if s.InsightArn != nil && len(*s.InsightArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightArn sets the InsightArn field's value.
func (s *DeleteInsightInput) SetInsightArn(v string) *DeleteInsightInput {
	s.InsightArn = &v
	return s
}

type DeleteInsightOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight that was deleted.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInsightOutput) GoString() string {
	return s.String()
}

// SetInsightArn sets the InsightArn field's value.
func (s *DeleteInsightOutput) SetInsightArn(v string) *DeleteInsightOutput {
	s.InsightArn = &v
	return s
}

type DeleteInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The list of the account IDs that sent the invitations to delete.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInvitationsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteInvitationsInput) SetAccountIds(v []*string) *DeleteInvitationsInput {
	s.AccountIds = v
	return s
}

type DeleteInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts for which the invitations were not deleted. For
	// each account, the list includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s DeleteInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteInvitationsOutput) SetUnprocessedAccounts(v []*Result) *DeleteInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of account IDs for the member accounts to delete.
	AccountIds []*string `type:"list"`
}

// String returns the string representation
func (s DeleteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteMembersInput) SetAccountIds(v []*string) *DeleteMembersInput {
	s.AccountIds = v
	return s
}

type DeleteMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts that were not deleted. For each account, the list
	// includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s DeleteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteMembersOutput) SetUnprocessedAccounts(v []*Result) *DeleteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type DescribeActionTargetsInput struct {
	_ struct{} `type:"structure"`

	// A list of custom action target ARNs for the custom action targets to retrieve.
	ActionTargetArns []*string `type:"list"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeActionTargets
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActionTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActionTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeActionTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeActionTargetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTargetArns sets the ActionTargetArns field's value.
func (s *DescribeActionTargetsInput) SetActionTargetArns(v []*string) *DescribeActionTargetsInput {
	s.ActionTargetArns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeActionTargetsInput) SetMaxResults(v int64) *DescribeActionTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeActionTargetsInput) SetNextToken(v string) *DescribeActionTargetsInput {
	s.NextToken = &v
	return s
}

type DescribeActionTargetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ActionTarget objects. Each object includes the ActionTargetArn,
	// Description, and Name of a custom action target available in Security Hub.
	//
	// ActionTargets is a required field
	ActionTargets []*ActionTarget `type:"list" required:"true"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActionTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActionTargetsOutput) GoString() string {
	return s.String()
}

// SetActionTargets sets the ActionTargets field's value.
func (s *DescribeActionTargetsOutput) SetActionTargets(v []*ActionTarget) *DescribeActionTargetsOutput {
	s.ActionTargets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeActionTargetsOutput) SetNextToken(v string) *DescribeActionTargetsOutput {
	s.NextToken = &v
	return s
}

type DescribeHubInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Hub resource to retrieve.
	HubArn *string `location:"querystring" locationName:"HubArn" type:"string"`
}

// String returns the string representation
func (s DescribeHubInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHubInput) GoString() string {
	return s.String()
}

// SetHubArn sets the HubArn field's value.
func (s *DescribeHubInput) SetHubArn(v string) *DescribeHubInput {
	s.HubArn = &v
	return s
}

type DescribeHubOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Hub resource that was retrieved.
	HubArn *string `type:"string"`

	// The date and time when Security Hub was enabled in the account.
	SubscribedAt *string `type:"string"`
}

// String returns the string representation
func (s DescribeHubOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHubOutput) GoString() string {
	return s.String()
}

// SetHubArn sets the HubArn field's value.
func (s *DescribeHubOutput) SetHubArn(v string) *DescribeHubOutput {
	s.HubArn = &v
	return s
}

// SetSubscribedAt sets the SubscribedAt field's value.
func (s *DescribeHubOutput) SetSubscribedAt(v string) *DescribeHubOutput {
	s.SubscribedAt = &v
	return s
}

type DescribeProductsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeProducts
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s DescribeProductsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProductsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProductsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeProductsInput) SetMaxResults(v int64) *DescribeProductsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeProductsInput) SetNextToken(v string) *DescribeProductsInput {
	s.NextToken = &v
	return s
}

type DescribeProductsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`

	// A list of products, including details for each product.
	//
	// Products is a required field
	Products []*Product `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeProductsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeProductsOutput) SetNextToken(v string) *DescribeProductsOutput {
	s.NextToken = &v
	return s
}

// SetProducts sets the Products field's value.
func (s *DescribeProductsOutput) SetProducts(v []*Product) *DescribeProductsOutput {
	s.Products = v
	return s
}

type DescribeStandardsControlsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of security standard controls to return.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeStandardsControls
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ARN of a resource that represents your subscription to a supported standard.
	//
	// StandardsSubscriptionArn is a required field
	StandardsSubscriptionArn *string `location:"uri" locationName:"StandardsSubscriptionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStandardsControlsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStandardsControlsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStandardsControlsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStandardsControlsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StandardsSubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsSubscriptionArn"))
	}
	if s.StandardsSubscriptionArn != nil && len(*s.StandardsSubscriptionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeStandardsControlsInput) SetMaxResults(v int64) *DescribeStandardsControlsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStandardsControlsInput) SetNextToken(v string) *DescribeStandardsControlsInput {
	s.NextToken = &v
	return s
}

// SetStandardsSubscriptionArn sets the StandardsSubscriptionArn field's value.
func (s *DescribeStandardsControlsInput) SetStandardsSubscriptionArn(v string) *DescribeStandardsControlsInput {
	s.StandardsSubscriptionArn = &v
	return s
}

type DescribeStandardsControlsOutput struct {
	_ struct{} `type:"structure"`

	// A list of security standards controls.
	Controls []*StandardsControl `type:"list"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeStandardsControlsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStandardsControlsOutput) GoString() string {
	return s.String()
}

// SetControls sets the Controls field's value.
func (s *DescribeStandardsControlsOutput) SetControls(v []*StandardsControl) *DescribeStandardsControlsOutput {
	s.Controls = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStandardsControlsOutput) SetNextToken(v string) *DescribeStandardsControlsOutput {
	s.NextToken = &v
	return s
}

type DescribeStandardsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of standards to return.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeStandards
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s DescribeStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStandardsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeStandardsInput) SetMaxResults(v int64) *DescribeStandardsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStandardsInput) SetNextToken(v string) *DescribeStandardsInput {
	s.NextToken = &v
	return s
}

type DescribeStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`

	// A list of available standards.
	Standards []*Standard `type:"list"`
}

// String returns the string representation
func (s DescribeStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStandardsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStandardsOutput) SetNextToken(v string) *DescribeStandardsOutput {
	s.NextToken = &v
	return s
}

// SetStandards sets the Standards field's value.
func (s *DescribeStandardsOutput) SetStandards(v []*Standard) *DescribeStandardsOutput {
	s.Standards = v
	return s
}

type DisableImportFindingsForProductInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the integrated product to disable the integration for.
	//
	// ProductSubscriptionArn is a required field
	ProductSubscriptionArn *string `location:"uri" locationName:"ProductSubscriptionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableImportFindingsForProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableImportFindingsForProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableImportFindingsForProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableImportFindingsForProductInput"}
	if s.ProductSubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductSubscriptionArn"))
	}
	if s.ProductSubscriptionArn != nil && len(*s.ProductSubscriptionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductSubscriptionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProductSubscriptionArn sets the ProductSubscriptionArn field's value.
func (s *DisableImportFindingsForProductInput) SetProductSubscriptionArn(v string) *DisableImportFindingsForProductInput {
	s.ProductSubscriptionArn = &v
	return s
}

type DisableImportFindingsForProductOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableImportFindingsForProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableImportFindingsForProductOutput) GoString() string {
	return s.String()
}

type DisableSecurityHubInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableSecurityHubInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSecurityHubInput) GoString() string {
	return s.String()
}

type DisableSecurityHubOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableSecurityHubOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSecurityHubOutput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountInput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountOutput) GoString() string {
	return s.String()
}

type DisassociateMembersInput struct {
	_ struct{} `type:"structure"`

	// The account IDs of the member accounts to disassociate from the master account.
	AccountIds []*string `type:"list"`
}

// String returns the string representation
func (s DisassociateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DisassociateMembersInput) SetAccountIds(v []*string) *DisassociateMembersInput {
	s.AccountIds = v
	return s
}

type DisassociateMembersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersOutput) GoString() string {
	return s.String()
}

type EnableImportFindingsForProductInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the product to enable the integration for.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableImportFindingsForProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableImportFindingsForProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableImportFindingsForProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableImportFindingsForProductInput"}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProductArn sets the ProductArn field's value.
func (s *EnableImportFindingsForProductInput) SetProductArn(v string) *EnableImportFindingsForProductInput {
	s.ProductArn = &v
	return s
}

type EnableImportFindingsForProductOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of your subscription to the product to enable integrations for.
	ProductSubscriptionArn *string `type:"string"`
}

// String returns the string representation
func (s EnableImportFindingsForProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableImportFindingsForProductOutput) GoString() string {
	return s.String()
}

// SetProductSubscriptionArn sets the ProductSubscriptionArn field's value.
func (s *EnableImportFindingsForProductOutput) SetProductSubscriptionArn(v string) *EnableImportFindingsForProductOutput {
	s.ProductSubscriptionArn = &v
	return s
}

type EnableSecurityHubInput struct {
	_ struct{} `type:"structure"`

	// The tags to add to the Hub resource when you enable Security Hub.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s EnableSecurityHubInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSecurityHubInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableSecurityHubInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableSecurityHubInput"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *EnableSecurityHubInput) SetTags(v map[string]*string) *EnableSecurityHubInput {
	s.Tags = v
	return s
}

type EnableSecurityHubOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableSecurityHubOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSecurityHubOutput) GoString() string {
	return s.String()
}

type GetEnabledStandardsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the GetEnabledStandards
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `type:"string"`

	// The list of the standards subscription ARNs for the standards to retrieve.
	StandardsSubscriptionArns []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s GetEnabledStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnabledStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnabledStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnabledStandardsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StandardsSubscriptionArns != nil && len(s.StandardsSubscriptionArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEnabledStandardsInput) SetMaxResults(v int64) *GetEnabledStandardsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEnabledStandardsInput) SetNextToken(v string) *GetEnabledStandardsInput {
	s.NextToken = &v
	return s
}

// SetStandardsSubscriptionArns sets the StandardsSubscriptionArns field's value.
func (s *GetEnabledStandardsInput) SetStandardsSubscriptionArns(v []*string) *GetEnabledStandardsInput {
	s.StandardsSubscriptionArns = v
	return s
}

type GetEnabledStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`

	// The list of StandardsSubscriptions objects that include information about
	// the enabled standards.
	StandardsSubscriptions []*StandardsSubscription `type:"list"`
}

// String returns the string representation
func (s GetEnabledStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnabledStandardsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetEnabledStandardsOutput) SetNextToken(v string) *GetEnabledStandardsOutput {
	s.NextToken = &v
	return s
}

// SetStandardsSubscriptions sets the StandardsSubscriptions field's value.
func (s *GetEnabledStandardsOutput) SetStandardsSubscriptions(v []*StandardsSubscription) *GetEnabledStandardsOutput {
	s.StandardsSubscriptions = v
	return s
}

type GetFindingsInput struct {
	_ struct{} `type:"structure"`

	// The finding attributes used to define a condition to filter the returned
	// findings.
	Filters *AwsSecurityFindingFilters `type:"structure"`

	// The maximum number of findings to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the GetFindings
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `type:"string"`

	// The finding attributes used to sort the list of returned findings.
	SortCriteria []*SortCriterion `type:"list"`
}

// String returns the string representation
func (s GetFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *GetFindingsInput) SetFilters(v *AwsSecurityFindingFilters) *GetFindingsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetFindingsInput) SetMaxResults(v int64) *GetFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFindingsInput) SetNextToken(v string) *GetFindingsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *GetFindingsInput) SetSortCriteria(v []*SortCriterion) *GetFindingsInput {
	s.SortCriteria = v
	return s
}

type GetFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The findings that matched the filters specified in the request.
	//
	// Findings is a required field
	Findings []*AwsSecurityFinding `type:"list" required:"true"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *GetFindingsOutput) SetFindings(v []*AwsSecurityFinding) *GetFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFindingsOutput) SetNextToken(v string) *GetFindingsOutput {
	s.NextToken = &v
	return s
}

type GetInsightResultsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight for which to return results.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInsightResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInsightResultsInput"}
	if s.InsightArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightArn"))
	}
	if s.InsightArn != nil && len(*s.InsightArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightArn sets the InsightArn field's value.
func (s *GetInsightResultsInput) SetInsightArn(v string) *GetInsightResultsInput {
	s.InsightArn = &v
	return s
}

type GetInsightResultsOutput struct {
	_ struct{} `type:"structure"`

	// The insight results returned by the operation.
	//
	// InsightResults is a required field
	InsightResults *InsightResults `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetInsightResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightResultsOutput) GoString() string {
	return s.String()
}

// SetInsightResults sets the InsightResults field's value.
func (s *GetInsightResultsOutput) SetInsightResults(v *InsightResults) *GetInsightResultsOutput {
	s.InsightResults = v
	return s
}

type GetInsightsInput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the insights to describe.
	InsightArns []*string `type:"list"`

	// The maximum number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the GetInsights
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightArns sets the InsightArns field's value.
func (s *GetInsightsInput) SetInsightArns(v []*string) *GetInsightsInput {
	s.InsightArns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetInsightsInput) SetMaxResults(v int64) *GetInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInsightsInput) SetNextToken(v string) *GetInsightsInput {
	s.NextToken = &v
	return s
}

type GetInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The insights returned by the operation.
	//
	// Insights is a required field
	Insights []*Insight `type:"list" required:"true"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightsOutput) GoString() string {
	return s.String()
}

// SetInsights sets the Insights field's value.
func (s *GetInsightsOutput) SetInsights(v []*Insight) *GetInsightsOutput {
	s.Insights = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInsightsOutput) SetNextToken(v string) *GetInsightsOutput {
	s.NextToken = &v
	return s
}

type GetInvitationsCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetInvitationsCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountInput) GoString() string {
	return s.String()
}

type GetInvitationsCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of all membership invitations sent to this Security Hub member
	// account, not including the currently accepted invitation.
	InvitationsCount *int64 `type:"integer"`
}

// String returns the string representation
func (s GetInvitationsCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountOutput) GoString() string {
	return s.String()
}

// SetInvitationsCount sets the InvitationsCount field's value.
func (s *GetInvitationsCountOutput) SetInvitationsCount(v int64) *GetInvitationsCountOutput {
	s.InvitationsCount = &v
	return s
}

type GetMasterAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountInput) GoString() string {
	return s.String()
}

type GetMasterAccountOutput struct {
	_ struct{} `type:"structure"`

	// A list of details about the Security Hub master account for the current member
	// account.
	Master *Invitation `type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountOutput) GoString() string {
	return s.String()
}

// SetMaster sets the Master field's value.
func (s *GetMasterAccountOutput) SetMaster(v *Invitation) *GetMasterAccountOutput {
	s.Master = v
	return s
}

type GetMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of account IDs for the Security Hub member accounts to return the
	// details for.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetMembersInput) SetAccountIds(v []*string) *GetMembersInput {
	s.AccountIds = v
	return s
}

type GetMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of details about the Security Hub member accounts.
	Members []*Member `type:"list"`

	// The list of AWS accounts that could not be processed. For each account, the
	// list includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s GetMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *GetMembersOutput) SetMembers(v []*Member) *GetMembersOutput {
	s.Members = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *GetMembersOutput) SetUnprocessedAccounts(v []*Result) *GetMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// Includes details of the list of the findings that cannot be imported.
type ImportFindingsError struct {
	_ struct{} `type:"structure"`

	// The code of the error made during the BatchImportFindings operation.
	//
	// ErrorCode is a required field
	ErrorCode *string `type:"string" required:"true"`

	// The message of the error made during the BatchImportFindings operation.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The ID of the error made during the BatchImportFindings operation.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportFindingsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportFindingsError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ImportFindingsError) SetErrorCode(v string) *ImportFindingsError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ImportFindingsError) SetErrorMessage(v string) *ImportFindingsError {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *ImportFindingsError) SetId(v string) *ImportFindingsError {
	s.Id = &v
	return s
}

// Contains information about a Security Hub insight.
type Insight struct {
	_ struct{} `type:"structure"`

	// One or more attributes used to filter the findings included in the insight.
	// The insight only includes findings that match the criteria defined in the
	// filters.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The attribute that the insight's findings are grouped by. This attribute
	// is used as a findings aggregator for the purposes of viewing and managing
	// multiple related findings under a single operand.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of a Security Hub insight.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The name of a Security Hub insight.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Insight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Insight) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *Insight) SetFilters(v *AwsSecurityFindingFilters) *Insight {
	s.Filters = v
	return s
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *Insight) SetGroupByAttribute(v string) *Insight {
	s.GroupByAttribute = &v
	return s
}

// SetInsightArn sets the InsightArn field's value.
func (s *Insight) SetInsightArn(v string) *Insight {
	s.InsightArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Insight) SetName(v string) *Insight {
	s.Name = &v
	return s
}

// The insight result values returned by the GetInsightResults operation.
type InsightResultValue struct {
	_ struct{} `type:"structure"`

	// The number of findings returned for each GroupByAttributeValue.
	//
	// Count is a required field
	Count *int64 `type:"integer" required:"true"`

	// The value of the attribute that the findings are grouped by for the insight
	// whose results are returned by the GetInsightResults operation.
	//
	// GroupByAttributeValue is a required field
	GroupByAttributeValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InsightResultValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightResultValue) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *InsightResultValue) SetCount(v int64) *InsightResultValue {
	s.Count = &v
	return s
}

// SetGroupByAttributeValue sets the GroupByAttributeValue field's value.
func (s *InsightResultValue) SetGroupByAttributeValue(v string) *InsightResultValue {
	s.GroupByAttributeValue = &v
	return s
}

// The insight results returned by the GetInsightResults operation.
type InsightResults struct {
	_ struct{} `type:"structure"`

	// The attribute that the findings are grouped by for the insight whose results
	// are returned by the GetInsightResults operation.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of the insight whose results are returned by the GetInsightResults
	// operation.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The list of insight result values returned by the GetInsightResults operation.
	//
	// ResultValues is a required field
	ResultValues []*InsightResultValue `type:"list" required:"true"`
}

// String returns the string representation
func (s InsightResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightResults) GoString() string {
	return s.String()
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *InsightResults) SetGroupByAttribute(v string) *InsightResults {
	s.GroupByAttribute = &v
	return s
}

// SetInsightArn sets the InsightArn field's value.
func (s *InsightResults) SetInsightArn(v string) *InsightResults {
	s.InsightArn = &v
	return s
}

// SetResultValues sets the ResultValues field's value.
func (s *InsightResults) SetResultValues(v []*InsightResultValue) *InsightResults {
	s.ResultValues = v
	return s
}

// Internal server error.
type InternalException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InternalException) OrigErr() error {
	return nil
}

func (s InternalException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s InternalException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InternalException) RequestID() string {
	return s.respMetadata.RequestID
}

// AWS Security Hub isn't enabled for the account used to make this request.
type InvalidAccessException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidAccessException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidAccessException) GoString() string {
	return s.String()
}

func newErrorInvalidAccessException(v protocol.ResponseMetadata) error {
	return &InvalidAccessException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidAccessException) Code() string {
	return "InvalidAccessException"
}

// Message returns the exception's message.
func (s InvalidAccessException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidAccessException) OrigErr() error {
	return nil
}

func (s InvalidAccessException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidAccessException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidAccessException) RequestID() string {
	return s.respMetadata.RequestID
}

// The request was rejected because you supplied an invalid or out-of-range
// value for an input parameter.
type InvalidInputException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidInputException) OrigErr() error {
	return nil
}

func (s InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidInputException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidInputException) RequestID() string {
	return s.respMetadata.RequestID
}

// Details about an invitation.
type Invitation struct {
	_ struct{} `type:"structure"`

	// The account ID of the Security Hub master account that the invitation was
	// sent from.
	AccountId *string `type:"string"`

	// The ID of the invitation sent to the member account.
	InvitationId *string `type:"string"`

	// The timestamp of when the invitation was sent.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The current status of the association between the member and master accounts.
	MemberStatus *string `type:"string"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invitation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Invitation) SetAccountId(v string) *Invitation {
	s.AccountId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *Invitation) SetInvitationId(v string) *Invitation {
	s.InvitationId = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Invitation) SetInvitedAt(v time.Time) *Invitation {
	s.InvitedAt = &v
	return s
}

// SetMemberStatus sets the MemberStatus field's value.
func (s *Invitation) SetMemberStatus(v string) *Invitation {
	s.MemberStatus = &v
	return s
}

type InviteMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of account IDs of the AWS accounts to invite to Security Hub as
	// members.
	AccountIds []*string `type:"list"`
}

// String returns the string representation
func (s InviteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *InviteMembersInput) SetAccountIds(v []*string) *InviteMembersInput {
	s.AccountIds = v
	return s
}

type InviteMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts that could not be processed. For each account, the
	// list includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s InviteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *InviteMembersOutput) SetUnprocessedAccounts(v []*Result) *InviteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// The IP filter for querying findings.
type IpFilter struct {
	_ struct{} `type:"structure"`

	// A finding's CIDR value.
	Cidr *string `type:"string"`
}

// String returns the string representation
func (s IpFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFilter) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *IpFilter) SetCidr(v string) *IpFilter {
	s.Cidr = &v
	return s
}

// A keyword filter for querying findings.
type KeywordFilter struct {
	_ struct{} `type:"structure"`

	// A value for the keyword.
	Value *string `type:"string"`
}

// String returns the string representation
func (s KeywordFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeywordFilter) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *KeywordFilter) SetValue(v string) *KeywordFilter {
	s.Value = &v
	return s
}

// The request was rejected because it attempted to create resources beyond
// the current AWS account limits. The error code describes the limit exceeded.
type LimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s LimitExceededException) OrigErr() error {
	return nil
}

func (s LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s LimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s LimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

type ListEnabledProductsForImportInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the ListEnabledProductsForImport
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListEnabledProductsForImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnabledProductsForImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnabledProductsForImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnabledProductsForImportInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnabledProductsForImportInput) SetMaxResults(v int64) *ListEnabledProductsForImportInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnabledProductsForImportInput) SetNextToken(v string) *ListEnabledProductsForImportInput {
	s.NextToken = &v
	return s
}

type ListEnabledProductsForImportOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`

	// The list of ARNs for the resources that represent your subscriptions to products.
	ProductSubscriptions []*string `type:"list"`
}

// String returns the string representation
func (s ListEnabledProductsForImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnabledProductsForImportOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnabledProductsForImportOutput) SetNextToken(v string) *ListEnabledProductsForImportOutput {
	s.NextToken = &v
	return s
}

// SetProductSubscriptions sets the ProductSubscriptions field's value.
func (s *ListEnabledProductsForImportOutput) SetProductSubscriptions(v []*string) *ListEnabledProductsForImportOutput {
	s.ProductSubscriptions = v
	return s
}

type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the ListInvitations
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvitationsInput) SetMaxResults(v int64) *ListInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsInput) SetNextToken(v string) *ListInvitationsInput {
	s.NextToken = &v
	return s
}

type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the invitations returned by the operation.
	Invitations []*Invitation `type:"list"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsOutput) GoString() string {
	return s.String()
}

// SetInvitations sets the Invitations field's value.
func (s *ListInvitationsOutput) SetInvitations(v []*Invitation) *ListInvitationsOutput {
	s.Invitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsOutput) SetNextToken(v string) *ListInvitationsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the ListMembers
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Specifies which member accounts to include in the response based on their
	// relationship status with the master account. The default value is TRUE.
	//
	// If OnlyAssociated is set to TRUE, the response includes member accounts whose
	// relationship status with the master is set to ENABLED or DISABLED.
	//
	// If OnlyAssociated is set to FALSE, the response includes all existing member
	// accounts.
	OnlyAssociated *bool `location:"querystring" locationName:"OnlyAssociated" type:"boolean"`
}

// String returns the string representation
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

// SetOnlyAssociated sets the OnlyAssociated field's value.
func (s *ListMembersInput) SetOnlyAssociated(v bool) *ListMembersInput {
	s.OnlyAssociated = &v
	return s
}

type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// Member details returned by the operation.
	Members []*Member `type:"list"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListMembersOutput) SetMembers(v []*Member) *ListMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to retrieve tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with a resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about the state of the load balancer.
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The state code. The initial state of the load balancer is provisioning.
	//
	// After the load balancer is fully set up and ready to route traffic, its state
	// is active.
	//
	// If the load balancer could not be set up, its state is failed.
	Code *string `type:"string"`

	// A description of the state.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerState) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *LoadBalancerState) SetCode(v string) *LoadBalancerState {
	s.Code = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *LoadBalancerState) SetReason(v string) *LoadBalancerState {
	s.Reason = &v
	return s
}

// A list of malware related to a finding.
type Malware struct {
	_ struct{} `type:"structure"`

	// The name of the malware that was observed.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The file system path of the malware that was observed.
	Path *string `type:"string"`

	// The state of the malware that was observed.
	State *string `type:"string" enum:"MalwareState"`

	// The type of the malware that was observed.
	Type *string `type:"string" enum:"MalwareType"`
}

// String returns the string representation
func (s Malware) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Malware) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Malware) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Malware"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Malware) SetName(v string) *Malware {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Malware) SetPath(v string) *Malware {
	s.Path = &v
	return s
}

// SetState sets the State field's value.
func (s *Malware) SetState(v string) *Malware {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Malware) SetType(v string) *Malware {
	s.Type = &v
	return s
}

// The map filter for querying findings.
type MapFilter struct {
	_ struct{} `type:"structure"`

	// The condition to apply to a key value when querying for findings with a map
	// filter.
	Comparison *string `type:"string" enum:"MapFilterComparison"`

	// The key of the map filter.
	Key *string `type:"string"`

	// The value for the key in the map filter.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MapFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MapFilter) GoString() string {
	return s.String()
}

// SetComparison sets the Comparison field's value.
func (s *MapFilter) SetComparison(v string) *MapFilter {
	s.Comparison = &v
	return s
}

// SetKey sets the Key field's value.
func (s *MapFilter) SetKey(v string) *MapFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MapFilter) SetValue(v string) *MapFilter {
	s.Value = &v
	return s
}

// The details about a member account.
type Member struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the member account.
	AccountId *string `type:"string"`

	// The email address of the member account.
	Email *string `type:"string"`

	// A timestamp for the date and time when the invitation was sent to the member
	// account.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The AWS account ID of the Security Hub master account associated with this
	// member account.
	MasterId *string `type:"string"`

	// The status of the relationship between the member account and its master
	// account.
	MemberStatus *string `type:"string"`

	// The timestamp for the date and time when the member account was updated.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Member) SetAccountId(v string) *Member {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Member) SetEmail(v string) *Member {
	s.Email = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Member) SetInvitedAt(v time.Time) *Member {
	s.InvitedAt = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *Member) SetMasterId(v string) *Member {
	s.MasterId = &v
	return s
}

// SetMemberStatus sets the MemberStatus field's value.
func (s *Member) SetMemberStatus(v string) *Member {
	s.MemberStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Member) SetUpdatedAt(v time.Time) *Member {
	s.UpdatedAt = &v
	return s
}

// The details of network-related information about a finding.
type Network struct {
	_ struct{} `type:"structure"`

	// The destination domain of network-related information about a finding.
	DestinationDomain *string `type:"string"`

	// The destination IPv4 address of network-related information about a finding.
	DestinationIpV4 *string `type:"string"`

	// The destination IPv6 address of network-related information about a finding.
	DestinationIpV6 *string `type:"string"`

	// The destination port of network-related information about a finding.
	DestinationPort *int64 `type:"integer"`

	// The direction of network traffic associated with a finding.
	Direction *string `type:"string" enum:"NetworkDirection"`

	// The protocol of network-related information about a finding.
	Protocol *string `type:"string"`

	// The source domain of network-related information about a finding.
	SourceDomain *string `type:"string"`

	// The source IPv4 address of network-related information about a finding.
	SourceIpV4 *string `type:"string"`

	// The source IPv6 address of network-related information about a finding.
	SourceIpV6 *string `type:"string"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	SourceMac *string `type:"string"`

	// The source port of network-related information about a finding.
	SourcePort *int64 `type:"integer"`
}

// String returns the string representation
func (s Network) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Network) GoString() string {
	return s.String()
}

// SetDestinationDomain sets the DestinationDomain field's value.
func (s *Network) SetDestinationDomain(v string) *Network {
	s.DestinationDomain = &v
	return s
}

// SetDestinationIpV4 sets the DestinationIpV4 field's value.
func (s *Network) SetDestinationIpV4(v string) *Network {
	s.DestinationIpV4 = &v
	return s
}

// SetDestinationIpV6 sets the DestinationIpV6 field's value.
func (s *Network) SetDestinationIpV6(v string) *Network {
	s.DestinationIpV6 = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *Network) SetDestinationPort(v int64) *Network {
	s.DestinationPort = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *Network) SetDirection(v string) *Network {
	s.Direction = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Network) SetProtocol(v string) *Network {
	s.Protocol = &v
	return s
}

// SetSourceDomain sets the SourceDomain field's value.
func (s *Network) SetSourceDomain(v string) *Network {
	s.SourceDomain = &v
	return s
}

// SetSourceIpV4 sets the SourceIpV4 field's value.
func (s *Network) SetSourceIpV4(v string) *Network {
	s.SourceIpV4 = &v
	return s
}

// SetSourceIpV6 sets the SourceIpV6 field's value.
func (s *Network) SetSourceIpV6(v string) *Network {
	s.SourceIpV6 = &v
	return s
}

// SetSourceMac sets the SourceMac field's value.
func (s *Network) SetSourceMac(v string) *Network {
	s.SourceMac = &v
	return s
}

// SetSourcePort sets the SourcePort field's value.
func (s *Network) SetSourcePort(v int64) *Network {
	s.SourcePort = &v
	return s
}

// A user-defined note added to a finding.
type Note struct {
	_ struct{} `type:"structure"`

	// The text of a note.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The timestamp of when the note was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// The principal that created a note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Note) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Note) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Note) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Note"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.UpdatedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedAt"))
	}
	if s.UpdatedBy == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *Note) SetText(v string) *Note {
	s.Text = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Note) SetUpdatedAt(v string) *Note {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *Note) SetUpdatedBy(v string) *Note {
	s.UpdatedBy = &v
	return s
}

// The updated note.
type NoteUpdate struct {
	_ struct{} `type:"structure"`

	// The updated note text.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The principal that updated the note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NoteUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoteUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NoteUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NoteUpdate"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.UpdatedBy == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *NoteUpdate) SetText(v string) *NoteUpdate {
	s.Text = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *NoteUpdate) SetUpdatedBy(v string) *NoteUpdate {
	s.UpdatedBy = &v
	return s
}

// A number filter for querying findings.
type NumberFilter struct {
	_ struct{} `type:"structure"`

	// The equal-to condition to be applied to a single field when querying for
	// findings.
	Eq *float64 `type:"double"`

	// The greater-than-equal condition to be applied to a single field when querying
	// for findings.
	Gte *float64 `type:"double"`

	// The less-than-equal condition to be applied to a single field when querying
	// for findings.
	Lte *float64 `type:"double"`
}

// String returns the string representation
func (s NumberFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberFilter) GoString() string {
	return s.String()
}

// SetEq sets the Eq field's value.
func (s *NumberFilter) SetEq(v float64) *NumberFilter {
	s.Eq = &v
	return s
}

// SetGte sets the Gte field's value.
func (s *NumberFilter) SetGte(v float64) *NumberFilter {
	s.Gte = &v
	return s
}

// SetLte sets the Lte field's value.
func (s *NumberFilter) SetLte(v float64) *NumberFilter {
	s.Lte = &v
	return s
}

// The details of process-related information about a finding.
type ProcessDetails struct {
	_ struct{} `type:"structure"`

	// The date/time that the process was launched.
	LaunchedAt *string `type:"string"`

	// The name of the process.
	Name *string `type:"string"`

	// The parent process ID.
	ParentPid *int64 `type:"integer"`

	// The path to the process executable.
	Path *string `type:"string"`

	// The process ID.
	Pid *int64 `type:"integer"`

	// The date and time when the process was terminated.
	TerminatedAt *string `type:"string"`
}

// String returns the string representation
func (s ProcessDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProcessDetails) GoString() string {
	return s.String()
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *ProcessDetails) SetLaunchedAt(v string) *ProcessDetails {
	s.LaunchedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProcessDetails) SetName(v string) *ProcessDetails {
	s.Name = &v
	return s
}

// SetParentPid sets the ParentPid field's value.
func (s *ProcessDetails) SetParentPid(v int64) *ProcessDetails {
	s.ParentPid = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ProcessDetails) SetPath(v string) *ProcessDetails {
	s.Path = &v
	return s
}

// SetPid sets the Pid field's value.
func (s *ProcessDetails) SetPid(v int64) *ProcessDetails {
	s.Pid = &v
	return s
}

// SetTerminatedAt sets the TerminatedAt field's value.
func (s *ProcessDetails) SetTerminatedAt(v string) *ProcessDetails {
	s.TerminatedAt = &v
	return s
}

// Contains details about a product.
type Product struct {
	_ struct{} `type:"structure"`

	// The URL used to activate the product.
	ActivationUrl *string `type:"string"`

	// The categories assigned to the product.
	Categories []*string `type:"list"`

	// The name of the company that provides the product.
	CompanyName *string `type:"string"`

	// A description of the product.
	Description *string `type:"string"`

	// The types of integration that the product supports. Available values are
	// the following.
	//
	//    * SEND_FINDINGS_TO_SECURITY_HUB - Indicates that the integration sends
	//    findings to Security Hub.
	//
	//    * RECEIVE_FINDINGS_FROM_SECURITY_HUB - Indicates that the integration
	//    receives findings from Security Hub.
	IntegrationTypes []*string `type:"list"`

	// The URL for the page that contains more information about the product.
	MarketplaceUrl *string `type:"string"`

	// The ARN assigned to the product.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`

	// The name of the product.
	ProductName *string `type:"string"`

	// The resource policy associated with the product.
	ProductSubscriptionResourcePolicy *string `type:"string"`
}

// String returns the string representation
func (s Product) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Product) GoString() string {
	return s.String()
}

// SetActivationUrl sets the ActivationUrl field's value.
func (s *Product) SetActivationUrl(v string) *Product {
	s.ActivationUrl = &v
	return s
}

// SetCategories sets the Categories field's value.
func (s *Product) SetCategories(v []*string) *Product {
	s.Categories = v
	return s
}

// SetCompanyName sets the CompanyName field's value.
func (s *Product) SetCompanyName(v string) *Product {
	s.CompanyName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Product) SetDescription(v string) *Product {
	s.Description = &v
	return s
}

// SetIntegrationTypes sets the IntegrationTypes field's value.
func (s *Product) SetIntegrationTypes(v []*string) *Product {
	s.IntegrationTypes = v
	return s
}

// SetMarketplaceUrl sets the MarketplaceUrl field's value.
func (s *Product) SetMarketplaceUrl(v string) *Product {
	s.MarketplaceUrl = &v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *Product) SetProductArn(v string) *Product {
	s.ProductArn = &v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *Product) SetProductName(v string) *Product {
	s.ProductName = &v
	return s
}

// SetProductSubscriptionResourcePolicy sets the ProductSubscriptionResourcePolicy field's value.
func (s *Product) SetProductSubscriptionResourcePolicy(v string) *Product {
	s.ProductSubscriptionResourcePolicy = &v
	return s
}

// A recommendation on how to remediate the issue identified in a finding.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// Describes the recommended steps to take to remediate an issue identified
	// in a finding.
	Text *string `type:"string"`

	// A URL to a page or site that contains information about how to remediate
	// a finding.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Recommendation) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *Recommendation) SetText(v string) *Recommendation {
	s.Text = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Recommendation) SetUrl(v string) *Recommendation {
	s.Url = &v
	return s
}

// Details about a related finding.
type RelatedFinding struct {
	_ struct{} `type:"structure"`

	// The product-generated identifier for a related finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The ARN of the product that generated a related finding.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RelatedFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelatedFinding) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedFinding) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelatedFinding"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RelatedFinding) SetId(v string) *RelatedFinding {
	s.Id = &v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *RelatedFinding) SetProductArn(v string) *RelatedFinding {
	s.ProductArn = &v
	return s
}

// Details about the remediation steps for a finding.
type Remediation struct {
	_ struct{} `type:"structure"`

	// A recommendation on the steps to take to remediate the issue identified by
	// a finding.
	Recommendation *Recommendation `type:"structure"`
}

// String returns the string representation
func (s Remediation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Remediation) GoString() string {
	return s.String()
}

// SetRecommendation sets the Recommendation field's value.
func (s *Remediation) SetRecommendation(v *Recommendation) *Remediation {
	s.Recommendation = v
	return s
}

// A resource related to a finding.
type Resource struct {
	_ struct{} `type:"structure"`

	// Additional details about the resource related to a finding.
	Details *ResourceDetails `type:"structure"`

	// The canonical identifier for the given resource type.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The canonical AWS partition name that the Region is assigned to.
	Partition *string `type:"string" enum:"Partition"`

	// The canonical AWS external Region name where this resource is located.
	Region *string `type:"string"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	Tags map[string]*string `type:"map"`

	// The type of the resource that details are provided for. If possible, set
	// Type to one of the supported resource types. For example, if the resource
	// is an EC2 instance, then set Type to AwsEc2Instance.
	//
	// If the resource does not match any of the provided types, then set Type to
	// Other.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Resource"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Details != nil {
		if err := s.Details.Validate(); err != nil {
			invalidParams.AddNested("Details", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *Resource) SetDetails(v *ResourceDetails) *Resource {
	s.Details = v
	return s
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetPartition sets the Partition field's value.
func (s *Resource) SetPartition(v string) *Resource {
	s.Partition = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Resource) SetRegion(v string) *Resource {
	s.Region = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Resource) SetTags(v map[string]*string) *Resource {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// The resource specified in the request conflicts with an existing resource.
type ResourceConflictException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConflictException) GoString() string {
	return s.String()
}

func newErrorResourceConflictException(v protocol.ResponseMetadata) error {
	return &ResourceConflictException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceConflictException) Code() string {
	return "ResourceConflictException"
}

// Message returns the exception's message.
func (s ResourceConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceConflictException) OrigErr() error {
	return nil
}

func (s ResourceConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceConflictException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceConflictException) RequestID() string {
	return s.respMetadata.RequestID
}

// Additional details about a resource related to a finding.
//
// To provide the details, use the object that corresponds to the resource type.
// For example, if the resource type is AwsEc2Instance, then you use the AwsEc2Instance
// object to provide the details.
//
// If the type-specific object does not contain all of the fields you want to
// populate, then you use the Other object to populate those additional fields.
//
// You also use the Other object to populate the details when the selected type
// does not have a corresponding object.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// Details about a CloudFront distribution.
	AwsCloudFrontDistribution *AwsCloudFrontDistributionDetails `type:"structure"`

	// Details for an AWS CodeBuild project.
	AwsCodeBuildProject *AwsCodeBuildProjectDetails `type:"structure"`

	// Details about an Amazon EC2 instance related to a finding.
	AwsEc2Instance *AwsEc2InstanceDetails `type:"structure"`

	// Details for an AWS EC2 network interface.
	AwsEc2NetworkInterface *AwsEc2NetworkInterfaceDetails `type:"structure"`

	// Details for an EC2 security group.
	AwsEc2SecurityGroup *AwsEc2SecurityGroupDetails `type:"structure"`

	// Details for an Elasticsearch domain.
	AwsElasticsearchDomain *AwsElasticsearchDomainDetails `type:"structure"`

	// Details about a load balancer.
	AwsElbv2LoadBalancer *AwsElbv2LoadBalancerDetails `type:"structure"`

	// Details about an IAM access key related to a finding.
	AwsIamAccessKey *AwsIamAccessKeyDetails `type:"structure"`

	// Details about an IAM role.
	AwsIamRole *AwsIamRoleDetails `type:"structure"`

	// Details about a KMS key.
	AwsKmsKey *AwsKmsKeyDetails `type:"structure"`

	// Details about a Lambda function.
	AwsLambdaFunction *AwsLambdaFunctionDetails `type:"structure"`

	// Details for a Lambda layer version.
	AwsLambdaLayerVersion *AwsLambdaLayerVersionDetails `type:"structure"`

	// Details for an RDS database instance.
	AwsRdsDbInstance *AwsRdsDbInstanceDetails `type:"structure"`

	// Details about an Amazon S3 Bucket related to a finding.
	AwsS3Bucket *AwsS3BucketDetails `type:"structure"`

	// Details about an SNS topic.
	AwsSnsTopic *AwsSnsTopicDetails `type:"structure"`

	// Details about an SQS queue.
	AwsSqsQueue *AwsSqsQueueDetails `type:"structure"`

	// Details for a WAF WebACL.
	AwsWafWebAcl *AwsWafWebAclDetails `type:"structure"`

	// Details about a container resource related to a finding.
	Container *ContainerDetails `type:"structure"`

	// Details about a resource that are not available in a type-specific details
	// object. Use the Other object in the following cases.
	//
	//    * The type-specific object does not contain all of the fields that you
	//    want to populate. In this case, first use the type-specific object to
	//    populate those fields. Use the Other object to populate the fields that
	//    are missing from the type-specific object.
	//
	//    * The resource type does not have a corresponding object. This includes
	//    resources for which the type is Other.
	Other map[string]*string `type:"map"`
}

// String returns the string representation
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceDetails"}
	if s.AwsIamRole != nil {
		if err := s.AwsIamRole.Validate(); err != nil {
			invalidParams.AddNested("AwsIamRole", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsCloudFrontDistribution sets the AwsCloudFrontDistribution field's value.
func (s *ResourceDetails) SetAwsCloudFrontDistribution(v *AwsCloudFrontDistributionDetails) *ResourceDetails {
	s.AwsCloudFrontDistribution = v
	return s
}

// SetAwsCodeBuildProject sets the AwsCodeBuildProject field's value.
func (s *ResourceDetails) SetAwsCodeBuildProject(v *AwsCodeBuildProjectDetails) *ResourceDetails {
	s.AwsCodeBuildProject = v
	return s
}

// SetAwsEc2Instance sets the AwsEc2Instance field's value.
func (s *ResourceDetails) SetAwsEc2Instance(v *AwsEc2InstanceDetails) *ResourceDetails {
	s.AwsEc2Instance = v
	return s
}

// SetAwsEc2NetworkInterface sets the AwsEc2NetworkInterface field's value.
func (s *ResourceDetails) SetAwsEc2NetworkInterface(v *AwsEc2NetworkInterfaceDetails) *ResourceDetails {
	s.AwsEc2NetworkInterface = v
	return s
}

// SetAwsEc2SecurityGroup sets the AwsEc2SecurityGroup field's value.
func (s *ResourceDetails) SetAwsEc2SecurityGroup(v *AwsEc2SecurityGroupDetails) *ResourceDetails {
	s.AwsEc2SecurityGroup = v
	return s
}

// SetAwsElasticsearchDomain sets the AwsElasticsearchDomain field's value.
func (s *ResourceDetails) SetAwsElasticsearchDomain(v *AwsElasticsearchDomainDetails) *ResourceDetails {
	s.AwsElasticsearchDomain = v
	return s
}

// SetAwsElbv2LoadBalancer sets the AwsElbv2LoadBalancer field's value.
func (s *ResourceDetails) SetAwsElbv2LoadBalancer(v *AwsElbv2LoadBalancerDetails) *ResourceDetails {
	s.AwsElbv2LoadBalancer = v
	return s
}

// SetAwsIamAccessKey sets the AwsIamAccessKey field's value.
func (s *ResourceDetails) SetAwsIamAccessKey(v *AwsIamAccessKeyDetails) *ResourceDetails {
	s.AwsIamAccessKey = v
	return s
}

// SetAwsIamRole sets the AwsIamRole field's value.
func (s *ResourceDetails) SetAwsIamRole(v *AwsIamRoleDetails) *ResourceDetails {
	s.AwsIamRole = v
	return s
}

// SetAwsKmsKey sets the AwsKmsKey field's value.
func (s *ResourceDetails) SetAwsKmsKey(v *AwsKmsKeyDetails) *ResourceDetails {
	s.AwsKmsKey = v
	return s
}

// SetAwsLambdaFunction sets the AwsLambdaFunction field's value.
func (s *ResourceDetails) SetAwsLambdaFunction(v *AwsLambdaFunctionDetails) *ResourceDetails {
	s.AwsLambdaFunction = v
	return s
}

// SetAwsLambdaLayerVersion sets the AwsLambdaLayerVersion field's value.
func (s *ResourceDetails) SetAwsLambdaLayerVersion(v *AwsLambdaLayerVersionDetails) *ResourceDetails {
	s.AwsLambdaLayerVersion = v
	return s
}

// SetAwsRdsDbInstance sets the AwsRdsDbInstance field's value.
func (s *ResourceDetails) SetAwsRdsDbInstance(v *AwsRdsDbInstanceDetails) *ResourceDetails {
	s.AwsRdsDbInstance = v
	return s
}

// SetAwsS3Bucket sets the AwsS3Bucket field's value.
func (s *ResourceDetails) SetAwsS3Bucket(v *AwsS3BucketDetails) *ResourceDetails {
	s.AwsS3Bucket = v
	return s
}

// SetAwsSnsTopic sets the AwsSnsTopic field's value.
func (s *ResourceDetails) SetAwsSnsTopic(v *AwsSnsTopicDetails) *ResourceDetails {
	s.AwsSnsTopic = v
	return s
}

// SetAwsSqsQueue sets the AwsSqsQueue field's value.
func (s *ResourceDetails) SetAwsSqsQueue(v *AwsSqsQueueDetails) *ResourceDetails {
	s.AwsSqsQueue = v
	return s
}

// SetAwsWafWebAcl sets the AwsWafWebAcl field's value.
func (s *ResourceDetails) SetAwsWafWebAcl(v *AwsWafWebAclDetails) *ResourceDetails {
	s.AwsWafWebAcl = v
	return s
}

// SetContainer sets the Container field's value.
func (s *ResourceDetails) SetContainer(v *ContainerDetails) *ResourceDetails {
	s.Container = v
	return s
}

// SetOther sets the Other field's value.
func (s *ResourceDetails) SetOther(v map[string]*string) *ResourceDetails {
	s.Other = v
	return s
}

// The request was rejected because we can't find the specified resource.
type ResourceNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// Details about the account that was not processed.
type Result struct {
	_ struct{} `type:"structure"`

	// An AWS account ID of the account that was not processed.
	AccountId *string `type:"string"`

	// The reason that the account was not processed.
	ProcessingResult *string `type:"string"`
}

// String returns the string representation
func (s Result) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Result) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Result) SetAccountId(v string) *Result {
	s.AccountId = &v
	return s
}

// SetProcessingResult sets the ProcessingResult field's value.
func (s *Result) SetProcessingResult(v string) *Result {
	s.ProcessingResult = &v
	return s
}

// The severity of the finding.
type Severity struct {
	_ struct{} `type:"structure"`

	// The normalized severity of a finding.
	//
	// Normalized is a required field
	Normalized *int64 `type:"integer" required:"true"`

	// The native severity as defined by the AWS service or integrated partner product
	// that generated the finding.
	Product *float64 `type:"double"`
}

// String returns the string representation
func (s Severity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Severity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Severity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Severity"}
	if s.Normalized == nil {
		invalidParams.Add(request.NewErrParamRequired("Normalized"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNormalized sets the Normalized field's value.
func (s *Severity) SetNormalized(v int64) *Severity {
	s.Normalized = &v
	return s
}

// SetProduct sets the Product field's value.
func (s *Severity) SetProduct(v float64) *Severity {
	s.Product = &v
	return s
}

// A collection of finding attributes used to sort findings.
type SortCriterion struct {
	_ struct{} `type:"structure"`

	// The finding attribute used to sort findings.
	Field *string `type:"string"`

	// The order used to sort findings.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s SortCriterion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SortCriterion) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *SortCriterion) SetField(v string) *SortCriterion {
	s.Field = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SortCriterion) SetSortOrder(v string) *SortCriterion {
	s.SortOrder = &v
	return s
}

// Provides information about a specific standard.
type Standard struct {
	_ struct{} `type:"structure"`

	// A description of the standard.
	Description *string `type:"string"`

	// The name of the standard.
	Name *string `type:"string"`

	// The ARN of a standard.
	StandardsArn *string `type:"string"`
}

// String returns the string representation
func (s Standard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Standard) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Standard) SetDescription(v string) *Standard {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Standard) SetName(v string) *Standard {
	s.Name = &v
	return s
}

// SetStandardsArn sets the StandardsArn field's value.
func (s *Standard) SetStandardsArn(v string) *Standard {
	s.StandardsArn = &v
	return s
}

// Details for an individual security standard control.
type StandardsControl struct {
	_ struct{} `type:"structure"`

	// The identifier of the security standard control.
	ControlId *string `type:"string"`

	// The current status of the security standard control. Indicates whether the
	// control is enabled or disabled. Security Hub does not check against disabled
	// controls.
	ControlStatus *string `type:"string" enum:"ControlStatus"`

	// The date and time that the status of the security standard control was most
	// recently updated.
	ControlStatusUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The longer description of the security standard control. Provides information
	// about what the control is checking for.
	Description *string `type:"string"`

	// The reason provided for the most recent change in status for the control.
	DisabledReason *string `type:"string"`

	// The list of requirements that are related to this control.
	RelatedRequirements []*string `type:"list"`

	// A link to remediation information for the control in the Security Hub user
	// documentation.
	RemediationUrl *string `type:"string"`

	// The severity of findings generated from this security standard control.
	//
	// The finding severity is based on an assessment of how easy it would be to
	// compromise AWS resources if the issue is detected.
	SeverityRating *string `type:"string" enum:"SeverityRating"`

	// The ARN of the security standard control.
	StandardsControlArn *string `type:"string"`

	// The title of the security standard control.
	Title *string `type:"string"`
}

// String returns the string representation
func (s StandardsControl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardsControl) GoString() string {
	return s.String()
}

// SetControlId sets the ControlId field's value.
func (s *StandardsControl) SetControlId(v string) *StandardsControl {
	s.ControlId = &v
	return s
}

// SetControlStatus sets the ControlStatus field's value.
func (s *StandardsControl) SetControlStatus(v string) *StandardsControl {
	s.ControlStatus = &v
	return s
}

// SetControlStatusUpdatedAt sets the ControlStatusUpdatedAt field's value.
func (s *StandardsControl) SetControlStatusUpdatedAt(v time.Time) *StandardsControl {
	s.ControlStatusUpdatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StandardsControl) SetDescription(v string) *StandardsControl {
	s.Description = &v
	return s
}

// SetDisabledReason sets the DisabledReason field's value.
func (s *StandardsControl) SetDisabledReason(v string) *StandardsControl {
	s.DisabledReason = &v
	return s
}

// SetRelatedRequirements sets the RelatedRequirements field's value.
func (s *StandardsControl) SetRelatedRequirements(v []*string) *StandardsControl {
	s.RelatedRequirements = v
	return s
}

// SetRemediationUrl sets the RemediationUrl field's value.
func (s *StandardsControl) SetRemediationUrl(v string) *StandardsControl {
	s.RemediationUrl = &v
	return s
}

// SetSeverityRating sets the SeverityRating field's value.
func (s *StandardsControl) SetSeverityRating(v string) *StandardsControl {
	s.SeverityRating = &v
	return s
}

// SetStandardsControlArn sets the StandardsControlArn field's value.
func (s *StandardsControl) SetStandardsControlArn(v string) *StandardsControl {
	s.StandardsControlArn = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *StandardsControl) SetTitle(v string) *StandardsControl {
	s.Title = &v
	return s
}

// A resource that represents your subscription to a supported standard.
type StandardsSubscription struct {
	_ struct{} `type:"structure"`

	// The ARN of a standard.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	// A key-value pair of input for the standard.
	//
	// StandardsInput is a required field
	StandardsInput map[string]*string `type:"map" required:"true"`

	// The status of the standards subscription.
	//
	// StandardsStatus is a required field
	StandardsStatus *string `type:"string" required:"true" enum:"StandardsStatus"`

	// The ARN of a resource that represents your subscription to a supported standard.
	//
	// StandardsSubscriptionArn is a required field
	StandardsSubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StandardsSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardsSubscription) GoString() string {
	return s.String()
}

// SetStandardsArn sets the StandardsArn field's value.
func (s *StandardsSubscription) SetStandardsArn(v string) *StandardsSubscription {
	s.StandardsArn = &v
	return s
}

// SetStandardsInput sets the StandardsInput field's value.
func (s *StandardsSubscription) SetStandardsInput(v map[string]*string) *StandardsSubscription {
	s.StandardsInput = v
	return s
}

// SetStandardsStatus sets the StandardsStatus field's value.
func (s *StandardsSubscription) SetStandardsStatus(v string) *StandardsSubscription {
	s.StandardsStatus = &v
	return s
}

// SetStandardsSubscriptionArn sets the StandardsSubscriptionArn field's value.
func (s *StandardsSubscription) SetStandardsSubscriptionArn(v string) *StandardsSubscription {
	s.StandardsSubscriptionArn = &v
	return s
}

// The standard that you want to enable.
type StandardsSubscriptionRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the standard that you want to enable. To view the list of available
	// standards and their ARNs, use the DescribeStandards operation.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	// A key-value pair of input for the standard.
	StandardsInput map[string]*string `type:"map"`
}

// String returns the string representation
func (s StandardsSubscriptionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardsSubscriptionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StandardsSubscriptionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StandardsSubscriptionRequest"}
	if s.StandardsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStandardsArn sets the StandardsArn field's value.
func (s *StandardsSubscriptionRequest) SetStandardsArn(v string) *StandardsSubscriptionRequest {
	s.StandardsArn = &v
	return s
}

// SetStandardsInput sets the StandardsInput field's value.
func (s *StandardsSubscriptionRequest) SetStandardsInput(v map[string]*string) *StandardsSubscriptionRequest {
	s.StandardsInput = v
	return s
}

// A string filter for querying findings.
type StringFilter struct {
	_ struct{} `type:"structure"`

	// The condition to be applied to a string value when querying for findings.
	Comparison *string `type:"string" enum:"StringFilterComparison"`

	// The string filter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s StringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StringFilter) GoString() string {
	return s.String()
}

// SetComparison sets the Comparison field's value.
func (s *StringFilter) SetComparison(v string) *StringFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *StringFilter) SetValue(v string) *StringFilter {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to apply the tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Details about the threat intelligence related to a finding.
type ThreatIntelIndicator struct {
	_ struct{} `type:"structure"`

	// The category of a threat intelligence indicator.
	Category *string `type:"string" enum:"ThreatIntelIndicatorCategory"`

	// The date and time when the most recent instance of a threat intelligence
	// indicator was observed.
	LastObservedAt *string `type:"string"`

	// The source of the threat intelligence indicator.
	Source *string `type:"string"`

	// The URL to the page or site where you can get more information about the
	// threat intelligence indicator.
	SourceUrl *string `type:"string"`

	// The type of threat intelligence indicator.
	Type *string `type:"string" enum:"ThreatIntelIndicatorType"`

	// The value of a threat intelligence indicator.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ThreatIntelIndicator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThreatIntelIndicator) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *ThreatIntelIndicator) SetCategory(v string) *ThreatIntelIndicator {
	s.Category = &v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *ThreatIntelIndicator) SetLastObservedAt(v string) *ThreatIntelIndicator {
	s.LastObservedAt = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ThreatIntelIndicator) SetSource(v string) *ThreatIntelIndicator {
	s.Source = &v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *ThreatIntelIndicator) SetSourceUrl(v string) *ThreatIntelIndicator {
	s.SourceUrl = &v
	return s
}

// SetType sets the Type field's value.
func (s *ThreatIntelIndicator) SetType(v string) *ThreatIntelIndicator {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ThreatIntelIndicator) SetValue(v string) *ThreatIntelIndicator {
	s.Value = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to remove the tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tag keys associated with the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateActionTargetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom action target to update.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `location:"uri" locationName:"ActionTargetArn" type:"string" required:"true"`

	// The updated description for the custom action target.
	Description *string `type:"string"`

	// The updated name of the custom action target.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateActionTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateActionTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateActionTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateActionTargetInput"}
	if s.ActionTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTargetArn"))
	}
	if s.ActionTargetArn != nil && len(*s.ActionTargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionTargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *UpdateActionTargetInput) SetActionTargetArn(v string) *UpdateActionTargetInput {
	s.ActionTargetArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateActionTargetInput) SetDescription(v string) *UpdateActionTargetInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateActionTargetInput) SetName(v string) *UpdateActionTargetInput {
	s.Name = &v
	return s
}

type UpdateActionTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateActionTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateActionTargetOutput) GoString() string {
	return s.String()
}

type UpdateFindingsInput struct {
	_ struct{} `type:"structure"`

	// A collection of attributes that specify which findings you want to update.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The updated note for the finding.
	Note *NoteUpdate `type:"structure"`

	// The updated record state for the finding.
	RecordState *string `type:"string" enum:"RecordState"`
}

// String returns the string representation
func (s UpdateFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFindingsInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *UpdateFindingsInput) SetFilters(v *AwsSecurityFindingFilters) *UpdateFindingsInput {
	s.Filters = v
	return s
}

// SetNote sets the Note field's value.
func (s *UpdateFindingsInput) SetNote(v *NoteUpdate) *UpdateFindingsInput {
	s.Note = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *UpdateFindingsInput) SetRecordState(v string) *UpdateFindingsInput {
	s.RecordState = &v
	return s
}

type UpdateFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsOutput) GoString() string {
	return s.String()
}

type UpdateInsightInput struct {
	_ struct{} `type:"structure"`

	// The updated filters that define this insight.
	Filters *AwsSecurityFindingFilters `type:"structure"`

	// The updated GroupBy attribute that defines this insight.
	GroupByAttribute *string `type:"string"`

	// The ARN of the insight that you want to update.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`

	// The updated name for the insight.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInsightInput"}
	if s.InsightArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightArn"))
	}
	if s.InsightArn != nil && len(*s.InsightArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *UpdateInsightInput) SetFilters(v *AwsSecurityFindingFilters) *UpdateInsightInput {
	s.Filters = v
	return s
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *UpdateInsightInput) SetGroupByAttribute(v string) *UpdateInsightInput {
	s.GroupByAttribute = &v
	return s
}

// SetInsightArn sets the InsightArn field's value.
func (s *UpdateInsightInput) SetInsightArn(v string) *UpdateInsightInput {
	s.InsightArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateInsightInput) SetName(v string) *UpdateInsightInput {
	s.Name = &v
	return s
}

type UpdateInsightOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInsightOutput) GoString() string {
	return s.String()
}

type UpdateStandardsControlInput struct {
	_ struct{} `type:"structure"`

	// The updated status of the security standard control.
	ControlStatus *string `type:"string" enum:"ControlStatus"`

	// A description of the reason why you are disabling a security standard control.
	DisabledReason *string `type:"string"`

	// The ARN of the security standard control to enable or disable.
	//
	// StandardsControlArn is a required field
	StandardsControlArn *string `location:"uri" locationName:"StandardsControlArn" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStandardsControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStandardsControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStandardsControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStandardsControlInput"}
	if s.StandardsControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsControlArn"))
	}
	if s.StandardsControlArn != nil && len(*s.StandardsControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsControlArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlStatus sets the ControlStatus field's value.
func (s *UpdateStandardsControlInput) SetControlStatus(v string) *UpdateStandardsControlInput {
	s.ControlStatus = &v
	return s
}

// SetDisabledReason sets the DisabledReason field's value.
func (s *UpdateStandardsControlInput) SetDisabledReason(v string) *UpdateStandardsControlInput {
	s.DisabledReason = &v
	return s
}

// SetStandardsControlArn sets the StandardsControlArn field's value.
func (s *UpdateStandardsControlInput) SetStandardsControlArn(v string) *UpdateStandardsControlInput {
	s.StandardsControlArn = &v
	return s
}

type UpdateStandardsControlOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateStandardsControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStandardsControlOutput) GoString() string {
	return s.String()
}

// Details about the action that CloudFront or AWS WAF takes when a web request
// matches the conditions in the Rule.
type WafAction struct {
	_ struct{} `type:"structure"`

	// Specifies how you want AWS WAF to respond to requests that match the settings
	// in a Rule.
	//
	// Valid settings include the following:
	//
	//    * ALLOW - AWS WAF allows requests
	//
	//    * BLOCK - AWS WAF blocks requests
	//
	//    * COUNT - AWS WAF increments a counter of the requests that match all
	//    of the conditions in the rule. AWS WAF then continues to inspect the web
	//    request based on the remaining rules in the web ACL. You can't specify
	//    COUNT for the default action for a WebACL.
	Type *string `type:"string"`
}

// String returns the string representation
func (s WafAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WafAction) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *WafAction) SetType(v string) *WafAction {
	s.Type = &v
	return s
}

// Details about a rule to exclude from a rule group.
type WafExcludedRule struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the rule to exclude from the rule group.
	RuleId *string `type:"string"`
}

// String returns the string representation
func (s WafExcludedRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WafExcludedRule) GoString() string {
	return s.String()
}

// SetRuleId sets the RuleId field's value.
func (s *WafExcludedRule) SetRuleId(v string) *WafExcludedRule {
	s.RuleId = &v
	return s
}

// Details about an override action for a rule.
type WafOverrideAction struct {
	_ struct{} `type:"structure"`

	// COUNT overrides the action specified by the individual rule within a RuleGroup .
	//
	// If set to NONE, the rule's action takes place.
	Type *string `type:"string"`
}

// String returns the string representation
func (s WafOverrideAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WafOverrideAction) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *WafOverrideAction) SetType(v string) *WafOverrideAction {
	s.Type = &v
	return s
}

const (
	// AwsIamAccessKeyStatusActive is a AwsIamAccessKeyStatus enum value
	AwsIamAccessKeyStatusActive = "Active"

	// AwsIamAccessKeyStatusInactive is a AwsIamAccessKeyStatus enum value
	AwsIamAccessKeyStatusInactive = "Inactive"
)

const (
	// ComplianceStatusPassed is a ComplianceStatus enum value
	ComplianceStatusPassed = "PASSED"

	// ComplianceStatusWarning is a ComplianceStatus enum value
	ComplianceStatusWarning = "WARNING"

	// ComplianceStatusFailed is a ComplianceStatus enum value
	ComplianceStatusFailed = "FAILED"

	// ComplianceStatusNotAvailable is a ComplianceStatus enum value
	ComplianceStatusNotAvailable = "NOT_AVAILABLE"
)

const (
	// ControlStatusEnabled is a ControlStatus enum value
	ControlStatusEnabled = "ENABLED"

	// ControlStatusDisabled is a ControlStatus enum value
	ControlStatusDisabled = "DISABLED"
)

const (
	// DateRangeUnitDays is a DateRangeUnit enum value
	DateRangeUnitDays = "DAYS"
)

const (
	// IntegrationTypeSendFindingsToSecurityHub is a IntegrationType enum value
	IntegrationTypeSendFindingsToSecurityHub = "SEND_FINDINGS_TO_SECURITY_HUB"

	// IntegrationTypeReceiveFindingsFromSecurityHub is a IntegrationType enum value
	IntegrationTypeReceiveFindingsFromSecurityHub = "RECEIVE_FINDINGS_FROM_SECURITY_HUB"
)

const (
	// MalwareStateObserved is a MalwareState enum value
	MalwareStateObserved = "OBSERVED"

	// MalwareStateRemovalFailed is a MalwareState enum value
	MalwareStateRemovalFailed = "REMOVAL_FAILED"

	// MalwareStateRemoved is a MalwareState enum value
	MalwareStateRemoved = "REMOVED"
)

const (
	// MalwareTypeAdware is a MalwareType enum value
	MalwareTypeAdware = "ADWARE"

	// MalwareTypeBlendedThreat is a MalwareType enum value
	MalwareTypeBlendedThreat = "BLENDED_THREAT"

	// MalwareTypeBotnetAgent is a MalwareType enum value
	MalwareTypeBotnetAgent = "BOTNET_AGENT"

	// MalwareTypeCoinMiner is a MalwareType enum value
	MalwareTypeCoinMiner = "COIN_MINER"

	// MalwareTypeExploitKit is a MalwareType enum value
	MalwareTypeExploitKit = "EXPLOIT_KIT"

	// MalwareTypeKeylogger is a MalwareType enum value
	MalwareTypeKeylogger = "KEYLOGGER"

	// MalwareTypeMacro is a MalwareType enum value
	MalwareTypeMacro = "MACRO"

	// MalwareTypePotentiallyUnwanted is a MalwareType enum value
	MalwareTypePotentiallyUnwanted = "POTENTIALLY_UNWANTED"

	// MalwareTypeSpyware is a MalwareType enum value
	MalwareTypeSpyware = "SPYWARE"

	// MalwareTypeRansomware is a MalwareType enum value
	MalwareTypeRansomware = "RANSOMWARE"

	// MalwareTypeRemoteAccess is a MalwareType enum value
	MalwareTypeRemoteAccess = "REMOTE_ACCESS"

	// MalwareTypeRootkit is a MalwareType enum value
	MalwareTypeRootkit = "ROOTKIT"

	// MalwareTypeTrojan is a MalwareType enum value
	MalwareTypeTrojan = "TROJAN"

	// MalwareTypeVirus is a MalwareType enum value
	MalwareTypeVirus = "VIRUS"

	// MalwareTypeWorm is a MalwareType enum value
	MalwareTypeWorm = "WORM"
)

const (
	// MapFilterComparisonEquals is a MapFilterComparison enum value
	MapFilterComparisonEquals = "EQUALS"
)

const (
	// NetworkDirectionIn is a NetworkDirection enum value
	NetworkDirectionIn = "IN"

	// NetworkDirectionOut is a NetworkDirection enum value
	NetworkDirectionOut = "OUT"
)

const (
	// PartitionAws is a Partition enum value
	PartitionAws = "aws"

	// PartitionAwsCn is a Partition enum value
	PartitionAwsCn = "aws-cn"

	// PartitionAwsUsGov is a Partition enum value
	PartitionAwsUsGov = "aws-us-gov"
)

const (
	// RecordStateActive is a RecordState enum value
	RecordStateActive = "ACTIVE"

	// RecordStateArchived is a RecordState enum value
	RecordStateArchived = "ARCHIVED"
)

const (
	// SeverityRatingLow is a SeverityRating enum value
	SeverityRatingLow = "LOW"

	// SeverityRatingMedium is a SeverityRating enum value
	SeverityRatingMedium = "MEDIUM"

	// SeverityRatingHigh is a SeverityRating enum value
	SeverityRatingHigh = "HIGH"

	// SeverityRatingCritical is a SeverityRating enum value
	SeverityRatingCritical = "CRITICAL"
)

const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "asc"

	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "desc"
)

const (
	// StandardsStatusPending is a StandardsStatus enum value
	StandardsStatusPending = "PENDING"

	// StandardsStatusReady is a StandardsStatus enum value
	StandardsStatusReady = "READY"

	// StandardsStatusFailed is a StandardsStatus enum value
	StandardsStatusFailed = "FAILED"

	// StandardsStatusDeleting is a StandardsStatus enum value
	StandardsStatusDeleting = "DELETING"

	// StandardsStatusIncomplete is a StandardsStatus enum value
	StandardsStatusIncomplete = "INCOMPLETE"
)

const (
	// StringFilterComparisonEquals is a StringFilterComparison enum value
	StringFilterComparisonEquals = "EQUALS"

	// StringFilterComparisonPrefix is a StringFilterComparison enum value
	StringFilterComparisonPrefix = "PREFIX"
)

const (
	// ThreatIntelIndicatorCategoryBackdoor is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryBackdoor = "BACKDOOR"

	// ThreatIntelIndicatorCategoryCardStealer is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryCardStealer = "CARD_STEALER"

	// ThreatIntelIndicatorCategoryCommandAndControl is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryCommandAndControl = "COMMAND_AND_CONTROL"

	// ThreatIntelIndicatorCategoryDropSite is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryDropSite = "DROP_SITE"

	// ThreatIntelIndicatorCategoryExploitSite is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryExploitSite = "EXPLOIT_SITE"

	// ThreatIntelIndicatorCategoryKeylogger is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryKeylogger = "KEYLOGGER"
)

const (
	// ThreatIntelIndicatorTypeDomain is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeDomain = "DOMAIN"

	// ThreatIntelIndicatorTypeEmailAddress is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeEmailAddress = "EMAIL_ADDRESS"

	// ThreatIntelIndicatorTypeHashMd5 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashMd5 = "HASH_MD5"

	// ThreatIntelIndicatorTypeHashSha1 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashSha1 = "HASH_SHA1"

	// ThreatIntelIndicatorTypeHashSha256 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashSha256 = "HASH_SHA256"

	// ThreatIntelIndicatorTypeHashSha512 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashSha512 = "HASH_SHA512"

	// ThreatIntelIndicatorTypeIpv4Address is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeIpv4Address = "IPV4_ADDRESS"

	// ThreatIntelIndicatorTypeIpv6Address is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeIpv6Address = "IPV6_ADDRESS"

	// ThreatIntelIndicatorTypeMutex is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeMutex = "MUTEX"

	// ThreatIntelIndicatorTypeProcess is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeProcess = "PROCESS"

	// ThreatIntelIndicatorTypeUrl is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeUrl = "URL"
)

const (
	// VerificationStateUnknown is a VerificationState enum value
	VerificationStateUnknown = "UNKNOWN"

	// VerificationStateTruePositive is a VerificationState enum value
	VerificationStateTruePositive = "TRUE_POSITIVE"

	// VerificationStateFalsePositive is a VerificationState enum value
	VerificationStateFalsePositive = "FALSE_POSITIVE"

	// VerificationStateBenignPositive is a VerificationState enum value
	VerificationStateBenignPositive = "BENIGN_POSITIVE"
)

const (
	// WorkflowStateNew is a WorkflowState enum value
	WorkflowStateNew = "NEW"

	// WorkflowStateAssigned is a WorkflowState enum value
	WorkflowStateAssigned = "ASSIGNED"

	// WorkflowStateInProgress is a WorkflowState enum value
	WorkflowStateInProgress = "IN_PROGRESS"

	// WorkflowStateDeferred is a WorkflowState enum value
	WorkflowStateDeferred = "DEFERRED"

	// WorkflowStateResolved is a WorkflowState enum value
	WorkflowStateResolved = "RESOLVED"
)
