/*
 *  Copyright (C) 1999 Brad Stephens
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <stdlib.h>
#include "../log.h"
#include "../ballistics.h"
#include "../terrain.h"
#include "tunnel.h"

Shellstat_bal
wepTunnelInit(struct Projectilepos_bal *prjpos, void **guide,
	      Shellstat_bal(*initexplosion) (struct Projectilepos_bal *
					     prjpos, void **explosioninfo),
	      void **explosioninfo)
{
    Player_pl *plhit = NULL;
    int ix, iy;
    Weapon_wep *bs;
    struct Projectilelist_bal *prj;

    prjpos->x += prjpos->vx;
    prjpos->y += prjpos->vy;
    /*prjpos->vy -= (bal_grav / bal_lerp_tweak);*/
    *guide = NULL;

    if(balCheckIntersect
       (prjpos->ox, prjpos->oy, prjpos->x, prjpos->y, &plhit, &ix, &iy))
    {				/* We are in the dirt most likely so keep flying */

	prjpos->rox = prjpos->ox = prjpos->x;
	prjpos->roy = prjpos->oy = prjpos->y;
	return FLYING;
    }
    else
    {				/* We are in the air so launch a Large Shell */

	bs = wepLookupWeapon("Large Shell");
	prj =
	    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx,
			 prjpos->vy, bs);
	prj->stat = INITSHOT(prj);
	prj->prjpos.wid = wepLookupWeapon("Tunneler")->id;

	return FREEING;
    }
}

Shellstat_bal
wepTunnelGuidance(void *info, struct Projectilepos_bal * prjpos,
		  Shellstat_bal(*initexplosion) (struct Projectilepos_bal *
						 prjpos,
						 void **explosioninfo),
		  void **explosioninfo)
{
    int ix, iy;
    Player_pl *plhit = NULL;
    Weapon_wep *bs;
    struct Projectilelist_bal *prj;
    Shellstat_bal res;
    IsectTypes_bal isect;

    prjpos->rox = prjpos->ox = prjpos->x;
    prjpos->roy = prjpos->oy = prjpos->y;
    prjpos->x += prjpos->vx + (bal_wind / bal_lerp_tweak);
    prjpos->y += prjpos->vy;
    /*prjpos->vy -= (bal_grav / bal_lerp_tweak);*/

    if((res = balEnvironmentAdjustProjPos(prjpos)) != FLYING)
    {
	if(plLookupPlayer(prjpos->id))
	{
	    logPrintf(DEBUG, "Intersection at (%i, %i) of %s's shot\n", ix,
		      iy, plLookupPlayer(prjpos->id)->name);
	}
	else
	{
	    logPrintf(DEBUG, "Intersection at (%i, %i) of null's shot\n", ix,
		      iy);
	}
	if(plhit != NULL)
	    logPrintf(DEBUG, "and hit %s\n", plhit->name);
	switch (res)
	{
	    case HOLDING:
		/* wtf ??? */
		break;
	    case FLYING:
		prjpos->x = ix;
		prjpos->y = iy;
		/* fall through */
	    case EXPLODING:
		return initexplosion(prjpos, explosioninfo);
		break;
	    case FREEING:
		return FREEING;
		break;
	}
    }

    if((isect=balCheckIntersect
	(prjpos->ox, prjpos->oy, prjpos->x,
	 prjpos->y, &plhit, &ix, &iy)) == NO_ISECT)
    {				/* We hit air so lets launch the Large shell */

	bs = wepLookupWeapon("Large Shell");
	prj =
	    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx,
			 prjpos->vy, bs);
	prj->stat = INITSHOT(prj);
	prj->prjpos.wid = wepLookupWeapon("Tunneler")->id;

	return FREEING;
    }
    else if(isect == TANK_ISECT)
    {
	bs = wepLookupWeapon("Large Shell");
	prj =
	    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx,
			 prjpos->vy, bs);
	prj->stat = INITSHOT(prj);
	prj->prjpos.wid = wepLookupWeapon("Tunneler")->id;

	return FREEING;
    }
    else if(isect == TERRAIN_ISECT && prjpos->y < 0)
    {
        /* We hit the ground */
	
	bs = wepLookupWeapon("Large Shell");
	prj =
	    balNewShotXY(prjpos->id, 0, prjpos->x, 0, prjpos->vx,
			 prjpos->vy, bs);
	prj->stat = INITSHOT(prj);
	prj->prjpos.wid = wepLookupWeapon("Tunneler")->id;

	return FREEING;
    }

    return FLYING;
}
