/*-
 * Copyright (c) 2004 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: loop-divert.c,v 1.9 2005/05/25 21:06:45 vlm Exp $
 */

#include "ipcad.h"
#include "opt.h"


#ifndef	IPPROTO_DIVERT

void *
process_divert(void *psp) {
	(void)psp;
	assert(!"Can't be here");
	return NULL;
}

#else


/*
 * This is the interface loop - a busy horse handling interface statistics.
 */
void *
process_divert(void *psp) {
	struct sockaddr_in sin;
	packet_source_t *ps = psp;
	ssize_t len = 0;
	socklen_t addrlen;
	int fd = ps->fd;

	assert(ps->iface_type == IFACE_DIVERT || ps->iface_type == IFACE_TEE);
	assert(ps->bufsize);

	for(;;) {

		if(signoff_now)
			break;

		if(len == -1) {
			if(errno != EAGAIN) {
				/* We can't deal with permanent errors.
				 * Just sleep a bit.
				 */
				printf("System call returned %d: %s\n",
					errno, strerror(errno));
				sleep(1);
			}
		}
		
		if(ps->state != PST_READY || ps->fd == -1) {
			if(init_packet_source(ps, 1)) {
				sleep(5);
				continue;
			}
			assert(ps->state == PST_READY);
			fprintf(stderr, "\n");
			fd = ps->fd;
		}

		addrlen = sizeof(sin);
		len = recvfrom(fd, ps->buf, ps->bufsize, 0,
			(struct sockaddr *)&sin, &addrlen);

		/*
		 * Read timeout or failure condition.
		 */
		if(len <= 0) continue;

		/*
		 * Process packet
		 */
		if(sin.sin_addr.s_addr || !(ps->iflags & IFLAG_INONLY)) {
			process_packet_data(ps, (const unsigned char *)ps->buf,
				len, 0, 0);
		} else {
			/* input-only requested */
		}

		if(ps->iface_type == IFACE_DIVERT) {
			/* Put the packet back */
			sendto(fd, ps->buf, len, 0,
				(struct sockaddr *)&sin, addrlen);
		}
	}

	return 0;
}

#endif	/* divert(4)/tee support */
