//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// LoadBalancerNetworkInterfacesServer is a fake server for instances of the armnetwork.LoadBalancerNetworkInterfacesClient type.
type LoadBalancerNetworkInterfacesServer struct {
	// NewListPager is the fake for method LoadBalancerNetworkInterfacesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, loadBalancerName string, options *armnetwork.LoadBalancerNetworkInterfacesClientListOptions) (resp azfake.PagerResponder[armnetwork.LoadBalancerNetworkInterfacesClientListResponse])
}

// NewLoadBalancerNetworkInterfacesServerTransport creates a new instance of LoadBalancerNetworkInterfacesServerTransport with the provided implementation.
// The returned LoadBalancerNetworkInterfacesServerTransport instance is connected to an instance of armnetwork.LoadBalancerNetworkInterfacesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLoadBalancerNetworkInterfacesServerTransport(srv *LoadBalancerNetworkInterfacesServer) *LoadBalancerNetworkInterfacesServerTransport {
	return &LoadBalancerNetworkInterfacesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armnetwork.LoadBalancerNetworkInterfacesClientListResponse]](),
	}
}

// LoadBalancerNetworkInterfacesServerTransport connects instances of armnetwork.LoadBalancerNetworkInterfacesClient to instances of LoadBalancerNetworkInterfacesServer.
// Don't use this type directly, use NewLoadBalancerNetworkInterfacesServerTransport instead.
type LoadBalancerNetworkInterfacesServerTransport struct {
	srv          *LoadBalancerNetworkInterfacesServer
	newListPager *tracker[azfake.PagerResponder[armnetwork.LoadBalancerNetworkInterfacesClientListResponse]]
}

// Do implements the policy.Transporter interface for LoadBalancerNetworkInterfacesServerTransport.
func (l *LoadBalancerNetworkInterfacesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LoadBalancerNetworkInterfacesClient.NewListPager":
		resp, err = l.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LoadBalancerNetworkInterfacesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := l.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/loadBalancers/(?P<loadBalancerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		loadBalancerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("loadBalancerName")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListPager(resourceGroupNameParam, loadBalancerNameParam, nil)
		newListPager = &resp
		l.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetwork.LoadBalancerNetworkInterfacesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		l.newListPager.remove(req)
	}
	return resp, nil
}
