/*============================================================================*
 *============================================================================*
 * Component:           plextor-tool-applet
 * Filename:            utility_functions.c
 *                                                                             
 * Authors:             Georg Huettenegger
 *                                                                             
 * Date of Creation:    Wed Oct 27 10:01:24 1999
 *                                                                             
 * Last Modification:   Wed Oct 27 10:01:24 1999
 *                                                                             
 * Copyright:           Georg Huettenegger
 *                                                                             
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                             
 *============================================================================*
 *============================================================================*
 */

#include "utility-functions.h"
#include "scsi-functions.h"

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Searches for GPlextorToolData in device list.
 * device_name is short form (as found in combo box; otherwise provide char *
 * + 5).
 *
 * On success returns pointer else NULL;
 *                                                                             
 *----------------------------------------------------------------------------*
 */
GPlextorToolData * find_gptd_with_device_name (GPlextorToolAppletData * gptad,
                                               char * device_name)
{
  GPlextorToolData * gptd = NULL;
  int i = 0;

#ifdef CALL_TRACE
  flushed_output_0 (gptad->out_file_ptr,
                    "Trace: find_gptd_with_device_name\n");
#endif

  do
  {
    gptd = g_list_nth_data (gptad->device_data, i);
    if (gptd)
    {
      if (!strcmp(gptd->ptd.device_name_ptr+5, device_name))
        break;
    }
    ++i;
  } while (gptd);

#ifdef VERBOSE_OUTPUT
  if (!gptd)
    flushed_output_0 (gptad->out_file_ptr,
                     "Could not find the searched device!!!!\n");
#endif

  return gptd;
}

void device_changed (GPlextorToolAppletData * gptad,
                     gboolean property_page)
{
  GPlextorToolData * gptd;

#ifdef CALL_TRACE
  flushed_output_0 (gptad->out_file_ptr, "Trace: device_changed\n");
#endif
 
  gptd = find_gptd_with_device_name (gptad, gptad->old_device_selection);

  if (gptd)
  {
    /* block before updating */
    gtk_signal_handler_block (GTK_OBJECT
                              (GTK_COMBO(gptad->speed_selection_combo)
                               ->entry), gptad->speed_sel_signal_id);
    gtk_combo_set_popdown_strings (GTK_COMBO(gptad->speed_selection_combo),
                                   gptd->avail_speeds);
    g_free (gptad->old_speed_selection);
    gptad->old_speed_selection = g_strdup (return_speed_string
                                           (gptd->ptd.act_speed,
                                            gptd->ptd.model,
                                            gptd->ptd.mmc_drive));
    g_free (gptad->old_spindown_selection);
    gptad->old_spindown_selection = g_strdup (g_list_nth_data 
                                              (gptd->avail_spindowns,
                                               gptd->ptd.act_spindown));
    gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(gptad->speed_selection_combo)
                                  ->entry),
                        gptad->old_speed_selection);
    /* updating finished => unblock */
    gtk_signal_handler_unblock (GTK_OBJECT
                                (GTK_COMBO(gptad->speed_selection_combo)
                                 ->entry), gptad->speed_sel_signal_id);
    if (gptad->prop_active)
    {
      /* change the second combo box showing the device */
      if (property_page)
      {
        gtk_signal_handler_block (GTK_OBJECT
                                  (GTK_COMBO(gptad->device_selection_combo)
                                   ->entry), gptad->dev_sel_signal_id);
        gtk_entry_set_text (GTK_ENTRY
                            (GTK_COMBO(gptad->device_selection_combo)
                             ->entry), gptad->old_device_selection);
        gtk_signal_handler_unblock (GTK_OBJECT
                                    (GTK_COMBO
                                     (gptad->device_selection_combo)->entry),
                                    gptad->dev_sel_signal_id);
      }
      else
      {
        gtk_signal_handler_block (GTK_OBJECT
                                  (GTK_COMBO(gptad->prop_dev_selection_combo)
                                   ->entry), gptad->prop_dev_sel_signal_id);
        gtk_entry_set_text(GTK_ENTRY
                           (GTK_COMBO(gptad->prop_dev_selection_combo)
                            ->entry), gptad->old_device_selection);
        gtk_signal_handler_unblock (GTK_OBJECT
                                    (GTK_COMBO
                                     (gptad->prop_dev_selection_combo)->entry),
                                    gptad->prop_dev_sel_signal_id);
      }

      /* also adjust the speed and spindown combo boxes */
      gtk_signal_handler_block (GTK_OBJECT
                                (GTK_COMBO(gptad->prop_speed_selection_combo)
                                 ->entry), gptad->prop_speed_sel_signal_id);
      gtk_combo_set_popdown_strings (GTK_COMBO
                                     (gptad->prop_speed_selection_combo),
                                     gptd->avail_speeds);
      gtk_entry_set_text (GTK_ENTRY
                          (GTK_COMBO(gptad->prop_speed_selection_combo)
                           ->entry), gptad->old_speed_selection);
      gtk_signal_handler_unblock (GTK_OBJECT
                                  (GTK_COMBO
                                   (gptad->prop_speed_selection_combo)->entry),
                                  gptad->prop_speed_sel_signal_id);
      gtk_signal_handler_block (GTK_OBJECT
                                (GTK_COMBO(gptad->prop_avail_spindowns_combo)
                                 ->entry),
                                gptad->prop_avail_spindwn_signal_id);
      gtk_combo_set_popdown_strings (GTK_COMBO
                                     (gptad->prop_avail_spindowns_combo),
                                     gptd->avail_spindowns);
      gtk_entry_set_text (GTK_ENTRY
                          (GTK_COMBO(gptad->prop_avail_spindowns_combo)
                           ->entry), gptad->old_spindown_selection);
      gtk_signal_handler_unblock (GTK_OBJECT
                                  (GTK_COMBO
                                   (gptad->prop_avail_spindowns_combo)->entry),
                                  gptad->prop_avail_spindwn_signal_id);
      adjust_prop_toggles (gptad, gptd);
      adjust_prop_volume (gptad, gptd);
    }
  }
  else
  {
    gnome_error_dialog (_("Internal Error: Could Not Find The Device"));
  }
}

void speed_changed (GPlextorToolAppletData * gptad,
                    gboolean property_page)
{
  GPlextorToolData * gptd;

#ifdef CALL_TRACE
  flushed_output_0 (gptad->out_file_ptr, "Trace: speed_changed\n");
#endif
 
  gptd = find_gptd_with_device_name (gptad, gptad->old_device_selection);

  if (gptd)
  {
    change_speed_of_device (gptad->old_speed_selection, gptd);
    if (gptad->prop_active)
    {
      /* change the second combo box showing the speed */
      if (property_page)
      {
        gtk_signal_handler_block (GTK_OBJECT
                                  (GTK_COMBO(gptad->speed_selection_combo)
                                   ->entry), gptad->speed_sel_signal_id);
        gtk_entry_set_text (GTK_ENTRY
                            (GTK_COMBO(gptad->speed_selection_combo)
                             ->entry), gptad->old_speed_selection);
        gtk_signal_handler_unblock (GTK_OBJECT
                                    (GTK_COMBO
                                     (gptad->speed_selection_combo)->entry),
                                    gptad->speed_sel_signal_id);
      }
      else
      {
        gtk_signal_handler_block (GTK_OBJECT
                                  (GTK_COMBO(gptad->prop_speed_selection_combo)
                                   ->entry), gptad->prop_speed_sel_signal_id);
        gtk_entry_set_text(GTK_ENTRY
                           (GTK_COMBO(gptad->prop_speed_selection_combo)
                            ->entry), gptad->old_speed_selection);
        gtk_signal_handler_unblock (GTK_OBJECT
                                    (GTK_COMBO
                                     (gptad->prop_speed_selection_combo)
                                     ->entry),
                                    gptad->prop_speed_sel_signal_id);
      }
    }
  }
  else
  {
    gnome_error_dialog (_("Internal Error: Could Not Find The Device"));
  }
}

void spindown_changed (GPlextorToolAppletData * gptad)
{
  GPlextorToolData * gptd;

#ifdef CALL_TRACE
  flushed_output_0 (gptad->out_file_ptr, "Trace: spindown_changed\n");
#endif
 
  gptd = find_gptd_with_device_name (gptad, gptad->old_device_selection);

  if (gptd)
  {
    change_spindown_of_device (gptad->old_spindown_selection, gptd);
  }
  else
  {
    gnome_error_dialog (_("Internal Error: Could Not Find The Device"));
  }
}

void adjust_prop_toggles (GPlextorToolAppletData * gptad,
                          GPlextorToolData * gptd)
{
  /* adjust the toggle buttons */
  gtk_signal_handler_block (GTK_OBJECT
                            (GTK_TOGGLE_BUTTON(gptad->nsd_toggle)),
                            gptad->prop_nsd_toggle_signal_id);
  gtk_signal_handler_block (GTK_OBJECT
                            (GTK_TOGGLE_BUTTON(gptad->avoid_vib_toggle)),
                            gptad->prop_avoid_vib_toggle_signal_id);
  gtk_signal_handler_block (GTK_OBJECT
                            (GTK_TOGGLE_BUTTON(gptad->waiting_toggle)),
                            gptad->prop_waiting_toggle_signal_id);
  if (!gptd->ptd.mmc_drive)
  { /* case plextor drive */
    if (gptd->ptd.model > PLEX_12)
    { /* all settings available */
      gtk_widget_set_sensitive (gptad->nsd_toggle, TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(gptad->nsd_toggle),
                                    gptd->ptd.act_speed_mode);
      gtk_widget_set_sensitive (gptad->avoid_vib_toggle, TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(gptad->avoid_vib_toggle),
                                    gptd->ptd.act_avoid_vib_setting);
      gtk_widget_set_sensitive (gptad->waiting_toggle, TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(gptad->waiting_toggle),
                                    gptd->ptd.act_waiting_setting);
    }
    else
    { /* only speed setting available */
      gtk_widget_set_sensitive (gptad->nsd_toggle, TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(gptad->nsd_toggle),
                                    gptd->ptd.act_speed_mode);
      gtk_widget_set_sensitive (gptad->avoid_vib_toggle, FALSE);
      gtk_widget_set_sensitive (gptad->waiting_toggle, FALSE);
    }
  }
  else
  { /* only mmc drive, no settings! */
    gtk_widget_set_sensitive (gptad->nsd_toggle, FALSE);
    gtk_widget_set_sensitive (gptad->avoid_vib_toggle, FALSE);
    gtk_widget_set_sensitive (gptad->waiting_toggle, FALSE);
  }
  gtk_signal_handler_unblock (GTK_OBJECT
                              (GTK_TOGGLE_BUTTON(gptad->nsd_toggle)),
                              gptad->prop_nsd_toggle_signal_id);
  gtk_signal_handler_unblock (GTK_OBJECT
                              (GTK_TOGGLE_BUTTON(gptad->avoid_vib_toggle)),
                              gptad->prop_avoid_vib_toggle_signal_id);
  gtk_signal_handler_unblock (GTK_OBJECT
                              (GTK_TOGGLE_BUTTON(gptad->waiting_toggle)),
                              gptad->prop_waiting_toggle_signal_id);
}

void adjust_prop_volume (GPlextorToolAppletData * gptad,
			 GPlextorToolData * gptd)
{
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(gptad->lock_volume),
				gptd->act_lock_volume);
  GTK_ADJUSTMENT(gptad->left_volume)->value = -gptd->ptd.act_left_volume;
  gtk_signal_emit_by_name (GTK_OBJECT(gptad->left_volume),
			   "value_changed");
  GTK_ADJUSTMENT(gptad->right_volume)->value = -gptd->ptd.act_right_volume;
  gtk_signal_emit_by_name (GTK_OBJECT(gptad->right_volume),
			   "value_changed");
}

#if (defined CALL_TRACE) || (defined VERBOSE_OUTPUT)

void flushed_output_0 (FILE * output_ptr, const char * msg_ptr)
{
  if (verbose)
  {
    fprintf (output_ptr, msg_ptr);
    fflush (output_ptr);
  }
}

void flushed_output_1_int (FILE * output_ptr, const char * msg_ptr,
                           const int arg1)
{
  if (verbose)
  {
    fprintf (output_ptr, msg_ptr, arg1);
    fflush (output_ptr);
  }
}

void flushed_output_2_int (FILE * output_ptr, const char * msg_ptr,
                           const int arg1, const int arg2)
{
  if (verbose)
  {
    fprintf (output_ptr, msg_ptr, arg2, arg2);
    fflush (output_ptr);
  }
}

void flushed_output_1_string (FILE * output_ptr, const char * msg_ptr,
                              const char * arg1)
{
  if (verbose)
  {
    fprintf (output_ptr, msg_ptr, arg1);
    fflush (output_ptr);
  }
}

void flushed_output_2_string (FILE * output_ptr, const char * msg_ptr,
                              const char * arg1, const char * arg2)
{
  if (verbose)
  {
    fprintf (output_ptr, msg_ptr, arg1, arg2);
    fflush (output_ptr);
  }
}

#endif

/*============================================================================*
 *============================================================================*
 * EOF utility_functions.c
 *============================================================================*
 *============================================================================*
 */
