/*============================================================================*
 *============================================================================*
 * Component:           plextor-tool-applet
 * Filename:            session.h
 *                                                                             
 * Authors:             Georg Huettenegger
 *                                                                             
 * Date of Creation:    Fri Jul 30 16:04:57 1999
 *                                                                             
 * Last Modification:   Fri Jul 30 16:04:57 1999
 *                                                                             
 * Copyright:           Georg Huettenegger                                
 *                                                                             
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                             
 *============================================================================*
 *============================================================================*
 */

#ifndef ___SESSION_H
#define ___SESSION_H

#include "plextor-tool.h"
#include "gplextor-tool.h"

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Tries to find an old session. When found loads everything stored and in
 * case a stored device is still around the old settings are restored.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void plextor_tool_session_load (char * cfgpath,
                                GPlextorToolAppletData * gptad);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Saves all information about the devices (their current configuration).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
int plextor_tool_session_save (GtkWidget * w,
                               const char * cfgpath,
                               const char * globcfgpath,
                               gpointer data);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Searches for all currently available devices and retrieves the information
 * about the current configuration of each device (stored in the gptad
 * structure).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void plextor_tool_session_defaults (GPlextorToolAppletData * gptad);

#endif

/*============================================================================*
 *============================================================================*
 * EOF session.h
 *============================================================================*
 *============================================================================*
 */
