/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StopFilter
extends TokenFilter {
    private final CharArraySet stopWords;
    private boolean enablePositionIncrements = false;
    private TermAttribute termAtt;
    private PositionIncrementAttribute posIncrAtt;

    public StopFilter(boolean enablePositionIncrements, TokenStream input, Set<?> stopWords, boolean ignoreCase) {
        super(input);
        if (stopWords instanceof CharArraySet) {
            this.stopWords = (CharArraySet)stopWords;
        } else {
            this.stopWords = new CharArraySet(stopWords.size(), ignoreCase);
            this.stopWords.addAll(stopWords);
        }
        this.enablePositionIncrements = enablePositionIncrements;
        this.termAtt = this.addAttribute(TermAttribute.class);
        this.posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    }

    public StopFilter(boolean enablePositionIncrements, TokenStream in, Set<?> stopWords) {
        this(enablePositionIncrements, in, stopWords, false);
    }

    public static final Set<Object> makeStopSet(String ... stopWords) {
        return StopFilter.makeStopSet(stopWords, false);
    }

    public static final Set<Object> makeStopSet(List<?> stopWords) {
        return StopFilter.makeStopSet(stopWords, false);
    }

    public static final Set<Object> makeStopSet(String[] stopWords, boolean ignoreCase) {
        CharArraySet stopSet = new CharArraySet(stopWords.length, ignoreCase);
        stopSet.addAll(Arrays.asList(stopWords));
        return stopSet;
    }

    public static final Set<Object> makeStopSet(List<?> stopWords, boolean ignoreCase) {
        CharArraySet stopSet = new CharArraySet(stopWords.size(), ignoreCase);
        stopSet.addAll(stopWords);
        return stopSet;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        int skippedPositions = 0;
        while (this.input.incrementToken()) {
            if (!this.stopWords.contains(this.termAtt.termBuffer(), 0, this.termAtt.termLength())) {
                if (this.enablePositionIncrements) {
                    this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + skippedPositions);
                }
                return true;
            }
            skippedPositions += this.posIncrAtt.getPositionIncrement();
        }
        return false;
    }

    public static boolean getEnablePositionIncrementsVersionDefault(Version matchVersion) {
        return matchVersion.onOrAfter(Version.LUCENE_29);
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setEnablePositionIncrements(boolean enable) {
        this.enablePositionIncrements = enable;
    }
}

