/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the ExtendedInformationRestRequestComponent type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ExtendedInformationRestRequestComponent{}

// ExtendedInformationRestRequestComponent struct for ExtendedInformationRestRequestComponent
type ExtendedInformationRestRequestComponent struct {
	// Certificate Extension Object Identifier (OID)
	Name *string `json:"name,omitempty"`
	// OID value
	Value                *string `json:"value,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _ExtendedInformationRestRequestComponent ExtendedInformationRestRequestComponent

// NewExtendedInformationRestRequestComponent instantiates a new ExtendedInformationRestRequestComponent object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewExtendedInformationRestRequestComponent() *ExtendedInformationRestRequestComponent {
	this := ExtendedInformationRestRequestComponent{}
	return &this
}

// NewExtendedInformationRestRequestComponentWithDefaults instantiates a new ExtendedInformationRestRequestComponent object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewExtendedInformationRestRequestComponentWithDefaults() *ExtendedInformationRestRequestComponent {
	this := ExtendedInformationRestRequestComponent{}
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *ExtendedInformationRestRequestComponent) GetName() string {
	if o == nil || isNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ExtendedInformationRestRequestComponent) GetNameOk() (*string, bool) {
	if o == nil || isNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *ExtendedInformationRestRequestComponent) HasName() bool {
	if o != nil && !isNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *ExtendedInformationRestRequestComponent) SetName(v string) {
	o.Name = &v
}

// GetValue returns the Value field value if set, zero value otherwise.
func (o *ExtendedInformationRestRequestComponent) GetValue() string {
	if o == nil || isNil(o.Value) {
		var ret string
		return ret
	}
	return *o.Value
}

// GetValueOk returns a tuple with the Value field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ExtendedInformationRestRequestComponent) GetValueOk() (*string, bool) {
	if o == nil || isNil(o.Value) {
		return nil, false
	}
	return o.Value, true
}

// HasValue returns a boolean if a field has been set.
func (o *ExtendedInformationRestRequestComponent) HasValue() bool {
	if o != nil && !isNil(o.Value) {
		return true
	}

	return false
}

// SetValue gets a reference to the given string and assigns it to the Value field.
func (o *ExtendedInformationRestRequestComponent) SetValue(v string) {
	o.Value = &v
}

func (o ExtendedInformationRestRequestComponent) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ExtendedInformationRestRequestComponent) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !isNil(o.Value) {
		toSerialize["value"] = o.Value
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ExtendedInformationRestRequestComponent) UnmarshalJSON(bytes []byte) (err error) {
	varExtendedInformationRestRequestComponent := _ExtendedInformationRestRequestComponent{}

	if err = json.Unmarshal(bytes, &varExtendedInformationRestRequestComponent); err == nil {
		*o = ExtendedInformationRestRequestComponent(varExtendedInformationRestRequestComponent)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "value")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableExtendedInformationRestRequestComponent struct {
	value *ExtendedInformationRestRequestComponent
	isSet bool
}

func (v NullableExtendedInformationRestRequestComponent) Get() *ExtendedInformationRestRequestComponent {
	return v.value
}

func (v *NullableExtendedInformationRestRequestComponent) Set(val *ExtendedInformationRestRequestComponent) {
	v.value = val
	v.isSet = true
}

func (v NullableExtendedInformationRestRequestComponent) IsSet() bool {
	return v.isSet
}

func (v *NullableExtendedInformationRestRequestComponent) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableExtendedInformationRestRequestComponent(val *ExtendedInformationRestRequestComponent) *NullableExtendedInformationRestRequestComponent {
	return &NullableExtendedInformationRestRequestComponent{value: val, isSet: true}
}

func (v NullableExtendedInformationRestRequestComponent) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableExtendedInformationRestRequestComponent) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
