/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the CryptoTokenKeyGenerationRestRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CryptoTokenKeyGenerationRestRequest{}

// CryptoTokenKeyGenerationRestRequest struct for CryptoTokenKeyGenerationRestRequest
type CryptoTokenKeyGenerationRestRequest struct {
	// Key pair alias
	KeyPairAlias *string `json:"key_pair_alias,omitempty"`
	// Key algorithm
	KeyAlg *string `json:"key_alg,omitempty"`
	// Key specification
	KeySpec              *string `json:"key_spec,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CryptoTokenKeyGenerationRestRequest CryptoTokenKeyGenerationRestRequest

// NewCryptoTokenKeyGenerationRestRequest instantiates a new CryptoTokenKeyGenerationRestRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCryptoTokenKeyGenerationRestRequest() *CryptoTokenKeyGenerationRestRequest {
	this := CryptoTokenKeyGenerationRestRequest{}
	return &this
}

// NewCryptoTokenKeyGenerationRestRequestWithDefaults instantiates a new CryptoTokenKeyGenerationRestRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCryptoTokenKeyGenerationRestRequestWithDefaults() *CryptoTokenKeyGenerationRestRequest {
	this := CryptoTokenKeyGenerationRestRequest{}
	return &this
}

// GetKeyPairAlias returns the KeyPairAlias field value if set, zero value otherwise.
func (o *CryptoTokenKeyGenerationRestRequest) GetKeyPairAlias() string {
	if o == nil || isNil(o.KeyPairAlias) {
		var ret string
		return ret
	}
	return *o.KeyPairAlias
}

// GetKeyPairAliasOk returns a tuple with the KeyPairAlias field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CryptoTokenKeyGenerationRestRequest) GetKeyPairAliasOk() (*string, bool) {
	if o == nil || isNil(o.KeyPairAlias) {
		return nil, false
	}
	return o.KeyPairAlias, true
}

// HasKeyPairAlias returns a boolean if a field has been set.
func (o *CryptoTokenKeyGenerationRestRequest) HasKeyPairAlias() bool {
	if o != nil && !isNil(o.KeyPairAlias) {
		return true
	}

	return false
}

// SetKeyPairAlias gets a reference to the given string and assigns it to the KeyPairAlias field.
func (o *CryptoTokenKeyGenerationRestRequest) SetKeyPairAlias(v string) {
	o.KeyPairAlias = &v
}

// GetKeyAlg returns the KeyAlg field value if set, zero value otherwise.
func (o *CryptoTokenKeyGenerationRestRequest) GetKeyAlg() string {
	if o == nil || isNil(o.KeyAlg) {
		var ret string
		return ret
	}
	return *o.KeyAlg
}

// GetKeyAlgOk returns a tuple with the KeyAlg field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CryptoTokenKeyGenerationRestRequest) GetKeyAlgOk() (*string, bool) {
	if o == nil || isNil(o.KeyAlg) {
		return nil, false
	}
	return o.KeyAlg, true
}

// HasKeyAlg returns a boolean if a field has been set.
func (o *CryptoTokenKeyGenerationRestRequest) HasKeyAlg() bool {
	if o != nil && !isNil(o.KeyAlg) {
		return true
	}

	return false
}

// SetKeyAlg gets a reference to the given string and assigns it to the KeyAlg field.
func (o *CryptoTokenKeyGenerationRestRequest) SetKeyAlg(v string) {
	o.KeyAlg = &v
}

// GetKeySpec returns the KeySpec field value if set, zero value otherwise.
func (o *CryptoTokenKeyGenerationRestRequest) GetKeySpec() string {
	if o == nil || isNil(o.KeySpec) {
		var ret string
		return ret
	}
	return *o.KeySpec
}

// GetKeySpecOk returns a tuple with the KeySpec field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CryptoTokenKeyGenerationRestRequest) GetKeySpecOk() (*string, bool) {
	if o == nil || isNil(o.KeySpec) {
		return nil, false
	}
	return o.KeySpec, true
}

// HasKeySpec returns a boolean if a field has been set.
func (o *CryptoTokenKeyGenerationRestRequest) HasKeySpec() bool {
	if o != nil && !isNil(o.KeySpec) {
		return true
	}

	return false
}

// SetKeySpec gets a reference to the given string and assigns it to the KeySpec field.
func (o *CryptoTokenKeyGenerationRestRequest) SetKeySpec(v string) {
	o.KeySpec = &v
}

func (o CryptoTokenKeyGenerationRestRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CryptoTokenKeyGenerationRestRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.KeyPairAlias) {
		toSerialize["key_pair_alias"] = o.KeyPairAlias
	}
	if !isNil(o.KeyAlg) {
		toSerialize["key_alg"] = o.KeyAlg
	}
	if !isNil(o.KeySpec) {
		toSerialize["key_spec"] = o.KeySpec
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CryptoTokenKeyGenerationRestRequest) UnmarshalJSON(bytes []byte) (err error) {
	varCryptoTokenKeyGenerationRestRequest := _CryptoTokenKeyGenerationRestRequest{}

	if err = json.Unmarshal(bytes, &varCryptoTokenKeyGenerationRestRequest); err == nil {
		*o = CryptoTokenKeyGenerationRestRequest(varCryptoTokenKeyGenerationRestRequest)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "key_pair_alias")
		delete(additionalProperties, "key_alg")
		delete(additionalProperties, "key_spec")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCryptoTokenKeyGenerationRestRequest struct {
	value *CryptoTokenKeyGenerationRestRequest
	isSet bool
}

func (v NullableCryptoTokenKeyGenerationRestRequest) Get() *CryptoTokenKeyGenerationRestRequest {
	return v.value
}

func (v *NullableCryptoTokenKeyGenerationRestRequest) Set(val *CryptoTokenKeyGenerationRestRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableCryptoTokenKeyGenerationRestRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableCryptoTokenKeyGenerationRestRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCryptoTokenKeyGenerationRestRequest(val *CryptoTokenKeyGenerationRestRequest) *NullableCryptoTokenKeyGenerationRestRequest {
	return &NullableCryptoTokenKeyGenerationRestRequest{value: val, isSet: true}
}

func (v NullableCryptoTokenKeyGenerationRestRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCryptoTokenKeyGenerationRestRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
