# ctx_zap
`import "github.com/grpc-ecosystem/go-grpc-middleware/tags/zap"`

* [Overview](#pkg-overview)
* [Imported Packages](#pkg-imports)
* [Index](#pkg-index)

## <a name="pkg-overview">Overview</a>
`ctx_zap` is a ctxlogger that is backed by Zap

It accepts a user-configured `zap.Logger` that will be used for logging. The same `zap.Logger` will
be populated into the `context.Context` passed into gRPC handler code.

You can use `ctx_zap.Extract` to log into a request-scoped `zap.Logger` instance in your handler code.

As `ctx_zap.Extract` will iterate all tags on from `grpc_ctxtags` it is therefore expensive so it is advised that you
extract once at the start of the function from the context and reuse it for the remainder of the function (see examples).

Please see examples and tests for examples of use.

## <a name="pkg-imports">Imported Packages</a>

- [github.com/grpc-ecosystem/go-grpc-middleware/tags](./..)
- [go.uber.org/zap](https://godoc.org/go.uber.org/zap)
- [go.uber.org/zap/zapcore](https://godoc.org/go.uber.org/zap/zapcore)
- [golang.org/x/net/context](https://godoc.org/golang.org/x/net/context)

## <a name="pkg-index">Index</a>
* [func AddFields(ctx context.Context, fields ...zapcore.Field)](#AddFields)
* [func Extract(ctx context.Context) \*zap.Logger](#Extract)
* [func TagsToFields(ctx context.Context) []zapcore.Field](#TagsToFields)
* [func ToContext(ctx context.Context, logger \*zap.Logger) context.Context](#ToContext)

#### <a name="pkg-files">Package files</a>
[context.go](./context.go) [doc.go](./doc.go) 

## <a name="AddFields">func</a> [AddFields](./context.go#L23)
``` go
func AddFields(ctx context.Context, fields ...zapcore.Field)
```
AddFields adds zap fields to the logger.

## <a name="Extract">func</a> [Extract](./context.go#L35)
``` go
func Extract(ctx context.Context) *zap.Logger
```
Extract takes the call-scoped Logger from grpc_zap middleware.

It always returns a Logger that has all the grpc_ctxtags updated.

## <a name="TagsToFields">func</a> [TagsToFields](./context.go#L48)
``` go
func TagsToFields(ctx context.Context) []zapcore.Field
```
TagsToFields transforms the Tags on the supplied context into zap fields.

## <a name="ToContext">func</a> [ToContext](./context.go#L59)
``` go
func ToContext(ctx context.Context, logger *zap.Logger) context.Context
```
ToContext adds the zap.Logger to the context for extraction later.
Returning the new context that has been created.

- - -
Generated by [godoc2ghmd](https://github.com/GandalfUK/godoc2ghmd)