/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.misc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eso.util.misc.StatsProvider;
import org.eso.util.stream.Message;
import org.eso.util.stream.ProcessingTask;
import org.eso.util.stream.TerminatingTask;

public class StatsAccumulatorTask
extends ProcessingTask {
    static final Logger logger = Logger.getLogger(StatsAccumulatorTask.class);
    private static final String classLogName = "StatsAccumulatorTask";
    private final long creationTime = System.currentTimeMillis();
    private long totalSize = 0L;
    private int totalMessages = 0;
    private int totalElements = 0;
    LinkedList<HistoryElement> history = new LinkedList();
    private int historyDepth;
    private Date nextComputingTime;
    private int computingPeriod;
    private List<Integer> intervals;
    private Map<Integer, Float> maxThroughput = new HashMap<Integer, Float>();
    private String hostname = null;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    static final int MILLIS_DAY = 86400000;
    static final int MILLIS_HOUR = 3600000;
    static final int MILLIS_MIN = 60000;
    static final int MILLIS_SEC = 1000;
    static final int KILOBYTE = 1024;
    static final int MEGABYTE = 0x100000;
    static final int GIGABYTE = 0x40000000;
    static final long TERABYTE = 0x10000000000L;
    static final int MAX_HISTORY_DEPTH = 100000;

    public StatsAccumulatorTask(int computingPeriod, List<Integer> computingIntervals) throws NullPointerException {
        super(classLogName, 1, computingPeriod);
        this.init(computingPeriod, computingIntervals, 100000);
    }

    public StatsAccumulatorTask(int computingPeriod, List<Integer> computingIntervals, int historyDepth) throws NullPointerException {
        super(classLogName, 1, computingPeriod);
        this.init(computingPeriod, computingIntervals, historyDepth);
    }

    private void init(int computingPeriod, List<Integer> computingIntervals, int historyDepth) throws NullPointerException {
        String methodLogName = "StatsAccumulatorTask::init()";
        logger.trace("StatsAccumulatorTask::init()");
        if (computingPeriod <= 0) {
            throw new IllegalArgumentException("StatsAccumulatorTask::init() - computingPeriod must be greater than 0.");
        }
        if (historyDepth <= 0) {
            throw new IllegalArgumentException("StatsAccumulatorTask::init() - historyDepth must be greater than 0.");
        }
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e2) {
            logger.warn("StatsAccumulatorTask::init() - could not get hostname : " + e2.getMessage());
            this.hostname = "UnknownHost";
        }
        this.nextComputingTime = new Date();
        this.computingPeriod = computingPeriod;
        this.historyDepth = historyDepth;
        this.intervals = computingIntervals;
        for (int interval : this.intervals) {
            this.maxThroughput.put(interval, Float.valueOf(0.0f));
        }
    }

    @Override
    protected boolean canProcessMessage(Message message) {
        String methodLogName = "StatsAccumulatorTask::canProcessMessage()";
        logger.trace("StatsAccumulatorTask::canProcessMessage()");
        try {
            StatsProvider info = (StatsProvider)((Object)message);
            return info.canProvideStats();
        }
        catch (ClassCastException e2) {
            logger.warn("StatsAccumulatorTask::canProcessMessage() - Cannot convert message: " + e2.getMessage());
            return false;
        }
    }

    @Override
    protected void process(List<Message> msgList) {
        String methodLogName = "StatsAccumulatorTask::process()";
        logger.trace("StatsAccumulatorTask::process()");
        if (System.currentTimeMillis() >= this.nextComputingTime.getTime()) {
            this.computeOverallStats();
            if (this.intervals != null) {
                for (int n : this.intervals) {
                    this.computeRecentStats(n);
                }
            }
            this.nextComputingTime.setTime(System.currentTimeMillis() + (long)(this.computingPeriod * 1000));
            logger.debug("StatsAccumulatorTask::process() - next computing time: " + this.dateFormat.format(this.nextComputingTime) + ".");
        }
        for (StatsProvider statsProvider : msgList) {
            this.history.add(new HistoryElement(statsProvider.getStartTime(), statsProvider.getSize(), statsProvider.getNumElements()));
            if (this.history.size() > this.historyDepth) {
                this.history.removeFirst();
            }
            ++this.totalMessages;
            this.totalElements += statsProvider.getNumElements();
            this.totalSize += statsProvider.getSize();
        }
    }

    private void computeRecentStats(int seconds) {
        String methodLogName = "StatsAccumulatorTask::computeRecentStats()";
        logger.trace("StatsAccumulatorTask::computeRecentStats()");
        if (this.history.isEmpty()) {
            return;
        }
        long startingTime = System.currentTimeMillis() - (long)(seconds * 1000);
        if (startingTime < this.creationTime) {
            startingTime = this.creationTime;
        }
        long size = 0L;
        int msgCount = 0;
        int elCount = 0;
        HistoryElement[] historyArray = this.history.toArray(new HistoryElement[this.history.size()]);
        for (int i = historyArray.length - 1; i >= 0; --i) {
            HistoryElement el = historyArray[i];
            if (el.endTime <= startingTime) break;
            ++msgCount;
            if (el.startTime > startingTime) {
                size += el.size;
            } else {
                long partialSize = (long)((float)(el.endTime - startingTime) / (float)(el.endTime - el.startTime) * (float)el.size);
                logger.debug("Total size: " + el.size + ", actual size: " + partialSize);
                size += partialSize;
            }
            elCount += el.numElements;
        }
        String tag = "last ";
        tag = seconds == 86400 ? tag + "day stats" : (seconds == 3600 ? tag + "hr stats" : (seconds == 60 ? tag + "min stats" : (seconds == 1 ? tag + "sec stats" : (seconds % 86400 == 0 ? tag + seconds / 86400 + " days stats" : (seconds % 3600 == 0 ? tag + seconds / 3600 + " hrs stats" : (seconds % 60 == 0 ? tag + seconds / 60 + " mins stats" : tag + seconds + " secs stats"))))));
        float th = (float)size / 1024.0f / (float)seconds;
        if (th > this.maxThroughput.get(seconds).floatValue()) {
            this.maxThroughput.put(seconds, Float.valueOf(th));
        }
        logger.info(this.format(tag, null, msgCount, elCount, size, seconds, this.maxThroughput.get(seconds)));
    }

    private void computeOverallStats() {
        String methodLogName = "StatsAccumulatorTask::computeOverallStats()";
        logger.trace("StatsAccumulatorTask::computeOverallStats()");
        long uptime = System.currentTimeMillis() - this.creationTime;
        int nDays = (int)uptime / 86400000;
        int remainder = (int)uptime % 86400000;
        int nHours = remainder / 3600000;
        int nMinutes = (remainder %= 3600000) / 60000;
        int nSeconds = (remainder %= 60000) / 1000;
        DecimalFormat df = new DecimalFormat("00");
        String uptimeStr = "host " + this.hostname + ", up " + nDays + " days " + df.format(nHours) + ":" + df.format(nMinutes) + ":" + df.format(nSeconds);
        String info = this.format("overall stats", uptimeStr, this.totalMessages, this.totalElements, this.totalSize, uptime / 1000L, null);
        logger.info(info);
    }

    private String format(String tag, String custom, int messages, int elements, long size, long period, Float max) {
        DecimalFormat df = new DecimalFormat("0.###");
        String totalMessagesStr = messages + " msgs";
        String totalElementsStr = elements + " items";
        String totalSizeStr = size > 0x10000000000L ? "" + df.format((float)size / 1.0995116E12f) + " TB" : (size > 0x40000000L ? "" + df.format((float)size / 1.0737418E9f) + " GB" : (size > 0x100000L ? "" + df.format((float)size / 1048576.0f) + " MB" : "" + df.format((float)size / 1024.0f) + " KB"));
        String throughputStr = "" + df.format((float)size / 1024.0f / (float)period) + " KB/s";
        String infoStr = "[" + tag + "] ";
        if (custom != null) {
            infoStr = infoStr + custom + ", ";
        }
        infoStr = infoStr + totalMessagesStr + ", " + totalElementsStr + ", " + totalSizeStr + ", " + throughputStr;
        if (max != null) {
            infoStr = infoStr + ", max " + df.format(max) + " KB/s";
        }
        return infoStr;
    }

    public int getHistoryDepth() {
        return this.historyDepth;
    }

    public void setHistoryDepth(int historyDepth) {
        this.historyDepth = historyDepth;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Logger utilLogger = Logger.getLogger("org.eso.util");
        utilLogger.setLevel(Level.INFO);
        LinkedList<Integer> p = new LinkedList<Integer>();
        p.add(2);
        StatsAccumulatorTask task = new StatsAccumulatorTask(1, p);
        task.setNextTask(new TerminatingTask());
        task.open();
        for (int i = 0; i < 2000; ++i) {
            class TestMessage
            extends Message
            implements StatsProvider {
                long creationTime = System.currentTimeMillis() - 500L;
                final long size;
                final int numElements;

                public TestMessage(int numElements, long size) {
                    super(6);
                    this.numElements = numElements;
                    this.size = size;
                }

                @Override
                public boolean canProvideStats() {
                    return true;
                }

                @Override
                public int getNumElements() {
                    return this.numElements;
                }

                @Override
                public long getSize() {
                    return this.size;
                }

                @Override
                public long getStartTime() {
                    return this.creationTime;
                }
            }
            TestMessage msg = new TestMessage(1, 100L);
            task.put(msg);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
    }

    private class HistoryElement {
        final long startTime;
        final long endTime;
        final long size;
        final int numElements;

        public HistoryElement(long startTime, long size) {
            this.startTime = startTime;
            this.endTime = System.currentTimeMillis();
            this.size = size;
            this.numElements = 1;
        }

        public HistoryElement(long startTime, long size, int numElements) {
            this.startTime = startTime;
            this.endTime = System.currentTimeMillis();
            this.size = size;
            this.numElements = numElements;
        }
    }
}

