/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.datatransfer;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eso.util.datatransfer.StatsInfo;
import org.eso.util.stream.Message;
import org.eso.util.stream.ProcessingTask;
import org.eso.util.stream.TerminatingTask;

public class StatsKeeperTask
extends ProcessingTask {
    static final Logger logger = Logger.getLogger(StatsKeeperTask.class);
    private static final String classLogName = "StatsKeeperTask";
    private final long creationTime = System.currentTimeMillis();
    private long totSize = 0L;
    private int totMessages = 0;
    private int totRequests = 0;
    LinkedList<HistoryElement> history = new LinkedList();
    private final int historyDepth;
    private final Date nextComputingTime;
    private final int computingInterval;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    static final int MILLIS_DAY = 86400000;
    static final int MILLIS_HOUR = 3600000;
    static final int MILLIS_MIN = 60000;
    static final int MILLIS_SEC = 1000;
    static final int KILOBYTE = 1024;
    static final int MEGABYTE = 0x100000;
    static final int GIGABYTE = 0x40000000;
    static final long TERABYTE = 0x10000000000L;

    public StatsKeeperTask(int computingInterval, int historyDepth) throws NullPointerException {
        super(classLogName, 1, computingInterval);
        String methodLogName = "StatsKeeperTask::StatsKeeperTask()";
        logger.trace("StatsKeeperTask::StatsKeeperTask()");
        this.nextComputingTime = new Date();
        this.computingInterval = computingInterval;
        this.historyDepth = historyDepth;
    }

    @Override
    protected boolean canProcessMessage(Message message) {
        String methodLogName = "StatsKeeperTask::canProcessMessage()";
        logger.trace("StatsKeeperTask::canProcessMessage()");
        StatsInfo info = (StatsInfo)((Object)message);
        return info.canProcessInfo();
    }

    @Override
    protected void process(List<Message> msgList) {
        String methodLogName = "StatsKeeperTask::process()";
        logger.trace("StatsKeeperTask::process()");
        if (System.currentTimeMillis() >= this.nextComputingTime.getTime()) {
            this.computeStats();
            this.computeRunningStats();
            this.nextComputingTime.setTime(System.currentTimeMillis() + (long)(this.computingInterval * 1000));
            logger.debug("StatsKeeperTask::process() - next computing time: " + this.dateFormat.format(this.nextComputingTime) + ".");
        }
        for (StatsInfo statsInfo : msgList) {
            this.history.add(new HistoryElement(statsInfo.getStartTime(), statsInfo.getSize(), statsInfo.getNumRequests()));
            if (this.history.size() > this.historyDepth) {
                this.history.removeFirst();
            }
            ++this.totMessages;
            this.totRequests += statsInfo.getNumRequests();
            this.totSize += statsInfo.getSize();
        }
    }

    private void computeRunningStats() {
        String methodLogName = "StatsKeeperTask::computeRunningStats()";
        logger.trace("StatsKeeperTask::computeRunningStats()");
        if (this.history.isEmpty()) {
            return;
        }
        long size = 0L;
        for (HistoryElement element : this.history) {
            size += element.size;
        }
        String messagesStr = "" + this.history.size() + " msgs";
        String throughputStr = "" + (float)size / 1024.0f / (float)(this.history.getLast().endTime - this.history.getFirst().startTime) * 1000.0f + " KB/s";
        String infoStr = "[running stats] " + messagesStr + ", " + throughputStr;
        logger.info(infoStr);
    }

    private void computeStats() {
        String methodLogName = "StatsKeeperTask::computeStats()";
        logger.trace("StatsKeeperTask::computeStats()");
        long uptime = System.currentTimeMillis() - this.creationTime;
        int nDays = (int)uptime / 86400000;
        int remainder = (int)uptime % 86400000;
        int nHours = remainder / 3600000;
        int nMinutes = (remainder %= 3600000) / 60000;
        int nSeconds = (remainder %= 60000) / 1000;
        DecimalFormat df = new DecimalFormat("00");
        String uptimeStr = "up " + nDays + " days " + df.format(nHours) + ":" + df.format(nMinutes) + ":" + df.format(nSeconds);
        String totMessagesStr = this.totMessages + " msgs";
        String totRequestsStr = this.totRequests + " reqs";
        String totSizeStr = this.totSize > 0x10000000000L ? "" + (float)this.totSize / 1.0995116E12f + " TB" : (this.totSize > 0x40000000L ? "" + (float)this.totSize / 1.0737418E9f + " GB" : (this.totSize > 0x100000L ? "" + (float)this.totSize / 1048576.0f + " MB" : "" + (float)this.totSize / 1024.0f + " KB"));
        String throughputStr = "" + (float)this.totSize / 1024.0f / (float)uptime * 1000.0f + " KB/s";
        String infoStr = "[overall stats] " + uptimeStr + ", " + totMessagesStr + ", " + totRequestsStr + ", " + totSizeStr + ", " + throughputStr;
        logger.info(infoStr);
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Logger utilLogger = Logger.getLogger("org.eso.util");
        utilLogger.setLevel(Level.INFO);
        StatsKeeperTask task = new StatsKeeperTask(1, 100);
        task.setNextTask(new TerminatingTask());
        task.open();
        for (int i = 0; i < 1000; ++i) {
            class TestMessage
            extends Message
            implements StatsInfo {
                long creationTime = System.currentTimeMillis();
                final long size;
                final int numRequests;

                public TestMessage(int numRequests, long size) {
                    super(6);
                    this.numRequests = numRequests;
                    this.size = size;
                }

                @Override
                public boolean canProcessInfo() {
                    return true;
                }

                @Override
                public int getNumRequests() {
                    return this.numRequests;
                }

                @Override
                public long getSize() {
                    return this.size;
                }

                @Override
                public long getStartTime() {
                    return this.creationTime;
                }
            }
            TestMessage msg = new TestMessage(i, 100 * i * i);
            task.put(msg);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
    }

    private class HistoryElement {
        final long startTime;
        final long endTime;
        final long size;
        final int numRequests;

        public HistoryElement(long startTime, long size) {
            this.startTime = startTime;
            this.endTime = System.currentTimeMillis();
            this.size = size;
            this.numRequests = 1;
        }

        public HistoryElement(long startTime, long size, int numRequests) {
            this.startTime = startTime;
            this.endTime = System.currentTimeMillis();
            this.size = size;
            this.numRequests = numRequests;
        }
    }
}

