/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.PackageReport;
import org.eso.util.dal.PackageReportsDAO;
import org.eso.util.dal.SybaseConnectionService;

public class PackageReportsDAOSyb
implements PackageReportsDAO {
    static final Logger logger = Logger.getLogger(PackageReportsDAOSyb.class);
    private static final String classLogName = "PackageReportsDAOSyb";
    public static final String PACKAGEID_KW = "pkg_id";
    public static final String FILEURL_KW = "file_url";
    public static final String REPORT_KW = "report";
    private Connection d_connection = null;
    private String d_dbTable = null;

    public PackageReportsDAOSyb(Connection conn, String dbTable) throws DAOException {
        this.d_connection = conn;
        this.d_dbTable = dbTable;
    }

    @Override
    public void delete(PackageReport report) throws DAOException {
        String query = "DELETE FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + "=" + report.getPackageId();
        query = query + " AND file_url='" + report.getFileUrl() + "'";
        try {
            SybaseConnectionService.executeStatement(this.d_connection, query);
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public void delete(List<PackageReport> reports) throws DAOException {
        for (PackageReport report : reports) {
            this.delete(report);
        }
    }

    @Override
    public PackageReport find(Integer pkgId, String url) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + "=" + pkgId;
        query = query + " AND file_url='" + url + "'";
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            PackageReport report = null;
            if (rs.next()) {
                report = new PackageReport();
                report.setPackageId(rs.getInt(PACKAGEID_KW));
                report.setFileUrl(rs.getString(FILEURL_KW));
                report.setReport(PackageReportsDAOSyb.readAll(rs.getBinaryStream(REPORT_KW)));
            }
            return report;
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (SQLException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (IOException e4) {
            throw new DAOException(e4.getMessage());
        }
    }

    @Override
    public void insert(PackageReport report) throws DAOException {
        String columns = "(pkg_id,file_url,report)";
        String values = "(" + report.getPackageId() + ",'" + report.getFileUrl() + "', ? )";
        String query = "INSERT INTO " + this.d_dbTable + " " + columns + " VALUES " + values;
        try {
            PreparedStatement stmt = this.d_connection.prepareStatement(query);
            ByteArrayInputStream binaryStream = new ByteArrayInputStream(report.getReport());
            stmt.setBinaryStream(1, (InputStream)binaryStream, report.getReport().length);
            stmt.execute();
            ((InputStream)binaryStream).close();
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (FileNotFoundException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (IOException e4) {
            throw new DAOException(e4.getMessage());
        }
    }

    @Override
    public void insertOrUpdate(PackageReport report) throws DAOException {
        if (this.find(report.getPackageId(), report.getFileUrl()) == null) {
            this.insert(report);
        } else {
            this.update(report);
        }
    }

    @Override
    public void update(PackageReport report) throws DAOException {
        String query = "UPDATE " + this.d_dbTable + " SET " + REPORT_KW + " = ? WHERE ";
        query = query + "pkg_id=" + report.getPackageId() + " AND " + FILEURL_KW + "='" + report.getFileUrl() + "'";
        try {
            PreparedStatement stmt = this.d_connection.prepareStatement(query);
            ByteArrayInputStream binaryStream = new ByteArrayInputStream(report.getReport());
            stmt.setBinaryStream(1, (InputStream)binaryStream, report.getReport().length);
            stmt.execute();
            ((InputStream)binaryStream).close();
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (FileNotFoundException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (IOException e4) {
            throw new DAOException(e4.getMessage());
        }
    }

    @Override
    public List<PackageReport> find(Integer pkgId) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + "=" + pkgId;
        ArrayList<PackageReport> result = new ArrayList<PackageReport>();
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            while (rs.next()) {
                PackageReport report = new PackageReport();
                report.setPackageId(rs.getInt(PACKAGEID_KW));
                report.setFileUrl(rs.getString(FILEURL_KW));
                report.setReport(PackageReportsDAOSyb.readAll(rs.getBinaryStream(REPORT_KW)));
                result.add(report);
            }
            return result;
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (SQLException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (IOException e4) {
            throw new DAOException(e4.getMessage());
        }
    }

    public static byte[] readAll(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) >= 0) {
            bout.write(buffer, 0, len);
        }
        return bout.toByteArray();
    }
}

