/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.PackageInfo;
import org.eso.util.dal.PackageInfoDAO;
import org.eso.util.dal.SybaseConnectionService;

public class PackageInfoDAOSyb
implements PackageInfoDAO {
    static final Logger logger = Logger.getLogger(PackageInfoDAOSyb.class);
    private static final String classLogName = "PackageInfoDAOSyb";
    public static final String PACKAGEID_KW = "pkg_id";
    public static final String RUNID_KW = "run_id";
    public static final String INSTRUMENT_KW = "instrume";
    public static final String ASSOCIATIONDATA_KW = "assoc_data";
    public static final String STATUS_KW = "pkg_status";
    private Connection d_connection = null;
    private String d_dbTable = null;
    private String d_idGenProcedure = null;

    public PackageInfoDAOSyb(Connection conn, String dbTable, String idGenProcedure) {
        this.d_connection = conn;
        this.d_dbTable = dbTable;
        this.d_idGenProcedure = idGenProcedure;
    }

    @Override
    public Integer getPackageId(String runId, String instrument) throws DAOException {
        PackageInfo info = this.find(runId, instrument);
        if (info != null) {
            return info.getPackageId();
        }
        try {
            CallableStatement cstmt = null;
            this.d_connection.setAutoCommit(true);
            cstmt = this.d_connection.prepareCall("{ call " + this.d_idGenProcedure + "(?,?)}");
            cstmt.setString(1, "PI_PACK");
            cstmt.registerOutParameter(2, 4);
            cstmt.execute();
            return cstmt.getInt(2);
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public void delete(PackageInfo pkg) throws DAOException {
        String query = "DELETE FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + " = " + pkg.getPackageId();
        try {
            SybaseConnectionService.executeStatement(this.d_connection, query);
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public PackageInfo find(String run_id, String instrument) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE " + RUNID_KW + " = '" + run_id + "' AND " + INSTRUMENT_KW + " = '" + instrument + "'";
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            if (rs.next()) {
                PackageInfo result = new PackageInfo();
                result.setPackageId(rs.getInt(PACKAGEID_KW));
                result.setRunId(rs.getString(RUNID_KW));
                result.setInstrument(rs.getString(INSTRUMENT_KW));
                result.setAssocData(rs.getString(ASSOCIATIONDATA_KW));
                result.setStatus(PackageInfo.Status.valueOf(rs.getString(STATUS_KW)));
                return result;
            }
            return null;
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
    }

    @Override
    public void insert(PackageInfo pkg) throws DAOException {
        String columns = "(";
        String values = "(";
        columns = columns + "pkg_id,run_id,instrume,pkg_status";
        if (pkg.getAssocData() != null) {
            columns = columns + ",assoc_data";
        }
        columns = columns + ")";
        values = values + pkg.getPackageId() + ",'" + pkg.getRunId() + "','" + pkg.getInstrument() + "','" + pkg.getStatus().toString() + "'";
        if (pkg.getAssocData() != null) {
            values = values + ",'" + pkg.getAssocData() + "'";
        }
        values = values + ")";
        String query = "INSERT INTO " + this.d_dbTable + " " + columns + " VALUES " + values;
        try {
            SybaseConnectionService.executeStatement(this.d_connection, query);
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public void insertIfNotFound(PackageInfo pkg) throws DAOException {
        if (this.find(pkg.getRunId(), pkg.getInstrument()) != null) {
            logger.info("Package information already in the database");
        } else {
            logger.info("Ingesting package information");
            this.insert(pkg);
        }
    }
}

